public class MeineFehlerfunktion2 implements Fehlerfunktion
{
    private PApplet pap;
    private Integrator integrator;
    private FahrzeugModell2     modell;

    private Graycode graycode;

    double[] y;
    double[] y0;
    double[] y_alt;
  
    public MeineFehlerfunktion2(PApplet pap,Integrator integrator,FahrzeugModell2     modell)
    {
        this.pap = pap;
        graycode = new Graycode(pap);      
        
        this.integrator = integrator;
        this.modell = modell;
    }

    
  
    public double berechne(Gen gen)
    {
        graycode.gray2doublearr(PID,gen.arr,new double[] {0.0,0.0,0.0},new  double[] {10.0,10.0,10.0});      
      
        y = new double[modell.getGleichungsanzahl()];
        y0 = new double[] {0.0,0.9,HALF_PI,0.0,0.0}; //x, y, beta
        y[0] = y0[0];
        y[1] = y0[1];
        y[2] = y0[2];
        y[3] = y0[3]; //Aufintegrieren von sensorwert (Regeldifferenz)
        y[4] = y0[4]; //Aufintegrieren der Servo-Lenkwinkelgeschw.
        y_alt = new double[modell.getGleichungsanzahl()];

        int MAXSCHRITTE = 200;

        double fehler = 0.0;
        t=0.0;
//println("??? "+PID[0]+" "+PID[1]+" "+PID[2]);        
        for(int i=0;i<MAXSCHRITTE;i++)
        {
            fehler += Math.abs(RADIUSPARCOURS - Math.sqrt(y[0]*y[0]+y[1]*y[1]));

            for(int ii=0;ii<y.length;ii++)
                y_alt[ii] = y[ii];
          
            integrator.zeitschritt(y,y_alt,t,dt); //Ergebnis wird in y gelegt

            modell.sensorwert_alt = modell.sensorwert;    
            t+=dt;             
        }

        return fehler;
    }
  
    public double berechneUndZeige(Gen gen)
    {
        return 0.0;      
    }
    
}
