/*
 * Decompiled with CFR 0.152.
 */
package javax.media.nativewindow;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.common.util.ReflectionUtil;
import com.jogamp.nativewindow.UpstreamWindowHookMutableSizePos;
import com.jogamp.nativewindow.awt.AWTGraphicsDevice;
import com.jogamp.nativewindow.awt.AWTGraphicsScreen;
import com.jogamp.nativewindow.macosx.MacOSXGraphicsDevice;
import com.jogamp.nativewindow.windows.WindowsGraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsScreen;
import java.io.File;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.nativewindow.AbstractGraphicsConfiguration;
import javax.media.nativewindow.AbstractGraphicsDevice;
import javax.media.nativewindow.AbstractGraphicsScreen;
import javax.media.nativewindow.Capabilities;
import javax.media.nativewindow.DefaultGraphicsConfiguration;
import javax.media.nativewindow.DefaultGraphicsScreen;
import javax.media.nativewindow.GraphicsConfigurationFactory;
import javax.media.nativewindow.NativeSurface;
import javax.media.nativewindow.NativeWindow;
import javax.media.nativewindow.NativeWindowException;
import javax.media.nativewindow.OffscreenLayerOption;
import javax.media.nativewindow.OffscreenLayerSurface;
import javax.media.nativewindow.ToolkitLock;
import javax.media.nativewindow.util.PointImmutable;
import jogamp.common.os.PlatformPropsImpl;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.NativeWindowFactoryImpl;
import jogamp.nativewindow.ResourceToolkitLock;
import jogamp.nativewindow.WrappedWindow;
import jogamp.nativewindow.macosx.OSXUtil;
import jogamp.nativewindow.windows.GDIUtil;
import jogamp.nativewindow.x11.X11Lib;

public abstract class NativeWindowFactory {
    protected static final boolean DEBUG;
    public static final String TYPE_EGL;
    public static final String TYPE_WINDOWS;
    public static final String TYPE_X11;
    public static final String TYPE_BCM_VC_IV;
    public static final String TYPE_ANDROID;
    public static final String TYPE_MACOSX;
    public static final String TYPE_AWT;
    public static final String TYPE_DEFAULT;
    private static final String nativeWindowingTypePure;
    private static final String nativeWindowingTypeCustom;
    private static NativeWindowFactory defaultFactory;
    private static Map<Class<?>, NativeWindowFactory> registeredFactories;
    private static Class<?> nativeWindowClass;
    private static boolean isAWTAvailable;
    private static final String JAWTUtilClassName = "jogamp.nativewindow.jawt.JAWTUtil";
    private static final String X11UtilClassName = "jogamp.nativewindow.x11.X11Util";
    private static final String OSXUtilClassName = "jogamp.nativewindow.macosx.OSXUtil";
    private static final String GDIClassName = "jogamp.nativewindow.windows.GDIUtil";
    private static ToolkitLock jawtUtilJAWTToolkitLock;
    private static boolean requiresToolkitLock;
    private static boolean desktopHasThreadingIssues;
    private static volatile boolean isJVMShuttingDown;
    private static final List<Runnable> customShutdownHooks;
    private static boolean initialized;

    protected NativeWindowFactory() {
    }

    private static final boolean guessBroadcomVCIV() {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){
            private final File vcliblocation = new File("/opt/vc/lib/libbcm_host.so");

            @Override
            public Boolean run() {
                if (this.vcliblocation.isFile()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        });
    }

    private static String _getNativeWindowingType() {
        switch (PlatformPropsImpl.OS_TYPE) {
            case ANDROID: {
                return TYPE_ANDROID;
            }
            case MACOS: {
                return TYPE_MACOSX;
            }
            case WINDOWS: {
                return TYPE_WINDOWS;
            }
            case OPENKODE: {
                return TYPE_EGL;
            }
        }
        if (NativeWindowFactory.guessBroadcomVCIV()) {
            return TYPE_BCM_VC_IV;
        }
        return TYPE_X11;
    }

    private static void initSingletonNativeImpl(ClassLoader classLoader) {
        String string = TYPE_X11 == nativeWindowingTypePure ? X11UtilClassName : (TYPE_WINDOWS == nativeWindowingTypePure ? GDIClassName : (TYPE_MACOSX == nativeWindowingTypePure ? OSXUtilClassName : null));
        if (null != string) {
            ReflectionUtil.callStaticMethod((String)string, (String)"initSingleton", null, null, (ClassLoader)classLoader);
            Boolean bl = (Boolean)ReflectionUtil.callStaticMethod((String)string, (String)"requiresToolkitLock", null, null, (ClassLoader)classLoader);
            requiresToolkitLock = bl;
            Boolean bl2 = (Boolean)ReflectionUtil.callStaticMethod((String)string, (String)"hasThreadingIssues", null, null, (ClassLoader)classLoader);
            desktopHasThreadingIssues = bl2;
        } else {
            requiresToolkitLock = false;
            desktopHasThreadingIssues = false;
        }
    }

    public static final boolean isJVMShuttingDown() {
        return isJVMShuttingDown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCustomShutdownHook(boolean bl, Runnable runnable) {
        List<Runnable> list = customShutdownHooks;
        synchronized (list) {
            if (!customShutdownHooks.contains(runnable)) {
                if (bl) {
                    customShutdownHooks.add(0, runnable);
                } else {
                    customShutdownHooks.add(runnable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void shutdown(boolean bl) {
        isJVMShuttingDown = bl;
        if (DEBUG) {
            System.err.println("NativeWindowFactory.shutdown() START: JVM Shutdown " + isJVMShuttingDown + ", on thread " + Thread.currentThread().getName());
        }
        List<Runnable> list = customShutdownHooks;
        synchronized (list) {
            int n = customShutdownHooks.size();
            for (int i = 0; i < n; ++i) {
                try {
                    if (DEBUG) {
                        System.err.println("NativeWindowFactory.shutdown - customShutdownHook #" + (i + 1) + "/" + n);
                    }
                    customShutdownHooks.get(i).run();
                    continue;
                }
                catch (Throwable throwable) {
                    System.err.println("NativeWindowFactory.shutdown: Caught " + throwable.getClass().getName() + " during customShutdownHook #" + (i + 1) + "/" + n);
                    if (!DEBUG) continue;
                    throwable.printStackTrace();
                }
            }
            customShutdownHooks.clear();
        }
        if (DEBUG) {
            System.err.println("NativeWindowFactory.shutdown(): Post customShutdownHook");
        }
        if (initialized) {
            initialized = false;
            if (null != registeredFactories) {
                registeredFactories.clear();
                registeredFactories = null;
            }
            GraphicsConfigurationFactory.shutdown();
        }
        NativeWindowFactory.shutdownNativeImpl(NativeWindowFactory.class.getClassLoader());
        if (DEBUG) {
            System.err.println(Thread.currentThread().getName() + " - NativeWindowFactory.shutdown() END JVM Shutdown " + isJVMShuttingDown);
        }
    }

    private static void shutdownNativeImpl(ClassLoader classLoader) {
        String string = TYPE_X11 == nativeWindowingTypePure ? X11UtilClassName : (TYPE_WINDOWS == nativeWindowingTypePure ? GDIClassName : (TYPE_MACOSX == nativeWindowingTypePure ? OSXUtilClassName : null));
        if (null != string) {
            ReflectionUtil.callStaticMethod((String)string, (String)"shutdown", null, null, (ClassLoader)classLoader);
        }
    }

    public static synchronized boolean isInitialized() {
        return initialized;
    }

    public static synchronized void initSingleton() {
        if (!initialized) {
            Object object;
            initialized = true;
            if (DEBUG) {
                System.err.println(Thread.currentThread().getName() + " - NativeWindowFactory.initSingleton()");
            }
            ClassLoader classLoader = NativeWindowFactory.class.getClassLoader();
            isAWTAvailable = false;
            if (Platform.AWT_AVAILABLE && ReflectionUtil.isClassAvailable((String)"com.jogamp.nativewindow.awt.AWTGraphicsDevice", (ClassLoader)classLoader) && null != (object = AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

                @Override
                public Method[] run() {
                    try {
                        Class<?> clazz = Class.forName(NativeWindowFactory.JAWTUtilClassName, true, NativeWindowFactory.class.getClassLoader());
                        Method method = clazz.getDeclaredMethod("isHeadlessMode", null);
                        method.setAccessible(true);
                        Method method2 = clazz.getDeclaredMethod("initSingleton", null);
                        method2.setAccessible(true);
                        Method method3 = clazz.getDeclaredMethod("getJAWTToolkitLock", new Class[0]);
                        method3.setAccessible(true);
                        return new Method[]{method2, method, method3};
                    }
                    catch (Exception exception) {
                        if (DEBUG) {
                            exception.printStackTrace();
                        }
                        return null;
                    }
                }
            }))) {
                Method method = object[0];
                Method method2 = object[1];
                Method method3 = object[2];
                ReflectionUtil.callMethod(null, (Method)method, (Object[])new Object[0]);
                Object object2 = ReflectionUtil.callMethod(null, (Method)method2, (Object[])new Object[0]);
                if (!(object2 instanceof Boolean)) {
                    throw new RuntimeException("JAWTUtil.isHeadlessMode() didn't return a Boolean");
                }
                isAWTAvailable = ((Boolean)object2).equals(Boolean.FALSE);
                object2 = ReflectionUtil.callMethod(null, (Method)method3, (Object[])new Object[0]);
                if (object2 instanceof ToolkitLock) {
                    jawtUtilJAWTToolkitLock = (ToolkitLock)object2;
                } else {
                    throw new RuntimeException("JAWTUtil.getJAWTToolkitLock() didn't return a ToolkitLock");
                }
            }
            NativeWindowFactory.initSingletonNativeImpl(classLoader);
            registeredFactories = Collections.synchronizedMap(new HashMap());
            object = new NativeWindowFactoryImpl();
            nativeWindowClass = NativeWindow.class;
            NativeWindowFactory.registerFactory(nativeWindowClass, (NativeWindowFactory)object);
            defaultFactory = object;
            if (isAWTAvailable) {
                NativeWindowFactory.registerFactory(ReflectionUtil.getClass((String)"java.awt.Component", (boolean)false, (ClassLoader)classLoader), (NativeWindowFactory)object);
            }
            if (DEBUG) {
                System.err.println("NativeWindowFactory requiresToolkitLock " + requiresToolkitLock + ", desktopHasThreadingIssues " + desktopHasThreadingIssues);
                System.err.println("NativeWindowFactory isAWTAvailable " + isAWTAvailable + ", defaultFactory " + object);
            }
            GraphicsConfigurationFactory.initSingleton();
        }
    }

    public static boolean requiresToolkitLock() {
        return requiresToolkitLock;
    }

    public static boolean isAWTAvailable() {
        return isAWTAvailable;
    }

    public static String getNativeWindowType(boolean bl) {
        return bl ? nativeWindowingTypeCustom : nativeWindowingTypePure;
    }

    public static void setDefaultFactory(NativeWindowFactory nativeWindowFactory) {
        defaultFactory = nativeWindowFactory;
    }

    public static NativeWindowFactory getDefaultFactory() {
        return defaultFactory;
    }

    public static ToolkitLock getAWTToolkitLock() {
        return jawtUtilJAWTToolkitLock;
    }

    public static ToolkitLock getNullToolkitLock() {
        return NativeWindowFactoryImpl.getNullToolkitLock();
    }

    public static ToolkitLock getDefaultToolkitLock() {
        return NativeWindowFactory.getDefaultToolkitLock(nativeWindowingTypePure);
    }

    public static ToolkitLock getDefaultToolkitLock(String string) {
        if (requiresToolkitLock) {
            if (TYPE_AWT == string && NativeWindowFactory.isAWTAvailable()) {
                return NativeWindowFactory.getAWTToolkitLock();
            }
            return ResourceToolkitLock.create();
        }
        return NativeWindowFactoryImpl.getNullToolkitLock();
    }

    public static ToolkitLock getDefaultToolkitLock(String string, long l) {
        if (requiresToolkitLock) {
            if (TYPE_AWT == string && NativeWindowFactory.isAWTAvailable()) {
                return NativeWindowFactory.getAWTToolkitLock();
            }
            return ResourceToolkitLock.create();
        }
        return NativeWindowFactoryImpl.getNullToolkitLock();
    }

    public static AbstractGraphicsScreen createScreen(AbstractGraphicsDevice abstractGraphicsDevice, int n) {
        String string = abstractGraphicsDevice.getType();
        if (TYPE_X11 == string) {
            X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)abstractGraphicsDevice;
            if (0 > n) {
                n = x11GraphicsDevice.getDefaultScreen();
            }
            return new X11GraphicsScreen(x11GraphicsDevice, n);
        }
        if (0 > n) {
            n = 0;
        }
        if (TYPE_AWT == string) {
            AWTGraphicsDevice aWTGraphicsDevice = (AWTGraphicsDevice)abstractGraphicsDevice;
            return new AWTGraphicsScreen(aWTGraphicsDevice);
        }
        return new DefaultGraphicsScreen(abstractGraphicsDevice, n);
    }

    public static NativeWindowFactory getFactory(Class<?> clazz) throws IllegalArgumentException {
        if (nativeWindowClass.isAssignableFrom(clazz)) {
            return registeredFactories.get(nativeWindowClass);
        }
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            NativeWindowFactory nativeWindowFactory = registeredFactories.get(clazz2);
            if (nativeWindowFactory == null) continue;
            return nativeWindowFactory;
        }
        throw new IllegalArgumentException("No registered NativeWindowFactory for class " + clazz.getName());
    }

    protected static void registerFactory(Class<?> clazz, NativeWindowFactory nativeWindowFactory) {
        if (DEBUG) {
            System.err.println("NativeWindowFactory.registerFactory() " + clazz + " -> " + nativeWindowFactory);
        }
        registeredFactories.put(clazz, nativeWindowFactory);
    }

    public static NativeWindow getNativeWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) throws IllegalArgumentException, NativeWindowException {
        if (object == null) {
            throw new IllegalArgumentException("Null window object");
        }
        return NativeWindowFactory.getFactory(object.getClass()).getNativeWindowImpl(object, abstractGraphicsConfiguration);
    }

    protected abstract NativeWindow getNativeWindowImpl(Object var1, AbstractGraphicsConfiguration var2) throws IllegalArgumentException;

    public static OffscreenLayerSurface getOffscreenLayerSurface(NativeSurface nativeSurface, boolean bl) {
        if (nativeSurface instanceof OffscreenLayerSurface && (!bl || nativeSurface instanceof OffscreenLayerOption)) {
            OffscreenLayerSurface offscreenLayerSurface = (OffscreenLayerSurface)((Object)nativeSurface);
            return !bl || ((OffscreenLayerOption)((Object)offscreenLayerSurface)).isOffscreenLayerSurfaceEnabled() ? offscreenLayerSurface : null;
        }
        if (nativeSurface instanceof NativeWindow) {
            for (NativeWindow nativeWindow = ((NativeWindow)nativeSurface).getParent(); null != nativeWindow; nativeWindow = nativeWindow.getParent()) {
                if (!(nativeWindow instanceof OffscreenLayerSurface) || bl && !(nativeWindow instanceof OffscreenLayerOption)) continue;
                OffscreenLayerSurface offscreenLayerSurface = (OffscreenLayerSurface)((Object)nativeWindow);
                return !bl || ((OffscreenLayerOption)((Object)offscreenLayerSurface)).isOffscreenLayerSurfaceEnabled() ? offscreenLayerSurface : null;
            }
        }
        return null;
    }

    public static boolean isNativeVisualIDValidForProcessing(int n) {
        return TYPE_X11 != NativeWindowFactory.getNativeWindowType(false) || 0 != n;
    }

    public static AbstractGraphicsDevice createDevice(String string, boolean bl) {
        String string2 = NativeWindowFactory.getNativeWindowType(true);
        if (TYPE_X11 == string2) {
            if (bl) {
                return new X11GraphicsDevice(string, 0, null);
            }
            return new X11GraphicsDevice(string, 0);
        }
        if (TYPE_WINDOWS == string2) {
            return new WindowsGraphicsDevice("decon", 0);
        }
        if (TYPE_MACOSX == string2) {
            return new MacOSXGraphicsDevice(0);
        }
        throw new UnsupportedOperationException("n/a for windowing system: " + string2);
    }

    public static NativeWindow createWrappedWindow(AbstractGraphicsScreen abstractGraphicsScreen, long l, long l2, UpstreamWindowHookMutableSizePos upstreamWindowHookMutableSizePos) {
        Capabilities capabilities = new Capabilities();
        DefaultGraphicsConfiguration defaultGraphicsConfiguration = new DefaultGraphicsConfiguration(abstractGraphicsScreen, capabilities, capabilities);
        return new WrappedWindow((AbstractGraphicsConfiguration)defaultGraphicsConfiguration, l, upstreamWindowHookMutableSizePos, true, l2);
    }

    public static PointImmutable getLocationOnScreen(NativeWindow nativeWindow) {
        String string = NativeWindowFactory.getNativeWindowType(true);
        if (TYPE_X11 == string) {
            return X11Lib.GetRelativeLocation(nativeWindow.getDisplayHandle(), nativeWindow.getScreenIndex(), nativeWindow.getWindowHandle(), 0L, 0, 0);
        }
        if (TYPE_WINDOWS == string) {
            return GDIUtil.GetRelativeLocation(nativeWindow.getWindowHandle(), 0L, 0, 0);
        }
        if (TYPE_MACOSX == string) {
            return OSXUtil.GetLocationOnScreen(nativeWindow.getWindowHandle(), 0, 0);
        }
        throw new UnsupportedOperationException("n/a for windowing system: " + string);
    }

    static {
        TYPE_EGL = ".egl".intern();
        TYPE_WINDOWS = ".windows".intern();
        TYPE_X11 = ".x11".intern();
        TYPE_BCM_VC_IV = ".bcm.vc.iv".intern();
        TYPE_ANDROID = ".android".intern();
        TYPE_MACOSX = ".macosx".intern();
        TYPE_AWT = ".awt".intern();
        TYPE_DEFAULT = ".default".intern();
        isJVMShuttingDown = false;
        customShutdownHooks = new ArrayList<Runnable>();
        final boolean[] blArray = new boolean[]{false};
        final String[] stringArray = new String[]{null};
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Platform.initSingleton();
                blArray[0] = Debug.debug("NativeWindow");
                stringArray[0] = PropertyAccess.getProperty((String)"nativewindow.ws.name", (boolean)true);
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                    @Override
                    public void run() {
                        NativeWindowFactory.shutdown(true);
                    }
                }, "NativeWindowFactory_ShutdownHook"));
                return null;
            }
        });
        DEBUG = blArray[0];
        if (DEBUG) {
            System.err.println(Thread.currentThread().getName() + " - Info: NativeWindowFactory.<init>");
        }
        nativeWindowingTypePure = NativeWindowFactory._getNativeWindowingType();
        nativeWindowingTypeCustom = null == stringArray[0] || stringArray[0].length() == 0 ? nativeWindowingTypePure : stringArray[0].intern();
        initialized = false;
    }
}

