/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.util.cache;

import com.jogamp.common.util.IOUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import jogamp.common.Debug;

public class TempFileCache {
    private static final boolean DEBUG = Debug.debug("TempFileCache");
    private static boolean staticInitError = false;
    private static final String tmpDirPrefix = "file_cache";
    private static final File tmpBaseDir;
    static final String tmpRootPropName = "jnlp.jogamp.tmp.cache.root";
    private static String tmpRootPropValue;
    private static File tmpRootDir;
    private boolean initError = false;
    private File individualTmpDir;

    public static boolean initSingleton() {
        return !staticInitError;
    }

    private static void initTmpRoot() throws IOException {
        tmpRootPropValue = System.getProperty(tmpRootPropName);
        if (tmpRootPropValue != null) {
            if (tmpRootPropValue.indexOf(47) >= 0 || tmpRootPropValue.indexOf(File.separatorChar) >= 0) {
                throw new IOException("Illegal value of: jnlp.jogamp.tmp.cache.root");
            }
            if (DEBUG) {
                System.err.println("TempFileCache: Trying existing value of: jnlp.jogamp.tmp.cache.root=" + tmpRootPropValue);
            }
            tmpRootDir = new File(tmpBaseDir, tmpRootPropValue);
            if (DEBUG) {
                System.err.println("TempFileCache: Trying tmpRootDir = " + tmpRootDir.getAbsolutePath());
            }
            if (tmpRootDir.isDirectory()) {
                if (!tmpRootDir.canWrite()) {
                    throw new IOException("Temp root directory is not writable: " + tmpRootDir.getAbsolutePath());
                }
            } else {
                System.err.println("TempFileCache: None existing tmpRootDir = " + tmpRootDir.getAbsolutePath() + ", assuming new path due to update");
                tmpRootPropValue = null;
                tmpRootDir = null;
                System.clearProperty(tmpRootPropName);
            }
        }
        if (tmpRootPropValue == null) {
            File file = File.createTempFile("jln", ".tmp", tmpBaseDir);
            if (DEBUG) {
                System.err.println("TempFileCache: tmpFile = " + file.getAbsolutePath());
            }
            final FileOutputStream fileOutputStream = new FileOutputStream(file);
            FileChannel fileChannel = fileOutputStream.getChannel();
            final FileLock fileLock = fileChannel.lock();
            String string = file.getAbsolutePath();
            String string2 = string.substring(0, string.lastIndexOf(".tmp"));
            String string3 = string2 + ".lck";
            File file2 = new File(string3);
            if (DEBUG) {
                System.err.println("TempFileCache: lckFile = " + file2.getAbsolutePath());
            }
            file2.createNewFile();
            final FileOutputStream fileOutputStream2 = new FileOutputStream(file2);
            FileChannel fileChannel2 = fileOutputStream2.getChannel();
            final FileLock fileLock2 = fileChannel2.lock();
            tmpRootDir = new File(string2);
            if (DEBUG) {
                System.err.println("TempFileCache: tmpRootDir = " + tmpRootDir.getAbsolutePath());
            }
            if (!tmpRootDir.mkdir()) {
                throw new IOException("Cannot create " + tmpRootDir);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        fileOutputStream.close();
                        fileLock.release();
                        fileOutputStream2.close();
                        fileLock2.release();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            tmpRootPropValue = string2.substring(string2.lastIndexOf(File.separator) + 1);
            System.setProperty(tmpRootPropName, tmpRootPropValue);
            if (DEBUG) {
                System.err.println("TempFileCache: Setting jnlp.jogamp.tmp.cache.root=" + tmpRootPropValue);
            }
            Thread thread = new Thread(){

                @Override
                public void run() {
                    TempFileCache.deleteOldTempDirs();
                }
            };
            thread.setName("TempFileCache-Reaper");
            thread.start();
        }
    }

    private static void deleteOldTempDirs() {
        String string;
        FilenameFilter filenameFilter;
        String[] stringArray;
        if (DEBUG) {
            System.err.println("TempFileCache: *** Reaper: deleteOldTempDirs in " + tmpBaseDir.getAbsolutePath());
        }
        if ((stringArray = tmpBaseDir.list(filenameFilter = new FilenameFilter(string = tmpRootPropValue + ".lck"){
            final /* synthetic */ String val$ourLockFile;
            {
                this.val$ourLockFile = string;
            }

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".lck") && !string.equals(this.val$ourLockFile);
            }
        })) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                String string3 = string2.substring(0, string2.lastIndexOf(".lck"));
                String string4 = string3 + ".tmp";
                File file = new File(tmpBaseDir, string2);
                File file2 = new File(tmpBaseDir, string4);
                File file3 = new File(tmpBaseDir, string3);
                if (file.exists() && file2.exists() && file3.isDirectory()) {
                    FileLock fileLock;
                    FileOutputStream fileOutputStream;
                    FileLock fileLock2;
                    FileOutputStream fileOutputStream2;
                    block17: {
                        block16: {
                            fileOutputStream2 = null;
                            FileChannel fileChannel = null;
                            fileLock2 = null;
                            try {
                                fileOutputStream2 = new FileOutputStream(file2);
                                fileChannel = fileOutputStream2.getChannel();
                                fileLock2 = fileChannel.tryLock();
                            }
                            catch (Exception exception) {
                                if (!DEBUG) break block16;
                                exception.printStackTrace();
                            }
                        }
                        if (fileLock2 == null) continue;
                        fileOutputStream = null;
                        FileChannel fileChannel = null;
                        fileLock = null;
                        try {
                            fileOutputStream = new FileOutputStream(file);
                            fileChannel = fileOutputStream.getChannel();
                            fileLock = fileChannel.tryLock();
                        }
                        catch (Exception exception) {
                            if (!DEBUG) break block17;
                            exception.printStackTrace();
                        }
                    }
                    if (fileLock != null) {
                        TempFileCache.removeAll(file3);
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        file.delete();
                        try {
                            fileOutputStream2.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        file2.delete();
                        continue;
                    }
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                        fileOutputStream2.close();
                        fileLock2.release();
                    }
                    catch (IOException iOException) {
                        if (!DEBUG) continue;
                        iOException.printStackTrace();
                    }
                    continue;
                }
                if (!DEBUG) continue;
                System.err.println("TempFileCache: Skipping: " + file3.getAbsolutePath());
            }
        }
    }

    private static void removeAll(File file) {
        File[] fileArray;
        if (DEBUG) {
            System.err.println("TempFileCache: removeAll(" + file + ")");
        }
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                TempFileCache.removeAll(fileArray[i]);
            }
        }
        file.delete();
    }

    public TempFileCache() {
        if (DEBUG) {
            System.err.println("TempFileCache: new TempFileCache() --------------------- (static ok: " + !staticInitError + ")");
            System.err.println("TempFileCache: Thread: " + Thread.currentThread().getName() + ", CL 0x" + Integer.toHexString(TempFileCache.class.getClassLoader().hashCode()) + ", this 0x" + Integer.toHexString(this.hashCode()));
        }
        if (!staticInitError) {
            try {
                this.createTmpDir();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.initError = true;
            }
        }
        if (DEBUG) {
            System.err.println("TempFileCache: tempDir " + this.individualTmpDir + " (ok: " + !this.initError + ")");
            System.err.println("----------------------------------------------------------");
        }
    }

    public void destroy() {
        if (DEBUG) {
            System.err.println("TempFileCache: destroy() --------------------- (static ok: " + !staticInitError + ")");
            System.err.println("TempFileCache: Thread: " + Thread.currentThread().getName() + ", CL 0x" + Integer.toHexString(TempFileCache.class.getClassLoader().hashCode()) + ", this 0x" + Integer.toHexString(this.hashCode()));
        }
        if (!staticInitError) {
            try {
                TempFileCache.removeAll(this.individualTmpDir);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.individualTmpDir = null;
        if (DEBUG) {
            System.err.println("TempFileCache: destroy() END");
        }
    }

    public boolean isValid() {
        return !staticInitError && !this.initError;
    }

    public File getBaseDir() {
        return tmpBaseDir;
    }

    public File getRootDir() {
        return tmpRootDir;
    }

    public File getTempDir() {
        return this.individualTmpDir;
    }

    private void createTmpDir() throws IOException {
        File file = File.createTempFile("jln", ".tmp", tmpRootDir);
        String string = file.getAbsolutePath();
        String string2 = string.substring(0, string.lastIndexOf(".tmp"));
        this.individualTmpDir = new File(string2);
        if (!this.individualTmpDir.mkdir()) {
            throw new IOException("Cannot create " + this.individualTmpDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        PrintStream printStream = System.out;
        synchronized (printStream) {
            File file = null;
            try {
                file = new File(IOUtil.getTempDir(true), tmpDirPrefix);
                file = IOUtil.testDir(file, true, false);
            }
            catch (Exception exception) {
                System.err.println("Warning: Caught Exception while retrieving executable temp base directory:");
                exception.printStackTrace();
                staticInitError = true;
            }
            tmpBaseDir = file;
            if (DEBUG) {
                System.err.println("TempFileCache: Static Initialization ---------------------------------------------- OK: " + !staticInitError);
                System.err.println("TempFileCache: Thread: " + Thread.currentThread().getName() + ", CL 0x" + Integer.toHexString(TempFileCache.class.getClassLoader().hashCode()) + ", tempBaseDir " + tmpBaseDir.getAbsolutePath());
            }
            if (!staticInitError) {
                try {
                    TempFileCache.initTmpRoot();
                }
                catch (Exception exception) {
                    System.err.println("Warning: Caught Exception due to initializing TmpRoot:");
                    exception.printStackTrace();
                    staticInitError = true;
                }
            }
            if (DEBUG) {
                System.err.println("------------------------------------------------------------------ OK: " + !staticInitError);
            }
        }
    }
}

