public class Neuroschicht
{
     public Neuroschicht vorgaenger = null;
  
     public int vornanz=0;
    
     public int nanz; //Neuronenanzahl
  
     public double[] ausgang;
     public double[] Q; //Q ist Neuron-bezogen: jedes Neuron hat ein Q
     public double[] ausgang_strich; //Für Backpropagation gleich die Ableitung der sigmoiden Fkt. mitnehmen! 
  
     public int i,k,p;

     public double[][] w = null; //1. Dimension: vornanz, 2. Dimension: nanz

     public double u;

     public void uebertrageGewichte(double[] ww, int ab_dort)
     {
         for(i=0;i<vornanz;i++) //Anzahl der Neuronen in Vorgängerschicht
         {
             for(k=0;k<nanz;k++) //Anzahl der Neuronen in der aktuellen Schicht
             {
                  w[i][k] = ww[ab_dort];
                  ab_dort++;
             }
         }
     }
  
     public Neuroschicht(int nanz, Neuroschicht vorgaenger)
     {
         this.vorgaenger = vorgaenger;
         this.nanz = nanz;
         ausgang = new double[nanz];
         ausgang_strich = new double[nanz];
         Q = new double[nanz];
         for(i=0;i<nanz;i++)
             ausgang[i] = 0.0;
         for(i=0;i<nanz;i++)
             ausgang_strich[i] = 0.0;
         for(i=0;i<nanz;i++)
             Q[i] = 0.0;
             
         if(vorgaenger!=null)
         {
               vornanz = vorgaenger.holeNeuronenanzahl();
               w = new double[vornanz][nanz];
         }
     }
     
     public int holeNeuronenanzahl()
     {
           return nanz;
     }

     //Nur für Eingangsschicht relevant
     public void setzeAusgang(double[] eingang)
     {
         for(i=0;i<nanz;i++)
         {
                 ausgang[i] = eingang[i];
                 ausgang_strich[i] = 0.0;
         }
     }
     
     public void aktualisiereAusgang()
     {
         if(vorgaenger!=null)
         {
             for(i=0;i<nanz;i++)
             {
                 u = 0.0;
                 for(k=0;k<vornanz;k++)
                 {
                     u += w[k][i]*vorgaenger.ausgang[k];
                 }
                 
                 ausgang[i] = sigmoid(u);
                 ausgang_strich[i] = sigmoid_strich(u);
             }
             
         }    
     }
     
     public double sigmoid(double u)
     {
         double d = 1.8;
         return (   1.0/(1.0 + Math.exp(-d*u))   );
     }
     public double sigmoid_strich(double u)
     {
         double d = 1.8;
         return d*Math.exp(-d*u) / ( ( 1.0 + Math.exp(-d*u) )*( 1.0 + Math.exp(-d*u) ) );
     }     
}
