public class Netz
{
     //Lernfaktor für das Backtracking
     public double lernfaktor = 0.5;
  
  
     public Random zufall;
     public Neuroschicht letzte; 
  
  
     public Neuroschicht[] schicht;
     public double[] ww;
     public int anz_ww=0;
     public int[] ab_dort;
     
     public void initGewichteRand()
     {
          for(int i=0;i<anz_ww;i++)
              ww[i] = 0.001*(double)(zufall.nextInt(2001)-1000);  //-1..+1
     }
     
     public Netz()
     {
//           zufall = new Random(0);
           zufall = new Random(System.currentTimeMillis());
       
           schicht = new Neuroschicht[3];  //Antivalenz 2 4 4 1
           schicht[0] = new Neuroschicht(2,null);
           schicht[1] = new Neuroschicht(4,schicht[0]);
           schicht[2] = new Neuroschicht(1,schicht[1]);
//           schicht[3] = new Neuroschicht(4,schicht[2]);
//           schicht[4] = new Neuroschicht(1,schicht[3]);

           letzte = schicht[schicht.length-1]; 

           //------
           //Bestimmen, wieviele Gewichte es insgesamt gibt und diese in ww alle zusammenfassen:           
           ab_dort = new int[schicht.length];
           
           ab_dort[0] = 0; //nicht benutzt!!
           ab_dort[1] = 0;
           
           anz_ww = schicht[1].nanz*schicht[1].vornanz;
           
           for(int i=2;i<ab_dort.length;i++)
           {
                ab_dort[i] = ab_dort[i-1] + schicht[i-1].nanz*schicht[i-1].vornanz; //ab_dort[i] gilt für schicht[i]
                anz_ww += schicht[i].nanz*schicht[i].vornanz;
           }
           ww = new double[anz_ww];
           
           initGewichteRand();
     }
 
     public void aktualisiereAusgang(double[] eingang)
     {
           schicht[0].setzeAusgang(eingang);
           
           for(int i=1;i<schicht.length;i++)
               schicht[i].aktualisiereAusgang();
     }

     //Neuberechnung der Gewichte der Ausgangsschicht mit Backtracking:
     public void backtrackAusgangsschicht(double[] out_soll)
     {
          Neuroschicht s     = schicht[schicht.length-1];
          Neuroschicht s_vor = schicht[schicht.length-2];
          
          for(int k=0;k<s.nanz;k++) //Zu jedem Neuron korrespondiert ein Q:
          {
              s.Q[k] = s.ausgang_strich[k]*(out_soll[k] - s.ausgang[k]);
              //x ist die Aktivierung des Vorgängerneurons in die Leitung hinein, dessen
              //Gewicht gerade betrachtet wird:
              for(int i=0;i<s.vornanz;i++)
              {
                   double x = s_vor.ausgang[i];
                   
                   //i==Index Vorgängerschicht, k==Index aktuelle Schicht
                   s.w[i][k] += lernfaktor*x*s.Q[k]; 
              }
          }
     }

     //Backtracking für alle anderen Schichten außer der Ausgangsschicht (auch 0. nicht!)
     public void backtrackSchicht(int nr)
     {
          Neuroschicht s     = schicht[nr];
          Neuroschicht s_vor = schicht[nr-1];
          Neuroschicht s_nach = schicht[nr+1];
          
          for(int k=0;k<s.nanz;k++) //Zu jedem Neuron korrespondiert ein Q:
          {
              s.Q[k] = 0.0;
              //Alle Leitungen betrachten, die vom aktuell betrachteten Neuron der
              //aktuellen Schicht in der Nachfolgeschicht weggehen:
              for(int q=0;q<s_nach.nanz;q++)
              {
                   s.Q[k] += s_nach.Q[q]*s_nach.w[k][q]; //"k in s ist das i in s_nach" 
              }
              
              //Jetzt noch mit der Steigung  des aktuellen Neurons multiplizieren:
              s.Q[k]*=s.ausgang_strich[k];
              
              //x ist die Aktivierung des Vorgängerneurons in die Leitung hinein, dessen
              //Gewicht gerade betrachtet wird:
              for(int i=0;i<s.vornanz;i++)
              {
                   double x = s_vor.ausgang[i];
                   
                   //i==Index Vorgängerschicht, k==Index aktuelle Schicht
                   s.w[i][k] += lernfaktor*x*s.Q[k]; 
              }
          }
     }
 
 
     public void show()
     {
           System.out.println("Aktueller Eingang:");
           for(int i=0;i<schicht[0].ausgang.length;i++)
               System.out.print(schicht[0].ausgang[i]+" ");
           System.out.println();    
           System.out.println("Aktueller Ausgang:");
           for(int i=0;i<letzte.ausgang.length;i++)
               System.out.print(letzte.ausgang[i]+" ");
           System.out.println();    
     }

     public void uebertrageGewichte()
     {
           for(int i=1;i<schicht.length;i++)
               schicht[i].uebertrageGewichte(ww,ab_dort[i]);
     }
     
     public void testen()
     {
           double[] in1 = {0.0,0.0};            
           double[] in2 = {1.0,0.0};            
           double[] in3 = {0.0,1.0};            
           double[] in4 = {1.0,1.0};

           aktualisiereAusgang(in1);
           show();
           aktualisiereAusgang(in2);
           show();
           aktualisiereAusgang(in3);
           show();
           aktualisiereAusgang(in4);
           show();
     }

     public double berechneFehler()
     {
           double fehler = 0.0;
       
           double[] in1 = {0.0,0.0};            
           double[] in2 = {1.0,0.0};            
           double[] in3 = {0.0,1.0};            
           double[] in4 = {1.0,1.0};

           aktualisiereAusgang(in1);                                 
           fehler+=(letzte.ausgang[0]-0.0)*(letzte.ausgang[0]-0.0);
           
           aktualisiereAusgang(in2);
           fehler+=(letzte.ausgang[0]-1.0)*(letzte.ausgang[0]-1.0);
           
           aktualisiereAusgang(in3);
           fehler+=(letzte.ausgang[0]-1.0)*(letzte.ausgang[0]-1.0);
           
           aktualisiereAusgang(in4);
           fehler+=(letzte.ausgang[0]-0.0)*(letzte.ausgang[0]-0.0);
           
           return fehler;
     }
     
     public void optimiereAntivalenz()
     {
           initGewichteRand();
           uebertrageGewichte();
           testen();
           
           
           double fehler = berechneFehler();
           
           println("err0="+fehler);
           
           for(int i=0;i<10000;i++)
           {
                int nr = zufall.nextInt(ww.length);
                double delta = 0.01*(double)(zufall.nextInt(2001)-1000);
                double merk = ww[nr];
                ww[nr]+=delta;
                
                uebertrageGewichte();
                double fehler_neu = berechneFehler();
                
                if(fehler_neu<=fehler)
                {
                     if(fehler_neu<fehler)
                     {
                          println(i+": err="+fehler_neu);
                          
                     }
//                          println(i+": err="+fehler_neu);
                     fehler = fehler_neu;
                }
                else
                {
                    ww[nr] = merk;
                }
           }
           println("ENDE err="+fehler);
           testen();

     }
     
     public void optimiereAntivalenzBacktrack()
     {
           double[] in1 = {0.0,0.0};            
           double[] in2 = {1.0,0.0};            
           double[] in3 = {0.0,1.0};            
           double[] in4 = {1.0,1.0};

           double[][] in = {in1,in2,in3,in4}; //Varianten zusammenfassen
           //Zugehörige Soll-Ausgänge
           double[] out = {0.0,1.0,1.0,0.0};
       
           initGewichteRand();
           uebertrageGewichte();
           testen();
 
           double fehler = berechneFehler();
           
           //Fehler mit zufälligen Gewichten anzeigen:
           println("err0="+fehler);
           
           
           for(int i=0;i<10000;i++)
           {
               //Varianten durchgehen:
               for(int k=0;k<out.length;k++)
               {
                     //Input Verwärtspropagieren:
                     double[] in_aktuell = in[k];
                     aktualisiereAusgang(in_aktuell); //auch sigmoid_strich(u) wird schon berechnet!
                                                              
                     double[] out_aktuell = {out[k]};
                     
                     backtrackAusgangsschicht(out_aktuell);
                     
                     //Schichten ab der vorletzten rückwärts durchgehen,
                     //0-te Schicht aussparen, da Eingangsschicht keine Gewichte hat:
                     for(int p=schicht.length-2;p>=1;p--)
                         backtrackSchicht(p);
               }
           }
           
           fehler = berechneFehler();
           println("ENDE err="+fehler);
           testen();
           
     }
}
