public class Netz
{
     //unsigned int bei 2 Byte hat maximal 65535, wurzel == 255, 255*255 == 65025
     //Maxwert kleiner als Hälfte von 65535==32767, wurzel == 181, 181*181 == 32761.
     //800*800 = 64000
     public int GRENZWERT = 181; //Grenzwert der sigmoiden Funktion  
     
     public int MAXWERT = GRENZWERT*GRENZWERT;  //Da muß gegenüber dem Grenzwert nach oben noch Luft sein, mindestens GRENZWERT*GRENZWERT!!!,
                                  //also w_max*Q_max muss darstellbar sein!, Ansatz: w_max == Q_max == GRENZWERT 
                                  //also auch: MAX_INT > MAXWERT*2
     public int DELTATEILER = 10; //durch das wird das delta geteilt, z.B. liegt es dann im Bereich +/-GRENZWERT/10
  
     public Random zufall;
     public Neuroschicht letzte; 
  
  
     public Neuroschicht[] schicht;
     public int[] ww;
     public int anz_ww=0;
     public int[] ab_dort;

     public int[] ausgang_binaer;  //wenn <=500 => 0, >500 => 1
     public int[] eingang_binaer;  //wenn <=0 => 0, >0 => 1
     
     public void initGewichteRand()
     {
          //Werden im Bereich bis zur zum Grenzwert angesetzt, denn: Maximal auftretender Wert auf einer Leitung ist dann Grenzwert im Quadrat!!!!
          for(int i=0;i<anz_ww;i++)
              ww[i] = zufall.nextInt(GRENZWERT);  //0..GRENZWERT-1, keine negativen Gewichte erlauben
              
          //Bessere Konvergenz ev. mit kleineren Startgewichten, die um die Mitte herum liegen:
          // GRENZWERT/2 +/- GRENZWERT/DELTATEILER:
          
//          for(int i=0;i<anz_ww;i++)
//              ww[i] = GRENZWERT/2 + zufall.nextInt((2*GRENZWERT)/DELTATEILER+1) - GRENZWERT/DELTATEILER;  //0..GRENZWERT-1, keine negativen Gewichte erlauben
          
     }
     
     public Netz()
     {
//           zufall = new Random(0);
           zufall = new Random(System.currentTimeMillis());
       
           schicht = new Neuroschicht[3];  //Antivalenz 2 4 4 1
           schicht[0] = new Neuroschicht(2,null,GRENZWERT,MAXWERT);
//           schicht[1] = new Neuroschicht(16,schicht[0],GRENZWERT,MAXWERT); //Netz viermal größer als nötig, um trotz schlechter Konvergenz noch zu err==0 zu gelangen!
           schicht[1] = new Neuroschicht(4,schicht[0],GRENZWERT,MAXWERT); //Netz viermal größer als nötig, um trotz schlechter Konvergenz noch zu err==0 zu gelangen!
           schicht[2] = new Neuroschicht(1,schicht[1],GRENZWERT,MAXWERT);
//           schicht[3] = new Neuroschicht(4,schicht[2]);
//           schicht[4] = new Neuroschicht(1,schicht[3]);

           letzte = schicht[schicht.length-1]; 

           //------
           
           ab_dort = new int[schicht.length];
           
           ab_dort[0] = 0; //nicht benutzt!!
           ab_dort[1] = 0;
           
           anz_ww = schicht[1].nanz*schicht[1].vornanz;
           
           for(int i=2;i<ab_dort.length;i++)
           {
                ab_dort[i] = ab_dort[i-1] + schicht[i-1].nanz*schicht[i-1].vornanz; //ab_dort[i] gilt für schicht[i]
                anz_ww += schicht[i].nanz*schicht[i].vornanz;
           }
           ww = new int[anz_ww];
           
           initGewichteRand();
           
           ausgang_binaer = new int[schicht[schicht.length-1].nanz];
           eingang_binaer = new int[schicht[0].nanz];
     }

     public void backtrackSchritt(int[] eingang, int[] sollausgang, double lernfaktor)
     {
           // 0 und 1 werden am Eingang immer gemappt auf 0 und GRENZWERT
           //1. Netz aktualisieren
           aktualisiereAusgang(eingang);
           
           //bei der geplanten Spezialanwendung ergibt sich aus dem aktuellen Ausgang erst der
           //sollausgang (nächste Kombi, die keine Fehler enthält!)
           
           //dann entfällt die Übergabe des sollausgangs von außen!!!
           
           //2. Neue Gewichte zur Ausgangsschicht hin berechnen:
           Neuroschicht sn; //Referenz auf Nachfolgeschicht
           Neuroschicht s  = schicht[schicht.length-1];
           Neuroschicht sv = s.vorgaenger;
           
           for(int i=0;i<s.nanz;i++)
           {
                 double Q = s.ausgang_strich[i];
//                 double Q = (double)s.ausgang[i];
//println("Q= "+Q);                 
                 if(sollausgang[i]==0)
                       Q*=(double)(0-s.ausgang[i]);
                 else
                       Q*=(double)(GRENZWERT-s.ausgang[i]);
                 //Gewicht k jeder Leitung hin zu Neuron i
                 //i... Index Neuronen der Schicht
                 //k... Index der Neuronen der Vorgängerschicht
                 // w = new int[vornanz][nanz];
//print("v= ");                 
                 for(int k=0;k<s.w.length;k++)
                 {
                      int veraenderung =(int)(lernfaktor*sv.ausgang[k]*Q);
//print(veraenderung+" ");                      
                      s.w[k][i]+=veraenderung;
                 }
//println();                 
                 s.Q[i] = (int)Q; //Qs der Schicht für nachfolgende Btracks merken
           }
           aktualisiereAusgang(eingang);
           //Alle anderen Zwischenschichten, beginnend mit der vorletzten.
           //(Eingangsschicht nicht, die hat keine Gewichte)
           for(int nr=schicht.length-2;nr>=1;nr--)
           {
               sn = schicht[nr+1];
               s  = schicht[nr];
               sv = schicht[nr-1];
               
               for(int i=0;i<s.nanz;i++)
               {
                   double Q = s.ausgang_strich[i];
                   double summe = 0.0;
               
                   //Summe Qk*wneuk der Nachfolgeschicht bilden:
                   //w = new int[vornanz][nanz];
                   for(int p=0;p<sn.nanz;p++)
                       summe+=(double)sn.w[i][p]*(double)sn.Q[p];
                   Q*=summe;    
                   for(int k=0;k<sv.nanz;k++)
                   {
                       s.w[k][i]+=(int)(lernfaktor*sv.ausgang[k]*Q);
                   }
               }
               aktualisiereAusgang(eingang);
           }
     }

     public void backtrackTest()
     {
           initGewichteRand();
           uebertrageGewichte();  //Performanceverlust!,jedoch egal, wenn Adaption an PC und festes Netz in Mikrocontroller 
           testen();

           long fehler = berechneFehler();
           
           println("err0="+fehler);
           int[] in1 = {0,0};            
           int[] in2 = {1,0};            
           int[] in3 = {0,1};            
           int[] in4 = {1,1};
           
           for(int i=0;i<100000;i++)
           {
               //backtrackSchritt(int[] eingang, int[] sollausgang, double lernfaktor)
               double lernfaktor = 1000.0;
               backtrackSchritt(in1,new int[] {0}, lernfaktor);             
               backtrackSchritt(in2,new int[] {1}, lernfaktor);             
               backtrackSchritt(in3,new int[] {1}, lernfaktor);             
               backtrackSchritt(in4,new int[] {0}, lernfaktor);             
           }           
           println("ENDE err="+fehler);
           
           testen();
     }

     //Alternative für binäre Eingänge
     public void aktualisiereAusgang(int[] eingang)
     {
           schicht[0].setzeAusgang(eingang);
           
           for(int i=1;i<schicht.length;i++)
           {
//               println("\nSCHICHT "+i+":");
               schicht[i].aktualisiereAusgang();
           }    
           for(int i=0;i<ausgang_binaer.length;i++)
               if(schicht[schicht.length-1].ausgang[i]>GRENZWERT/2)
                   ausgang_binaer[i]=1;
               else    
                   ausgang_binaer[i]=0;
                   
           for(int i=0;i<eingang.length;i++)
               eingang_binaer[i] = eingang[i];
                   
     }
 
     public void show()
     {
           System.out.println("Aktueller Eingang:");
           for(int i=0;i<eingang_binaer.length;i++)
               System.out.print(eingang_binaer[i]+" ");
           System.out.println();    
           System.out.println("Aktueller Ausgang:");
           for(int i=0;i<ausgang_binaer.length;i++)
               System.out.print(ausgang_binaer[i]+" ");
           System.out.println();    
     }

     public void uebertrageGewichte()
     {
           for(int i=1;i<schicht.length;i++)
               schicht[i].uebertrageGewichte(ww,ab_dort[i]);
     }
     
     public void testen()
     {
           int[] in1 = {0,0};            
           int[] in2 = {1,0};            
           int[] in3 = {0,1};            
           int[] in4 = {1,1};

           aktualisiereAusgang(in1);
           show();
           aktualisiereAusgang(in2);
           show();
           aktualisiereAusgang(in3);
           show();
           aktualisiereAusgang(in4);
           show();
     }

     public long berechneFehler()
     {
           long fehler = 0;
       
           int[] in1 = {0,0};            
           int[] in2 = {1,0};            
           int[] in3 = {0,1};            
           int[] in4 = {1,1};

           aktualisiereAusgang(in1); //soll <=0 sein
           if(letzte.ausgang[0]>GRENZWERT/2)
              fehler+=letzte.ausgang[0]-GRENZWERT/2+1;
           
           aktualisiereAusgang(in2); //soll >0 sein
           if(letzte.ausgang[0]<=GRENZWERT/2)
              fehler+=GRENZWERT/2-letzte.ausgang[0]+1;
           
           aktualisiereAusgang(in3); //soll >0 sein
           if(letzte.ausgang[0]<=GRENZWERT/2)
              fehler+=GRENZWERT/2-letzte.ausgang[0]+1;
           
           aktualisiereAusgang(in4);
           if(letzte.ausgang[0]>GRENZWERT/2)
              fehler+=letzte.ausgang[0]-GRENZWERT/2+1;
           
           return fehler;
     }
     
     public void optimiereAntivalenz()
     {
           initGewichteRand();
           uebertrageGewichte();  //Performanceverlust!,jedoch egal, wenn Adaption an PC und festes Netz in Mikrocontroller 
           testen();
           
           
           long fehler = berechneFehler();
           
           println("err0="+fehler);
           
           for(int i=0;i<100000;i++)
           {
                int nr = zufall.nextInt(ww.length);
                int delta = (zufall.nextInt(2*GRENZWERT/DELTATEILER+1)-GRENZWERT/DELTATEILER); //delta darf nicht unsigned sein.
                int merk = ww[nr];
                
                if(delta<0 && ww[nr]<-delta)
                    ww[nr]=0;
                else if(delta>0 && ww[nr]+delta>GRENZWERT)     
                    ww[nr]=GRENZWERT;
                else    
                    ww[nr]=delta;
                
                uebertrageGewichte();
                long fehler_neu = berechneFehler();
                
                if(fehler_neu<=fehler)
                {
                     if(fehler_neu<fehler)
                     {
                          println(i+": err="+fehler_neu);
                          
                     }
//                          println(i+": err="+fehler_neu);
                     fehler = fehler_neu;
                }
                else
                {
                    ww[nr] = merk;
                }
           }
           println("ENDE err="+fehler);
           testen();

     }
     
     
}
