
//*****************
//IMPLEMENTIERUNGEN
//*****************
//..sendet zyklisch ein serielles Signal "ping" über die Infrarot-Diode
class zPing : public iZustand
{
    public:
       unsigned int zaehler=0;
       void loop()
       {
           switch(zaehler)
           {
                 case 0:
                     gruenblau.anGruen();
                 break;
                 case 1:
                     Serial1.write('p');
                 break;
                 case 2:
                     Serial1.write('i');
                 break;
                 case 3:
                     Serial1.write('n');
                 break;
                 case 4:
                     Serial1.write('g');
                 break;
                 case 5:
                     Serial1.write('\n');
                 break;
                 case 6:
                     Serial1.write('\r');
                 break;
                 
                 case 20:
                     gruenblau.ausGruen();
                 break;
                 
           }
           
           zaehler++;
           zaehler%=100;
       }
       void konfigurieren(char a, char b, char c, char d){}
       char getPanz(){return 0;}                    
} zping;

class zBlink : public iZustand
{
    public:
        int zaehler=0;
        void loop()
        {
             if(zaehler==0)
             {
                 gruenblau.anGruen();
                 gruenblau.ausBlau();
             }    
             else if(zaehler==50)
             {
                 gruenblau.ausGruen();
                 gruenblau.anBlau();
             }
             
             zaehler++;
             zaehler%=100;
        }
        char getPanz(){         return 0;    }
        void konfigurieren(char a, char b, char c, char d){      }
} zblink;

class zStromanalyse : public iZustand
{
    public:
       char zaehler=0;
       
       void loop()
       {
             switch(zaehler)
             {
                 case 0:
                     strom.aktualisiereStrom();
                 break;
                 case 10:
                     strom.aktualisiereStrom();
                 break;
                 case 20:
                     strom.aktualisiereStrom();
                 break;
                 case 30:
                     strom.aktualisiereStrom();
                 break;
                 case 40:
                     strom.sendeStrom();
                 break;
             }
             zaehler++;
             zaehler%=100;
       }
       void konfigurieren(char a, char b, char c, char d){}
       char getPanz(){return 0;}                    
} zstromanalyse;

class zBodenanalyse : public iZustand
{
    public:
       void loop()
       {
             boden.sendeBoden();
       }    
       void konfigurieren(char a, char b, char c, char d){}
       char getPanz(){return 0;}                                
} zbodenanalyse;

class zBodenfahrt : public iZustand
{
    public:
       void loop()
       {
             boden.aktualisiereBoden();
             boden.setzeFahrt(255);
       }    
       void konfigurieren(char a, char b, char c, char d){}
       char getPanz(){return 0;}                                
} zbodenfahrt;

class zBodenfahrtdist : public iZustand
{
    public:
       int wert=0;
       void loop()
       {
             boden.aktualisiereBoden();
             entfernung.aktualisiereEntfernung();
             
             //Langsdam fahren, wenn niemand vorne ist:
             if(entfernung.wert<150)
             {
                 boden.setzeFahrt(240);
             }
             else if(entfernung.wert<300)
             {
                 boden.setzeFahrt(255);
             }    
             else    
             {
                 wert = 255+300-entfernung.wert;
                 if(wert<0)
                     wert=0;
                 boden.setzeFahrtAlt(wert);
             }    
       }    
       void konfigurieren(char a, char b, char c, char d){}
       char getPanz(){return 0;}                                
} zbodenfahrtdist;



class zEntfernungsanalyse : public iZustand
{
    public:
       void loop()
       {
             entfernung.sendeEntfernung();
       }    
       void konfigurieren(char a, char b, char c, char d){}
       char getPanz(){return 0;}                                
} zentfernungsanalyse;

class zMikrofonanalyse : public iZustand
{
    public:
       void loop()
       {
             mikrofon.sendePegel();
       }    
       void konfigurieren(char a, char b, char c, char d){}
       char getPanz(){return 0;}                                
} zmikrofonanalyse;

class zAudioanalyse : public iZustand
{
    public:
       int z=0;
       int inx=0;
       int wert=0;
       void loop()
       {
           switch(z)
           {
               case 0:
                   mikrofon.reset();
                   z++;
                   
                   //ton.ping(1000);  //testweise direkt den ping hinzufügen
               break;
               case 1:
                   mikrofon.aktualisierePegel();
                   if(mikrofon.speicherPegel()==false)
                       z++;
//                   while(mikrofon.speicherPegel()==true) PORTB|=0;
//                   z++;
               break;
               case 2:
                   Serial.print("Neuer Puffer: ");
                   inx=0;
                   z++;
               break;
               case 3:
                   if((inx<<2)<PUFFERGROESSE)               
                   {
                       wert = gPuffer[((inx<<2) | 1)];          
                       //Serial.println(wert,DEC);           
                       Serial.print(wert,DEC);           
                       inx++;
                   }
                   else
                   {
                       z=0; //von vorn
                       Serial.println();
                   }
               break;
           }
       }    
       void konfigurieren(char a, char b, char c, char d){}
       char getPanz(){return 0;}                                
} zaudioanalyse;

class zEntfernungssonifikation : public iZustand
{
    public:
       int zaehler = 0;
       void loop()
       {
             if(zaehler==0)
             {
                entfernung.aktualisiereEntfernung();
                ton.ping(entfernung.wert+1000);
             }
             zaehler++;
             zaehler%=100;
       }    
       void konfigurieren(char a, char b, char c, char d){}
       char getPanz(){return 0;}                                
} zentfernungssonifikation;

class zLadestromanalyse : public iZustand
{
    public:
       int zaehler = 0;
       void loop()
       {
             switch(zaehler)
             {
                 case 0:
                     laden.aktualisiereLadestrom();
                 break;
                 case 40:
                     laden.sendeLadestrom();
                 break;
             }
             zaehler++;
             zaehler%=100;
       }
       void konfigurieren(char a, char b, char c, char d){}
       char getPanz(){return 0;}                    
} zladestromanalyse;


class zRuhe : public iZustand
{
    public:
       void loop()
       {
            antrieb.fahrt(0,0);
            gruenblau.ausGruen();
            gruenblau.ausBlau();            
       }
       void konfigurieren(char a, char b, char c, char d){}
       char getPanz(){return 0;}                    
} zruhe;

