//NEU: 
//a) Drei Typen: Nachricht, Befehl, Zustand 
//b) Länge soll flexibel sein. Abgespeicherte Nachrichten, Befehls und Zustandsobjekte geben selber ihre Länge an.

//BEFEHLSÜBERSICHT (direkte Befehle, die den Loop unterbrechen):
//ZUSTÄNDE
// #00  Wechselblinken
// #01  seriell über Kabel und IR den Text "ping" zur Kontrolle der seriellen Schnittstelle
// #02  Stromanalyse: liefert die Strommesswerte auf allen vier Motoranschlüssen und zeigt über die LEDs an, ob ein Motor blockiert ist.
//        Sinnvoll im Zusammenhang mit Motorsteuerbefehlen, z.B. $05 (beide Motoren vorwärts). Zustand und befehl lassen sich gleichzeitig realisieren!
// #03  Bodenanalyse: Wert des Bodensensors anzeigen und über LEDs, wie gegengeregelt würde.
// #04  Entfernungsanalyse: Test des Sharp-IR-Sensors
// #05  Mikrofonanalyse: Test des Mikrofon Breakout-Boards
// #06  Audioanalyse: Aufzeichnen in Pudffer und Ausgabe des Puffers
// #07  Entfernungssonifikation, IR-Wert wird als Frequenz an ton als Ping gespielt.
// #08  Fahrt entlang Linie: gegen Uhrzeigersinn, innen weiß, außen schwarzes Isolierklebeband.
// #09  Fahrt entlang Linie und Abstand halten zu Vordermann
// #10  Ladestromanalyse

//LED-Befehle (ohne Parameter)
// $00  grüne LED an
// $01  grüne LED aus
// $02  blaue LED an
// $03  blaue LED aus
//Antriebs-Befehle (zwei Parameter, v,r,h für vorwärts, rückwärts, halt   ... erster Parameter für links, zweiter für rechts)
// $04hh Beide Motore anhalten
// $04vh Nur linker Motor vor
// $04hv Nur rechter Motor vor
// $04rh Nur linker Motor zurück
// $04hr Nur rechter Motor zurück
// $04vv vorwärts
// $04rr rückwärts
// $04vr Rechts-Drehung (im Uhrzeigersinn)
// $04rv Links-Drehung  (gegen Uhrzeigersinn)
//Kurzbefehle für den Antrieb für bessere Infrarotübertragung:
// $05 vor
// $06 zurück
// $07 Links herum
// $08 Rechts herum
// $09 Stop
// $10ab Ton an, a*100 = frequenz, b=28 = Lautstärke
// $11   Ton aus
// $12   Nullerausgabe am Ende der Tonsequenz seriell ausgeben.
// $13   Nullerausgabe am Ende der Tonsequenz seriell NICHT ausgeben.
// $14   Zyklische Tonausgabe einschalten.
// $15   Zyklische Tonausgabe ausschalten.
// $16   Motore sind richtig angebracht
// $17   Motore sind verkehrt angebracht
// $18   Testprogramm auf EEPROM übertagen
// $19   Interpreter starten
// $20   Interpreter beenden

#include<avr/interrupt.h>
#include <EEPROM.h>


#define MAXZAEHLER 255
#define MAXGRENZE 256
#define HALBMAXZAEHLER 127

#define ANZZUSTAND 12
#define ANZBEFEHL 22
#define ANZNACHRICHT 1

#define BAUDRATE 300

#define BLOCKADESCHWELLE 860 //unterhalb dieses Wertes gilt ein Motor als blockiert, wenn dort Strom anliegt.

#define BODENSOLLWERT 350
#define BODENSTELLFAKTOR -3

//Der Lautsprecher ist an D6 angeschlossen, das entspricht auf dem Mikrocontroller PD7
//Deshalb zur Erzeugung des Sinustones (vergl. in der main-Loop):

#define PUFFERGROESSE 128
//Timeout, z.B. für das Einlesen des Puffers. ca. 4ms pro Tick, also ca. 8Sekunden wenn 2000
#define TIMEOUT 2000

//Ganzzahlige Vielfache der folgenden Frequenz werden gespielt:
#define BASISFREQUENZ 200
#define PHRASENBREITE 12

//#################################
//Definitionen für den Interpreter:

#define ANZBEDINGUNGEN 9
#define ANZSTRATEGIEN 4

//ENDE Definitionen für den Interpreter:
//#################################

//Konstanten für die Hilfsklassen und Funktionen in hilfs.h

//Klasse Bitdamper:
#define DAEMPFUNGSPERIODE_IN_TICKS 100
//statt Prozent Absolutanteil gegenüber DAEMPFUNGSPERIODE_IN_TICKS festlegen:
#define DAEMPFUNGS_SCHWELLE_ABSOLUT 80

//Testskript für Interpreter, das in den EEPROM geschrieben werden kann:

//Programmbeschreibung des nachfolgenden Programms:
//Erster Befehl:
//0==aktuelle Strategie == grün an, blau aus
//1==Zielzustand == blau an, grün aus
//Übergang, wenn Bedingung 2 erfüllt == grün zu lange an

//Zweiter Befehl:
//1==aktuelle Strategie == blau an, grün aus
//0==Zielzustand == grün an, blau aus
//Übergang, wenn Bedingung 3 erfüllt == blau zu lange an


//Übertragen von Testprogramm auf EEPROM: $18  schreibetestprogrammaufeeprom;
//Verwenden des EEPROM-Programms: $19 startinterpreter
//const char testprogramm[] = {"01:2&0&0 10:3&0&0"}; //Leerzeichen sollten überlesen werden, bei zu kurzem Programm rest mit Leerzeichen aufgefüllt werden.

//Zweites Testprogramm:
//Übergang von Strategie "Liniendist" nach Ruhe, wenn ZeitA & Spule
//Übergang von Strategie "Ruhe" nach Liniendist, wenn ZeitB
//const char testprogramm[] = {"23:7&6&0 32:8&0&0"}; //Leerzeichen sollten überlesen werden, bei zu kurzem Programm rest mit Leerzeichen aufgefüllt werden.

//einfacher: zeitA => grün an, sonst blau an:
//const char testprogramm[] = {"01:8&0&0 10:7&0&0"}; //Leerzeichen sollten überlesen werden, bei zu kurzem Programm rest mit Leerzeichen aufgefüllt werden.

//weiterer Test: wenn spule, dann grün sonst blau
//const char testprogramm[] = {"01!6&0&0 10:6&0&0"}; //Leerzeichen sollten überlesen werden, bei zu kurzem Programm rest mit Leerzeichen aufgefüllt werden.

//Wechsel zwischen Ruhe und Fahren entsprechend zeitA zeitB:
//const char testprogramm[] = {"23:8&0&0 32:7&0&0"};
//const char testprogramm[] = {"02:8&0&0 20:7&0&0"};

//Ahhhhh: Allererster Zustand muß immer erst einmal 0 sein:
const char testprogramm[] = {"03:0&0&0 23:7&6&0 32:8&0&0"};


//GLOBALE VARIABLEN
volatile bool perform = false; //Hauptloop ausführen, von ISR gesteuert!

//Globaler Puffer, den sich mehrere Anwendungen teilen: Erfassen diverser Sensordaten, aber auch Skript für Metaebene.
volatile unsigned int gPuffer[PUFFERGROESSE];
volatile unsigned char gZaehler=0; //wird von der ISR inkrementiert, dient als Zeitgebeber für die synchrone Programmierung
volatile unsigned long gUhrzeit = 0;

//aktuellen Motorzustand global verfügbar machen:
volatile int gLinks=0;
volatile int gRechts=0;  //vergl. mAntrieb.h, fahrt(..)

//Für Modul mTon: serielle Ausgabe der mit dem Mikrofon gezählten "Nuller":
//...wird über den Befehl bNullerausgabeAn aktiviert und mit bNullerausgabeAus deaktiviert.
volatile bool gNullerausgabe = false;

//Tonsequenz ausgeben mit btonausgabeAn aktivieren und mit btonausgabeAus deaktivieren.
volatile bool gTonausgabe = true; //Defaultmäßig "Ping-Ton" ausgaben

//Für den Fall, dass die Motore falsch angebracht sind, Vorzeichenumkehr bei boden.setzeFahrt() bewirken:
volatile bool gMotorRichtig = true;

//Global verfügbare Hilfsmethoden
#include "hilfs.h"

//SCHNITTSTELLEN
#include "interfaces.h"


iZustand* zustand = 0;
iZustand* zustaende[ANZZUSTAND];
iBefehl* befehl = 0;
iBefehl* befehle[ANZBEFEHL];
iNachricht* nachricht = 0;
iNachricht* nachrichten[ANZNACHRICHT];

//für Interpreter:
iStrategie* strategie = 0;
iStrategie* strategien[ANZSTRATEGIEN];
iBedingung* bedingung = 0;
iBedingung* bedingungen[ANZBEDINGUNGEN];


//MODULE
#include "module.h"
#include "mStrom.h"
#include "mBoden.h"
#include "Remote.h"

//Die Verwendung des Interpreters sollte in einen Zustand eingebettet sein.
//Statt selber Zustände zu verwenden, wird so etwas Ähnliches verwendet, das "strategie" genannt wird, damit diese
//unabhängig von den verfügbaren Zuständen entwickelt werden können.
//Strategien wiederum werden abhängig von der Erfüllung bestimmter Bedingungen gemäß der Skriptbeschreibung ausgeführt.
//Zeiger auf Strategien und Bedingungen werden wie Nachrichten, Befehle und zustände auch in einer natürlichen Reihenfolge in Arrays abgelegt und
//werden im Skript über ihre Nummer angesprochen.
//Da der Interpreter auch über Befehle aktiviert und deaktiviert werden können soll, ist das include-File auch noch vor den Befehlen.

#include "strategien.h"
#include "bedingungen.h"

//INTERPRETER
#include "interpret.h"

//BEFEHLE
#include "befehle.h"

//NACHRICHTEN
#include "nachrichten.h"


//ZUSTAENDE
#include "zustaende.h"

ISR(TIMER1_COMPA_vect)  //Initialisierung, siehe Remote.h
{
    gZaehler++; //gleicher Timer zur Taktung der IR-Diode, deshalb 2*30kHz Takt == 60kHz (toggeln mit 60kHz heißt 30kHz blinken)
                //Also ein Tick == 0,000016667 Sekunden oder 0,016666667 Millisekunden
                //Ein Schleifendurchlauf dauert 256 Ticks, also 4,266666667 Millisekunden oder 0,004266667 Sekunden
                //grob gerechnet also 4 Millisekunden.
                //
                //UHRZEIT:
                //1 Sekunde == 234 Uhrzeit-Ticks, also Schleifendurchläufe.
                //Halbsekunden-Blinken: mit Modulo 117 toggeln                            
                
    //gZaehler%=MAXGRENZE;  //nicht nötig, da unsigned char 8 Bit hat, d.h. maxwert ist 255
                
    if(gZaehler==0)            
        perform = true;
}


void setup() 
{
    //pinMode(6,OUTPUT); //Tontest
  
    zustaende[0] = &zblink;
    zustaende[1] = &zping;
    zustaende[2] = &zstromanalyse;
    zustaende[3] = &zbodenanalyse;
    zustaende[4] = &zentfernungsanalyse;
    zustaende[5] = &zmikrofonanalyse;
    zustaende[6] = &zaudioanalyse;
    zustaende[7] = &zentfernungssonifikation;
    zustaende[8] = &zbodenfahrt;
    zustaende[9] = &zbodenfahrtdist; //Mit Abstandhalten
    zustaende[10] = &zladestromanalyse;
    zustaende[11] = &zruhe;
    
    befehle[0] = &bgruenan;
    befehle[1] = &bgruenaus;
    befehle[2] = &bblauan;
    befehle[3] = &bblauaus;
    befehle[4] = &bfahrt;
    befehle[5] = &bvor;
    befehle[6] = &brueck;
    befehle[7] = &blinks;
    befehle[8] = &brechts;
    befehle[9] = &bstop;    
    befehle[10] = &btonan;
    befehle[11] = &btonaus;
    befehle[12] = &bnullerausgabean;
    befehle[13] = &bnullerausgabeaus;
    befehle[14] = &btonausgabean;
    befehle[15] = &btonausgabeaus;
    befehle[16] = &bmotorrichtigja;
    befehle[17] = &bmotorrichtignein;
    befehle[18] = &bschreibetestprogrammaufeeprom;
    befehle[19] = &bstartinterpreter;
    befehle[20] = &bstopinterpreter;
    befehle[21] = &bladeprogrammkabel;

    nachrichten[0] = &ngruss;

    strategien[0] = &sgruen;  //Wechselblinken über Interpreter realisieren.
    strategien[1] = &sblau;
    strategien[2] = &sbodenfahrtdist;    
    strategien[3] = &sruhe;

    bedingungen[0] = &qtrue;
    bedingungen[1] = &qfalse;
    bedingungen[2] = &qgruenzulangean;
    bedingungen[3] = &qblauzulangean;
    bedingungen[4] = &qgruenzulangean_schnell;
    bedingungen[5] = &qblauzulangean_schnell;
    bedingungen[6] = &qladespule;
    bedingungen[7] = &qzeita;
    bedingungen[8] = &qzeitb;
  
    gruenblau.aktivieren();
    antrieb.aktivieren();
    strom.aktivieren();
    boden.aktivieren();
    remote.aktivieren();
    mikrofon.aktivieren();
    ton.aktivieren();    
    entfernung.aktivieren();
    laden.aktivieren();
}

void loop() 
{  
    if(perform == true)  
    {
         perform = false;
      
         remote.zeitschritt(); //drastisch verkürzt, wenn keine Zeichen hereinkommen!
         ton.zeitschritt();

  
         if(zustand!=0)
         {
               zustand->loop();
         }
         if(befehl!=0)
         {
               //zustand = 0; //keinen Zustandsloop mehr ausführen, wenn ein direkter Befehl herainkommt
               //Nur bei Befehl $00 die Zustände ausklinken, da sonst z.B. Kontrolle des Stromsensors bei verschiedenen Motorzuständen nicht möglich!
               //SIEHE befehle.h bGruenAn

               befehl->perform();
               befehl = 0; //nur einmal ausführen!
         }
         if(nachricht!=0)
         {
               nachricht->reagieren();
               nachricht = 0;
         }

//Testweise verlangsamen (Später entfernen!!!!):
//if(gUhrzeit%100==0)
//{
         //Für Interpreter
         if(strategie!=0)
         {
               strategie->loop();
         }

         if(gUhrzeit%20==0)//seltener machen!
             interpreter.zeitschritt(); //Hat nur Effekt, wenn interpreter.AKTIV==true
//}

         
         
         
//         if(interpreter.zeitschritt())        
//             Serial.print('1');  //Befehl ausgeführt
         
              //digitalWrite(6,HIGH);  //Tontest
         /*     
         while(gZaehler<HALBMAXZAEHLER)
         {
              PORTB |=0;
              
         }
         */
         gUhrzeit++;         
    }              
}
