
//*****************
//IMPLEMENTIERUNGEN
//*****************

//ACHTUNG: Größere Module stehen in Extra-Haeder-Dateien!

class GruenBlau : public iModul
{
    public:
       void aktivieren()
       {
           pinMode(13,OUTPUT);    //Grüne superhelle LED
           digitalWrite(13,HIGH);
           DDRB  |=  0b00000010;  //Blaue superhelle LED
           //DDRB  &= ~0b00001000; //#### NICHT MEHR NÖTIG BEI NEUEM FAHRZEUG ####
           PORTB |=  0b00000010;
       }
       void deaktivieren()
       {
           pinMode(13,INPUT);    //Grüne superhelle LED
           digitalWrite(13,LOW);
           DDRB  &= ~0b00000010;  //Blaue superhelle LED
           //DDRB  &= ~0b00001000; //#### NICHT MEHR NÖTIG BEI NEUEM FAHRZEUG ####
           PORTB &= ~0b00000010;            
       }
       
       void anGruen()
       {
           digitalWrite(13,LOW);
       }
       
       void ausGruen()
       {
           digitalWrite(13,HIGH);
       }
       
       void anBlau()
       {
           PORTB &= ~0b00000010;
       }
       
       void ausBlau()
       {
           PORTB |=  0b00000010;
       }
       
} gruenblau;

class mAntrieb : public iModul
{
   public:
      void aktivieren()
      {
            //D5, PWM, Motor rechts, roter Punkt
            analogWrite(5,0);
            //D4, Motor rechts
            pinMode(4,OUTPUT);
            digitalWrite(4,LOW);
            
            //D3, PWM, Motor rechts, roter Punkt
            analogWrite(3,0);
            //D2, Motor rechts
            digitalWrite(2,LOW);
            pinMode(2,OUTPUT);                                    
      }
      
      void deaktivieren()
      {
            //D5, PWM, Motor rechts, roter Punkt
            analogWrite(5,0);
            //D4, Motor rechts
            pinMode(4,INPUT);
            digitalWrite(4,LOW);
            
            //D3, PWM, Motor links, roter Punkt
            analogWrite(3,0);
            //D2, Motor links
            digitalWrite(2,LOW);
            pinMode(2,INPUT);
      }
      
      void fahrt(int links, int rechts)
      {
           gLinks = links;    //auf globalen Zustand übertragen
           gRechts = rechts;
        
           if(rechts>0)
           {
              analogWrite(3,rechts);
              digitalWrite(2,LOW);
           }
           else if(rechts<0)
           {
              analogWrite(3,255+rechts);
              digitalWrite(2,HIGH);
           }
           else
           {
              analogWrite(3,0);
              digitalWrite(2,LOW);
           }
           
           if(links>0)
           {
              analogWrite(5,255-links);
              digitalWrite(4,HIGH);
           }
           else if(links<0)
           {
              analogWrite(5,-links);
              digitalWrite(4,LOW);
           }
           else
           {
              analogWrite(5,0);
              digitalWrite(4,LOW);
           }
           
      }
} antrieb;


class mMikrofon
{
   public:
      int wert = 0;
      int index = 0;      
      unsigned long startzeit = 0;
      char zaehler=0;   

      void aktivieren()
      {
          pinMode(22,INPUT); //...wenn mit digital-Read gearbeitet wird!
      }    
      void deaktivieren()
      {
      }    

      //Als Vorbereitung für eine Aufzeichnung im Puffer.      
      void reset()
      {          
          for(index=0;index<PUFFERGROESSE;index++)
              gPuffer[index]=0;
          
          index = 0;
          startzeit = gUhrzeit;
          zaehler=0;
      }
      
      void aktualisierePegel()      
      {
//          wert = analogRead(4);
            wert = digitalRead(22);
      }    
      
      //Hört auf, wenn Puffer voll.
      bool speicherPegel()      
      {
          if((index<<1)<PUFFERGROESSE)
          {
              gPuffer[(index<<1)] = gUhrzeit;
              gPuffer[((index<<1) | 1)] = wert;
              index++;     
              return true;     
          }
          else
          {
              return false;
          }
      }          
      
      //Zur Kontrolle Sensorwerte an PC schicken
      //Liefert nur einen groben Anhaltspunkt, da bei direktem Übertragen die Samplerate viel zu langsam ist.
      //Sinnvoller ist es, in gPuffer aufzuzeichnen und das Aufgezeichnete dann abzurufen.
      void sendePegel()
      {
        
           switch(zaehler)
           {
               case 0:
                   aktualisierePegel();
               break;
               case 10:
                   Serial.print(wert,DEC);
               break;
               case 15:
                   Serial.write('\n');
               break;
               case 20:
                   Serial.write('\r');
               break;
               case 25:
                   Serial1.print(wert,DEC);
               break;
               case 30:
                   Serial1.write('\n');
               break;
               case 35:
                   Serial1.write('\r');
               break;                              
           }           
           
           zaehler++;
           zaehler%=100;
      }                 
} mikrofon;


class mTon
{
    public:
      int frequenz = 0;
      int zaehler = -1;
      int z=0;

      int i=0;
      int anznuller = 0;

      //Idee: alle laufen synchron.
      //Es wird das Vorhandensein eines hohen Tones auf einer Zählzeit erkannt, nicht aber die Tonhöhe und nur, wenn gerade selber nicht gespielt wird.
      
      unsigned char phrase[PHRASENBREITE] = {1,0,0,0,0,0,0,0,0,0,0,0};
//      unsigned char phrase[PHRASENBREITE] = {0,5,6,7,8,0,0,0,0,0,0,0};
//      unsigned char phrase[PHRASENBREITE] = {5,5,5,5,5,5,5,5,5,5,5,0};
//      unsigned char phrase[PHRASENBREITE] = {0,0,0,  0,0,0,  0,0,0,  0,0,0};
      unsigned char nuller[PHRASENBREITE] = {0,0,0,  0,0,0,  0,0,0,  0,0,0};
      int spielindex=0;
      
      void aktivieren()
      {
          //Timer 4 aktivieren mit sehr hoher Frequenz, um damit eine Hüllkurve als unhörbar hohes PWM-Signal realisieren zu können:
          //Timer 4 hat seinen Ausgang auf D6 == OC4D, Dies entspricht PD7 auf PortD 
          
          DDRD |= 0b10000000;
          pinMode(6,OUTPUT);
          digitalWrite(6,LOW);

          //OC4D PWM, Frequenz durch Vorteilung!    
          TCCR4C |= (1<<COM4D1) | (1<<COM4D0) | (1<<PWM4D);  //corrct PWM-Mode, OC4D verbunden, NICHT_OC4D nicht verbunden
          
          //Vorteilung 2 (eigentlich 1)

          TCCR4B &= ~(1<<CS43);
          TCCR4B &= ~(1<<CS42);
          TCCR4B &= ~(1<<CS41);    
          TCCR4B |=  (1<<CS40);    
 
          OCR4D = 0;
    
      }    
      void deaktivieren()
      {
          DDRD &= ~0b10000000;
      }    

      void an(int hertz, int laute)  //leute=0..1023        
      {
          tone(11,hertz);            
          OCR4D = laute;
      }
      
      void aus()
      {
          OCR4D = 0;
          noTone(11);
      }
      
      //Erzeugt einen Ton mit Hüllkurve einer bestimmten Frequenz
      //Setzt voraus, dass die Methode zeitschritt() im Main-Loop eingetragen ist, also ton.zeitschritt()
      void ping(int hertz)
      {
          OCR4D = 0;
          tone(11,hertz);            
          frequenz = hertz;           
          zaehler = 0;
      }
      
      void zeitschritt()
      {
          //Von Uhrzeit abhängig machen, was und wann gepingt wird:
          //(ca. 4ms pro Tick der Uhrzeit, d.h. 250==1s, 60==4x pro Sek, 30==8mal pro sek
          if(gUhrzeit%32==0)
          {
               spielindex = (gUhrzeit>>5)%PHRASENBREITE;
               if(phrase[spielindex]>0)
               {
                   OCR4D = 0;
                   tone(11,phrase[spielindex]*BASISFREQUENZ);            
                   frequenz = phrase[spielindex]*BASISFREQUENZ;           
                   zaehler = 0;
                   
                   nuller[spielindex]=2; //2==eigener Ton
               }                              
               else
               {
                   anznuller = 0;
                   for(i=0;i<100;i++)
                       if(digitalRead(22)==0)      
                           anznuller++;
                   if(anznuller>0)        
                       nuller[spielindex]=1;   //1==fremder Ton     
                   else    
                       nuller[spielindex]=0;        
               }          
                 
                 
               if(spielindex==PHRASENBREITE-1 && gNullerausgabe==true)
               {               
                   //nuller ausgeben:
                   Serial.print("NULLER: ");
                   for(i=0;i<PHRASENBREITE;i++)
                   {
                       Serial.print(nuller[i],DEC);
                       Serial.write(' ');
                   }    
                   Serial.println();
               }
          }
        
          if(zaehler<0 || gTonausgabe==false) //wird nur ausgeführt, wenn ping() verlangt ist.
              return;

         /*
          if(zaehler<4)
              OCR4D = 85*zaehler;
          else if(zaehler<12)
              OCR4D = 255 - 24*(zaehler-4);
          else
              OCR4D = 87 - (zaehler-12)/3;
         */ 
          //OCR4D = 255 - zaehler;
      
          else if(zaehler<10)
              OCR4D = 255 - (zaehler<<4);
          else
              OCR4D = 128 - (zaehler<<2);  //muss bei 255-9*16 == 111 beginnen

      
          zaehler++;
          
          
          if(zaehler>=32)
          {
               zaehler=-1;
               OCR4D = 0;
               noTone(11);
          }    
      }            
} ton;

//Entfernungsmodul ganz unten, um es sonifizieren zu können:
class mEntfernung : public iModul
{
    public:
      int wert = 0;
      int sonowert = 0;
      int sonowert_alt = 0;
      char zaehler=0;   
      
      int aenderung_moeglich = 0;
      
      void aktivieren()
      {
      }    
      void deaktivieren()
      {
      }    
      void aktualisiereEntfernung()      
      {
          wert = analogRead(10);
          //SONIFIKATION
          
          sonowert = wert/50;
          if(sonowert>12)
              sonowert=12;
          if(aenderung_moeglich==0 && sonowert>0 && ton.spielindex>0 && ton.spielindex<PHRASENBREITE)
          {
                if(sonowert!=sonowert_alt)
                {
                    ton.phrase[ton.spielindex] = sonowert;                
                    sonowert_alt = sonowert;
                }
                else
                {
                    ton.phrase[ton.spielindex] = 0;                
                }
                
                aenderung_moeglich = 100;
          }
          
          if(aenderung_moeglich>0)
              aenderung_moeglich--;
              
      }
      
      //Zur Kontrolle Sensorwerte an PC schicken
      void sendeEntfernung()
      {
           switch(zaehler)
           {
               case 0:
                   aktualisiereEntfernung();
               break;
               case 10:
                   Serial.print(wert,DEC);
               break;
               case 15:
                   Serial.write('\n');
               break;
               case 20:
                   Serial.write('\r');
               break;
               case 25:
                   Serial1.print(wert,DEC);
               break;
               case 30:
                   Serial1.write('\n');
               break;
               case 35:
                   Serial1.write('\r');
               break;                              
           }           
           
           zaehler++;
           zaehler%=100;
      }      
} entfernung;


class mLaden : public iModul
{
   public:
      int ladestrom = 0;
      
      void aktivieren()
      {
      }
      void deaktivieren()
      {
      }
      
      void aktualisiereLadestrom()
      {
          ladestrom = analogRead(8);    
      }

      bool ladespule()
      {
           if(ladestrom<25)
               return true;
           else 
               return false;    
      }

     void sendeLadestrom()      
     {
           Serial.print(ladestrom,DEC);
           Serial.write('\n');
           Serial.write('\r');
     }
} laden;
