//Strommessung an den Polen der Motoren
/*
    Beispiele für Stromsensor:
  LINKS     RECHTS
    alle aus
     0  0  0  0
    10 10 10 10 
strom 0 1 2 3    
    Beide Motoren vorwärts, nicht blockiert:
    50 900 900 400
    80 950 950 450
    Beide Motoren vorwärts aber blockiert:
    250 700 700 400
    300 750 750 450
    
    Beide Motoren rückwärts, nicht blockiert:
    900 470 130 880
    960 460 112 920
    Beide Motoren rückwärts aber blockiert:
    750 550 270 690
    730 490 320 700
*/
class mStrom : public iModul
{
   public:
      char stromzaehler=0;
      int strom0 = 0;
      int strom1 = 0;
      int strom2 = 0;
      int strom3 = 0;      
      
      void aktivieren()
      {
      }
      void deaktivieren()
      {
      }
      
      void aktualisiereStrom()
      {
         switch(stromzaehler)
         {
            case 0:
                strom0 = analogRead(0);
            break;
            case 1:
                strom1 = analogRead(1);
            break;
            case 2:
                strom2 = analogRead(2);
            break;
            case 3:
                strom3 = analogRead(3);
            break;
         }
    
        stromzaehler++;
        stromzaehler%=4;
     }

     bool linksBlockiert()
     {
           if(gLinks>0 && strom1<BLOCKADESCHWELLE)
               return true;
           else if(gLinks<0 && strom0<BLOCKADESCHWELLE)
               return true;
           else     
               return false;
     }

     bool rechtsBlockiert()
     {
           if(gRechts>0 && strom2<BLOCKADESCHWELLE)
               return true;
           else if(gRechts<0 && strom3<BLOCKADESCHWELLE)
               return true;
           else     
               return false;
     }

     bool blockiert()
     {
           if(gLinks>0 && strom1<BLOCKADESCHWELLE)
               return true;
           else if(gLinks<0 && strom0<BLOCKADESCHWELLE)
               return true;
               
           if(gRechts>0 && strom2<BLOCKADESCHWELLE)
               return true;
           else if(gRechts<0 && strom3<BLOCKADESCHWELLE)
               return true;

           return false;               
     }

     void sendeStrom()      
     {
           Serial.print(strom0,DEC);
           Serial.write(' ');
           Serial.print(strom1,DEC);
           Serial.write(' ');
           Serial.print(strom2,DEC);
           Serial.write(' ');
           Serial.print(strom3,DEC);
           Serial.write('\n');
           Serial.write('\r');
           
           if(linksBlockiert())
               gruenblau.anGruen();
           else
               gruenblau.ausGruen();
               
           if(rechtsBlockiert())
               gruenblau.anBlau();
           else
               gruenblau.ausBlau();
     }
} strom;
