//Die Sprache:
// 16 Byte pro Zeile.
// 0.:   00..99 Strategie/Zustand, für den die nachfolgenden Übergangsbedingungen formuliert sind.
// 1.:   00..99 Ziel-Strategie, zu der unter den nachfolgend verknüpften Bedingungen gewechselt wird
// 2.:   &00..&99 |00..|99  danach die Nummer der Bedingung, NICHT-Bedingungen könnten immer ungerade Nummern sein, z.B. 0==Sensor liefert Werte, 1==Sensor liefert keine Werte.
// 3.:   Die erste Bedingung benötigt keinen Buchstaben. Somit gibt es pro Zeile 1xStrategie, 1xZiel und maximal 4xBedingungen
// 4.:   Als Lückenfüller, wenn nur eine Bedingung nötig ist:  & 00 == & TRUE, einfach alle 00 als TRUE definieren. & 01 wäre dann & FALSE => terminierender Zustand!
//
// Beispiel für diese Syntax:
//
// 070212&00|01&08;
//
// Beim seriellen Einlesen von Befehle und beim dump werden Leerzeichen und ungültige Zeichen überlesen, bzw. werden zur besseren Lesbarkeit ergänzt:
//
// 07 02 12 & 00 | 01 & 08
//
// Irgendwie muß man damit dann auskommen, oder nötigenfalls die Syntax erweitern, so gibt es hier keine Klammerung, Default sollte sein:
// ((((q | r) & s) | t) &~u)  usw., also so als wären die aufeinanderfolgenden Bedingungen in einander geschachtelt.
// Das macht es manchmal nötig, diese richtig in der Reihenfolge zu sortieren.

//ev. nur Nummern 0..9 zulassen und zweite Nummer als Parameter verwenden (?)

//Die vorangestellten Buchstaben dienen zur besseren Lesbarkeit und als Kontrollzeichen.

//Wieviele Programme sind möglich, wenn es 128 Byte gibt, also 8 Zeilen ?
//1 Zeile: 100 Zustände * 100 Ziele .... 

//o.k. in erster version stark reduzieren:
//10 Zustände, 10 Ziele, 10 Bed.
// 0..9 0..9  :!   0..9 &| 0..9 &| 0..9  //d.h. 8Byte => 1xStrategie, 1xZielstrategie , bis zu 3x Bed.
// NEU: : "wenn nachfolgende Verknüpfungen logisch true ergeben" ! "wenn nachfolgende Verknüpfungen logisch false ergeben"
// Möglichkeiten pro Zeile: 10*10* 2*  10*2*10*2*10 == 800000 mögliche Varianten pro Zeile.
// Bei 8 Zeilen => 64000000 Programmvarianten
//Beispiel
//
//  14:3&0|2
//
// Bei 16 Zeilen: 


class Interpreter
{
      public:
          bool AKTIV = false;
          int index = 0;
          char nr_strategie;
          char nr_ziel;
          bool INVERS;
          char nr_bed1;
          bool UNDODER12;
          char nr_bed2;
          bool UNDODER23;
          char nr_bed3;
          
          int i;

          int aktuelle_strategie_nummer = -1;

          bool ERFUELLT;
          
          bool aktivieren()
          {
              index = 0;  //Index in EEPROM, wie gPuffer: PUFFERGROESSE
              AKTIV = true;
              aktuelle_strategie_nummer = 0;
              //initiale Strategie laden:
              //Ohne dies wird kein loop durchgeführt und der Zähler erreicht nie den kritischen Wert für einen Wechsel.
              //Sicherer: Zuerst im Programm auftretende Strategie nehmen!
              strategie = strategien[aktuelle_strategie_nummer];
          }
          
          bool deaktivieren()
          {
              AKTIV = false;
          }
      
          bool zeitschritt()
          {
              //Quasi ganz kurz Ruhezustand einnehmen, damit Fahrzeug nicht ungeregelt herumdriftet!
              antrieb.fahrt(0,0);
            
              while(index<PUFFERGROESSE && AKTIV==true)
              {
                  //Nächsten Befehl holen    
                  nr_strategie = EEPROM.read(index)-48;  
                  if(nr_strategie<0 || nr_strategie>=ANZSTRATEGIEN)
                      return false;
                  index++;
                  nr_ziel      = EEPROM.read(index)-48;  
                  if(nr_ziel<0 || nr_ziel>=ANZSTRATEGIEN)
                      return false;
                  index++;
                  if(EEPROM.read(index)==':')
                      INVERS=false;                     
                  else if(EEPROM.read(index)=='!')
                      INVERS=true;                     
                  else
                      return false;    
                  index++;
                  nr_bed1       = EEPROM.read(index)-48;                 
                  if(nr_bed1<0 || nr_bed1>=ANZBEDINGUNGEN)
                      return false;
                  index++;    
                  if(EEPROM.read(index)=='&')    
                      UNDODER12 = true;
                  else if(EEPROM.read(index)=='|')    
                      UNDODER12 = false;
                  else
                      return false;
                  index++;    
                  nr_bed2       = EEPROM.read(index)-48;                 
                  if(nr_bed2<0 || nr_bed2>=ANZBEDINGUNGEN)
                      return false;
                  index++;    
                  if(EEPROM.read(index)=='&')    
                      UNDODER23 = true;
                  else if(EEPROM.read(index)=='|')    
                      UNDODER23 = false;
                  else
                      return false;
                  index++;                      
                  nr_bed3       = EEPROM.read(index)-48;                 
                  if(nr_bed3<0 || nr_bed3>=ANZBEDINGUNGEN)
                      return false;
                  index++;  
                  //ENDE nächsten Befehl laden.  
                  
                  
                  //Testausgabe, um den Interpreter zu überprüfen (in main-Loop verlangsamen!)
                  /*
                  Serial.println("***** NEUER BEFEHL AUS EEPROM *****");
                  Serial.print("Aktuelle Strategie:   ");                  
                  Serial.println(aktuelle_strategie_nummer,DEC);
                  Serial.print("Strategie in Befehl:  ");
                  Serial.println(nr_strategie,DEC);
                  Serial.print("Ziel-Strategie     :  ");
                  Serial.println(nr_ziel,DEC);
                  Serial.print("Nr. Bedingung 1    :  ");
                  Serial.println(nr_bed1,DEC);
                  Serial.print("Nr. Bedingung 2    :  ");
                  Serial.println(nr_bed2,DEC);
                  Serial.print("Nr. Bedingung 3    :  ");
                  Serial.println(nr_bed3,DEC);
                  Serial.print("index EEPROM       :  ");
                  Serial.println(index,DEC);
                  */
                  //Prüfen, ob der aktuelle Befehl ausgeführt werden muß:
                  //Dazu muß die aktuelle Strategienummer mit der am Befehlsanfang übereinstimmen:                  
                  if(aktuelle_strategie_nummer==nr_strategie)
                  {
//Testausgabe (später entfernen!)                    
//Serial.println(">>>>>>>>>>>>>> Befehl wird ausgefuehrt");
                    
                        //Prüfen, ob die aktuell verlangte Verknüpfung an Bedingungen TRUE oder FALSE ist:
                        if(UNDODER12==true)
                            ERFUELLT = (bedingungen[nr_bed1]->pruefen()) && (bedingungen[nr_bed2]->pruefen());
                        else    
                            ERFUELLT = (bedingungen[nr_bed1]->pruefen()) || (bedingungen[nr_bed2]->pruefen());
                            
                        if(UNDODER23==true)
                            ERFUELLT = ERFUELLT && (bedingungen[nr_bed3]->pruefen());
                        else    
                            ERFUELLT = ERFUELLT || (bedingungen[nr_bed3]->pruefen());
                            
                        if(INVERS==true)                            
                            ERFUELLT=!ERFUELLT;
                            
                        if(ERFUELLT==true)    //Wenn Bedingen erfüllt, dann zu Zielzustand übergehen
                        {
//Testausgabe (später entfernen!)                    
//Serial.println("<<<<<<<<<<<<< Bedingung in Befehl ist erfuellt, Wechsel zu Zielstrategie");
                          
                            aktuelle_strategie_nummer = nr_ziel;
                            strategie = strategien[nr_ziel];
                            //neue Strategie initialisieren:
                            strategie->reset(); //bei Wexhselblinker um zaehler zurückzusetzen
                            
                        }
                        
                        //Sobald ein Befehl gefunden wird, der mit der aktuellen Strategie korrespondiert, 
                        //wird dessen Bedingung überprüft und auch dann die Suche abgebrochen (und beim nächsten Zeitschritt wiederholt), wenn die Bedingungen NICHT erfüllt sind.
                        //Es darf nämlich nur EINEN Befehl pro Strategie geben!
                        index=0; //zurücksetzen, damit beim nächsten Durchgang das EEPROM von vorn durchsucht wird.                          
                        return true; //nicht weiter die Befehle durchgehen, wenn erster mit aktueller Nummer gefunden wurde.                                          
                  }
              }
              
              return false; //Kein Befehl zum ausführen gefunden.
          }
} interpreter;
