/*  Im Gegensatz zu Zustand, der geloopt wird, wird das, was in der perform()-Methode steht nur genau einmal ausgeführt.
*/
class iBefehl
{
     public:
         virtual void perform() = 0;
         virtual void konfigurieren(char a, char b, char c, char d) = 0;         
         virtual char getPanz() = 0;         
};

class iModul
{
    public:
        virtual void aktivieren()   = 0;
        virtual void deaktivieren() = 0;
};

/* Im Sinne der synchronen Programmierung entspricht loop() einer Methode, die zyklisch aufgerufen wird
   und die zeitlich synchronisierte Befehle in Abhängigkeit des Zählzustandes des Schedulers ausführt.
*/
class iNachricht
{
     public:
         virtual void reagieren() = 0;
         virtual void konfigurieren(char a, char b, char c, char d) = 0;
         virtual char getPanz() = 0;         
         
};

/* Im Sinne der synchronen Programmierung entspricht loop() einer Methode, die zyklisch aufgerufen wird
   und die zeitlich synchronisierte Befehle in Abhängigkeit des Zählzustandes des Schedulers ausführt.
*/
class iZustand
{
     public:
         virtual void loop() = 0; //Zyklisch ausgeführte Methode
         virtual void konfigurieren(char a, char b, char c, char d) = 0; //bietet die Möglichkeit die Ausführungsart eines Zustands anzupassen, z.B. PID-Regler.
         virtual char getPanz() = 0;                  
};

//Für Interpreter:

//ähnlich Zustand, aber einfacher:
class iStrategie
{
     public:
         virtual void reset() = 0; //Anfangszustand einnehmen
         virtual void loop() = 0; //Zyklisch ausgeführte Methode
};

class iBedingung
{
     public:
         virtual bool pruefen() = 0; //Bedingung mit Parameter a, liefert, ob die Bedingung erfüllt ist oder nicht.
};

