//Hilfsmethoden, die global verfügbar sein sollen
//und z.B. von den Befehlenn und Zuständen benutzt wernden können.

//Schickt an Seriell und Seriell1 den globalen Puffer gPuffer
//Da die Skriptsprache mit Zeilen a 8 Zeichen arbeitet, wird
//der Inhalt genau so gebrochen.
void sendePufferASCII()
{
    int i;
    for(i=0;i<PUFFERGROESSE;i++)
    {
          if(i>0 && i%8==0)
          {
              Serial.write('\n');
              Serial.write('\r');
          }    
          Serial.write(gPuffer[i]);
    }
    for(i=0;i<PUFFERGROESSE;i++)
    {
          if(i>0 && i%8==0)
          {
              Serial1.write('\n');
              Serial1.write('\r');
          }    
          Serial1.write(gPuffer[i]);
    }
}

//...Darstellung der Bytes im Puffer als Dezimalzahlen:
void sendePufferDEC()
{
    int i;
    for(i=0;i<PUFFERGROESSE;i++)
    {
          if(i>0 && i%8==0)
          {
              Serial.write('\n');
              Serial.write('\r');
          }    
          Serial.print(gPuffer[i],DEC);
          Serial.write(' ');
    }
    for(i=0;i<PUFFERGROESSE;i++)
    {
          if(i>0 && i%8==0)
          {
              Serial1.write('\n');
              Serial1.write('\r');
          }    
          Serial1.print(gPuffer[i],DEC);
          Serial1.write(' ');
    }
}

//Liest von Infrarot den kompletten Puffer von einer Quelle ein.
//Abbruch mit false bei Timeout
bool lesePufferASCII_IR()
{
    int i=0;
    char c=0;
    unsigned int zaehler=0;

    gZaehler=0;
    while(true)
    {
         if(Serial1.available())
         {
             c = Serial1.read();
             
             //Unsichtbare Zeichen überlesen!
             if(  (c>='0' && c<='9') || (c>='A' && c<='Z') || (c>='a' && c<='z')
                  || c=='+' || c=='-' || c=='*' || c=='/' || c=='.' || c==',' || c==':' || c==';' || c=='#' || c=='$' || c=='?'
                  || c=='!' || c=='(' || c==')' || c=='[' || c==']' || c=='{' || c=='}' || c=='|' || c=='&' || c=='<' || c=='>' )
             {     
                 gPuffer[i] = c;
                 i++;
             }
         }
         
         if(gZaehler>HALBMAXZAEHLER)  //60kHz pro Tick, 127Tichs => 0,00212 Sekunden pro Zählschritt, somit 4000 Zählschritte == 8Sekunden
         {
              gZaehler=0;
              zaehler++;
         }
         
         if(i>=PUFFERGROESSE)
             return true;
             
         if(zaehler>=4000)    //Hauptschleife geht nicht mehr, deshalb gUhrzeit nicht verfügbar (korrumpiert gUhrzeit)!
             return false;
    }    
}

//Liest über Kabel den kompletten Puffer von einer Quelle ein.
//Abbruch mit false bei Timeout
//Liefert die Anzahl der geladenen Zeichen zurück.
int lesePufferASCII_KABEL()
{
    int i=0;
    char c=0;
    unsigned int zaehler=0;

    gZaehler=0;
//############################################    
    Serial.print("Uebernommene Zeichen:");
    while(true)
    {
         if(Serial.available())
         {
             c = Serial.read();
             
             //Unsichtbare Zeichen überlesen!
             if(  (c>='0' && c<='9') || (c>='A' && c<='Z') || (c>='a' && c<='z')
                  || c=='+' || c=='-' || c=='*' || c=='/' || c=='.' || c==',' || c==':' || c==';' || c=='#' || c=='$' || c=='?'
                  || c=='!' || c=='(' || c==')' || c=='[' || c==']' || c=='{' || c=='}' || c=='|' || c=='&' || c=='<' || c=='>' )
             {     
                 gPuffer[i] = c;
//############################################    
                 Serial.print(c);
                 i++;
             }
         }
         
         if(gZaehler>HALBMAXZAEHLER)  //60kHz pro Tick, 127Tichs => 0,00212 Sekunden pro Zählschritt, somit 4000 Zählschritte == 8Sekunden
         {
              gZaehler=0;
              zaehler++;
         }
         
         if(i>=PUFFERGROESSE)
             return i;
             
         if(zaehler>=4000)    //Hauptschleife geht nicht mehr, deshalb gUhrzeit nicht verfügbar (korrumpiert gUhrzeit)!
             return i;
    }
//############################################    
    //Testausgaben, ev. entfernen.    
    Serial.println();
    Serial.println("Uebertragung auf Puffer beendet.");
    return i;
}

//gPuffer wird auf dem EEPROM gesichert
void schreibePufferAufEEPROM()
{
    int i;
    char c=0;
    for(i=0;i<PUFFERGROESSE;i++)
    {
        c = EEPROM.read(i);
        if(c!=gPuffer[i])        //Nur schreiben, wenn nötig
            EEPROM.write(i,gPuffer[i]);
        //EEPROM.update(i,gPuffer[i]); //schonender als write, da nur bei Unterschied geschrieben wird. (Nicht verfügbar?!)
    }    
}


void lesePufferVonEEPROM()
{
    int i;
    for(i=0;i<PUFFERGROESSE;i++)
        gPuffer[i] = EEPROM.read(i);
}

bool schreibeTestprogrammAufEEPROM()
{
    int i;
    int ii;
    char c=0,d=0;
    bool irgend_ein_zeichen_anders = false;
    bool zeichen_uebrig = true;
    ii=0; //Zum Überlesen von Blanks
    for(i=0;i<PUFFERGROESSE;i++)
    {
        c = EEPROM.read(i);
        if(zeichen_uebrig==true)
        {
              d = testprogramm[ii];
              ii++;
              //Nur Zeichenvorrat der Skriptsprache berücksichtigen, insbesondere Blanks überlesen.
              while(d!='0' && d!='1' && d!='2' && d!='3' && d!='4' && d!='5' && d!='6' && d!='7' && d!='8' && d!='9' && d!=':' && d!='!' && d!='&' && d!='|' && d!='\0')
              {
                  d = testprogramm[ii];
                  ii++;            
              }
                  
              
              if(d=='\0')
              {
                  zeichen_uebrig = false;
                  d=' ';
              }
              
                  
        }
        else
        {
              d=' '; //Defaultwert Leerzeichen, wenn Programm nicht den gesamten Puffer ausfüllt.
              
              //ACHTUNG: Befehlszeile muß wirklich 8 Byte lang sein, also dürfen keine Bedingungen weggelassen werden.
              //         Nötigenfalls Dummy-Bedingungen &TRUE (0) oder |FALSE (1) ergänzen, vergl. bedingungen.h
        }
        if(c!=d)        //Nur schreiben, wenn nötig
        {
            EEPROM.write(i,d);
            irgend_ein_zeichen_anders=true;
        }    
        //EEPROM.update(i,gPuffer[i]); //schonender als write, da nur bei Unterschied geschrieben wird. (Nicht verfügbar?!)
    }    
    
    //true, wenn mindestens ein Zeichen geschrieben werden mußte:
    return irgend_ein_zeichen_anders;
}

//Oft "zappeln" Sensordaten hin und her, oder man will nicht wissen, ob ein Wert aktuell
//einen bestimmten Wert hat, sondern ober meistens diesen Wert in den letzten Sekunden hatte.
//Um dieses Problem allgemein zu lösen, dient die nachfolgende Klasse.
//Von ihr sollte bei Bedarf geerbt werden.
//Das Problem wird auf die zeitliche Dämpfung einer boolschen Variable reduziert.
//Die Dämpfungsperiode in Ticks ist in der Konstanten DAEMPFUNGSPERIODE_IN_TICKS abgelegt.
//
//Die Dämpfung ist konservativ eingestellt: in der Dämpfungsperiode müssen mindestens 80% der
//Bitzustände anders sein als der aktuelle, damit dieser in den anderen wechselt.
//
class Bitdamper
{
    private:    
        bool bit_aktuell = false;
        bool bit_damped  = false;
        
        int anteil=0;        
        int index_verlauf=0;                
    public:
        void setzen()
        {
              bit_aktuell = true;
        }
        void loeschen()
        {
              bit_aktuell = false;
        }
        
        bool istGesetztD() //gedämpften Wert zurückgeben
        {
              return bit_damped;
        }
        
        void zeitschritt() //Muss im Main-Loop zyklisch aufgerufen werden, sonst funktioniert das Ganze nicht.
        {
              if(bit_aktuell==true)
                  anteil++;
              
              if(index_verlauf>=DAEMPFUNGSPERIODE_IN_TICKS)//Nur nach Ablauf der Dämpfungsticks Zustand neu überprüfen
              {
                  if(bit_damped==false && anteil>=DAEMPFUNGS_SCHWELLE_ABSOLUT)
                      bit_damped=true;
                  else if(bit_damped==true && DAEMPFUNGSPERIODE_IN_TICKS-anteil>=DAEMPFUNGS_SCHWELLE_ABSOLUT)
                      bit_damped=false;
                
                  anteil = 0;                  
              }            
              
              index_verlauf++;              
        }
};




