
//*****************
//IMPLEMENTIERUNGEN
//*****************

//LED-Befehle
class bGruenAn : public iBefehl
{
  public:
    void perform()
    {
          //Nur bei diesem Befehl die Zustände deaktivieren!!!
          //AUSSERDEM Uhrzeit RESET, QUASI Synchronstart
          //***********************
          zustand = 0;
          antrieb.fahrt(0,0);
          gUhrzeit = 0;
          
          //NEU:
          //Auch Interpreter stoppen:
          interpreter.deaktivieren();

          //***********************
          gruenblau.anGruen();
          Serial.write("GRUEN AN\n\r");
    }
    char getPanz(){         return 0;    }
    void konfigurieren(char a, char b, char c, char d){   }
} bgruenan;

class bGruenAus : public iBefehl
{
  public:
    void perform()
    {
          gruenblau.ausGruen();
          Serial.write("GRUEN AUS\n\r");
    }
    char getPanz(){         return 0;    }
    void konfigurieren(char a, char b, char c, char d){   }
} bgruenaus;

class bBlauAn : public iBefehl
{
  public:
    void perform()
    {
          gruenblau.anBlau();
          Serial.write("BLAU AN\n\r");
    }
    char getPanz(){         return 0;    }
    void konfigurieren(char a, char b, char c, char d){   }
} bblauan;

class bBlauAus : public iBefehl
{
  public:
    void perform()
    {
          gruenblau.ausBlau();
          Serial.write("BLAU AUS\n\r");
    }
    char getPanz(){         return 0;    }
    void konfigurieren(char a, char b, char c, char d){   }
} bblauaus;

//Antriebs-Befehle
class bFahrt : public iBefehl
{
     public:
         char richtungLinks, richtungRechts;
         int links,rechts;
         void perform()
         {
              if(richtungLinks=='v') 
                  links=255;
              else if(richtungLinks=='r')    
                  links=-255;
              else
                  links=0;    
                  
              if(richtungRechts=='v') 
                  rechts=255;
              else if(richtungRechts=='r')    
                  rechts=-255;
              else
                  rechts=0;    

              antrieb.fahrt(links,rechts);                  
         }
         char getPanz(){         return 2;    }
         void konfigurieren(char a, char b, char c, char d)
         {   
              richtungLinks  = a;  //v==vorwärts, r==rückwärts, h==halten
              richtungRechts = b;
         }         
} bfahrt;

//Kurzbefehle für den Antrieb für die Infrarot-Übertragung
class bVor : public iBefehl
{
     public:
         void perform(){ antrieb.fahrt(255,255); }
         char getPanz(){         return 0;    }
         void konfigurieren(char a, char b, char c, char d){}
} bvor;
class bRueck : public iBefehl
{
     public:
         void perform(){ antrieb.fahrt(-255,-255); }
         char getPanz(){         return 0;    }
         void konfigurieren(char a, char b, char c, char d){}
} brueck;
class bLinks : public iBefehl
{
     public:
         void perform(){ antrieb.fahrt(-255,255); }
         char getPanz(){         return 0;    }
         void konfigurieren(char a, char b, char c, char d){}
} blinks;
class bRechts : public iBefehl
{
     public:
         void perform(){ antrieb.fahrt(255,-255); }
         char getPanz(){         return 0;    }
         void konfigurieren(char a, char b, char c, char d){}
} brechts;
class bStop : public iBefehl
{
     public:
         void perform(){ antrieb.fahrt(0,0); }
         char getPanz(){         return 0;    }
         void konfigurieren(char a, char b, char c, char d){}
} bstop;



class bTonan : public iBefehl
{
     public:
         char a = 0;
         char b = 0;
         void perform()
         { 
             ton.an((a-48)*100,(b-48)*28); //0..255 bei Lautstaerke möglich, deshalb 255/9~=28
             Serial.print(" a=");
             Serial.write(a);
             Serial.print(" b=");
             Serial.write(b);
             Serial.println();
         }  //i mal 100Hz, da ASCII-Ziffern bei 48 beginnen, diese abziehen!
//         void perform(){ ton.an(1000,1023); }  //i mal 100Hz, da ASCII-Ziffern bei 48 beginnen, diese abziehen!
         char getPanz(){         return 2;    }
         void konfigurieren(char a, char b, char c, char d)
         {
              this->a = a;
              this->b = b;
         }
} btonan;

class bTonaus : public iBefehl
{
     public:
         void perform(){ ton.aus(); }
         char getPanz(){         return 0;    }
         void konfigurieren(char a, char b, char c, char d){}
} btonaus;


class bNullerausgabeAn : public iBefehl
{
     public:
         void perform(){ gNullerausgabe=true; }
         char getPanz(){         return 0;    }
         void konfigurieren(char a, char b, char c, char d){}
} bnullerausgabean;

class bNullerausgabeAus : public iBefehl
{
     public:
         void perform(){ gNullerausgabe=false; }
         char getPanz(){         return 0;    }
         void konfigurieren(char a, char b, char c, char d){}
} bnullerausgabeaus;

class bTonausgabeAn : public iBefehl
{
     public:
         void perform(){ gTonausgabe=true; }
         char getPanz(){         return 0;    }
         void konfigurieren(char a, char b, char c, char d){}
} btonausgabean;

class bTonausgabeAus : public iBefehl
{
     public:
         void perform(){ gTonausgabe=false; }
         char getPanz(){         return 0;    }
         void konfigurieren(char a, char b, char c, char d){}
} btonausgabeaus;

class bMotorRichtigJA : public iBefehl
{
     public:
         void perform(){ gMotorRichtig=true; }
         char getPanz(){         return 0;    }
         void konfigurieren(char a, char b, char c, char d){}
} bmotorrichtigja;

class bMotorRichtigNEIN : public iBefehl
{
     public:
         void perform(){ gMotorRichtig=false; }
         char getPanz(){         return 0;    }
         void konfigurieren(char a, char b, char c, char d){}
} bmotorrichtignein;


class bSchreibeTestprogrammAufEEPROM : public iBefehl
{
     public:
         void perform()
         {  
             //Skript-Programm bereitstellen:
             if(schreibeTestprogrammAufEEPROM()==true)    
                 Serial.println("Testprogramm wurde auf EEPROM geschrieben.");
             else    
                 Serial.println("Testprogramm auf EEPROM ist aktuell.");             
         }
         char getPanz(){         return 0;    }
         void konfigurieren(char a, char b, char c, char d){}
} bschreibetestprogrammaufeeprom;

class bStartInterpreter : public iBefehl
{
     public:
         void perform()
         { 
              interpreter.aktivieren(); 
              Serial.println("Inpterpreter gestartet.");
         }
         char getPanz(){         return 0;    }
         void konfigurieren(char a, char b, char c, char d){}
} bstartinterpreter;

class bStopInterpreter : public iBefehl
{
     public:
         void perform()
         { 
              interpreter.deaktivieren();
              Serial.println("Inpterpreter beendet.");
         }
         char getPanz(){         return 0;    }
         void konfigurieren(char a, char b, char c, char d){}
} bstopinterpreter;

//Programm in das EEPROM über serielle Kabelverbindung laden.
//Das Programm sollte in einer Datei verfügbar sein und kann über den Seriellen Monitor von Arduino an das Board geschickt werden.
class bLadeProgrammKabel : public iBefehl
{
     public:
         int geladen = 0;
         int i;
         char c;
         int fehler;
         void perform()
         { 
              interpreter.deaktivieren(); //Sicherheitshalber
              
              //Speicherplatz sparen
              //Serial.println("1. Inpterpreter beendet.");
              
              Serial.println("Jetzt Programmdatei an TURTLE senden.");

              geladen = lesePufferASCII_KABEL();

              //Um Speicherplatz zu sparen diesen Teil weglassen:
              /*         
              if(geladen==PUFFERGROESSE)              
              {
                  Serial.println("Erfolg! - Das Programm steht jetzt in gPuffer");
                  
              }
              else
              {
                  Serial.println("Timeout! - Geladene Zeichen fuellen nicht den ganzen Puffer");
                  Serial.print("Es wurden ");
                  Serial.print(geladen,DEC);
                  Serial.println("relevante Zeichen geladen.");
              }
              */
              
              //Speicherplatz sparen
              //Serial.println("Syntaxpruefung:");
              if(geladen==0)
              {
                  Serial.println("ABBRUCH: Keine Zeichen geladen!");
                  return;
              }
              if(geladen%8!=0)
              {
                  Serial.println("ABBRUCH: Anzahl der Zeichen nicht durch 8 teilbar!");
                  return;
              }

              fehler=0;
              for(i=0;i<geladen;i++)
              {
                   c=gPuffer[i];
                   if(i%8==0 && (c<'0' || c>'9')) fehler++;
                   if(i%8==1 && (c<'0' || c>'9')) fehler++;
                   if(i%8==2 && (c!=':' && c!='!')) fehler++;
                   if(i%8==3 && (c<'0' || c>'9')) fehler++;
                   if(i%8==4 && (c!='&' && c!='|')) fehler++;
                   if(i%8==5 && (c<'0' || c>'9')) fehler++;
                   if(i%8==6 && (c!='&' && c!='|')) fehler++;
                   if(i%8==7 && (c<'0' || c>'9')) fehler++;                                          
              }              
              
              if(fehler>0)
              {
                   Serial.print(fehler,DEC);
                   Serial.println(" Fehler! - ABBRUCH");
                   return;
              }
              //Serial.println("Es wurden keine Syntaxfehler gefunden.");
              Serial.println("Keine Fehler - Programm wird von gPuffer auf EEPROM uebertragen.");                  
              schreibePufferAufEEPROM();
                  
              Serial.println("Programm jetzt mit $19 testbar.");                  
              
         }
         char getPanz(){         return 0;    }
         void konfigurieren(char a, char b, char c, char d){}
} bladeprogrammkabel;

