#include "Arduino.h"

#define REMOTEPUFFER 17

class Remote : public iModul
{
     public:
         char index_intern;
         char index_infrarot;
         char index_kabel;
         char a,b,c,d,i,k,nummer,panz;
         char puffer_intern[REMOTEPUFFER];   //geringste Priorität
         char puffer_infrarot[REMOTEPUFFER]; //mittlere Priorität
         char puffer_kabel[REMOTEPUFFER];    //höchste Priorität
         char* puffer; //Hilfszeiger, um immer den richtigen Puffer zur Verfügung zu stellen
         bool auftrag_gefunden = false;

         bool ZEICHEN_EMPFANGEN = false; //Um in zeitschritt() nur den Puffer zu untersuchen, wenn mindestens ein Zeichen angekommen ist!
         
         void initTimer1()
         {
           TCCR1B &= ~(1<<WGM13); //Mode 4
           TCCR1B |= (1<<WGM12);
           TCCR1A &= ~(1<<WGM11);
           TCCR1A &= ~(1<<WGM10);
    
           //Vorteilung 1: 16000000Hz
           TCCR1B &= ~(1<<CS12);
           TCCR1B &= ~(1<<CS11);
           TCCR1B |= (1<<CS10);
    
           //f = fclk/(2*N*(OCR1A+1))
           //OCR1A = (fclk/(f*2*N))-1
           //OCR1A = 8000000/440 - 1 ==  18181
           //KORRIGIERT:
           //********************************
           //OCR1A = 4000000/440 - 1 ==  9091
           //OCR1A = 16000000/(f*4*N) - 1 ==  9091
           //********************************
           //OCR1A=9091;  //0,5Hz == 4 Schläge!
         //  OCR1A=132;  //0,5Hz == 4 Schläge!
           OCR1A=264;  //0,5Hz == 4 Schläge!
  
           //Kann man da nicht jetzt auch einen Zähler im Interrupt laufen lassen???
  
           //Toggle auf OC1A:
           TCCR1A &= ~(1<<COM1A1);
           TCCR1A |=  (1<<COM1A0);
           pinMode(9,OUTPUT);    
         
           //Aktivierung der ISR:
           TIMSK1 |= (1<<OCIE1A); //Mode 4
           sei();  
         }         
         
         void aktivieren()
         {
               //30kHz mittels Timer 1 auf D9 / OC1A
               initTimer1();  
               
               //PB2 sicher deaktivieren, da als toter Pin für IR-Anode benötigt:
               //DDRB &= ~0b00000100;     //#### NICHT MEHR NÖTIG BEI NEUEM FAHRZEUG ####
               
               //Spannungsversorgung IR-Sensor:
               //pinMode(22,OUTPUT);  //A4  NICHT MEHR RICHTIG BEI NEUEM FAHRZEUG, DA A4 mit Mikrofon verbunden wird!, Masse ist jetzt direkt verbunden!
               pinMode(23,OUTPUT);  //A5  
               //digitalWrite(22,LOW); //A4  NICHT MEHR RICHTIG BEI NEUEM FAHRZEUG, DA A4 mit Mikrofon verbunden wird!
               digitalWrite(23,HIGH); //+5 Volt Stromversorgung
               
               
               Serial.begin(BAUDRATE);  //Kabelverbindung
               Serial1.begin(BAUDRATE); //Infrarot-Verbindung
               index_intern=0;
               index_infrarot=0;
               index_kabel=0;
               
               for(k=0;k<3;k++)
               {
                     if(k==0)
                         puffer = puffer_kabel;
                     else if(k==1)    
                         puffer = puffer_infrarot;
                     else
                         puffer = puffer_intern;
                         
                     for(i=0;i<REMOTEPUFFER;i++)
                         puffer[i]=' ';
               }
         }
         
         void deaktivieren()
         {
               Serial.end();  //Kabelverbindung
               Serial1.end(); //Infrarot-Verbindung
               index_intern=0;
               index_infrarot=0;
               index_kabel=0;

               //Spannungsversorgung IR-Sensor deaktivieren:
               //digitalWrite(22,LOW);
               digitalWrite(23,LOW);
               //pinMode(22,INPUT);  //A4
               pinMode(23,INPUT);  //A5  

               
               for(k=0;k<3;k++)
               {
                     if(k==0)
                         puffer = puffer_kabel;
                     else if(k==1)    
                         puffer = puffer_infrarot;
                     else
                         puffer = puffer_intern;
                         
                     for(i=0;i<REMOTEPUFFER;i++)
                         puffer[i]=' ';
               }
         }

         void setzePuffer(const char* text)
         {
             i=0;
             while(text[i]!='\0')               
             {
                   puffer_intern[index_intern] = text[i];
                   i++;
                   index_intern++;
                   index_intern%=REMOTEPUFFER;
             }
             ZEICHEN_EMPFANGEN = true; //Aktiv setzen, damit Puffer in zeitschritt() untersucht wird!
         }
         
         
         void zeitschritt()
         {
               while(Serial.available())
               {
                     puffer_kabel[index_kabel] = Serial.read();
                     index_kabel++;
                     index_kabel%=REMOTEPUFFER;
                     ZEICHEN_EMPFANGEN=true;
               }
               while(Serial1.available())
               {
                     puffer_infrarot[index_infrarot] = Serial1.read();
                     index_infrarot++;
                     index_infrarot%=REMOTEPUFFER;
                     ZEICHEN_EMPFANGEN=true;
               }

               if(ZEICHEN_EMPFANGEN==false)
                   return;
                   
               ZEICHEN_EMPFANGEN=false;    

               auftrag_gefunden = false;  //wenn auf der aktuellen Ebene etwas gefunden wird, die darunter liegenden nicht mehr ansehen, bzw. sogar löschen!
               for(k=0;k<3;k++)  //alle drei Puffer in hierarchischer Reihenfolge durchgehen
               {
                     if(k==0)
                         puffer = puffer_kabel;
                     else if(k==1)    
                         puffer = puffer_infrarot;
                     else
                         puffer = puffer_intern;

                     for(i=0;i<REMOTEPUFFER;i++)
                     {
                           //wenn   Zustand, oder       Befehl, oder      Nachricht
                           nummer=-1;
                           panz=-1;
                           if(puffer[i]=='#' || puffer[i]=='$' || puffer[i]=='!')
                           {
                               nummer = (puffer[(i+1)%REMOTEPUFFER]-48)*10 + (puffer[(i+2)%REMOTEPUFFER]-48);
                           }
                           
                           if(puffer[i]=='#' && nummer>=0 && nummer<ANZZUSTAND) //Zustand
                           {
                               zustand = zustaende[nummer];
                               auftrag_gefunden = true;
                               panz = zustand->getPanz();
                           }
                           else if(puffer[i]=='$' && nummer>=0 && nummer<ANZBEFEHL) //Befehl
                           {
                               befehl = befehle[nummer];
                               auftrag_gefunden = true;
                               panz = befehl->getPanz();                               
                           }
                           else if(puffer[i]=='!' && nummer>=0 && nummer<ANZNACHRICHT)//Nachricht
                           {
                               nachricht = nachrichten[nummer];
                               auftrag_gefunden = true;
                               panz = nachricht->getPanz();
                           }                           
                           
                           a=0;
                           b=0;
                           c=0;
                           d=0;
                           
                           if(panz>0)
                               a = puffer[(i+3)%REMOTEPUFFER];
                           if(panz>1) 
                               b = puffer[(i+4)%REMOTEPUFFER];
                           if(panz>2) 
                               c = puffer[(i+5)%REMOTEPUFFER];
                           if(panz>3) 
                               d = puffer[(i+6)%REMOTEPUFFER];
                           
                           if(puffer[i]=='#' && auftrag_gefunden)
                           {
                                 zustand->konfigurieren(a,b,c,d);
                           }      
                           else if(puffer[i]=='$' && auftrag_gefunden)
                           {
                                 befehl->konfigurieren(a,b,c,d);
                                 //Befehle werden unmittelbar verarbeitet und man fliegt dabei aus dem aktuellen Zustand heraus:
                                 //befehl->perform();   wird in Hauptprogramm ausgeführt!                              
                           }      
                           else if(puffer[i]=='!' && auftrag_gefunden)
                           {
                                 nachricht->konfigurieren(a,b,c,d);                                                      
                                 //nachricht->reagieren();   wird in Hauptprogramm ausgeführt!
                           }  
                       
                       
                           if(panz>-1)
                           {
                               puffer[i]=' ';  //abgearbeitete Befehle löschen, entsprechend Befehlslänge
                               puffer[(i+1)%REMOTEPUFFER]=' ';
                               puffer[(i+2)%REMOTEPUFFER]=' ';
                           }
                           if(panz>0)
                               puffer[(i+3)%REMOTEPUFFER] = ' ';
                           if(panz>1) 
                               puffer[(i+4)%REMOTEPUFFER] = ' ';
                           if(panz>2) 
                               puffer[(i+5)%REMOTEPUFFER] = ' ';
                           if(panz>3) 
                               puffer[(i+6)%REMOTEPUFFER] = ' ';
                           
                     }//for i 
                     
                     
                     if(auftrag_gefunden==true)    
                     {
                         if(i<1)
                         {
                             for(i=0;i<REMOTEPUFFER;i++)
                                 puffer_infrarot[i]=' ';
                             index_infrarot = 0;                                 
                         }
                         if(i<2)
                         {
                             for(i=0;i<REMOTEPUFFER;i++)
                                 puffer_intern[i]=' ';
                             index_intern = 0;                                 
                         }
                         break;
                     }
               }//for k alle Puffer               
         }//zeitschritt()
} remote;
