//Timer 1 dient gleichzeitig als PWM-Geber für die Motoren, als auch als Zeitbasis für 
//Zeitsteuerungen.

//   Zählfrequenz = fclock / (N*(TOP+1))
//   Zählfrequenz = 8.000.000 / (64*1024) ==  122,0703125Hz (einmal hochzählen)   ungefähr 8ms pro Schleifendurchlauf

class TIMER1
{
    public:
        unsigned long ZEIT;

        TIMER1()
        {
            ZEIT=0;

            DDRC |= 0b00001100;  //Richtung

            //10-Bit Phasen-korrektes PWM-Signal.
            TCCR1A = (1<<COM1A1) | (0<<COM1A0) | (1<<COM1B1) | (0<<COM1B0) | (0<<FOC1A) | (0<<FOC1B) | (1<<WGM11) | (1<<WGM10);
            TCCR1B = (0<<ICNC1) | (0<<ICES1) | (0<<WGM13) | (1<<WGM12) | (0<<CS12) | (1<<CS11) | (1<<CS10);
            DDRD |= (1<<PD5) | (1<<PD4); //auf Ausgang setzen.            
            OCR1A = 0; //PWM-Breite setzen (entspricht für Servo auf 0 Grad).
            OCR1B = 0; //PWM-Breite setzen (entspricht für Servo auf 0 Grad).
        }

        void abwartenZyklus() //Wartet ab, bis Zähler von Timer1 auf 1023 ist, also 1/122Sekunde vorbei ist.
        {
            ZEIT++;
            ZEIT%=122; //Eine Sekunde wird in 122 Teile gegliedert
            while(TCNT1<1023) PORTB|=0;
        }

        //Ansteuerung der Motoren
        void fahrt(int links, int rechts)  //Wertebereich: +-1023
        {
            if(links==0)    
            {
                PORTC &= ~(1<<PC2);
                OCR1B = 0;
            }
            else if(links<0)
            {
                PORTC |=  (1<<PC2);
                OCR1B = -links;
            }
            else
            {
                PORTC &= ~(1<<PC2);
                OCR1B = links;
            }

            if(rechts==0)    
            {
                PORTC &= ~(1<<PC3);
                OCR1A = 0;
            }
            else if(rechts<0)
            {
                PORTC |=  (1<<PC3);
                OCR1A = -rechts;
            }
            else
            {
                PORTC &= ~(1<<PC3);
                OCR1A = rechts;
            }
        }

} timer1;