//TTS:
import android.speech.tts.TextToSpeech;
import java.util.Locale;
import java.util.Set;
import android.media.AudioManager;
import android.content.Context;

TTS tts = null;

public void sprich(String text)
{
    if(tts==null)
    {
        tts = new TTS();
        tts.setzeSpechgeschwindigkeit(1.0f);
        tts.setzeStimmhoehe(1.0f);
        tts.setzeLautstaerke(0.8f);      
    }
    
    if(tts!=null)
    {
        tts.sprich(text);
    }
}

public class TTS implements Runnable
{
     ArrayList<String> warteschlange = new ArrayList<String>();
  
  
     TextToSpeech tts;
     AudioManager audio;
     int currentVolume;
     int maxVolume;

     public void setzeSpechgeschwindigkeit(float s)
     {
         tts.setSpeechRate(s);    
     }

     public void setzeStimmhoehe(float h)
     {
         tts.setSpeechRate(h);    
     }

     public void setzeLautstaerke(float ls)
     {
         if(ls<0.0f)
             ls=0.0f;
         if(ls>1.0f)
             ls=1.0f;
         int LAUT  = (int) (maxVolume*ls);
             
         audio.setStreamVolume(AudioManager.STREAM_MUSIC, LAUT, 0);             
     }

     public void run()
     {
         while(true)
         {
              if(tts!=null && warteschlange.size()>0 && !tts.isSpeaking())
              {
                  String text = warteschlange.get(0);
                  warteschlange.remove(0);
                
                  tts.speak(text, TextToSpeech.QUEUE_FLUSH, null);
              }  
                         
              try
              {
                  Thread.sleep(100);
              }
              catch(Exception e)
              {
              }
         }
     }

     public void sprich(String text)
     {
        warteschlange.add(text);       
     }

     public TTS()
     {
         //NEU:  getActivity(). ab Proc. 3!
         tts=new TextToSpeech(getActivity().getApplicationContext(), new TextToSpeech.OnInitListener() {
         //@Override
            public void onInit(int status) {
               if(status != TextToSpeech.ERROR) {
                  tts.setLanguage(Locale.GERMAN);
               }
            }
         });

         audio = (AudioManager) getActivity().getSystemService(Context.AUDIO_SERVICE);  //NEU:  getActivity(). ab Proc. 3!
         currentVolume = audio.getStreamVolume(AudioManager.STREAM_MUSIC);
         maxVolume = audio.getStreamMaxVolume(AudioManager.STREAM_MUSIC);
         
         //eigenen Thread starten:
         (new Thread(this)).start();
     }
}