package processing.test.avrconnect1;

import processing.core.*; 

import android.media.AudioTrack;
import android.media.AudioFormat;
import android.media.AudioManager;

//Neuerungen:
//STEREO
//Auswahl der PWM-Kombis über Touchscreen:
//
//            1
//
//    3       0       4
//
//            2
//
//            PWM_LINKS      PWM_RECHTS
//
//0  Stopp    66             66
//1  Vor      88             88
//2  Zurück   44             44
//3  links    44             88
//4  rechts   88             44
//

public class avrconnect1 extends PApplet 
{

//NEU:
	
//Aktueller Zustand:	
int ZUSTAND = 0;	
//Zuordnung verschiedener Zustände zu den PWM-Werten
int[][] ZUORDNUNG = {
                        {66,66},
                        {88,88},
                        {44,44},
                        {44,88},
                        {88,44}
                    };
//aktuelle PWM-Werte:
int PWM_LEFT=66;
int PWM_RIGHT=66;

//Hilfsvariablen für rechteckige Taster auf Touchscreen
//Müssen in setup() initialisiert werden, weil dann erst width und height feststehen!
float xraster;
float yraster;
float xrand;
float yrand;
	

boolean aktiv = false; 

int sr;
int buffsize;
long PUFFERZEIT=0;
//create an audiotrack object
AudioTrack audioTrack;

public int PULSE = 400;
public int pulse = 0;

short[] samples;
int amp = 10000;
float twopi = 2.0f*PI;
float fr = 440.0f;
float fr2 = 4.4f;
float fr4 = 1.1f;
float fr3 = 220.0f;
float ph = 0.0f;   
float ph2 = 0.0f;   
float ph3 = 0.0f;   
float ph4 = 0.0f;   
float change=0.0f;
float change2=0.0f;

Tonspieler tonspieler;

int WERT = 0;

public void setup()
{
	sr = 44100;

	xraster = width/3.0f;
	yraster = height/3.0f;
	xrand   = width/15.0f;
	yrand   = height/15.0f;
	
	
	buffsize = AudioTrack.getMinBufferSize(sr, AudioFormat.CHANNEL_OUT_STEREO, 
	        AudioFormat.ENCODING_PCM_16BIT);

	//PUFFERZEIT = (1000*(long)buffsize)/sr;  //MONO
	PUFFERZEIT = (500*(long)buffsize)/sr;     //STEREO
	
	//create an audiotrack object
	audioTrack = new AudioTrack(AudioManager.STREAM_MUSIC, sr, 
	                                    AudioFormat.CHANNEL_OUT_STEREO, 
	                                    AudioFormat.ENCODING_PCM_16BIT, 
	                                    buffsize, 
	                                    AudioTrack.MODE_STREAM);


	samples= new short[buffsize];
   
	tonspieler = new Tonspieler();
	
	Thread t = new Thread(tonspieler);
	t.start();
	audioTrack.play();
}

public void draw()
{
    clear();
    background(0);

    if(ZUSTAND==0) fill(255,0,0); else fill(0,0,255);
    rect(xraster+xrand,yraster+yrand,xraster-2.0f*xrand,yraster-2.0f*yrand);
    if(ZUSTAND==1) fill(255,0,0); else fill(0,0,255);
    rect(xraster+xrand,yrand,xraster-2.0f*xrand,yraster-2.0f*yrand);
    if(ZUSTAND==2) fill(255,0,0); else fill(0,0,255);
    rect(xraster+xrand,2.0f*yraster+yrand,xraster-2.0f*xrand,yraster-2.0f*yrand);
    if(ZUSTAND==3) fill(255,0,0); else fill(0,0,255);
    rect(xrand,yraster+yrand,xraster-2.0f*xrand,yraster-2.0f*yrand);
    if(ZUSTAND==4) fill(255,0,0); else fill(0,0,255);
    rect(2.0f*xraster+xrand,yraster+yrand,xraster-2.0f*xrand,yraster-2.0f*yrand);
}

public void mousePressed()
{
	WERT++;
	WERT%=3;
	
	if(mouseX>=xraster+xrand && mouseX<=2.0f*xraster-xrand 
    && mouseY>=yraster+yrand && mouseY<=2.0f*yraster-yrand)
				ZUSTAND=0;
			
	if(mouseX>=xraster+xrand && mouseX<=2.0f*xraster-xrand 
    && mouseY>=yrand && mouseY<=yraster-yrand)
				ZUSTAND=1;
			
	if(mouseX>=xraster+xrand && mouseX<=2.0f*xraster-xrand 
	&& mouseY>=2.0f*yraster+yrand && mouseY<=3.0f*yraster-yrand)
				ZUSTAND=2;
			
	if(mouseX>=xrand && mouseX<=xraster-xrand 
	&& mouseY>=yraster+yrand && mouseY<=2.0f*yraster-yrand)
				ZUSTAND=3;
			
	if(mouseX>=2.0f*xraster+xrand && mouseX<=3.0f*xraster-xrand 
	&& mouseY>=yraster+yrand && mouseY<=2.0f*yraster-yrand)
				ZUSTAND=4;

	//Aktualisierung der PWM-Werte:
	PWM_LEFT = ZUORDNUNG[ZUSTAND][0];
	PWM_RIGHT = ZUORDNUNG[ZUSTAND][1];
}

private class Tonspieler implements Runnable
{
	public void run()
	{
		int zaehler = 0;
		long zeit = System.currentTimeMillis();
		while(true)
		{
				  for(int i=0;i<buffsize;i+=2)
				  {  
						 if(zaehler<PWM_LEFT)
						     samples[i] = Short.MAX_VALUE;
						 else
							 samples[i] = Short.MIN_VALUE;
						 if(zaehler<PWM_RIGHT)
						     samples[i+1] = Short.MAX_VALUE;
						 else
							 samples[i+1] = Short.MIN_VALUE;
				     zaehler++;
				     if(zaehler>=500)
				         zaehler=0;
				     
				  } 
				  audioTrack.write(samples, 0, buffsize);
				  
				  long restzeit = PUFFERZEIT-(System.currentTimeMillis()-zeit);
				  zeit=System.currentTimeMillis();
				  if(restzeit>0)
				  {
					  try
					  {
						  Thread.sleep(restzeit);
					  }
					  catch(Exception e)
					  {
						  
					  }
				  }
		}
	}
}


}
