/*
 * Decompiled with CFR 0.152.
 */
package generativedesign;

import generativedesign.Node;
import processing.core.PVector;

public class Spring {
    public String id = "";
    public Node fromNode;
    public Node toNode;
    public float length = 100.0f;
    public float stiffness = 0.6f;
    public float damping = 0.9f;

    public Spring(Node theFromNode, Node theToNode) {
        this.fromNode = theFromNode;
        this.toNode = theToNode;
    }

    public Spring(Node theFromNode, Node theToNode, float theLength, float theStiffness, float theDamping) {
        this.fromNode = theFromNode;
        this.toNode = theToNode;
        this.length = theLength;
        this.stiffness = theStiffness;
        this.damping = theDamping;
    }

    public void update() {
        PVector diff = PVector.sub((PVector)this.toNode, (PVector)this.fromNode);
        diff.normalize();
        diff.mult(this.length);
        PVector target = PVector.add((PVector)this.fromNode, (PVector)diff);
        PVector force = PVector.sub((PVector)target, (PVector)this.toNode);
        force.mult(0.5f);
        force.mult(this.stiffness);
        force.mult(1.0f - this.damping);
        this.toNode.velocity.add(force);
        this.fromNode.velocity.add(PVector.mult((PVector)force, (float)-1.0f));
    }

    public String getID() {
        return this.id;
    }

    public void setID(String theID) {
        this.id = theID;
    }

    public Node getFromNode() {
        return this.fromNode;
    }

    public void setFromNode(Node theFromNode) {
        this.fromNode = theFromNode;
    }

    public Node getToNode() {
        return this.toNode;
    }

    public void setToNode(Node theToNode) {
        this.toNode = theToNode;
    }

    public float getLength() {
        return this.length;
    }

    public void setLength(float theLength) {
        this.length = theLength;
    }

    public float getStiffness() {
        return this.stiffness;
    }

    public void setStiffness(float theStiffness) {
        this.stiffness = theStiffness;
    }

    public float getDamping() {
        return this.damping;
    }

    public void setDamping(float theDamping) {
        this.damping = theDamping;
    }
}

