/*
 * Decompiled with CFR 0.152.
 */
package generativedesign;

import processing.core.PApplet;
import processing.core.PVector;

public class Mesh
extends PApplet {
    private PApplet parent;
    private static final long serialVersionUID = 1L;
    public static final int PLANE = 0;
    public static final int TUBE = 1;
    public static final int SPHERE = 2;
    public static final int TORUS = 3;
    public static final int PARABOLOID = 4;
    public static final int STEINBACHSCREW = 5;
    public static final int SINE = 6;
    public static final int FIGURE8TORUS = 7;
    public static final int ELLIPTICTORUS = 8;
    public static final int CORKSCREW = 9;
    public static final int BOHEMIANDOME = 10;
    public static final int BOW = 11;
    public static final int MAEDERSOWL = 12;
    public static final int ASTROIDALELLIPSOID = 13;
    public static final int TRIAXIALTRITORUS = 14;
    public static final int LIMPETTORUS = 15;
    public static final int HORN = 16;
    public static final int SHELL = 17;
    public static final int KIDNEY = 18;
    public static final int LEMNISCAPE = 19;
    public static final int TRIANGULOID = 20;
    public static final int SUPERFORMULA = 21;
    public int form = 4;
    public float uMin = (float)(-Math.PI);
    public float uMax = (float)Math.PI;
    public int uCount = 50;
    public float vMin = (float)(-Math.PI);
    public float vMax = (float)Math.PI;
    public int vCount = 50;
    public float[] params = new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    public int drawMode = 10;
    public float minHue = 0.0f;
    public float maxHue = 0.0f;
    public float minSaturation = 0.0f;
    public float maxSaturation = 0.0f;
    public float minBrightness = 100.0f;
    public float maxBrightness = 100.0f;
    public float meshAlpha = 100.0f;
    public float meshDistortion = 0.0f;
    PVector[][] points;

    public Mesh(PApplet theParent) {
        this.parent = theParent;
        this.form = 0;
        this.update();
    }

    public Mesh(PApplet theParent, int theForm) {
        this.parent = theParent;
        if (theForm >= 0) {
            this.form = theForm;
        }
        this.update();
    }

    public Mesh(PApplet theParent, int theForm, int theUCount, int theVCount) {
        this.parent = theParent;
        if (theForm >= 0) {
            this.form = theForm;
        }
        this.uCount = Mesh.max((int)theUCount, (int)1);
        this.vCount = Mesh.max((int)theVCount, (int)1);
        this.update();
    }

    public Mesh(PApplet theParent, int theForm, float theUMin, float theUMax, float theVMin, float theVMax) {
        this.parent = theParent;
        if (theForm >= 0) {
            this.form = theForm;
        }
        this.uMin = theUMin;
        this.uMax = theUMax;
        this.vMin = theVMin;
        this.vMax = theVMax;
        this.update();
    }

    public Mesh(PApplet theParent, int theForm, int theUCount, int theVCount, float theUMin, float theUMax, float theVMin, float theVMax) {
        this.parent = theParent;
        if (theForm >= 0) {
            this.form = theForm;
        }
        this.uCount = Mesh.max((int)theUCount, (int)1);
        this.vCount = Mesh.max((int)theVCount, (int)1);
        this.uMin = theUMin;
        this.uMax = theUMax;
        this.vMin = theVMin;
        this.vMax = theVMax;
        this.update();
    }

    public void update() {
        this.points = new PVector[this.vCount + 1][this.uCount + 1];
        int iv = 0;
        while (iv <= this.vCount) {
            int iu = 0;
            while (iu <= this.uCount) {
                float u = Mesh.map((float)iu, (float)0.0f, (float)this.uCount, (float)this.uMin, (float)this.uMax);
                float v = Mesh.map((float)iv, (float)0.0f, (float)this.vCount, (float)this.vMin, (float)this.vMax);
                switch (this.form) {
                    case 0: {
                        this.points[iv][iu] = this.calculatePoints(u, v);
                        break;
                    }
                    case 1: {
                        this.points[iv][iu] = this.calculateTube(u, v);
                        break;
                    }
                    case 2: {
                        this.points[iv][iu] = this.calculateSphere(u, v);
                        break;
                    }
                    case 3: {
                        this.points[iv][iu] = this.calculateTorus(u, v);
                        break;
                    }
                    case 4: {
                        this.points[iv][iu] = this.calculateParaboloid(u, v);
                        break;
                    }
                    case 5: {
                        this.points[iv][iu] = this.calculateSteinbachScrew(u, v);
                        break;
                    }
                    case 6: {
                        this.points[iv][iu] = this.calculateSine(u, v);
                        break;
                    }
                    case 7: {
                        this.points[iv][iu] = this.calculateFigure8Torus(u, v);
                        break;
                    }
                    case 8: {
                        this.points[iv][iu] = this.calculateEllipticTorus(u, v);
                        break;
                    }
                    case 9: {
                        this.points[iv][iu] = this.calculateCorkscrew(u, v);
                        break;
                    }
                    case 10: {
                        this.points[iv][iu] = this.calculateBohemianDome(u, v);
                        break;
                    }
                    case 11: {
                        this.points[iv][iu] = this.calculateBow(u, v);
                        break;
                    }
                    case 12: {
                        this.points[iv][iu] = this.calculateMaedersOwl(u, v);
                        break;
                    }
                    case 13: {
                        this.points[iv][iu] = this.calculateAstroidalEllipsoid(u, v);
                        break;
                    }
                    case 14: {
                        this.points[iv][iu] = this.calculateTriaxialTritorus(u, v);
                        break;
                    }
                    case 15: {
                        this.points[iv][iu] = this.calculateLimpetTorus(u, v);
                        break;
                    }
                    case 16: {
                        this.points[iv][iu] = this.calculateHorn(u, v);
                        break;
                    }
                    case 17: {
                        this.points[iv][iu] = this.calculateShell(u, v);
                        break;
                    }
                    case 18: {
                        this.points[iv][iu] = this.calculateKidney(u, v);
                        break;
                    }
                    case 19: {
                        this.points[iv][iu] = this.calculateLemniscape(u, v);
                        break;
                    }
                    case 20: {
                        this.points[iv][iu] = this.calculateTrianguloid(u, v);
                        break;
                    }
                    case 21: {
                        this.points[iv][iu] = this.calculateSuperformula(u, v);
                        break;
                    }
                    default: {
                        this.points[iv][iu] = this.calculatePoints(u, v);
                    }
                }
                ++iu;
            }
            ++iv;
        }
    }

    public PVector calculatePoints(float u, float v) {
        float x = u;
        float y = v;
        float z = 0.0f;
        return new PVector(x, y, z);
    }

    public PVector calculateTube(float u, float v) {
        float x = Mesh.sin((float)u);
        float y = this.params[0] * v;
        float z = Mesh.cos((float)u);
        return new PVector(x, y, z);
    }

    public PVector calculateSphere(float u, float v) {
        v /= 2.0f;
        float x = 2.0f * (Mesh.sin((float)(v += 1.5707964f)) * Mesh.sin((float)u));
        float y = 2.0f * (this.params[0] * Mesh.cos((float)v));
        float z = 2.0f * (Mesh.sin((float)v) * Mesh.cos((float)u));
        return new PVector(x, y, z);
    }

    public PVector calculateTorus(float u, float v) {
        float x = 1.0f * ((this.params[1] + 1.0f + this.params[0] * Mesh.cos((float)v)) * Mesh.sin((float)u));
        float y = 1.0f * (this.params[0] * Mesh.sin((float)v));
        float z = 1.0f * ((this.params[1] + 1.0f + this.params[0] * Mesh.cos((float)v)) * Mesh.cos((float)u));
        return new PVector(x, y, z);
    }

    public PVector calculateParaboloid(float u, float v) {
        float pd = this.params[0];
        if (pd == 0.0f) {
            pd = 1.0E-4f;
        }
        float x = this.power(v / pd, 0.5f) * Mesh.sin((float)u);
        float y = v;
        float z = this.power(v / pd, 0.5f) * Mesh.cos((float)u);
        return new PVector(x, y, z);
    }

    public PVector calculateSteinbachScrew(float u, float v) {
        float x = u * Mesh.cos((float)v);
        float y = u * Mesh.sin((float)(this.params[0] * v));
        float z = v * Mesh.cos((float)u);
        return new PVector(x, y, z);
    }

    public PVector calculateSine(float u, float v) {
        float x = 2.0f * Mesh.sin((float)u);
        float y = 2.0f * Mesh.sin((float)(this.params[0] * v));
        float z = 2.0f * Mesh.sin((float)(u + v));
        return new PVector(x, y, z);
    }

    public PVector calculateFigure8Torus(float u, float v) {
        float x = 1.5f * Mesh.cos((float)u) * (this.params[0] + Mesh.sin((float)v) * Mesh.cos((float)u) - Mesh.sin((float)(2.0f * v)) * Mesh.sin((float)u) / 2.0f);
        float y = 1.5f * Mesh.sin((float)u) * (this.params[0] + Mesh.sin((float)v) * Mesh.cos((float)u) - Mesh.sin((float)(2.0f * v)) * Mesh.sin((float)u) / 2.0f);
        float z = 1.5f * Mesh.sin((float)u) * Mesh.sin((float)v) + Mesh.cos((float)u) * Mesh.sin((float)(2.0f * v)) / 2.0f;
        return new PVector(x, y, z);
    }

    public PVector calculateEllipticTorus(float u, float v) {
        float x = 1.5f * (this.params[0] + Mesh.cos((float)v)) * Mesh.cos((float)u);
        float y = 1.5f * (this.params[0] + Mesh.cos((float)v)) * Mesh.sin((float)u);
        float z = 1.5f * Mesh.sin((float)v) + Mesh.cos((float)v);
        return new PVector(x, y, z);
    }

    public PVector calculateCorkscrew(float u, float v) {
        float x = Mesh.cos((float)u) * Mesh.cos((float)v);
        float y = Mesh.sin((float)u) * Mesh.cos((float)v);
        float z = Mesh.sin((float)v) + this.params[0] * u;
        return new PVector(x, y, z);
    }

    public PVector calculateBohemianDome(float u, float v) {
        float x = 2.0f * Mesh.cos((float)u);
        float y = 2.0f * Mesh.sin((float)u) + this.params[0] * Mesh.cos((float)v);
        float z = 2.0f * Mesh.sin((float)v);
        return new PVector(x, y, z);
    }

    public PVector calculateBow(float u, float v) {
        float x = (2.0f + this.params[0] * Mesh.sin((float)((float)Math.PI * 2 * (u /= (float)Math.PI * 2)))) * Mesh.sin((float)((float)Math.PI * 4 * (v /= (float)Math.PI * 2)));
        float y = (2.0f + this.params[0] * Mesh.sin((float)((float)Math.PI * 2 * u))) * Mesh.cos((float)((float)Math.PI * 4 * v));
        float z = this.params[0] * Mesh.cos((float)((float)Math.PI * 2 * u)) + 3.0f * Mesh.cos((float)((float)Math.PI * 2 * v));
        return new PVector(x, y, z);
    }

    public PVector calculateMaedersOwl(float u, float v) {
        float x = 0.4f * (v * Mesh.cos((float)u) - 0.5f * this.params[0] * this.power(v, 2.0f) * Mesh.cos((float)(2.0f * u)));
        float y = 0.4f * (-v * Mesh.sin((float)u) - 0.5f * this.params[0] * this.power(v, 2.0f) * Mesh.sin((float)(2.0f * u)));
        float z = 0.4f * (4.0f * this.power(v, 1.5f) * Mesh.cos((float)(3.0f * u / 2.0f)) / 3.0f);
        return new PVector(x, y, z);
    }

    public PVector calculateAstroidalEllipsoid(float u, float v) {
        float x = 3.0f * this.power(Mesh.cos((float)(u /= 2.0f)) * Mesh.cos((float)v), 3.0f * this.params[0]);
        float y = 3.0f * this.power(Mesh.sin((float)u) * Mesh.cos((float)v), 3.0f * this.params[0]);
        float z = 3.0f * this.power(Mesh.sin((float)v), 3.0f * this.params[0]);
        return new PVector(x, y, z);
    }

    public PVector calculateTriaxialTritorus(float u, float v) {
        float x = 1.5f * Mesh.sin((float)u) * (1.0f + Mesh.cos((float)v));
        float y = 1.5f * Mesh.sin((float)(u + 2.0943952f * this.params[0])) * (1.0f + Mesh.cos((float)(v + 2.0943952f * this.params[0])));
        float z = 1.5f * Mesh.sin((float)(u + 4.1887903f * this.params[0])) * (1.0f + Mesh.cos((float)(v + 4.1887903f * this.params[0])));
        return new PVector(x, y, z);
    }

    public PVector calculateLimpetTorus(float u, float v) {
        float x = 1.5f * this.params[0] * Mesh.cos((float)u) / (Mesh.sqrt((float)2.0f) + Mesh.sin((float)v));
        float y = 1.5f * this.params[0] * Mesh.sin((float)u) / (Mesh.sqrt((float)2.0f) + Mesh.sin((float)v));
        float z = 1.5f / (Mesh.sqrt((float)2.0f) + Mesh.cos((float)v));
        return new PVector(x, y, z);
    }

    public PVector calculateHorn(float u, float v) {
        float x = (2.0f * this.params[0] + (u /= (float)Math.PI) * Mesh.cos((float)v)) * Mesh.sin((float)((float)Math.PI * 2 * u));
        float y = (2.0f * this.params[0] + u * Mesh.cos((float)v)) * Mesh.cos((float)((float)Math.PI * 2 * u)) + 2.0f * u;
        float z = u * Mesh.sin((float)v);
        return new PVector(x, y, z);
    }

    public PVector calculateShell(float u, float v) {
        float x = this.params[1] * (1.0f - u / ((float)Math.PI * 2)) * Mesh.cos((float)(this.params[0] * u)) * (1.0f + Mesh.cos((float)v)) + this.params[3] * Mesh.cos((float)(this.params[0] * u));
        float y = this.params[1] * (1.0f - u / ((float)Math.PI * 2)) * Mesh.sin((float)(this.params[0] * u)) * (1.0f + Mesh.cos((float)v)) + this.params[3] * Mesh.sin((float)(this.params[0] * u));
        float z = this.params[2] * (u / ((float)Math.PI * 2)) + this.params[0] * (1.0f - u / ((float)Math.PI * 2)) * Mesh.sin((float)v);
        return new PVector(x, y, z);
    }

    public PVector calculateKidney(float u, float v) {
        float x = Mesh.cos((float)(u /= 2.0f)) * (this.params[0] * 3.0f * Mesh.cos((float)v) - Mesh.cos((float)(3.0f * v)));
        float y = Mesh.sin((float)u) * (this.params[0] * 3.0f * Mesh.cos((float)v) - Mesh.cos((float)(3.0f * v)));
        float z = 3.0f * Mesh.sin((float)v) - Mesh.sin((float)(3.0f * v));
        return new PVector(x, y, z);
    }

    public PVector calculateLemniscape(float u, float v) {
        float cosvSqrtAbsSin2u = Mesh.cos((float)v) * Mesh.sqrt((float)Mesh.abs((float)Mesh.sin((float)(2.0f * this.params[0] * (u /= 2.0f)))));
        float x = cosvSqrtAbsSin2u * Mesh.cos((float)u);
        float y = cosvSqrtAbsSin2u * Mesh.sin((float)u);
        float z = 3.0f * (this.power(x, 2.0f) - this.power(y, 2.0f) + 2.0f * x * y * this.power(Mesh.tan((float)v), 2.0f));
        return new PVector(x *= 3.0f, y *= 3.0f, z);
    }

    public PVector calculateTrianguloid(float u, float v) {
        float x = 0.75f * (Mesh.sin((float)(3.0f * u)) * 2.0f / (2.0f + Mesh.cos((float)v)));
        float y = 0.75f * ((Mesh.sin((float)u) + 2.0f * this.params[0] * Mesh.sin((float)(2.0f * u))) * 2.0f / (2.0f + Mesh.cos((float)(v + (float)Math.PI * 2))));
        float z = 0.75f * ((Mesh.cos((float)u) - 2.0f * this.params[0] * Mesh.cos((float)(2.0f * u))) * (2.0f + Mesh.cos((float)v)) * ((2.0f + Mesh.cos((float)(v + 2.0943952f))) * 0.25f));
        return new PVector(x, y, z);
    }

    public PVector calculateSuperformula(float u, float v) {
        v /= 2.0f;
        float a = this.params[0];
        float b = this.params[1];
        float m = this.params[2];
        float n1 = this.params[3];
        float n2 = this.params[4];
        float n3 = this.params[5];
        float r1 = Mesh.pow((float)(Mesh.pow((float)Mesh.abs((float)(Mesh.cos((float)(m * u / 4.0f)) / a)), (float)n2) + Mesh.pow((float)Mesh.abs((float)(Mesh.sin((float)(m * u / 4.0f)) / b)), (float)n3)), (float)(-1.0f / n1));
        a = this.params[6];
        b = this.params[7];
        m = this.params[8];
        n1 = this.params[9];
        n2 = this.params[10];
        n3 = this.params[11];
        float r2 = Mesh.pow((float)(Mesh.pow((float)Mesh.abs((float)(Mesh.cos((float)(m * v / 4.0f)) / a)), (float)n2) + Mesh.pow((float)Mesh.abs((float)(Mesh.sin((float)(m * v / 4.0f)) / b)), (float)n3)), (float)(-1.0f / n1));
        float x = 2.0f * (r1 * Mesh.sin((float)u) * r2 * Mesh.cos((float)v));
        float y = 2.0f * (r2 * Mesh.sin((float)v));
        float z = 2.0f * (r1 * Mesh.cos((float)u) * r2 * Mesh.cos((float)v));
        return new PVector(x, y, z);
    }

    public float power(float b, float e) {
        if (b >= 0.0f || (float)PApplet.parseInt((float)e) == e) {
            return Mesh.pow((float)b, (float)e);
        }
        return -Mesh.pow((float)(-b), (float)e);
    }

    public float logE(float v) {
        if (v >= 0.0f) {
            return Mesh.log((float)v);
        }
        return -Mesh.log((float)(-v));
    }

    public void draw() {
        float minB;
        float maxB;
        float minS;
        float maxS;
        int ivMax;
        int iuMax;
        if (this.drawMode == 16 || this.drawMode == 9) {
            iuMax = this.uCount - 1;
            ivMax = this.vCount - 1;
        } else {
            iuMax = this.uCount;
            ivMax = this.vCount - 1;
        }
        this.parent.pushStyle();
        this.parent.colorMode(3, 360.0f, 100.0f, 100.0f, 100.0f);
        float minH = this.minHue;
        float maxH = this.maxHue;
        if (Mesh.abs((float)(maxH - minH)) < 20.0f) {
            maxH = minH;
        }
        if (Mesh.abs((float)((maxS = this.maxSaturation) - (minS = this.minSaturation))) < 10.0f) {
            maxS = minS;
        }
        if (Mesh.abs((float)((maxB = this.maxBrightness) - (minB = this.minBrightness))) < 10.0f) {
            maxB = minB;
        }
        int iv = 0;
        while (iv <= ivMax) {
            float r3;
            float r2;
            float r1;
            int iu;
            if (this.drawMode == 9) {
                iu = 0;
                while (iu <= iuMax) {
                    this.parent.fill(this.random(minH, maxH), this.random(minS, maxS), this.random(minB, maxB), this.meshAlpha);
                    this.parent.beginShape(this.drawMode);
                    r1 = this.random(-this.meshDistortion, this.meshDistortion);
                    r2 = this.random(-this.meshDistortion, this.meshDistortion);
                    r3 = this.random(-this.meshDistortion, this.meshDistortion);
                    this.parent.vertex(this.points[iv][iu].x + r1, this.points[iv][iu].y + r2, this.points[iv][iu].z + r3);
                    this.parent.vertex(this.points[iv + 1][iu + 1].x + r1, this.points[iv + 1][iu + 1].y + r2, this.points[iv + 1][iu + 1].z + r3);
                    this.parent.vertex(this.points[iv + 1][iu].x + r1, this.points[iv + 1][iu].y + r2, this.points[iv + 1][iu].z + r3);
                    this.parent.endShape();
                    this.parent.fill(this.random(minH, maxH), this.random(minS, maxS), this.random(minB, maxB), this.meshAlpha);
                    this.parent.beginShape(this.drawMode);
                    r1 = this.random(-this.meshDistortion, this.meshDistortion);
                    r2 = this.random(-this.meshDistortion, this.meshDistortion);
                    r3 = this.random(-this.meshDistortion, this.meshDistortion);
                    this.parent.vertex(this.points[iv + 1][iu + 1].x + r1, this.points[iv + 1][iu + 1].y + r2, this.points[iv + 1][iu + 1].z + r3);
                    this.parent.vertex(this.points[iv][iu].x + r1, this.points[iv][iu].y + r2, this.points[iv][iu].z + r3);
                    this.parent.vertex(this.points[iv][iu + 1].x + r1, this.points[iv][iu + 1].y + r2, this.points[iv][iu + 1].z + r3);
                    this.parent.endShape();
                    ++iu;
                }
            } else if (this.drawMode == 16) {
                iu = 0;
                while (iu <= iuMax) {
                    this.parent.fill(this.random(minH, maxH), this.random(minS, maxS), this.random(minB, maxB), this.meshAlpha);
                    this.parent.beginShape(this.drawMode);
                    r1 = this.random(-this.meshDistortion, this.meshDistortion);
                    r2 = this.random(-this.meshDistortion, this.meshDistortion);
                    r3 = this.random(-this.meshDistortion, this.meshDistortion);
                    this.parent.vertex(this.points[iv][iu].x + r1, this.points[iv][iu].y + r2, this.points[iv][iu].z + r3);
                    this.parent.vertex(this.points[iv + 1][iu].x + r1, this.points[iv + 1][iu].y + r2, this.points[iv + 1][iu].z + r3);
                    this.parent.vertex(this.points[iv + 1][iu + 1].x + r1, this.points[iv + 1][iu + 1].y + r2, this.points[iv + 1][iu + 1].z + r3);
                    this.parent.vertex(this.points[iv][iu + 1].x + r1, this.points[iv][iu + 1].y + r2, this.points[iv][iu + 1].z + r3);
                    this.parent.endShape();
                    ++iu;
                }
            } else {
                this.parent.fill(this.random(minH, maxH), this.random(minS, maxS), this.random(minB, maxB), this.meshAlpha);
                this.parent.beginShape(this.drawMode);
                iu = 0;
                while (iu <= iuMax) {
                    r1 = this.random(-this.meshDistortion, this.meshDistortion);
                    r2 = this.random(-this.meshDistortion, this.meshDistortion);
                    r3 = this.random(-this.meshDistortion, this.meshDistortion);
                    this.parent.vertex(this.points[iv][iu].x + r1, this.points[iv][iu].y + r2, this.points[iv][iu].z + r3);
                    this.parent.vertex(this.points[iv + 1][iu].x + r1, this.points[iv + 1][iu].y + r2, this.points[iv + 1][iu].z + r3);
                    ++iu;
                }
                this.parent.endShape();
            }
            ++iv;
        }
        this.parent.popStyle();
    }

    public int getForm() {
        return this.form;
    }

    public void setForm(int theValue) {
        this.form = theValue;
    }

    public String getFormName() {
        switch (this.form) {
            case 0: {
                return "Custom";
            }
            case 1: {
                return "Tube";
            }
            case 2: {
                return "Sphere";
            }
            case 3: {
                return "Torus";
            }
            case 4: {
                return "Paraboloid";
            }
            case 5: {
                return "Steinbach Screw";
            }
            case 6: {
                return "Sine";
            }
            case 7: {
                return "Figure 8 Torus";
            }
            case 8: {
                return "Elliptic Torus";
            }
            case 9: {
                return "Corkscrew";
            }
            case 10: {
                return "Bohemian Dome";
            }
            case 11: {
                return "Bow";
            }
            case 12: {
                return "Maeders Owl";
            }
            case 13: {
                return "Astoidal Ellipsoid";
            }
            case 14: {
                return "Triaxial Tritorus";
            }
            case 15: {
                return "Limpet Torus";
            }
            case 16: {
                return "Horn";
            }
            case 17: {
                return "Shell";
            }
            case 18: {
                return "Kidney";
            }
            case 19: {
                return "Lemniscape";
            }
            case 20: {
                return "Trianguloid";
            }
            case 21: {
                return "Superformula";
            }
        }
        return "";
    }

    public float getUMin() {
        return this.uMin;
    }

    public void setUMin(float theValue) {
        this.uMin = theValue;
    }

    public float getUMax() {
        return this.uMax;
    }

    public void setUMax(float theValue) {
        this.uMax = theValue;
    }

    public int getUCount() {
        return this.uCount;
    }

    public void setUCount(int theValue) {
        this.uCount = theValue;
    }

    public float getVMin() {
        return this.vMin;
    }

    public void setVMin(float theValue) {
        this.vMin = theValue;
    }

    public float getVMax() {
        return this.vMax;
    }

    public void setVMax(float theValue) {
        this.vMax = theValue;
    }

    public int getVCount() {
        return this.vCount;
    }

    public void setVCount(int theValue) {
        this.vCount = theValue;
    }

    public float[] getParams() {
        return this.params;
    }

    public void setParams(float[] theValues) {
        this.params = theValues;
    }

    public float getParam(int theIndex) {
        return this.params[theIndex];
    }

    public void setParam(int theIndex, float theValue) {
        this.params[theIndex] = theValue;
    }

    public int getDrawMode() {
        return this.drawMode;
    }

    public void setDrawMode(int theMode) {
        this.drawMode = theMode;
    }

    public float getMeshDistortion() {
        return this.meshDistortion;
    }

    public void setMeshDistortion(float theValue) {
        this.meshDistortion = theValue;
    }

    public void setColorRange(float theMinHue, float theMaxHue, float theMinSaturation, float theMaxSaturation, float theMinBrightness, float theMaxBrightness, float theMeshAlpha) {
        this.minHue = theMinHue;
        this.maxHue = theMaxHue;
        this.minSaturation = theMinSaturation;
        this.maxSaturation = theMaxSaturation;
        this.minBrightness = theMinBrightness;
        this.maxBrightness = theMaxBrightness;
        this.meshAlpha = theMeshAlpha;
    }

    public float getMinHue() {
        return this.minHue;
    }

    public void setMinHue(float minHue) {
        this.minHue = minHue;
    }

    public float getMaxHue() {
        return this.maxHue;
    }

    public void setMaxHue(float maxHue) {
        this.maxHue = maxHue;
    }

    public float getMinSaturation() {
        return this.minSaturation;
    }

    public void setMinSaturation(float minSaturation) {
        this.minSaturation = minSaturation;
    }

    public float getMaxSaturation() {
        return this.maxSaturation;
    }

    public void setMaxSaturation(float maxSaturation) {
        this.maxSaturation = maxSaturation;
    }

    public float getMinBrightness() {
        return this.minBrightness;
    }

    public void setMinBrightness(float minBrightness) {
        this.minBrightness = minBrightness;
    }

    public float getMaxBrightness() {
        return this.maxBrightness;
    }

    public void setMaxBrightness(float maxBrightness) {
        this.maxBrightness = maxBrightness;
    }

    public float getMeshAlpha() {
        return this.meshAlpha;
    }

    public void setMeshAlpha(float meshAlpha) {
        this.meshAlpha = meshAlpha;
    }
}

