/*
 * Decompiled with CFR 0.152.
 */
package generativedesign;

import generativedesign.AsyncHTMLLoader;
import generativedesign.AsyncImageLoader;
import generativedesign.AsyncXMLLoader;
import generativedesign.AsyncXMLLoader2;
import generativedesign.ColorObject;
import generativedesign.aComperator;
import generativedesign.grayscaleComperator;
import generativedesign.xComperator;
import generativedesign.yComperator;
import generativedesign.zComperator;
import java.awt.Color;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PVector;
import processing.data.XML;
import processing.xml.XMLElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenerativeDesign {
    public static String VERSION = "1.0.4";
    public static String RED = "red";
    public static String GREEN = "green";
    public static String BLUE = "blue";
    public static String HUE = "hue";
    public static String SATURATION = "saturation";
    public static String BRIGHTNESS = "brightness";
    public static String GRAYSCALE = "grayscale";
    public static String ALPHA = "alpha";
    public static int HTML_PLAIN = 0;
    public static int HTML_CONTENT = 1;

    public static String version() {
        return VERSION;
    }

    public static String timestamp() {
        Calendar now = Calendar.getInstance();
        return String.format("%1$ty%1$tm%1$td_%1$tH%1$tM%1$tS", now);
    }

    public static float[] RGBtoHSB(float theR, float theG, float theB) {
        float[] hsb = new float[3];
        Color.RGBtoHSB((int)theR, (int)theG, (int)theB, hsb);
        hsb[0] = hsb[0] * 360.0f;
        hsb[1] = hsb[1] * 100.0f;
        hsb[2] = hsb[2] * 100.0f;
        return hsb;
    }

    public static float[] HSBtoRGB(float theH, float theS, float theB) {
        float[] rgb = new float[3];
        Color t = new Color(Color.HSBtoRGB(theH / 360.0f, theS / 100.0f, theB / 100.0f));
        rgb[0] = t.getRed();
        rgb[1] = t.getGreen();
        rgb[2] = t.getBlue();
        return rgb;
    }

    public static int[] sortColors(PApplet theParent, int[] theColors, String theMethod) {
        theMethod = theMethod.toLowerCase();
        ColorObject[] tmpColors = new ColorObject[theColors.length];
        int i = 0;
        while (i < tmpColors.length) {
            tmpColors[i] = theMethod.equals(GRAYSCALE) ? new ColorObject(theParent, theColors[i], 0.3f, 0.59f, 0.11f) : new ColorObject(theParent, theColors[i]);
            ++i;
        }
        if (theMethod.equals(HUE) || theMethod.equals(RED)) {
            xComperator xComparison = new xComperator();
            Arrays.sort(tmpColors, xComparison);
        } else if (theMethod.equals(SATURATION) || theMethod.equals(GREEN)) {
            yComperator yComparison = new yComperator();
            Arrays.sort(tmpColors, yComparison);
        } else if (theMethod.equals(BRIGHTNESS) || theMethod.equals(BLUE)) {
            zComperator zComparison = new zComperator();
            Arrays.sort(tmpColors, zComparison);
        } else if (theMethod.equals(ALPHA)) {
            aComperator aComparison = new aComperator();
            Arrays.sort(tmpColors, aComparison);
        } else if (theMethod.equals(GRAYSCALE)) {
            grayscaleComperator grayscaleComparison = new grayscaleComperator();
            Arrays.sort(tmpColors, grayscaleComparison);
        }
        i = 0;
        while (i < tmpColors.length) {
            theColors[i] = tmpColors[i].c;
            ++i;
        }
        return theColors;
    }

    public static void saveASE(PApplet theParent, int[] theColors, String theFileName) {
        String[] names = new String[theColors.length];
        int i = 0;
        while (i < theColors.length) {
            int rDec = theColors[i] >> 16 & 0xFF;
            int gDec = theColors[i] >> 8 & 0xFF;
            int bDec = theColors[i] & 0xFF;
            names[i] = "R=" + PApplet.nf((int)rDec, (int)3) + " G=" + PApplet.nf((int)gDec, (int)3) + " B=" + PApplet.nf((int)bDec, (int)3);
            ++i;
        }
        GenerativeDesign.saveASE(theParent, theColors, names, theFileName);
    }

    public static void saveASE(PApplet theParent, int[] theColors, String[] theNames, String theFileName) {
        String NUL = new Character('\u0000').toString();
        String SOH = new Character('\u0001').toString();
        int countColors = theColors.length;
        String ase = "ASEF" + NUL + SOH + NUL + NUL;
        int i = 24;
        while (i >= 0) {
            ase = String.valueOf(ase) + new Character((char)(countColors >> i & 0xFF)).toString();
            i -= 8;
        }
        ase = String.valueOf(ase) + NUL;
        i = 0;
        while (i < countColors) {
            ase = String.valueOf(ase) + SOH + NUL + NUL + NUL;
            ase = String.valueOf(ase) + new Character((char)((theNames[i].length() + 1) * 2 + 20)).toString() + NUL;
            ase = String.valueOf(ase) + new Character((char)(theNames[i].length() + 1)).toString() + NUL;
            int j = 0;
            while (j < theNames[i].length()) {
                ase = String.valueOf(ase) + theNames[i].substring(j, j + 1) + NUL;
                ++j;
            }
            float rDec = theColors[i] >> 16 & 0xFF;
            float gDec = theColors[i] >> 8 & 0xFF;
            float bDec = theColors[i] & 0xFF;
            String r = new String(GenerativeDesign.floatTobytes(rDec / 255.0f));
            String g = new String(GenerativeDesign.floatTobytes(gDec / 255.0f));
            String b = new String(GenerativeDesign.floatTobytes(bDec / 255.0f));
            ase = String.valueOf(ase) + NUL + "RGB ";
            ase = String.valueOf(ase) + r.substring(0, 1) + r.substring(1, 2) + r.substring(2, 3) + NUL;
            ase = String.valueOf(ase) + g.substring(0, 1) + g.substring(1, 2) + g.substring(2, 3) + NUL;
            ase = String.valueOf(ase) + b.substring(0, 1) + b.substring(1, 2) + b.substring(2, 3) + NUL;
            if (i + 1 != countColors) {
                ase = String.valueOf(ase) + NUL + NUL + NUL;
            }
            ++i;
        }
        ase = String.valueOf(ase) + NUL + NUL;
        byte[] bytes = ase.getBytes();
        theParent.saveBytes(theFileName, bytes);
    }

    private static byte[] floatTobytes(float theNumber) {
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putFloat(theNumber);
        return buf.array();
    }

    public static PImage loadImageAsync(PApplet theParent, String thePath) {
        PImage vessel = new PImage();
        new AsyncImageLoader(theParent, thePath, vessel);
        return vessel;
    }

    public static XML loadXMLAsync2(PApplet theParent, String theURL) {
        XML vessel = new XML("test");
        new AsyncXMLLoader2(theParent, theURL, vessel);
        return vessel;
    }

    public static XMLElement loadXMLAsync(PApplet theParent, String theURL) {
        XMLElement vessel = new XMLElement();
        new AsyncXMLLoader(theParent, theURL, vessel);
        return vessel;
    }

    public static ArrayList<String> loadHTMLAsync(PApplet theParent, String theURL) {
        ArrayList<String> vessel = new ArrayList<String>();
        new AsyncHTMLLoader(theParent, theURL, vessel);
        return vessel;
    }

    public static ArrayList<String> loadHTMLAsync(PApplet theParent, String theURL, int theMode) {
        ArrayList<String> vessel = new ArrayList<String>();
        new AsyncHTMLLoader(theParent, theURL, vessel, theMode);
        return vessel;
    }

    public static float angleDifference(float theAngle1, float theAngle2) {
        float a2 = (theAngle2 % ((float)Math.PI * 2) + (float)Math.PI * 2) % ((float)Math.PI * 2);
        float a1 = (theAngle1 % ((float)Math.PI * 2) + (float)Math.PI * 2) % ((float)Math.PI * 2);
        if (a2 > a1) {
            float d1 = a2 - a1;
            float d2 = a1 + (float)Math.PI * 2 - a2;
            if (d1 <= d2) {
                return -d1;
            }
            return d2;
        }
        float d1 = a1 - a2;
        float d2 = a2 + (float)Math.PI * 2 - a1;
        if (d1 <= d2) {
            return d1;
        }
        return -d2;
    }

    public static float[] cartesianToPolar(float theX, float theY) {
        float[] res = new float[]{PApplet.mag((float)theX, (float)theY), PApplet.atan2((float)theY, (float)theX)};
        return res;
    }

    public static float[] cartesianToPolar(float theX, float theY, float theZ) {
        float[] res = new float[3];
        res[0] = PApplet.mag((float)theX, (float)theY, (float)theZ);
        if (res[0] > 0.0f) {
            res[1] = -PApplet.atan2((float)theZ, (float)theX);
            res[2] = PApplet.asin((float)(theY / res[0]));
        } else {
            res[1] = 0.0f;
            res[2] = 0.0f;
        }
        return res;
    }

    public static PVector cartesianToPolar(PVector theVector) {
        PVector res = new PVector();
        res.x = theVector.mag();
        if (res.x > 0.0f) {
            res.y = -PApplet.atan2((float)theVector.z, (float)theVector.x);
            res.z = PApplet.asin((float)(theVector.y / res.x));
        } else {
            res.y = 0.0f;
            res.z = 0.0f;
        }
        return res;
    }

    public static float[] polarToCartesian(float theLength, float theAngle) {
        float[] res = new float[]{PApplet.cos((float)theAngle) * theLength, PApplet.sin((float)theAngle) * theLength};
        return res;
    }

    public static float[] polarToCartesian(float theLength, float theAngleY, float theAngleZ) {
        float[] res = new float[]{PApplet.cos((float)theAngleZ) * PApplet.cos((float)theAngleY) * theLength, PApplet.sin((float)theAngleZ) * theLength, -PApplet.cos((float)theAngleZ) * PApplet.sin((float)theAngleY) * theLength};
        return res;
    }

    public static PVector polarToCartesian(PVector theVector) {
        PVector res = new PVector();
        res.x = PApplet.cos((float)theVector.z) * PApplet.cos((float)theVector.y) * theVector.x;
        res.y = PApplet.sin((float)theVector.z) * theVector.x;
        res.z = -PApplet.cos((float)theVector.z) * PApplet.sin((float)theVector.y) * theVector.x;
        return res;
    }

    public static void unsort(ArrayList<Object> theList) {
        int i = 0;
        while (i < theList.size()) {
            Object oi = theList.get(i);
            int ir = (int)(Math.random() * (double)theList.size());
            Object oir = theList.get(ir);
            theList.set(i, oir);
            theList.set(ir, oi);
            ++i;
        }
    }
}

