/*
 * Decompiled with CFR 0.152.
 */
package prohtml;

public class Url
implements Comparable {
    String url;
    String parentPart;
    String domain;
    boolean absoluteUrl;

    public Url(String url, String parentPart) {
        this.url = url;
        this.parentPart = parentPart;
        this.absoluteUrl = parentPart.equals("");
        this.domain = parentPart;
    }

    public Url(String url, String parentPart, String domain) {
        this(url, parentPart);
        this.domain = domain;
    }

    public boolean isAbsolute() {
        return this.absoluteUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getParentPart() {
        return this.parentPart;
    }

    public String getCompleteUrl() {
        return String.valueOf(this.parentPart) + this.url;
    }

    public boolean equals(Url toCompare) {
        return this.url.equals(toCompare.url) && this.parentPart.equals(toCompare.parentPart);
    }

    public int compareTo(Object toCompare) throws ClassCastException {
        if (!(toCompare instanceof Url)) {
            throw new ClassCastException();
        }
        Url urlToCompare = (Url)toCompare;
        if (urlToCompare.equals(this)) {
            return 0;
        }
        if (this.parentPart.equals(urlToCompare.parentPart)) {
            return this.url.compareTo(urlToCompare.url);
        }
        return this.parentPart.compareTo(urlToCompare.parentPart);
    }

    public String toString() {
        return "parentPart: " + this.parentPart + " url: " + this.url;
    }
}

