/*
 * Decompiled with CFR 0.152.
 */
package prohtml;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import prohtml.Element;
import prohtml.HtmlCollection;
import prohtml.HtmlElement;
import prohtml.InvalidUrlException;
import prohtml.StandAloneElement;
import prohtml.TextElement;
import prohtml.Url;

public class HtmlTree
extends HtmlCollection {
    private HashMap weights;
    public HtmlElement pageTree;
    private HtmlElement actualElement;
    public static final String[] standAloneTags = new String[]{"area", "base", "basefont", "br", "col", "frame", "hr", "img", "input", "isindex", "link", "meta", "param", "doctype"};

    public HtmlTree(String url) throws InvalidUrlException {
        super(url);
        this.initBeforeParsing();
        this.parsePage(this.page);
        this.weights = this.getAllChildrenNumbs();
    }

    public HtmlTree(StringReader page, String url) throws InvalidUrlException {
        super(page, url);
        this.initBeforeParsing();
        try {
            this.parsePage(page);
        }
        catch (Exception e) {
            throw new InvalidUrlException(url);
        }
        this.weights = this.getAllChildrenNumbs();
    }

    void initBeforeParsing() {
        this.actualElement = this.pageTree = new HtmlElement("page", null);
    }

    void handleStartTag(String sTagName, HashMap attributes, boolean standAlone) {
        try {
            if (this.isStandAlone(sTagName) || standAlone) {
                this.actualElement.addChild(new StandAloneElement(sTagName, attributes, this.actualElement));
            } else {
                HtmlElement keep = new HtmlElement(sTagName, attributes, this.actualElement);
                this.actualElement.addChild(keep);
                this.actualElement = keep;
            }
        }
        catch (Exception e) {
            throw new InvalidUrlException();
        }
    }

    private boolean isStandAlone(String kindOfElement) {
        int i = 0;
        while (i < standAloneTags.length) {
            if (standAloneTags[i].equals(kindOfElement)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void handleAttribute(String sAttributeName, String sAttributeValue) {
        Integer keep;
        if ((sAttributeName.equals("bgcolor") || sAttributeName.equals("color")) && !this.colors.contains(keep = new Integer(this.hexToColor(sAttributeValue)))) {
            this.colors.add(keep);
        }
    }

    void doAfterEndTag() {
        try {
            this.actualElement = this.actualElement.getParent();
        }
        catch (Exception e) {
            System.out.println("+++++++++++" + this.actualElement);
            throw new InvalidUrlException();
        }
    }

    void handleText(TextElement toHandle) {
        toHandle.parent = this.actualElement;
        this.actualElement.addChild(toHandle);
    }

    public float childNumbToWeight(int childNumb) {
        return ((Float)this.weights.get(new Integer(childNumb))).floatValue();
    }

    private HashMap getAllChildrenNumbs() {
        Object[] allChildNumbs = this.getAllChildrenNumbs(this.pageTree).toArray();
        HashMap<Object, Float> result = new HashMap<Object, Float>();
        float max = allChildNumbs.length;
        float step = max / 19.0f;
        int i = 0;
        while (i < allChildNumbs.length) {
            result.put(allChildNumbs[i], new Float((float)i / step + 1.0f));
            ++i;
        }
        return result;
    }

    private TreeSet getAllChildrenNumbs(Element toCount) {
        TreeSet<Integer> result = new TreeSet<Integer>();
        List toCountChildren = toCount.getChildren();
        int i = 0;
        while (i < toCountChildren.size()) {
            result.addAll(this.getAllChildrenNumbs((Element)toCountChildren.get(i)));
            ++i;
        }
        result.add(new Integer(toCount.countAllChildren()));
        return result;
    }

    public List getLinks() {
        StandAloneElement keep2;
        List links = this.pageTree.getSpecificElements("a");
        ArrayList<Url> result = new ArrayList<Url>();
        int i = 0;
        while (i < links.size()) {
            try {
                keep2 = (HtmlElement)links.get(i);
                result.add(this.parseUrl(keep2.getAttribute("href")));
            }
            catch (Exception keep2) {
                // empty catch block
            }
            ++i;
        }
        links = this.pageTree.getSpecificElements("FRAME");
        i = 0;
        while (i < links.size()) {
            try {
                keep2 = (StandAloneElement)links.get(i);
                result.add(this.parseUrl(keep2.getAttribute("src")));
            }
            catch (Exception keep3) {
                // empty catch block
            }
            ++i;
        }
        links = this.pageTree.getSpecificElements("META");
        i = 0;
        while (i < links.size()) {
            try {
                String attValue;
                keep2 = (StandAloneElement)links.get(i);
                if (keep2.hasAttribute("http-equiv") && (attValue = keep2.getAttribute("http-equiv")).equals("refresh")) {
                    attValue = keep2.getAttribute("content");
                    attValue = attValue.substring(attValue.lastIndexOf("=") + 1, attValue.length());
                    result.add(this.parseUrl(attValue));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return result;
    }

    public static void main(String[] args) {
        HtmlTree test = null;
        try {
            test = new HtmlTree("http://www.texone.org/");
        }
        catch (Exception exception) {
            // empty catch block
        }
        TreeSet<Url> links = new TreeSet<Url>();
        TreeSet childLinks = new TreeSet();
        TreeSet<Url> allreadyBuilt = new TreeSet<Url>();
        String url = "";
        String path = "";
        List linkis = test.getLinks();
        int i = 0;
        while (i < linkis.size()) {
            links.add((Url)linkis.get(i));
            ++i;
        }
        while (true) {
            Url nextUrl;
            try {
                if (links.isEmpty()) {
                    System.out.println("add new:" + childLinks.size() + ":" + allreadyBuilt.size());
                    childLinks.removeAll(allreadyBuilt);
                    links = childLinks;
                    childLinks = new TreeSet();
                }
                nextUrl = (Url)links.last();
                links.remove(nextUrl);
            }
            catch (NoSuchElementException e) {
                break;
            }
            try {
                try {
                    url = nextUrl.getCompleteUrl();
                }
                catch (Exception e) {
                    url = String.valueOf(nextUrl.getDomain()) + nextUrl.getUrl();
                }
                System.out.println("make        : " + url);
                test = new HtmlTree(url);
                allreadyBuilt.add(nextUrl);
                List newLinks = test.getLinks();
                int i2 = 0;
                while (i2 < newLinks.size()) {
                    if (!allreadyBuilt.contains(newLinks.get(i2))) {
                        childLinks.add(newLinks.get(i2));
                    }
                    ++i2;
                }
                System.out.println("made:         " + url);
                childLinks.addAll(test.getLinks());
            }
            catch (InvalidUrlException e) {
                System.out.println("problem with: " + url);
                e.printStackTrace();
            }
        }
    }
}

