/*
 * Decompiled with CFR 0.152.
 */
package prohtml;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import prohtml.HtmlCollection;
import prohtml.InvalidUrlException;
import prohtml.LetterElement;
import prohtml.StandAloneElement;
import prohtml.TextElement;
import prohtml.Url;

public class HtmlList
extends HtmlCollection {
    public List pageList = new ArrayList();

    public HtmlList(String url) throws InvalidUrlException {
        super(url);
        this.initBeforeParsing();
        try {
            this.parsePage(this.page);
        }
        catch (Exception e) {
            throw new InvalidUrlException(url);
        }
    }

    public HtmlList(StringReader page, String url) throws InvalidUrlException {
        super(page, url);
        this.initBeforeParsing();
        try {
            this.parsePage(page);
        }
        catch (Exception e) {
            throw new InvalidUrlException(url);
        }
    }

    void initBeforeParsing() {
    }

    void handleStartTag(String sTagName, HashMap attributes, boolean standAlone) {
        this.pageList.add(new StandAloneElement(sTagName, attributes, null));
    }

    void handleAttribute(String sAttributeName, String sAttributeValue) {
        Integer keep;
        if ((sAttributeName.equals("bgcolor") || sAttributeName.equals("color")) && !this.colors.contains(keep = new Integer(this.hexToColor(sAttributeValue)))) {
            this.colors.add(keep);
        }
    }

    void doAfterEndTag() {
    }

    void handleText(TextElement toHandle) {
        this.pageList.add(toHandle);
    }

    public List getElements(String kind) {
        kind = kind.toLowerCase();
        ArrayList<LetterElement> result = new ArrayList<LetterElement>();
        int i = 0;
        while (i < this.pageList.size()) {
            LetterElement keep = (LetterElement)this.pageList.get(i);
            if (keep.kindOfElement.equals(kind)) {
                result.add(keep);
            }
            ++i;
        }
        return result;
    }

    public List getLinks() {
        StandAloneElement keep2;
        List links = this.getElements("a");
        ArrayList<Url> result = new ArrayList<Url>();
        int i = 0;
        while (i < links.size()) {
            try {
                keep2 = (StandAloneElement)links.get(i);
                result.add(this.parseUrl(keep2.getAttribute("href")));
            }
            catch (Exception keep2) {
                // empty catch block
            }
            ++i;
        }
        links = this.getElements("FRAME");
        i = 0;
        while (i < links.size()) {
            try {
                keep2 = (StandAloneElement)links.get(i);
                result.add(this.parseUrl(keep2.getAttribute("src")));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
        return result;
    }

    public void printElements() {
        int i = 0;
        while (i < this.pageList.size()) {
            System.out.println(String.valueOf(i) + " : " + this.pageList.get(i));
            ++i;
        }
    }
}

