/*
 * Decompiled with CFR 0.152.
 */
package prohtml;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import prohtml.HtmlCollection;
import prohtml.InvalidUrlException;
import prohtml.StandAloneElement;
import prohtml.TextElement;

public class HtmlElementFinder
extends HtmlCollection {
    List elements = new ArrayList();
    String kindOfElement;

    public HtmlElementFinder(String url, String kindOfElement) throws InvalidUrlException {
        super(url);
        this.kindOfElement = kindOfElement;
        this.initBeforeParsing();
        try {
            this.parsePage(this.page);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidUrlException(url);
        }
    }

    public HtmlElementFinder(StringReader page, String url, String kindOfElement) throws InvalidUrlException {
        super(page, url);
        this.kindOfElement = kindOfElement;
        this.initBeforeParsing();
        try {
            this.parsePage(page);
        }
        catch (Exception e) {
            throw new InvalidUrlException(url);
        }
    }

    void initBeforeParsing() {
        this.kindOfElement = this.kindOfElement.toUpperCase();
    }

    void handleStartTag(String sTagName, HashMap attributes, boolean standAlone) {
        if (sTagName.toUpperCase().equals(this.kindOfElement)) {
            this.elements.add(new StandAloneElement(sTagName, attributes, null));
        }
    }

    void handleAttribute(String sAttributeName, String sAttributeValue) {
    }

    void doAfterEndTag() {
    }

    void handleText(TextElement toHandle) {
        if (this.kindOfElement.equals("TEXT")) {
            this.elements.add(toHandle);
        }
    }

    public List getElements() {
        return this.elements;
    }

    public void printElements() {
        int i = 0;
        while (i < this.elements.size()) {
            System.out.println(String.valueOf(i) + " : " + this.elements.get(i));
            ++i;
        }
    }
}

