/*
 * Decompiled with CFR 0.152.
 */
package prohtml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import prohtml.Element;
import prohtml.LetterElement;
import prohtml.StandAloneElement;

public class HtmlElement
extends StandAloneElement {
    public List children;
    String text;

    public HtmlElement(String kindOfElement, HashMap attributes, List children, HtmlElement parent) {
        super(kindOfElement, attributes, parent);
        this.children = children;
    }

    public HtmlElement(String kindOfElement, HtmlElement parent) {
        this(kindOfElement, new HashMap(), new ArrayList(), parent);
    }

    public HtmlElement(String kindOfElement, List children, HtmlElement parent) {
        this(kindOfElement, new HashMap(), children, parent);
    }

    public HtmlElement(String kindOfElement, HashMap attributes, HtmlElement parent) {
        this(kindOfElement, attributes, new ArrayList(), parent);
    }

    public List getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return this.has(this.children);
    }

    public void addChild(Element element) {
        this.children.add(element);
    }

    public void addChild(Element element, int position) {
        this.children.add(position, element);
    }

    public int getDepth() {
        int result = 0;
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            result = Math.max(result, ((Element)children.get(i)).getDepth());
            ++i;
        }
        return 1 + result;
    }

    public int countAllChildren() {
        int result = 0;
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            result += ((Element)children.get(i)).countAllChildren();
            ++i;
        }
        return 1 + result;
    }

    public List getSpecificElements(String element) {
        element = element.toLowerCase();
        ArrayList<LetterElement> result = new ArrayList<LetterElement>();
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            LetterElement keep = (LetterElement)children.get(i);
            if (keep.type().equals("HtmlElement")) {
                result.addAll(((HtmlElement)keep).getSpecificElements(element));
            }
            if (keep.kindOfElement.equals(element)) {
                result.add(keep);
            }
            ++i;
        }
        return result;
    }

    public String type() {
        return "HtmlElement";
    }

    public void printElementTree(String dist) {
        this.printElementTree("", dist);
    }

    public void printElementTree(String start, String dist) {
        super.printElementTree(start, dist);
        int i = 0;
        while (i < this.children.size()) {
            ((Element)this.children.get(i)).printElementTree(String.valueOf(start) + dist, dist);
            ++i;
        }
        System.out.println(String.valueOf(start) + "</" + this.kindOfElement + ">");
    }
}

