/*
 * Decompiled with CFR 0.152.
 */
package prohtml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import prohtml.ColorConts;
import prohtml.InvalidUrlException;
import prohtml.TextElement;
import prohtml.Url;

public abstract class HtmlCollection {
    public ArrayList colors;
    public String parentUrlPart;
    Reader page;
    Reader keep;
    private boolean firstTag = false;
    static String before = "";
    static String after = "";

    public HtmlCollection(String url) throws InvalidUrlException {
        try {
            this.parentUrlPart = this.getParentUrlPart(url);
            this.page = this.openHtml(url);
            this.keep = this.openHtml(url);
            this.colors = new ArrayList();
        }
        catch (Exception e) {
            throw new InvalidUrlException(url, e);
        }
    }

    public HtmlCollection(StringReader page, String url) throws InvalidUrlException {
        try {
            this.parentUrlPart = this.getParentUrlPart(url);
            this.page = page;
            this.colors = new ArrayList();
        }
        catch (Exception e) {
            throw new InvalidUrlException();
        }
    }

    public String getSource() {
        StringBuffer result = new StringBuffer();
        try {
            int iChar;
            while ((iChar = this.keep.read()) != -1) {
                result.append((char)iChar);
            }
        }
        catch (Exception e) {
            return "fails";
        }
        return result.toString();
    }

    abstract void initBeforeParsing();

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void parsePage(Reader page) {
        this.firstTag = true;
        sbText = new StringBuffer();
        bText = false;
        bSpaceBefore = false;
        try {
            block10: while (true) lbl-1000:
            // 15 sources

            {
                if ((iChar = page.read()) == -1) {
                    return;
                }
                cChar = (char)iChar;
                switch (cChar) {
                    case '\b': {
                        ** break;
                    }
                    case '\n': {
                        ** break;
                    }
                    case '\f': {
                        ** break;
                    }
                    case '\r': {
                        ** break;
                    }
                    case '\t': {
                        ** break;
                    }
                    case '<': {
                        if (bText) {
                            bText = false;
                            this.handleText(new TextElement(sbText.toString(), null));
                            sbText = new StringBuffer();
                        }
                        if ((iChar = page.read()) == -1) continue block10;
                        cChar = (char)iChar;
                        if (cChar == '/') {
                            page = this.handleEndTag(page);
                            ** break;
                        }
                        if (cChar == '!') {
                            iChar = page.read();
                            if (iChar == -1) continue block10;
                            cChar = (char)iChar;
                            if (cChar == '-') {
                                page = this.handleComment(page);
                                ** break;
                            }
                            page = this.handleStartTag(page, new StringBuffer().append(cChar));
                            ** break;
                        }
                        page = this.handleStartTag(page, new StringBuffer().append(cChar));
                        ** break;
                    }
                }
                if (cChar == ' ') {
                    if (!bSpaceBefore && bText) {
                        this.handleText(new TextElement(sbText.toString(), null));
                        sbText = new StringBuffer();
                    }
                    bSpaceBefore = true;
                    ** break;
                }
                if (Character.getNumericValue(cChar) < 0) continue;
                bSpaceBefore = false;
                bText = true;
                sbText.append(cChar);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    Reader handleStartTag(Reader page, StringBuffer alreadyParsed) throws Exception {
        int iChar;
        boolean bTagName = true;
        boolean bSpaceBefore = false;
        boolean bLeftAttribute = false;
        StringBuffer sbTagName = alreadyParsed;
        StringBuffer sbAttributeName = new StringBuffer();
        StringBuffer sbAttributeValue = new StringBuffer();
        StringBuffer sbActual = sbTagName;
        HashMap<String, String> attributes = new HashMap<String, String>();
        boolean inValue = false;
        int oChar = 32;
        while ((iChar = page.read()) != -1) {
            char cChar = (char)iChar;
            switch (cChar) {
                case '\b': {
                    break;
                }
                case '\n': {
                    break;
                }
                case '\f': {
                    break;
                }
                case '\r': {
                    break;
                }
                case '\t': {
                    break;
                }
                case ' ': {
                    String sAttributeValue;
                    String sAttributeName;
                    if (!bSpaceBefore) {
                        if (!inValue) {
                            if (bTagName) {
                                bTagName = false;
                            } else {
                                sAttributeName = sbAttributeName.toString().toLowerCase();
                                sAttributeValue = sbAttributeValue.toString().toLowerCase();
                                attributes.put(sAttributeName, sAttributeValue);
                                this.handleAttribute(sAttributeName, sAttributeValue);
                                sbAttributeName = new StringBuffer();
                                sbAttributeValue = new StringBuffer();
                                bLeftAttribute = false;
                            }
                            sbActual = sbAttributeName;
                        } else {
                            sbActual.append(cChar);
                        }
                    }
                    bSpaceBefore = true;
                    break;
                }
                case '=': {
                    if (!inValue) {
                        sbActual = sbAttributeValue;
                        bLeftAttribute = true;
                        break;
                    }
                    sbActual.append(cChar);
                    break;
                }
                case '\"': {
                    inValue = !inValue;
                    break;
                }
                case '\'': {
                    break;
                }
                case '/': {
                    if (!inValue) break;
                    sbActual.append(cChar);
                    break;
                }
                case '>': {
                    String sAttributeValue;
                    String sAttributeName;
                    if (bLeftAttribute) {
                        sAttributeName = sbAttributeName.toString().toLowerCase();
                        sAttributeValue = sbAttributeValue.toString().toLowerCase();
                        attributes.put(sAttributeName, sAttributeValue);
                        this.handleAttribute(sAttributeName, sAttributeValue);
                    }
                    String sTagName = sbTagName.toString().toLowerCase();
                    if (this.firstTag) {
                        this.firstTag = false;
                        if (!(sTagName.equals("doctype") || sTagName.equals("html") || sTagName.equals("?xml"))) {
                            throw new InvalidUrlException();
                        }
                    }
                    if (oChar == 47) {
                        this.handleStartTag(sTagName, attributes, true);
                    } else {
                        this.handleStartTag(sTagName, attributes, false);
                    }
                    return page;
                }
                default: {
                    bSpaceBefore = false;
                    sbActual.append(cChar);
                }
            }
            oChar = cChar;
        }
        throw new InvalidUrlException();
    }

    abstract void handleStartTag(String var1, HashMap var2, boolean var3);

    abstract void handleAttribute(String var1, String var2);

    Reader handleEndTag(Reader toParse) throws Exception {
        int iChar;
        while ((iChar = toParse.read()) != -1) {
            char cChar = (char)iChar;
            switch (cChar) {
                case '\b': {
                    break;
                }
                case '\n': {
                    break;
                }
                case '\f': {
                    break;
                }
                case '\r': {
                    break;
                }
                case '\t': {
                    break;
                }
                case '>': {
                    this.doAfterEndTag();
                    return toParse;
                }
            }
        }
        throw new InvalidUrlException();
    }

    abstract void doAfterEndTag();

    Reader handleComment(Reader toParse) throws Exception {
        int iChar;
        int prevChar = 32;
        while ((iChar = toParse.read()) != -1) {
            char cChar = (char)iChar;
            if (prevChar == 45 && cChar == '>') {
                return toParse;
            }
            prevChar = cChar;
        }
        throw new InvalidUrlException();
    }

    abstract void handleText(TextElement var1);

    String getParentUrlPart(String url) {
        File test;
        File keep = test = new File(url);
        int countDepth = 0;
        while ((keep = keep.getParentFile()) != null) {
            ++countDepth;
        }
        if (countDepth > 1 && url.lastIndexOf("/") < url.lastIndexOf(".")) {
            return url.substring(0, url.lastIndexOf("/"));
        }
        return url;
    }

    String getDomain(String url) {
        File test;
        File keep = test = new File(url);
        boolean countDepth = false;
        while (keep.getParentFile() != null) {
            test = keep;
            keep = keep.getParentFile();
        }
        return test.getPath().replaceAll("\\\\", "//");
    }

    Reader openHtml(String url) throws InvalidUrlException {
        try {
            return this.openHtmlFile(url);
        }
        catch (Exception exception) {
            try {
                return this.openHtmlUrl(url);
            }
            catch (Exception exception2) {
                try {
                    return this.openHtmlUrl("open_url.php?url=" + url);
                }
                catch (Exception exception3) {
                    throw new InvalidUrlException();
                }
            }
        }
    }

    Reader openHtmlFile(String file) throws IOException {
        FileReader in = new FileReader(file);
        return in;
    }

    Reader openHtmlUrl(String givenUrl) throws IOException {
        URL url = new URL(givenUrl);
        URLConnection urlCon = url.openConnection();
        BufferedReader in = new BufferedReader(new InputStreamReader(urlCon.getInputStream()));
        return in;
    }

    int doubleHexToInt(String hex) {
        return Integer.parseInt(hex, 16);
    }

    int hexToColor(String hex) {
        int x;
        hex = hex.replaceAll("#", "");
        try {
            x = this.doubleHexToInt(hex.substring(0, 2));
        }
        catch (Exception e) {
            hex = ColorConts.colornameTohexvalue(hex);
            x = this.doubleHexToInt(hex.substring(0, 2));
        }
        int y = this.doubleHexToInt(hex.substring(2, 4));
        int z = this.doubleHexToInt(hex.substring(4, 6));
        if (x > 255) {
            x = 255;
        } else if (x < 0) {
            x = 0;
        }
        if (y > 255) {
            y = 255;
        } else if (y < 0) {
            y = 0;
        }
        if (z > 255) {
            z = 255;
        } else if (z < 0) {
            z = 0;
        }
        return 0xFF000000 | x << 16 | y << 8 | z;
    }

    public int getPageColor(int value) {
        return (Integer)this.colors.get(value);
    }

    public int getNumbOfColors() {
        return this.colors.size();
    }

    Url parseUrl(String url) throws IllegalArgumentException, InvalidUrlException {
        int pos = url.indexOf("#");
        if (pos == 0) {
            throw new InvalidUrlException("Just a link to an anchor: " + url);
        }
        if (pos > 0) {
            url = url.substring(0, pos);
        }
        if ((pos = url.indexOf("javascript:")) != -1) {
            throw new InvalidUrlException("Just a link to a javascript: " + url);
        }
        String toCheck = url.replaceAll("(\\.mp3)|(\\.pdf)|(\\.zip)|(\\.exe)", "");
        if (toCheck.length() < url.length()) {
            throw new InvalidUrlException("Just a link to a not valid file " + url);
        }
        int startLook = 0;
        String urlPart = this.parentUrlPart;
        while (url.indexOf("..") != -1) {
            startLook = url.indexOf("..") + 3;
            url = url.substring(startLook, url.length());
            try {
                urlPart = urlPart.substring(0, urlPart.lastIndexOf("/"));
            }
            catch (Exception exception) {}
        }
        pos = url.indexOf(":");
        if (pos == -1) {
            return new Url(url, String.valueOf(urlPart) + "/", this.getDomain(String.valueOf(urlPart) + "/"));
        }
        return new Url(url, "", this.getDomain(url));
    }
}

