/*
 * Decompiled with CFR 0.152.
 */
package processing.dxf;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import processing.core.PGraphics;

public class RawDXF
extends PGraphics {
    File file;
    PrintWriter writer;
    int currentLayer;

    public void setPath(String path) {
        this.path = path;
        if (path != null) {
            this.file = new File(path);
            if (!this.file.isAbsolute()) {
                this.file = null;
            }
        }
        if (this.file == null) {
            throw new RuntimeException("PGraphicsPDF requires an absolute path for the location of the output file.");
        }
    }

    protected void allocate() {
        this.setLayer(0);
    }

    public void dispose() {
        this.writeFooter();
        this.writer.flush();
        this.writer.close();
        this.writer = null;
    }

    public boolean displayable() {
        return false;
    }

    public boolean is2D() {
        return false;
    }

    public boolean is3D() {
        return true;
    }

    public void beginDraw() {
        if (this.writer == null) {
            try {
                this.writer = new PrintWriter(new FileWriter(this.file));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.writeHeader();
        }
    }

    public void endDraw() {
        this.writer.flush();
    }

    public void setLayer(int layer) {
        this.currentLayer = layer;
    }

    private void writeHeader() {
        this.writer.println("0");
        this.writer.println("SECTION");
        this.writer.println("2");
        this.writer.println("ENTITIES");
    }

    private void writeFooter() {
        this.writer.println("0");
        this.writer.println("ENDSEC");
        this.writer.println("0");
        this.writer.println("EOF");
    }

    public void write(String cmd, float val) {
        this.writer.println(cmd);
        this.writer.println(val);
    }

    public void println(String what) {
        this.writer.println(what);
    }

    protected void writeLine(int index1, int index2) {
        this.writer.println("0");
        this.writer.println("LINE");
        this.writer.println("8");
        this.writer.println(String.valueOf(this.currentLayer));
        this.write("10", this.vertices[index1][0]);
        this.write("20", this.vertices[index1][1]);
        this.write("30", this.vertices[index1][2]);
        this.write("11", this.vertices[index2][0]);
        this.write("21", this.vertices[index2][1]);
        this.write("31", this.vertices[index2][2]);
    }

    protected void writeTriangle() {
        this.writer.println("0");
        this.writer.println("3DFACE");
        this.writer.println("8");
        this.writer.println(String.valueOf(this.currentLayer));
        this.write("10", this.vertices[0][0]);
        this.write("20", this.vertices[0][1]);
        this.write("30", this.vertices[0][2]);
        this.write("11", this.vertices[1][0]);
        this.write("21", this.vertices[1][1]);
        this.write("31", this.vertices[1][2]);
        this.write("12", this.vertices[2][0]);
        this.write("22", this.vertices[2][1]);
        this.write("32", this.vertices[2][2]);
        this.write("13", this.vertices[2][0] + 1.0E-4f);
        this.write("23", this.vertices[2][1] + 1.0E-4f);
        this.write("33", this.vertices[2][2] + 1.0E-4f);
        this.vertexCount = 0;
    }

    public void beginShape(int kind) {
        this.shape = kind;
        if (this.shape != 5 && this.shape != 9 && this.shape != 20) {
            String err = "RawDXF can only be used with beginRaw(), because it only supports lines and triangles";
            throw new RuntimeException(err);
        }
        if (this.shape == 20 && this.fill) {
            throw new RuntimeException("RawDXF only supports non-filled shapes.");
        }
        this.vertexCount = 0;
    }

    public void vertex(float x, float y) {
        this.vertex(x, y, 0.0f);
    }

    public void vertex(float x, float y, float z) {
        float[] vertex = this.vertices[this.vertexCount];
        vertex[0] = x;
        vertex[1] = y;
        vertex[2] = z;
        if (this.fill) {
            vertex[3] = this.fillR;
            vertex[4] = this.fillG;
            vertex[5] = this.fillB;
            vertex[6] = this.fillA;
        }
        if (this.stroke) {
            vertex[13] = this.strokeR;
            vertex[14] = this.strokeG;
            vertex[15] = this.strokeB;
            vertex[16] = this.strokeA;
            vertex[17] = this.strokeWeight;
        }
        if (this.textureImage != null) {
            vertex[7] = this.textureU;
            vertex[8] = this.textureV;
        }
        ++this.vertexCount;
        if (this.shape == 5 && this.vertexCount == 2) {
            this.writeLine(0, 1);
            this.vertexCount = 0;
        } else if (this.shape == 9 && this.vertexCount == 3) {
            this.writeTriangle();
        }
    }

    public void endShape(int mode) {
        if (this.shape == 20) {
            int i = 0;
            while (i < this.vertexCount - 1) {
                this.writeLine(i, i + 1);
                ++i;
            }
            if (mode == 2) {
                this.writeLine(this.vertexCount - 1, 0);
            }
        }
    }
}

