/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.opengl.GLU;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;
import processing.core.PApplet;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.Texture;
import processing.opengl.tess.PGLU;
import processing.opengl.tess.PGLUtessellator;
import processing.opengl.tess.PGLUtessellatorCallbackAdapter;

public class PGL {
    public static boolean FORCE_SCREEN_FBO = false;
    public static final boolean USE_DIRECT_BUFFERS = true;
    public static final int MIN_DIRECT_BUFFER_SIZE = 1;
    public static final boolean SAVE_SURFACE_TO_PIXELS = false;
    protected static final boolean MIPMAPS_ENABLED = false;
    protected static final int DEFAULT_IN_VERTICES = 16;
    protected static final int DEFAULT_IN_EDGES = 32;
    protected static final int DEFAULT_IN_TEXTURES = 16;
    protected static final int DEFAULT_TESS_VERTICES = 16;
    protected static final int DEFAULT_TESS_INDICES = 32;
    protected static final int MAX_LIGHTS = 8;
    protected static final int MAX_VERTEX_INDEX = Short.MAX_VALUE;
    protected static final int MAX_VERTEX_INDEX1 = 32768;
    protected static final int FLUSH_VERTEX_COUNT = 32768;
    protected static final int MAX_FONT_TEX_SIZE = 512;
    protected static final float MIN_CAPS_JOINS_WEIGHT = 2.0f;
    protected static final int MAX_CAPS_JOINS_LENGTH = 1000;
    protected static final int MIN_ARRAYCOPY_SIZE = 2;
    protected static final int SIZEOF_SHORT = 2;
    protected static final int SIZEOF_INT = 4;
    protected static final int SIZEOF_FLOAT = 4;
    protected static final int SIZEOF_BYTE = 1;
    protected static final int SIZEOF_INDEX = 2;
    protected static final int INDEX_TYPE = 5123;
    protected static final String FRAMEBUFFER_ERROR_MESSAGE = "Framebuffer error (%1$s), rendering will probably not work as expected";
    protected static float FLOAT_EPS = Float.MIN_VALUE;
    protected static boolean BIG_ENDIAN;
    protected static final String SHADER_PREPROCESSOR_DIRECTIVE = "#ifdef GL_ES\nprecision mediump float;\nprecision mediump int;\n#endif\n";
    public static final int FALSE = 0;
    public static final int TRUE = 1;
    public static final int LESS = 513;
    public static final int LEQUAL = 515;
    public static final int CCW = 2305;
    public static final int CW = 2304;
    public static final int CULL_FACE = 2884;
    public static final int FRONT = 1028;
    public static final int BACK = 1029;
    public static final int FRONT_AND_BACK = 1032;
    public static final int VIEWPORT = 2978;
    public static final int SCISSOR_TEST = 3089;
    public static final int DEPTH_TEST = 2929;
    public static final int DEPTH_WRITEMASK = 2930;
    public static final int COLOR_BUFFER_BIT = 16384;
    public static final int DEPTH_BUFFER_BIT = 256;
    public static final int STENCIL_BUFFER_BIT = 1024;
    public static final int FUNC_ADD = 32774;
    public static final int FUNC_MIN = 32775;
    public static final int FUNC_MAX = 32776;
    public static final int FUNC_REVERSE_SUBTRACT = 32779;
    public static final int TEXTURE_2D = 3553;
    public static final int TEXTURE_BINDING_2D = 32873;
    public static final int RGB = 6407;
    public static final int RGBA = 6408;
    public static final int ALPHA = 6406;
    public static final int UNSIGNED_INT = 5125;
    public static final int UNSIGNED_BYTE = 5121;
    public static final int UNSIGNED_SHORT = 5123;
    public static final int FLOAT = 5126;
    public static final int NEAREST = 9728;
    public static final int LINEAR = 9729;
    public static final int LINEAR_MIPMAP_NEAREST = 9985;
    public static final int LINEAR_MIPMAP_LINEAR = 9987;
    public static final int TEXTURE_MAX_ANISOTROPY = 34046;
    public static final int MAX_TEXTURE_MAX_ANISOTROPY = 34047;
    public static final int CLAMP_TO_EDGE = 33071;
    public static final int REPEAT = 10497;
    public static final int RGBA8 = -1;
    public static final int DEPTH24_STENCIL8 = 35056;
    public static final int DEPTH_COMPONENT = 6402;
    public static final int DEPTH_COMPONENT16 = 33189;
    public static final int DEPTH_COMPONENT24 = 33190;
    public static final int DEPTH_COMPONENT32 = 33191;
    public static final int STENCIL_INDEX = 6401;
    public static final int STENCIL_INDEX1 = 36166;
    public static final int STENCIL_INDEX4 = 36167;
    public static final int STENCIL_INDEX8 = 36168;
    public static final int ARRAY_BUFFER = 34962;
    public static final int ELEMENT_ARRAY_BUFFER = 34963;
    public static final int SAMPLES = 32937;
    public static final int FRAMEBUFFER_COMPLETE = 36053;
    public static final int FRAMEBUFFER_INCOMPLETE_ATTACHMENT = 36054;
    public static final int FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = 36055;
    public static final int FRAMEBUFFER_INCOMPLETE_DIMENSIONS = 36057;
    public static final int FRAMEBUFFER_INCOMPLETE_FORMATS = 36058;
    public static final int FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = -1;
    public static final int FRAMEBUFFER_INCOMPLETE_READ_BUFFER = -1;
    public static final int FRAMEBUFFER_UNSUPPORTED = 36061;
    public static final int STATIC_DRAW = 35044;
    public static final int DYNAMIC_DRAW = 35048;
    public static final int STREAM_DRAW = 35040;
    public static final int READ_ONLY = -1;
    public static final int WRITE_ONLY = -1;
    public static final int READ_WRITE = -1;
    public static final int TRIANGLE_FAN = 6;
    public static final int TRIANGLE_STRIP = 5;
    public static final int TRIANGLES = 4;
    public static final int VENDOR = 7936;
    public static final int RENDERER = 7937;
    public static final int VERSION = 7938;
    public static final int EXTENSIONS = 7939;
    public static final int SHADING_LANGUAGE_VERSION = 35724;
    public static final int MAX_TEXTURE_SIZE = 3379;
    public static final int MAX_SAMPLES = -1;
    public static final int ALIASED_LINE_WIDTH_RANGE = 33902;
    public static final int ALIASED_POINT_SIZE_RANGE = 33901;
    public static final int DEPTH_BITS = 3414;
    public static final int STENCIL_BITS = 3415;
    public static final int TESS_WINDING_NONZERO = 100131;
    public static final int TESS_WINDING_ODD = 100130;
    public static final int TEXTURE0 = 33984;
    public static final int TEXTURE1 = 33985;
    public static final int TEXTURE2 = 33986;
    public static final int TEXTURE3 = 33987;
    public static final int TEXTURE_MIN_FILTER = 10241;
    public static final int TEXTURE_MAG_FILTER = 10240;
    public static final int TEXTURE_WRAP_S = 10242;
    public static final int TEXTURE_WRAP_T = 10243;
    public static final int BLEND = 3042;
    public static final int ONE = 1;
    public static final int ZERO = 0;
    public static final int SRC_ALPHA = 770;
    public static final int DST_ALPHA = 772;
    public static final int ONE_MINUS_SRC_ALPHA = 771;
    public static final int ONE_MINUS_DST_COLOR = 775;
    public static final int ONE_MINUS_SRC_COLOR = 769;
    public static final int DST_COLOR = 774;
    public static final int SRC_COLOR = 768;
    public static final int FRAMEBUFFER = 36160;
    public static final int COLOR_ATTACHMENT0 = 36064;
    public static final int COLOR_ATTACHMENT1 = -1;
    public static final int COLOR_ATTACHMENT2 = -1;
    public static final int COLOR_ATTACHMENT3 = -1;
    public static final int RENDERBUFFER = 36161;
    public static final int DEPTH_ATTACHMENT = 36096;
    public static final int STENCIL_ATTACHMENT = 36128;
    public static final int READ_FRAMEBUFFER = -1;
    public static final int DRAW_FRAMEBUFFER = -1;
    public static final int VERTEX_SHADER = 35633;
    public static final int FRAGMENT_SHADER = 35632;
    public static final int INFO_LOG_LENGTH = 35716;
    public static final int SHADER_SOURCE_LENGTH = 35720;
    public static final int COMPILE_STATUS = 35713;
    public static final int LINK_STATUS = 35714;
    public static final int VALIDATE_STATUS = 35715;
    public static final int MULTISAMPLE = -1;
    public static final int POINT_SMOOTH = -1;
    public static final int LINE_SMOOTH = -1;
    public static final int POLYGON_SMOOTH = -1;
    protected static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    protected static final int EGL_OPENGL_ES2_BIT = 4;
    public static GL10 gl;
    public static PGLU glu;
    public static EGLContext context;
    public static GLSurfaceView glview;
    protected PGraphicsOpenGL pg;
    protected static AndroidRenderer renderer;
    protected static Thread glThread;
    protected static boolean[] texturingTargets;
    protected static int[] boundTextures;
    protected static boolean fboLayerByDefault;
    protected static boolean fboLayerCreated;
    protected static boolean fboLayerInUse;
    protected static boolean firstFrame;
    protected static int reqNumSamples;
    protected static int numSamples;
    protected static IntBuffer glColorFbo;
    protected static IntBuffer glMultiFbo;
    protected static IntBuffer glColorBuf;
    protected static IntBuffer glColorTex;
    protected static IntBuffer glDepthStencil;
    protected static IntBuffer glDepth;
    protected static IntBuffer glStencil;
    protected static int fboWidth;
    protected static int fboHeight;
    protected static int backTex;
    protected static int frontTex;
    protected static boolean loadedTexShader;
    protected static int texShaderProgram;
    protected static int texVertShader;
    protected static int texFragShader;
    protected static EGLContext texShaderContext;
    protected static int texVertLoc;
    protected static int texTCoordLoc;
    protected static float[] texCoords;
    protected static FloatBuffer texData;
    protected static String texVertShaderSource;
    protected static String texFragShaderSource;
    protected ByteBuffer byteBuffer;
    protected IntBuffer intBuffer;
    protected IntBuffer colorBuffer;
    protected FloatBuffer depthBuffer;
    protected ByteBuffer stencilBuffer;

    public PGL(PGraphicsOpenGL pGraphicsOpenGL) {
        this.pg = pGraphicsOpenGL;
        if (glu == null) {
            glu = new PGLU();
        }
        if (glColorTex == null) {
            glColorTex = PGL.allocateIntBuffer(2);
            glColorFbo = PGL.allocateIntBuffer(1);
            glMultiFbo = PGL.allocateIntBuffer(1);
            glColorBuf = PGL.allocateIntBuffer(1);
            glDepthStencil = PGL.allocateIntBuffer(1);
            glDepth = PGL.allocateIntBuffer(1);
            glStencil = PGL.allocateIntBuffer(1);
            fboLayerCreated = false;
            fboLayerInUse = false;
            firstFrame = false;
        }
        this.byteBuffer = PGL.allocateByteBuffer(1);
        this.intBuffer = PGL.allocateIntBuffer(1);
    }

    protected void setFrameRate(float f) {
    }

    protected void initSurface(int n) {
        glview = (GLSurfaceView)this.pg.parent.getSurfaceView();
        reqNumSamples = this.qualityToSamples(n);
        fboLayerCreated = false;
        fboLayerInUse = false;
        firstFrame = true;
    }

    protected void deleteSurface() {
        if (this.threadIsCurrent() && glColorTex != null) {
            this.deleteTextures(2, glColorTex);
            this.deleteFramebuffers(1, glColorFbo);
            this.deleteFramebuffers(1, glMultiFbo);
            this.deleteRenderbuffers(1, glColorBuf);
            this.deleteRenderbuffers(1, glDepthStencil);
            this.deleteRenderbuffers(1, glDepth);
            this.deleteRenderbuffers(1, glStencil);
        }
        fboLayerCreated = false;
        fboLayerInUse = false;
        firstFrame = true;
    }

    protected void update() {
        if (!fboLayerCreated) {
            int n;
            String string = this.getString(7939);
            if (-1 < string.indexOf("texture_non_power_of_two")) {
                fboWidth = this.pg.width;
                fboHeight = this.pg.height;
            } else {
                fboWidth = PGL.nextPowerOfTwo(this.pg.width);
                fboHeight = PGL.nextPowerOfTwo(this.pg.height);
            }
            this.getIntegerv(-1, this.intBuffer);
            numSamples = -1 < string.indexOf("_framebuffer_multisample") && 1 < this.intBuffer.get(0) ? reqNumSamples : 1;
            boolean bl = 1 < numSamples;
            boolean bl2 = string.indexOf("packed_depth_stencil") != -1;
            int n2 = this.getDepthBits();
            int n3 = this.getStencilBits();
            this.genTextures(2, glColorTex);
            for (n = 0; n < 2; ++n) {
                this.bindTexture(3553, glColorTex.get(n));
                this.texParameteri(3553, 10241, 9728);
                this.texParameteri(3553, 10240, 9728);
                this.texParameteri(3553, 10242, 33071);
                this.texParameteri(3553, 10243, 33071);
                this.texImage2D(3553, 0, 6408, fboWidth, fboHeight, 0, 6408, 5121, null);
                this.initTexture(3553, 6408, fboWidth, fboHeight, this.pg.backgroundColor);
            }
            this.bindTexture(3553, 0);
            backTex = 0;
            frontTex = 1;
            this.genFramebuffers(1, glColorFbo);
            this.bindFramebuffer(36160, glColorFbo.get(0));
            this.framebufferTexture2D(36160, 36064, 3553, glColorTex.get(backTex), 0);
            if (bl) {
                this.genFramebuffers(1, glMultiFbo);
                this.bindFramebuffer(36160, glMultiFbo.get(0));
                this.genRenderbuffers(1, glColorBuf);
                this.bindRenderbuffer(36161, glColorBuf.get(0));
                this.renderbufferStorageMultisample(36161, numSamples, -1, fboWidth, fboHeight);
                this.framebufferRenderbuffer(36160, 36064, 36161, glColorBuf.get(0));
            }
            if (bl2 && n2 == 24 && n3 == 8) {
                this.genRenderbuffers(1, glDepthStencil);
                this.bindRenderbuffer(36161, glDepthStencil.get(0));
                if (bl) {
                    this.renderbufferStorageMultisample(36161, numSamples, 35056, fboWidth, fboHeight);
                } else {
                    this.renderbufferStorage(36161, 35056, fboWidth, fboHeight);
                }
                this.framebufferRenderbuffer(36160, 36096, 36161, glDepthStencil.get(0));
                this.framebufferRenderbuffer(36160, 36128, 36161, glDepthStencil.get(0));
            } else {
                if (0 < n2) {
                    n = 33189;
                    if (n2 == 32) {
                        n = 33191;
                    } else if (n2 == 24) {
                        n = 33190;
                    } else if (n2 == 16) {
                        n = 33189;
                    }
                    this.genRenderbuffers(1, glDepth);
                    this.bindRenderbuffer(36161, glDepth.get(0));
                    if (bl) {
                        this.renderbufferStorageMultisample(36161, numSamples, n, fboWidth, fboHeight);
                    } else {
                        this.renderbufferStorage(36161, n, fboWidth, fboHeight);
                    }
                    this.framebufferRenderbuffer(36160, 36096, 36161, glDepth.get(0));
                }
                if (0 < n3) {
                    n = 36166;
                    if (n3 == 8) {
                        n = 36168;
                    } else if (n3 == 4) {
                        n = 36167;
                    } else if (n3 == 1) {
                        n = 36166;
                    }
                    this.genRenderbuffers(1, glStencil);
                    this.bindRenderbuffer(36161, glStencil.get(0));
                    if (bl) {
                        this.renderbufferStorageMultisample(36161, numSamples, n, fboWidth, fboHeight);
                    } else {
                        this.renderbufferStorage(36161, n, fboWidth, fboHeight);
                    }
                    this.framebufferRenderbuffer(36160, 36128, 36161, glStencil.get(0));
                }
            }
            this.validateFramebuffer();
            this.clearDepth(1.0f);
            this.clearStencil(0);
            n = this.pg.backgroundColor;
            float f = (float)(n >> 24 & 0xFF) / 255.0f;
            float f2 = (float)(n >> 16 & 0xFF) / 255.0f;
            float f3 = (float)(n >> 8 & 0xFF) / 255.0f;
            float f4 = (float)(n & 0xFF) / 255.0f;
            this.clearColor(f2, f3, f4, f);
            this.clear(17664);
            this.bindFramebuffer(36160, 0);
            fboLayerCreated = true;
        }
    }

    protected int getReadFramebuffer() {
        if (fboLayerInUse) {
            return glColorFbo.get(0);
        }
        return 0;
    }

    protected int getDrawFramebuffer() {
        if (fboLayerInUse) {
            return glColorFbo.get(0);
        }
        return 0;
    }

    protected int getDefaultDrawBuffer() {
        if (fboLayerInUse) {
            return 36064;
        }
        return 1029;
    }

    protected int getDefaultReadBuffer() {
        if (fboLayerInUse) {
            return 36064;
        }
        return 1028;
    }

    protected boolean isFBOBacked() {
        return fboLayerInUse;
    }

    protected void needFBOLayer() {
        FORCE_SCREEN_FBO = true;
    }

    protected boolean isMultisampled() {
        return false;
    }

    protected int getDepthBits() {
        this.intBuffer.rewind();
        this.getIntegerv(3414, this.intBuffer);
        return this.intBuffer.get(0);
    }

    protected int getStencilBits() {
        this.intBuffer.rewind();
        this.getIntegerv(3415, this.intBuffer);
        return this.intBuffer.get(0);
    }

    protected boolean getDepthTest() {
        this.intBuffer.rewind();
        this.getBooleanv(2929, this.intBuffer);
        return this.intBuffer.get(0) != 0;
    }

    protected boolean getDepthWriteMask() {
        this.intBuffer.rewind();
        this.getBooleanv(2930, this.intBuffer);
        return this.intBuffer.get(0) != 0;
    }

    protected Texture wrapBackTexture() {
        Texture texture = new Texture(this.pg.parent);
        texture.init(this.pg.width, this.pg.height, glColorTex.get(backTex), 3553, 6408, fboWidth, fboHeight, 9728, 9728, 33071, 33071);
        texture.invertedY(true);
        texture.colorBufferOf(this.pg);
        this.pg.setCache(this.pg, texture);
        return texture;
    }

    protected Texture wrapFrontTexture() {
        Texture texture = new Texture(this.pg.parent);
        texture.init(this.pg.width, this.pg.height, glColorTex.get(frontTex), 3553, 6408, fboWidth, fboHeight, 9728, 9728, 33071, 33071);
        texture.invertedY(true);
        texture.colorBufferOf(this.pg);
        return texture;
    }

    int getBackTextureName() {
        return glColorTex.get(backTex);
    }

    int getFrontTextureName() {
        return glColorTex.get(frontTex);
    }

    protected void bindFrontTexture() {
        if (!this.texturingIsEnabled(3553)) {
            this.enableTexturing(3553);
        }
        this.bindTexture(3553, glColorTex.get(frontTex));
    }

    protected void unbindFrontTexture() {
        if (this.textureIsBound(3553, glColorTex.get(frontTex))) {
            if (!this.texturingIsEnabled(3553)) {
                this.enableTexturing(3553);
                this.bindTexture(3553, 0);
                this.disableTexturing(3553);
            } else {
                this.bindTexture(3553, 0);
            }
        }
    }

    protected void syncBackTexture() {
        if (1 < numSamples) {
            this.bindFramebuffer(-1, glMultiFbo.get(0));
            this.bindFramebuffer(-1, glColorFbo.get(0));
            this.blitFramebuffer(0, 0, fboWidth, fboHeight, 0, 0, fboWidth, fboHeight, 16384, 9728);
        }
    }

    protected int qualityToSamples(int n) {
        if (n <= 1) {
            return 1;
        }
        int n2 = 2 * (n / 2);
        return n2;
    }

    protected void beginDraw(boolean bl) {
        if (this.fboLayerInUse(bl)) {
            this.bindFramebuffer(36160, glColorFbo.get(0));
            this.framebufferTexture2D(36160, 36064, 3553, glColorTex.get(backTex), 0);
            if (1 < numSamples) {
                this.bindFramebuffer(36160, glMultiFbo.get(0));
            }
            if (firstFrame) {
                int n = this.pg.backgroundColor;
                float f = (float)(n >> 24 & 0xFF) / 255.0f;
                float f2 = (float)(n >> 16 & 0xFF) / 255.0f;
                float f3 = (float)(n >> 8 & 0xFF) / 255.0f;
                float f4 = (float)(n & 0xFF) / 255.0f;
                this.clearColor(f2, f3, f4, f);
                this.clear(16384);
            } else if (!bl) {
                this.drawTexture(3553, glColorTex.get(frontTex), fboWidth, fboHeight, 0, 0, this.pg.width, this.pg.height, 0, 0, this.pg.width, this.pg.height);
            }
            fboLayerInUse = true;
        } else {
            fboLayerInUse = false;
        }
        if (firstFrame) {
            firstFrame = false;
        }
        if (!fboLayerByDefault) {
            FORCE_SCREEN_FBO = false;
        }
    }

    protected void endDraw(boolean bl) {
        if (fboLayerInUse) {
            this.syncBackTexture();
            this.bindFramebuffer(36160, 0);
            this.clearDepth(1.0f);
            this.clearColor(0.0f, 0.0f, 0.0f, 0.0f);
            this.clear(16640);
            this.disable(3042);
            this.drawTexture(3553, glColorTex.get(backTex), fboWidth, fboHeight, 0, 0, this.pg.width, this.pg.height, 0, 0, this.pg.width, this.pg.height);
            int n = frontTex;
            frontTex = backTex;
            backTex = n;
        }
        this.flush();
    }

    protected boolean canDraw() {
        return true;
    }

    protected void requestDraw() {
        if (this.pg.initialized && this.pg.parent.canDraw()) {
            glview.requestRender();
        }
    }

    protected boolean threadIsCurrent() {
        return Thread.currentThread() == glThread;
    }

    protected boolean fboLayerInUse(boolean bl) {
        boolean bl2 = !bl || FORCE_SCREEN_FBO || 1 < numSamples;
        return bl2 && glColorFbo.get(0) != 0;
    }

    protected void beginGL() {
    }

    protected void endGL() {
    }

    public String getString(int n) {
        return GLES20.glGetString((int)n);
    }

    public void getIntegerv(int n, IntBuffer intBuffer) {
        if (-1 < n) {
            GLES20.glGetIntegerv((int)n, (IntBuffer)intBuffer);
        } else {
            PGL.fillIntBuffer(intBuffer, 0, intBuffer.capacity(), 0);
        }
    }

    public void getFloatv(int n, FloatBuffer floatBuffer) {
        if (-1 < n) {
            GLES20.glGetFloatv((int)n, (FloatBuffer)floatBuffer);
        } else {
            PGL.fillFloatBuffer(floatBuffer, 0, floatBuffer.capacity(), 0.0f);
        }
    }

    public void getBooleanv(int n, IntBuffer intBuffer) {
        if (-1 < n) {
            GLES20.glGetBooleanv((int)n, (IntBuffer)intBuffer);
        } else {
            PGL.fillIntBuffer(intBuffer, 0, intBuffer.capacity(), 0);
        }
    }

    public void enable(int n) {
        if (-1 < n) {
            GLES20.glEnable((int)n);
        }
    }

    public void disable(int n) {
        if (-1 < n) {
            GLES20.glDisable((int)n);
        }
    }

    public void flush() {
        GLES20.glFlush();
    }

    public void finish() {
        GLES20.glFinish();
    }

    public int getError() {
        return GLES20.glGetError();
    }

    public String errorString(int n) {
        return GLU.gluErrorString((int)n);
    }

    public void frontFace(int n) {
        GLES20.glFrontFace((int)n);
    }

    public void cullFace(int n) {
        GLES20.glCullFace((int)n);
    }

    public void depthMask(boolean bl) {
        GLES20.glDepthMask((boolean)bl);
    }

    public void depthFunc(int n) {
        GLES20.glDepthFunc((int)n);
    }

    public void genTextures(int n, IntBuffer intBuffer) {
        GLES20.glGenTextures((int)n, (IntBuffer)intBuffer);
    }

    public void deleteTextures(int n, IntBuffer intBuffer) {
        GLES20.glDeleteTextures((int)n, (IntBuffer)intBuffer);
    }

    public void activeTexture(int n) {
        GLES20.glActiveTexture((int)n);
    }

    public void bindTexture(int n, int n2) {
        GLES20.glBindTexture((int)n, (int)n2);
        if (n == 3553) {
            PGL.boundTextures[0] = n2;
        }
    }

    public void texImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        GLES20.glTexImage2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (Buffer)buffer);
    }

    public void texSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Buffer buffer) {
        GLES20.glTexSubImage2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (Buffer)buffer);
    }

    public void texParameteri(int n, int n2, int n3) {
        GLES20.glTexParameteri((int)n, (int)n2, (int)n3);
    }

    public void texParameterf(int n, int n2, float f) {
        GLES20.glTexParameterf((int)n, (int)n2, (float)f);
    }

    public void getTexParameteriv(int n, int n2, IntBuffer intBuffer) {
        GLES20.glGetTexParameteriv((int)n, (int)n2, (IntBuffer)intBuffer);
    }

    public void generateMipmap(int n) {
        GLES20.glGenerateMipmap((int)n);
    }

    public void genBuffers(int n, IntBuffer intBuffer) {
        GLES20.glGenBuffers((int)n, (IntBuffer)intBuffer);
    }

    public void deleteBuffers(int n, IntBuffer intBuffer) {
        GLES20.glDeleteBuffers((int)n, (IntBuffer)intBuffer);
    }

    public void bindBuffer(int n, int n2) {
        GLES20.glBindBuffer((int)n, (int)n2);
    }

    public void bufferData(int n, int n2, Buffer buffer, int n3) {
        GLES20.glBufferData((int)n, (int)n2, (Buffer)buffer, (int)n3);
    }

    public void bufferSubData(int n, int n2, int n3, Buffer buffer) {
        GLES20.glBufferSubData((int)n, (int)n2, (int)n3, (Buffer)buffer);
    }

    public void drawArrays(int n, int n2, int n3) {
        GLES20.glDrawArrays((int)n, (int)n2, (int)n3);
    }

    public void drawElements(int n, int n2, int n3, int n4) {
        GLES20.glDrawElements((int)n, (int)n2, (int)n3, (int)n4);
    }

    public void enableVertexAttribArray(int n) {
        GLES20.glEnableVertexAttribArray((int)n);
    }

    public void disableVertexAttribArray(int n) {
        GLES20.glDisableVertexAttribArray((int)n);
    }

    public void vertexAttribPointer(int n, int n2, int n3, boolean bl, int n4, int n5) {
        GLES20.glVertexAttribPointer((int)n, (int)n2, (int)n3, (boolean)bl, (int)n4, (int)n5);
    }

    public void vertexAttribPointer(int n, int n2, int n3, boolean bl, int n4, Buffer buffer) {
        GLES20.glVertexAttribPointer((int)n, (int)n2, (int)n3, (boolean)bl, (int)n4, (Buffer)buffer);
    }

    public ByteBuffer mapBuffer(int n, int n2) {
        return null;
    }

    public ByteBuffer mapBufferRange(int n, int n2, int n3, int n4) {
        return null;
    }

    public void unmapBuffer(int n) {
    }

    public void genFramebuffers(int n, IntBuffer intBuffer) {
        GLES20.glGenFramebuffers((int)n, (IntBuffer)intBuffer);
    }

    public void deleteFramebuffers(int n, IntBuffer intBuffer) {
        GLES20.glDeleteFramebuffers((int)n, (IntBuffer)intBuffer);
    }

    public void bindFramebuffer(int n, int n2) {
        GLES20.glBindFramebuffer((int)n, (int)n2);
    }

    public void genRenderbuffers(int n, IntBuffer intBuffer) {
        GLES20.glGenRenderbuffers((int)n, (IntBuffer)intBuffer);
    }

    public void deleteRenderbuffers(int n, IntBuffer intBuffer) {
        GLES20.glDeleteRenderbuffers((int)n, (IntBuffer)intBuffer);
    }

    public void blitFramebuffer(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
    }

    public void framebufferTexture2D(int n, int n2, int n3, int n4, int n5) {
        GLES20.glFramebufferTexture2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5);
    }

    public void bindRenderbuffer(int n, int n2) {
        GLES20.glBindRenderbuffer((int)n, (int)n2);
    }

    public void renderbufferStorageMultisample(int n, int n2, int n3, int n4, int n5) {
    }

    public void renderbufferStorage(int n, int n2, int n3, int n4) {
        GLES20.glRenderbufferStorage((int)n, (int)n2, (int)n3, (int)n4);
    }

    public void framebufferRenderbuffer(int n, int n2, int n3, int n4) {
        GLES20.glFramebufferRenderbuffer((int)n, (int)n2, (int)n3, (int)n4);
    }

    public int checkFramebufferStatus(int n) {
        return GLES20.glCheckFramebufferStatus((int)n);
    }

    public int createProgram() {
        return GLES20.glCreateProgram();
    }

    public void deleteProgram(int n) {
        GLES20.glDeleteProgram((int)n);
    }

    public int createShader(int n) {
        return GLES20.glCreateShader((int)n);
    }

    public void deleteShader(int n) {
        GLES20.glDeleteShader((int)n);
    }

    public void linkProgram(int n) {
        GLES20.glLinkProgram((int)n);
    }

    public void validateProgram(int n) {
        GLES20.glValidateProgram((int)n);
    }

    public void useProgram(int n) {
        GLES20.glUseProgram((int)n);
    }

    public int getAttribLocation(int n, String string) {
        return GLES20.glGetAttribLocation((int)n, (String)string);
    }

    public int getUniformLocation(int n, String string) {
        return GLES20.glGetUniformLocation((int)n, (String)string);
    }

    public void uniform1i(int n, int n2) {
        GLES20.glUniform1i((int)n, (int)n2);
    }

    public void uniform2i(int n, int n2, int n3) {
        GLES20.glUniform2i((int)n, (int)n2, (int)n3);
    }

    public void uniform3i(int n, int n2, int n3, int n4) {
        GLES20.glUniform3i((int)n, (int)n2, (int)n3, (int)n4);
    }

    public void uniform4i(int n, int n2, int n3, int n4, int n5) {
        GLES20.glUniform4i((int)n, (int)n2, (int)n3, (int)n4, (int)n5);
    }

    public void uniform1f(int n, float f) {
        GLES20.glUniform1f((int)n, (float)f);
    }

    public void uniform2f(int n, float f, float f2) {
        GLES20.glUniform2f((int)n, (float)f, (float)f2);
    }

    public void uniform3f(int n, float f, float f2, float f3) {
        GLES20.glUniform3f((int)n, (float)f, (float)f2, (float)f3);
    }

    public void uniform4f(int n, float f, float f2, float f3, float f4) {
        GLES20.glUniform4f((int)n, (float)f, (float)f2, (float)f3, (float)f4);
    }

    public void uniform1iv(int n, int n2, IntBuffer intBuffer) {
        GLES20.glUniform1iv((int)n, (int)n2, (IntBuffer)intBuffer);
    }

    public void uniform2iv(int n, int n2, IntBuffer intBuffer) {
        GLES20.glUniform2iv((int)n, (int)n2, (IntBuffer)intBuffer);
    }

    public void uniform3iv(int n, int n2, IntBuffer intBuffer) {
        GLES20.glUniform3iv((int)n, (int)n2, (IntBuffer)intBuffer);
    }

    public void uniform4iv(int n, int n2, IntBuffer intBuffer) {
        GLES20.glUniform4iv((int)n, (int)n2, (IntBuffer)intBuffer);
    }

    public void uniform1fv(int n, int n2, FloatBuffer floatBuffer) {
        GLES20.glUniform1fv((int)n, (int)n2, (FloatBuffer)floatBuffer);
    }

    public void uniform2fv(int n, int n2, FloatBuffer floatBuffer) {
        GLES20.glUniform2fv((int)n, (int)n2, (FloatBuffer)floatBuffer);
    }

    public void uniform3fv(int n, int n2, FloatBuffer floatBuffer) {
        GLES20.glUniform3fv((int)n, (int)n2, (FloatBuffer)floatBuffer);
    }

    public void uniform4fv(int n, int n2, FloatBuffer floatBuffer) {
        GLES20.glUniform4fv((int)n, (int)n2, (FloatBuffer)floatBuffer);
    }

    public void uniformMatrix2fv(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        GLES20.glUniformMatrix2fv((int)n, (int)n2, (boolean)bl, (FloatBuffer)floatBuffer);
    }

    public void uniformMatrix3fv(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        GLES20.glUniformMatrix3fv((int)n, (int)n2, (boolean)bl, (FloatBuffer)floatBuffer);
    }

    public void uniformMatrix4fv(int n, int n2, boolean bl, FloatBuffer floatBuffer) {
        GLES20.glUniformMatrix4fv((int)n, (int)n2, (boolean)bl, (FloatBuffer)floatBuffer);
    }

    public void vertexAttrib1f(int n, float f) {
        GLES20.glVertexAttrib1f((int)n, (float)f);
    }

    public void vertexAttrib2f(int n, float f, float f2) {
        GLES20.glVertexAttrib2f((int)n, (float)f, (float)f2);
    }

    public void vertexAttrib3f(int n, float f, float f2, float f3) {
        GLES20.glVertexAttrib3f((int)n, (float)f, (float)f2, (float)f3);
    }

    public void vertexAttrib4f(int n, float f, float f2, float f3, float f4) {
        GLES20.glVertexAttrib4f((int)n, (float)f, (float)f2, (float)f3, (float)f4);
    }

    public void vertexAttrib1fv(int n, FloatBuffer floatBuffer) {
        GLES20.glVertexAttrib1fv((int)n, (FloatBuffer)floatBuffer);
    }

    public void vertexAttrib2fv(int n, FloatBuffer floatBuffer) {
        GLES20.glVertexAttrib2fv((int)n, (FloatBuffer)floatBuffer);
    }

    public void vertexAttrib3fv(int n, FloatBuffer floatBuffer) {
        GLES20.glVertexAttrib3fv((int)n, (FloatBuffer)floatBuffer);
    }

    public void vertexAttri4fv(int n, FloatBuffer floatBuffer) {
        GLES20.glVertexAttrib4fv((int)n, (FloatBuffer)floatBuffer);
    }

    public void shaderSource(int n, String string) {
        GLES20.glShaderSource((int)n, (String)string);
    }

    public void compileShader(int n) {
        GLES20.glCompileShader((int)n);
    }

    public void attachShader(int n, int n2) {
        GLES20.glAttachShader((int)n, (int)n2);
    }

    public void getShaderiv(int n, int n2, IntBuffer intBuffer) {
        GLES20.glGetShaderiv((int)n, (int)n2, (IntBuffer)intBuffer);
    }

    public String getShaderInfoLog(int n) {
        return GLES20.glGetShaderInfoLog((int)n);
    }

    public void getProgramiv(int n, int n2, IntBuffer intBuffer) {
        GLES20.glGetProgramiv((int)n, (int)n2, (IntBuffer)intBuffer);
    }

    public String getProgramInfoLog(int n) {
        return GLES20.glGetProgramInfoLog((int)n);
    }

    public void viewport(int n, int n2, int n3, int n4) {
        GLES20.glViewport((int)n, (int)n2, (int)n3, (int)n4);
    }

    public void scissor(int n, int n2, int n3, int n4) {
        GLES20.glScissor((int)n, (int)n2, (int)n3, (int)n4);
    }

    public void blendEquation(int n) {
        GLES20.glBlendEquation((int)n);
    }

    public void blendFunc(int n, int n2) {
        GLES20.glBlendFunc((int)n, (int)n2);
    }

    public void readBuffer(int n) {
    }

    public void readPixels(int n, int n2, int n3, int n4, int n5, int n6, Buffer buffer) {
        GLES20.glReadPixels((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (Buffer)buffer);
    }

    public void drawBuffer(int n) {
    }

    public void clearDepth(float f) {
        GLES20.glClearDepthf((float)f);
    }

    public void clearStencil(int n) {
        GLES20.glClearStencil((int)n);
    }

    public void colorMask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        GLES20.glColorMask((boolean)bl, (boolean)bl2, (boolean)bl3, (boolean)bl4);
    }

    public void clearColor(float f, float f2, float f3, float f4) {
        GLES20.glClearColor((float)f, (float)f2, (float)f3, (float)f4);
    }

    public void clear(int n) {
        GLES20.glClear((int)n);
    }

    protected int createEmptyContext() {
        return -1;
    }

    protected int getCurrentContext() {
        return context.hashCode();
    }

    protected Tessellator createTessellator(TessellatorCallback tessellatorCallback) {
        return new Tessellator(tessellatorCallback);
    }

    protected String tessError(int n) {
        return PGLU.gluErrorString(n);
    }

    protected boolean contextIsCurrent(int n) {
        return n == -1 || n == context.hashCode();
    }

    protected void enableTexturing(int n) {
        if (n == 3553) {
            PGL.texturingTargets[0] = true;
        }
    }

    protected void disableTexturing(int n) {
        if (n == 3553) {
            PGL.texturingTargets[0] = false;
        }
    }

    protected boolean texturingIsEnabled(int n) {
        if (n == 3553) {
            return texturingTargets[0];
        }
        return false;
    }

    protected boolean textureIsBound(int n, int n2) {
        if (n == 3553) {
            return boundTextures[0] == n2;
        }
        return false;
    }

    protected void initTexture(int n, int n2, int n3, int n4) {
        this.initTexture(n, n2, n3, n4, 0);
    }

    protected void initTexture(int n, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[256];
        Arrays.fill(nArray, PGL.javaToNativeARGB(n5));
        IntBuffer intBuffer = PGL.allocateDirectIntBuffer(256);
        intBuffer.put(nArray);
        intBuffer.rewind();
        for (int i = 0; i < n4; i += 16) {
            int n6 = PApplet.min(16, n4 - i);
            for (int j = 0; j < n3; j += 16) {
                int n7 = PApplet.min(16, n3 - j);
                this.texSubImage2D(n, 0, j, i, n7, n6, n2, 5121, intBuffer);
            }
        }
    }

    protected void copyToTexture(int n, int n2, int n3, int n4, int n5, int n6, int n7, IntBuffer intBuffer) {
        this.activeTexture(33984);
        boolean bl = false;
        if (!this.texturingIsEnabled(n)) {
            this.enableTexturing(n);
            bl = true;
        }
        this.bindTexture(n, n3);
        this.texSubImage2D(n, 0, n4, n5, n6, n7, n2, 5121, intBuffer);
        this.bindTexture(n, 0);
        if (bl) {
            this.disableTexturing(n);
        }
    }

    protected void drawTexture(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.drawTexture(n, n2, n3, n4, n5, n6, n7, n8, n5, n6, n7, n8);
    }

    protected void drawTexture(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        if (!loadedTexShader || texShaderContext.hashCode() != context.hashCode()) {
            texVertShader = this.createShader(35633, texVertShaderSource);
            texFragShader = this.createShader(35632, texFragShaderSource);
            if (0 < texVertShader && 0 < texFragShader) {
                texShaderProgram = this.createProgram(texVertShader, texFragShader);
            }
            if (0 < texShaderProgram) {
                texVertLoc = this.getAttribLocation(texShaderProgram, "inVertex");
                texTCoordLoc = this.getAttribLocation(texShaderProgram, "inTexcoord");
            }
            loadedTexShader = true;
            texShaderContext = context;
        }
        if (texData == null) {
            texData = PGL.allocateDirectFloatBuffer(texCoords.length);
        }
        if (0 < texShaderProgram) {
            boolean bl = this.getDepthTest();
            this.disable(2929);
            boolean bl2 = this.getDepthWriteMask();
            this.depthMask(false);
            this.useProgram(texShaderProgram);
            this.enableVertexAttribArray(texVertLoc);
            this.enableVertexAttribArray(texTCoordLoc);
            PGL.texCoords[0] = 2.0f * (float)n9 / (float)this.pg.width - 1.0f;
            PGL.texCoords[1] = 2.0f * (float)n10 / (float)this.pg.height - 1.0f;
            PGL.texCoords[2] = (float)n5 / (float)n3;
            PGL.texCoords[3] = (float)n6 / (float)n4;
            PGL.texCoords[4] = 2.0f * (float)n11 / (float)this.pg.width - 1.0f;
            PGL.texCoords[5] = 2.0f * (float)n10 / (float)this.pg.height - 1.0f;
            PGL.texCoords[6] = (float)n7 / (float)n3;
            PGL.texCoords[7] = (float)n6 / (float)n4;
            PGL.texCoords[8] = 2.0f * (float)n9 / (float)this.pg.width - 1.0f;
            PGL.texCoords[9] = 2.0f * (float)n12 / (float)this.pg.height - 1.0f;
            PGL.texCoords[10] = (float)n5 / (float)n3;
            PGL.texCoords[11] = (float)n8 / (float)n4;
            PGL.texCoords[12] = 2.0f * (float)n11 / (float)this.pg.width - 1.0f;
            PGL.texCoords[13] = 2.0f * (float)n12 / (float)this.pg.height - 1.0f;
            PGL.texCoords[14] = (float)n7 / (float)n3;
            PGL.texCoords[15] = (float)n8 / (float)n4;
            texData.rewind();
            texData.put(texCoords);
            this.activeTexture(33984);
            boolean bl3 = false;
            if (!this.texturingIsEnabled(3553)) {
                this.enableTexturing(3553);
                bl3 = true;
            }
            this.bindTexture(n, n2);
            this.bindBuffer(34962, 0);
            texData.position(0);
            this.vertexAttribPointer(texVertLoc, 2, 5126, false, 16, texData);
            texData.position(2);
            this.vertexAttribPointer(texTCoordLoc, 2, 5126, false, 16, texData);
            this.drawArrays(5, 0, 4);
            this.bindTexture(n, 0);
            if (bl3) {
                this.disableTexturing(3553);
            }
            this.disableVertexAttribArray(texVertLoc);
            this.disableVertexAttribArray(texTCoordLoc);
            this.useProgram(0);
            if (bl) {
                this.enable(2929);
            } else {
                this.disable(2929);
            }
            this.depthMask(bl2);
        }
    }

    protected int getColorValue(int n, int n2) {
        if (this.colorBuffer == null) {
            this.colorBuffer = IntBuffer.allocate(1);
        }
        this.colorBuffer.rewind();
        this.readPixels(n, this.pg.height - n2 - 1, 1, 1, 6408, 5121, this.colorBuffer);
        return this.colorBuffer.get();
    }

    protected float getDepthValue(int n, int n2) {
        return 0.0f;
    }

    protected byte getStencilValue(int n, int n2) {
        return 0;
    }

    protected static int nextPowerOfTwo(int n) {
        int n2;
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        return n2;
    }

    protected static int nativeToJavaARGB(int n) {
        if (BIG_ENDIAN) {
            return n & 0xFF000000 | n >> 8 & 0xFFFFFF;
        }
        return n & 0xFF000000 | n << 16 & 0xFF0000 | n & 0xFF00 | n >> 16 & 0xFF;
    }

    protected static void nativeToJavaARGB(int[] nArray, int n, int n2) {
        block9: {
            int n3;
            int n4 = 0;
            int n5 = (n2 - 1) * n;
            for (n3 = 0; n3 < n2 / 2; ++n3) {
                int n6;
                int n7;
                if (BIG_ENDIAN) {
                    for (n7 = 0; n7 < n; ++n7) {
                        n6 = nArray[n4];
                        nArray[n4] = nArray[n5] & 0xFF000000 | nArray[n5] >> 8 & 0xFFFFFF;
                        nArray[n5] = n6 & 0xFF000000 | n6 >> 8 & 0xFFFFFF;
                        ++n4;
                        ++n5;
                    }
                } else {
                    for (n7 = 0; n7 < n; ++n7) {
                        n6 = nArray[n4];
                        nArray[n4] = nArray[n5] & 0xFF000000 | nArray[n5] << 16 & 0xFF0000 | nArray[n5] & 0xFF00 | nArray[n5] >> 16 & 0xFF;
                        nArray[n5] = n6 & 0xFF000000 | n6 << 16 & 0xFF0000 | n6 & 0xFF00 | n6 >> 16 & 0xFF;
                        ++n4;
                        ++n5;
                    }
                }
                n5 -= n * 2;
            }
            if (n2 % 2 != 1) break block9;
            n4 = n2 / 2 * n;
            if (BIG_ENDIAN) {
                for (n3 = 0; n3 < n; ++n3) {
                    nArray[n4] = nArray[n4] & 0xFF000000 | nArray[n4] >> 8 & 0xFFFFFF;
                    ++n4;
                }
            } else {
                for (n3 = 0; n3 < n; ++n3) {
                    nArray[n4] = nArray[n4] & 0xFF000000 | nArray[n4] << 16 & 0xFF0000 | nArray[n4] & 0xFF00 | nArray[n4] >> 16 & 0xFF;
                    ++n4;
                }
            }
        }
    }

    protected static int nativeToJavaRGB(int n) {
        if (BIG_ENDIAN) {
            return n << 8 & 0xFFFFFF00 | 0xFF;
        }
        return 0xFF000000 | n << 16 & 0xFF0000 | n & 0xFF00 | n >> 16 & 0xFF;
    }

    protected static void nativeToJavaRGB(int[] nArray, int n, int n2) {
        block9: {
            int n3;
            int n4 = 0;
            int n5 = (n2 - 1) * n;
            for (n3 = 0; n3 < n2 / 2; ++n3) {
                int n6;
                int n7;
                if (BIG_ENDIAN) {
                    for (n7 = 0; n7 < n; ++n7) {
                        n6 = nArray[n4];
                        nArray[n4] = 0xFF000000 | nArray[n5] >> 8 & 0xFFFFFF;
                        nArray[n5] = 0xFF000000 | n6 >> 8 & 0xFFFFFF;
                        ++n4;
                        ++n5;
                    }
                } else {
                    for (n7 = 0; n7 < n; ++n7) {
                        n6 = nArray[n4];
                        nArray[n4] = 0xFF000000 | nArray[n5] << 16 & 0xFF0000 | nArray[n5] & 0xFF00 | nArray[n5] >> 16 & 0xFF;
                        nArray[n5] = 0xFF000000 | n6 << 16 & 0xFF0000 | n6 & 0xFF00 | n6 >> 16 & 0xFF;
                        ++n4;
                        ++n5;
                    }
                }
                n5 -= n * 2;
            }
            if (n2 % 2 != 1) break block9;
            n4 = n2 / 2 * n;
            if (BIG_ENDIAN) {
                for (n3 = 0; n3 < n; ++n3) {
                    nArray[n4] = 0xFF000000 | nArray[n4] >> 8 & 0xFFFFFF;
                    ++n4;
                }
            } else {
                for (n3 = 0; n3 < n; ++n3) {
                    nArray[n4] = 0xFF000000 | nArray[n4] << 16 & 0xFF0000 | nArray[n4] & 0xFF00 | nArray[n4] >> 16 & 0xFF;
                    ++n4;
                }
            }
        }
    }

    protected static int javaToNativeARGB(int n) {
        if (BIG_ENDIAN) {
            return n >> 24 & 0xFF | n << 8 & 0xFFFFFF00;
        }
        return n & 0xFF000000 | n << 16 & 0xFF0000 | n & 0xFF00 | n >> 16 & 0xFF;
    }

    protected static void javaToNativeARGB(int[] nArray, int n, int n2) {
        block9: {
            int n3;
            int n4 = 0;
            int n5 = (n2 - 1) * n;
            for (n3 = 0; n3 < n2 / 2; ++n3) {
                int n6;
                int n7;
                if (BIG_ENDIAN) {
                    for (n7 = 0; n7 < n; ++n7) {
                        n6 = nArray[n4];
                        nArray[n4] = nArray[n5] >> 24 & 0xFF | nArray[n5] << 8 & 0xFFFFFF00;
                        nArray[n5] = n6 >> 24 & 0xFF | n6 << 8 & 0xFFFFFF00;
                        ++n4;
                        ++n5;
                    }
                } else {
                    for (n7 = 0; n7 < n; ++n7) {
                        n6 = nArray[n4];
                        nArray[n4] = nArray[n5] & 0xFF000000 | nArray[n5] << 16 & 0xFF0000 | nArray[n5] & 0xFF00 | nArray[n5] >> 16 & 0xFF;
                        nArray[n5] = n6 & 0xFF000000 | n6 << 16 & 0xFF0000 | n6 & 0xFF00 | n6 >> 16 & 0xFF;
                        ++n4;
                        ++n5;
                    }
                }
                n5 -= n * 2;
            }
            if (n2 % 2 != 1) break block9;
            n4 = n2 / 2 * n;
            if (BIG_ENDIAN) {
                for (n3 = 0; n3 < n; ++n3) {
                    nArray[n4] = nArray[n4] >> 24 & 0xFF | nArray[n4] << 8 & 0xFFFFFF00;
                    ++n4;
                }
            } else {
                for (n3 = 0; n3 < n; ++n3) {
                    nArray[n4] = nArray[n4] & 0xFF000000 | nArray[n4] << 16 & 0xFF0000 | nArray[n4] & 0xFF00 | nArray[n4] >> 16 & 0xFF;
                    ++n4;
                }
            }
        }
    }

    protected static int javaToNativeRGB(int n) {
        if (BIG_ENDIAN) {
            return n << 8 & 0xFFFFFF00 | 0xFF;
        }
        return 0xFF000000 | n << 16 & 0xFF0000 | n & 0xFF00 | n >> 16 & 0xFF;
    }

    protected static void javaToNativeRGB(int[] nArray, int n, int n2) {
        block9: {
            int n3;
            int n4 = 0;
            int n5 = (n2 - 1) * n;
            for (n3 = 0; n3 < n2 / 2; ++n3) {
                int n6;
                int n7;
                if (BIG_ENDIAN) {
                    for (n7 = 0; n7 < n; ++n7) {
                        n6 = nArray[n4];
                        nArray[n4] = nArray[n5] << 8 & 0xFFFFFF00 | 0xFF;
                        nArray[n5] = n6 << 8 & 0xFFFFFF00 | 0xFF;
                        ++n4;
                        ++n5;
                    }
                } else {
                    for (n7 = 0; n7 < n; ++n7) {
                        n6 = nArray[n4];
                        nArray[n4] = 0xFF000000 | nArray[n5] << 16 & 0xFF0000 | nArray[n5] & 0xFF00 | nArray[n5] >> 16 & 0xFF;
                        nArray[n5] = 0xFF000000 | n6 << 16 & 0xFF0000 | n6 & 0xFF00 | n6 >> 16 & 0xFF;
                        ++n4;
                        ++n5;
                    }
                }
                n5 -= n * 2;
            }
            if (n2 % 2 != 1) break block9;
            n4 = n2 / 2 * n;
            if (BIG_ENDIAN) {
                for (n3 = 0; n3 < n; ++n3) {
                    nArray[n4] = nArray[n4] << 8 & 0xFFFFFF00 | 0xFF;
                    ++n4;
                }
            } else {
                for (n3 = 0; n3 < n; ++n3) {
                    nArray[n4] = 0xFF000000 | nArray[n4] << 16 & 0xFF0000 | nArray[n4] & 0xFF00 | nArray[n4] >> 16 & 0xFF;
                    ++n4;
                }
            }
        }
    }

    protected int createShader(int n, String string) {
        int n2 = this.createShader(n);
        if (n2 != 0) {
            this.shaderSource(n2, string);
            this.compileShader(n2);
            if (!this.compiled(n2)) {
                System.err.println("Could not compile shader " + n + ":");
                System.err.println(this.getShaderInfoLog(n2));
                this.deleteShader(n2);
                n2 = 0;
            }
        }
        return n2;
    }

    protected int createProgram(int n, int n2) {
        int n3 = this.createProgram();
        if (n3 != 0) {
            this.attachShader(n3, n);
            this.attachShader(n3, n2);
            this.linkProgram(n3);
            if (!this.linked(n3)) {
                System.err.println("Could not link program: ");
                System.err.println(this.getProgramInfoLog(n3));
                this.deleteProgram(n3);
                n3 = 0;
            }
        }
        return n3;
    }

    protected boolean compiled(int n) {
        this.intBuffer.rewind();
        this.getShaderiv(n, 35713, this.intBuffer);
        return this.intBuffer.get(0) != 0;
    }

    protected boolean linked(int n) {
        this.intBuffer.rewind();
        this.getProgramiv(n, 35714, this.intBuffer);
        return this.intBuffer.get(0) != 0;
    }

    protected boolean validateFramebuffer() {
        int n = this.checkFramebufferStatus(36160);
        if (n == 36053) {
            return true;
        }
        if (n == 36054) {
            System.err.println(String.format(FRAMEBUFFER_ERROR_MESSAGE, "incomplete attachment"));
        } else if (n == 36055) {
            System.err.println(String.format(FRAMEBUFFER_ERROR_MESSAGE, "incomplete missing attachment"));
        } else if (n == 36057) {
            System.err.println(String.format(FRAMEBUFFER_ERROR_MESSAGE, "incomplete dimensions"));
        } else if (n == 36058) {
            System.err.println(String.format(FRAMEBUFFER_ERROR_MESSAGE, "incomplete formats"));
        } else if (n == 36061) {
            System.err.println(String.format(FRAMEBUFFER_ERROR_MESSAGE, "framebuffer unsupported"));
        } else {
            System.err.println(String.format(FRAMEBUFFER_ERROR_MESSAGE, "unknown error"));
        }
        return false;
    }

    protected int[] getGLVersion() {
        String string = this.getString(7938).trim();
        int[] nArray = new int[]{0, 0, 0};
        String[] stringArray = string.split(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            if (0 >= stringArray[i].indexOf(".")) continue;
            String[] stringArray2 = stringArray[i].split("\\.");
            try {
                nArray[0] = Integer.parseInt(stringArray2[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (1 < stringArray2.length) {
                try {
                    nArray[1] = Integer.parseInt(stringArray2[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (2 >= stringArray2.length) break;
            try {
                nArray[2] = Integer.parseInt(stringArray2[2]);
            }
            catch (NumberFormatException numberFormatException) {}
            break;
        }
        return nArray;
    }

    protected static ByteBuffer allocateDirectByteBuffer(int n) {
        int n2 = PApplet.max(1, n) * 1;
        return ByteBuffer.allocateDirect(n2).order(ByteOrder.nativeOrder());
    }

    protected static ByteBuffer allocateByteBuffer(int n) {
        return PGL.allocateDirectByteBuffer(n);
    }

    protected static ByteBuffer allocateByteBuffer(byte[] byArray) {
        return PGL.allocateDirectByteBuffer(byArray.length);
    }

    protected static ByteBuffer updateByteBuffer(ByteBuffer byteBuffer, byte[] byArray, boolean bl) {
        if (byteBuffer == null || byteBuffer.capacity() < byArray.length) {
            byteBuffer = PGL.allocateDirectByteBuffer(byArray.length);
        }
        byteBuffer.position(0);
        byteBuffer.put(byArray);
        byteBuffer.rewind();
        return byteBuffer;
    }

    protected static void updateByteBuffer(ByteBuffer byteBuffer, byte[] byArray, int n, int n2) {
        byteBuffer.position(n);
        byteBuffer.put(byArray, n, n2);
        byteBuffer.rewind();
    }

    protected static void getByteArray(ByteBuffer byteBuffer, byte[] byArray) {
        if (!byteBuffer.hasArray() || byteBuffer.array() != byArray) {
            byteBuffer.position(0);
            byteBuffer.get(byArray);
            byteBuffer.rewind();
        }
    }

    protected static void putByteArray(ByteBuffer byteBuffer, byte[] byArray) {
        if (!byteBuffer.hasArray() || byteBuffer.array() != byArray) {
            byteBuffer.position(0);
            byteBuffer.put(byArray);
            byteBuffer.rewind();
        }
    }

    protected static void fillByteBuffer(ByteBuffer byteBuffer, int n, int n2, byte by) {
        int n3 = n2 - n;
        byte[] byArray = new byte[n3];
        Arrays.fill(byArray, 0, n3, by);
        byteBuffer.position(n);
        byteBuffer.put(byArray, 0, n3);
        byteBuffer.rewind();
    }

    protected static ShortBuffer allocateDirectShortBuffer(int n) {
        int n2 = PApplet.max(1, n) * 2;
        return ByteBuffer.allocateDirect(n2).order(ByteOrder.nativeOrder()).asShortBuffer();
    }

    protected static ShortBuffer allocateShortBuffer(int n) {
        return PGL.allocateDirectShortBuffer(n);
    }

    protected static ShortBuffer allocateShortBuffer(short[] sArray) {
        return PGL.allocateDirectShortBuffer(sArray.length);
    }

    protected static ShortBuffer updateShortBuffer(ShortBuffer shortBuffer, short[] sArray, boolean bl) {
        if (shortBuffer == null || shortBuffer.capacity() < sArray.length) {
            shortBuffer = PGL.allocateDirectShortBuffer(sArray.length);
        }
        shortBuffer.position(0);
        shortBuffer.put(sArray);
        shortBuffer.rewind();
        return shortBuffer;
    }

    protected static void updateShortBuffer(ShortBuffer shortBuffer, short[] sArray, int n, int n2) {
        shortBuffer.position(n);
        shortBuffer.put(sArray, n, n2);
        shortBuffer.rewind();
    }

    protected static void getShortArray(ShortBuffer shortBuffer, short[] sArray) {
        if (!shortBuffer.hasArray() || shortBuffer.array() != sArray) {
            shortBuffer.position(0);
            shortBuffer.get(sArray);
            shortBuffer.rewind();
        }
    }

    protected static void putShortArray(ShortBuffer shortBuffer, short[] sArray) {
        if (!shortBuffer.hasArray() || shortBuffer.array() != sArray) {
            shortBuffer.position(0);
            shortBuffer.put(sArray);
            shortBuffer.rewind();
        }
    }

    protected static void fillShortBuffer(ShortBuffer shortBuffer, int n, int n2, short s) {
        int n3 = n2 - n;
        short[] sArray = new short[n3];
        Arrays.fill(sArray, 0, n3, s);
        shortBuffer.position(n);
        shortBuffer.put(sArray, 0, n3);
        shortBuffer.rewind();
    }

    protected static IntBuffer allocateDirectIntBuffer(int n) {
        int n2 = PApplet.max(1, n) * 4;
        return ByteBuffer.allocateDirect(n2).order(ByteOrder.nativeOrder()).asIntBuffer();
    }

    protected static IntBuffer allocateIntBuffer(int n) {
        return PGL.allocateDirectIntBuffer(n);
    }

    protected static IntBuffer allocateIntBuffer(int[] nArray) {
        return PGL.allocateDirectIntBuffer(nArray.length);
    }

    protected static IntBuffer updateIntBuffer(IntBuffer intBuffer, int[] nArray, boolean bl) {
        if (intBuffer == null || intBuffer.capacity() < nArray.length) {
            intBuffer = PGL.allocateDirectIntBuffer(nArray.length);
        }
        intBuffer.position(0);
        intBuffer.put(nArray);
        intBuffer.rewind();
        return intBuffer;
    }

    protected static void updateIntBuffer(IntBuffer intBuffer, int[] nArray, int n, int n2) {
        intBuffer.position(n);
        intBuffer.put(nArray, n, n2);
        intBuffer.rewind();
    }

    protected static void getIntArray(IntBuffer intBuffer, int[] nArray) {
        if (!intBuffer.hasArray() || intBuffer.array() != nArray) {
            intBuffer.position(0);
            intBuffer.get(nArray);
            intBuffer.rewind();
        }
    }

    protected static void putIntArray(IntBuffer intBuffer, int[] nArray) {
        if (!intBuffer.hasArray() || intBuffer.array() != nArray) {
            intBuffer.position(0);
            intBuffer.put(nArray);
            intBuffer.rewind();
        }
    }

    protected static void fillIntBuffer(IntBuffer intBuffer, int n, int n2, int n3) {
        int n4 = n2 - n;
        int[] nArray = new int[n4];
        Arrays.fill(nArray, 0, n4, n3);
        intBuffer.position(n);
        intBuffer.put(nArray, 0, n4);
        intBuffer.rewind();
    }

    protected static FloatBuffer allocateDirectFloatBuffer(int n) {
        int n2 = PApplet.max(1, n) * 4;
        return ByteBuffer.allocateDirect(n2).order(ByteOrder.nativeOrder()).asFloatBuffer();
    }

    protected static FloatBuffer allocateFloatBuffer(int n) {
        return PGL.allocateDirectFloatBuffer(n);
    }

    protected static FloatBuffer allocateFloatBuffer(float[] fArray) {
        return PGL.allocateDirectFloatBuffer(fArray.length);
    }

    protected static FloatBuffer updateFloatBuffer(FloatBuffer floatBuffer, float[] fArray, boolean bl) {
        if (floatBuffer == null || floatBuffer.capacity() < fArray.length) {
            floatBuffer = PGL.allocateDirectFloatBuffer(fArray.length);
        }
        floatBuffer.position(0);
        floatBuffer.put(fArray);
        floatBuffer.rewind();
        return floatBuffer;
    }

    protected static void updateFloatBuffer(FloatBuffer floatBuffer, float[] fArray, int n, int n2) {
        floatBuffer.position(n);
        floatBuffer.put(fArray, n, n2);
        floatBuffer.rewind();
    }

    protected static void getFloatArray(FloatBuffer floatBuffer, float[] fArray) {
        if (!floatBuffer.hasArray() || floatBuffer.array() != fArray) {
            floatBuffer.position(0);
            floatBuffer.get(fArray);
            floatBuffer.rewind();
        }
    }

    protected static void putFloatArray(FloatBuffer floatBuffer, float[] fArray) {
        if (!floatBuffer.hasArray() || floatBuffer.array() != fArray) {
            floatBuffer.position(0);
            floatBuffer.put(fArray);
            floatBuffer.rewind();
        }
    }

    protected static void fillFloatBuffer(FloatBuffer floatBuffer, int n, int n2, float f) {
        int n3 = n2 - n;
        float[] fArray = new float[n3];
        Arrays.fill(fArray, 0, n3, f);
        floatBuffer.position(n);
        floatBuffer.put(fArray, 0, n3);
        floatBuffer.rewind();
    }

    public AndroidRenderer getRenderer() {
        renderer = new AndroidRenderer();
        return renderer;
    }

    public AndroidContextFactory getContextFactory() {
        return new AndroidContextFactory();
    }

    public AndroidConfigChooser getConfigChooser(int n, int n2, int n3, int n4, int n5, int n6) {
        return new AndroidConfigChooser(n, n2, n3, n4, n5, n6);
    }

    static {
        float f = 1.0f;
        while ((double)((float)(1.0 + (double)(f /= 2.0f) / 2.0)) != 1.0) {
        }
        FLOAT_EPS = f;
        BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        texturingTargets = new boolean[]{false};
        boundTextures = new int[]{0};
        fboLayerByDefault = FORCE_SCREEN_FBO;
        fboLayerCreated = false;
        fboLayerInUse = false;
        firstFrame = true;
        loadedTexShader = false;
        texCoords = new float[]{-1.0f, -1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
        texVertShaderSource = "attribute vec2 inVertex;attribute vec2 inTexcoord;varying vec2 vertTexcoord;void main() {  gl_Position = vec4(inVertex, 0, 1);  vertTexcoord = inTexcoord;}";
        texFragShaderSource = "#ifdef GL_ES\nprecision mediump float;\nprecision mediump int;\n#endif\nuniform sampler2D textureSampler;varying vec2 vertTexcoord;void main() {  gl_FragColor = texture2D(textureSampler, vertTexcoord.st);}";
    }

    protected class AndroidConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        public int redTarget;
        public int greenTarget;
        public int blueTarget;
        public int alphaTarget;
        public int depthTarget;
        public int stencilTarget;
        public int redBits;
        public int greenBits;
        public int blueBits;
        public int alphaBits;
        public int depthBits;
        public int stencilBits;
        public int[] tempValue = new int[1];
        protected int[] configAttribsGL = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, 4, 12344};

        public AndroidConfigChooser(int n, int n2, int n3, int n4, int n5, int n6) {
            this.redTarget = n;
            this.greenTarget = n2;
            this.blueTarget = n3;
            this.alphaTarget = n4;
            this.depthTarget = n5;
            this.stencilTarget = n6;
        }

        public EGLConfig chooseConfig(EGL10 eGL10, EGLDisplay eGLDisplay) {
            int[] nArray = new int[1];
            eGL10.eglChooseConfig(eGLDisplay, this.configAttribsGL, null, 0, nArray);
            int n = nArray[0];
            if (n <= 0) {
                throw new IllegalArgumentException("No EGL configs match configSpec");
            }
            EGLConfig[] eGLConfigArray = new EGLConfig[n];
            eGL10.eglChooseConfig(eGLDisplay, this.configAttribsGL, eGLConfigArray, n, nArray);
            return this.chooseBestConfig(eGL10, eGLDisplay, eGLConfigArray);
        }

        public EGLConfig chooseBestConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig[] eGLConfigArray) {
            EGLConfig eGLConfig = null;
            float f = 1000.0f;
            for (EGLConfig eGLConfig2 : eGLConfigArray) {
                int n = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12352, 0);
                if (n != 4) continue;
                int n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12325, 0);
                int n3 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12326, 0);
                int n4 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12324, 0);
                int n5 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12323, 0);
                int n6 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12322, 0);
                int n7 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig2, 12321, 0);
                float f2 = 0.2f * (float)PApplet.abs(n4 - this.redTarget) + 0.2f * (float)PApplet.abs(n5 - this.greenTarget) + 0.2f * (float)PApplet.abs(n6 - this.blueTarget) + 0.15f * (float)PApplet.abs(n7 - this.blueTarget) + 0.15f * (float)PApplet.abs(n2 - this.depthTarget) + 0.1f * (float)PApplet.abs(n3 - this.stencilTarget);
                if (!(f2 < f)) continue;
                eGLConfig = eGLConfig2;
                f = f2;
                this.redBits = n4;
                this.greenBits = n5;
                this.blueBits = n6;
                this.alphaBits = n7;
                this.depthBits = n2;
                this.stencilBits = n3;
            }
            return eGLConfig;
        }

        protected String printConfig(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            int n = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12324, 0);
            int n2 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12323, 0);
            int n3 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12322, 0);
            int n4 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12321, 0);
            int n5 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12325, 0);
            int n6 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12326, 0);
            int n7 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12352, 0);
            int n8 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12333, 0);
            int n9 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12320, 0);
            int n10 = this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12422, 0);
            return String.format("EGLConfig rgba=%d%d%d%d depth=%d stencil=%d", n, n2, n3, n4, n5, n6) + " type=" + n7 + " native=" + n8 + " buffer size=" + n9 + " buffer surface=" + n10 + String.format(" caveat=0x%04x", this.findConfigAttrib(eGL10, eGLDisplay, eGLConfig, 12327, 0));
        }

        protected int findConfigAttrib(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig, int n, int n2) {
            if (eGL10.eglGetConfigAttrib(eGLDisplay, eGLConfig, n, this.tempValue)) {
                return this.tempValue[0];
            }
            return n2;
        }
    }

    protected class AndroidContextFactory
    implements GLSurfaceView.EGLContextFactory {
        protected AndroidContextFactory() {
        }

        public EGLContext createContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLConfig eGLConfig) {
            int[] nArray = new int[]{12440, 2, 12344};
            EGLContext eGLContext = eGL10.eglCreateContext(eGLDisplay, eGLConfig, EGL10.EGL_NO_CONTEXT, nArray);
            return eGLContext;
        }

        public void destroyContext(EGL10 eGL10, EGLDisplay eGLDisplay, EGLContext eGLContext) {
            eGL10.eglDestroyContext(eGLDisplay, eGLContext);
        }
    }

    protected class AndroidRenderer
    implements GLSurfaceView.Renderer {
        public void onDrawFrame(GL10 gL10) {
            gl = gL10;
            glThread = Thread.currentThread();
            PGL.this.pg.parent.handleDraw();
        }

        public void onSurfaceChanged(GL10 gL10, int n, int n2) {
            gl = gL10;
            PGL.this.pg.setSize(n, n2);
        }

        public void onSurfaceCreated(GL10 gL10, EGLConfig eGLConfig) {
            gl = gL10;
            context = ((EGL10)EGLContext.getEGL()).eglGetCurrentContext();
        }
    }

    protected static interface TessellatorCallback {
        public void begin(int var1);

        public void end();

        public void vertex(Object var1);

        public void combine(double[] var1, Object[] var2, float[] var3, Object[] var4);

        public void error(int var1);
    }

    protected class Tessellator {
        protected PGLUtessellator tess;
        protected TessellatorCallback callback;
        protected GLUCallback gluCallback;

        public Tessellator(TessellatorCallback tessellatorCallback) {
            this.callback = tessellatorCallback;
            this.tess = PGLU.gluNewTess();
            this.gluCallback = new GLUCallback();
            PGLU.gluTessCallback(this.tess, 100100, this.gluCallback);
            PGLU.gluTessCallback(this.tess, 100102, this.gluCallback);
            PGLU.gluTessCallback(this.tess, 100101, this.gluCallback);
            PGLU.gluTessCallback(this.tess, 100105, this.gluCallback);
            PGLU.gluTessCallback(this.tess, 100103, this.gluCallback);
        }

        public void beginPolygon() {
            PGLU.gluTessBeginPolygon(this.tess, null);
        }

        public void endPolygon() {
            PGLU.gluTessEndPolygon(this.tess);
        }

        public void setWindingRule(int n) {
            PGLU.gluTessProperty(this.tess, 100140, n);
        }

        public void beginContour() {
            PGLU.gluTessBeginContour(this.tess);
        }

        public void endContour() {
            PGLU.gluTessEndContour(this.tess);
        }

        public void addVertex(double[] dArray) {
            PGLU.gluTessVertex(this.tess, dArray, 0, dArray);
        }

        protected class GLUCallback
        extends PGLUtessellatorCallbackAdapter {
            protected GLUCallback() {
            }

            @Override
            public void begin(int n) {
                Tessellator.this.callback.begin(n);
            }

            @Override
            public void end() {
                Tessellator.this.callback.end();
            }

            @Override
            public void vertex(Object object) {
                Tessellator.this.callback.vertex(object);
            }

            @Override
            public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
                Tessellator.this.callback.combine(dArray, objectArray, fArray, objectArray2);
            }

            @Override
            public void error(int n) {
                Tessellator.this.callback.error(n);
            }
        }
    }
}

