/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import java.util.zip.GZIPInputStream;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PShape;
import processing.core.PShapeSVG;
import processing.data.XML;

public class PGraphicsAndroid2D
extends PGraphics {
    public Canvas canvas;
    boolean breakShape;
    float[] curveCoordX;
    float[] curveCoordY;
    float[] curveDrawX;
    float[] curveDrawY;
    float[] transform = new float[9];
    Path path = new Path();
    RectF rect = new RectF();
    Paint fillPaint = new Paint();
    Paint strokePaint;
    Paint tintPaint;
    Rect imageImplSrcRect;
    RectF imageImplDstRect;
    float[] screenPoint;
    static int[] getset = new int[1];

    public PGraphicsAndroid2D() {
        this.fillPaint.setStyle(Paint.Style.FILL);
        this.strokePaint = new Paint();
        this.strokePaint.setStyle(Paint.Style.STROKE);
        this.tintPaint = new Paint(2);
    }

    public void setSize(int iwidth, int iheight) {
        this.width = iwidth;
        this.height = iheight;
        this.width1 = this.width - 1;
        this.height1 = this.height - 1;
        this.allocate();
        this.reapplySettings();
    }

    protected void allocate() {
        this.bitmap = Bitmap.createBitmap((int)this.width, (int)this.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.canvas = new Canvas(this.bitmap);
    }

    public void dispose() {
        this.bitmap.recycle();
    }

    public void requestDraw() {
        this.parent.handleDraw();
    }

    public void beginDraw() {
        this.checkSettings();
        this.resetMatrix();
        this.vertexCount = 0;
    }

    /*
     * Unable to fully structure code
     */
    public void endDraw() {
        if (this.primarySurface) {
            screen = null;
            try {
                screen = this.parent.getSurfaceHolder().lockCanvas(null);
                if (screen == null) ** GOTO lbl13
                screen.drawBitmap(this.bitmap, new Matrix(), null);
            }
            finally {
                if (screen != null) {
                    this.parent.getSurfaceHolder().unlockCanvasAndPost(screen);
                }
            }
        } else {
            this.loadPixels();
        }
lbl13:
        // 3 sources

        this.setModified();
        super.updatePixels();
    }

    public void beginShape(int kind) {
        this.shape = kind;
        this.vertexCount = 0;
        this.curveVertexCount = 0;
    }

    public void texture(PImage image) {
        PGraphicsAndroid2D.showMethodWarning("texture");
    }

    public void vertex(float x, float y) {
        if (this.shape == 20) {
            if (this.vertexCount == 0) {
                this.path.reset();
                this.path.moveTo(x, y);
                this.vertexCount = 1;
            } else if (this.breakShape) {
                this.path.moveTo(x, y);
                this.breakShape = false;
            } else {
                this.path.lineTo(x, y);
            }
        } else {
            this.curveVertexCount = 0;
            if (this.vertexCount == this.vertices.length) {
                float[][] temp = new float[this.vertexCount << 1][37];
                System.arraycopy(this.vertices, 0, temp, 0, this.vertexCount);
                this.vertices = temp;
            }
            this.vertices[this.vertexCount][0] = x;
            this.vertices[this.vertexCount][1] = y;
            ++this.vertexCount;
            switch (this.shape) {
                case 3: {
                    break;
                }
                case 5: {
                    if (this.vertexCount % 2 != 0) break;
                    this.line(this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y);
                    this.vertexCount = 0;
                    break;
                }
                case 9: {
                    if (this.vertexCount % 3 != 0) break;
                    this.triangle(this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y);
                    this.vertexCount = 0;
                    break;
                }
                case 10: {
                    if (this.vertexCount < 3) break;
                    this.triangle(this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y, this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1]);
                    break;
                }
                case 11: {
                    if (this.vertexCount < 3) break;
                    this.triangle(this.vertices[0][0], this.vertices[0][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y);
                    break;
                }
                case 16: 
                case 17: {
                    if (this.vertexCount % 4 != 0) break;
                    this.quad(this.vertices[this.vertexCount - 4][0], this.vertices[this.vertexCount - 4][1], this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y);
                    this.vertexCount = 0;
                    break;
                }
                case 18: {
                    if (this.vertexCount < 4 || this.vertexCount % 2 != 0) break;
                    this.quad(this.vertices[this.vertexCount - 4][0], this.vertices[this.vertexCount - 4][1], this.vertices[this.vertexCount - 2][0], this.vertices[this.vertexCount - 2][1], x, y, this.vertices[this.vertexCount - 3][0], this.vertices[this.vertexCount - 3][1]);
                }
            }
        }
    }

    public void vertex(float x, float y, float z) {
        PGraphicsAndroid2D.showDepthWarningXYZ("vertex");
    }

    public void vertex(float x, float y, float u, float v) {
        PGraphicsAndroid2D.showVariationWarning("vertex(x, y, u, v)");
    }

    public void vertex(float x, float y, float z, float u, float v) {
        PGraphicsAndroid2D.showDepthWarningXYZ("vertex");
    }

    public void breakShape() {
        this.breakShape = true;
    }

    public void endShape(int mode) {
        if (this.shape == 3 && this.stroke && this.vertexCount > 0) {
            Matrix m = this.canvas.getMatrix();
            if (this.strokeWeight == 1.0f && m.isIdentity()) {
                if (this.screenPoint == null) {
                    this.screenPoint = new float[2];
                }
                int i = 0;
                while (i < this.vertexCount) {
                    this.screenPoint[0] = this.vertices[i][0];
                    this.screenPoint[1] = this.vertices[i][1];
                    m.mapPoints(this.screenPoint);
                    this.set(PApplet.round(this.screenPoint[0]), PApplet.round(this.screenPoint[1]), this.strokeColor);
                    float x = this.vertices[i][0];
                    float y = this.vertices[i][1];
                    this.set(PApplet.round(this.screenX(x, y)), PApplet.round(this.screenY(x, y)), this.strokeColor);
                    ++i;
                }
            } else {
                float sw = this.strokeWeight / 2.0f;
                this.strokePaint.setStyle(Paint.Style.FILL);
                int i = 0;
                while (i < this.vertexCount) {
                    float x = this.vertices[i][0];
                    float y = this.vertices[i][1];
                    this.rect.set(x - sw, y - sw, x + sw, y + sw);
                    this.canvas.drawOval(this.rect, this.strokePaint);
                    ++i;
                }
                this.strokePaint.setStyle(Paint.Style.STROKE);
            }
        } else if (this.shape == 20 && !this.path.isEmpty()) {
            if (mode == 2) {
                this.path.close();
            }
            this.drawPath();
        }
        this.shape = 0;
    }

    public void bezierVertex(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.bezierVertexCheck();
        this.path.cubicTo(x1, y1, x2, y2, x3, y3);
    }

    public void bezierVertex(float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        PGraphicsAndroid2D.showDepthWarningXYZ("bezierVertex");
    }

    public void quadraticVertex(float ctrlX, float ctrlY, float endX, float endY) {
        this.bezierVertexCheck();
        this.path.quadTo(ctrlX, ctrlY, endX, endY);
    }

    public void quadraticVertex(float x2, float y2, float z2, float x4, float y4, float z4) {
        PGraphicsAndroid2D.showDepthWarningXYZ("quadVertex");
    }

    protected void curveVertexCheck() {
        super.curveVertexCheck();
        if (this.curveCoordX == null) {
            this.curveCoordX = new float[4];
            this.curveCoordY = new float[4];
            this.curveDrawX = new float[4];
            this.curveDrawY = new float[4];
        }
    }

    protected void curveVertexSegment(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.curveCoordX[0] = x1;
        this.curveCoordY[0] = y1;
        this.curveCoordX[1] = x2;
        this.curveCoordY[1] = y2;
        this.curveCoordX[2] = x3;
        this.curveCoordY[2] = y3;
        this.curveCoordX[3] = x4;
        this.curveCoordY[3] = y4;
        this.curveToBezierMatrix.mult(this.curveCoordX, this.curveDrawX);
        this.curveToBezierMatrix.mult(this.curveCoordY, this.curveDrawY);
        if (this.vertexCount == 0) {
            this.path.moveTo(this.curveDrawX[0], this.curveDrawY[0]);
            this.vertexCount = 1;
        }
        this.path.cubicTo(this.curveDrawX[1], this.curveDrawY[1], this.curveDrawX[2], this.curveDrawY[2], this.curveDrawX[3], this.curveDrawY[3]);
    }

    public void curveVertex(float x, float y, float z) {
        PGraphicsAndroid2D.showDepthWarningXYZ("curveVertex");
    }

    public void point(float x, float y) {
        this.beginShape(3);
        this.vertex(x, y);
        this.endShape();
    }

    public void line(float x1, float y1, float x2, float y2) {
        if (this.stroke) {
            this.canvas.drawLine(x1, y1, x2, y2, this.strokePaint);
        }
    }

    public void triangle(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.path.reset();
        this.path.moveTo(x1, y1);
        this.path.lineTo(x2, y2);
        this.path.lineTo(x3, y3);
        this.path.close();
        this.drawPath();
    }

    public void quad(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        this.path.reset();
        this.path.moveTo(x1, y1);
        this.path.lineTo(x2, y2);
        this.path.lineTo(x3, y3);
        this.path.lineTo(x4, y4);
        this.path.close();
        this.drawPath();
    }

    protected void rectImpl(float x1, float y1, float x2, float y2) {
        if (this.fill) {
            this.canvas.drawRect(x1, y1, x2, y2, this.fillPaint);
        }
        if (this.stroke) {
            this.canvas.drawRect(x1, y1, x2, y2, this.strokePaint);
        }
    }

    protected void ellipseImpl(float x, float y, float w, float h) {
        this.rect.set(x, y, x + w, y + h);
        if (this.fill) {
            this.canvas.drawOval(this.rect, this.fillPaint);
        }
        if (this.stroke) {
            this.canvas.drawOval(this.rect, this.strokePaint);
        }
    }

    protected void arcImpl(float x, float y, float w, float h, float start, float stop, int mode) {
        if (stop - start >= (float)Math.PI * 2) {
            this.ellipseImpl(x, y, w, h);
        } else {
            start *= 57.295776f;
            stop *= 57.295776f;
            while (start < 0.0f) {
                start += 360.0f;
                stop += 360.0f;
            }
            if (start > stop) {
                float temp = start;
                start = stop;
                stop = temp;
            }
            float sweep = stop - start;
            this.rect.set(x, y, x + w, y + h);
            if (mode == 0) {
                if (this.fill) {
                    this.canvas.drawArc(this.rect, start, sweep, true, this.fillPaint);
                }
                if (this.stroke) {
                    this.canvas.drawArc(this.rect, start, sweep, false, this.strokePaint);
                }
            } else if (mode == 1) {
                if (this.fill) {
                    PGraphicsAndroid2D.showMissingWarning("arc");
                }
                if (this.stroke) {
                    this.canvas.drawArc(this.rect, start, sweep, false, this.strokePaint);
                }
            } else if (mode == 2) {
                PGraphicsAndroid2D.showMissingWarning("arc");
            } else if (mode == 3) {
                if (this.fill) {
                    this.canvas.drawArc(this.rect, start, sweep, true, this.fillPaint);
                }
                if (this.stroke) {
                    this.canvas.drawArc(this.rect, start, sweep, true, this.strokePaint);
                }
            }
        }
    }

    protected void drawPath() {
        if (this.fill) {
            this.canvas.drawPath(this.path, this.fillPaint);
        }
        if (this.stroke) {
            this.canvas.drawPath(this.path, this.strokePaint);
        }
    }

    public void box(float w, float h, float d) {
        PGraphicsAndroid2D.showMethodWarning("box");
    }

    public void sphere(float r) {
        PGraphicsAndroid2D.showMethodWarning("sphere");
    }

    public void bezierDetail(int detail) {
    }

    public void curveDetail(int detail) {
    }

    public void smooth() {
        this.smooth = true;
        this.strokePaint.setAntiAlias(true);
        this.fillPaint.setAntiAlias(true);
    }

    public void noSmooth() {
        this.smooth = false;
        this.strokePaint.setAntiAlias(false);
        this.fillPaint.setAntiAlias(false);
    }

    protected void imageImpl(PImage src, float x1, float y1, float x2, float y2, int u1, int v1, int u2, int v2) {
        if (src.bitmap == null && src.format == 4) {
            src.bitmap = Bitmap.createBitmap((int)src.width, (int)src.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            int[] px = new int[src.pixels.length];
            int i = 0;
            while (i < px.length) {
                px[i] = src.pixels[i] << 24 | 0xFFFFFF;
                ++i;
            }
            src.bitmap.setPixels(px, 0, src.width, 0, 0, src.width, src.height);
            src.modified = false;
        }
        if (src.bitmap == null || src.width != src.bitmap.getWidth() || src.height != src.bitmap.getHeight()) {
            src.bitmap = Bitmap.createBitmap((int)src.width, (int)src.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            src.modified = true;
        }
        if (src.modified) {
            if (!src.bitmap.isMutable()) {
                src.bitmap = Bitmap.createBitmap((int)src.width, (int)src.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            }
            src.bitmap.setPixels(src.pixels, 0, src.width, 0, 0, src.width, src.height);
            src.modified = false;
        }
        if (this.imageImplSrcRect == null) {
            this.imageImplSrcRect = new Rect(u1, v1, u2, v2);
            this.imageImplDstRect = new RectF(x1, y1, x2, y2);
        } else {
            this.imageImplSrcRect.set(u1, v1, u2, v2);
            this.imageImplDstRect.set(x1, y1, x2, y2);
        }
        this.canvas.drawBitmap(src.bitmap, this.imageImplSrcRect, this.imageImplDstRect, this.tint ? this.tintPaint : null);
    }

    public PShape loadShape(String filename) {
        String extension = PApplet.getExtension(filename);
        PShapeSVG svg = null;
        if (extension.equals("svg")) {
            svg = new PShapeSVG(this.parent.loadXML(filename));
        } else if (extension.equals("svgz")) {
            try {
                GZIPInputStream input = new GZIPInputStream(this.parent.createInput(filename));
                XML xml = new XML(input);
                svg = new PShapeSVG(xml);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            PGraphics.showWarning("Unsupported format");
        }
        return svg;
    }

    public void textFont(PFont which) {
        super.textFont(which);
        this.fillPaint.setTypeface((Typeface)which.getNative());
    }

    protected boolean textModeCheck(int mode) {
        return mode == 4;
    }

    public void textSize(float size) {
        Typeface font;
        if (this.textFont == null) {
            this.defaultFontOrDeath("textSize", size);
        }
        if ((font = (Typeface)this.textFont.getNative()) != null) {
            this.fillPaint.setTextSize(size);
        }
        this.textSize = size;
        this.textLeading = (this.textAscent() + this.textDescent()) * 1.275f;
    }

    protected void beginTextScreenMode() {
        this.loadPixels();
    }

    protected void endTextScreenMode() {
        this.updatePixels();
    }

    protected float textWidthImpl(char[] buffer, int start, int stop) {
        Typeface font = (Typeface)this.textFont.getNative();
        if (font == null) {
            return super.textWidthImpl(buffer, start, stop);
        }
        int length = stop - start;
        return this.fillPaint.measureText(buffer, start, length);
    }

    protected void textLineImpl(char[] buffer, int start, int stop, float x, float y) {
        Typeface font = (Typeface)this.textFont.getNative();
        if (font == null) {
            PGraphicsAndroid2D.showWarning("Inefficient font rendering: use createFont() with a TTF/OTF instead of loadFont().");
            super.textLineImpl(buffer, start, stop, x, y);
            return;
        }
        this.fillPaint.setAntiAlias(this.textFont.smooth);
        int length = stop - start;
        this.canvas.drawText(buffer, start, length, x, y, this.fillPaint);
        this.fillPaint.setAntiAlias(this.smooth);
    }

    public void pushMatrix() {
        this.canvas.save(1);
    }

    public void popMatrix() {
        this.canvas.restore();
    }

    public void translate(float tx, float ty) {
        this.canvas.translate(tx, ty);
    }

    public void rotate(float angle) {
        this.canvas.rotate(angle * 57.295776f);
    }

    public void rotateX(float angle) {
        PGraphicsAndroid2D.showDepthWarning("rotateX");
    }

    public void rotateY(float angle) {
        PGraphicsAndroid2D.showDepthWarning("rotateY");
    }

    public void rotateZ(float angle) {
        PGraphicsAndroid2D.showDepthWarning("rotateZ");
    }

    public void rotate(float angle, float vx, float vy, float vz) {
        PGraphicsAndroid2D.showVariationWarning("rotate");
    }

    public void scale(float s) {
        this.canvas.scale(s, s);
    }

    public void scale(float sx, float sy) {
        this.canvas.scale(sx, sy);
    }

    public void scale(float sx, float sy, float sz) {
        PGraphicsAndroid2D.showDepthWarningXYZ("scale");
    }

    public void shearX(float angle) {
        this.canvas.skew((float)Math.tan(angle), 0.0f);
    }

    public void shearY(float angle) {
        this.canvas.skew(0.0f, (float)Math.tan(angle));
    }

    public void resetMatrix() {
        this.canvas.setMatrix(new Matrix());
    }

    public void applyMatrix(float n00, float n01, float n02, float n10, float n11, float n12) {
        Matrix m = new Matrix();
        m.setValues(new float[]{n00, n01, n02, n10, n11, n12, 0.0f, 0.0f, 1.0f});
        this.canvas.concat(m);
    }

    public void applyMatrix(float n00, float n01, float n02, float n03, float n10, float n11, float n12, float n13, float n20, float n21, float n22, float n23, float n30, float n31, float n32, float n33) {
        PGraphicsAndroid2D.showVariationWarning("applyMatrix");
    }

    public PMatrix getMatrix() {
        return this.getMatrix((PMatrix2D)null);
    }

    public PMatrix2D getMatrix(PMatrix2D target) {
        if (target == null) {
            target = new PMatrix2D();
        }
        Matrix m = new Matrix();
        this.canvas.getMatrix(m);
        m.getValues(this.transform);
        target.set(this.transform[0], this.transform[1], this.transform[2], this.transform[3], this.transform[4], this.transform[5]);
        return target;
    }

    public PMatrix3D getMatrix(PMatrix3D target) {
        PGraphicsAndroid2D.showVariationWarning("getMatrix");
        return target;
    }

    public void setMatrix(PMatrix2D source) {
        Matrix matrix = new Matrix();
        matrix.setValues(new float[]{source.m00, source.m01, source.m02, source.m10, source.m11, source.m12, 0.0f, 0.0f, 1.0f});
        this.canvas.setMatrix(matrix);
    }

    public void setMatrix(PMatrix3D source) {
        PGraphicsAndroid2D.showVariationWarning("setMatrix");
    }

    public void printMatrix() {
        this.getMatrix((PMatrix2D)null).print();
    }

    public float screenX(float x, float y) {
        if (this.screenPoint == null) {
            this.screenPoint = new float[2];
        }
        this.screenPoint[0] = x;
        this.screenPoint[1] = y;
        this.canvas.getMatrix().mapPoints(this.screenPoint);
        return this.screenPoint[0];
    }

    public float screenY(float x, float y) {
        if (this.screenPoint == null) {
            this.screenPoint = new float[2];
        }
        this.screenPoint[0] = x;
        this.screenPoint[1] = y;
        this.canvas.getMatrix().mapPoints(this.screenPoint);
        return this.screenPoint[1];
    }

    public float screenX(float x, float y, float z) {
        PGraphicsAndroid2D.showDepthWarningXYZ("screenX");
        return 0.0f;
    }

    public float screenY(float x, float y, float z) {
        PGraphicsAndroid2D.showDepthWarningXYZ("screenY");
        return 0.0f;
    }

    public float screenZ(float x, float y, float z) {
        PGraphicsAndroid2D.showDepthWarningXYZ("screenZ");
        return 0.0f;
    }

    public void strokeCap(int cap) {
        super.strokeCap(cap);
        if (this.strokeCap == 2) {
            this.strokePaint.setStrokeCap(Paint.Cap.ROUND);
        } else if (this.strokeCap == 4) {
            this.strokePaint.setStrokeCap(Paint.Cap.SQUARE);
        } else {
            this.strokePaint.setStrokeCap(Paint.Cap.BUTT);
        }
    }

    public void strokeJoin(int join) {
        super.strokeJoin(join);
        if (this.strokeJoin == 8) {
            this.strokePaint.setStrokeJoin(Paint.Join.MITER);
        } else if (this.strokeJoin == 2) {
            this.strokePaint.setStrokeJoin(Paint.Join.ROUND);
        } else {
            this.strokePaint.setStrokeJoin(Paint.Join.BEVEL);
        }
    }

    public void strokeWeight(float weight) {
        super.strokeWeight(weight);
        this.strokePaint.setStrokeWidth(weight);
    }

    protected void strokeFromCalc() {
        super.strokeFromCalc();
        this.strokePaint.setColor(this.strokeColor);
        this.strokePaint.setShader(null);
    }

    protected void tintFromCalc() {
        super.tintFromCalc();
        this.tintPaint.setColorFilter((ColorFilter)new PorterDuffColorFilter(this.tintColor, PorterDuff.Mode.MULTIPLY));
    }

    protected void fillFromCalc() {
        super.fillFromCalc();
        this.fillPaint.setColor(this.fillColor);
        this.fillPaint.setShader(null);
    }

    public void backgroundImpl() {
        this.canvas.drawColor(this.backgroundColor);
    }

    public void beginRaw(PGraphics recorderRaw) {
        PGraphicsAndroid2D.showMethodWarning("beginRaw");
    }

    public void endRaw() {
        PGraphicsAndroid2D.showMethodWarning("endRaw");
    }

    public void loadPixels() {
        if (this.pixels == null || this.pixels.length != this.width * this.height) {
            this.pixels = new int[this.width * this.height];
        }
        this.bitmap.getPixels(this.pixels, 0, this.width, 0, 0, this.width, this.height);
    }

    public void updatePixels() {
        this.bitmap.setPixels(this.pixels, 0, this.width, 0, 0, this.width, this.height);
    }

    public void updatePixels(int x, int y, int c, int d) {
        if (x != 0 || y != 0 || c != this.width || d != this.height) {
            PGraphicsAndroid2D.showVariationWarning("updatePixels(x, y, w, h)");
        }
        this.updatePixels();
    }

    public void resize(int wide, int high) {
        PGraphicsAndroid2D.showMethodWarning("resize");
    }

    public int get(int x, int y) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return 0;
        }
        return this.bitmap.getPixel(x, y);
    }

    public PImage get() {
        return this.get(0, 0, this.width, this.height);
    }

    public void set(int x, int y, int argb) {
        if (x < 0 || y < 0 || x >= this.width || y >= this.height) {
            return;
        }
        this.bitmap.setPixel(x, y, argb);
    }

    public void set(int x, int y, PImage src) {
        if (src.format == 4) {
            throw new RuntimeException("set() not available for ALPHA images");
        }
        if (src.bitmap == null) {
            this.canvas.drawBitmap(src.pixels, 0, src.width, x, y, src.width, src.height, false, null);
        } else {
            if (src.width != src.bitmap.getWidth() || src.height != src.bitmap.getHeight()) {
                src.bitmap = Bitmap.createBitmap((int)src.width, (int)src.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                src.modified = true;
            }
            if (src.modified) {
                if (!src.bitmap.isMutable()) {
                    src.bitmap = Bitmap.createBitmap((int)src.width, (int)src.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                }
                src.bitmap.setPixels(src.pixels, 0, src.width, 0, 0, src.width, src.height);
                src.modified = false;
            }
            this.canvas.save(1);
            this.canvas.setMatrix(null);
            this.canvas.drawBitmap(src.bitmap, (float)x, (float)y, null);
            this.canvas.restore();
        }
    }

    public void mask(int[] alpha) {
        PGraphicsAndroid2D.showMethodWarning("mask");
    }

    public void mask(PImage alpha) {
        PGraphicsAndroid2D.showMethodWarning("mask");
    }

    public void copy(int sx, int sy, int sw, int sh, int dx, int dy, int dw, int dh) {
        this.rect.set((float)sx, (float)sy, (float)(sx + sw), (float)(sy + sh));
        Rect src = new Rect(dx, dy, dx + dw, dy + dh);
        this.canvas.drawBitmap(this.bitmap, src, this.rect, null);
    }
}

