/*
 * Decompiled with CFR 0.152.
 */
package proxml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import processing.core.PApplet;
import proxml.XMLElement;

public class XMLInOut {
    private static final String docStart = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>";
    private XMLElement actualElement;
    private XMLElement result;
    private final PApplet pApplet;
    private final Object parent;
    private Method xmlEventMethod;
    static /* synthetic */ Class class$0;

    public XMLInOut(PApplet pApplet) {
        this.pApplet = pApplet;
        this.parent = pApplet;
        try {
            Class<?> clazz = pApplet.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("proxml.XMLElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            this.xmlEventMethod = clazz.getMethod("xmlEvent", classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public XMLInOut(PApplet pApplet, Object i_parent) {
        this.pApplet = pApplet;
        this.parent = i_parent;
        try {
            Class<?> clazz = i_parent.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("proxml.XMLElement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            this.xmlEventMethod = clazz.getMethod("xmlEvent", classArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private InputStream openStream(String filename) {
        File file2;
        InputStream stream = null;
        try {
            URL url = new URL(filename);
            stream = url.openStream();
            return stream;
        }
        catch (MalformedURLException url) {
        }
        catch (IOException e) {
            throw new RuntimeException("Error downloading from URL " + filename);
        }
        if (!this.pApplet.online) {
            try {
                file2 = new File(String.valueOf(this.pApplet.sketchPath) + File.separator + "data", filename);
                if (!file2.exists()) {
                    file2 = new File(this.pApplet.sketchPath, filename);
                }
                if (file2.exists()) {
                    try {
                        String path = file2.getCanonicalPath();
                        String filenameActual = new File(path).getName();
                        if (filenameActual.equalsIgnoreCase(filename) && !filenameActual.equals(filename)) {
                            throw new RuntimeException("This file is named " + filenameActual + " not " + filename + ".");
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if ((stream = new FileInputStream(file2)) != null) {
                    return stream;
                }
            }
            catch (IOException file2) {
            }
            catch (SecurityException file2) {
                // empty catch block
            }
        }
        try {
            stream = this.pApplet.getClass().getResourceAsStream(filename);
            if (stream != null) {
                return stream;
            }
            stream = this.pApplet.getClass().getResourceAsStream("data/" + filename);
            if (stream != null) {
                return stream;
            }
            try {
                try {
                    file2 = new File(this.pApplet.sketchPath, filename);
                    stream = new FileInputStream(file2);
                    if (stream != null) {
                        return stream;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    stream = new FileInputStream(new File("data", filename));
                    if (stream != null) {
                        return stream;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    stream = new FileInputStream(filename);
                    if (stream != null) {
                        return stream;
                    }
                }
                catch (IOException iOException) {}
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (stream == null) {
                throw new IOException("openStream() could not open " + filename);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void loadElement(String documentUrl) {
        Thread loader;
        if (documentUrl.startsWith("<?xml")) {
            loader = new Thread(new Loader(new StringReader(documentUrl), this.parent));
        } else {
            try {
                InputStream test = this.openStream(documentUrl);
                loader = new Thread(new Loader(new BufferedReader(new InputStreamReader(test)), this.parent));
            }
            catch (Exception e) {
                throw new RuntimeException("proXML was not able to load the given xml-file: " + documentUrl + " Please check if you have entered the correct url.");
            }
        }
        try {
            loader.start();
        }
        catch (Exception e) {
            throw new RuntimeException("proXML was not able to read the given xml-file: " + documentUrl + " Please make sure that you load a file that contains valid xml.");
        }
    }

    public XMLElement loadElementFrom(String documentUrl) {
        Loader loader;
        if (documentUrl.startsWith("<?xml")) {
            loader = new Loader(new StringReader(documentUrl), null);
        } else {
            try {
                InputStream test = this.openStream(documentUrl);
                loader = new Loader(new BufferedReader(new InputStreamReader(test)), null);
            }
            catch (Exception e) {
                throw new RuntimeException("proXML was not able to load the given xml-file: " + documentUrl + " Please check if you have entered the correct url.");
            }
        }
        try {
            loader.run();
            return loader.xmlElement;
        }
        catch (Exception e) {
            throw new RuntimeException("proXML was not able to read the given xml-file: " + documentUrl + " Please make sure that you load a file that contains valid xml.");
        }
    }

    public void saveElement(XMLElement xmlElement, String filename) {
        try {
            File file;
            if (!this.pApplet.online) {
                File unit;
                String parent;
                file = new File(String.valueOf(this.pApplet.sketchPath) + File.separator + "data", filename);
                System.out.println(String.valueOf(this.pApplet.sketchPath) + File.separator + "data");
                if (!file.exists() && (parent = file.getParent()) != null && !(unit = new File(parent)).exists()) {
                    unit.mkdirs();
                }
            } else {
                file = new File(this.pApplet.getClass().getResource("data/" + filename).toURI());
            }
            PrintWriter output = new PrintWriter(new FileOutputStream(file));
            output.println(docStart);
            xmlElement.printElementTree(output, "  ");
            output.flush();
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(String.valueOf(this.pApplet.sketchPath) + File.separator + "data");
            System.out.println("You cannot write to this destination. Make sure destionation is a valid path");
        }
    }

    private class Loader
    implements Runnable {
        Reader document;
        Reader keep;
        Object xmlHandler;
        private boolean firstTag = false;
        private boolean rootNode = false;
        private int line = 0;
        XMLElement xmlElement;

        Loader(Reader i_document, Object i_xmlHandler) {
            this.document = i_document;
            this.xmlHandler = i_xmlHandler;
        }

        String getSource() {
            StringBuffer result = new StringBuffer();
            try {
                int iChar;
                while ((iChar = this.keep.read()) != -1) {
                    result.append((char)iChar);
                }
            }
            catch (Exception e) {
                return "fails";
            }
            return result.toString();
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private XMLElement parseDocument(Reader document) {
            this.firstTag = true;
            this.rootNode = true;
            sbText = new StringBuffer();
            bText = false;
            try {
                while (true) lbl-1000:
                // 14 sources

                {
                    if ((iChar = document.read()) == -1) {
                        return XMLInOut.access$1(XMLInOut.this);
                    }
                    cChar = (char)iChar;
                    switch (cChar) {
                        case '\b': {
                            ** break;
                        }
                        case '\n': {
                            ++this.line;
                            ** break;
                        }
                        case '\f': {
                            ** break;
                        }
                        case '\r': {
                            ** break;
                        }
                        case '\t': {
                            ** break;
                        }
                        case '<': {
                            if (bText) {
                                bText = false;
                                XMLInOut.access$0(XMLInOut.this).addChild(new XMLElement(sbText.toString(), true));
                                sbText = new StringBuffer();
                            }
                            if ((iChar = document.read()) != -1) {
                                cChar = (char)iChar;
                                if (cChar == '/') {
                                    document = this.handleEndTag(XMLInOut.access$1(XMLInOut.this), document);
                                    ** break;
                                }
                                if (cChar == '!' && (iChar = document.read()) != -1) {
                                    cChar = (char)iChar;
                                    if (cChar == '-') {
                                        document = this.handleComment(document);
                                        ** break;
                                    }
                                    if (cChar == '[') {
                                        document = this.handleCDATASection(document);
                                        ** break;
                                    }
                                    if (cChar == 'D') {
                                        document = this.handleDoctypeSection(document);
                                        ** break;
                                    }
                                }
                            }
                            document = this.handleStartTag(document, new StringBuffer().append(cChar));
                            ** break;
                        }
                    }
                    if (cChar == ' ' && !bText) continue;
                    bText = true;
                    if (cChar == '&') {
                        document = this.handleEntity(document, sbText);
                        ** break;
                    }
                    sbText.append(cChar);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return XMLInOut.access$1(XMLInOut.this);
        }

        private Reader handleStartTag(Reader page, StringBuffer alreadyParsed) throws Exception {
            int iChar;
            boolean bTagName = true;
            boolean bSpaceBefore = false;
            boolean bLeftAttribute = false;
            StringBuffer sbTagName = alreadyParsed;
            StringBuffer sbAttributeName = new StringBuffer();
            StringBuffer sbAttributeValue = new StringBuffer();
            StringBuffer sbActual = sbTagName;
            Hashtable<String, String> attributes = new Hashtable<String, String>();
            boolean inValue = false;
            int oChar = 32;
            while ((iChar = page.read()) != -1) {
                char cChar = (char)iChar;
                switch (cChar) {
                    case '\b': {
                        break;
                    }
                    case '\f': {
                        break;
                    }
                    case '\r': {
                        break;
                    }
                    case '\n': {
                        ++this.line;
                    }
                    case '\t': 
                    case ' ': {
                        String sAttributeValue;
                        String sAttributeName;
                        if (!bSpaceBefore) {
                            if (!inValue) {
                                if (bTagName) {
                                    bTagName = false;
                                } else {
                                    sAttributeName = sbAttributeName.toString();
                                    sAttributeValue = sbAttributeValue.toString();
                                    attributes.put(sAttributeName, sAttributeValue);
                                    sbAttributeName = new StringBuffer();
                                    sbAttributeValue = new StringBuffer();
                                    bLeftAttribute = false;
                                }
                                sbActual = sbAttributeName;
                            } else {
                                sbActual.append(cChar);
                            }
                        }
                        bSpaceBefore = true;
                        break;
                    }
                    case '=': {
                        if (!inValue) {
                            sbActual = sbAttributeValue;
                            bLeftAttribute = true;
                            break;
                        }
                        sbActual.append(cChar);
                        break;
                    }
                    case '\"': {
                        inValue = !inValue;
                        try {
                            if (!inValue && sbActual.charAt(sbActual.length() - 1) == ' ') {
                                sbActual.deleteCharAt(sbActual.length() - 1);
                            }
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            System.out.println(sbActual.toString());
                        }
                        bSpaceBefore = false;
                        break;
                    }
                    case '\'': {
                        break;
                    }
                    case '/': {
                        if (!inValue) break;
                        sbActual.append(cChar);
                        break;
                    }
                    case '>': {
                        String sAttributeValue;
                        String sAttributeName;
                        if (bLeftAttribute) {
                            sAttributeName = sbAttributeName.toString();
                            sAttributeValue = sbAttributeValue.toString();
                            attributes.put(sAttributeName, sAttributeValue);
                        }
                        String sTagName = sbTagName.toString();
                        if (this.firstTag) {
                            this.firstTag = false;
                            if (!sTagName.equals("doctype") && !sTagName.equals("?xml")) {
                                throw new RuntimeException("XML File has no valid header");
                            }
                        } else if (this.rootNode && !this.firstTag) {
                            this.rootNode = false;
                            XMLInOut.this.result = new XMLElement(sTagName, attributes);
                            XMLInOut.this.actualElement = XMLInOut.this.result;
                        } else {
                            XMLElement keep = new XMLElement(sTagName, attributes);
                            XMLInOut.this.actualElement.addChild(keep);
                            if (oChar != 47) {
                                XMLInOut.this.actualElement = keep;
                            }
                        }
                        return page;
                    }
                    default: {
                        bSpaceBefore = false;
                        sbActual.append(cChar);
                    }
                }
                oChar = cChar;
            }
            throw new RuntimeException("Error in line:" + this.line);
        }

        private Reader handleEndTag(XMLElement xmlElement, Reader toParse) throws Exception {
            int iChar;
            while ((iChar = toParse.read()) != -1) {
                char cChar = (char)iChar;
                switch (cChar) {
                    case '\b': {
                        break;
                    }
                    case '\n': {
                        ++this.line;
                        break;
                    }
                    case '\f': {
                        break;
                    }
                    case '\r': {
                        break;
                    }
                    case '\t': {
                        break;
                    }
                    case '>': {
                        if (!XMLInOut.this.actualElement.equals(xmlElement)) {
                            XMLInOut.this.actualElement = XMLInOut.this.actualElement.getParent();
                        }
                        return toParse;
                    }
                }
            }
            throw new RuntimeException("Error in line:" + this.line);
        }

        private Reader handleComment(Reader toParse) throws Exception {
            int iChar;
            int prevChar = 32;
            while ((iChar = toParse.read()) != -1) {
                char cChar = (char)iChar;
                if (prevChar == 45 && cChar == '>') {
                    return toParse;
                }
                prevChar = cChar;
            }
            throw new RuntimeException("Comment is not correctly closed in Line:" + this.line);
        }

        private Reader handleDoctypeSection(Reader toParse) throws Exception {
            int iChar;
            int prevChar = 32;
            boolean entities = false;
            while ((iChar = toParse.read()) != -1) {
                char cChar = (char)iChar;
                if (cChar == '[') {
                    entities = true;
                }
                if (cChar == '>' && (prevChar == 93 && entities || !entities)) {
                    return toParse;
                }
                prevChar = cChar;
            }
            throw new RuntimeException("Comment is not correctly closed in Line:" + this.line);
        }

        private Reader handleEntity(Reader toParse, StringBuffer stringBuffer) throws Exception {
            int iChar;
            StringBuffer result = new StringBuffer();
            int counter = 0;
            while ((iChar = toParse.read()) != -1) {
                char cChar = (char)iChar;
                result.append(cChar);
                if (cChar == ';') {
                    String entity = result.toString().toLowerCase();
                    if (entity.equals("lt;")) {
                        stringBuffer.append("<");
                        break;
                    }
                    if (entity.equals("gt;")) {
                        stringBuffer.append(">");
                        break;
                    }
                    if (entity.equals("amp;")) {
                        stringBuffer.append("&");
                        break;
                    }
                    if (entity.equals("quot;")) {
                        stringBuffer.append("\"");
                        break;
                    }
                    if (!entity.equals("apos;")) break;
                    stringBuffer.append("'");
                    break;
                }
                if (++counter <= 4) continue;
                throw new RuntimeException("Illegal use of &. Use &amp; entity instead. Line:" + this.line);
            }
            return toParse;
        }

        private Reader handleCDATASection(Reader toParse) throws Exception {
            int iChar;
            StringBuffer result = new StringBuffer();
            int counter = 0;
            boolean checkedCDATA = false;
            while ((iChar = toParse.read()) != -1) {
                char cChar = (char)iChar;
                if (cChar == ']') {
                    XMLElement keep = new XMLElement(result.toString());
                    keep.cdata = true;
                    keep.pcdata = true;
                    XMLInOut.this.actualElement.addChild(keep);
                    break;
                }
                result.append(cChar);
                if (++counter <= 5 || checkedCDATA) continue;
                checkedCDATA = true;
                if (!result.toString().toUpperCase().equals("CDATA[")) {
                    throw new RuntimeException("Illegal use of <![. These operators are used to start a CDATA section. <![CDATA[]]> Line:" + this.line);
                }
                result = new StringBuffer();
            }
            if ((char)toParse.read() != ']') {
                throw new RuntimeException("Wrong Syntax at the end of a CDATA section <![CDATA[]]> Line:" + this.line);
            }
            if ((char)toParse.read() != '>') {
                throw new RuntimeException("Wrong Syntax at the end of a CDATA section <![CDATA[]]> Line:" + this.line);
            }
            return toParse;
        }

        public void run() {
            this.xmlElement = this.parseDocument(this.document);
            if (this.xmlHandler == null) {
                return;
            }
            try {
                XMLInOut.this.xmlEventMethod.invoke(this.xmlHandler, this.xmlElement);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NullPointerException e) {
                throw new RuntimeException("You need to implement the xmlEvent() function to handle the loaded xml files.");
            }
        }
    }
}

