/*
 * Decompiled with CFR 0.152.
 */
package proxml;

import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import proxml.InvalidAttributeException;

public class XMLElement {
    Hashtable attributes;
    private Vector children;
    private boolean empty = true;
    boolean pcdata;
    boolean cdata = false;
    private XMLElement parent;
    private String element;

    private XMLElement(String name, Hashtable attributes, Vector children, boolean pcdata) {
        this.element = name;
        this.attributes = attributes;
        this.children = children;
        this.pcdata = pcdata;
    }

    public XMLElement(String name, boolean pcdata) {
        this(name, new Hashtable(), new Vector(), pcdata);
    }

    public XMLElement(String name, Hashtable attributes, Vector children) {
        this(name, attributes, children, false);
    }

    public XMLElement(String name) {
        this(name, new Hashtable(), new Vector());
    }

    public XMLElement(String name, Vector children) {
        this(name, new Hashtable(), children);
    }

    public XMLElement(String name, Hashtable attributes) {
        this(name, attributes, new Vector());
    }

    private boolean has(Vector toCheck) {
        return !toCheck.isEmpty() && toCheck != null;
    }

    public boolean isTextElement() {
        return this.pcdata;
    }

    public String getElement() {
        return this.element;
    }

    public String getName() {
        if (this.isTextElement()) {
            return null;
        }
        return this.element;
    }

    public String getText() {
        if (this.isTextElement()) {
            return this.element;
        }
        return null;
    }

    public String[] getAttributes() {
        Object[] attributeArray = this.attributes.keySet().toArray();
        String[] result = new String[attributeArray.length];
        int i = 0;
        while (i < attributeArray.length) {
            result[i] = (String)attributeArray[i];
            ++i;
        }
        return result;
    }

    public String getAttribute(String key) {
        String result = (String)this.attributes.get(key);
        if (result == null) {
            throw new InvalidAttributeException(this.element, key);
        }
        return result;
    }

    public int getIntAttribute(String key) {
        String attributeValue = (String)this.attributes.get(key);
        if (attributeValue == null) {
            throw new InvalidAttributeException(this.element, key);
        }
        try {
            return Integer.parseInt((String)this.attributes.get(key));
        }
        catch (NumberFormatException e) {
            throw new InvalidAttributeException(this.element, key, "int");
        }
    }

    public float getFloatAttribute(String key) {
        String attributeValue = (String)this.attributes.get(key);
        if (attributeValue == null) {
            throw new InvalidAttributeException(this.element, key);
        }
        try {
            return Float.parseFloat((String)this.attributes.get(key));
        }
        catch (NumberFormatException e) {
            throw new InvalidAttributeException(this.element, key, "int");
        }
    }

    public boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    public int countAttributes() {
        return this.attributes.size();
    }

    public void addAttribute(String key, String value) {
        if (this.isTextElement()) {
            throw new InvalidAttributeException(key);
        }
        this.attributes.put(key, value);
    }

    public void addAttribute(String key, int value) {
        this.addAttribute(key, String.valueOf(value));
    }

    public void addAttribute(String key, float value) {
        this.addAttribute(key, String.valueOf(value));
    }

    public XMLElement getParent() {
        return this.parent;
    }

    public XMLElement[] getChildren() {
        Object[] childArray = this.children.toArray();
        XMLElement[] result = new XMLElement[childArray.length];
        int i = 0;
        while (i < childArray.length) {
            result[i] = (XMLElement)childArray[i];
            ++i;
        }
        return result;
    }

    public XMLElement firstChild() {
        if (this.hasChildren()) {
            return this.getChild(0);
        }
        return null;
    }

    public XMLElement lastChild() {
        if (this.hasChildren()) {
            return this.getChild(this.countChildren() - 1);
        }
        return null;
    }

    public XMLElement nextSibling() {
        if (this.parent == null) {
            return null;
        }
        int index = this.parent.children.indexOf(this);
        if (index < this.parent.countChildren() - 1) {
            return this.parent.getChild(index + 1);
        }
        return null;
    }

    public XMLElement previousSibling() {
        if (this.parent == null) {
            return null;
        }
        int index = this.parent.children.indexOf(this);
        if (index > 0) {
            return this.parent.getChild(index - 1);
        }
        return null;
    }

    public XMLElement getChild(int i) {
        return (XMLElement)this.children.get(i);
    }

    public boolean hasChildren() {
        return this.has(this.children);
    }

    public int countChildren() {
        return this.children.size();
    }

    public void addChild(XMLElement element) {
        this.empty = false;
        element.parent = this;
        this.children.add(element);
    }

    public void addChild(XMLElement element, int position) {
        this.empty = false;
        element.parent = this;
        this.children.add(position, element);
    }

    public void removeChild(int childNumber) {
        this.children.remove(childNumber);
        this.empty = this.children.size() == 0;
    }

    public int getDepth() {
        int result = 0;
        XMLElement[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            result = Math.max(result, children[i].getDepth());
            ++i;
        }
        return 1 + result;
    }

    public int countAllChildren() {
        int result = 0;
        XMLElement[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            result += children[i].countAllChildren();
            ++i;
        }
        return 1 + result;
    }

    public Vector getSpecificElements(String element) {
        Vector<XMLElement> result = new Vector<XMLElement>();
        XMLElement[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            if (!children[i].isTextElement()) {
                result.addAll(children[i].getSpecificElements(element));
            }
            if (children[i].element.equals(element)) {
                result.add(children[i]);
            }
            ++i;
        }
        return result;
    }

    public String toString() {
        if (this.isTextElement()) {
            if (this.cdata) {
                StringBuffer result = new StringBuffer();
                result.append("<![CDATA[");
                result.append(this.getElement());
                result.append("]]>");
                return result.toString();
            }
            String result = this.getElement();
            result = result.replaceAll("&", "&amp;");
            result = result.replaceAll("<", "&lt;");
            result = result.replaceAll(">", "&gt;");
            result = result.replaceAll("\"", "&quot;");
            result = result.replaceAll("'", "&apos;");
            return result;
        }
        StringBuffer result = new StringBuffer();
        result.append("<");
        result.append(this.element);
        Iterator it = this.attributes.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            result.append(" ");
            result.append(key);
            result.append("=\"");
            result.append(this.attributes.get(key));
            result.append("\"");
        }
        if (this.empty) {
            result.append("/>");
        } else {
            result.append(">");
        }
        return result.toString();
    }

    public void printElementTree() {
        this.printElementTree(" ");
    }

    public void printElementTree(String dist) {
        this.printElementTree("", dist);
    }

    void printElementTree(String start, String dist) {
        System.out.println(String.valueOf(start) + this);
        int i = 0;
        while (i < this.children.size()) {
            ((XMLElement)this.children.get(i)).printElementTree(String.valueOf(start) + dist, dist);
            ++i;
        }
        if (!this.empty) {
            System.out.println(String.valueOf(start) + "</" + this.element + ">");
        }
    }

    void printElementTree(PrintWriter output, String dist) {
        this.printElementTree(output, "", dist);
    }

    void printElementTree(PrintWriter output, String start, String dist) {
        output.println(String.valueOf(start) + this);
        int i = 0;
        while (i < this.children.size()) {
            ((XMLElement)this.children.get(i)).printElementTree(output, String.valueOf(start) + dist, dist);
            ++i;
        }
        if (!this.empty) {
            output.println(String.valueOf(start) + "</" + this.element + ">");
        }
    }
}

