/*
 * Decompiled with CFR 0.152.
 */
package jpen.provider.xinput;

import jpen.provider.xinput.XiDevice;

final class XiBus {
    static final Object macrofLock = new Object();
    private final int cellIndex;
    private XiDevice xiDevice;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XiBus() throws Exception {
        Object object = macrofLock;
        synchronized (object) {
            this.cellIndex = XiBus.create();
            if (this.cellIndex == -1) {
                throw new Exception(XiBus.getError());
            }
        }
    }

    private static native int create();

    private static native String getError();

    public static native int getNativeBuild();

    public synchronized int getXiDevicesSize() {
        return XiBus.getDevicesSize(this.cellIndex);
    }

    private static native int getDevicesSize(int var0);

    public synchronized String getXiDeviceName(int xiDeviceIndex) {
        return XiBus.getDeviceName(this.cellIndex, xiDeviceIndex);
    }

    private static native String getDeviceName(int var0, int var1);

    public synchronized XiDevice getXiDevice() {
        return this.xiDevice;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setXiDevice(int xiDeviceIndex) throws Exception {
        Object object = macrofLock;
        synchronized (object) {
            if (xiDeviceIndex == -1) {
                this.xiDevice = null;
                return;
            }
            int xiDeviceCellIndex = XiBus.setDevice(this.cellIndex, xiDeviceIndex);
            if (xiDeviceCellIndex < 0) {
                throw new Exception(XiBus.getError());
            }
            this.xiDevice = new XiDevice(this, xiDeviceCellIndex, xiDeviceIndex);
        }
    }

    private static native int setDevice(int var0, int var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void refreshXiDeviceInfo() {
        Object object = macrofLock;
        synchronized (object) {
            if (XiBus.refreshDeviceInfo(this.cellIndex) != 0) {
                throw new IllegalStateException(XiBus.getError());
            }
        }
    }

    private static native int refreshDeviceInfo(int var0);

    synchronized void printXNextRequestSerial() {
        XiBus.printXNextRequestSerial(this.cellIndex);
    }

    private static native void printXNextRequestSerial(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void finalize() {
        Object object = macrofLock;
        synchronized (object) {
            if (this.cellIndex != -1) {
                XiBus.destroy(this.cellIndex);
            }
        }
    }

    static native int destroy(int var0);

    public synchronized String toString() {
        return "{Bus: xiDevice=" + this.xiDevice + "}";
    }
}

