/*
 * Decompiled with CFR 0.152.
 */
package jpen.provider.system;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jpen.PButton;
import jpen.PLevel;
import jpen.PScroll;
import jpen.provider.AbstractPenDevice;
import jpen.provider.system.SystemProvider;

public final class MouseDevice
extends AbstractPenDevice {
    private static final Logger L = Logger.getLogger(MouseDevice.class.getName());
    private final MouseListener mouseL = new MouseAdapter(){

        public void mousePressed(MouseEvent ev) {
            MouseDevice.this.scheduleMove(ev);
            MouseDevice.this.mouseButtonChanged(ev, true);
        }

        public void mouseReleased(MouseEvent ev) {
            MouseDevice.this.scheduleMove(ev);
            MouseDevice.this.mouseButtonChanged(ev, false);
        }
    };
    private final MouseMotionListener mouseMotionL = new MouseMotionListener(){

        public void mouseMoved(MouseEvent ev) {
            MouseDevice.this.scheduleMove(ev);
        }

        public void mouseDragged(MouseEvent ev) {
            MouseDevice.this.scheduleMove(ev);
        }
    };
    private final MouseWheelListener mouseWheelL = new MouseWheelListener(){

        public void mouseWheelMoved(MouseWheelEvent ev) {
            if (!MouseDevice.this.getEnabled()) {
                return;
            }
            int value = ev.getWheelRotation();
            PScroll.Type type = PScroll.Type.DOWN;
            if (value < 0) {
                type = PScroll.Type.UP;
                value = -value;
            }
            if (ev.getScrollType() == 0 && ev.getScrollAmount() > 0) {
                value *= ev.getScrollAmount();
            }
            MouseDevice.this.getPenManager().scheduleScrollEvent(MouseDevice.this, ev.getWhen(), new PScroll(type.ordinal(), value));
        }
    };
    private final SystemProvider systemProvider;
    private WeakReference<Component> activeComponentRef;
    private final PLevel[] changedLevelsA = new PLevel[2];
    private final List<PLevel> changedLevels = Arrays.asList(this.changedLevelsA);

    MouseDevice(SystemProvider systemProvider) {
        super(systemProvider);
        this.systemProvider = systemProvider;
        this.setEnabled(true);
    }

    public String getName() {
        return "Mouse";
    }

    public boolean getUseFractionalMovements() {
        return false;
    }

    void setPaused(boolean paused) {
        Component activeComponent = this.activeComponentRef == null ? null : (Component)this.activeComponentRef.get();
        this.activeComponentRef = null;
        if (activeComponent != null) {
            activeComponent.removeMouseListener(this.mouseL);
            activeComponent.removeMouseMotionListener(this.mouseMotionL);
            activeComponent.removeMouseWheelListener(this.mouseWheelL);
        }
        if (!paused && (activeComponent = this.systemProvider.componentPenOwner.getActiveComponent()) != null) {
            activeComponent.addMouseListener(this.mouseL);
            activeComponent.addMouseMotionListener(this.mouseMotionL);
            activeComponent.addMouseWheelListener(this.mouseWheelL);
            this.activeComponentRef = new WeakReference<Component>(activeComponent);
        }
    }

    private void scheduleMove(MouseEvent ev) {
        if (!this.getEnabled()) {
            return;
        }
        this.scheduleMove(ev.getWhen(), ev.getX(), ev.getY());
    }

    private void scheduleMove(long time, int x, int y) {
        this.changedLevelsA[0] = new PLevel(PLevel.Type.X.ordinal(), (float)x);
        this.changedLevelsA[1] = new PLevel(PLevel.Type.Y.ordinal(), (float)y);
        this.getPenManager().scheduleLevelEvent(this, time, this.changedLevels, false);
    }

    private void mouseButtonChanged(MouseEvent ev, boolean state) {
        if (!this.getEnabled()) {
            return;
        }
        PButton.Type buttonType = MouseDevice.getButtonType(ev.getButton());
        if (buttonType == null) {
            return;
        }
        if (L.isLoggable(Level.FINE)) {
            L.fine("scheduling button event: " + (Object)((Object)buttonType) + ", " + state);
        }
        this.getPenManager().scheduleButtonEvent(this, ev.getWhen(), new PButton(buttonType.ordinal(), (Boolean)state));
    }

    private static PButton.Type getButtonType(int buttonNumber) {
        switch (buttonNumber) {
            case 1: {
                return PButton.Type.LEFT;
            }
            case 2: {
                return PButton.Type.CENTER;
            }
            case 3: {
                return PButton.Type.RIGHT;
            }
        }
        return null;
    }
}

