/*
 * Decompiled with CFR 0.152.
 */
package jpen.provider;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import jpen.PenManager;
import jpen.internal.BuildInfo;

public class NativeLibraryLoader {
    private static final Logger L = Logger.getLogger(NativeLibraryLoader.class.getName());
    private static String PREFERENCE_KEY$ARCHITECTURE = "NativeLibraryLoader.architecture";
    private final Map<String, Collection<String>> dataModelToArchitectures = new HashMap<String, Collection<String>>();
    private boolean loaded;
    public final int nativeVersion;

    public NativeLibraryLoader(int nativeVersion) {
        this(new String[]{""}, nativeVersion);
    }

    public NativeLibraryLoader(String[] architectures, int nativeVersion) {
        this(architectures, architectures, nativeVersion);
    }

    public NativeLibraryLoader() {
        this(new String[]{""});
    }

    public NativeLibraryLoader(String[] architectures) {
        this(architectures, architectures);
    }

    public NativeLibraryLoader(String[] architectures32, String[] architectures64) {
        this(architectures32, architectures64, 0);
    }

    public NativeLibraryLoader(String[] architectures32, String[] architectures64, int nativeVersion) {
        this.dataModelToArchitectures.put("32", Arrays.asList(architectures32));
        this.dataModelToArchitectures.put("64", Arrays.asList(architectures64));
        this.nativeVersion = nativeVersion;
    }

    public synchronized void load() {
        if (!this.loaded) {
            L.finest("v");
            Throwable loadExceptionCause = this.doLoad();
            this.loaded = true;
            if (loadExceptionCause != null) {
                L.info("no suitable JNI library found");
                throw new LoadException(loadExceptionCause);
            }
            L.finest("^");
        }
    }

    private Throwable doLoad() {
        String preferredArchitecture = this.getPreferredArchitecture();
        if (preferredArchitecture != null) {
            try {
                NativeLibraryLoader.loadLibrary(preferredArchitecture, this.nativeVersion);
                return null;
            }
            catch (Throwable t) {
                NativeLibraryLoader.setPreferredArchitecture(null);
            }
        }
        Throwable loadExceptionCause = null;
        String dataModel = NativeLibraryLoader.getJavaVMDataModel();
        Collection<String> architectures = this.dataModelToArchitectures.get(dataModel);
        if (architectures == null) {
            throw new IllegalStateException("Unsupported data model: " + dataModel);
        }
        for (String architecture : architectures) {
            try {
                NativeLibraryLoader.loadLibrary(architecture, this.nativeVersion);
                NativeLibraryLoader.setPreferredArchitecture(architecture);
                loadExceptionCause = null;
                break;
            }
            catch (Throwable t) {
                NativeLibraryLoader.setPreferredArchitecture(null);
                loadExceptionCause = t;
            }
        }
        return loadExceptionCause;
    }

    private static String getJavaVMDataModel() {
        String dataModel = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("sun.arch.data.model");
            }
        });
        return dataModel == null ? "32" : dataModel;
    }

    private String getPreferredArchitecture() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String override = System.getProperty("jpen.provider.architecture");
                if (override != null) {
                    return override;
                }
                Preferences preferences = Preferences.userNodeForPackage(NativeLibraryLoader.class);
                return preferences.get(PREFERENCE_KEY$ARCHITECTURE, null);
            }
        });
    }

    private static void setPreferredArchitecture(final String architecture) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public String run() {
                Preferences preferences = Preferences.userNodeForPackage(NativeLibraryLoader.class);
                if (architecture == null) {
                    preferences.remove(PREFERENCE_KEY$ARCHITECTURE);
                } else {
                    preferences.put(PREFERENCE_KEY$ARCHITECTURE, architecture);
                    L.info("preferred architecture set");
                }
                return null;
            }
        });
    }

    public static final void loadLibrary(final String architecture, final int nativeVersion) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){
            final String jniLibName;
            {
                this.jniLibName = NativeLibraryLoader.getJniLibName(architecture, nativeVersion);
            }

            @Override
            public Object run() {
                try {
                    L.info("loading JPen " + PenManager.getJPenFullVersion() + " JNI library: " + this.jniLibName + " ...");
                    System.loadLibrary(this.jniLibName);
                    L.info(this.jniLibName + " loaded");
                    return null;
                }
                catch (RuntimeException ex) {
                    this.logOnFail();
                    throw ex;
                }
                catch (Error ex) {
                    this.logOnFail();
                    throw ex;
                }
            }

            private void logOnFail() {
                L.info(this.jniLibName + " couldn't be loaded");
            }
        });
    }

    private static final String getJniLibName(String architecture, int nativeVersion) {
        StringBuilder jniLibName = new StringBuilder(64);
        jniLibName.append(BuildInfo.getModuleId());
        jniLibName.append("-");
        jniLibName.append(BuildInfo.getVersion());
        if (nativeVersion != 0) {
            jniLibName.append("-");
            jniLibName.append(nativeVersion);
        }
        if (architecture != null && architecture.trim().length() != 0) {
            jniLibName.append("-");
            jniLibName.append(architecture);
        }
        return jniLibName.toString();
    }

    public static class LoadException
    extends RuntimeException {
        LoadException(Throwable cause) {
            super(cause);
        }
    }
}

