/*
 * Decompiled with CFR 0.152.
 */
package jpen.owner.multiAwt;

import java.awt.Component;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import jpen.event.PenListener;
import jpen.owner.multiAwt.MultiAwtPenOwner;

final class ComponentPool {
    private final MultiAwtPenOwner multiAwtPenOwner;
    private final Map<Component, PenListener[]> componentToPenListeners = Collections.synchronizedMap(new HashMap());
    private final MouseListener mouseL = new MouseAdapter(){

        public void mouseEntered(MouseEvent ev) {
            ComponentPool.this.setPointerComponent(ev.getComponent());
        }

        public void mouseExited(MouseEvent ev) {
            ComponentPool.this.setPointerComponent(null);
        }
    };
    private final HierarchyListener hierarchyL = new HierarchyListener(){

        public void hierarchyChanged(HierarchyEvent ev) {
            if (ev.getID() == 1400) {
                if ((ev.getChangeFlags() & 2L) > 0L && !ev.getComponent().isDisplayable()) {
                    ComponentPool.this.fireComponentUndisplayable(ev.getComponent());
                }
            }
        }
    };
    private Component pointerComponent;
    private Listener listener;
    private static final PenListener[] emptyPenListeners = new PenListener[0];

    ComponentPool(MultiAwtPenOwner multiAwtPenOwner) {
        this.multiAwtPenOwner = multiAwtPenOwner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Component getPointerComponent() {
        Object object = this.multiAwtPenOwner.getPenSchedulerLock();
        synchronized (object) {
            return this.pointerComponent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPointerComponent(Component pointerComponent) {
        Object object = this.multiAwtPenOwner.getPenSchedulerLock(pointerComponent);
        synchronized (object) {
            if (pointerComponent == this.pointerComponent) {
                return;
            }
            Component oldPointerComponent = this.pointerComponent;
            this.pointerComponent = pointerComponent;
            this.firePointerComponentChanged();
        }
    }

    private void firePointerComponentChanged() {
        Listener listener = this.listener;
        if (listener != null) {
            listener.pointerComponentChanged(this.pointerComponent);
        }
    }

    void setListener(Listener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addPenListener(Component component, PenListener penListener) {
        Object object = this.multiAwtPenOwner.getPenSchedulerLock();
        synchronized (object) {
            if (component == null || penListener == null) {
                throw new NullPointerException();
            }
            PenListener[] penListeners = this.componentToPenListeners.get(component);
            if (penListeners == null) {
                this.componentToPenListeners.put(component, new PenListener[]{penListener});
                component.addMouseListener(this.mouseL);
                component.addHierarchyListener(this.hierarchyL);
                if (component.getMousePosition() != null) {
                    this.setPointerComponent(component);
                }
            } else {
                LinkedHashSet<PenListener> newPenListeners = new LinkedHashSet<PenListener>(Arrays.asList(penListeners));
                if (newPenListeners.add(penListener)) {
                    this.componentToPenListeners.put(component, newPenListeners.toArray(new PenListener[newPenListeners.size()]));
                    this.firePointerComponentPenListenersChanged(component);
                }
            }
        }
    }

    private void firePointerComponentPenListenersChanged(Component component) {
        if (this.pointerComponent != component) {
            return;
        }
        Listener listener = this.listener;
        if (listener != null) {
            listener.pointerComponentPenListenersChanged(component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePenListener(Component component, PenListener penListener) {
        Object object = this.multiAwtPenOwner.getPenSchedulerLock(component);
        synchronized (object) {
            PenListener[] penListeners = this.componentToPenListeners.get(component);
            if (penListeners == null) {
                return;
            }
            ArrayList<PenListener> newPenListeners = new ArrayList<PenListener>(Arrays.asList(penListeners));
            if (newPenListeners.remove(penListener)) {
                if (newPenListeners.isEmpty()) {
                    this.componentToPenListeners.remove(component);
                    component.removeMouseListener(this.mouseL);
                    component.removeHierarchyListener(this.hierarchyL);
                    if (this.pointerComponent == component) {
                        this.setPointerComponent(null);
                    }
                    this.fireComponentRemoved(component);
                } else {
                    this.componentToPenListeners.put(component, newPenListeners.toArray(new PenListener[newPenListeners.size()]));
                    this.firePointerComponentPenListenersChanged(component);
                }
            }
        }
    }

    private void fireComponentRemoved(Component component) {
        Listener listener = this.listener;
        if (listener != null) {
            listener.componentRemoved(component);
        }
    }

    private void fireComponentUndisplayable(Component component) {
        Listener listener = this.listener;
        if (listener != null) {
            listener.componentUndisplayable(component);
        }
    }

    PenListener[] getPenListeners(Component component) {
        if (component == null) {
            return emptyPenListeners;
        }
        PenListener[] penListeners = this.componentToPenListeners.get(component);
        return penListeners == null ? emptyPenListeners : penListeners;
    }

    static interface Listener {
        public void pointerComponentChanged(Component var1);

        public void pointerComponentPenListenersChanged(Component var1);

        public void componentRemoved(Component var1);

        public void componentUndisplayable(Component var1);
    }
}

