/*
 * Decompiled with CFR 0.152.
 */
package jpen.internal;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public final class AccessibleField {
    private final Class clazz;
    private final String fieldName;
    private Field field;

    public AccessibleField(Class clazz, String fieldName) {
        this.clazz = clazz;
        this.fieldName = fieldName;
    }

    public Field getField() {
        if (this.field == null) {
            try {
                this.field = AccessibleField.getAccessibleField(this.clazz, this.fieldName);
            }
            catch (PrivilegedActionException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        return this.field;
    }

    private static Field getAccessibleField(final Class clazz, final String fieldName) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

            @Override
            public Field run() throws Exception {
                Field field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                return field;
            }
        });
    }
}

