/*
 * Decompiled with CFR 0.152.
 */
package jpen.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import jpen.PKind;
import jpen.PLevel;
import jpen.PLevelEvent;
import jpen.demo.Utils;
import jpen.event.PenAdapter;
import jpen.owner.multiAwt.AwtPenToolkit;

class PenCanvas
extends JComponent {
    public static final long serialVersionUID = 1L;
    private static final Logger L = Logger.getLogger(PenCanvas.class.getName());
    private static final Dimension SIZE = new Dimension(1000, 1000);
    private static final Color BACKGROUND_COLOR = new Color(247, 217, 186);
    private static final float STROKE_RAD = 20.0f;
    private static final Dimension PREF_SCROLLPANE_SIZE = new Dimension(230, 120);
    final JScrollPane scrollPane;
    private final BufferedImage image;
    private final Graphics2D g;
    private final Point2D.Float cursorCenter;
    private final Ellipse2D.Float stroke;
    private final Rectangle dirtyArea;
    private boolean isDirty;
    private final Rectangle rectangle;

    PenCanvas() {
        this.image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(PenCanvas.SIZE.width, PenCanvas.SIZE.height);
        this.g = (Graphics2D)this.image.getGraphics();
        this.cursorCenter = new Point2D.Float();
        this.stroke = new Ellipse2D.Float();
        this.dirtyArea = new Rectangle();
        this.rectangle = new Rectangle();
        Utils.freezeSize(this, SIZE);
        this.setDoubleBuffered(false);
        this.setOpaque(true);
        this.scrollPane = new JScrollPane(this);
        this.scrollPane.setPreferredSize(PREF_SCROLLPANE_SIZE);
        this.image.setAccelerationPriority(1.0f);
        this.g.setColor(BACKGROUND_COLOR);
        this.rectangle.setFrame(0.0, 0.0, PenCanvas.SIZE.width, PenCanvas.SIZE.height);
        this.g.fill(this.rectangle);
        PenCanvas.setupRenderingHints(this.g);
        AwtPenToolkit.addPenListener(this, new PenAdapter(){

            public void penLevelEvent(PLevelEvent ev) {
                for (PLevel.Type levelType : PLevel.Type.MOVEMENT_TYPES) {
                    float value = ev.pen.getLevelValue(levelType);
                    switch (levelType) {
                        case X: {
                            ((PenCanvas)PenCanvas.this).cursorCenter.x = value;
                            break;
                        }
                        case Y: {
                            ((PenCanvas)PenCanvas.this).cursorCenter.y = value;
                        }
                    }
                }
                PenCanvas.this.paintStroke(ev);
            }

            public void penTock(long availableTime) {
                if (availableTime < 0L) {
                    L.warning("no time to repaint... but this is a test, so I continue.");
                }
                if (PenCanvas.this.isDirty) {
                    PenCanvas.this.repaint(((PenCanvas)PenCanvas.this).dirtyArea.x, ((PenCanvas)PenCanvas.this).dirtyArea.y, ((PenCanvas)PenCanvas.this).dirtyArea.width, ((PenCanvas)PenCanvas.this).dirtyArea.height);
                }
                PenCanvas.this.isDirty = false;
            }
        });
        this.setFocusable(true);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent ev) {
                if (ev.isControlDown() && ev.getKeyCode() == 68) {
                    JOptionPane.showMessageDialog(null, "<html>Testing dialog window:<p> the pen buttons must be disabled when this dialog appears.</html>");
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent ev) {
                PenCanvas.this.requestFocus();
            }
        });
    }

    private static void setupRenderingHints(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    private synchronized void paintStroke(PLevelEvent ev) {
        float pressure = ev.pen.getLevelValue(PLevel.Type.PRESSURE);
        if (pressure == 0.0f) {
            L.fine("no pressure");
            return;
        }
        float r = pressure * 20.0f;
        PKind.Type kindType = (PKind.Type)((Object)ev.pen.getKind().getType());
        switch (kindType) {
            case CUSTOM: {
                this.g.setColor(Color.PINK);
                break;
            }
            case STYLUS: {
                this.g.setColor(Color.BLACK);
                break;
            }
            case ERASER: {
                this.g.setColor(BACKGROUND_COLOR);
                break;
            }
            case CURSOR: {
                this.g.setColor(Color.BLUE);
            }
        }
        this.stroke.x = this.cursorCenter.x - r;
        this.stroke.y = this.cursorCenter.y - r;
        this.stroke.width = this.stroke.height = 2.0f * r;
        this.g.fill(this.stroke);
        L.fine("stoke painted");
        this.addCursorAreaToDirtyArea();
    }

    private void addCursorAreaToDirtyArea() {
        this.evalCursorArea(this.rectangle);
        if (this.isDirty) {
            this.dirtyArea.add(this.rectangle);
        } else {
            this.dirtyArea.setRect(this.rectangle);
        }
        this.isDirty = true;
    }

    private void evalCursorArea(Rectangle r) {
        float max = 42.0f;
        r.x = (int)(this.cursorCenter.x - max);
        r.y = (int)(this.cursorCenter.y - max);
        r.width = r.height = (int)(2.0f * max);
    }

    protected synchronized void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage(this.image, null, null);
    }
}

