/*
 * Decompiled with CFR 0.152.
 */
package jpen.demo;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JTextField;
import jpen.PLevel;
import jpen.PLevelEvent;
import jpen.Pen;
import jpen.demo.DataDisplay;
import jpen.demo.Utils;
import jpen.event.PenAdapter;

class LevelsPanel {
    final Map<PLevel.Type, Display> levelTypeToDisplay = new EnumMap<PLevel.Type, Display>(PLevel.Type.class);
    final Box panel;

    LevelsPanel(Pen pen) {
        for (PLevel.Type levelType : PLevel.Type.VALUES) {
            this.levelTypeToDisplay.put(levelType, PLevel.Type.TILT_TYPES.contains((Object)levelType) || PLevel.Type.ROTATION.equals((Object)levelType) ? new AngleDisplay(levelType) : new Display(levelType));
        }
        this.panel = Box.createVerticalBox();
        for (PLevel.Type levelType : PLevel.Type.VALUES) {
            this.panel.add(Utils.labelComponent(levelType.toString(), this.levelTypeToDisplay.get((Object)((Object)levelType)).component));
        }
        pen.addListener(new PenAdapter(){
            private Pen pen;

            public void penLevelEvent(PLevelEvent ev) {
                this.pen = ev.pen;
                for (PLevel level : ev.levels) {
                    Display display = LevelsPanel.this.levelTypeToDisplay.get(level.getType());
                    if (display == null) continue;
                    display.setIsDirty(true);
                }
            }

            public void penTock(long availableMillis) {
                if (this.pen == null) {
                    return;
                }
                for (Display display : LevelsPanel.this.levelTypeToDisplay.values()) {
                    display.update(this.pen);
                }
                this.pen = null;
            }
        });
        for (PLevel.Type levelType : PLevel.Type.VALUES) {
            Display display = this.levelTypeToDisplay.get((Object)levelType);
            display.setValue(pen.getLevelValue(levelType));
        }
    }

    static class AngleDisplay
    extends Display {
        static NumberFormat FORMAT = new DecimalFormat("###0.0\u00ba");
        static float RAD_TO_DEG = 57.29578f;

        AngleDisplay(PLevel.Type levelType) {
            super(levelType);
        }

        String format(float value) {
            return FORMAT.format(value *= RAD_TO_DEG);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Display
    extends DataDisplay<JTextField> {
        static NumberFormat FORMAT = new DecimalFormat("###0.000");
        final PLevel.Type levelType;

        Display(PLevel.Type levelType) {
            super(new JTextField(6));
            this.levelType = levelType;
            ((JTextField)this.component).setHorizontalAlignment(4);
            ((JTextField)this.component).setEditable(false);
        }

        @Override
        void updateImp(Pen pen) {
            this.setValue(pen.getLevelValue(this.levelType));
        }

        public void setValue(float value) {
            ((JTextField)this.component).setText(this.format(value));
        }

        String format(float value) {
            return FORMAT.format(value);
        }
    }
}

