/*
 * Decompiled with CFR 0.152.
 */
package jpen.demo;

import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import jpen.PButton;
import jpen.PButtonEvent;
import jpen.Pen;
import jpen.demo.DataDisplay;
import jpen.demo.Utils;
import jpen.event.PenAdapter;

final class ButtonsPanel2 {
    Display display = new Display();
    final JComponent panel = Box.createVerticalBox();

    ButtonsPanel2(Pen pen) {
        JScrollPane scrollPane = new JScrollPane(this.display.component);
        scrollPane.setHorizontalScrollBarPolicy(31);
        this.panel.add(Utils.alignTopLeft(scrollPane));
        pen.addListener(new PenAdapter(){
            Pen pen;

            public void penButtonEvent(PButtonEvent ev) {
                this.pen = ev.pen;
                ButtonsPanel2.this.display.setIsDirty(true);
            }

            public void penTock(long availableMillis) {
                if (this.pen == null) {
                    return;
                }
                ButtonsPanel2.this.display.update(this.pen);
                this.pen = null;
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Display
    extends DataDisplay<JList> {
        final DefaultListModel listModel;

        Display() {
            super(new JList());
            this.listModel = new DefaultListModel();
            ((JList)this.component).setModel(this.listModel);
            this.setupSize();
        }

        private void setupSize() {
            for (PButton.Type buttonType : PButton.Type.VALUES) {
                this.listModel.addElement(buttonType);
            }
            ((JList)this.component).setFixedCellWidth(((JList)this.component).getPreferredSize().width + 5);
            ((JList)this.component).setVisibleRowCount(5);
            this.listModel.clear();
        }

        @Override
        void updateImp(Pen pen) {
            this.listModel.clear();
            for (PButton.Type buttonType : PButton.Type.VALUES) {
                if (!pen.getButtonValue(buttonType)) continue;
                this.listModel.addElement(buttonType);
            }
        }
    }
}

