/*
 * Decompiled with CFR 0.152.
 */
package jpen;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Set;
import jpen.PLevel;
import jpen.PenDevice;
import jpen.PenEvent;
import jpen.PenState;
import jpen.event.PenListener;
import jpen.internal.AccessibleField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PLevelEvent
extends PenEvent
implements Serializable {
    public static final long serialVersionUID = 2L;
    public final PLevel[] levels;
    private static final AccessibleField levelsField = new AccessibleField(PLevelEvent.class, "levels");

    public PLevelEvent(PenDevice device, long deviceTime, PLevel[] levels) {
        super(device, deviceTime);
        this.levels = levels;
    }

    @Override
    void copyTo(PenState penState) {
        penState.levels.setValues(this);
    }

    @Override
    void dispatch() {
        for (PenListener l : this.pen.getListenersArray()) {
            l.penLevelEvent(this);
        }
    }

    public boolean containsLevelOfType(Set<PLevel.Type> levelTypes) {
        int i = this.levels.length;
        while (--i >= 0) {
            if (!levelTypes.contains(this.levels[i].getType())) continue;
            return true;
        }
        return false;
    }

    public boolean isMovement() {
        return this.containsLevelOfType(PLevel.Type.MOVEMENT_TYPES);
    }

    @Override
    public String toString() {
        return "[PLevelEvent: super=" + super.toString() + ", levels=" + Arrays.asList(this.levels) + "]";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            ObjectInputStream.GetField fields = in.readFields();
            levelsField.getField().set(this, fields.get("levels", null));
            ObjectStreamClass objectStreamClass = fields.getObjectStreamClass();
            if (objectStreamClass.getField("deviceId") != null) {
                PenEvent.deviceIdField.getField().set(this, fields.get("deviceId", (byte)0));
            }
            if (objectStreamClass.getField("deviceTime") != null) {
                PenEvent.deviceTimeField.getField().set(this, fields.get("deviceTime", 0L));
            }
        }
        catch (IllegalAccessException ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

