/*
 * Decompiled with CFR 0.152.
 */
package processing.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.Socket;
import processing.core.PApplet;

public class Client
implements Runnable {
    PApplet parent;
    Method clientEventMethod;
    Method disconnectEventMethod;
    Thread thread;
    Socket socket;
    String ip;
    int port;
    String host;
    public InputStream input;
    public OutputStream output;
    byte[] buffer = new byte[32768];
    int bufferIndex;
    int bufferLast;

    public Client(PApplet parent, String host, int port) {
        this.parent = parent;
        this.host = host;
        this.port = port;
        try {
            this.socket = new Socket(this.host, this.port);
            this.input = this.socket.getInputStream();
            this.output = this.socket.getOutputStream();
            this.thread = new Thread(this);
            this.thread.start();
            parent.registerMethod("dispose", (Object)this);
            try {
                this.clientEventMethod = parent.getClass().getMethod("clientEvent", Client.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.disconnectEventMethod = parent.getClass().getMethod("disconnectEvent", Client.class);
            }
            catch (Exception exception) {}
        }
        catch (ConnectException ce) {
            ce.printStackTrace();
            this.dispose();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.dispose();
        }
    }

    public Client(PApplet parent, Socket socket) throws IOException {
        this.socket = socket;
        this.input = socket.getInputStream();
        this.output = socket.getOutputStream();
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void stop() {
        if (this.disconnectEventMethod != null) {
            try {
                this.disconnectEventMethod.invoke((Object)this.parent, this);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.disconnectEventMethod = null;
            }
        }
        this.dispose();
    }

    public void dispose() {
        this.thread = null;
        try {
            if (this.input != null) {
                this.input.close();
                this.input = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.output != null) {
                this.output.close();
                this.output = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean active() {
        return this.thread != null;
    }

    public String ip() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public int available() {
        return this.bufferLast - this.bufferIndex;
    }

    public void clear() {
        this.bufferLast = 0;
        this.bufferIndex = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() {
        if (this.bufferIndex == this.bufferLast) {
            return -1;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int outgoing = this.buffer[this.bufferIndex++] & 0xFF;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return outgoing;
        }
    }

    public char readChar() {
        if (this.bufferIndex == this.bufferLast) {
            return '\uffff';
        }
        return (char)this.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes() {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int length = this.bufferLast - this.bufferIndex;
            byte[] outgoing = new byte[length];
            System.arraycopy(this.buffer, this.bufferIndex, outgoing, 0, length);
            this.bufferIndex = 0;
            this.bufferLast = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return outgoing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytes(byte[] bytebuffer) {
        if (this.bufferIndex == this.bufferLast) {
            return 0;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int length = this.bufferLast - this.bufferIndex;
            if (length > bytebuffer.length) {
                length = bytebuffer.length;
            }
            System.arraycopy(this.buffer, this.bufferIndex, bytebuffer, 0, length);
            this.bufferIndex += length;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytesUntil(int interesting) {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        byte what = (byte)interesting;
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int found;
            block8: {
                found = -1;
                int k = this.bufferIndex;
                while (k < this.bufferLast) {
                    if (this.buffer[k] == what) {
                        found = k;
                        break;
                    }
                    ++k;
                }
                if (found != -1) break block8;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return null;
            }
            int length = found - this.bufferIndex + 1;
            byte[] outgoing = new byte[length];
            System.arraycopy(this.buffer, this.bufferIndex, outgoing, 0, length);
            this.bufferIndex += length;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return outgoing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytesUntil(int interesting, byte[] byteBuffer) {
        if (this.bufferIndex == this.bufferLast) {
            return 0;
        }
        byte what = (byte)interesting;
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int length;
            block10: {
                int found;
                block9: {
                    found = -1;
                    int k = this.bufferIndex;
                    while (k < this.bufferLast) {
                        if (this.buffer[k] == what) {
                            found = k;
                            break;
                        }
                        ++k;
                    }
                    if (found != -1) break block9;
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return 0;
                }
                length = found - this.bufferIndex + 1;
                if (length <= byteBuffer.length) break block10;
                System.err.println("readBytesUntil() byte buffer is too small for the " + length + " bytes up to and including char " + interesting);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return -1;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byteBuffer, 0, length);
            this.bufferIndex += length;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return length;
        }
    }

    public String readString() {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        return new String(this.readBytes());
    }

    public String readStringUntil(int interesting) {
        byte[] b = this.readBytesUntil(interesting);
        if (b == null) {
            return null;
        }
        return new String(b);
    }

    public void write(int data) {
        try {
            this.output.write(data & 0xFF);
            this.output.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.stop();
        }
    }

    public void write(byte[] data) {
        try {
            this.output.write(data);
            this.output.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.stop();
        }
    }

    public void write(String data) {
        this.write(data.getBytes());
    }
}

