/*
 * Decompiled with CFR 0.152.
 */
package sprites.maths;

import java.io.Serializable;
import sprites.maths.FastMath;

public class Vector2D
implements Serializable {
    public static final Vector2D ZERO = new Vector2D(0.0, 0.0);
    public static final Vector2D ONE = new Vector2D(1.0, 1.0);
    public static final Vector2D PLUS_I = new Vector2D(1.0, 0.0);
    public static final Vector2D MINUS_I = new Vector2D(-1.0, 0.0);
    public static final Vector2D PLUS_J = new Vector2D(0.0, 1.0);
    public static final Vector2D MINUS_J = new Vector2D(0.0, -1.0);
    public static final Vector2D NaN = new Vector2D(Double.NaN, Double.NaN);
    public static final Vector2D POSITIVE_INFINITY = new Vector2D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    public static final Vector2D NEGATIVE_INFINITY = new Vector2D(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    public static final int CLOCKWISE = 1;
    public static final int ANTI_CLOCKWISE = -1;
    public double x;
    public double y;

    public Vector2D() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public Vector2D(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Vector2D(Vector2D vector2D) {
        this.x = vector2D.x;
        this.y = vector2D.y;
    }

    public void set(Vector2D vector2D) {
        this.x = vector2D.x;
        this.y = vector2D.y;
    }

    public void set(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public double lengthSq() {
        return this.x * this.x + this.y * this.y;
    }

    public double length() {
        return FastMath.sqrt(this.x * this.x + this.y * this.y);
    }

    public double dot(Vector2D vector2D) {
        return this.x * vector2D.x + this.y * vector2D.y;
    }

    public double dotNorm(Vector2D vector2D) {
        double d = FastMath.sqrt(this.x * this.x + this.y * this.y) * FastMath.sqrt(vector2D.x * vector2D.x + vector2D.y * vector2D.y);
        return (this.x * vector2D.x + this.y * vector2D.y) / d;
    }

    public double angleBetween(Vector2D vector2D) {
        double d = FastMath.sqrt(this.x * this.x + this.y * this.y) * FastMath.sqrt(vector2D.x * vector2D.x + vector2D.y * vector2D.y);
        if (d > Double.MIN_VALUE) {
            double d2 = FastMath.acos((this.x * vector2D.x + this.y * vector2D.y) / d);
            if (d2 != d2) {
                return 0.0;
            }
            return d2;
        }
        return 0.0;
    }

    public int sign(Vector2D vector2D) {
        if (this.y * vector2D.x > this.x * vector2D.y) {
            return 1;
        }
        return -1;
    }

    public Vector2D getPerp() {
        return new Vector2D(-this.y, this.x);
    }

    public double distanceSq(Vector2D vector2D) {
        double d = vector2D.x - this.x;
        double d2 = vector2D.y - this.y;
        return d * d + d2 * d2;
    }

    public double distance(Vector2D vector2D) {
        double d = vector2D.x - this.x;
        double d2 = vector2D.y - this.y;
        return FastMath.sqrt(d * d + d2 * d2);
    }

    public void normalize() {
        double d = FastMath.sqrt(this.x * this.x + this.y * this.y);
        if (d < Double.MIN_VALUE) {
            this.y = 0.0;
            this.x = 0.0;
        } else {
            this.x /= d;
            this.y /= d;
        }
    }

    public void truncate(double d) {
        double d2 = FastMath.sqrt(this.x * this.x + this.y * this.y);
        if (d2 > Double.MIN_VALUE && d2 > d) {
            double d3 = d / d2;
            this.x *= d3;
            this.y *= d3;
        }
    }

    public Vector2D getReverse() {
        return new Vector2D(-this.x, -this.y);
    }

    public Vector2D getReflect(Vector2D vector2D) {
        double d = this.dot(vector2D);
        double d2 = this.x + -2.0 * d * vector2D.x;
        double d3 = this.y + -2.0 * d * vector2D.y;
        return new Vector2D(d2, d3);
    }

    public void add(Vector2D vector2D) {
        this.x += vector2D.x;
        this.y += vector2D.y;
    }

    public void add(double d, double d2) {
        this.x += d;
        this.y += d2;
    }

    public void sub(Vector2D vector2D) {
        this.x -= vector2D.x;
        this.y -= vector2D.y;
    }

    public void mult(double d) {
        this.x *= d;
        this.y *= d;
    }

    public void div(double d) {
        this.x /= d;
        this.y /= d;
    }

    public static Vector2D add(Vector2D vector2D, Vector2D vector2D2) {
        return new Vector2D(vector2D.x + vector2D2.x, vector2D.y + vector2D2.y);
    }

    public static Vector2D sub(Vector2D vector2D, Vector2D vector2D2) {
        return new Vector2D(vector2D.x - vector2D2.x, vector2D.y - vector2D2.y);
    }

    public static Vector2D mult(Vector2D vector2D, double d) {
        return new Vector2D(vector2D.x * d, vector2D.y * d);
    }

    public static Vector2D div(Vector2D vector2D, double d) {
        return new Vector2D(vector2D.x / d, vector2D.y / d);
    }

    public static double distSq(Vector2D vector2D, Vector2D vector2D2) {
        double d = vector2D2.x - vector2D.x;
        double d2 = vector2D2.y - vector2D.y;
        return d * d + d2 * d2;
    }

    public static double dist(Vector2D vector2D, Vector2D vector2D2) {
        double d = vector2D2.x - vector2D.x;
        double d2 = vector2D2.y - vector2D.y;
        return FastMath.sqrt(d * d + d2 * d2);
    }

    public static double dot(Vector2D vector2D, Vector2D vector2D2) {
        return vector2D.x * vector2D2.x + vector2D.y * vector2D2.y;
    }

    public static Vector2D normalize(Vector2D vector2D) {
        double d = vector2D.length();
        Vector2D vector2D2 = d < Double.MIN_VALUE ? new Vector2D() : new Vector2D(vector2D.x / d, vector2D.y / d);
        return vector2D2;
    }

    public static double angleBetween(Vector2D vector2D, Vector2D vector2D2) {
        double d = FastMath.sqrt(vector2D.x * vector2D.x + vector2D.y * vector2D.y) * FastMath.sqrt(vector2D2.x * vector2D2.x + vector2D2.y * vector2D2.y);
        if (d > Double.MIN_VALUE) {
            double d2 = FastMath.acos((vector2D.x * vector2D2.x + vector2D.y * vector2D2.y) / d);
            if (d2 != d2) {
                return 0.0;
            }
            return d2;
        }
        return 0.0;
    }

    public static boolean isSecondInFOVofFirst(Vector2D vector2D, Vector2D vector2D2, Vector2D vector2D3, double d) {
        Vector2D vector2D4 = Vector2D.sub(vector2D3, vector2D);
        double d2 = vector2D4.length() * vector2D2.length();
        double d3 = vector2D2.dot(vector2D4) / d2;
        return d3 >= FastMath.cos(d / 2.0);
    }

    public double[] toArray() {
        return new double[]{this.x, this.y};
    }

    public String toString() {
        return "[ " + this.x + ", " + this.y + " ]";
    }
}

