/*
 * Decompiled with CFR 0.152.
 */
package sprites.maths;

public class FastMath {
    public static final double PI = Math.PI;
    public static final double E = Math.E;
    private static final double[] EXP_INT_TABLE_A;
    private static final double[] EXP_INT_TABLE_B;
    private static final double[] EXP_FRAC_TABLE_A;
    private static final double[] EXP_FRAC_TABLE_B;
    private static final double[] FACT;
    private static final double[][] LN_MANT;
    private static final double LN_2_A = 0.6931470632553101;
    private static final double LN_2_B = 1.1730463525082348E-7;
    private static final double[][] LN_SPLIT_COEF;
    private static final double[][] LN_QUICK_COEF;
    private static final double[][] LN_HI_PREC_COEF;
    private static final double[] SINE_TABLE_A;
    private static final double[] SINE_TABLE_B;
    private static final double[] COSINE_TABLE_A;
    private static final double[] COSINE_TABLE_B;
    private static final double[] TANGENT_TABLE_A;
    private static final double[] TANGENT_TABLE_B;
    private static final long[] RECIP_2PI;
    private static final long[] PI_O_4_BITS;
    private static final double[] EIGHTHS;
    private static final double[] CBRTTWO;
    private static final long HEX_40000000 = 0x40000000L;
    private static final long MASK_30BITS = -1073741824L;
    private static final double TWO_POWER_52 = 4.503599627370496E15;
    public static final double SAFE_MIN = Double.MIN_NORMAL;

    private FastMath() {
    }

    private static double doubleHighPart(double d) {
        if (d > -2.2250738585072014E-308 && d < Double.MIN_NORMAL) {
            return d;
        }
        long l = Double.doubleToLongBits(d);
        return Double.longBitsToDouble(l &= 0xFFFFFFFFC0000000L);
    }

    public static double sqrt(double d) {
        return Math.sqrt(d);
    }

    public static double cosh(double d) {
        if (d != d) {
            return d;
        }
        if (d > 20.0) {
            return FastMath.exp(d) / 2.0;
        }
        if (d < -20.0) {
            return FastMath.exp(-d) / 2.0;
        }
        double[] dArray = new double[2];
        if (d < 0.0) {
            d = -d;
        }
        FastMath.exp(d, 0.0, dArray);
        double d2 = dArray[0] + dArray[1];
        double d3 = -(d2 - dArray[0] - dArray[1]);
        double d4 = d2 * 1.073741824E9;
        double d5 = d2 + d4 - d4;
        double d6 = d2 - d5;
        double d7 = 1.0 / d2;
        d4 = d7 * 1.073741824E9;
        double d8 = d7 + d4 - d4;
        double d9 = d7 - d8;
        d9 += (1.0 - d5 * d8 - d5 * d9 - d6 * d8 - d6 * d9) * d7;
        d9 += -d3 * d7 * d7;
        d4 = d2 + d8;
        d3 += -(d4 - d2 - d8);
        d2 = d4;
        d4 = d2 + d9;
        d3 += -(d4 - d2 - d9);
        d2 = d4;
        double d10 = d2 + d3;
        return d10 *= 0.5;
    }

    public static double sinh(double d) {
        double d2;
        boolean bl = false;
        if (d != d) {
            return d;
        }
        if (d > 20.0) {
            return FastMath.exp(d) / 2.0;
        }
        if (d < -20.0) {
            return -FastMath.exp(-d) / 2.0;
        }
        if (d == 0.0) {
            return d;
        }
        if (d < 0.0) {
            d = -d;
            bl = true;
        }
        if (d > 0.25) {
            double[] dArray = new double[2];
            FastMath.exp(d, 0.0, dArray);
            double d3 = dArray[0] + dArray[1];
            double d4 = -(d3 - dArray[0] - dArray[1]);
            double d5 = d3 * 1.073741824E9;
            double d6 = d3 + d5 - d5;
            double d7 = d3 - d6;
            double d8 = 1.0 / d3;
            d5 = d8 * 1.073741824E9;
            double d9 = d8 + d5 - d5;
            double d10 = d8 - d9;
            d10 += (1.0 - d6 * d9 - d6 * d10 - d7 * d9 - d7 * d10) * d8;
            d10 += -d4 * d8 * d8;
            d9 = -d9;
            d10 = -d10;
            d5 = d3 + d9;
            d4 += -(d5 - d3 - d9);
            d3 = d5;
            d5 = d3 + d10;
            d4 += -(d5 - d3 - d10);
            d3 = d5;
            d2 = d3 + d4;
            d2 *= 0.5;
        } else {
            double[] dArray = new double[2];
            FastMath.expm1(d, dArray);
            double d11 = dArray[0] + dArray[1];
            double d12 = -(d11 - dArray[0] - dArray[1]);
            double d13 = 1.0 + d11;
            double d14 = 1.0 / d13;
            double d15 = -(d13 - 1.0 - d11) + d12;
            double d16 = d11 * d14;
            double d17 = d16 * 1.073741824E9;
            double d18 = d16 + d17 - d17;
            double d19 = d16 - d18;
            d17 = d13 * 1.073741824E9;
            double d20 = d13 + d17 - d17;
            double d21 = d13 - d20;
            d19 += (d11 - d20 * d18 - d20 * d19 - d21 * d18 - d21 * d19) * d14;
            d19 += d12 * d14;
            d19 += -d11 * d15 * d14 * d14;
            d17 = d11 + d18;
            d12 += -(d17 - d11 - d18);
            d11 = d17;
            d17 = d11 + d19;
            d12 += -(d17 - d11 - d19);
            d11 = d17;
            d2 = d11 + d12;
            d2 *= 0.5;
        }
        if (bl) {
            d2 = -d2;
        }
        return d2;
    }

    public static double tanh(double d) {
        double d2;
        boolean bl = false;
        if (d != d) {
            return d;
        }
        if (d > 20.0) {
            return 1.0;
        }
        if (d < -20.0) {
            return -1.0;
        }
        if (d == 0.0) {
            return d;
        }
        if (d < 0.0) {
            d = -d;
            bl = true;
        }
        if (d >= 0.5) {
            double[] dArray = new double[2];
            FastMath.exp(d * 2.0, 0.0, dArray);
            double d3 = dArray[0] + dArray[1];
            double d4 = -(d3 - dArray[0] - dArray[1]);
            double d5 = -1.0 + d3;
            double d6 = -(d5 + 1.0 - d3);
            double d7 = d5 + d4;
            d6 += -(d7 - d5 - d4);
            d5 = d7;
            double d8 = 1.0 + d3;
            double d9 = -(d8 - 1.0 - d3);
            d7 = d8 + d4;
            d9 += -(d7 - d8 - d4);
            d8 = d7;
            d7 = d8 * 1.073741824E9;
            double d10 = d8 + d7 - d7;
            double d11 = d8 - d10;
            double d12 = d5 / d8;
            d7 = d12 * 1.073741824E9;
            double d13 = d12 + d7 - d7;
            double d14 = d12 - d13;
            d14 += (d5 - d10 * d13 - d10 * d14 - d11 * d13 - d11 * d14) / d8;
            d14 += d6 / d8;
            d2 = d13 + (d14 += -d9 * d5 / d8 / d8);
        } else {
            double[] dArray = new double[2];
            FastMath.expm1(d * 2.0, dArray);
            double d15 = dArray[0] + dArray[1];
            double d16 = -(d15 - dArray[0] - dArray[1]);
            double d17 = d15;
            double d18 = d16;
            double d19 = 2.0 + d15;
            double d20 = -(d19 - 2.0 - d15);
            double d21 = d19 + d16;
            d20 += -(d21 - d19 - d16);
            d19 = d21;
            d21 = d19 * 1.073741824E9;
            double d22 = d19 + d21 - d21;
            double d23 = d19 - d22;
            double d24 = d17 / d19;
            d21 = d24 * 1.073741824E9;
            double d25 = d24 + d21 - d21;
            double d26 = d24 - d25;
            d26 += (d17 - d22 * d25 - d22 * d26 - d23 * d25 - d23 * d26) / d19;
            d26 += d18 / d19;
            d2 = d25 + (d26 += -d20 * d17 / d19 / d19);
        }
        if (bl) {
            d2 = -d2;
        }
        return d2;
    }

    public static double acosh(double d) {
        return FastMath.log(d + FastMath.sqrt(d * d - 1.0));
    }

    public static double asinh(double d) {
        double d2;
        boolean bl = false;
        if (d < 0.0) {
            bl = true;
            d = -d;
        }
        if (d > 0.167) {
            d2 = FastMath.log(FastMath.sqrt(d * d + 1.0) + d);
        } else {
            double d3 = d * d;
            d2 = d > 0.097 ? d * (1.0 - d3 * (0.3333333333333333 - d3 * (0.2 - d3 * (0.14285714285714285 - d3 * (0.1111111111111111 - d3 * (0.09090909090909091 - d3 * (0.07692307692307693 - d3 * (0.06666666666666667 - d3 * 0.058823529411764705 * 15.0 / 16.0) * 13.0 / 14.0) * 11.0 / 12.0) * 9.0 / 10.0) * 7.0 / 8.0) * 5.0 / 6.0) * 3.0 / 4.0) / 2.0) : (d > 0.036 ? d * (1.0 - d3 * (0.3333333333333333 - d3 * (0.2 - d3 * (0.14285714285714285 - d3 * (0.1111111111111111 - d3 * (0.09090909090909091 - d3 * 0.07692307692307693 * 11.0 / 12.0) * 9.0 / 10.0) * 7.0 / 8.0) * 5.0 / 6.0) * 3.0 / 4.0) / 2.0) : (d > 0.0036 ? d * (1.0 - d3 * (0.3333333333333333 - d3 * (0.2 - d3 * (0.14285714285714285 - d3 * 0.1111111111111111 * 7.0 / 8.0) * 5.0 / 6.0) * 3.0 / 4.0) / 2.0) : d * (1.0 - d3 * (0.3333333333333333 - d3 * 0.2 * 3.0 / 4.0) / 2.0)));
        }
        return bl ? -d2 : d2;
    }

    public static double atanh(double d) {
        double d2;
        boolean bl = false;
        if (d < 0.0) {
            bl = true;
            d = -d;
        }
        if (d > 0.15) {
            d2 = 0.5 * FastMath.log((1.0 + d) / (1.0 - d));
        } else {
            double d3 = d * d;
            d2 = d > 0.087 ? d * (1.0 + d3 * (0.3333333333333333 + d3 * (0.2 + d3 * (0.14285714285714285 + d3 * (0.1111111111111111 + d3 * (0.09090909090909091 + d3 * (0.07692307692307693 + d3 * (0.06666666666666667 + d3 * 0.058823529411764705)))))))) : (d > 0.031 ? d * (1.0 + d3 * (0.3333333333333333 + d3 * (0.2 + d3 * (0.14285714285714285 + d3 * (0.1111111111111111 + d3 * (0.09090909090909091 + d3 * 0.07692307692307693)))))) : (d > 0.003 ? d * (1.0 + d3 * (0.3333333333333333 + d3 * (0.2 + d3 * (0.14285714285714285 + d3 * 0.1111111111111111)))) : d * (1.0 + d3 * (0.3333333333333333 + d3 * 0.2))));
        }
        return bl ? -d2 : d2;
    }

    public static double signum(double d) {
        return d < 0.0 ? -1.0 : (d > 0.0 ? 1.0 : d);
    }

    public static float signum(float f) {
        return f < 0.0f ? -1.0f : (f > 0.0f ? 1.0f : f);
    }

    public static double nextUp(double d) {
        return FastMath.nextAfter(d, Double.POSITIVE_INFINITY);
    }

    public static float nextUp(float f) {
        return FastMath.nextAfter(f, Double.POSITIVE_INFINITY);
    }

    public static double random() {
        return Math.random();
    }

    public static double exp(double d) {
        return FastMath.exp(d, 0.0, null);
    }

    private static double exp(double d, double d2, double[] dArray) {
        double d3;
        double d4;
        int n;
        if (d < 0.0) {
            n = (int)(-d);
            if (n > 746) {
                if (dArray != null) {
                    dArray[0] = 0.0;
                    dArray[1] = 0.0;
                }
                return 0.0;
            }
            if (n > 709) {
                double d5 = FastMath.exp(d + 40.19140625, d2, dArray) / 2.8504009514401178E17;
                if (dArray != null) {
                    dArray[0] = dArray[0] / 2.8504009514401178E17;
                    dArray[1] = dArray[1] / 2.8504009514401178E17;
                }
                return d5;
            }
            if (n == 709) {
                double d6 = FastMath.exp(d + 1.494140625, d2, dArray) / 4.455505956692757;
                if (dArray != null) {
                    dArray[0] = dArray[0] / 4.455505956692757;
                    dArray[1] = dArray[1] / 4.455505956692757;
                }
                return d6;
            }
            d4 = EXP_INT_TABLE_A[750 - ++n];
            d3 = EXP_INT_TABLE_B[750 - n];
            n = -n;
        } else {
            n = (int)d;
            if (n > 709) {
                if (dArray != null) {
                    dArray[0] = Double.POSITIVE_INFINITY;
                    dArray[1] = 0.0;
                }
                return Double.POSITIVE_INFINITY;
            }
            d4 = EXP_INT_TABLE_A[750 + n];
            d3 = EXP_INT_TABLE_B[750 + n];
        }
        int n2 = (int)((d - (double)n) * 1024.0);
        double d7 = EXP_FRAC_TABLE_A[n2];
        double d8 = EXP_FRAC_TABLE_B[n2];
        double d9 = d - ((double)n + (double)n2 / 1024.0);
        double d10 = 0.04168701738764507;
        d10 = d10 * d9 + 0.1666666505023083;
        d10 = d10 * d9 + 0.5000000000042687;
        d10 = d10 * d9 + 1.0;
        d10 = d10 * d9 + -3.940510424527919E-20;
        double d11 = d4 * d7;
        double d12 = d4 * d8 + d3 * d7 + d3 * d8;
        double d13 = d12 + d11;
        double d14 = d2 != 0.0 ? d13 * d2 * d10 + d13 * d2 + d13 * d10 + d12 + d11 : d13 * d10 + d12 + d11;
        if (dArray != null) {
            dArray[0] = d11;
            dArray[1] = d13 * d2 * d10 + d13 * d2 + d13 * d10 + d12;
        }
        return d14;
    }

    public static double expm1(double d) {
        return FastMath.expm1(d, null);
    }

    private static double expm1(double d, double[] dArray) {
        if (d != d || d == 0.0) {
            return d;
        }
        if (d <= -1.0 || d >= 1.0) {
            double[] dArray2 = new double[2];
            FastMath.exp(d, 0.0, dArray2);
            if (d > 0.0) {
                return -1.0 + dArray2[0] + dArray2[1];
            }
            double d2 = -1.0 + dArray2[0];
            double d3 = -(d2 + 1.0 - dArray2[0]);
            return d2 + (d3 += dArray2[1]);
        }
        boolean bl = false;
        if (d < 0.0) {
            d = -d;
            bl = true;
        }
        int n = (int)(d * 1024.0);
        double d4 = EXP_FRAC_TABLE_A[n] - 1.0;
        double d5 = EXP_FRAC_TABLE_B[n];
        double d6 = d4 + d5;
        d5 = -(d6 - d4 - d5);
        d4 = d6;
        d6 = d4 * 1.073741824E9;
        double d7 = d4 + d6 - d6;
        double d8 = d5 + (d4 - d7);
        double d9 = d - (double)n / 1024.0;
        double d10 = 0.008336750013465571;
        d10 = d10 * d9 + 0.041666663879186654;
        d10 = d10 * d9 + 0.16666666666745392;
        d10 = d10 * d9 + 0.49999999999999994;
        d10 *= d9;
        double d11 = d9;
        double d12 = d11 + (d10 *= d9);
        d10 = -(d12 - d11 - d10);
        d11 = d12;
        d12 = d11 * 1.073741824E9;
        d12 = d11 + d12 - d12;
        d10 += d11 - d12;
        d11 = d12;
        double d13 = d11 * d7;
        d12 = d13 + d11 * d8;
        double d14 = -(d12 - d13 - d11 * d8);
        d13 = d12;
        d12 = d13 + d10 * d7;
        d14 += -(d12 - d13 - d10 * d7);
        d13 = d12;
        d12 = d13 + d10 * d8;
        d14 += -(d12 - d13 - d10 * d8);
        d13 = d12;
        d12 = d13 + d7;
        d14 += -(d12 - d7 - d13);
        d13 = d12;
        d12 = d13 + d11;
        d14 += -(d12 - d13 - d11);
        d13 = d12;
        d12 = d13 + d8;
        d14 += -(d12 - d13 - d8);
        d13 = d12;
        d12 = d13 + d10;
        d14 += -(d12 - d13 - d10);
        d13 = d12;
        if (bl) {
            double d15 = 1.0 + d13;
            double d16 = 1.0 / d15;
            double d17 = -(d15 - 1.0 - d13) + d14;
            double d18 = d13 * d16;
            d12 = d18 * 1.073741824E9;
            double d19 = d18 + d12 - d12;
            double d20 = d18 - d19;
            d12 = d15 * 1.073741824E9;
            d11 = d15 + d12 - d12;
            d10 = d15 - d11;
            d20 += (d13 - d11 * d19 - d11 * d20 - d10 * d19 - d10 * d20) * d16;
            d20 += d14 * d16;
            d20 += -d13 * d17 * d16 * d16;
            d13 = -d19;
            d14 = -d20;
        }
        if (dArray != null) {
            dArray[0] = d13;
            dArray[1] = d14;
        }
        return d13 + d14;
    }

    private static double slowexp(double d, double[] dArray) {
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        double[] dArray5 = new double[2];
        FastMath.split(d, dArray2);
        dArray3[1] = 0.0;
        dArray3[0] = 0.0;
        for (int i = 19; i >= 0; --i) {
            FastMath.splitMult(dArray2, dArray3, dArray5);
            dArray3[0] = dArray5[0];
            dArray3[1] = dArray5[1];
            FastMath.split(FACT[i], dArray5);
            FastMath.splitReciprocal(dArray5, dArray4);
            FastMath.splitAdd(dArray3, dArray4, dArray5);
            dArray3[0] = dArray5[0];
            dArray3[1] = dArray5[1];
        }
        if (dArray != null) {
            dArray[0] = dArray3[0];
            dArray[1] = dArray3[1];
        }
        return dArray3[0] + dArray3[1];
    }

    private static void split(double d, double[] dArray) {
        if (d < 8.0E298 && d > -8.0E298) {
            double d2 = d * 1.073741824E9;
            dArray[0] = d + d2 - d2;
            dArray[1] = d - dArray[0];
        } else {
            double d3 = d * 9.313225746154785E-10;
            dArray[0] = (d + d3 - d) * 1.073741824E9;
            dArray[1] = d - dArray[0];
        }
    }

    private static void resplit(double[] dArray) {
        double d = dArray[0] + dArray[1];
        double d2 = -(d - dArray[0] - dArray[1]);
        if (d < 8.0E298 && d > -8.0E298) {
            double d3 = d * 1.073741824E9;
            dArray[0] = d + d3 - d3;
            dArray[1] = d - dArray[0] + d2;
        } else {
            double d4 = d * 9.313225746154785E-10;
            dArray[0] = (d + d4 - d) * 1.073741824E9;
            dArray[1] = d - dArray[0] + d2;
        }
    }

    private static void splitMult(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray3[0] = dArray[0] * dArray2[0];
        dArray3[1] = dArray[0] * dArray2[1] + dArray[1] * dArray2[0] + dArray[1] * dArray2[1];
        FastMath.resplit(dArray3);
    }

    private static void splitAdd(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray3[0] = dArray[0] + dArray2[0];
        dArray3[1] = dArray[1] + dArray2[1];
        FastMath.resplit(dArray3);
    }

    private static void splitReciprocal(double[] dArray, double[] dArray2) {
        if (dArray[0] == 0.0) {
            dArray[0] = dArray[1];
            dArray[1] = 0.0;
        }
        dArray2[0] = 0.9999997615814209 / dArray[0];
        dArray2[1] = (2.384185791015625E-7 * dArray[0] - 0.9999997615814209 * dArray[1]) / (dArray[0] * dArray[0] + dArray[0] * dArray[1]);
        if (dArray2[1] != dArray2[1]) {
            dArray2[1] = 0.0;
        }
        FastMath.resplit(dArray2);
        for (int i = 0; i < 2; ++i) {
            double d = 1.0 - dArray2[0] * dArray[0] - dArray2[0] * dArray[1] - dArray2[1] * dArray[0] - dArray2[1] * dArray[1];
            dArray2[1] = dArray2[1] + (d *= dArray2[0] + dArray2[1]);
        }
    }

    private static void quadMult(double[] dArray, double[] dArray2, double[] dArray3) {
        double[] dArray4 = new double[2];
        double[] dArray5 = new double[2];
        double[] dArray6 = new double[2];
        FastMath.split(dArray[0], dArray4);
        FastMath.split(dArray2[0], dArray5);
        FastMath.splitMult(dArray4, dArray5, dArray6);
        dArray3[0] = dArray6[0];
        dArray3[1] = dArray6[1];
        FastMath.split(dArray2[1], dArray5);
        FastMath.splitMult(dArray4, dArray5, dArray6);
        double d = dArray3[0] + dArray6[0];
        dArray3[1] = dArray3[1] - (d - dArray3[0] - dArray6[0]);
        dArray3[0] = d;
        d = dArray3[0] + dArray6[1];
        dArray3[1] = dArray3[1] - (d - dArray3[0] - dArray6[1]);
        dArray3[0] = d;
        FastMath.split(dArray[1], dArray4);
        FastMath.split(dArray2[0], dArray5);
        FastMath.splitMult(dArray4, dArray5, dArray6);
        d = dArray3[0] + dArray6[0];
        dArray3[1] = dArray3[1] - (d - dArray3[0] - dArray6[0]);
        dArray3[0] = d;
        d = dArray3[0] + dArray6[1];
        dArray3[1] = dArray3[1] - (d - dArray3[0] - dArray6[1]);
        dArray3[0] = d;
        FastMath.split(dArray[1], dArray4);
        FastMath.split(dArray2[1], dArray5);
        FastMath.splitMult(dArray4, dArray5, dArray6);
        d = dArray3[0] + dArray6[0];
        dArray3[1] = dArray3[1] - (d - dArray3[0] - dArray6[0]);
        dArray3[0] = d;
        d = dArray3[0] + dArray6[1];
        dArray3[1] = dArray3[1] - (d - dArray3[0] - dArray6[1]);
        dArray3[0] = d;
    }

    private static double expint(int n, double[] dArray) {
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        dArray2[0] = Math.E;
        dArray2[1] = 1.4456468917292502E-16;
        FastMath.split(1.0, dArray4);
        while (n > 0) {
            if ((n & 1) != 0) {
                FastMath.quadMult(dArray4, dArray2, dArray3);
                dArray4[0] = dArray3[0];
                dArray4[1] = dArray3[1];
            }
            FastMath.quadMult(dArray2, dArray2, dArray3);
            dArray2[0] = dArray3[0];
            dArray2[1] = dArray3[1];
            n >>= 1;
        }
        if (dArray != null) {
            dArray[0] = dArray4[0];
            dArray[1] = dArray4[1];
            FastMath.resplit(dArray);
        }
        return dArray4[0] + dArray4[1];
    }

    public static double log(double d) {
        return FastMath.log(d, null);
    }

    private static double log(double d, double[] dArray) {
        double d2;
        double d3;
        double d4;
        double d5;
        if (d == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        long l = Double.doubleToLongBits(d);
        if (((l & Long.MIN_VALUE) != 0L || d != d) && d != 0.0) {
            if (dArray != null) {
                dArray[0] = Double.NaN;
            }
            return Double.NaN;
        }
        if (d == Double.POSITIVE_INFINITY) {
            if (dArray != null) {
                dArray[0] = Double.POSITIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        int n = (int)(l >> 52) - 1023;
        if ((l & 0x7FF0000000000000L) == 0L) {
            if (d == 0.0) {
                if (dArray != null) {
                    dArray[0] = Double.NEGATIVE_INFINITY;
                }
                return Double.NEGATIVE_INFINITY;
            }
            l <<= 1;
            while ((l & 0x10000000000000L) == 0L) {
                --n;
                l <<= 1;
            }
        }
        if ((n == -1 || n == 0) && d < 1.01 && d > 0.99 && dArray == null) {
            double d6 = d - 1.0;
            double d7 = d6 - d + 1.0;
            double d8 = d6 * 1.073741824E9;
            double d9 = d6 + d8 - d8;
            double d10 = d6 - d9;
            d6 = d9;
            d7 = d10;
            double d11 = LN_QUICK_COEF[LN_QUICK_COEF.length - 1][0];
            double d12 = LN_QUICK_COEF[LN_QUICK_COEF.length - 1][1];
            for (int i = LN_QUICK_COEF.length - 2; i >= 0; --i) {
                d9 = d11 * d6;
                d10 = d11 * d7 + d12 * d6 + d12 * d7;
                d8 = d9 * 1.073741824E9;
                d11 = d9 + d8 - d8;
                d12 = d9 - d11 + d10;
                d9 = d11 + LN_QUICK_COEF[i][0];
                d10 = d12 + LN_QUICK_COEF[i][1];
                d8 = d9 * 1.073741824E9;
                d11 = d9 + d8 - d8;
                d12 = d9 - d11 + d10;
            }
            d9 = d11 * d6;
            d10 = d11 * d7 + d12 * d6 + d12 * d7;
            d8 = d9 * 1.073741824E9;
            d11 = d9 + d8 - d8;
            d12 = d9 - d11 + d10;
            return d11 + d12;
        }
        double[] dArray2 = LN_MANT[(int)((l & 0xFFC0000000000L) >> 42)];
        double d13 = (double)(l & 0x3FFFFFFFFFFL) / (4.503599627370496E15 + (double)(l & 0xFFC0000000000L));
        double d14 = 0.0;
        double d15 = 0.0;
        if (dArray != null) {
            d5 = d13 * 1.073741824E9;
            d4 = d13 + d5 - d5;
            d3 = d13 - d4;
            d2 = d4;
            double d16 = d3;
            double d17 = l & 0x3FFFFFFFFFFL;
            double d18 = 4.503599627370496E15 + (double)(l & 0xFFC0000000000L);
            d4 = d17 - d2 * d18 - d16 * d18;
            d16 += d4 / d18;
            double d19 = LN_HI_PREC_COEF[LN_HI_PREC_COEF.length - 1][0];
            double d20 = LN_HI_PREC_COEF[LN_HI_PREC_COEF.length - 1][1];
            for (int i = LN_HI_PREC_COEF.length - 2; i >= 0; --i) {
                d4 = d19 * d2;
                d3 = d19 * d16 + d20 * d2 + d20 * d16;
                d5 = d4 * 1.073741824E9;
                d19 = d4 + d5 - d5;
                d20 = d4 - d19 + d3;
                d4 = d19 + LN_HI_PREC_COEF[i][0];
                d3 = d20 + LN_HI_PREC_COEF[i][1];
                d5 = d4 * 1.073741824E9;
                d19 = d4 + d5 - d5;
                d20 = d4 - d19 + d3;
            }
            d4 = d19 * d2;
            d3 = d19 * d16 + d20 * d2 + d20 * d16;
            d14 = d4 + d3;
            d15 = -(d14 - d4 - d3);
        } else {
            d14 = -0.16624882440418567;
            d14 = d14 * d13 + 0.19999954120254515;
            d14 = d14 * d13 + -0.2499999997677497;
            d14 = d14 * d13 + 0.3333333333332802;
            d14 = d14 * d13 + -0.5;
            d14 = d14 * d13 + 1.0;
            d14 *= d13;
        }
        d5 = 0.6931470632553101 * (double)n;
        d4 = 0.0;
        d3 = d5 + dArray2[0];
        d2 = -(d3 - d5 - dArray2[0]);
        d5 = d3;
        d4 += d2;
        d3 = d5 + d14;
        d2 = -(d3 - d5 - d14);
        d5 = d3;
        d4 += d2;
        d3 = d5 + 1.1730463525082348E-7 * (double)n;
        d2 = -(d3 - d5 - 1.1730463525082348E-7 * (double)n);
        d5 = d3;
        d4 += d2;
        d3 = d5 + dArray2[1];
        d2 = -(d3 - d5 - dArray2[1]);
        d5 = d3;
        d4 += d2;
        d3 = d5 + d15;
        d2 = -(d3 - d5 - d15);
        d5 = d3;
        d4 += d2;
        if (dArray != null) {
            dArray[0] = d5;
            dArray[1] = d4;
        }
        return d5 + d4;
    }

    public static double log1p(double d) {
        double d2 = 1.0 + d;
        double d3 = -(d2 - 1.0 - d);
        if (d == -1.0) {
            return d / 0.0;
        }
        if (d > 0.0 && 1.0 / d == 0.0) {
            return d;
        }
        if (d > 1.0E-6 || d < -1.0E-6) {
            double[] dArray = new double[2];
            double d4 = FastMath.log(d2, dArray);
            if (Double.isInfinite(d4)) {
                return d4;
            }
            double d5 = d3 / d2;
            double d6 = 0.5 * d5 + 1.0;
            return (d6 *= d5) + dArray[1] + dArray[0];
        }
        double d7 = d * 0.333333333333333 - 0.5;
        d7 = d7 * d + 1.0;
        return d7 *= d;
    }

    public static double log10(double d) {
        double[] dArray = new double[2];
        double d2 = FastMath.log(d, dArray);
        if (Double.isInfinite(d2)) {
            return d2;
        }
        double d3 = dArray[0] * 1.073741824E9;
        double d4 = dArray[0] + d3 - d3;
        double d5 = dArray[0] - d4 + dArray[1];
        return 1.9699272335463627E-8 * d5 + 1.9699272335463627E-8 * d4 + 0.4342944622039795 * d5 + 0.4342944622039795 * d4;
    }

    public static double pow(double d, double d2) {
        double d3;
        double d4;
        double d5;
        double d6;
        double[] dArray = new double[2];
        if (d2 == 0.0) {
            return 1.0;
        }
        if (d != d) {
            return d;
        }
        if (d == 0.0) {
            long l = Double.doubleToLongBits(d);
            if ((l & Long.MIN_VALUE) != 0L) {
                long l2 = (long)d2;
                if (d2 < 0.0 && d2 == (double)l2 && (l2 & 1L) == 1L) {
                    return Double.NEGATIVE_INFINITY;
                }
                if (d2 < 0.0 && d2 == (double)l2 && (l2 & 1L) == 1L) {
                    return -0.0;
                }
                if (d2 > 0.0 && d2 == (double)l2 && (l2 & 1L) == 1L) {
                    return -0.0;
                }
            }
            if (d2 < 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            if (d2 > 0.0) {
                return 0.0;
            }
            return Double.NaN;
        }
        if (d == Double.POSITIVE_INFINITY) {
            if (d2 != d2) {
                return d2;
            }
            if (d2 < 0.0) {
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            if (d * d == 1.0) {
                return Double.NaN;
            }
            if (d * d > 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            if (d2 != d2) {
                return d2;
            }
            if (d2 < 0.0) {
                long l = (long)d2;
                if (d2 == (double)l && (l & 1L) == 1L) {
                    return -0.0;
                }
                return 0.0;
            }
            if (d2 > 0.0) {
                long l = (long)d2;
                if (d2 == (double)l && (l & 1L) == 1L) {
                    return Double.NEGATIVE_INFINITY;
                }
                return Double.POSITIVE_INFINITY;
            }
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            if (d * d == 1.0) {
                return Double.NaN;
            }
            if (d * d < 1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }
        if (d < 0.0) {
            if (d2 >= 4.503599627370496E15 || d2 <= -4.503599627370496E15) {
                return FastMath.pow(-d, d2);
            }
            if (d2 == (double)((long)d2)) {
                return ((long)d2 & 1L) == 0L ? FastMath.pow(-d, d2) : -FastMath.pow(-d, d2);
            }
            return Double.NaN;
        }
        if (d2 < 8.0E298 && d2 > -8.0E298) {
            d6 = d2 * 1.073741824E9;
            d5 = d2 + d6 - d6;
            d4 = d2 - d5;
        } else {
            d6 = d2 * 9.313225746154785E-10;
            d3 = d6 * 9.313225746154785E-10;
            d5 = (d6 + d3 - d6) * 1.073741824E9 * 1.073741824E9;
            d4 = d2 - d5;
        }
        d6 = FastMath.log(d, dArray);
        if (Double.isInfinite(d6)) {
            return d6;
        }
        d3 = dArray[0];
        double d7 = dArray[1];
        double d8 = d3 * 1.073741824E9;
        double d9 = d3 + d8 - d8;
        d7 += d3 - d9;
        d3 = d9;
        double d10 = d3 * d5;
        double d11 = d3 * d4 + d7 * d5 + d7 * d4;
        d3 = d10 + d11;
        d7 = -(d3 - d10 - d11);
        double d12 = 0.008333333333333333;
        d12 = d12 * d7 + 0.041666666666666664;
        d12 = d12 * d7 + 0.16666666666666666;
        d12 = d12 * d7 + 0.5;
        d12 = d12 * d7 + 1.0;
        double d13 = FastMath.exp(d3, d12 *= d7, null);
        return d13;
    }

    private static double[] slowLog(double d) {
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        FastMath.split(d, dArray);
        dArray[0] = dArray[0] + 1.0;
        FastMath.resplit(dArray);
        FastMath.splitReciprocal(dArray, dArray4);
        dArray[0] = dArray[0] - 2.0;
        FastMath.resplit(dArray);
        FastMath.splitMult(dArray, dArray4, dArray3);
        dArray[0] = dArray3[0];
        dArray[1] = dArray3[1];
        FastMath.splitMult(dArray, dArray, dArray2);
        dArray3[0] = LN_SPLIT_COEF[LN_SPLIT_COEF.length - 1][0];
        dArray3[1] = LN_SPLIT_COEF[LN_SPLIT_COEF.length - 1][1];
        for (int i = LN_SPLIT_COEF.length - 2; i >= 0; --i) {
            FastMath.splitMult(dArray3, dArray2, dArray4);
            dArray3[0] = dArray4[0];
            dArray3[1] = dArray4[1];
            FastMath.splitAdd(dArray3, LN_SPLIT_COEF[i], dArray4);
            dArray3[0] = dArray4[0];
            dArray3[1] = dArray4[1];
        }
        FastMath.splitMult(dArray3, dArray, dArray4);
        dArray3[0] = dArray4[0];
        dArray3[1] = dArray4[1];
        return dArray3;
    }

    private static double slowSin(double d, double[] dArray) {
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        double[] dArray5 = new double[2];
        FastMath.split(d, dArray2);
        dArray3[1] = 0.0;
        dArray3[0] = 0.0;
        for (int i = 19; i >= 0; --i) {
            FastMath.splitMult(dArray2, dArray3, dArray5);
            dArray3[0] = dArray5[0];
            dArray3[1] = dArray5[1];
            if ((i & 1) == 0) continue;
            FastMath.split(FACT[i], dArray5);
            FastMath.splitReciprocal(dArray5, dArray4);
            if ((i & 2) != 0) {
                dArray4[0] = -dArray4[0];
                dArray4[1] = -dArray4[1];
            }
            FastMath.splitAdd(dArray3, dArray4, dArray5);
            dArray3[0] = dArray5[0];
            dArray3[1] = dArray5[1];
        }
        if (dArray != null) {
            dArray[0] = dArray3[0];
            dArray[1] = dArray3[1];
        }
        return dArray3[0] + dArray3[1];
    }

    private static double slowCos(double d, double[] dArray) {
        double[] dArray2 = new double[2];
        double[] dArray3 = new double[2];
        double[] dArray4 = new double[2];
        double[] dArray5 = new double[2];
        FastMath.split(d, dArray2);
        dArray3[1] = 0.0;
        dArray3[0] = 0.0;
        for (int i = 19; i >= 0; --i) {
            FastMath.splitMult(dArray2, dArray3, dArray5);
            dArray3[0] = dArray5[0];
            dArray3[1] = dArray5[1];
            if ((i & 1) != 0) continue;
            FastMath.split(FACT[i], dArray5);
            FastMath.splitReciprocal(dArray5, dArray4);
            if ((i & 2) != 0) {
                dArray4[0] = -dArray4[0];
                dArray4[1] = -dArray4[1];
            }
            FastMath.splitAdd(dArray3, dArray4, dArray5);
            dArray3[0] = dArray5[0];
            dArray3[1] = dArray5[1];
        }
        if (dArray != null) {
            dArray[0] = dArray3[0];
            dArray[1] = dArray3[1];
        }
        return dArray3[0] + dArray3[1];
    }

    private static void buildSinCosTables() {
        double[] dArray;
        double[] dArray2;
        int n;
        double[] dArray3 = new double[2];
        for (n = 0; n < 7; ++n) {
            double d = (double)n / 8.0;
            FastMath.slowSin(d, dArray3);
            FastMath.SINE_TABLE_A[n] = dArray3[0];
            FastMath.SINE_TABLE_B[n] = dArray3[1];
            FastMath.slowCos(d, dArray3);
            FastMath.COSINE_TABLE_A[n] = dArray3[0];
            FastMath.COSINE_TABLE_B[n] = dArray3[1];
        }
        for (n = 7; n < 14; ++n) {
            double[] dArray4 = new double[2];
            dArray2 = new double[2];
            dArray = new double[2];
            double[] dArray5 = new double[2];
            double[] dArray6 = new double[2];
            if ((n & 1) == 0) {
                dArray4[0] = SINE_TABLE_A[n / 2];
                dArray4[1] = SINE_TABLE_B[n / 2];
                dArray2[0] = COSINE_TABLE_A[n / 2];
                dArray2[1] = COSINE_TABLE_B[n / 2];
                FastMath.splitMult(dArray4, dArray2, dArray3);
                FastMath.SINE_TABLE_A[n] = dArray3[0] * 2.0;
                FastMath.SINE_TABLE_B[n] = dArray3[1] * 2.0;
                FastMath.splitMult(dArray2, dArray2, dArray);
                FastMath.splitMult(dArray4, dArray4, dArray6);
                dArray6[0] = -dArray6[0];
                dArray6[1] = -dArray6[1];
                FastMath.splitAdd(dArray, dArray6, dArray3);
                FastMath.COSINE_TABLE_A[n] = dArray3[0];
                FastMath.COSINE_TABLE_B[n] = dArray3[1];
                continue;
            }
            dArray4[0] = SINE_TABLE_A[n / 2];
            dArray4[1] = SINE_TABLE_B[n / 2];
            dArray2[0] = COSINE_TABLE_A[n / 2];
            dArray2[1] = COSINE_TABLE_B[n / 2];
            dArray[0] = SINE_TABLE_A[n / 2 + 1];
            dArray[1] = SINE_TABLE_B[n / 2 + 1];
            dArray5[0] = COSINE_TABLE_A[n / 2 + 1];
            dArray5[1] = COSINE_TABLE_B[n / 2 + 1];
            FastMath.splitMult(dArray4, dArray5, dArray6);
            FastMath.splitMult(dArray2, dArray, dArray3);
            FastMath.splitAdd(dArray3, dArray6, dArray3);
            FastMath.SINE_TABLE_A[n] = dArray3[0];
            FastMath.SINE_TABLE_B[n] = dArray3[1];
            FastMath.splitMult(dArray2, dArray5, dArray3);
            FastMath.splitMult(dArray4, dArray, dArray6);
            dArray6[0] = -dArray6[0];
            dArray6[1] = -dArray6[1];
            FastMath.splitAdd(dArray3, dArray6, dArray3);
            FastMath.COSINE_TABLE_A[n] = dArray3[0];
            FastMath.COSINE_TABLE_B[n] = dArray3[1];
        }
        for (n = 0; n < 14; ++n) {
            double[] dArray7 = new double[2];
            dArray2 = new double[2];
            dArray = new double[]{COSINE_TABLE_A[n], COSINE_TABLE_B[n]};
            FastMath.splitReciprocal(dArray, dArray2);
            dArray7[0] = SINE_TABLE_A[n];
            dArray7[1] = SINE_TABLE_B[n];
            FastMath.splitMult(dArray7, dArray2, dArray);
            FastMath.TANGENT_TABLE_A[n] = dArray[0];
            FastMath.TANGENT_TABLE_B[n] = dArray[1];
        }
    }

    private static double polySine(double d) {
        double d2 = d * d;
        double d3 = 2.7553817452272217E-6;
        d3 = d3 * d2 + -1.9841269659586505E-4;
        d3 = d3 * d2 + 0.008333333333329196;
        d3 = d3 * d2 + -0.16666666666666666;
        d3 = d3 * d2 * d;
        return d3;
    }

    private static double polyCosine(double d) {
        double d2 = d * d;
        double d3 = 2.479773539153719E-5;
        d3 = d3 * d2 + -0.0013888888689039883;
        d3 = d3 * d2 + 0.041666666666621166;
        d3 = d3 * d2 + -0.49999999999999994;
        return d3 *= d2;
    }

    private static double sinQ(double d, double d2) {
        int n = (int)(d * 8.0 + 0.5);
        double d3 = d - EIGHTHS[n];
        double d4 = SINE_TABLE_A[n];
        double d5 = SINE_TABLE_B[n];
        double d6 = COSINE_TABLE_A[n];
        double d7 = COSINE_TABLE_B[n];
        double d8 = d3;
        double d9 = FastMath.polySine(d3);
        double d10 = FastMath.polyCosine(d3);
        double d11 = d8 * 1.073741824E9;
        double d12 = d8 + d11 - d11;
        d9 += d8 - d12;
        d8 = d12;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = d4;
        double d16 = d13 + d15;
        double d17 = -(d16 - d13 - d15);
        d13 = d16;
        d14 += d17;
        d15 = d6 * d8;
        d16 = d13 + d15;
        d17 = -(d16 - d13 - d15);
        d13 = d16;
        d14 += d17;
        d14 = d14 + d4 * d10 + d6 * d9;
        d14 = d14 + d5 + d7 * d8 + d5 * d10 + d7 * d9;
        if (d2 != 0.0) {
            d15 = ((d6 + d7) * (1.0 + d10) - (d4 + d5) * (d8 + d9)) * d2;
            d16 = d13 + d15;
            d17 = -(d16 - d13 - d15);
            d13 = d16;
            d14 += d17;
        }
        double d18 = d13 + d14;
        return d18;
    }

    private static double cosQ(double d, double d2) {
        double d3 = 1.5707963267948966 - d;
        double d4 = -(d3 - 1.5707963267948966 + d);
        return FastMath.sinQ(d3, d4 += 6.123233995736766E-17 - d2);
    }

    private static double tanQ(double d, double d2, boolean bl) {
        double d3;
        int n = (int)(d * 8.0 + 0.5);
        double d4 = d - EIGHTHS[n];
        double d5 = SINE_TABLE_A[n];
        double d6 = SINE_TABLE_B[n];
        double d7 = COSINE_TABLE_A[n];
        double d8 = COSINE_TABLE_B[n];
        double d9 = d4;
        double d10 = FastMath.polySine(d4);
        double d11 = FastMath.polyCosine(d4);
        double d12 = d9 * 1.073741824E9;
        double d13 = d9 + d12 - d12;
        d10 += d9 - d13;
        d9 = d13;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = d5;
        double d17 = d14 + d16;
        double d18 = -(d17 - d14 - d16);
        d14 = d17;
        d15 += d18;
        d16 = d7 * d9;
        d17 = d14 + d16;
        d18 = -(d17 - d14 - d16);
        d14 = d17;
        d15 += d18;
        d15 = d15 + d5 * d11 + d7 * d10;
        d15 = d15 + d6 + d8 * d9 + d6 * d11 + d8 * d10;
        double d19 = d14 + d15;
        double d20 = -(d19 - d14 - d15);
        d18 = 0.0;
        d17 = 0.0;
        d15 = 0.0;
        d14 = 0.0;
        d16 = d7 * 1.0;
        d17 = d14 + d16;
        d18 = -(d17 - d14 - d16);
        d14 = d17;
        d15 += d18;
        d16 = -d5 * d9;
        d17 = d14 + d16;
        d18 = -(d17 - d14 - d16);
        d14 = d17;
        d15 += d18;
        d15 = d15 + d8 * 1.0 + d7 * d11 + d8 * d11;
        double d21 = d14 + (d15 -= d6 * d9 + d5 * d10 + d6 * d10);
        double d22 = -(d21 - d14 - d15);
        if (bl) {
            d3 = d21;
            d21 = d19;
            d19 = d3;
            d3 = d22;
            d22 = d20;
            d20 = d3;
        }
        d3 = d19 / d21;
        d12 = d3 * 1.073741824E9;
        double d23 = d3 + d12 - d12;
        double d24 = d3 - d23;
        d12 = d21 * 1.073741824E9;
        double d25 = d21 + d12 - d12;
        double d26 = d21 - d25;
        double d27 = (d19 - d23 * d25 - d23 * d26 - d24 * d25 - d24 * d26) / d21;
        d27 += d20 / d21;
        d27 += -d19 * d22 / d21 / d21;
        if (d2 != 0.0) {
            double d28 = d2 + d3 * d3 * d2;
            if (bl) {
                d28 = -d28;
            }
            d27 += d28;
        }
        return d3 + d27;
    }

    private static void reducePayneHanek(double d, double[] dArray) {
        boolean bl;
        long l;
        long l2;
        long l3;
        int n;
        int n2;
        long l4 = Double.doubleToLongBits(d);
        int n3 = (int)(l4 >> 52 & 0x7FFL) - 1023;
        l4 &= 0xFFFFFFFFFFFFFL;
        l4 |= 0x10000000000000L;
        l4 <<= 11;
        if ((n2 = ++n3 - ((n = n3 >> 6) << 6)) != 0) {
            l3 = n == 0 ? 0L : RECIP_2PI[n - 1] << n2;
            l3 |= RECIP_2PI[n] >>> 64 - n2;
            l2 = RECIP_2PI[n] << n2 | RECIP_2PI[n + 1] >>> 64 - n2;
            l = RECIP_2PI[n + 1] << n2 | RECIP_2PI[n + 2] >>> 64 - n2;
        } else {
            l3 = n == 0 ? 0L : RECIP_2PI[n - 1];
            l2 = RECIP_2PI[n];
            l = RECIP_2PI[n + 1];
        }
        long l5 = l4 >>> 32;
        long l6 = l4 & 0xFFFFFFFFL;
        long l7 = l2 >>> 32;
        long l8 = l2 & 0xFFFFFFFFL;
        long l9 = l5 * l7;
        long l10 = l6 * l8;
        long l11 = l6 * l7;
        long l12 = l5 * l8;
        long l13 = l10 + (l12 << 32);
        long l14 = l9 + (l12 >>> 32);
        boolean bl2 = (l10 & Long.MIN_VALUE) != 0L;
        boolean bl3 = (l12 & 0x80000000L) != 0L;
        boolean bl4 = bl = (l13 & Long.MIN_VALUE) != 0L;
        if (bl2 && bl3 || (bl2 || bl3) && !bl) {
            ++l14;
        }
        bl2 = (l13 & Long.MIN_VALUE) != 0L;
        bl3 = (l11 & 0x80000000L) != 0L;
        l14 += l11 >>> 32;
        boolean bl5 = bl = ((l13 += l11 << 32) & Long.MIN_VALUE) != 0L;
        if (bl2 && bl3 || (bl2 || bl3) && !bl) {
            ++l14;
        }
        l7 = l >>> 32;
        l8 = l & 0xFFFFFFFFL;
        l9 = l5 * l7;
        l11 = l6 * l7;
        l12 = l5 * l8;
        bl2 = (l13 & Long.MIN_VALUE) != 0L;
        bl3 = ((l9 += l11 + l12 >>> 32) & Long.MIN_VALUE) != 0L;
        boolean bl6 = bl = ((l13 += l9) & Long.MIN_VALUE) != 0L;
        if (bl2 && bl3 || (bl2 || bl3) && !bl) {
            ++l14;
        }
        l7 = l3 >>> 32;
        l8 = l3 & 0xFFFFFFFFL;
        l10 = l6 * l8;
        l11 = l6 * l7;
        l12 = l5 * l8;
        int n4 = (int)((l14 += l10 + (l11 + l12 << 32)) >>> 62);
        l14 <<= 2;
        l14 |= l13 >>> 62;
        l13 <<= 2;
        l5 = l14 >>> 32;
        l6 = l14 & 0xFFFFFFFFL;
        l7 = PI_O_4_BITS[0] >>> 32;
        l8 = PI_O_4_BITS[0] & 0xFFFFFFFFL;
        l9 = l5 * l7;
        l10 = l6 * l8;
        l11 = l6 * l7;
        l12 = l5 * l8;
        long l15 = l10 + (l12 << 32);
        long l16 = l9 + (l12 >>> 32);
        bl2 = (l10 & Long.MIN_VALUE) != 0L;
        bl3 = (l12 & 0x80000000L) != 0L;
        boolean bl7 = bl = (l15 & Long.MIN_VALUE) != 0L;
        if (bl2 && bl3 || (bl2 || bl3) && !bl) {
            ++l16;
        }
        bl2 = (l15 & Long.MIN_VALUE) != 0L;
        bl3 = (l11 & 0x80000000L) != 0L;
        l16 += l11 >>> 32;
        boolean bl8 = bl = ((l15 += l11 << 32) & Long.MIN_VALUE) != 0L;
        if (bl2 && bl3 || (bl2 || bl3) && !bl) {
            ++l16;
        }
        l7 = PI_O_4_BITS[1] >>> 32;
        l8 = PI_O_4_BITS[1] & 0xFFFFFFFFL;
        l9 = l5 * l7;
        l11 = l6 * l7;
        l12 = l5 * l8;
        bl2 = (l15 & Long.MIN_VALUE) != 0L;
        bl3 = ((l9 += l11 + l12 >>> 32) & Long.MIN_VALUE) != 0L;
        boolean bl9 = bl = ((l15 += l9) & Long.MIN_VALUE) != 0L;
        if (bl2 && bl3 || (bl2 || bl3) && !bl) {
            ++l16;
        }
        l5 = l13 >>> 32;
        l6 = l13 & 0xFFFFFFFFL;
        l7 = PI_O_4_BITS[0] >>> 32;
        l8 = PI_O_4_BITS[0] & 0xFFFFFFFFL;
        l9 = l5 * l7;
        l11 = l6 * l7;
        l12 = l5 * l8;
        bl2 = (l15 & Long.MIN_VALUE) != 0L;
        bl3 = ((l9 += l11 + l12 >>> 32) & Long.MIN_VALUE) != 0L;
        boolean bl10 = bl = ((l15 += l9) & Long.MIN_VALUE) != 0L;
        if (bl2 && bl3 || (bl2 || bl3) && !bl) {
            ++l16;
        }
        double d2 = (double)(l16 >>> 12) / 4.503599627370496E15;
        double d3 = (double)(((l16 & 0xFFFL) << 40) + (l15 >>> 24)) / 4.503599627370496E15 / 4.503599627370496E15;
        double d4 = d2 + d3;
        double d5 = -(d4 - d2 - d3);
        dArray[0] = n4;
        dArray[1] = d4 * 2.0;
        dArray[2] = d5 * 2.0;
    }

    public static double sin(double d) {
        boolean bl = false;
        int n = 0;
        double d2 = 0.0;
        double d3 = d;
        if (d < 0.0) {
            bl = true;
            d3 = -d3;
        }
        if (d3 == 0.0) {
            long l = Double.doubleToLongBits(d);
            if (l < 0L) {
                return -0.0;
            }
            return 0.0;
        }
        if (d3 != d3 || d3 == Double.POSITIVE_INFINITY) {
            return Double.NaN;
        }
        if (d3 > 3294198.0) {
            double[] dArray = new double[3];
            FastMath.reducePayneHanek(d3, dArray);
            n = (int)dArray[0] & 3;
            d3 = dArray[1];
            d2 = dArray[2];
        } else if (d3 > 1.5707963267948966) {
            double d4;
            double d5;
            int n2 = (int)(d3 * 0.6366197723675814);
            while (true) {
                double d6 = (double)(-n2) * 1.570796251296997;
                d5 = d3 + d6;
                d4 = -(d5 - d3 - d6);
                d6 = (double)(-n2) * 7.549789948768648E-8;
                double d7 = d5;
                d5 = d6 + d7;
                d4 += -(d5 - d7 - d6);
                d6 = (double)(-n2) * 6.123233995736766E-17;
                d7 = d5;
                d5 = d6 + d7;
                d4 += -(d5 - d7 - d6);
                if (d5 > 0.0) break;
                --n2;
            }
            n = n2 & 3;
            d3 = d5;
            d2 = d4;
        }
        if (bl) {
            n ^= 2;
        }
        switch (n) {
            case 0: {
                return FastMath.sinQ(d3, d2);
            }
            case 1: {
                return FastMath.cosQ(d3, d2);
            }
            case 2: {
                return -FastMath.sinQ(d3, d2);
            }
            case 3: {
                return -FastMath.cosQ(d3, d2);
            }
        }
        return Double.NaN;
    }

    public static double cos(double d) {
        int n = 0;
        double d2 = d;
        if (d < 0.0) {
            d2 = -d2;
        }
        if (d2 != d2 || d2 == Double.POSITIVE_INFINITY) {
            return Double.NaN;
        }
        double d3 = 0.0;
        if (d2 > 3294198.0) {
            double[] dArray = new double[3];
            FastMath.reducePayneHanek(d2, dArray);
            n = (int)dArray[0] & 3;
            d2 = dArray[1];
            d3 = dArray[2];
        } else if (d2 > 1.5707963267948966) {
            double d4;
            double d5;
            int n2 = (int)(d2 * 0.6366197723675814);
            while (true) {
                double d6 = (double)(-n2) * 1.570796251296997;
                d5 = d2 + d6;
                d4 = -(d5 - d2 - d6);
                d6 = (double)(-n2) * 7.549789948768648E-8;
                double d7 = d5;
                d5 = d6 + d7;
                d4 += -(d5 - d7 - d6);
                d6 = (double)(-n2) * 6.123233995736766E-17;
                d7 = d5;
                d5 = d6 + d7;
                d4 += -(d5 - d7 - d6);
                if (d5 > 0.0) break;
                --n2;
            }
            n = n2 & 3;
            d2 = d5;
            d3 = d4;
        }
        switch (n) {
            case 0: {
                return FastMath.cosQ(d2, d3);
            }
            case 1: {
                return -FastMath.sinQ(d2, d3);
            }
            case 2: {
                return -FastMath.cosQ(d2, d3);
            }
            case 3: {
                return FastMath.sinQ(d2, d3);
            }
        }
        return Double.NaN;
    }

    public static double tan(double d) {
        boolean bl = false;
        int n = 0;
        double d2 = d;
        if (d < 0.0) {
            bl = true;
            d2 = -d2;
        }
        if (d2 == 0.0) {
            long l = Double.doubleToLongBits(d);
            if (l < 0L) {
                return -0.0;
            }
            return 0.0;
        }
        if (d2 != d2 || d2 == Double.POSITIVE_INFINITY) {
            return Double.NaN;
        }
        double d3 = 0.0;
        if (d2 > 3294198.0) {
            double[] dArray = new double[3];
            FastMath.reducePayneHanek(d2, dArray);
            n = (int)dArray[0] & 3;
            d2 = dArray[1];
            d3 = dArray[2];
        } else if (d2 > 1.5707963267948966) {
            double d4;
            double d5;
            int n2 = (int)(d2 * 0.6366197723675814);
            while (true) {
                double d6 = (double)(-n2) * 1.570796251296997;
                d5 = d2 + d6;
                d4 = -(d5 - d2 - d6);
                d6 = (double)(-n2) * 7.549789948768648E-8;
                double d7 = d5;
                d5 = d6 + d7;
                d4 += -(d5 - d7 - d6);
                d6 = (double)(-n2) * 6.123233995736766E-17;
                d7 = d5;
                d5 = d6 + d7;
                d4 += -(d5 - d7 - d6);
                if (d5 > 0.0) break;
                --n2;
            }
            n = n2 & 3;
            d2 = d5;
            d3 = d4;
        }
        if (d2 > 1.5) {
            double d8 = 1.5707963267948966 - d2;
            double d9 = -(d8 - 1.5707963267948966 + d2);
            d2 = d8 + (d9 += 6.123233995736766E-17 - d3);
            d3 = -(d2 - d8 - d9);
            n ^= 1;
            bl ^= true;
        }
        double d10 = !(n & true) ? FastMath.tanQ(d2, d3, false) : -FastMath.tanQ(d2, d3, true);
        if (bl) {
            d10 = -d10;
        }
        return d10;
    }

    public static double atan(double d) {
        return FastMath.atan(d, 0.0, false);
    }

    private static double atan(double d, double d2, boolean bl) {
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        int n;
        boolean bl2 = false;
        if (d == 0.0) {
            return bl ? FastMath.copySign(Math.PI, d) : d;
        }
        if (d < 0.0) {
            d = -d;
            d2 = -d2;
            bl2 = true;
        }
        if (d > 1.633123935319537E16) {
            return bl2 ^ bl ? -1.5707963267948966 : 1.5707963267948966;
        }
        if (d < 1.0) {
            n = (int)((-1.7168146928204135 * d * d + 8.0) * d + 0.5);
        } else {
            d8 = 1.0 / d;
            n = (int)(-((-1.7168146928204135 * d8 * d8 + 8.0) * d8) + 13.07);
        }
        d8 = d - TANGENT_TABLE_A[n];
        double d9 = -(d8 - d + TANGENT_TABLE_A[n]);
        double d10 = d8 + (d9 += d2 - TANGENT_TABLE_B[n]);
        d9 = -(d10 - d8 - d9);
        d8 = d10;
        d10 = d * 1.073741824E9;
        double d11 = d + d10 - d10;
        double d12 = d2 + d - d11;
        d = d11;
        d2 += d12;
        if (n == 0) {
            d7 = 1.0 / (1.0 + (d + d2) * (TANGENT_TABLE_A[n] + TANGENT_TABLE_B[n]));
            d11 = d8 * d7;
            d12 = d9 * d7;
        } else {
            d7 = d * TANGENT_TABLE_A[n];
            d6 = 1.0 + d7;
            d5 = -(d6 - 1.0 - d7);
            d7 = d2 * TANGENT_TABLE_A[n] + d * TANGENT_TABLE_B[n];
            d10 = d6 + d7;
            d5 += -(d10 - d6 - d7);
            d6 = d10;
            d5 += d2 * TANGENT_TABLE_B[n];
            d11 = d8 / d6;
            d10 = d11 * 1.073741824E9;
            d4 = d11 + d10 - d10;
            d3 = d11 - d4;
            d10 = d6 * 1.073741824E9;
            double d13 = d6 + d10 - d10;
            double d14 = d6 - d13;
            d12 = (d8 - d4 * d13 - d4 * d14 - d3 * d13 - d3 * d14) / d6;
            d12 += -d8 * d5 / d6 / d6;
            d12 += d9 / d6;
        }
        d8 = d11;
        d9 = d12;
        d7 = d8 * d8;
        d12 = 0.07490822288864472;
        d12 = d12 * d7 + -0.09088450866185192;
        d12 = d12 * d7 + 0.11111095942313305;
        d12 = d12 * d7 + -0.1428571423679182;
        d12 = d12 * d7 + 0.19999999999923582;
        d12 = d12 * d7 + -0.33333333333333287;
        d12 = d12 * d7 * d8;
        d11 = d8;
        d10 = d11 + d12;
        d12 = -(d10 - d11 - d12);
        d11 = d10;
        d4 = EIGHTHS[n] + d11;
        d3 = -(d4 - EIGHTHS[n] - d11);
        d10 = d4 + (d12 += d9 / (1.0 + d8 * d8));
        d3 += -(d10 - d4 - d12);
        d4 = d10;
        d6 = d4 + d3;
        d5 = -(d6 - d4 - d3);
        if (bl) {
            d4 = Math.PI - d6;
            d3 = -(d4 - Math.PI + d6);
            d6 = d4 + (d3 += 1.2246467991473532E-16 - d5);
            d5 = -(d6 - d4 - d3);
        }
        if (bl2 ^ bl) {
            d6 = -d6;
        }
        return d6;
    }

    public static double atan2(double d, double d2) {
        double d3;
        if (d2 != d2 || d != d) {
            return Double.NaN;
        }
        if (d == 0.0) {
            double d4 = d2 * d;
            double d5 = 1.0 / d2;
            double d6 = 1.0 / d;
            if (d5 == 0.0) {
                if (d2 > 0.0) {
                    return d;
                }
                return FastMath.copySign(Math.PI, d);
            }
            if (d2 < 0.0 || d5 < 0.0) {
                if (d < 0.0 || d6 < 0.0) {
                    return -Math.PI;
                }
                return Math.PI;
            }
            return d4;
        }
        if (d == Double.POSITIVE_INFINITY) {
            if (d2 == Double.POSITIVE_INFINITY) {
                return 0.7853981633974483;
            }
            if (d2 == Double.NEGATIVE_INFINITY) {
                return 2.356194490192345;
            }
            return 1.5707963267948966;
        }
        if (d == Double.NEGATIVE_INFINITY) {
            if (d2 == Double.POSITIVE_INFINITY) {
                return -0.7853981633974483;
            }
            if (d2 == Double.NEGATIVE_INFINITY) {
                return -2.356194490192345;
            }
            return -1.5707963267948966;
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            if (d > 0.0 || 1.0 / d > 0.0) {
                return 0.0;
            }
            if (d < 0.0 || 1.0 / d < 0.0) {
                return -0.0;
            }
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            if (d > 0.0 || 1.0 / d > 0.0) {
                return Math.PI;
            }
            if (d < 0.0 || 1.0 / d < 0.0) {
                return -Math.PI;
            }
        }
        if (d2 == 0.0) {
            if (d > 0.0 || 1.0 / d > 0.0) {
                return 1.5707963267948966;
            }
            if (d < 0.0 || 1.0 / d < 0.0) {
                return -1.5707963267948966;
            }
        }
        if (Double.isInfinite(d3 = d / d2)) {
            return FastMath.atan(d3, 0.0, d2 < 0.0);
        }
        double d7 = FastMath.doubleHighPart(d3);
        double d8 = d3 - d7;
        double d9 = FastMath.doubleHighPart(d2);
        double d10 = d2 - d9;
        d8 += (d - d7 * d9 - d7 * d10 - d8 * d9 - d8 * d10) / d2;
        double d11 = d7 + d8;
        d8 = -(d11 - d7 - d8);
        d7 = d11;
        if (d7 == 0.0) {
            d7 = FastMath.copySign(0.0, d);
        }
        double d12 = FastMath.atan(d7, d8, d2 < 0.0);
        return d12;
    }

    public static double asin(double d) {
        if (d != d) {
            return Double.NaN;
        }
        if (d > 1.0 || d < -1.0) {
            return Double.NaN;
        }
        if (d == 1.0) {
            return 1.5707963267948966;
        }
        if (d == -1.0) {
            return -1.5707963267948966;
        }
        if (d == 0.0) {
            return d;
        }
        double d2 = d * 1.073741824E9;
        double d3 = d + d2 - d2;
        double d4 = d - d3;
        double d5 = d3 * d3;
        double d6 = d3 * d4 * 2.0 + d4 * d4;
        d5 = -d5;
        d6 = -d6;
        double d7 = 1.0 + d5;
        double d8 = -(d7 - 1.0 - d5);
        d2 = d7 + d6;
        d8 += -(d2 - d7 - d6);
        d7 = d2;
        double d9 = FastMath.sqrt(d7);
        d2 = d9 * 1.073741824E9;
        d5 = d9 + d2 - d2;
        d6 = d9 - d5;
        d6 += (d7 - d5 * d5 - 2.0 * d5 * d6 - d6 * d6) / (2.0 * d9);
        double d10 = d8 / (2.0 * d9);
        double d11 = d / d9;
        d2 = d11 * 1.073741824E9;
        double d12 = d11 + d2 - d2;
        double d13 = d11 - d12;
        d13 += (d - d12 * d5 - d12 * d6 - d13 * d5 - d13 * d6) / d9;
        d2 = d12 + (d13 += -d * d10 / d9 / d9);
        d13 = -(d2 - d12 - d13);
        d12 = d2;
        return FastMath.atan(d12, d13, false);
    }

    public static double acos(double d) {
        if (d != d) {
            return Double.NaN;
        }
        if (d > 1.0 || d < -1.0) {
            return Double.NaN;
        }
        if (d == -1.0) {
            return Math.PI;
        }
        if (d == 1.0) {
            return 0.0;
        }
        if (d == 0.0) {
            return 1.5707963267948966;
        }
        double d2 = d * 1.073741824E9;
        double d3 = d + d2 - d2;
        double d4 = d - d3;
        double d5 = d3 * d3;
        double d6 = d3 * d4 * 2.0 + d4 * d4;
        d5 = -d5;
        d6 = -d6;
        double d7 = 1.0 + d5;
        double d8 = -(d7 - 1.0 - d5);
        d2 = d7 + d6;
        d8 += -(d2 - d7 - d6);
        d7 = d2;
        double d9 = FastMath.sqrt(d7);
        d2 = d9 * 1.073741824E9;
        d5 = d9 + d2 - d2;
        d6 = d9 - d5;
        d6 += (d7 - d5 * d5 - 2.0 * d5 * d6 - d6 * d6) / (2.0 * d9);
        d6 += d8 / (2.0 * d9);
        d9 = d5 + d6;
        d6 = -(d9 - d5 - d6);
        double d10 = d9 / d;
        if (Double.isInfinite(d10)) {
            return 1.5707963267948966;
        }
        double d11 = FastMath.doubleHighPart(d10);
        double d12 = d10 - d11;
        d12 += (d9 - d11 * d3 - d11 * d4 - d12 * d3 - d12 * d4) / d;
        d2 = d11 + (d12 += d6 / d);
        d12 = -(d2 - d11 - d12);
        d11 = d2;
        return FastMath.atan(d11, d12, d < 0.0);
    }

    public static double cbrt(double d) {
        long l = Double.doubleToLongBits(d);
        int n = (int)(l >> 52 & 0x7FFL) - 1023;
        boolean bl = false;
        if (n == -1023) {
            if (d == 0.0) {
                return d;
            }
            bl = true;
            l = Double.doubleToLongBits(d *= 1.8014398509481984E16);
            n = (int)(l >> 52 & 0x7FFL) - 1023;
        }
        if (n == 1024) {
            return d;
        }
        int n2 = n / 3;
        double d2 = Double.longBitsToDouble(l & Long.MIN_VALUE | (long)(n2 + 1023 & 0x7FF) << 52);
        double d3 = Double.longBitsToDouble(l & 0xFFFFFFFFFFFFFL | 0x3FF0000000000000L);
        double d4 = -0.010714690733195933;
        d4 = d4 * d3 + 0.0875862700108075;
        d4 = d4 * d3 + -0.3058015757857271;
        d4 = d4 * d3 + 0.7249995199969751;
        d4 = d4 * d3 + 0.5039018405998233;
        d4 *= CBRTTWO[n % 3 + 2];
        double d5 = d / (d2 * d2 * d2);
        d4 += (d5 - d4 * d4 * d4) / (3.0 * d4 * d4);
        d4 += (d5 - d4 * d4 * d4) / (3.0 * d4 * d4);
        double d6 = d4 * 1.073741824E9;
        double d7 = d4 + d6 - d6;
        double d8 = d4 - d7;
        double d9 = d7 * d7;
        double d10 = d7 * d8 * 2.0 + d8 * d8;
        d6 = d9 * 1.073741824E9;
        double d11 = d9 + d6 - d6;
        d10 += d9 - d11;
        d9 = d11;
        d10 = d9 * d8 + d7 * d10 + d10 * d8;
        double d12 = d5 - (d9 *= d7);
        double d13 = -(d12 - d5 + d9);
        d4 += (d12 + (d13 -= d10)) / (3.0 * d4 * d4);
        d4 *= d2;
        if (bl) {
            d4 *= 3.814697265625E-6;
        }
        return d4;
    }

    public static double toRadians(double d) {
        if (Double.isInfinite(d) || d == 0.0) {
            return d;
        }
        double d2 = FastMath.doubleHighPart(d);
        double d3 = d - d2;
        double d4 = d3 * 1.997844754509471E-9 + d3 * 0.01745329052209854 + d2 * 1.997844754509471E-9 + d2 * 0.01745329052209854;
        if (d4 == 0.0) {
            d4 *= d;
        }
        return d4;
    }

    public static double toDegrees(double d) {
        if (Double.isInfinite(d) || d == 0.0) {
            return d;
        }
        double d2 = FastMath.doubleHighPart(d);
        double d3 = d - d2;
        return d3 * 3.145894820876798E-6 + d3 * 57.2957763671875 + d2 * 3.145894820876798E-6 + d2 * 57.2957763671875;
    }

    public static int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static long abs(long l) {
        return l < 0L ? -l : l;
    }

    public static float abs(float f) {
        return f < 0.0f ? -f : (f == 0.0f ? 0.0f : f);
    }

    public static double abs(double d) {
        return d < 0.0 ? -d : (d == 0.0 ? 0.0 : d);
    }

    public static double ulp(double d) {
        if (Double.isInfinite(d)) {
            return Double.POSITIVE_INFINITY;
        }
        return FastMath.abs(d - Double.longBitsToDouble(Double.doubleToLongBits(d) ^ 1L));
    }

    public static float ulp(float f) {
        if (Float.isInfinite(f)) {
            return Float.POSITIVE_INFINITY;
        }
        return FastMath.abs(f - Float.intBitsToFloat(Float.floatToIntBits(f) ^ 1));
    }

    public static double scalb(double d, int n) {
        if (n > -1023 && n < 1024) {
            return d * Double.longBitsToDouble((long)(n + 1023) << 52);
        }
        if (Double.isNaN(d) || Double.isInfinite(d) || d == 0.0) {
            return d;
        }
        if (n < -2098) {
            return d > 0.0 ? 0.0 : -0.0;
        }
        if (n > 2097) {
            return d > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        long l = Double.doubleToLongBits(d);
        long l2 = l & Long.MIN_VALUE;
        int n2 = (int)(l >>> 52) & 0x7FF;
        long l3 = l & 0xFFFFFFFFFFFFFL;
        int n3 = n2 + n;
        if (n < 0) {
            if (n3 > 0) {
                return Double.longBitsToDouble(l2 | (long)n3 << 52 | l3);
            }
            if (n3 > -53) {
                long l4 = (l3 |= 0x10000000000000L) & 1L << -n3;
                l3 >>>= 1 - n3;
                if (l4 != 0L) {
                    ++l3;
                }
                return Double.longBitsToDouble(l2 | l3);
            }
            return l2 == 0L ? 0.0 : -0.0;
        }
        if (n2 == 0) {
            while (l3 >>> 52 != 1L) {
                l3 <<= 1;
                --n3;
            }
            l3 &= 0xFFFFFFFFFFFFFL;
            if (++n3 < 2047) {
                return Double.longBitsToDouble(l2 | (long)n3 << 52 | l3);
            }
            return l2 == 0L ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        if (n3 < 2047) {
            return Double.longBitsToDouble(l2 | (long)n3 << 52 | l3);
        }
        return l2 == 0L ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
    }

    public static float scalb(float f, int n) {
        if (n > -127 && n < 128) {
            return f * Float.intBitsToFloat(n + 127 << 23);
        }
        if (Float.isNaN(f) || Float.isInfinite(f) || f == 0.0f) {
            return f;
        }
        if (n < -277) {
            return f > 0.0f ? 0.0f : -0.0f;
        }
        if (n > 276) {
            return f > 0.0f ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
        }
        int n2 = Float.floatToIntBits(f);
        int n3 = n2 & Integer.MIN_VALUE;
        int n4 = n2 >>> 23 & 0xFF;
        int n5 = n2 & 0x7FFFFF;
        int n6 = n4 + n;
        if (n < 0) {
            if (n6 > 0) {
                return Float.intBitsToFloat(n3 | n6 << 23 | n5);
            }
            if (n6 > -24) {
                int n7 = (n5 |= 0x800000) & 1 << -n6;
                n5 >>>= 1 - n6;
                if (n7 != 0) {
                    ++n5;
                }
                return Float.intBitsToFloat(n3 | n5);
            }
            return n3 == 0 ? 0.0f : -0.0f;
        }
        if (n4 == 0) {
            while (n5 >>> 23 != 1) {
                n5 <<= 1;
                --n6;
            }
            n5 &= 0x7FFFFF;
            if (++n6 < 255) {
                return Float.intBitsToFloat(n3 | n6 << 23 | n5);
            }
            return n3 == 0 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
        }
        if (n6 < 255) {
            return Float.intBitsToFloat(n3 | n6 << 23 | n5);
        }
        return n3 == 0 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
    }

    public static double nextAfter(double d, double d2) {
        long l;
        long l2;
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (d == d2) {
            return d2;
        }
        if (Double.isInfinite(d)) {
            return d < 0.0 ? -1.7976931348623157E308 : Double.MAX_VALUE;
        }
        if (d == 0.0) {
            return d2 < 0.0 ? -4.9E-324 : Double.MIN_VALUE;
        }
        if (d2 < d ^ (l2 = (l = Double.doubleToLongBits(d)) & Long.MIN_VALUE) == 0L) {
            return Double.longBitsToDouble(l2 | (l & Long.MAX_VALUE) + 1L);
        }
        return Double.longBitsToDouble(l2 | (l & Long.MAX_VALUE) - 1L);
    }

    public static float nextAfter(float f, double d) {
        int n;
        int n2;
        if (Double.isNaN(f) || Double.isNaN(d)) {
            return Float.NaN;
        }
        if ((double)f == d) {
            return (float)d;
        }
        if (Float.isInfinite(f)) {
            return f < 0.0f ? -3.4028235E38f : Float.MAX_VALUE;
        }
        if (f == 0.0f) {
            return d < 0.0 ? -1.4E-45f : Float.MIN_VALUE;
        }
        if (d < (double)f ^ (n2 = (n = Float.floatToIntBits(f)) & Integer.MIN_VALUE) == 0) {
            return Float.intBitsToFloat(n2 | (n & Integer.MAX_VALUE) + 1);
        }
        return Float.intBitsToFloat(n2 | (n & Integer.MAX_VALUE) - 1);
    }

    public static double floor(double d) {
        if (d != d) {
            return d;
        }
        if (d >= 4.503599627370496E15 || d <= -4.503599627370496E15) {
            return d;
        }
        long l = (long)d;
        if (d < 0.0 && (double)l != d) {
            --l;
        }
        if (l == 0L) {
            return d * (double)l;
        }
        return l;
    }

    public static double ceil(double d) {
        if (d != d) {
            return d;
        }
        double d2 = FastMath.floor(d);
        if (d2 == d) {
            return d2;
        }
        if ((d2 += 1.0) == 0.0) {
            return d * d2;
        }
        return d2;
    }

    public static double rint(double d) {
        double d2 = FastMath.floor(d);
        double d3 = d - d2;
        if (d3 > 0.5) {
            if (d2 == -1.0) {
                return -0.0;
            }
            return d2 + 1.0;
        }
        if (d3 < 0.5) {
            return d2;
        }
        long l = (long)d2;
        return (l & 1L) == 0L ? d2 : d2 + 1.0;
    }

    public static long round(double d) {
        return (long)FastMath.floor(d + 0.5);
    }

    public static int round(float f) {
        return (int)FastMath.floor(f + 0.5f);
    }

    public static int min(int n, int n2) {
        return n <= n2 ? n : n2;
    }

    public static long min(long l, long l2) {
        return l <= l2 ? l : l2;
    }

    public static float min(float f, float f2) {
        if (f > f2) {
            return f2;
        }
        if (f < f2) {
            return f;
        }
        if (f != f2) {
            return Float.NaN;
        }
        int n = Float.floatToRawIntBits(f);
        if (n == Integer.MIN_VALUE) {
            return f;
        }
        return f2;
    }

    public static double min(double d, double d2) {
        if (d > d2) {
            return d2;
        }
        if (d < d2) {
            return d;
        }
        if (d != d2) {
            return Double.NaN;
        }
        long l = Double.doubleToRawLongBits(d);
        if (l == Long.MIN_VALUE) {
            return d;
        }
        return d2;
    }

    public static int max(int n, int n2) {
        return n <= n2 ? n2 : n;
    }

    public static long max(long l, long l2) {
        return l <= l2 ? l2 : l;
    }

    public static float max(float f, float f2) {
        if (f > f2) {
            return f;
        }
        if (f < f2) {
            return f2;
        }
        if (f != f2) {
            return Float.NaN;
        }
        int n = Float.floatToRawIntBits(f);
        if (n == Integer.MIN_VALUE) {
            return f2;
        }
        return f;
    }

    public static double max(double d, double d2) {
        if (d > d2) {
            return d;
        }
        if (d < d2) {
            return d2;
        }
        if (d != d2) {
            return Double.NaN;
        }
        long l = Double.doubleToRawLongBits(d);
        if (l == Long.MIN_VALUE) {
            return d2;
        }
        return d;
    }

    public static double hypot(double d, double d2) {
        int n;
        if (Double.isInfinite(d) || Double.isInfinite(d2)) {
            return Double.POSITIVE_INFINITY;
        }
        if (Double.isNaN(d) || Double.isNaN(d2)) {
            return Double.NaN;
        }
        int n2 = FastMath.getExponent(d);
        if (n2 > (n = FastMath.getExponent(d2)) + 27) {
            return FastMath.abs(d);
        }
        if (n > n2 + 27) {
            return FastMath.abs(d2);
        }
        int n3 = (n2 + n) / 2;
        double d3 = FastMath.scalb(d, -n3);
        double d4 = FastMath.scalb(d2, -n3);
        double d5 = FastMath.sqrt(d3 * d3 + d4 * d4);
        return FastMath.scalb(d5, n3);
    }

    public static double IEEEremainder(double d, double d2) {
        return StrictMath.IEEEremainder(d, d2);
    }

    public static double copySign(double d, double d2) {
        long l = Double.doubleToLongBits(d);
        long l2 = Double.doubleToLongBits(d2);
        if (l >= 0L && l2 >= 0L || l < 0L && l2 < 0L) {
            return d;
        }
        return -d;
    }

    public static float copySign(float f, float f2) {
        int n = Float.floatToIntBits(f);
        int n2 = Float.floatToIntBits(f2);
        if (n >= 0 && n2 >= 0 || n < 0 && n2 < 0) {
            return f;
        }
        return -f;
    }

    public static int getExponent(double d) {
        return (int)(Double.doubleToLongBits(d) >>> 52 & 0x7FFL) - 1023;
    }

    public static int getExponent(float f) {
        return (Float.floatToIntBits(f) >>> 23 & 0xFF) - 127;
    }

    static {
        int n;
        EXP_INT_TABLE_A = new double[1500];
        EXP_INT_TABLE_B = new double[1500];
        EXP_FRAC_TABLE_A = new double[1025];
        EXP_FRAC_TABLE_B = new double[1025];
        FACT = new double[20];
        LN_MANT = new double[1024][];
        LN_SPLIT_COEF = new double[][]{{2.0, 0.0}, {0.6666666269302368, 3.9736429850260626E-8}, {0.3999999761581421, 2.3841857910019882E-8}, {0.2857142686843872, 1.7029898543501842E-8}, {0.2222222089767456, 1.3245471311735498E-8}, {0.1818181574344635, 2.4384203044354907E-8}, {0.1538461446762085, 9.140260083262505E-9}, {0.13333332538604736, 9.220590270857665E-9}, {0.11764700710773468, 1.2393345855018391E-8}, {0.10526403784751892, 8.251545029714408E-9}, {0.0952233225107193, 1.2675934823758863E-8}, {0.08713622391223907, 1.1430250008909141E-8}, {0.07842259109020233, 2.404307984052299E-9}, {0.08371849358081818, 1.176342548272881E-8}, {0.03058958f, 1.2958646899018938E-9}, {0.14982303977012634, 1.225743062930824E-8}};
        LN_QUICK_COEF = new double[][]{{1.0, 5.669184079525E-24}, {-0.25, -0.25}, {0.3333333134651184, 1.986821492305628E-8}, {-0.25, -6.663542893624021E-14}, {0.19999998807907104, 1.1921056801463227E-8}, {-0.1666666567325592, -7.800414592973399E-9}, {0.1428571343421936, 5.650007086920087E-9}, {-0.1250253f, -7.44321345601866E-11}, {0.11113807559013367, 9.219544613762692E-9}};
        LN_HI_PREC_COEF = new double[][]{{1.0, -6.032174644509064E-23}, {-0.25, -0.25}, {0.3333333134651184, 1.9868161777724352E-8}, {-0.2499999701976776, -2.957007209750105E-8}, {0.19999954104423523, 1.5830993332061267E-10}, {-0.1662488f, -2.6033824355191673E-8}};
        SINE_TABLE_A = new double[14];
        SINE_TABLE_B = new double[14];
        COSINE_TABLE_A = new double[14];
        COSINE_TABLE_B = new double[14];
        TANGENT_TABLE_A = new double[14];
        TANGENT_TABLE_B = new double[14];
        RECIP_2PI = new long[]{2935890503282001226L, 9154082963658192752L, 3952090531849364496L, 9193070505571053912L, 7910884519577875640L, 113236205062349959L, 4577762542105553359L, -5034868814120038111L, 4208363204685324176L, 5648769086999809661L, 2819561105158720014L, -4035746434778044925L, -302932621132653753L, -2644281811660520851L, -3183605296591799669L, 6722166367014452318L, -3512299194304650054L, -7278142539171889152L};
        PI_O_4_BITS = new long[]{-3958705157555305932L, -4267615245585081135L};
        EIGHTHS = new double[]{0.0, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1.0, 1.125, 1.25, 1.375, 1.5, 1.625};
        CBRTTWO = new double[]{0.6299605249474366, 0.7937005259840998, 1.0, 1.2599210498948732, 1.5874010519681994};
        FastMath.FACT[0] = 1.0;
        for (n = 1; n < FACT.length; ++n) {
            FastMath.FACT[n] = FACT[n - 1] * (double)n;
        }
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        for (n = 0; n < 750; ++n) {
            FastMath.expint(n, dArray);
            FastMath.EXP_INT_TABLE_A[n + 750] = dArray[0];
            FastMath.EXP_INT_TABLE_B[n + 750] = dArray[1];
            if (n == 0) continue;
            FastMath.splitReciprocal(dArray, dArray2);
            FastMath.EXP_INT_TABLE_A[750 - n] = dArray2[0];
            FastMath.EXP_INT_TABLE_B[750 - n] = dArray2[1];
        }
        for (n = 0; n < EXP_FRAC_TABLE_A.length; ++n) {
            FastMath.slowexp((double)n / 1024.0, dArray);
            FastMath.EXP_FRAC_TABLE_A[n] = dArray[0];
            FastMath.EXP_FRAC_TABLE_B[n] = dArray[1];
        }
        for (n = 0; n < LN_MANT.length; ++n) {
            double d = Double.longBitsToDouble((long)n << 42 | 0x3FF0000000000000L);
            FastMath.LN_MANT[n] = FastMath.slowLog(d);
        }
        FastMath.buildSinCosTables();
    }
}

