/*
 * Decompiled with CFR 0.152.
 */
package sprites.utils;

import java.io.Serializable;

public class DVector
implements Serializable {
    private static final long serialVersionUID = -6717872085945400694L;
    public double x;
    public double y;
    public double z;
    protected transient double[] array;

    public DVector() {
    }

    public DVector(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public DVector(double d, double d2) {
        this.x = d;
        this.y = d2;
        this.z = 0.0;
    }

    public void set(double d, double d2, double d3) {
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public void set(DVector dVector) {
        this.x = dVector.x;
        this.y = dVector.y;
        this.z = dVector.z;
    }

    public void set(double[] dArray) {
        if (dArray.length >= 2) {
            this.x = dArray[0];
            this.y = dArray[1];
        }
        if (dArray.length >= 3) {
            this.z = dArray[2];
        }
    }

    public DVector get() {
        return new DVector(this.x, this.y, this.z);
    }

    public double[] get(double[] dArray) {
        if (dArray == null) {
            return new double[]{this.x, this.y, this.z};
        }
        if (dArray.length >= 2) {
            dArray[0] = this.x;
            dArray[1] = this.y;
        }
        if (dArray.length >= 3) {
            dArray[2] = this.z;
        }
        return dArray;
    }

    public double mag() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public double magSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public void add(DVector dVector) {
        this.x += dVector.x;
        this.y += dVector.y;
        this.z += dVector.z;
    }

    public void add(double d, double d2, double d3) {
        this.x += d;
        this.y += d2;
        this.z += d3;
    }

    public static DVector add(DVector dVector, DVector dVector2) {
        return DVector.add(dVector, dVector2, null);
    }

    public static DVector add(DVector dVector, DVector dVector2, DVector dVector3) {
        if (dVector3 == null) {
            dVector3 = new DVector(dVector.x + dVector2.x, dVector.y + dVector2.y, dVector.z + dVector2.z);
        } else {
            dVector3.set(dVector.x + dVector2.x, dVector.y + dVector2.y, dVector.z + dVector2.z);
        }
        return dVector3;
    }

    public void sub(DVector dVector) {
        this.x -= dVector.x;
        this.y -= dVector.y;
        this.z -= dVector.z;
    }

    public void sub(double d, double d2, double d3) {
        this.x -= d;
        this.y -= d2;
        this.z -= d3;
    }

    public static DVector sub(DVector dVector, DVector dVector2) {
        return DVector.sub(dVector, dVector2, null);
    }

    public static DVector sub(DVector dVector, DVector dVector2, DVector dVector3) {
        if (dVector3 == null) {
            dVector3 = new DVector(dVector.x - dVector2.x, dVector.y - dVector2.y, dVector.z - dVector2.z);
        } else {
            dVector3.set(dVector.x - dVector2.x, dVector.y - dVector2.y, dVector.z - dVector2.z);
        }
        return dVector3;
    }

    public void mult(double d) {
        this.x *= d;
        this.y *= d;
        this.z *= d;
    }

    public static DVector mult(DVector dVector, double d) {
        return DVector.mult(dVector, d, null);
    }

    public static DVector mult(DVector dVector, double d, DVector dVector2) {
        if (dVector2 == null) {
            dVector2 = new DVector(dVector.x * d, dVector.y * d, dVector.z * d);
        } else {
            dVector2.set(dVector.x * d, dVector.y * d, dVector.z * d);
        }
        return dVector2;
    }

    public void mult(DVector dVector) {
        this.x *= dVector.x;
        this.y *= dVector.y;
        this.z *= dVector.z;
    }

    public static DVector mult(DVector dVector, DVector dVector2) {
        return DVector.mult(dVector, dVector2, null);
    }

    public static DVector mult(DVector dVector, DVector dVector2, DVector dVector3) {
        if (dVector3 == null) {
            dVector3 = new DVector(dVector.x * dVector2.x, dVector.y * dVector2.y, dVector.z * dVector2.z);
        } else {
            dVector3.set(dVector.x * dVector2.x, dVector.y * dVector2.y, dVector.z * dVector2.z);
        }
        return dVector3;
    }

    public void div(double d) {
        this.x /= d;
        this.y /= d;
        this.z /= d;
    }

    public static DVector div(DVector dVector, double d) {
        return DVector.div(dVector, d, null);
    }

    public static DVector div(DVector dVector, double d, DVector dVector2) {
        if (dVector2 == null) {
            dVector2 = new DVector(dVector.x / d, dVector.y / d, dVector.z / d);
        } else {
            dVector2.set(dVector.x / d, dVector.y / d, dVector.z / d);
        }
        return dVector2;
    }

    public void div(DVector dVector) {
        this.x /= dVector.x;
        this.y /= dVector.y;
        this.z /= dVector.z;
    }

    public static DVector div(DVector dVector, DVector dVector2) {
        return DVector.div(dVector, dVector2, null);
    }

    public static DVector div(DVector dVector, DVector dVector2, DVector dVector3) {
        if (dVector3 == null) {
            dVector3 = new DVector(dVector.x / dVector2.x, dVector.y / dVector2.y, dVector.z / dVector2.z);
        } else {
            dVector3.set(dVector.x / dVector2.x, dVector.y / dVector2.y, dVector.z / dVector2.z);
        }
        return dVector3;
    }

    public double dist(DVector dVector) {
        double d = this.x - dVector.x;
        double d2 = this.y - dVector.y;
        double d3 = this.z - dVector.z;
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public static double dist(DVector dVector, DVector dVector2) {
        double d = dVector.x - dVector2.x;
        double d2 = dVector.y - dVector2.y;
        double d3 = dVector.z - dVector2.z;
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    public double dot(DVector dVector) {
        return this.x * dVector.x + this.y * dVector.y + this.z * dVector.z;
    }

    public double dot(double d, double d2, double d3) {
        return this.x * d + this.y * d2 + this.z * d3;
    }

    public static double dot(DVector dVector, DVector dVector2) {
        return dVector.x * dVector2.x + dVector.y * dVector2.y + dVector.z * dVector2.z;
    }

    public DVector cross(DVector dVector) {
        return this.cross(dVector, null);
    }

    public DVector cross(DVector dVector, DVector dVector2) {
        double d = this.y * dVector.z - dVector.y * this.z;
        double d2 = this.z * dVector.x - dVector.z * this.x;
        double d3 = this.x * dVector.y - dVector.x * this.y;
        if (dVector2 == null) {
            dVector2 = new DVector(d, d2, d3);
        } else {
            dVector2.set(d, d2, d3);
        }
        return dVector2;
    }

    public static DVector cross(DVector dVector, DVector dVector2, DVector dVector3) {
        double d = dVector.y * dVector2.z - dVector2.y * dVector.z;
        double d2 = dVector.z * dVector2.x - dVector2.z * dVector.x;
        double d3 = dVector.x * dVector2.y - dVector2.x * dVector.y;
        if (dVector3 == null) {
            dVector3 = new DVector(d, d2, d3);
        } else {
            dVector3.set(d, d2, d3);
        }
        return dVector3;
    }

    public void normalize() {
        double d = this.mag();
        if (d != 0.0 && d != 1.0) {
            this.div(d);
        }
    }

    public DVector normalize(DVector dVector) {
        double d;
        if (dVector == null) {
            dVector = new DVector();
        }
        if ((d = this.mag()) > 0.0) {
            dVector.set(this.x / d, this.y / d, this.z / d);
        } else {
            dVector.set(this.x, this.y, this.z);
        }
        return dVector;
    }

    public void limit(double d) {
        if (this.mag() > d) {
            this.normalize();
            this.mult(d);
        }
    }

    public void setMag(double d) {
        this.normalize();
        this.mult(d);
    }

    public DVector setMag(DVector dVector, double d) {
        dVector = this.normalize(dVector);
        dVector.mult(d);
        return dVector;
    }

    public double heading2D() {
        double d = Math.atan2(-this.y, this.x);
        return -1.0 * d;
    }

    public void rotate(double d) {
        double d2 = this.x;
        this.x = this.x * Math.cos(d) - this.y * Math.sin(d);
        this.y = d2 * Math.sin(d) + this.y * Math.cos(d);
    }

    public void lerp(DVector dVector, double d) {
        this.x = this.lerp(this.x, dVector.x, d);
        this.y = this.lerp(this.y, dVector.y, d);
    }

    public void lerp(double d, double d2, double d3, double d4) {
        this.x = this.lerp(this.x, d, d4);
        this.y = this.lerp(this.y, d2, d4);
    }

    public double lerp(double d, double d2, double d3) {
        return d + (d2 - d) * d3;
    }

    public static double angleBetween(DVector dVector, DVector dVector2) {
        double d;
        double d2 = dVector.x * dVector2.x + dVector.y * dVector2.y + dVector.z * dVector2.z;
        double d3 = Math.sqrt(dVector.x * dVector.x + dVector.y * dVector.y + dVector.z * dVector.z);
        double d4 = d2 / (d3 * (d = Math.sqrt(dVector2.x * dVector2.x + dVector2.y * dVector2.y + dVector2.z * dVector2.z)));
        if (d4 <= -1.0) {
            return 3.1415927410125732;
        }
        if (d4 >= 1.0) {
            return 0.0;
        }
        return Math.acos(d4);
    }

    public String toString() {
        return "[ " + this.x + ", " + this.y + ", " + this.z + " ]";
    }

    public double[] array() {
        if (this.array == null) {
            this.array = new double[3];
        }
        this.array[0] = this.x;
        this.array[1] = this.y;
        this.array[2] = this.z;
        return this.array;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DVector)) {
            return false;
        }
        DVector dVector = (DVector)object;
        return this.x == dVector.x && this.y == dVector.y && this.z == dVector.z;
    }

    public int hashCode() {
        long l = 1L;
        l = 31L * l + Double.doubleToLongBits(this.x);
        l = 31L * l + Double.doubleToLongBits(this.y);
        l = 31L * l + Double.doubleToLongBits(this.z);
        return (int)l;
    }
}

