/*
 * Decompiled with CFR 0.152.
 */
package sprites;

import java.lang.reflect.Method;
import java.util.Comparator;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;
import processing.event.MouseEvent;
import sprites.Domain;
import sprites.ImageInfo;
import sprites.S4P;
import sprites.SConstants;
import sprites.SMessenger;
import sprites.maths.PointD2D;
import sprites.maths.Vector2D;

public class Sprite
implements PConstants,
SConstants,
Cloneable {
    public PApplet app;
    public static final int HALT = 0;
    public static final int REBOUND = 1;
    public static int ALPHALEVEL = 20;
    protected static Sprite focusIsWith;
    protected int mdx = Integer.MAX_VALUE;
    protected int mdy = Integer.MAX_VALUE;
    protected double moffX;
    protected double moffY;
    protected Vector2D pos = new Vector2D();
    protected Vector2D vel = new Vector2D();
    protected Vector2D acc = new Vector2D();
    protected double rot;
    protected double mass = 1.0;
    protected double elasticity = 1.0;
    protected double friction = 0.0;
    protected double scale = 1.0;
    protected double colRadius;
    protected boolean dead = false;
    protected boolean visible = true;
    protected Domain domain = null;
    protected int domainAction = 1;
    protected double animInterval;
    protected double animTime;
    protected int animDir = 0;
    protected int frameCurrent = 0;
    protected int frameBegin = 0;
    protected int frameEnd = 0;
    protected int nbrRepeats = Integer.MAX_VALUE;
    protected PImage[] frames;
    protected PImage[] colFrames = null;
    protected ImageInfo info;
    protected double halfWidth;
    protected double width;
    protected double halfHeight;
    protected double height;
    protected int hit_x;
    protected int hit_y;
    protected int[] nbrPixels = null;
    protected Object eventHandlerObject = null;
    protected Method eventHandlerMethod = null;
    protected String eventHandlerMethodName;
    public int eventType = 0;
    protected boolean respondsToMouseEvents = false;
    private boolean beingDragged = false;
    protected boolean draggable = false;
    protected Integer zOrder = 0;
    static Z_Order zSorter;
    public Object tag = null;
    public int tagNo = 0;

    public Sprite(PApplet pApplet, String string, int n) {
        this(pApplet, string, n, true);
    }

    public Sprite(PApplet pApplet, String string, int n, boolean bl) {
        this.app = pApplet;
        this.info = S4P.getImageInfo(this.app, string, 1, 1);
        this.ctorCore(string, 1, 1, n, bl);
    }

    public Sprite(PApplet pApplet, String string, String string2, int n) {
        this(pApplet, string, string2, n, true);
    }

    public Sprite(PApplet pApplet, String string, String string2, int n, boolean bl) {
        this.app = pApplet;
        this.info = S4P.getImageInfo(this.app, string, string2, 1, 1);
        this.ctorCore(string, 1, 1, n, bl);
    }

    public Sprite(PApplet pApplet, String string, int n, int n2, int n3) {
        this(pApplet, string, n, n2, n3, true);
    }

    public Sprite(PApplet pApplet, String string, int n, int n2, int n3, boolean bl) {
        this.app = pApplet;
        this.info = S4P.getImageInfo(this.app, string, n, n2);
        this.ctorCore(string, n, n2, n3, bl);
    }

    public Sprite(PApplet pApplet, String string, String string2, int n, int n2, int n3) {
        this(pApplet, string, string2, n, n2, n3, true);
    }

    public Sprite(PApplet pApplet, String string, String string2, int n, int n2, int n3, boolean bl) {
        this.app = pApplet;
        this.info = S4P.getImageInfo(this.app, string, string2, n, n2);
        this.ctorCore(string, n, n2, n3, bl);
    }

    private void ctorCore(String string, int n, int n2, int n3, boolean bl) {
        this.frames = S4P.getFrames(this.info);
        this.width = this.frames[0].width;
        this.height = this.frames[0].height;
        this.halfWidth = this.width / 2.0;
        this.halfHeight = this.height / 2.0;
        this.colRadius = (this.width + this.height) / 4.0;
        this.zOrder = n3;
        if (bl) {
            S4P.registerSprite(this);
        }
    }

    protected void calcCollisionImage() {
        this.colFrames = new PImage[this.frames.length];
        for (int i = 0; i < this.colFrames.length; ++i) {
            this.colFrames[i] = new PImage((int)this.width, (int)this.height, 2);
            this.colFrames[i].loadPixels();
            this.frames[i].loadPixels();
            for (int j = 0; j < this.frames[i].pixels.length; ++j) {
                this.colFrames[i].pixels[j] = this.app.alpha(this.frames[i].pixels[j]) < (float)ALPHALEVEL ? 0 : S4P.colColor;
            }
            this.colFrames[i].updatePixels();
        }
    }

    protected void calcOpaquePixelCount() {
        this.nbrPixels = new int[this.frames.length];
        for (int i = 0; i < this.nbrPixels.length; ++i) {
            this.frames[i].loadPixels();
            for (int j = 0; j < this.frames[i].pixels.length; ++j) {
                if (!(this.app.alpha(this.frames[i].pixels[j]) > (float)ALPHALEVEL)) continue;
                int n = i;
                this.nbrPixels[n] = this.nbrPixels[n] + 1;
            }
            this.frames[i].updatePixels();
        }
    }

    public void respondToMouse(boolean bl) {
        if (this.respondsToMouseEvents != bl) {
            this.respondsToMouseEvents = bl;
            if (this.respondsToMouseEvents) {
                this.app.registerMethod("mouseEvent", (Object)this);
                if (this.eventHandlerObject == null) {
                    this.createEventHandler(this.app, "handleSpriteEvents", new Class[]{Sprite.class});
                }
            } else {
                this.app.unregisterMethod("mouseEvent", (Object)this);
            }
        }
    }

    protected void createEventHandler(Object object, String string, Class[] classArray) {
        try {
            this.eventHandlerMethod = object.getClass().getMethod(string, classArray);
            this.eventHandlerObject = object;
            this.eventHandlerMethodName = string;
        }
        catch (Exception exception) {
            SMessenger.message(0x1000001, this, new Object[]{string, classArray});
            this.eventHandlerObject = null;
        }
    }

    public void addEventHandler(Object object, String string) {
        try {
            this.eventHandlerObject = object;
            this.eventHandlerMethodName = string;
            this.eventHandlerMethod = object.getClass().getMethod(string, this.getClass());
        }
        catch (Exception exception) {
            SMessenger.message(0x1000002, this, new Object[]{string, new Class[]{this.getClass()}});
            this.eventHandlerObject = null;
            this.eventHandlerMethodName = "";
        }
    }

    protected void fireEvent() {
        if (this.eventHandlerMethod != null) {
            try {
                this.eventHandlerMethod.invoke(this.eventHandlerObject, this);
            }
            catch (Exception exception) {
                SMessenger.message(-2130706429, this.eventHandlerObject, new Object[]{this.eventHandlerMethodName, exception});
            }
        }
    }

    public void restoreImages() {
        this.frames = S4P.getFrames(this.info);
    }

    public void update(double d) {
        if (!this.dead) {
            this.updatePosition(d);
            this.updateImageAnimation(d);
        }
    }

    protected void updatePosition(double d) {
        this.vel.x += this.acc.x * d;
        this.vel.y += this.acc.y * d;
        this.pos.x += this.vel.x * d;
        this.pos.y += this.vel.y * d;
        if (this.domain != null) {
            this.keepInsideDomain();
        }
    }

    public boolean isOnScreem() {
        return !(this.pos.x + this.width * this.scale < S4P.screenDomain.left || this.pos.x - this.width * this.scale > S4P.screenDomain.right || this.pos.y + this.height * this.scale < S4P.screenDomain.top) && !(this.pos.y - this.height * this.scale > S4P.screenDomain.bottom);
    }

    protected void updateImageAnimation(double d) {
        if (this.animInterval > 0.0 && this.nbrRepeats > 0) {
            this.animTime += d;
            while (this.animTime > this.animInterval) {
                this.animTime -= this.animInterval;
                this.frameCurrent += this.animDir;
                if (this.animDir == 1 && this.frameCurrent > this.frameEnd) {
                    this.frameCurrent = this.frameBegin;
                    --this.nbrRepeats;
                    continue;
                }
                if (this.animDir != -1 || this.frameCurrent >= this.frameEnd) continue;
                this.frameCurrent = this.frameBegin;
                --this.nbrRepeats;
            }
            if (this.nbrRepeats <= 0) {
                this.nbrRepeats = 0;
                this.animInterval = 0.0;
            }
        }
    }

    protected void keepInsideDomain() {
        double d = this.width * this.scale * 0.5;
        double d2 = this.height * this.scale * 0.5;
        switch (this.domainAction) {
            case 1: {
                if (this.pos.x - d < this.domain.left && this.vel.x < 0.0) {
                    this.vel.x = Math.abs(this.vel.x);
                    this.acc.x = -this.acc.x;
                } else if (this.pos.x + d > this.domain.right && this.vel.x > 0.0) {
                    this.vel.x = -Math.abs(this.vel.x);
                    this.acc.x = -this.acc.x;
                }
                if (this.pos.y - d2 < this.domain.top && this.vel.y < 0.0) {
                    this.vel.y = Math.abs(this.vel.y);
                    this.acc.y = -this.acc.y;
                    break;
                }
                if (!(this.pos.y + d2 > this.domain.bottom) || !(this.vel.y > 0.0)) break;
                this.vel.y = -Math.abs(this.vel.y);
                this.acc.y = -this.acc.y;
                break;
            }
            case 0: {
                if (this.pos.x - d < this.domain.left) {
                    this.pos.x = this.domain.left + d;
                    this.acc.y = 0.0;
                    this.acc.x = 0.0;
                    this.vel.y = 0.0;
                    this.vel.x = 0.0;
                } else if (this.pos.x + d > this.domain.right) {
                    this.pos.x = this.domain.right - d;
                    this.acc.y = 0.0;
                    this.acc.x = 0.0;
                    this.vel.y = 0.0;
                    this.vel.x = 0.0;
                }
                if (this.pos.y - d2 < this.domain.top) {
                    this.pos.y = this.domain.top + d2;
                    this.acc.y = 0.0;
                    this.acc.x = 0.0;
                    this.vel.y = 0.0;
                    this.vel.x = 0.0;
                    break;
                }
                if (!(this.pos.y + d2 > this.domain.bottom)) break;
                this.pos.y = this.domain.bottom - d2;
                this.acc.y = 0.0;
                this.acc.x = 0.0;
                this.vel.y = 0.0;
                this.vel.x = 0.0;
            }
        }
    }

    public void setDomain(double d, double d2, double d3, double d4, int n) {
        this.domain = new Domain(d, d2, d3, d4);
        this.domainAction = n;
    }

    public void setDomain(Domain domain, int n) {
        this.domain = domain;
        this.domainAction = n;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void clearDomain() {
        this.domain = null;
        this.domainAction = 1;
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        if (!this.visible || this.dead) {
            return;
        }
        boolean bl = this.isOver(this.app.mouseX, this.app.mouseY);
        switch (mouseEvent.getAction()) {
            case 1: {
                if (!bl || focusIsWith != null && (focusIsWith == null || this.zOrder <= Sprite.focusIsWith.zOrder)) break;
                this.mdx = this.app.mouseX;
                this.mdy = this.app.mouseY;
                this.moffX = this.pos.x - (double)this.mdx;
                this.moffY = this.pos.y - (double)this.mdy;
                focusIsWith = this;
                this.eventType = 1;
                this.fireEvent();
                this.beingDragged = true;
                break;
            }
            case 3: {
                if (focusIsWith != this) break;
                focusIsWith = null;
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
                this.eventType = 3;
                this.fireEvent();
                break;
            }
            case 2: {
                if (focusIsWith != this || !this.mouseHasMoved(this.app.mouseX, this.app.mouseY)) break;
                this.mdy = Integer.MAX_VALUE;
                this.mdx = Integer.MAX_VALUE;
                focusIsWith = null;
                this.beingDragged = false;
                this.eventType = 2;
                this.fireEvent();
                break;
            }
            case 4: {
                if (focusIsWith != this || !this.draggable) break;
                this.beingDragged = true;
                PointD2D pointD2D = S4P.pixel2world((double)this.app.mouseX + this.moffX, (double)this.app.mouseY + this.moffY);
                this.pos.x = pointD2D.x;
                this.pos.y = pointD2D.y;
                this.eventType = 4;
                this.fireEvent();
            }
        }
    }

    public void draw() {
        if (this.visible && !this.dead) {
            this.app.pushMatrix();
            this.app.imageMode(3);
            this.app.translate((float)this.pos.x, (float)this.pos.y);
            this.app.scale((float)this.scale);
            this.app.rotate((float)this.rot);
            this.app.image(this.frames[this.frameCurrent], 0.0f, 0.0f, (float)this.width, (float)this.height);
            if (S4P.collisionAreasVisible) {
                this.drawCollisionArea();
            }
            this.app.popMatrix();
        }
    }

    protected void drawCollisionArea() {
        this.app.pushStyle();
        this.app.imageMode(3);
        this.app.noStroke();
        this.app.fill(S4P.colColor);
        if (this.isOver(this.app.mouseX, this.app.mouseY)) {
            this.app.tint(this.app.red(S4P.selColor), this.app.green(S4P.selColor), this.app.blue(S4P.selColor), 255.0f);
            this.app.fill(S4P.selColor);
        }
        if (this.rot != 0.0) {
            this.app.ellipseMode(3);
            this.app.ellipse(0.0f, 0.0f, (float)this.colRadius * 2.0f, (float)this.colRadius * 2.0f);
        } else if (this.scale != 1.0) {
            this.app.rectMode(3);
            this.app.rect(0.0f, 0.0f, (float)this.width, (float)this.height);
        } else {
            if (this.colFrames == null) {
                this.calcCollisionImage();
            }
            this.app.image(this.colFrames[this.frameCurrent], 0.0f, 0.0f, (float)this.width, (float)this.height);
        }
        this.app.popStyle();
    }

    protected boolean mouseHasMoved(int n, int n2) {
        return this.mdx != n || this.mdy != n2;
    }

    public boolean isOver(int n, int n2) {
        PointD2D pointD2D = S4P.pixel2world(n, n2);
        if (this.rot != 0.0) {
            return (pointD2D.x - this.pos.x) * (pointD2D.x - this.pos.x) + (pointD2D.y - this.pos.y) * (pointD2D.y - this.pos.y) < this.colRadius * this.colRadius * this.scale * this.scale;
        }
        if (this.scale != 1.0) {
            return pointD2D.x > this.pos.x - this.halfWidth * this.scale && pointD2D.x < this.pos.x + this.halfWidth * this.scale && pointD2D.y > this.pos.y - this.halfHeight * this.scale && pointD2D.y < this.pos.y + this.halfHeight * this.scale;
        }
        if (Math.abs(pointD2D.x - this.pos.x) < this.halfWidth && Math.abs(pointD2D.y - this.pos.y) < this.halfHeight) {
            PImage pImage = this.frames[this.frameCurrent];
            int n3 = (int)(pointD2D.x - this.pos.x + this.halfWidth);
            int n4 = (int)(pointD2D.y - this.pos.y + this.halfHeight);
            int n5 = n4 * pImage.width + n3;
            pImage.loadPixels();
            if (this.app.alpha(pImage.pixels[n5]) > (float)ALPHALEVEL) {
                return true;
            }
        }
        return false;
    }

    public boolean cc_collision(Sprite sprite) {
        if (!this.visible || !sprite.visible) {
            return false;
        }
        double d = (this.pos.x - sprite.pos.x) * (this.pos.x - sprite.pos.x) + (this.pos.y - sprite.pos.y) * (this.pos.y - sprite.pos.y);
        return (d -= (this.colRadius * this.scale + sprite.colRadius * sprite.scale) * (this.colRadius * this.scale + sprite.colRadius * sprite.scale)) < 0.0;
    }

    public boolean oop_collision(Sprite sprite, float f) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (!this.visible || !sprite.visible) {
            return false;
        }
        if (this.rot != 0.0 || sprite.rot != 0.0 || this.scale != 1.0 || sprite.scale != 1.0) {
            return this.bb_collision(sprite);
        }
        int n8 = (int)(this.pos.y - this.halfHeight);
        int n9 = (int)(this.pos.y + this.halfHeight);
        int n10 = (int)(this.pos.x - this.halfWidth);
        int n11 = (int)(this.pos.x + this.halfWidth);
        int n12 = (int)(sprite.pos.y - sprite.halfHeight);
        int n13 = (int)(sprite.pos.y + sprite.halfHeight);
        int n14 = (int)(sprite.pos.x - sprite.halfWidth);
        int n15 = (int)(sprite.pos.x + sprite.halfWidth);
        if (n9 <= n12 || n13 <= n8 || n11 <= n14 || n15 <= n10) {
            return false;
        }
        if (this.nbrPixels == null) {
            this.calcOpaquePixelCount();
        }
        if ((n7 = (n6 = (n5 = n11 > n15 ? n15 : n11) - (n4 = n10 < n14 ? n14 : n10)) * ((n3 = n9 > n13 ? n13 : n9) - (n2 = n8 < n12 ? n12 : n8))) < (n = (int)((double)((float)this.nbrPixels[this.frameCurrent] * f) / 100.0))) {
            System.out.println("FALSE " + n7 + " " + n);
            return false;
        }
        int n16 = n4 - n10;
        int n17 = n2 - n8;
        int n18 = n5 - n10;
        int n19 = n3 - n8 - 1;
        int n20 = n4 - n14;
        int n21 = n2 - n12;
        int n22 = n5 - n14;
        int n23 = n3 - n12 - 1;
        int n24 = 0;
        int n25 = n7;
        PImage pImage = this.frames[this.frameCurrent];
        PImage pImage2 = sprite.frames[sprite.frameCurrent];
        pImage.loadPixels();
        pImage2.loadPixels();
        int n26 = this.frames[this.frameCurrent].width;
        int n27 = sprite.frames[sprite.frameCurrent].width;
        boolean bl = true;
        boolean bl2 = true;
        int n28 = n17 * n26 + n16;
        int n29 = n21 * n27 + n20;
        int n30 = n16;
        int n31 = n17;
        int n32 = n20;
        int n33 = n21;
        for (n31 = n17; n31 < n19; ++n31) {
            n32 = n20;
            for (n30 = n16; n30 < n18; ++n30) {
                bl = this.app.alpha(pImage.pixels[n28]) < (float)ALPHALEVEL;
                bl2 = this.app.alpha(pImage2.pixels[n29]) < (float)ALPHALEVEL;
                --n25;
                if (!bl && !bl2) {
                    if (++n24 >= n) {
                        return true;
                    }
                } else if (n24 + n25 < n) {
                    return false;
                }
                ++n28;
                ++n29;
                ++n32;
            }
            n28 = n28 + n26 - n6;
            n29 = n29 + n27 - n6;
            ++n33;
        }
        return false;
    }

    public boolean pp_collision(Sprite sprite) {
        if (!this.visible || !sprite.visible) {
            return false;
        }
        if (this.rot != 0.0 || sprite.rot != 0.0 || this.scale != 1.0 || sprite.scale != 1.0) {
            return this.bb_collision(sprite);
        }
        int n = (int)(this.pos.y - this.halfHeight);
        int n2 = (int)(this.pos.y + this.halfHeight);
        int n3 = (int)(this.pos.x - this.halfWidth);
        int n4 = (int)(this.pos.x + this.halfWidth);
        int n5 = (int)(sprite.pos.y - sprite.halfHeight);
        int n6 = (int)(sprite.pos.y + sprite.halfHeight);
        int n7 = (int)(sprite.pos.x - sprite.halfWidth);
        int n8 = (int)(sprite.pos.x + sprite.halfWidth);
        if (n2 <= n5 || n6 <= n || n4 <= n7 || n8 <= n3) {
            return false;
        }
        int n9 = n3 < n7 ? n7 : n3;
        int n10 = n4 > n8 ? n8 : n4;
        int n11 = n2 > n6 ? n6 : n2;
        int n12 = n < n5 ? n5 : n;
        int n13 = n9 - n3;
        int n14 = n12 - n;
        int n15 = n10 - n3;
        int n16 = n11 - n - 1;
        int n17 = n9 - n7;
        int n18 = n12 - n5;
        int n19 = n10 - n7;
        int n20 = n11 - n5 - 1;
        int n21 = n10 - n9;
        boolean bl = false;
        PImage pImage = this.frames[this.frameCurrent];
        PImage pImage2 = sprite.frames[sprite.frameCurrent];
        pImage.loadPixels();
        pImage2.loadPixels();
        int n22 = this.frames[this.frameCurrent].width;
        int n23 = sprite.frames[sprite.frameCurrent].width;
        boolean bl2 = true;
        boolean bl3 = true;
        int n24 = n14 * n22 + n13;
        int n25 = n18 * n23 + n17;
        int n26 = n13;
        int n27 = n14;
        int n28 = n17;
        int n29 = n18;
        for (n27 = n14; n27 < n16; ++n27) {
            n28 = n17;
            for (n26 = n13; n26 < n15; ++n26) {
                bl2 = this.app.alpha(pImage.pixels[n24]) < (float)ALPHALEVEL;
                boolean bl4 = bl3 = this.app.alpha(pImage2.pixels[n25]) < (float)ALPHALEVEL;
                if (!bl2 && !bl3) {
                    this.hit_x = n26;
                    this.hit_y = n27;
                    sprite.setHitXY(n28, n29);
                    bl = true;
                    break;
                }
                ++n24;
                ++n25;
                ++n28;
            }
            if (bl) break;
            n24 = n24 + n22 - n21;
            n25 = n25 + n23 - n21;
            ++n29;
        }
        return bl;
    }

    public boolean oo_collision(Sprite sprite, float f) {
        if (!this.visible || !sprite.visible) {
            return false;
        }
        if (this.rot != 0.0 || sprite.rot != 0.0) {
            return this.cc_collision(sprite);
        }
        int n = (int)(this.pos.y - this.halfHeight * this.scale);
        int n2 = (int)(this.pos.y + this.halfHeight * this.scale);
        int n3 = (int)(this.pos.x - this.halfWidth * this.scale);
        int n4 = (int)(this.pos.x + this.halfWidth * this.scale);
        int n5 = (int)(sprite.pos.y - sprite.halfHeight * sprite.scale);
        int n6 = (int)(sprite.pos.y + sprite.halfHeight * sprite.scale);
        int n7 = (int)(sprite.pos.x - sprite.halfWidth * sprite.scale);
        int n8 = (int)(sprite.pos.x + sprite.halfWidth * sprite.scale);
        if (n2 <= n5 || n6 <= n || n4 <= n7 || n8 <= n3) {
            return false;
        }
        int n9 = n3 < n7 ? n7 : n3;
        int n10 = n4 > n8 ? n8 : n4;
        int n11 = n2 > n6 ? n6 : n2;
        int n12 = n < n5 ? n5 : n;
        float f2 = (float)((n10 - n9) * (n11 - n12)) * 100.0f / (float)((n4 - n3) * (n2 - n));
        return f2 > f;
    }

    public boolean bb_collision(Sprite sprite) {
        if (!this.visible || !sprite.visible) {
            return false;
        }
        if (this.rot != 0.0 || sprite.rot != 0.0) {
            return this.cc_collision(sprite);
        }
        int n = (int)(this.pos.y - this.halfHeight * this.scale);
        int n2 = (int)(this.pos.y + this.halfHeight * this.scale);
        int n3 = (int)(this.pos.x - this.halfWidth * this.scale);
        int n4 = (int)(this.pos.x + this.halfWidth * this.scale);
        int n5 = (int)(sprite.pos.y - sprite.halfHeight * sprite.scale);
        int n6 = (int)(sprite.pos.y + sprite.halfHeight * sprite.scale);
        int n7 = (int)(sprite.pos.x - sprite.halfWidth * sprite.scale);
        int n8 = (int)(sprite.pos.x + sprite.halfWidth * sprite.scale);
        return n2 > n5 && n6 > n && n4 > n7 && n8 > n3;
    }

    public void bite(int n) {
        this.bite(this.hit_x, this.hit_y, n);
    }

    public void bite(int n, int n2, int n3) {
        int n4 = n - n3;
        int n5 = n2 - n3;
        int n6 = n + n3;
        int n7 = n2 + n3;
        if (n4 < 0) {
            n4 = 0;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if ((double)n6 >= this.width) {
            n6 = (int)this.width;
        }
        if ((double)n7 >= this.height) {
            n7 = (int)this.height;
        }
        int n8 = n3 * n3;
        int n9 = (int)this.width;
        for (int i = 0; i < this.frames.length; ++i) {
            this.frames[i].loadPixels();
            for (int j = n4; j < n6; ++j) {
                for (int k = n5; k < n7; ++k) {
                    if ((j - n) * (j - n) + (k - n2) * (k - n2) > n8) continue;
                    int n10 = j + k * n9;
                    this.frames[i].pixels[n10] = this.frames[i].pixels[n10] & 0xFFFFFF;
                }
            }
            this.frames[i].updatePixels();
        }
    }

    protected void setHitXY(int n, int n2) {
        this.hit_x = n;
        this.hit_y = n2;
    }

    public int getHitX() {
        return this.hit_x;
    }

    public int getHitY() {
        return this.hit_y;
    }

    public PointD2D getHitXY() {
        return new PointD2D(this.hit_x, this.hit_y);
    }

    public void setAnimInterval(double d) {
        this.animTime = 0.0;
        this.nbrRepeats = Integer.MAX_VALUE;
        this.animInterval = d;
    }

    public void setAnimInterval(double d, int n) {
        this.animTime = 0.0;
        this.nbrRepeats = n;
        this.animInterval = d;
    }

    public void setFrameSequence(int n, int n2) {
        this.frameBegin = PApplet.constrain((int)n, (int)0, (int)(this.frames.length - 1));
        this.frameEnd = PApplet.constrain((int)n2, (int)0, (int)(this.frames.length - 1));
        if (this.frameEnd > this.frameBegin) {
            this.animDir = 1;
            this.frameCurrent = PApplet.constrain((int)this.frameCurrent, (int)this.frameBegin, (int)this.frameEnd);
        } else {
            this.animDir = -1;
            this.frameCurrent = PApplet.constrain((int)this.frameCurrent, (int)this.frameEnd, (int)this.frameBegin);
        }
    }

    public void setFrameSequence(int n, int n2, double d) {
        this.setFrameSequence(n, n2);
        this.animInterval = d;
    }

    public void setFrameSequence(int n, int n2, double d, int n3) {
        this.setFrameSequence(n, n2);
        this.nbrRepeats = n3;
        this.animInterval = d;
    }

    public void stopImageAnim() {
        this.animInterval = 0.0;
    }

    public boolean isImageAnimating() {
        return this.animInterval > 0.0;
    }

    public void setFrame(int n) {
        this.animInterval = 0.0;
        this.frameCurrent = PApplet.constrain((int)n, (int)0, (int)this.frames.length);
    }

    public int getFrame() {
        return this.frameCurrent;
    }

    public void setSpeed(double d) {
        double d2 = Math.sqrt(this.vel.x * this.vel.x + this.vel.y * this.vel.y);
        if (d2 == 0.0) {
            this.setSpeed(d, this.rot);
        } else {
            double d3 = d / d2;
            this.vel.x *= d3;
            this.vel.y *= d3;
        }
    }

    public void setSpeed(double d, double d2) {
        this.vel.x = d * Math.cos(d2);
        this.vel.y = d * Math.sin(d2);
    }

    public double getSpeed() {
        return Math.sqrt(this.vel.x * this.vel.x + this.vel.y * this.vel.y);
    }

    public void setAcceleration(double d) {
        double d2 = Math.sqrt(this.vel.x * this.vel.x + this.vel.y * this.vel.y);
        if (d2 == 0.0) {
            this.setAcceleration(d, this.rot);
        } else {
            this.setAcceleration(d, Math.atan2(this.vel.y, this.vel.x));
        }
    }

    public void setAcceleration(double d, double d2) {
        this.acc.x = d * Math.cos(d2);
        this.acc.y = d * Math.sin(d2);
    }

    public double getAcceleration() {
        return Math.sqrt(this.acc.x * this.acc.x + this.acc.y * this.acc.y);
    }

    public void setDirection(double d) {
        double d2 = Math.sqrt(this.vel.x * this.vel.x + this.vel.y * this.vel.y);
        this.setSpeed(d2, d);
        double d3 = Math.sqrt(this.acc.x * this.acc.x + this.acc.y * this.acc.y);
        this.setAcceleration(d3, d);
    }

    public double getDirection() {
        return Math.atan2(this.vel.y, this.vel.x);
    }

    public void setRot(double d) {
        this.rot = d;
    }

    public double getRot() {
        return this.rot;
    }

    public void setScale(double d) {
        this.scale = d;
    }

    public double getScale() {
        return this.scale;
    }

    public void setXY(double d, double d2) {
        this.pos.x = d;
        this.pos.y = d2;
    }

    public void setPos(Vector2D vector2D) {
        this.pos.x = vector2D.x;
        this.pos.y = vector2D.y;
    }

    public Vector2D getPos() {
        return this.pos;
    }

    public void setX(double d) {
        this.pos.x = d;
    }

    public double getX() {
        return this.pos.x;
    }

    public void setY(double d) {
        this.pos.y = d;
    }

    public double getY() {
        return this.pos.y;
    }

    public double getHeight() {
        return this.height * this.scale;
    }

    public double getWidth() {
        return this.width * this.scale;
    }

    public void setVelXY(double d, double d2) {
        this.vel.x = d;
        this.vel.y = d2;
    }

    public void setVelX(double d) {
        this.vel.x = d;
    }

    public double getVelX() {
        return this.vel.x;
    }

    public void setVelY(double d) {
        this.vel.y = d;
    }

    public double getVelY() {
        return this.vel.y;
    }

    public void setAccXY(double d, double d2) {
        this.acc.x = d;
        this.acc.y = d2;
    }

    public void setAccX(double d) {
        this.acc.x = d;
    }

    public double getAccX() {
        return this.acc.x;
    }

    public void setAccY(double d) {
        this.acc.y = d;
    }

    public double getAccY() {
        return this.acc.y;
    }

    public void setCollisionRadius(double d) {
        this.colRadius = d;
    }

    public double getCollisionRadius() {
        return this.colRadius;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double d) {
        this.mass = d;
    }

    public double getElasticity() {
        return this.elasticity;
    }

    public void setElasticity(double d) {
        this.elasticity = d;
    }

    public double getFriction() {
        return this.friction;
    }

    public void setFriction(double d) {
        this.friction = d;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setZorder(int n) {
        this.zOrder = n;
        S4P.sortZorder();
    }

    public void setZorder(int n, boolean bl) {
        this.zOrder = n;
        if (bl) {
            S4P.sortZorder();
        }
    }

    public int getZorder() {
        return this.zOrder;
    }

    public boolean isBeingDragged() {
        return this.beingDragged;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setDraggable(boolean bl) {
        this.draggable = bl;
    }

    public void setDead(boolean bl) {
        this.dead = bl;
    }

    public boolean isDead() {
        return this.dead;
    }

    static {
        zSorter = new Z_Order();
    }

    public static class Z_Order
    implements Comparator<Sprite> {
        @Override
        public int compare(Sprite sprite, Sprite sprite2) {
            return sprite.zOrder.compareTo(sprite2.zOrder);
        }
    }
}

