/*
 * Decompiled with CFR 0.152.
 */
package sprites;

import java.awt.Point;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PImage;
import sprites.Domain;
import sprites.ImageInfo;
import sprites.Sprite;
import sprites.maths.PointD2D;
import sprites.maths.Vector2D;

public class S4P
implements PConstants {
    private static HashMap<Integer, ImageInfo> imageStore = new HashMap();
    private static LinkedList<Sprite> sprites = new LinkedList();
    private static HashSet<Sprite> toAdd = new HashSet();
    private static HashSet<Sprite> toRemove = new HashSet();
    private static PApplet app;
    public static boolean messages;
    public static boolean collisionAreasVisible;
    public static int colColor;
    public static int selColor;
    public static Domain screenDomain;
    protected static double worldX;
    protected static double worldY;
    protected static double worldScale;

    public static void resizeWorld(double d) {
        double d2 = S4P.app.width;
        double d3 = S4P.app.height;
        double d4 = worldX + d2 / (2.0 * worldScale) - d2 / (2.0 * d);
        double d5 = worldY + d3 / (2.0 * worldScale) - d3 / (2.0 * d);
        worldX = d4;
        worldY = d5;
        worldScale = d;
        S4P.calcScreenDomain();
    }

    protected static void calcScreenDomain() {
        S4P.screenDomain.left = worldX;
        S4P.screenDomain.right = worldX + (double)S4P.app.width / worldScale;
        S4P.screenDomain.top = worldY;
        S4P.screenDomain.bottom = worldY + (double)S4P.app.height / worldScale;
    }

    public static void resetWorld() {
        worldScale = 1.0;
        worldX = 0.0;
        worldY = 0.0;
        S4P.calcScreenDomain();
    }

    public static PointD2D pixel2world(double d, double d2) {
        PointD2D pointD2D = new PointD2D();
        pointD2D.x = worldX + d / worldScale;
        pointD2D.y = worldY + d2 / worldScale;
        return pointD2D;
    }

    public static Point world2pixel(double d, double d2) {
        Point point = new Point();
        point.x = (int)((d - worldX) * worldScale);
        point.y = (int)((d2 - worldY) * worldScale);
        return point;
    }

    public static void moveWorldTo(double d, double d2) {
        worldX = d;
        worldY = d2;
        S4P.calcScreenDomain();
    }

    public static void moveWorldBy(double d, double d2) {
        worldX += d;
        worldY += d2;
        S4P.calcScreenDomain();
    }

    public static void registerSprite(Sprite sprite) {
        if (sprite != null) {
            toAdd.add(sprite);
        }
    }

    public static void deregisterSprite(Sprite sprite) {
        if (sprite != null) {
            toRemove.remove(sprite);
        }
    }

    public static void sortZorder() {
        Collections.sort(sprites, Sprite.zSorter);
    }

    public static void updateSprites(double d) {
        System.out.println(sprites.size());
        for (Sprite sprite : sprites) {
            if (sprite.isDead()) continue;
            sprite.update(d);
        }
        if (!toRemove.isEmpty()) {
            sprites.removeAll(toRemove);
            toRemove.clear();
        }
        if (!toAdd.isEmpty()) {
            sprites.addAll(toAdd);
            toAdd.clear();
            S4P.sortZorder();
        }
    }

    public static void drawSprites() {
        app.pushMatrix();
        app.scale((float)worldScale);
        app.translate((float)(-worldX), (float)(-worldY));
        app.imageMode(3);
        for (Sprite sprite : sprites) {
            if (sprite.isDead()) continue;
            sprite.draw();
        }
        app.popMatrix();
    }

    public static ImageInfo getImageInfo(PApplet pApplet, String string, int n, int n2) {
        app = pApplet;
        if (screenDomain == null) {
            screenDomain = new Domain(0.0, 0.0, S4P.app.width, S4P.app.height);
        }
        Integer n3 = new Integer(string.toLowerCase().hashCode());
        ImageInfo imageInfo = null;
        if (imageStore.containsKey(n3)) {
            imageInfo = imageStore.get(n3);
        } else {
            PImage pImage = app.loadImage(string);
            imageInfo = new ImageInfo(pImage, n, n2);
            imageStore.put(n3, imageInfo);
        }
        return imageInfo;
    }

    public static ImageInfo getImageInfo(PApplet pApplet, String string, String string2, int n, int n2) {
        app = pApplet;
        if (screenDomain == null) {
            screenDomain = new Domain(0.0, 0.0, S4P.app.width, S4P.app.height);
        }
        Integer n3 = new Integer((string.toLowerCase() + string2.toLowerCase()).hashCode());
        ImageInfo imageInfo = null;
        if (imageStore.containsKey(n3)) {
            imageInfo = imageStore.get(n3);
        } else {
            PImage pImage = app.loadImage(string);
            PImage pImage2 = app.loadImage(string2);
            imageInfo = new ImageInfo(pImage, pImage2, n, n2);
            imageStore.put(n3, imageInfo);
        }
        return imageInfo;
    }

    public static PImage[] getFrames(ImageInfo imageInfo) {
        int n;
        int n2 = imageInfo.nbrCols * imageInfo.nbrRows;
        PImage[] pImageArray = new PImage[n2];
        int n3 = imageInfo.image.width / imageInfo.nbrCols;
        int n4 = imageInfo.image.height / imageInfo.nbrRows;
        int n5 = 0;
        for (int i = 0; i < imageInfo.nbrRows; ++i) {
            for (n = 0; n < imageInfo.nbrCols; ++n) {
                pImageArray[n5] = new PImage(n3, n4, 2);
                pImageArray[n5].copy(imageInfo.image, n * n3, i * n4, n3, n4, 0, 0, n3, n4);
                ++n5;
            }
        }
        if (imageInfo.alphaMask != null) {
            PImage[] pImageArray2 = S4P.makeAlphaMaskFrames(imageInfo, n3, n4);
            n = 0;
            for (int i = 0; i < pImageArray.length; ++i) {
                pImageArray[i].loadPixels();
                pImageArray2[n].loadPixels();
                for (int j = 0; j < pImageArray[i].pixels.length; ++j) {
                    int n6 = j;
                    pImageArray[i].pixels[n6] = pImageArray[i].pixels[n6] & 0xFFFFFF;
                    int n7 = j;
                    pImageArray[i].pixels[n7] = pImageArray[i].pixels[n7] | pImageArray2[n].pixels[j] << 24;
                }
                pImageArray[i].updatePixels();
                n = (n + 1) % pImageArray2.length;
            }
        }
        return pImageArray;
    }

    private static PImage[] makeAlphaMaskFrames(ImageInfo imageInfo, int n, int n2) {
        int n3;
        imageInfo.alphaMask.loadPixels();
        int[] nArray = imageInfo.alphaMask.pixels;
        int[] nArray2 = new int[nArray.length];
        for (n3 = 0; n3 < nArray2.length; ++n3) {
            int n4;
            int n5 = nArray[n3] & 0xFF;
            int n6 = nArray[n3] >> 8 & 0xFF;
            int n7 = nArray[n3] >> 16 & 0xFF;
            nArray2[n3] = n4 = (n7 + n6 + n5) / 3;
        }
        n3 = imageInfo.alphaMask.width / n;
        int n8 = imageInfo.alphaMask.height / n2;
        int n9 = n3 * n8;
        PImage[] pImageArray = new PImage[n9];
        int n10 = 0;
        for (int i = 0; i < n8; ++i) {
            for (int j = 0; j < n3; ++j) {
                pImageArray[n10] = new PImage(n, n2, 2);
                pImageArray[n10].copy(imageInfo.alphaMask, j * n, i * n2, n, n2, 0, 0, n, n2);
                ++n10;
            }
        }
        return pImageArray;
    }

    public static boolean rebound(Sprite sprite, Sprite sprite2) {
        double d = sprite2.mass / (sprite.mass + sprite2.mass);
        double d2 = 1.0 - d;
        Vector2D vector2D = Vector2D.sub(sprite.pos, sprite2.pos);
        Vector2D vector2D2 = Vector2D.sub(sprite.vel, sprite2.vel);
        double d3 = Vector2D.dot(vector2D, vector2D2);
        double d4 = Vector2D.dot(vector2D, vector2D);
        if (d3 > 0.0 || d4 < (double)1.0E-5f) {
            return false;
        }
        Vector2D vector2D3 = Vector2D.mult(vector2D, d3 / d4);
        Vector2D vector2D4 = Vector2D.sub(vector2D2, vector2D3);
        Vector2D vector2D5 = Vector2D.mult(vector2D3, (1.0 + sprite.elasticity) * d);
        Vector2D vector2D6 = Vector2D.mult(vector2D3, (1.0 + sprite2.elasticity) * d2);
        Vector2D vector2D7 = Vector2D.mult(vector2D4, sprite.friction);
        Vector2D vector2D8 = Vector2D.mult(vector2D4, sprite2.friction);
        sprite.vel.sub(vector2D5);
        sprite.vel.sub(vector2D7);
        sprite2.vel.add(vector2D6);
        sprite2.vel.add(vector2D8);
        return true;
    }

    public static boolean rebound(Sprite sprite, Vector2D vector2D) {
        double d = 1.0;
        double d2 = 0.0;
        Vector2D vector2D2 = sprite.vel;
        double d3 = Vector2D.dot(vector2D, vector2D2);
        double d4 = Vector2D.dot(vector2D, vector2D);
        if (d3 > 0.0 || d4 < (double)1.0E-5f) {
            return false;
        }
        Vector2D vector2D3 = Vector2D.mult(vector2D, d3 / d4);
        Vector2D vector2D4 = Vector2D.sub(vector2D2, vector2D3);
        Vector2D vector2D5 = Vector2D.mult(vector2D3, (1.0 + sprite.elasticity) * d);
        Vector2D vector2D6 = Vector2D.mult(vector2D4, sprite.friction);
        sprite.vel.sub(vector2D5);
        sprite.vel.sub(vector2D6);
        return true;
    }

    public static void messagesEnabled(boolean bl) {
        messages = bl;
    }

    static {
        messages = true;
        collisionAreasVisible = false;
        colColor = -2130706688;
        selColor = -2147418368;
        worldX = 0.0;
        worldY = 0.0;
        worldScale = 1.0;
    }
}

