/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import processing.core.PMatrix2D;
import processing.opengl.LineStroker;

public class LinePath {
    public static final int WIND_EVEN_ODD = 0;
    public static final int WIND_NON_ZERO = 1;
    public static final byte SEG_MOVETO = 0;
    public static final byte SEG_LINETO = 1;
    public static final byte SEG_CLOSE = 2;
    public static final int JOIN_MITER = 0;
    public static final int JOIN_ROUND = 1;
    public static final int JOIN_BEVEL = 2;
    public static final int CAP_BUTT = 0;
    public static final int CAP_ROUND = 1;
    public static final int CAP_SQUARE = 2;
    private static PMatrix2D identity = new PMatrix2D();
    private static float defaultMiterlimit = 10.0f;
    static final int INIT_SIZE = 20;
    static final int EXPAND_MAX = 500;
    protected byte[] pointTypes;
    protected float[] floatCoords;
    protected int[] pointColors;
    protected int numTypes;
    protected int numCoords;
    protected int windingRule;

    public LinePath() {
        this(1, 20);
    }

    public LinePath(int n) {
        this(n, 20);
    }

    public LinePath(int n, int n2) {
        this.setWindingRule(n);
        this.pointTypes = new byte[n2];
        this.floatCoords = new float[n2 * 2];
        this.pointColors = new int[n2];
    }

    void needRoom(boolean bl, int n) {
        int n2;
        if (bl && this.numTypes == 0) {
            throw new RuntimeException("missing initial moveto in path definition");
        }
        int n3 = this.pointTypes.length;
        if (this.numTypes >= n3) {
            n2 = n3;
            if (n2 > 500) {
                n2 = 500;
            }
            this.pointTypes = LinePath.copyOf(this.pointTypes, n3 + n2);
        }
        if (this.numCoords + n * 2 > (n3 = this.floatCoords.length)) {
            n2 = n3;
            if (n2 > 1000) {
                n2 = 1000;
            }
            if (n2 < n * 2) {
                n2 = n * 2;
            }
            this.floatCoords = LinePath.copyOf(this.floatCoords, n3 + n2);
        }
        if (this.numCoords + n > (n3 = this.pointColors.length)) {
            n2 = n3;
            if (n2 > 500) {
                n2 = 500;
            }
            if (n2 < n) {
                n2 = n;
            }
            this.pointColors = LinePath.copyOf(this.pointColors, n3 + n2);
        }
    }

    public final void moveTo(float f, float f2, int n) {
        if (this.numTypes > 0 && this.pointTypes[this.numTypes - 1] == 0) {
            this.floatCoords[this.numCoords - 2] = f;
            this.floatCoords[this.numCoords - 1] = f2;
            this.pointColors[this.numCoords / 2] = n;
        } else {
            this.needRoom(false, 1);
            this.pointTypes[this.numTypes++] = 0;
            this.floatCoords[this.numCoords++] = f;
            this.floatCoords[this.numCoords++] = f2;
            this.pointColors[this.numCoords / 2 - 1] = n;
        }
    }

    public final void lineTo(float f, float f2, int n) {
        this.needRoom(true, 1);
        this.pointTypes[this.numTypes++] = 1;
        this.floatCoords[this.numCoords++] = f;
        this.floatCoords[this.numCoords++] = f2;
        this.pointColors[this.numCoords / 2 - 1] = n;
    }

    public PathIterator getPathIterator() {
        return new PathIterator(this);
    }

    public final void closePath() {
        if (this.numTypes == 0 || this.pointTypes[this.numTypes - 1] != 2) {
            this.needRoom(false, 0);
            this.pointTypes[this.numTypes++] = 2;
        }
    }

    public final int getWindingRule() {
        return this.windingRule;
    }

    public final void setWindingRule(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("winding rule must be WIND_EVEN_ODD or WIND_NON_ZERO");
        }
        this.windingRule = n;
    }

    public final void reset() {
        this.numCoords = 0;
        this.numTypes = 0;
    }

    public static LinePath createStrokedPath(LinePath linePath, float f, int n, int n2) {
        return LinePath.createStrokedPath(linePath, f, n, n2, defaultMiterlimit, null);
    }

    public static LinePath createStrokedPath(LinePath linePath, float f, int n, int n2, float f2) {
        return LinePath.createStrokedPath(linePath, f, n, n2, f2, null);
    }

    public static LinePath createStrokedPath(LinePath linePath, float f, int n, int n2, float f2, PMatrix2D pMatrix2D) {
        final LinePath linePath2 = new LinePath();
        LinePath.strokeTo(linePath, f, n, n2, f2, pMatrix2D, new LineStroker(){

            @Override
            public void moveTo(int n, int n2, int n3) {
                linePath2.moveTo(LinePath.S15_16ToFloat(n), LinePath.S15_16ToFloat(n2), n3);
            }

            @Override
            public void lineJoin() {
            }

            @Override
            public void lineTo(int n, int n2, int n3) {
                linePath2.lineTo(LinePath.S15_16ToFloat(n), LinePath.S15_16ToFloat(n2), n3);
            }

            @Override
            public void close() {
                linePath2.closePath();
            }

            @Override
            public void end() {
            }
        });
        return linePath2;
    }

    private static void strokeTo(LinePath linePath, float f, int n, int n2, float f2, PMatrix2D pMatrix2D, LineStroker lineStroker) {
        lineStroker = new LineStroker(lineStroker, LinePath.FloatToS15_16(f), n, n2, LinePath.FloatToS15_16(f2), pMatrix2D == null ? identity : pMatrix2D);
        PathIterator pathIterator = linePath.getPathIterator();
        LinePath.pathTo(pathIterator, lineStroker);
    }

    private static void pathTo(PathIterator pathIterator, LineStroker lineStroker) {
        float[] fArray = new float[6];
        while (!pathIterator.isDone()) {
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    int n = (int)fArray[2] << 24 | (int)fArray[3] << 16 | (int)fArray[4] << 8 | (int)fArray[5];
                    lineStroker.moveTo(LinePath.FloatToS15_16(fArray[0]), LinePath.FloatToS15_16(fArray[1]), n);
                    break;
                }
                case 1: {
                    int n = (int)fArray[2] << 24 | (int)fArray[3] << 16 | (int)fArray[4] << 8 | (int)fArray[5];
                    lineStroker.lineJoin();
                    lineStroker.lineTo(LinePath.FloatToS15_16(fArray[0]), LinePath.FloatToS15_16(fArray[1]), n);
                    break;
                }
                case 2: {
                    lineStroker.lineJoin();
                    lineStroker.close();
                    break;
                }
                default: {
                    throw new InternalError("unknown flattened segment type");
                }
            }
            pathIterator.next();
        }
        lineStroker.end();
    }

    public static float[] copyOf(float[] fArray, int n) {
        float[] fArray2 = new float[n];
        for (int i = 0; i < fArray2.length; ++i) {
            fArray2[i] = i > fArray.length - 1 ? 0.0f : fArray[i];
        }
        return fArray2;
    }

    public static byte[] copyOf(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = i > byArray.length - 1 ? (byte)0 : byArray[i];
        }
        return byArray2;
    }

    public static int[] copyOf(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = i > nArray.length - 1 ? 0 : nArray[i];
        }
        return nArray2;
    }

    public static int isqrt(int n) {
        int n2 = 16;
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        int n6 = 15 + n2 / 2;
        do {
            n4 = n4 << 2 | n5 >>> 30;
            n5 <<= 2;
            int n7 = ((n3 <<= 1) << 1) + 1;
            if (n4 < n7) continue;
            n4 -= n7;
            ++n3;
        } while (n6-- != 0);
        return n3;
    }

    public static long lsqrt(long l) {
        int n = 16;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = l;
        int n2 = 31 + n / 2;
        do {
            l3 = l3 << 2 | l4 >>> 62;
            l4 <<= 2;
            long l5 = ((l2 <<= 1) << 1) + 1L;
            if (l3 < l5) continue;
            l3 -= l5;
            ++l2;
        } while (n2-- != 0);
        return l2;
    }

    public static double hypot(double d, double d2) {
        return Math.sqrt(d * d + d2 * d2);
    }

    public static int hypot(int n, int n2) {
        return (int)(LinePath.lsqrt((long)n * (long)n + (long)n2 * (long)n2) + 128L >> 8);
    }

    public static long hypot(long l, long l2) {
        return LinePath.lsqrt(l * l + l2 * l2) + 128L >> 8;
    }

    static int FloatToS15_16(float f) {
        if ((f = f * 65536.0f + 0.5f) <= -4.2949673E9f) {
            return Integer.MIN_VALUE;
        }
        if (f >= 4.2949673E9f) {
            return Integer.MAX_VALUE;
        }
        return (int)Math.floor(f);
    }

    static float S15_16ToFloat(int n) {
        return (float)n / 65536.0f;
    }

    public static class PathIterator {
        float[] floatCoords;
        int typeIdx;
        int pointIdx;
        int colorIdx;
        LinePath path;
        static final int[] curvecoords = new int[]{2, 2, 0};

        PathIterator(LinePath linePath) {
            this.path = linePath;
            this.floatCoords = linePath.floatCoords;
        }

        public int currentSegment(float[] fArray) {
            byte by = this.path.pointTypes[this.typeIdx];
            int n = curvecoords[by];
            if (n > 0) {
                System.arraycopy(this.floatCoords, this.pointIdx, fArray, 0, n);
                int n2 = this.path.pointColors[this.colorIdx];
                fArray[n + 0] = n2 >> 24 & 0xFF;
                fArray[n + 1] = n2 >> 16 & 0xFF;
                fArray[n + 2] = n2 >> 8 & 0xFF;
                fArray[n + 3] = n2 >> 0 & 0xFF;
            }
            return by;
        }

        public int currentSegment(double[] dArray) {
            byte by = this.path.pointTypes[this.typeIdx];
            int n = curvecoords[by];
            if (n > 0) {
                int n2;
                for (n2 = 0; n2 < n; ++n2) {
                    dArray[n2] = this.floatCoords[this.pointIdx + n2];
                }
                n2 = this.path.pointColors[this.colorIdx];
                dArray[n + 0] = n2 >> 24 & 0xFF;
                dArray[n + 1] = n2 >> 16 & 0xFF;
                dArray[n + 2] = n2 >> 8 & 0xFF;
                dArray[n + 3] = n2 >> 0 & 0xFF;
            }
            return by;
        }

        public int getWindingRule() {
            return this.path.getWindingRule();
        }

        public boolean isDone() {
            return this.typeIdx >= this.path.numTypes;
        }

        public void next() {
            byte by = this.path.pointTypes[this.typeIdx++];
            this.pointIdx += curvecoords[by];
            ++this.colorIdx;
        }
    }
}

