/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.net.URL;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.WeakHashMap;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.core.PMatrix;
import processing.core.PMatrix2D;
import processing.core.PMatrix3D;
import processing.core.PShape;
import processing.core.PVector;
import processing.opengl.FontTexture;
import processing.opengl.FrameBuffer;
import processing.opengl.LinePath;
import processing.opengl.PGL;
import processing.opengl.PGraphics2D;
import processing.opengl.PGraphics3D;
import processing.opengl.PShader;
import processing.opengl.Texture;

public class PGraphicsOpenGL
extends PGraphics {
    public PGL pgl;
    protected static PGraphicsOpenGL pgPrimary = null;
    protected static PGraphicsOpenGL pgCurrent = null;
    protected WeakHashMap<PFont, FontTexture> fontMap = new WeakHashMap();
    static final String OPENGL_THREAD_ERROR = "Cannot run the OpenGL renderer outside the main thread, change your code\nso the drawing calls are all inside the main thread, \nor use the default renderer instead.";
    static final String BLEND_DRIVER_ERROR = "blendMode(%1$s) is not supported by this hardware (or driver)";
    static final String BLEND_RENDERER_ERROR = "blendMode(%1$s) is not supported by this renderer";
    static final String ALREADY_DRAWING_ERROR = "Already called beginDraw()";
    static final String NO_BEGIN_DRAW_ERROR = "Cannot call endDraw() before beginDraw()";
    static final String NESTED_DRAW_ERROR = "Already called drawing on another PGraphicsOpenGL object";
    static final String ALREADY_BEGAN_CONTOUR_ERROR = "Already called beginContour()";
    static final String NO_BEGIN_CONTOUR_ERROR = "Need to call beginContour() first";
    static final String UNSUPPORTED_SMOOTH_LEVEL_ERROR = "Smooth level %1$s is not available. Using %2$s instead";
    static final String UNSUPPORTED_SMOOTH_ERROR = "Smooth is not supported by this hardware (or driver)";
    static final String TOO_MANY_SMOOTH_CALLS_ERROR = "The smooth/noSmooth functions are being called too often.\nThis results in screen flickering, so they will be disabled\nfor the rest of the sketch's execution";
    static final String UNSUPPORTED_SHAPE_FORMAT_ERROR = "Unsupported shape format";
    static final String INVALID_FILTER_SHADER_ERROR = "Object is not a valid shader to use as filter";
    static final String INVALID_PROCESSING_SHADER_ERROR = "The GLSL code doesn't seem to contain a valid shader to use in Processing";
    static final String WRONG_SHADER_TYPE_ERROR = "shader() called with a wrong shader";
    static final String UNKNOWN_SHADER_KIND_ERROR = "Unknown shader kind";
    static final String NO_TEXLIGHT_SHADER_ERROR = "Your shader cannot be used to render textured and lit geometry, using default shader instead.";
    static final String NO_LIGHT_SHADER_ERROR = "Your shader cannot be used to render lit geometry, using default shader instead.";
    static final String NO_TEXTURE_SHADER_ERROR = "Your shader cannot be used to render textured geometry, using default shader instead.";
    static final String NO_COLOR_SHADER_ERROR = "Your shader cannot be used to render colored geometry, using default shader instead.";
    static final String TOO_LONG_STROKE_PATH_ERROR = "Stroke path is too long, some bevel triangles won't be added";
    static final String TESSELLATION_ERROR = "Tessellation Error: %1$s";
    public boolean initialized;
    protected static final int FLUSH_CONTINUOUSLY = 0;
    protected static final int FLUSH_WHEN_FULL = 1;
    protected static final int IMMEDIATE = 0;
    protected static final int RETAINED = 1;
    protected int flushMode = 1;
    public int glPolyVertex;
    public int glPolyColor;
    public int glPolyNormal;
    public int glPolyTexcoord;
    public int glPolyAmbient;
    public int glPolySpecular;
    public int glPolyEmissive;
    public int glPolyShininess;
    public int glPolyIndex;
    protected boolean polyBuffersCreated = false;
    protected int polyBuffersContext;
    public int glLineVertex;
    public int glLineColor;
    public int glLineAttrib;
    public int glLineIndex;
    protected boolean lineBuffersCreated = false;
    protected int lineBuffersContext;
    public int glPointVertex;
    public int glPointColor;
    public int glPointAttrib;
    public int glPointIndex;
    protected boolean pointBuffersCreated = false;
    protected int pointBuffersContext;
    protected static final int INIT_VERTEX_BUFFER_SIZE = 256;
    protected static final int INIT_INDEX_BUFFER_SIZE = 512;
    protected static boolean glParamsRead = false;
    public static boolean npotTexSupported;
    public static boolean autoMipmapGenSupported;
    public static boolean fboMultisampleSupported;
    public static boolean packedDepthStencilSupported;
    public static boolean anisoSamplingSupported;
    public static boolean blendEqSupported;
    public static int maxTextureSize;
    public static int maxSamples;
    public static float maxPointSize;
    public static float maxLineWidth;
    public static float maxAnisoAmount;
    public static int depthBits;
    public static int stencilBits;
    public static String OPENGL_VENDOR;
    public static String OPENGL_RENDERER;
    public static String OPENGL_VERSION;
    public static String OPENGL_EXTENSIONS;
    public static String GLSL_VERSION;
    protected static HashMap<GLResource, Boolean> glTextureObjects;
    protected static HashMap<GLResource, Boolean> glVertexBuffers;
    protected static HashMap<GLResource, Boolean> glFrameBuffers;
    protected static HashMap<GLResource, Boolean> glRenderBuffers;
    protected static HashMap<GLResource, Boolean> glslPrograms;
    protected static HashMap<GLResource, Boolean> glslVertexShaders;
    protected static HashMap<GLResource, Boolean> glslFragmentShaders;
    protected static URL defColorShaderVertURL;
    protected static URL defTextureShaderVertURL;
    protected static URL defLightShaderVertURL;
    protected static URL defTexlightShaderVertURL;
    protected static URL defColorShaderFragURL;
    protected static URL defTextureShaderFragURL;
    protected static URL defLineShaderVertURL;
    protected static URL defLineShaderFragURL;
    protected static URL defPointShaderVertURL;
    protected static URL defPointShaderFragURL;
    protected static ColorShader defColorShader;
    protected static TexureShader defTextureShader;
    protected static LightShader defLightShader;
    protected static TexlightShader defTexlightShader;
    protected static LineShader defLineShader;
    protected static PointShader defPointShader;
    protected static URL maskShaderFragURL;
    protected static TexureShader maskShader;
    protected ColorShader colorShader;
    protected TexureShader textureShader;
    protected LightShader lightShader;
    protected TexlightShader texlightShader;
    protected LineShader lineShader;
    protected PointShader pointShader;
    protected boolean shaderWarningsEnabled = true;
    protected InGeometry inGeo;
    protected TessGeometry tessGeo;
    protected static Tessellator tessellator;
    protected TexCache texCache;
    public float cameraFOV;
    public float cameraX;
    public float cameraY;
    public float cameraZ;
    public float cameraNear;
    public float cameraFar;
    public float cameraAspect;
    protected float cameraEyeX;
    protected float cameraEyeY;
    protected float cameraEyeZ;
    protected boolean manipulatingCamera;
    public PMatrix3D projection;
    public PMatrix3D camera;
    public PMatrix3D cameraInv;
    public PMatrix3D modelview;
    public PMatrix3D modelviewInv;
    public PMatrix3D projmodelview;
    protected float[] glProjection;
    protected float[] glModelview;
    protected float[] glProjmodelview;
    protected float[] glNormal;
    protected static PMatrix3D identity;
    protected boolean matricesAllocated = false;
    protected boolean sized;
    protected static final int MATRIX_STACK_DEPTH = 32;
    protected int modelviewStackDepth;
    protected int projectionStackDepth;
    protected float[][] modelviewStack = new float[32][16];
    protected float[][] modelviewInvStack = new float[32][16];
    protected float[][] cameraStack = new float[32][16];
    protected float[][] cameraInvStack = new float[32][16];
    protected float[][] projectionStack = new float[32][16];
    public boolean lights;
    public int lightCount = 0;
    public int[] lightType;
    public float[] lightPosition;
    public float[] lightNormal;
    public float[] lightAmbient;
    public float[] lightDiffuse;
    public float[] lightSpecular;
    public float[] lightFalloffCoefficients;
    public float[] lightSpotParameters;
    public float[] currentLightSpecular;
    public float currentLightFalloffConstant;
    public float currentLightFalloffLinear;
    public float currentLightFalloffQuadratic;
    protected boolean lightsAllocated = false;
    protected int textureWrap = 0;
    protected int textureSampling = 5;
    protected int blendMode;
    protected boolean clip = false;
    protected int[] clipRect = new int[]{0, 0, 0, 0};
    FontTexture textTex;
    protected static final int FB_STACK_DEPTH = 16;
    protected static int fbStackDepth;
    protected static FrameBuffer[] fbStack;
    protected static FrameBuffer drawFramebuffer;
    protected static FrameBuffer readFramebuffer;
    protected static FrameBuffer currentFramebuffer;
    protected FrameBuffer offscreenFramebuffer;
    protected FrameBuffer multisampleFramebuffer;
    protected boolean offscreenMultisample;
    protected boolean pixOpChangedFB;
    protected Texture texture;
    protected Texture ptexture;
    protected IntBuffer pixelBuffer;
    protected int[] nativePixels;
    protected IntBuffer nativePixelBuffer;
    protected Texture filterTexture;
    protected PImage filterImage;
    protected boolean setgetPixels;
    protected boolean drawing = false;
    protected boolean restoreSurface = false;
    protected boolean smoothDisabled = false;
    protected int smoothCallCount = 0;
    protected int lastSmoothCall = -10;
    protected static final int OP_NONE = 0;
    protected static final int OP_READ = 1;
    protected static final int OP_WRITE = 2;
    protected int pixelsOp = 0;
    protected IntBuffer viewport;
    protected boolean clearColorBuffer;
    protected boolean clearColorBuffer0;
    protected boolean openContour = false;
    protected boolean breakShape = false;
    protected boolean defaultEdges = false;
    protected PImage textureImage0;
    protected static final int EDGE_MIDDLE = 0;
    protected static final int EDGE_START = 1;
    protected static final int EDGE_STOP = 2;
    protected static final int EDGE_SINGLE = 3;
    protected static final int MIN_POINT_ACCURACY = 20;
    protected static final float POINT_ACCURACY_FACTOR = 10.0f;
    protected final float[][] QUAD_POINT_SIGNS = new float[][]{{-1.0f, 1.0f}, {-1.0f, -1.0f}, {1.0f, -1.0f}, {1.0f, 1.0f}};
    protected IntBuffer intBuffer;
    protected FloatBuffer floatBuffer;

    public PGraphicsOpenGL() {
        this.pgl = new PGL(this);
        if (tessellator == null) {
            tessellator = new Tessellator();
        }
        this.intBuffer = PGL.allocateIntBuffer(2);
        this.floatBuffer = PGL.allocateFloatBuffer(2);
        this.viewport = PGL.allocateIntBuffer(4);
        this.inGeo = this.newInGeometry(0);
        this.tessGeo = this.newTessGeometry(0);
        this.texCache = this.newTexCache();
        this.initialized = false;
    }

    @Override
    public void setPrimary(boolean bl) {
        super.setPrimary(bl);
        this.format = 2;
    }

    @Override
    public void setFrameRate(float f) {
        this.pgl.setFrameRate(f);
    }

    @Override
    public void setSize(int n, int n2) {
        this.width = n;
        this.height = n2;
        this.allocate();
        this.reapplySettings();
        this.cameraFOV = 1.0471976f;
        this.cameraX = (float)this.width / 2.0f;
        this.cameraY = (float)this.height / 2.0f;
        this.cameraZ = this.cameraY / (float)Math.tan(this.cameraFOV / 2.0f);
        this.cameraNear = this.cameraZ / 10.0f;
        this.cameraFar = this.cameraZ * 10.0f;
        this.cameraAspect = (float)this.width / (float)this.height;
        this.restartPGL();
        this.sized = true;
    }

    @Override
    protected void allocate() {
        super.allocate();
        if (!this.matricesAllocated) {
            this.projection = new PMatrix3D();
            this.camera = new PMatrix3D();
            this.cameraInv = new PMatrix3D();
            this.modelview = new PMatrix3D();
            this.modelviewInv = new PMatrix3D();
            this.projmodelview = new PMatrix3D();
            this.matricesAllocated = true;
        }
        if (!this.lightsAllocated) {
            this.lightType = new int[8];
            this.lightPosition = new float[32];
            this.lightNormal = new float[24];
            this.lightAmbient = new float[24];
            this.lightDiffuse = new float[24];
            this.lightSpecular = new float[24];
            this.lightFalloffCoefficients = new float[24];
            this.lightSpotParameters = new float[16];
            this.currentLightSpecular = new float[3];
            this.lightsAllocated = true;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.deleteFinalizedGLResources();
        this.deletePolyBuffers();
        this.deleteLineBuffers();
        this.deletePointBuffers();
        this.deleteDefaultShaders();
        this.pgl.deleteSurface();
    }

    protected void setFlushMode(int n) {
        this.flushMode = n;
    }

    protected void setFontTexture(PFont pFont, FontTexture fontTexture) {
        this.fontMap.put(pFont, fontTexture);
    }

    protected FontTexture getFontTexture(PFont pFont) {
        return this.fontMap.get(pFont);
    }

    protected void removeFontTexture(PFont pFont) {
        this.fontMap.remove(pFont);
    }

    protected int createTextureObject(int n) {
        this.deleteFinalizedTextureObjects();
        this.pgl.genTextures(1, this.intBuffer);
        int n2 = this.intBuffer.get(0);
        GLResource gLResource = new GLResource(n2, n);
        if (!glTextureObjects.containsKey(gLResource)) {
            glTextureObjects.put(gLResource, false);
        }
        return n2;
    }

    protected void deleteTextureObject(int n, int n2) {
        GLResource gLResource = new GLResource(n, n2);
        if (glTextureObjects.containsKey(gLResource)) {
            this.intBuffer.put(0, n);
            if (this.pgl.threadIsCurrent()) {
                this.pgl.deleteTextures(1, this.intBuffer);
            }
            glTextureObjects.remove(gLResource);
        }
    }

    protected void deleteAllTextureObjects() {
        for (GLResource gLResource : glTextureObjects.keySet()) {
            this.intBuffer.put(0, gLResource.id);
            if (!this.pgl.threadIsCurrent()) continue;
            this.pgl.deleteTextures(1, this.intBuffer);
        }
        glTextureObjects.clear();
    }

    protected synchronized void finalizeTextureObject(int n, int n2) {
        GLResource gLResource = new GLResource(n, n2);
        if (glTextureObjects.containsKey(gLResource)) {
            glTextureObjects.put(gLResource, true);
        }
    }

    protected void deleteFinalizedTextureObjects() {
        HashSet<GLResource> hashSet = new HashSet<GLResource>();
        for (GLResource gLResource : glTextureObjects.keySet()) {
            if (!glTextureObjects.get(gLResource).booleanValue()) continue;
            hashSet.add(gLResource);
            this.intBuffer.put(0, gLResource.id);
            if (!this.pgl.threadIsCurrent()) continue;
            this.pgl.deleteTextures(1, this.intBuffer);
        }
        for (GLResource gLResource : hashSet) {
            glTextureObjects.remove(gLResource);
        }
    }

    protected void removeTextureObject(int n, int n2) {
        GLResource gLResource = new GLResource(n, n2);
        if (glTextureObjects.containsKey(gLResource)) {
            glTextureObjects.remove(gLResource);
        }
    }

    protected int createVertexBufferObject(int n) {
        this.deleteFinalizedVertexBufferObjects();
        this.pgl.genBuffers(1, this.intBuffer);
        int n2 = this.intBuffer.get(0);
        GLResource gLResource = new GLResource(n2, n);
        if (!glVertexBuffers.containsKey(gLResource)) {
            glVertexBuffers.put(gLResource, false);
        }
        return n2;
    }

    protected void deleteVertexBufferObject(int n, int n2) {
        GLResource gLResource = new GLResource(n, n2);
        if (glVertexBuffers.containsKey(gLResource)) {
            this.intBuffer.put(0, n);
            if (this.pgl.threadIsCurrent()) {
                this.pgl.deleteBuffers(1, this.intBuffer);
            }
            glVertexBuffers.remove(gLResource);
        }
    }

    protected void deleteAllVertexBufferObjects() {
        for (GLResource gLResource : glVertexBuffers.keySet()) {
            this.intBuffer.put(0, gLResource.id);
            if (!this.pgl.threadIsCurrent()) continue;
            this.pgl.deleteBuffers(1, this.intBuffer);
        }
        glVertexBuffers.clear();
    }

    protected synchronized void finalizeVertexBufferObject(int n, int n2) {
        GLResource gLResource = new GLResource(n, n2);
        if (glVertexBuffers.containsKey(gLResource)) {
            glVertexBuffers.put(gLResource, true);
        }
    }

    protected void deleteFinalizedVertexBufferObjects() {
        HashSet<GLResource> hashSet = new HashSet<GLResource>();
        for (GLResource gLResource : glVertexBuffers.keySet()) {
            if (!glVertexBuffers.get(gLResource).booleanValue()) continue;
            hashSet.add(gLResource);
            this.intBuffer.put(0, gLResource.id);
            if (!this.pgl.threadIsCurrent()) continue;
            this.pgl.deleteBuffers(1, this.intBuffer);
        }
        for (GLResource gLResource : hashSet) {
            glVertexBuffers.remove(gLResource);
        }
    }

    protected void removeVertexBufferObject(int n, int n2) {
        GLResource gLResource = new GLResource(n, n2);
        if (glVertexBuffers.containsKey(gLResource)) {
            glVertexBuffers.remove(gLResource);
        }
    }

    protected int createFrameBufferObject(int n) {
        this.deleteFinalizedFrameBufferObjects();
        this.pgl.genFramebuffers(1, this.intBuffer);
        int n2 = this.intBuffer.get(0);
        GLResource gLResource = new GLResource(n2, n);
        if (!glFrameBuffers.containsKey(gLResource)) {
            glFrameBuffers.put(gLResource, false);
        }
        return n2;
    }

    protected void deleteFrameBufferObject(int n, int n2) {
        GLResource gLResource = new GLResource(n, n2);
        if (glFrameBuffers.containsKey(gLResource)) {
            this.intBuffer.put(0, n);
            if (this.pgl.threadIsCurrent()) {
                this.pgl.deleteFramebuffers(1, this.intBuffer);
            }
            glFrameBuffers.remove(gLResource);
        }
    }

    protected void deleteAllFrameBufferObjects() {
        for (GLResource gLResource : glFrameBuffers.keySet()) {
            this.intBuffer.put(0, gLResource.id);
            if (!this.pgl.threadIsCurrent()) continue;
            this.pgl.deleteFramebuffers(1, this.intBuffer);
        }
        glFrameBuffers.clear();
    }

    protected synchronized void finalizeFrameBufferObject(int n, int n2) {
        GLResource gLResource = new GLResource(n, n2);
        if (glFrameBuffers.containsKey(gLResource)) {
            glFrameBuffers.put(gLResource, true);
        }
    }

    protected void deleteFinalizedFrameBufferObjects() {
        HashSet<GLResource> hashSet = new HashSet<GLResource>();
        for (GLResource gLResource : glFrameBuffers.keySet()) {
            if (!glFrameBuffers.get(gLResource).booleanValue()) continue;
            hashSet.add(gLResource);
            this.intBuffer.put(0, gLResource.id);
            if (!this.pgl.threadIsCurrent()) continue;
            this.pgl.deleteFramebuffers(1, this.intBuffer);
        }
        for (GLResource gLResource : hashSet) {
            glFrameBuffers.remove(gLResource);
        }
    }

    protected void removeFrameBufferObject(int n, int n2) {
        GLResource gLResource = new GLResource(n, n2);
        if (glFrameBuffers.containsKey(gLResource)) {
            glFrameBuffers.remove(gLResource);
        }
    }

    protected int createRenderBufferObject(int n) {
        this.deleteFinalizedRenderBufferObjects();
        this.pgl.genRenderbuffers(1, this.intBuffer);
        int n2 = this.intBuffer.get(0);
        GLResource gLResource = new GLResource(n2, n);
        if (!glRenderBuffers.containsKey(gLResource)) {
            glRenderBuffers.put(gLResource, false);
        }
        return n2;
    }

    protected void deleteRenderBufferObject(int n, int n2) {
        GLResource gLResource = new GLResource(n, n2);
        if (glRenderBuffers.containsKey(gLResource)) {
            this.intBuffer.put(0, n);
            if (this.pgl.threadIsCurrent()) {
                this.pgl.deleteRenderbuffers(1, this.intBuffer);
            }
            glRenderBuffers.remove(gLResource);
        }
    }

    protected void deleteAllRenderBufferObjects() {
        for (GLResource gLResource : glRenderBuffers.keySet()) {
            this.intBuffer.put(0, gLResource.id);
            if (!this.pgl.threadIsCurrent()) continue;
            this.pgl.deleteRenderbuffers(1, this.intBuffer);
        }
        glRenderBuffers.clear();
    }

    protected synchronized void finalizeRenderBufferObject(int n, int n2) {
        GLResource gLResource = new GLResource(n, n2);
        if (glRenderBuffers.containsKey(gLResource)) {
            glRenderBuffers.put(gLResource, true);
        }
    }

    protected void deleteFinalizedRenderBufferObjects() {
        HashSet<GLResource> hashSet = new HashSet<GLResource>();
        for (GLResource gLResource : glRenderBuffers.keySet()) {
            if (!glRenderBuffers.get(gLResource).booleanValue()) continue;
            hashSet.add(gLResource);
            this.intBuffer.put(0, gLResource.id);
            if (!this.pgl.threadIsCurrent()) continue;
            this.pgl.deleteRenderbuffers(1, this.intBuffer);
        }
        for (GLResource gLResource : hashSet) {
            glRenderBuffers.remove(gLResource);
        }
    }

    protected void removeRenderBufferObject(int n, int n2) {
        GLResource gLResource = new GLResource(n, n2);
        if (glRenderBuffers.containsKey(gLResource)) {
            glRenderBuffers.remove(gLResource);
        }
    }

    protected int createGLSLProgramObject(int n) {
        this.deleteFinalizedGLSLProgramObjects();
        int n2 = this.pgl.createProgram();
        GLResource gLResource = new GLResource(n2, n);
        if (!glslPrograms.containsKey(gLResource)) {
            glslPrograms.put(gLResource, false);
        }
        return n2;
    }

    protected void deleteGLSLProgramObject(int n, int n2) {
        GLResource gLResource = new GLResource(n, n2);
        if (glslPrograms.containsKey(gLResource)) {
            if (this.pgl.threadIsCurrent()) {
                this.pgl.deleteProgram(gLResource.id);
            }
            glslPrograms.remove(gLResource);
        }
    }

    protected void deleteAllGLSLProgramObjects() {
        for (GLResource gLResource : glslPrograms.keySet()) {
            if (!this.pgl.threadIsCurrent()) continue;
            this.pgl.deleteProgram(gLResource.id);
        }
        glslPrograms.clear();
    }

    protected synchronized void finalizeGLSLProgramObject(int n, int n2) {
        GLResource gLResource = new GLResource(n, n2);
        if (glslPrograms.containsKey(gLResource)) {
            glslPrograms.put(gLResource, true);
        }
    }

    protected void deleteFinalizedGLSLProgramObjects() {
        HashSet<GLResource> hashSet = new HashSet<GLResource>();
        for (GLResource gLResource : glslPrograms.keySet()) {
            if (!glslPrograms.get(gLResource).booleanValue()) continue;
            hashSet.add(gLResource);
            if (!this.pgl.threadIsCurrent()) continue;
            this.pgl.deleteProgram(gLResource.id);
        }
        for (GLResource gLResource : hashSet) {
            glslPrograms.remove(gLResource);
        }
    }

    protected void removeGLSLProgramObject(int n, int n2) {
        GLResource gLResource = new GLResource(n, n2);
        if (glslPrograms.containsKey(gLResource)) {
            glslPrograms.remove(gLResource);
        }
    }

    protected int createGLSLVertShaderObject(int n) {
        this.deleteFinalizedGLSLVertShaderObjects();
        int n2 = this.pgl.createShader(35633);
        GLResource gLResource = new GLResource(n2, n);
        if (!glslVertexShaders.containsKey(gLResource)) {
            glslVertexShaders.put(gLResource, false);
        }
        return n2;
    }

    protected void deleteGLSLVertShaderObject(int n, int n2) {
        GLResource gLResource = new GLResource(n, n2);
        if (glslVertexShaders.containsKey(gLResource)) {
            if (this.pgl.threadIsCurrent()) {
                this.pgl.deleteShader(gLResource.id);
            }
            glslVertexShaders.remove(gLResource);
        }
    }

    protected void deleteAllGLSLVertShaderObjects() {
        for (GLResource gLResource : glslVertexShaders.keySet()) {
            if (!this.pgl.threadIsCurrent()) continue;
            this.pgl.deleteShader(gLResource.id);
        }
        glslVertexShaders.clear();
    }

    protected synchronized void finalizeGLSLVertShaderObject(int n, int n2) {
        GLResource gLResource = new GLResource(n, n2);
        if (glslVertexShaders.containsKey(gLResource)) {
            glslVertexShaders.put(gLResource, true);
        }
    }

    protected void deleteFinalizedGLSLVertShaderObjects() {
        HashSet<GLResource> hashSet = new HashSet<GLResource>();
        for (GLResource gLResource : glslVertexShaders.keySet()) {
            if (!glslVertexShaders.get(gLResource).booleanValue()) continue;
            hashSet.add(gLResource);
            if (!this.pgl.threadIsCurrent()) continue;
            this.pgl.deleteShader(gLResource.id);
        }
        for (GLResource gLResource : hashSet) {
            glslVertexShaders.remove(gLResource);
        }
    }

    protected void removeGLSLVertShaderObject(int n, int n2) {
        GLResource gLResource = new GLResource(n, n2);
        if (glslVertexShaders.containsKey(gLResource)) {
            glslVertexShaders.remove(gLResource);
        }
    }

    protected int createGLSLFragShaderObject(int n) {
        this.deleteFinalizedGLSLFragShaderObjects();
        int n2 = this.pgl.createShader(35632);
        GLResource gLResource = new GLResource(n2, n);
        if (!glslFragmentShaders.containsKey(gLResource)) {
            glslFragmentShaders.put(gLResource, false);
        }
        return n2;
    }

    protected void deleteGLSLFragShaderObject(int n, int n2) {
        GLResource gLResource = new GLResource(n, n2);
        if (glslFragmentShaders.containsKey(gLResource)) {
            if (this.pgl.threadIsCurrent()) {
                this.pgl.deleteShader(gLResource.id);
            }
            glslFragmentShaders.remove(gLResource);
        }
    }

    protected void deleteAllGLSLFragShaderObjects() {
        for (GLResource gLResource : glslFragmentShaders.keySet()) {
            if (!this.pgl.threadIsCurrent()) continue;
            this.pgl.deleteShader(gLResource.id);
        }
        glslFragmentShaders.clear();
    }

    protected synchronized void finalizeGLSLFragShaderObject(int n, int n2) {
        GLResource gLResource = new GLResource(n, n2);
        if (glslFragmentShaders.containsKey(gLResource)) {
            glslFragmentShaders.put(gLResource, true);
        }
    }

    protected void deleteFinalizedGLSLFragShaderObjects() {
        HashSet<GLResource> hashSet = new HashSet<GLResource>();
        for (GLResource gLResource : glslFragmentShaders.keySet()) {
            if (!glslFragmentShaders.get(gLResource).booleanValue()) continue;
            hashSet.add(gLResource);
            if (!this.pgl.threadIsCurrent()) continue;
            this.pgl.deleteShader(gLResource.id);
        }
        for (GLResource gLResource : hashSet) {
            glslFragmentShaders.remove(gLResource);
        }
    }

    protected void removeGLSLFragShaderObject(int n, int n2) {
        GLResource gLResource = new GLResource(n, n2);
        if (glslFragmentShaders.containsKey(gLResource)) {
            glslFragmentShaders.remove(gLResource);
        }
    }

    protected void deleteFinalizedGLResources() {
        this.deleteFinalizedTextureObjects();
        this.deleteFinalizedVertexBufferObjects();
        this.deleteFinalizedFrameBufferObjects();
        this.deleteFinalizedRenderBufferObjects();
        this.deleteFinalizedGLSLProgramObjects();
        this.deleteFinalizedGLSLVertShaderObjects();
        this.deleteFinalizedGLSLFragShaderObjects();
    }

    protected void pushFramebuffer() {
        if (fbStackDepth == 16) {
            throw new RuntimeException("Too many pushFramebuffer calls");
        }
        PGraphicsOpenGL.fbStack[PGraphicsOpenGL.fbStackDepth] = currentFramebuffer;
        ++fbStackDepth;
    }

    protected void setFramebuffer(FrameBuffer frameBuffer) {
        if (currentFramebuffer != frameBuffer) {
            currentFramebuffer = frameBuffer;
            currentFramebuffer.bind();
        }
    }

    protected void popFramebuffer() {
        FrameBuffer frameBuffer;
        if (fbStackDepth == 0) {
            throw new RuntimeException("popFramebuffer call is unbalanced.");
        }
        if (currentFramebuffer != (frameBuffer = fbStack[--fbStackDepth])) {
            currentFramebuffer.finish();
            currentFramebuffer = frameBuffer;
            currentFramebuffer.bind();
        }
    }

    protected void createPolyBuffers() {
        if (!this.polyBuffersCreated || this.polyBuffersContextIsOutdated()) {
            this.polyBuffersContext = this.pgl.getCurrentContext();
            int n = 1024;
            int n2 = 1024;
            int n3 = 1024;
            this.glPolyVertex = this.createVertexBufferObject(this.polyBuffersContext);
            this.pgl.bindBuffer(34962, this.glPolyVertex);
            this.pgl.bufferData(34962, 3 * n, null, 35044);
            this.glPolyColor = this.createVertexBufferObject(this.polyBuffersContext);
            this.pgl.bindBuffer(34962, this.glPolyColor);
            this.pgl.bufferData(34962, n2, null, 35044);
            this.glPolyNormal = this.createVertexBufferObject(this.polyBuffersContext);
            this.pgl.bindBuffer(34962, this.glPolyNormal);
            this.pgl.bufferData(34962, 3 * n, null, 35044);
            this.glPolyTexcoord = this.createVertexBufferObject(this.polyBuffersContext);
            this.pgl.bindBuffer(34962, this.glPolyTexcoord);
            this.pgl.bufferData(34962, 2 * n, null, 35044);
            this.glPolyAmbient = pgPrimary.createVertexBufferObject(this.polyBuffersContext);
            this.pgl.bindBuffer(34962, this.glPolyAmbient);
            this.pgl.bufferData(34962, n2, null, 35044);
            this.glPolySpecular = pgPrimary.createVertexBufferObject(this.polyBuffersContext);
            this.pgl.bindBuffer(34962, this.glPolySpecular);
            this.pgl.bufferData(34962, n2, null, 35044);
            this.glPolyEmissive = pgPrimary.createVertexBufferObject(this.polyBuffersContext);
            this.pgl.bindBuffer(34962, this.glPolyEmissive);
            this.pgl.bufferData(34962, n2, null, 35044);
            this.glPolyShininess = pgPrimary.createVertexBufferObject(this.polyBuffersContext);
            this.pgl.bindBuffer(34962, this.glPolyShininess);
            this.pgl.bufferData(34962, n, null, 35044);
            this.pgl.bindBuffer(34962, 0);
            this.glPolyIndex = this.createVertexBufferObject(this.polyBuffersContext);
            this.pgl.bindBuffer(34963, this.glPolyIndex);
            this.pgl.bufferData(34963, n3, null, 35044);
            this.pgl.bindBuffer(34963, 0);
            this.polyBuffersCreated = true;
        }
    }

    protected void updatePolyBuffers(boolean bl, boolean bl2) {
        this.createPolyBuffers();
        int n = this.tessGeo.polyVertexCount;
        int n2 = n * 4;
        int n3 = n * 4;
        this.tessGeo.updatePolyVerticesBuffer();
        this.pgl.bindBuffer(34962, this.glPolyVertex);
        this.pgl.bufferData(34962, 4 * n2, this.tessGeo.polyVerticesBuffer, 35044);
        this.tessGeo.updatePolyColorsBuffer();
        this.pgl.bindBuffer(34962, this.glPolyColor);
        this.pgl.bufferData(34962, n3, this.tessGeo.polyColorsBuffer, 35044);
        if (bl) {
            this.tessGeo.updatePolyNormalsBuffer();
            this.pgl.bindBuffer(34962, this.glPolyNormal);
            this.pgl.bufferData(34962, 3 * n2, this.tessGeo.polyNormalsBuffer, 35044);
            this.tessGeo.updatePolyAmbientBuffer();
            this.pgl.bindBuffer(34962, this.glPolyAmbient);
            this.pgl.bufferData(34962, n3, this.tessGeo.polyAmbientBuffer, 35044);
            this.tessGeo.updatePolySpecularBuffer();
            this.pgl.bindBuffer(34962, this.glPolySpecular);
            this.pgl.bufferData(34962, n3, this.tessGeo.polySpecularBuffer, 35044);
            this.tessGeo.updatePolyEmissiveBuffer();
            this.pgl.bindBuffer(34962, this.glPolyEmissive);
            this.pgl.bufferData(34962, n3, this.tessGeo.polyEmissiveBuffer, 35044);
            this.tessGeo.updatePolyShininessBuffer();
            this.pgl.bindBuffer(34962, this.glPolyShininess);
            this.pgl.bufferData(34962, n2, this.tessGeo.polyShininessBuffer, 35044);
        }
        if (bl2) {
            this.tessGeo.updatePolyTexCoordsBuffer();
            this.pgl.bindBuffer(34962, this.glPolyTexcoord);
            this.pgl.bufferData(34962, 2 * n2, this.tessGeo.polyTexCoordsBuffer, 35044);
        }
        this.tessGeo.updatePolyIndicesBuffer();
        this.pgl.bindBuffer(34963, this.glPolyIndex);
        this.pgl.bufferData(34963, this.tessGeo.polyIndexCount * 2, this.tessGeo.polyIndicesBuffer, 35044);
    }

    protected void unbindPolyBuffers() {
        this.pgl.bindBuffer(34962, 0);
        this.pgl.bindBuffer(34963, 0);
    }

    protected boolean polyBuffersContextIsOutdated() {
        return !this.pgl.contextIsCurrent(this.polyBuffersContext);
    }

    protected void deletePolyBuffers() {
        if (this.polyBuffersCreated) {
            this.deleteVertexBufferObject(this.glPolyVertex, this.polyBuffersContext);
            this.glPolyVertex = 0;
            this.deleteVertexBufferObject(this.glPolyColor, this.polyBuffersContext);
            this.glPolyColor = 0;
            this.deleteVertexBufferObject(this.glPolyNormal, this.polyBuffersContext);
            this.glPolyNormal = 0;
            this.deleteVertexBufferObject(this.glPolyTexcoord, this.polyBuffersContext);
            this.glPolyTexcoord = 0;
            this.deleteVertexBufferObject(this.glPolyAmbient, this.polyBuffersContext);
            this.glPolyAmbient = 0;
            this.deleteVertexBufferObject(this.glPolySpecular, this.polyBuffersContext);
            this.glPolySpecular = 0;
            this.deleteVertexBufferObject(this.glPolyEmissive, this.polyBuffersContext);
            this.glPolyEmissive = 0;
            this.deleteVertexBufferObject(this.glPolyShininess, this.polyBuffersContext);
            this.glPolyShininess = 0;
            this.deleteVertexBufferObject(this.glPolyIndex, this.polyBuffersContext);
            this.glPolyIndex = 0;
            this.polyBuffersCreated = false;
        }
    }

    protected void createLineBuffers() {
        if (!this.lineBuffersCreated || this.lineBufferContextIsOutdated()) {
            this.lineBuffersContext = this.pgl.getCurrentContext();
            int n = 1024;
            int n2 = 1024;
            int n3 = 1024;
            this.glLineVertex = this.createVertexBufferObject(this.lineBuffersContext);
            this.pgl.bindBuffer(34962, this.glLineVertex);
            this.pgl.bufferData(34962, 3 * n, null, 35044);
            this.glLineColor = this.createVertexBufferObject(this.lineBuffersContext);
            this.pgl.bindBuffer(34962, this.glLineColor);
            this.pgl.bufferData(34962, n2, null, 35044);
            this.glLineAttrib = this.createVertexBufferObject(this.lineBuffersContext);
            this.pgl.bindBuffer(34962, this.glLineAttrib);
            this.pgl.bufferData(34962, 4 * n, null, 35044);
            this.pgl.bindBuffer(34962, 0);
            this.glLineIndex = this.createVertexBufferObject(this.lineBuffersContext);
            this.pgl.bindBuffer(34963, this.glLineIndex);
            this.pgl.bufferData(34963, n3, null, 35044);
            this.pgl.bindBuffer(34963, 0);
            this.lineBuffersCreated = true;
        }
    }

    protected void updateLineBuffers() {
        this.createLineBuffers();
        int n = this.tessGeo.lineVertexCount;
        int n2 = n * 4;
        int n3 = n * 4;
        this.tessGeo.updateLineVerticesBuffer();
        this.pgl.bindBuffer(34962, this.glLineVertex);
        this.pgl.bufferData(34962, 4 * n2, this.tessGeo.lineVerticesBuffer, 35044);
        this.tessGeo.updateLineColorsBuffer();
        this.pgl.bindBuffer(34962, this.glLineColor);
        this.pgl.bufferData(34962, n3, this.tessGeo.lineColorsBuffer, 35044);
        this.tessGeo.updateLineDirectionsBuffer();
        this.pgl.bindBuffer(34962, this.glLineAttrib);
        this.pgl.bufferData(34962, 4 * n2, this.tessGeo.lineDirectionsBuffer, 35044);
        this.tessGeo.updateLineIndicesBuffer();
        this.pgl.bindBuffer(34963, this.glLineIndex);
        this.pgl.bufferData(34963, this.tessGeo.lineIndexCount * 2, this.tessGeo.lineIndicesBuffer, 35044);
    }

    protected void unbindLineBuffers() {
        this.pgl.bindBuffer(34962, 0);
        this.pgl.bindBuffer(34963, 0);
    }

    protected boolean lineBufferContextIsOutdated() {
        return !this.pgl.contextIsCurrent(this.lineBuffersContext);
    }

    protected void deleteLineBuffers() {
        if (this.lineBuffersCreated) {
            this.deleteVertexBufferObject(this.glLineVertex, this.lineBuffersContext);
            this.glLineVertex = 0;
            this.deleteVertexBufferObject(this.glLineColor, this.lineBuffersContext);
            this.glLineColor = 0;
            this.deleteVertexBufferObject(this.glLineAttrib, this.lineBuffersContext);
            this.glLineAttrib = 0;
            this.deleteVertexBufferObject(this.glLineIndex, this.lineBuffersContext);
            this.glLineIndex = 0;
            this.lineBuffersCreated = false;
        }
    }

    protected void createPointBuffers() {
        if (!this.pointBuffersCreated || this.pointBuffersContextIsOutdated()) {
            this.pointBuffersContext = this.pgl.getCurrentContext();
            int n = 1024;
            int n2 = 1024;
            int n3 = 1024;
            this.glPointVertex = this.createVertexBufferObject(this.pointBuffersContext);
            this.pgl.bindBuffer(34962, this.glPointVertex);
            this.pgl.bufferData(34962, 3 * n, null, 35044);
            this.glPointColor = this.createVertexBufferObject(this.pointBuffersContext);
            this.pgl.bindBuffer(34962, this.glPointColor);
            this.pgl.bufferData(34962, n2, null, 35044);
            this.glPointAttrib = this.createVertexBufferObject(this.pointBuffersContext);
            this.pgl.bindBuffer(34962, this.glPointAttrib);
            this.pgl.bufferData(34962, 2 * n, null, 35044);
            this.pgl.bindBuffer(34962, 0);
            this.glPointIndex = this.createVertexBufferObject(this.pointBuffersContext);
            this.pgl.bindBuffer(34963, this.glPointIndex);
            this.pgl.bufferData(34963, n3, null, 35044);
            this.pgl.bindBuffer(34963, 0);
            this.pointBuffersCreated = true;
        }
    }

    protected void updatePointBuffers() {
        this.createPointBuffers();
        int n = this.tessGeo.pointVertexCount;
        int n2 = n * 4;
        int n3 = n * 4;
        this.tessGeo.updatePointVerticesBuffer();
        this.pgl.bindBuffer(34962, this.glPointVertex);
        this.pgl.bufferData(34962, 4 * n2, this.tessGeo.pointVerticesBuffer, 35044);
        this.tessGeo.updatePointColorsBuffer();
        this.pgl.bindBuffer(34962, this.glPointColor);
        this.pgl.bufferData(34962, n3, this.tessGeo.pointColorsBuffer, 35044);
        this.tessGeo.updatePointOffsetsBuffer();
        this.pgl.bindBuffer(34962, this.glPointAttrib);
        this.pgl.bufferData(34962, 2 * n2, this.tessGeo.pointOffsetsBuffer, 35044);
        this.tessGeo.updatePointIndicesBuffer();
        this.pgl.bindBuffer(34963, this.glPointIndex);
        this.pgl.bufferData(34963, this.tessGeo.pointIndexCount * 2, this.tessGeo.pointIndicesBuffer, 35044);
    }

    protected void unbindPointBuffers() {
        this.pgl.bindBuffer(34962, 0);
        this.pgl.bindBuffer(34963, 0);
    }

    protected boolean pointBuffersContextIsOutdated() {
        return !this.pgl.contextIsCurrent(this.pointBuffersContext);
    }

    protected void deletePointBuffers() {
        if (this.pointBuffersCreated) {
            this.deleteVertexBufferObject(this.glPointVertex, this.pointBuffersContext);
            this.glPointVertex = 0;
            this.deleteVertexBufferObject(this.glPointColor, this.pointBuffersContext);
            this.glPointColor = 0;
            this.deleteVertexBufferObject(this.glPointAttrib, this.pointBuffersContext);
            this.glPointAttrib = 0;
            this.deleteVertexBufferObject(this.glPointIndex, this.pointBuffersContext);
            this.glPointIndex = 0;
            this.pointBuffersCreated = false;
        }
    }

    @Override
    public boolean canDraw() {
        return this.pgl.canDraw();
    }

    @Override
    public void requestDraw() {
        if (this.primarySurface) {
            if (this.initialized) {
                this.pgl.requestDraw();
            } else {
                this.initPrimary();
            }
        }
    }

    @Override
    public void beginDraw() {
        this.report("top beginDraw()");
        if (!this.checkGLThread()) {
            return;
        }
        if (this.drawing) {
            PGraphics.showWarning(ALREADY_DRAWING_ERROR);
            return;
        }
        if (pgCurrent != null && !PGraphicsOpenGL.pgCurrent.primarySurface && !this.primarySurface) {
            PGraphics.showWarning(NESTED_DRAW_ERROR);
            return;
        }
        if (!glParamsRead) {
            this.getGLParameters();
        }
        if (this.primarySurface) {
            this.beginOnscreenDraw();
        } else {
            this.beginOffscreenDraw();
        }
        this.setDefaults();
        pgCurrent = this;
        this.drawing = true;
        this.report("bot beginDraw()");
    }

    @Override
    public void endDraw() {
        this.report("top endDraw()");
        if (!this.drawing) {
            PGraphics.showWarning(NO_BEGIN_DRAW_ERROR);
            return;
        }
        this.flush();
        if (this.primarySurface) {
            this.endOnscreenDraw();
        } else {
            this.endOffscreenDraw();
        }
        pgCurrent = pgCurrent == pgPrimary ? null : pgPrimary;
        this.drawing = false;
        this.report("bot endDraw()");
    }

    @Override
    public PGL beginPGL() {
        this.flush();
        this.pgl.beginGL();
        return this.pgl;
    }

    @Override
    public void endPGL() {
        this.pgl.endGL();
        this.restoreGL();
    }

    public void updateProjmodelview() {
        this.projmodelview.set(this.projection);
        this.projmodelview.apply(this.modelview);
    }

    protected void restartPGL() {
        this.initialized = false;
    }

    protected void restoreGL() {
        this.setBlendMode(this.blendMode);
        if (this.hints[2]) {
            this.pgl.disable(2929);
        } else {
            this.pgl.enable(2929);
        }
        this.pgl.depthFunc(515);
        if (this.quality < 2) {
            this.pgl.disable(-1);
        } else {
            this.pgl.enable(-1);
            this.pgl.disable(-1);
            this.pgl.disable(-1);
            this.pgl.disable(-1);
        }
        this.pgl.viewport(this.viewport.get(0), this.viewport.get(1), this.viewport.get(2), this.viewport.get(3));
        if (this.clip) {
            this.pgl.enable(3089);
            this.pgl.scissor(this.clipRect[0], this.clipRect[1], this.clipRect[2], this.clipRect[3]);
        } else {
            this.pgl.disable(3089);
        }
        this.pgl.frontFace(2304);
        this.pgl.disable(2884);
        this.pgl.activeTexture(33984);
        if (this.hints[5]) {
            this.pgl.depthMask(false);
        } else {
            this.pgl.depthMask(true);
        }
        currentFramebuffer.bind();
        this.pgl.drawBuffer(currentFramebuffer.getDefaultDrawBuffer());
    }

    protected void beginPixelsOp(int n) {
        FrameBuffer frameBuffer = null;
        if (this.primarySurface) {
            if (n == 1) {
                if (this.pgl.isFBOBacked() && this.pgl.isMultisampled()) {
                    this.pgl.syncBackTexture();
                    frameBuffer = readFramebuffer;
                } else {
                    frameBuffer = drawFramebuffer;
                }
            } else if (n == 2) {
                frameBuffer = drawFramebuffer;
            }
        } else if (n == 1) {
            if (this.offscreenMultisample) {
                this.multisampleFramebuffer.copy(this.offscreenFramebuffer, currentFramebuffer);
            }
            frameBuffer = this.offscreenFramebuffer;
        } else if (n == 2) {
            FrameBuffer frameBuffer2 = frameBuffer = this.offscreenMultisample ? this.multisampleFramebuffer : this.offscreenFramebuffer;
        }
        if (frameBuffer != currentFramebuffer) {
            this.pushFramebuffer();
            this.setFramebuffer(frameBuffer);
            this.pixOpChangedFB = true;
        }
        if (n == 1) {
            this.pgl.readBuffer(currentFramebuffer.getDefaultDrawBuffer());
        } else if (n == 2) {
            this.pgl.drawBuffer(currentFramebuffer.getDefaultDrawBuffer());
        }
        this.pixelsOp = n;
    }

    protected void endPixelsOp() {
        if (this.pixOpChangedFB) {
            this.popFramebuffer();
            this.pixOpChangedFB = false;
        }
        this.pgl.readBuffer(currentFramebuffer.getDefaultReadBuffer());
        this.pgl.drawBuffer(currentFramebuffer.getDefaultDrawBuffer());
        this.pixelsOp = 0;
    }

    protected void updateGLProjection() {
        if (this.glProjection == null) {
            this.glProjection = new float[16];
        }
        this.glProjection[0] = this.projection.m00;
        this.glProjection[1] = this.projection.m10;
        this.glProjection[2] = this.projection.m20;
        this.glProjection[3] = this.projection.m30;
        this.glProjection[4] = this.projection.m01;
        this.glProjection[5] = this.projection.m11;
        this.glProjection[6] = this.projection.m21;
        this.glProjection[7] = this.projection.m31;
        this.glProjection[8] = this.projection.m02;
        this.glProjection[9] = this.projection.m12;
        this.glProjection[10] = this.projection.m22;
        this.glProjection[11] = this.projection.m32;
        this.glProjection[12] = this.projection.m03;
        this.glProjection[13] = this.projection.m13;
        this.glProjection[14] = this.projection.m23;
        this.glProjection[15] = this.projection.m33;
    }

    protected void updateGLModelview() {
        if (this.glModelview == null) {
            this.glModelview = new float[16];
        }
        this.glModelview[0] = this.modelview.m00;
        this.glModelview[1] = this.modelview.m10;
        this.glModelview[2] = this.modelview.m20;
        this.glModelview[3] = this.modelview.m30;
        this.glModelview[4] = this.modelview.m01;
        this.glModelview[5] = this.modelview.m11;
        this.glModelview[6] = this.modelview.m21;
        this.glModelview[7] = this.modelview.m31;
        this.glModelview[8] = this.modelview.m02;
        this.glModelview[9] = this.modelview.m12;
        this.glModelview[10] = this.modelview.m22;
        this.glModelview[11] = this.modelview.m32;
        this.glModelview[12] = this.modelview.m03;
        this.glModelview[13] = this.modelview.m13;
        this.glModelview[14] = this.modelview.m23;
        this.glModelview[15] = this.modelview.m33;
    }

    protected void updateGLProjmodelview() {
        if (this.glProjmodelview == null) {
            this.glProjmodelview = new float[16];
        }
        this.glProjmodelview[0] = this.projmodelview.m00;
        this.glProjmodelview[1] = this.projmodelview.m10;
        this.glProjmodelview[2] = this.projmodelview.m20;
        this.glProjmodelview[3] = this.projmodelview.m30;
        this.glProjmodelview[4] = this.projmodelview.m01;
        this.glProjmodelview[5] = this.projmodelview.m11;
        this.glProjmodelview[6] = this.projmodelview.m21;
        this.glProjmodelview[7] = this.projmodelview.m31;
        this.glProjmodelview[8] = this.projmodelview.m02;
        this.glProjmodelview[9] = this.projmodelview.m12;
        this.glProjmodelview[10] = this.projmodelview.m22;
        this.glProjmodelview[11] = this.projmodelview.m32;
        this.glProjmodelview[12] = this.projmodelview.m03;
        this.glProjmodelview[13] = this.projmodelview.m13;
        this.glProjmodelview[14] = this.projmodelview.m23;
        this.glProjmodelview[15] = this.projmodelview.m33;
    }

    protected void updateGLNormal() {
        if (this.glNormal == null) {
            this.glNormal = new float[9];
        }
        this.glNormal[0] = this.modelviewInv.m00;
        this.glNormal[1] = this.modelviewInv.m01;
        this.glNormal[2] = this.modelviewInv.m02;
        this.glNormal[3] = this.modelviewInv.m10;
        this.glNormal[4] = this.modelviewInv.m11;
        this.glNormal[5] = this.modelviewInv.m12;
        this.glNormal[6] = this.modelviewInv.m20;
        this.glNormal[7] = this.modelviewInv.m21;
        this.glNormal[8] = this.modelviewInv.m22;
    }

    @Override
    protected void defaultSettings() {
        super.defaultSettings();
        this.manipulatingCamera = false;
        this.clearColorBuffer = false;
        this.textureMode(2);
        this.ambient(255);
        this.specular(125);
        this.emissive(0);
        this.shininess(1.0f);
        this.setAmbient = false;
    }

    @Override
    public void hint(int n) {
        boolean bl = this.hints[PApplet.abs(n)];
        super.hint(n);
        boolean bl2 = this.hints[PApplet.abs(n)];
        if (bl == bl2) {
            return;
        }
        if (n == 2) {
            this.flush();
            this.pgl.disable(2929);
        } else if (n == -2) {
            this.flush();
            this.pgl.enable(2929);
        } else if (n == 5) {
            this.flush();
            this.pgl.depthMask(false);
        } else if (n == -5) {
            this.flush();
            this.pgl.depthMask(true);
        } else if (n == -6) {
            this.flush();
            this.setFlushMode(1);
        } else if (n == 6) {
            this.flush();
            this.setFlushMode(0);
        } else if (n == -7) {
            if (0 < this.tessGeo.lineVertexCount && 0 < this.tessGeo.lineIndexCount) {
                this.flush();
            }
        } else if (n == 7 && 0 < this.tessGeo.lineVertexCount && 0 < this.tessGeo.lineIndexCount) {
            this.flush();
        }
    }

    protected boolean getHint(int n) {
        if (n > 0) {
            return this.hints[n];
        }
        return !this.hints[-n];
    }

    @Override
    public void beginShape(int n) {
        this.shape = n;
        this.curveVertexCount = 0;
        this.inGeo.clear();
        this.breakShape = true;
        this.defaultEdges = true;
        this.textureImage0 = this.textureImage;
        super.noTexture();
        this.normalMode = 0;
    }

    @Override
    public void endShape(int n) {
        this.tessellate(n);
        if (this.flushMode == 0 || this.flushMode == 1 && this.tessGeo.isFull()) {
            this.flush();
        }
    }

    protected void endShape(int[] nArray) {
        this.endShape(nArray, null);
    }

    protected void endShape(int[] nArray, int[] nArray2) {
        if (this.shape != 8 && this.shape != 9) {
            throw new RuntimeException("Indices and edges can only be set for TRIANGLE shapes");
        }
        this.tessellate(nArray, nArray2);
        if (this.flushMode == 0 || this.flushMode == 1 && this.tessGeo.isFull()) {
            this.flush();
        }
    }

    @Override
    public void textureWrap(int n) {
        this.textureWrap = n;
    }

    public void textureSampling(int n) {
        this.textureSampling = n;
    }

    @Override
    public void beginContour() {
        if (this.openContour) {
            PGraphics.showWarning(ALREADY_BEGAN_CONTOUR_ERROR);
            return;
        }
        this.openContour = true;
        this.breakShape = true;
    }

    @Override
    public void endContour() {
        if (!this.openContour) {
            PGraphics.showWarning(NO_BEGIN_CONTOUR_ERROR);
            return;
        }
        this.openContour = false;
    }

    @Override
    public void vertex(float f, float f2) {
        this.vertexImpl(f, f2, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public void vertex(float f, float f2, float f3, float f4) {
        this.vertexImpl(f, f2, 0.0f, f3, f4);
    }

    @Override
    public void vertex(float f, float f2, float f3) {
        this.vertexImpl(f, f2, f3, 0.0f, 0.0f);
    }

    @Override
    public void vertex(float f, float f2, float f3, float f4, float f5) {
        this.vertexImpl(f, f2, f3, f4, f5);
    }

    protected void vertexImpl(float f, float f2, float f3, float f4, float f5) {
        boolean bl = this.textureImage != null;
        int n = 0;
        if (this.fill || bl) {
            n = !bl ? this.fillColor : (this.tint ? this.tintColor : -1);
        }
        int n2 = 0;
        float f6 = 0.0f;
        if (this.stroke) {
            n2 = this.strokeColor;
            f6 = this.strokeWeight;
        }
        if (bl && this.textureMode == 2) {
            f4 = PApplet.min(1.0f, f4 / (float)this.textureImage.width);
            f5 = PApplet.min(1.0f, f5 / (float)this.textureImage.height);
        }
        this.inGeo.addVertex(f, f2, f3, n, this.normalX, this.normalY, this.normalZ, f4, f5, n2, f6, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess, this.vertexCode());
    }

    protected int vertexCode() {
        int n = 0;
        if (this.breakShape) {
            n = 4;
            this.breakShape = false;
        }
        return n;
    }

    @Override
    protected void clipImpl(float f, float f2, float f3, float f4) {
        this.flush();
        this.pgl.enable(3089);
        float f5 = f4 - f2;
        this.clipRect[0] = (int)f;
        this.clipRect[1] = (int)((float)this.height - f2 - f5);
        this.clipRect[2] = (int)(f3 - f);
        this.clipRect[3] = (int)f5;
        this.pgl.scissor(this.clipRect[0], this.clipRect[1], this.clipRect[2], this.clipRect[3]);
        this.clip = true;
    }

    @Override
    public void noClip() {
        if (this.clip) {
            this.flush();
            this.pgl.disable(3089);
            this.clip = false;
        }
    }

    protected void tessellate(int n) {
        tessellator.setInGeometry(this.inGeo);
        tessellator.setTessGeometry(this.tessGeo);
        tessellator.setFill(this.fill || this.textureImage != null);
        tessellator.setStroke(this.stroke);
        tessellator.setStrokeColor(this.strokeColor);
        tessellator.setStrokeWeight(this.strokeWeight);
        tessellator.setStrokeCap(this.strokeCap);
        tessellator.setStrokeJoin(this.strokeJoin);
        tessellator.setTexCache(this.texCache, this.textureImage0, this.textureImage);
        tessellator.setTransform(this.modelview);
        tessellator.set3D(this.is3D());
        if (this.shape == 3) {
            tessellator.tessellatePoints();
        } else if (this.shape == 5) {
            tessellator.tessellateLines();
        } else if (this.shape == 50) {
            tessellator.tessellateLineStrip();
        } else if (this.shape == 51) {
            tessellator.tessellateLineLoop();
        } else if (this.shape == 8 || this.shape == 9) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addTrianglesEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcTrianglesNormals();
            }
            tessellator.tessellateTriangles();
        } else if (this.shape == 11) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addTriangleFanEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcTriangleFanNormals();
            }
            tessellator.tessellateTriangleFan();
        } else if (this.shape == 10) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addTriangleStripEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcTriangleStripNormals();
            }
            tessellator.tessellateTriangleStrip();
        } else if (this.shape == 16 || this.shape == 17) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addQuadsEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcQuadsNormals();
            }
            tessellator.tessellateQuads();
        } else if (this.shape == 18) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addQuadStripEdges();
            }
            if (this.normalMode == 0) {
                this.inGeo.calcQuadStripNormals();
            }
            tessellator.tessellateQuadStrip();
        } else if (this.shape == 20) {
            if (this.stroke && this.defaultEdges) {
                this.inGeo.addPolygonEdges(n == 2);
            }
            tessellator.tessellatePolygon(false, n == 2, this.normalMode == 0);
        }
    }

    protected void tessellate(int[] nArray, int[] nArray2) {
        if (nArray2 != null) {
            int n = nArray2.length / 2;
            for (int i = 0; i < n; ++i) {
                int n2 = nArray2[2 * i + 0];
                int n3 = nArray2[2 * i + 1];
                this.inGeo.addEdge(n2, n3, i == 0, i == n - 1);
            }
        }
        tessellator.setInGeometry(this.inGeo);
        tessellator.setTessGeometry(this.tessGeo);
        tessellator.setFill(this.fill || this.textureImage != null);
        tessellator.setStroke(this.stroke);
        tessellator.setStrokeColor(this.strokeColor);
        tessellator.setStrokeWeight(this.strokeWeight);
        tessellator.setStrokeCap(this.strokeCap);
        tessellator.setStrokeJoin(this.strokeJoin);
        tessellator.setTexCache(this.texCache, this.textureImage0, this.textureImage);
        tessellator.setTransform(this.modelview);
        tessellator.set3D(this.is3D());
        if (this.stroke && this.defaultEdges && nArray2 == null) {
            this.inGeo.addTrianglesEdges();
        }
        if (this.normalMode == 0) {
            this.inGeo.calcTrianglesNormals();
        }
        tessellator.tessellateTriangles(nArray);
    }

    @Override
    public void flush() {
        boolean bl;
        boolean bl2 = 0 < this.tessGeo.polyVertexCount && 0 < this.tessGeo.polyIndexCount;
        boolean bl3 = 0 < this.tessGeo.lineVertexCount && 0 < this.tessGeo.lineIndexCount;
        boolean bl4 = 0 < this.tessGeo.pointVertexCount && 0 < this.tessGeo.pointIndexCount;
        boolean bl5 = bl = this.modified && this.pixels != null;
        if (bl) {
            this.flushPixels();
        }
        if (bl4 || bl3 || bl2) {
            PMatrix3D pMatrix3D = null;
            PMatrix3D pMatrix3D2 = null;
            if (this.flushMode == 1) {
                pMatrix3D = this.modelview;
                pMatrix3D2 = this.modelviewInv;
                this.modelview = this.modelviewInv = identity;
                this.projmodelview.set(this.projection);
            }
            if (bl2) {
                this.flushPolys();
                if (this.raw != null) {
                    this.rawPolys();
                }
            }
            if (this.is3D()) {
                if (bl3) {
                    this.flushLines();
                    if (this.raw != null) {
                        this.rawLines();
                    }
                }
                if (bl4) {
                    this.flushPoints();
                    if (this.raw != null) {
                        this.rawPoints();
                    }
                }
            }
            if (this.flushMode == 1) {
                this.modelview = pMatrix3D;
                this.modelviewInv = pMatrix3D2;
                this.updateProjmodelview();
            }
        }
        this.tessGeo.clear();
        this.texCache.clear();
        this.setgetPixels = false;
    }

    protected void flushPixels() {
        this.drawPixels(this.mx1, this.my1, this.mx2 - this.mx1 + 1, this.my2 - this.my1 + 1);
        this.modified = false;
    }

    protected void flushPolys() {
        this.updatePolyBuffers(this.lights, this.texCache.hasTexture);
        this.texCache.beginRender();
        for (int i = 0; i < this.texCache.size; ++i) {
            Texture texture = this.texCache.getTexture(i);
            BaseShader baseShader = this.getPolyShader(this.lights, texture != null);
            baseShader.bind();
            int n = this.texCache.firstCache[i];
            int n2 = this.texCache.lastCache[i];
            IndexCache indexCache = this.tessGeo.polyIndexCache;
            for (int j = n; j <= n2; ++j) {
                int n3 = j == n ? this.texCache.firstIndex[i] : indexCache.indexOffset[j];
                int n4 = j == n2 ? this.texCache.lastIndex[i] - n3 + 1 : indexCache.indexOffset[j] + indexCache.indexCount[j] - n3;
                int n5 = indexCache.vertexOffset[j];
                baseShader.setVertexAttribute(this.glPolyVertex, 4, 5126, 0, 4 * n5 * 4);
                baseShader.setColorAttribute(this.glPolyColor, 4, 5121, 0, 4 * n5 * 1);
                if (this.lights) {
                    baseShader.setNormalAttribute(this.glPolyNormal, 3, 5126, 0, 3 * n5 * 4);
                    baseShader.setAmbientAttribute(this.glPolyAmbient, 4, 5121, 0, 4 * n5 * 1);
                    baseShader.setSpecularAttribute(this.glPolySpecular, 4, 5121, 0, 4 * n5 * 1);
                    baseShader.setEmissiveAttribute(this.glPolyEmissive, 4, 5121, 0, 4 * n5 * 1);
                    baseShader.setShininessAttribute(this.glPolyShininess, 1, 5126, 0, n5 * 4);
                }
                if (texture != null) {
                    baseShader.setTexcoordAttribute(this.glPolyTexcoord, 2, 5126, 0, 2 * n5 * 4);
                    baseShader.setTexture(texture);
                }
                this.pgl.bindBuffer(34963, this.glPolyIndex);
                this.pgl.drawElements(4, n4, 5123, n3 * 2);
                this.pgl.bindBuffer(34963, 0);
            }
            baseShader.unbind();
        }
        this.texCache.endRender();
        this.unbindPolyBuffers();
    }

    void rawPolys() {
        this.raw.colorMode(1);
        this.raw.noStroke();
        this.raw.beginShape(9);
        float[] fArray = this.tessGeo.polyVertices;
        int[] nArray = this.tessGeo.polyColors;
        float[] fArray2 = this.tessGeo.polyTexCoords;
        short[] sArray = this.tessGeo.polyIndices;
        for (int i = 0; i < this.texCache.size; ++i) {
            PImage pImage = this.texCache.getTextureImage(i);
            int n = this.texCache.firstCache[i];
            int n2 = this.texCache.lastCache[i];
            IndexCache indexCache = this.tessGeo.polyIndexCache;
            for (int j = n; j <= n2; ++j) {
                int n3 = j == n ? this.texCache.firstIndex[i] : indexCache.indexOffset[j];
                int n4 = j == n2 ? this.texCache.lastIndex[i] - n3 + 1 : indexCache.indexOffset[j] + indexCache.indexCount[j] - n3;
                int n5 = indexCache.vertexOffset[j];
                for (int k = n3 / 3; k < (n3 + n4) / 3; ++k) {
                    float f;
                    float f2;
                    float f3;
                    int n6 = n5 + sArray[3 * k + 0];
                    int n7 = n5 + sArray[3 * k + 1];
                    int n8 = n5 + sArray[3 * k + 2];
                    float[] fArray3 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    float[] fArray4 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    float[] fArray5 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    int n9 = PGL.nativeToJavaARGB(nArray[n6]);
                    int n10 = PGL.nativeToJavaARGB(nArray[n7]);
                    int n11 = PGL.nativeToJavaARGB(nArray[n8]);
                    if (this.flushMode == 0) {
                        float[] fArray6 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                        float[] fArray7 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                        float[] fArray8 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                        PApplet.arrayCopy(fArray, 4 * n6, fArray6, 0, 4);
                        PApplet.arrayCopy(fArray, 4 * n7, fArray7, 0, 4);
                        PApplet.arrayCopy(fArray, 4 * n8, fArray8, 0, 4);
                        this.modelview.mult(fArray6, fArray3);
                        this.modelview.mult(fArray7, fArray4);
                        this.modelview.mult(fArray8, fArray5);
                    } else {
                        PApplet.arrayCopy(fArray, 4 * n6, fArray3, 0, 4);
                        PApplet.arrayCopy(fArray, 4 * n7, fArray4, 0, 4);
                        PApplet.arrayCopy(fArray, 4 * n8, fArray5, 0, 4);
                    }
                    if (pImage != null) {
                        this.raw.texture(pImage);
                        if (this.raw.is3D()) {
                            this.raw.fill(n9);
                            this.raw.vertex(fArray3[0], fArray3[1], fArray3[2], fArray2[2 * n6 + 0], fArray2[2 * n6 + 1]);
                            this.raw.fill(n10);
                            this.raw.vertex(fArray4[0], fArray4[1], fArray4[2], fArray2[2 * n7 + 0], fArray2[2 * n7 + 1]);
                            this.raw.fill(n11);
                            this.raw.vertex(fArray5[0], fArray5[1], fArray5[2], fArray2[2 * n8 + 0], fArray2[2 * n8 + 1]);
                            continue;
                        }
                        if (!this.raw.is2D()) continue;
                        float f4 = this.screenXImpl(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
                        float f5 = this.screenYImpl(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
                        float f6 = this.screenXImpl(fArray4[0], fArray4[1], fArray4[2], fArray4[3]);
                        f3 = this.screenYImpl(fArray4[0], fArray4[1], fArray4[2], fArray4[3]);
                        f2 = this.screenXImpl(fArray5[0], fArray5[1], fArray5[2], fArray5[3]);
                        f = this.screenYImpl(fArray5[0], fArray5[1], fArray5[2], fArray5[3]);
                        this.raw.fill(n9);
                        this.raw.vertex(f4, f5, fArray2[2 * n6 + 0], fArray2[2 * n6 + 1]);
                        this.raw.fill(n10);
                        this.raw.vertex(f6, f3, fArray2[2 * n7 + 0], fArray2[2 * n7 + 1]);
                        this.raw.fill(n10);
                        this.raw.vertex(f2, f, fArray2[2 * n8 + 0], fArray2[2 * n8 + 1]);
                        continue;
                    }
                    if (this.raw.is3D()) {
                        this.raw.fill(n9);
                        this.raw.vertex(fArray3[0], fArray3[1], fArray3[2]);
                        this.raw.fill(n10);
                        this.raw.vertex(fArray4[0], fArray4[1], fArray4[2]);
                        this.raw.fill(n11);
                        this.raw.vertex(fArray5[0], fArray5[1], fArray5[2]);
                        continue;
                    }
                    if (!this.raw.is2D()) continue;
                    float f7 = this.screenXImpl(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
                    float f8 = this.screenYImpl(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
                    float f9 = this.screenXImpl(fArray4[0], fArray4[1], fArray4[2], fArray4[3]);
                    f3 = this.screenYImpl(fArray4[0], fArray4[1], fArray4[2], fArray4[3]);
                    f2 = this.screenXImpl(fArray5[0], fArray5[1], fArray5[2], fArray5[3]);
                    f = this.screenYImpl(fArray5[0], fArray5[1], fArray5[2], fArray5[3]);
                    this.raw.fill(n9);
                    this.raw.vertex(f7, f8);
                    this.raw.fill(n10);
                    this.raw.vertex(f9, f3);
                    this.raw.fill(n11);
                    this.raw.vertex(f2, f);
                }
            }
        }
        this.raw.endShape();
    }

    protected void flushLines() {
        this.updateLineBuffers();
        LineShader lineShader = this.getLineShader();
        lineShader.bind();
        IndexCache indexCache = this.tessGeo.lineIndexCache;
        for (int i = 0; i < indexCache.size; ++i) {
            int n = indexCache.indexOffset[i];
            int n2 = indexCache.indexCount[i];
            int n3 = indexCache.vertexOffset[i];
            lineShader.setVertexAttribute(this.glLineVertex, 4, 5126, 0, 4 * n3 * 4);
            lineShader.setColorAttribute(this.glLineColor, 4, 5121, 0, 4 * n3 * 1);
            lineShader.setLineAttribute(this.glLineAttrib, 4, 5126, 0, 4 * n3 * 4);
            this.pgl.bindBuffer(34963, this.glLineIndex);
            this.pgl.drawElements(4, n2, 5123, n * 2);
            this.pgl.bindBuffer(34963, 0);
        }
        lineShader.unbind();
        this.unbindLineBuffers();
    }

    void rawLines() {
        this.raw.colorMode(1);
        this.raw.noFill();
        this.raw.strokeCap(this.strokeCap);
        this.raw.strokeJoin(this.strokeJoin);
        this.raw.beginShape(5);
        float[] fArray = this.tessGeo.lineVertices;
        int[] nArray = this.tessGeo.lineColors;
        float[] fArray2 = this.tessGeo.lineDirections;
        short[] sArray = this.tessGeo.lineIndices;
        IndexCache indexCache = this.tessGeo.lineIndexCache;
        for (int i = 0; i < indexCache.size; ++i) {
            int n = indexCache.indexOffset[i];
            int n2 = indexCache.indexCount[i];
            int n3 = indexCache.vertexOffset[i];
            for (int j = n / 6; j < (n + n2) / 6; ++j) {
                int n4 = n3 + sArray[6 * j + 0];
                int n5 = n3 + sArray[6 * j + 5];
                float f = 2.0f * fArray2[4 * n4 + 3];
                float f2 = 2.0f * fArray2[4 * n5 + 3];
                if (PGraphicsOpenGL.zero(f)) continue;
                float[] fArray3 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                float[] fArray4 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                int n6 = PGL.nativeToJavaARGB(nArray[n4]);
                int n7 = PGL.nativeToJavaARGB(nArray[n5]);
                if (this.flushMode == 0) {
                    float[] fArray5 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    float[] fArray6 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    PApplet.arrayCopy(fArray, 4 * n4, fArray5, 0, 4);
                    PApplet.arrayCopy(fArray, 4 * n5, fArray6, 0, 4);
                    this.modelview.mult(fArray5, fArray3);
                    this.modelview.mult(fArray6, fArray4);
                } else {
                    PApplet.arrayCopy(fArray, 4 * n4, fArray3, 0, 4);
                    PApplet.arrayCopy(fArray, 4 * n5, fArray4, 0, 4);
                }
                if (this.raw.is3D()) {
                    this.raw.strokeWeight(f);
                    this.raw.stroke(n6);
                    this.raw.vertex(fArray3[0], fArray3[1], fArray3[2]);
                    this.raw.strokeWeight(f2);
                    this.raw.stroke(n7);
                    this.raw.vertex(fArray4[0], fArray4[1], fArray4[2]);
                    continue;
                }
                if (!this.raw.is2D()) continue;
                float f3 = this.screenXImpl(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
                float f4 = this.screenYImpl(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
                float f5 = this.screenXImpl(fArray4[0], fArray4[1], fArray4[2], fArray4[3]);
                float f6 = this.screenYImpl(fArray4[0], fArray4[1], fArray4[2], fArray4[3]);
                this.raw.strokeWeight(f);
                this.raw.stroke(n6);
                this.raw.vertex(f3, f4);
                this.raw.strokeWeight(f2);
                this.raw.stroke(n7);
                this.raw.vertex(f5, f6);
            }
        }
        this.raw.endShape();
    }

    protected void flushPoints() {
        this.updatePointBuffers();
        PointShader pointShader = this.getPointShader();
        pointShader.bind();
        IndexCache indexCache = this.tessGeo.pointIndexCache;
        for (int i = 0; i < indexCache.size; ++i) {
            int n = indexCache.indexOffset[i];
            int n2 = indexCache.indexCount[i];
            int n3 = indexCache.vertexOffset[i];
            pointShader.setVertexAttribute(this.glPointVertex, 4, 5126, 0, 4 * n3 * 4);
            pointShader.setColorAttribute(this.glPointColor, 4, 5121, 0, 4 * n3 * 1);
            pointShader.setPointAttribute(this.glPointAttrib, 2, 5126, 0, 2 * n3 * 4);
            this.pgl.bindBuffer(34963, this.glPointIndex);
            this.pgl.drawElements(4, n2, 5123, n * 2);
            this.pgl.bindBuffer(34963, 0);
        }
        pointShader.unbind();
        this.unbindPointBuffers();
    }

    void rawPoints() {
        this.raw.colorMode(1);
        this.raw.noFill();
        this.raw.strokeCap(this.strokeCap);
        this.raw.beginShape(3);
        float[] fArray = this.tessGeo.pointVertices;
        int[] nArray = this.tessGeo.pointColors;
        float[] fArray2 = this.tessGeo.pointOffsets;
        short[] sArray = this.tessGeo.pointIndices;
        IndexCache indexCache = this.tessGeo.pointIndexCache;
        for (int i = 0; i < indexCache.size; ++i) {
            int n;
            int n2 = indexCache.indexOffset[i];
            int n3 = indexCache.indexCount[i];
            int n4 = indexCache.vertexOffset[i];
            for (int j = n2; j < (n2 + n3) / 3; j += n) {
                float f;
                float f2 = fArray2[2 * j + 2];
                if (0.0f < f2) {
                    f = f2 / 0.5f;
                    n = PApplet.max(20, (int)((float)Math.PI * 2 * f / 10.0f)) + 1;
                } else {
                    f = -f2 / 0.5f;
                    n = 5;
                }
                int n5 = n4 + sArray[3 * j];
                int n6 = PGL.nativeToJavaARGB(nArray[n5]);
                float[] fArray3 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                if (this.flushMode == 0) {
                    float[] fArray4 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};
                    PApplet.arrayCopy(fArray, 4 * n5, fArray4, 0, 4);
                    this.modelview.mult(fArray4, fArray3);
                } else {
                    PApplet.arrayCopy(fArray, 4 * n5, fArray3, 0, 4);
                }
                if (this.raw.is3D()) {
                    this.raw.strokeWeight(f);
                    this.raw.stroke(n6);
                    this.raw.vertex(fArray3[0], fArray3[1], fArray3[2]);
                    continue;
                }
                if (!this.raw.is2D()) continue;
                float f3 = this.screenXImpl(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
                float f4 = this.screenYImpl(fArray3[0], fArray3[1], fArray3[2], fArray3[3]);
                this.raw.strokeWeight(f);
                this.raw.stroke(n6);
                this.raw.vertex(f3, f4);
            }
        }
        this.raw.endShape();
    }

    @Override
    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        this.bezierVertexImpl(f, f2, 0.0f, f3, f4, 0.0f, f5, f6, 0.0f);
    }

    @Override
    public void bezierVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.bezierVertexImpl(f, f2, f3, f4, f5, f6, f7, f8, f9);
    }

    protected void bezierVertexImpl(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addBezierVertex(f, f2, f3, f4, f5, f6, f7, f8, f9, this.fill, this.stroke, this.bezierDetail, this.vertexCode(), this.shape);
    }

    @Override
    public void quadraticVertex(float f, float f2, float f3, float f4) {
        this.quadraticVertexImpl(f, f2, 0.0f, f3, f4, 0.0f);
    }

    @Override
    public void quadraticVertex(float f, float f2, float f3, float f4, float f5, float f6) {
        this.quadraticVertexImpl(f, f2, f3, f4, f5, f6);
    }

    protected void quadraticVertexImpl(float f, float f2, float f3, float f4, float f5, float f6) {
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addQuadraticVertex(f, f2, f3, f4, f5, f6, this.fill, this.stroke, this.bezierDetail, this.vertexCode(), this.shape);
    }

    @Override
    public void curveVertex(float f, float f2) {
        this.curveVertexImpl(f, f2, 0.0f);
    }

    @Override
    public void curveVertex(float f, float f2, float f3) {
        this.curveVertexImpl(f, f2, f3);
    }

    protected void curveVertexImpl(float f, float f2, float f3) {
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addCurveVertex(f, f2, f3, this.fill, this.stroke, this.curveDetail, this.vertexCode(), this.shape);
    }

    @Override
    public void point(float f, float f2) {
        this.pointImpl(f, f2, 0.0f);
    }

    @Override
    public void point(float f, float f2, float f3) {
        this.pointImpl(f, f2, f3);
    }

    protected void pointImpl(float f, float f2, float f3) {
        this.beginShape(3);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addPoint(f, f2, f3, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void line(float f, float f2, float f3, float f4) {
        this.lineImpl(f, f2, 0.0f, f3, f4, 0.0f);
    }

    @Override
    public void line(float f, float f2, float f3, float f4, float f5, float f6) {
        this.lineImpl(f, f2, f3, f4, f5, f6);
    }

    protected void lineImpl(float f, float f2, float f3, float f4, float f5, float f6) {
        this.beginShape(5);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addLine(f, f2, f3, f4, f5, f6, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void triangle(float f, float f2, float f3, float f4, float f5, float f6) {
        this.beginShape(9);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addTriangle(f, f2, 0.0f, f3, f4, 0.0f, f5, f6, 0.0f, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void quad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.beginShape(17);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addQuad(f, f2, 0.0f, f3, f4, 0.0f, f5, f6, 0.0f, f7, f8, 0.0f, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void rect(float f, float f2, float f3, float f4) {
        this.beginShape(17);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addRect(f, f2, f3, f4, this.fill, this.stroke, this.rectMode);
        this.endShape();
    }

    @Override
    public void rect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        this.beginShape(20);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addRect(f, f2, f3, f4, f5, f6, f7, f8, this.fill, this.stroke, this.bezierDetail, this.rectMode);
        this.endShape(2);
    }

    @Override
    public void ellipse(float f, float f2, float f3, float f4) {
        this.beginShape(11);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addEllipse(f, f2, f3, f4, this.fill, this.stroke, this.ellipseMode);
        this.endShape();
    }

    @Override
    protected void arcImpl(float f, float f2, float f3, float f4, float f5, float f6, int n) {
        this.beginShape(11);
        this.defaultEdges = false;
        this.normalMode = 1;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.setNormal(this.normalX, this.normalY, this.normalZ);
        this.inGeo.addArc(f, f2, f3, f4, f5, f6, this.fill, this.stroke, n);
        this.endShape();
    }

    @Override
    public void box(float f, float f2, float f3) {
        this.beginShape(17);
        this.defaultEdges = false;
        this.normalMode = 2;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        this.inGeo.addBox(f, f2, f3, this.fill, this.stroke);
        this.endShape();
    }

    @Override
    public void sphere(float f) {
        this.beginShape(9);
        this.defaultEdges = false;
        this.normalMode = 2;
        this.inGeo.setMaterial(this.fillColor, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininess);
        int[] nArray = this.inGeo.addSphere(f, this.sphereDetailU, this.sphereDetailV, this.fill, this.stroke);
        this.endShape(nArray);
    }

    @Override
    public void smooth() {
        this.smooth(2);
    }

    @Override
    public void smooth(int n) {
        if (this.smoothDisabled) {
            return;
        }
        this.smooth = true;
        if (maxSamples < n) {
            if (0 < maxSamples) {
                PGraphics.showWarning(UNSUPPORTED_SMOOTH_LEVEL_ERROR, n, maxSamples);
            } else {
                PGraphics.showWarning(UNSUPPORTED_SMOOTH_ERROR);
            }
            n = maxSamples;
        }
        if (this.quality != n) {
            ++this.smoothCallCount;
            if (this.parent.frameCount - this.lastSmoothCall < 30 && 5 < this.smoothCallCount) {
                this.smoothDisabled = true;
                PGraphics.showWarning(TOO_MANY_SMOOTH_CALLS_ERROR);
            }
            this.lastSmoothCall = this.parent.frameCount;
            this.quality = n;
            if (this.quality == 1) {
                this.quality = 0;
            }
            this.restartPGL();
        }
    }

    @Override
    public void noSmooth() {
        if (this.smoothDisabled) {
            return;
        }
        this.smooth = false;
        if (1 < this.quality) {
            ++this.smoothCallCount;
            if (this.parent.frameCount - this.lastSmoothCall < 30 && 5 < this.smoothCallCount) {
                this.smoothDisabled = true;
                PGraphics.showWarning(TOO_MANY_SMOOTH_CALLS_ERROR);
            }
            this.lastSmoothCall = this.parent.frameCount;
            this.quality = 0;
            this.restartPGL();
        }
    }

    @Override
    protected void shape(PShape pShape, float f, float f2, float f3) {
        if (pShape.isVisible()) {
            this.flush();
            this.pushMatrix();
            if (this.shapeMode == 3) {
                this.translate(f - pShape.getWidth() / 2.0f, f2 - pShape.getHeight() / 2.0f, f3 - pShape.getDepth() / 2.0f);
            } else if (this.shapeMode == 0 || this.shapeMode == 1) {
                this.translate(f, f2, f3);
            }
            pShape.draw(this);
            this.popMatrix();
        }
    }

    @Override
    protected void shape(PShape pShape, float f, float f2, float f3, float f4, float f5, float f6) {
        if (pShape.isVisible()) {
            this.flush();
            this.pushMatrix();
            if (this.shapeMode == 3) {
                this.translate(f - f4 / 2.0f, f2 - f5 / 2.0f, f3 - f6 / 2.0f);
                this.scale(f4 / pShape.getWidth(), f5 / pShape.getHeight(), f6 / pShape.getDepth());
            } else if (this.shapeMode == 0) {
                this.translate(f, f2, f3);
                this.scale(f4 / pShape.getWidth(), f5 / pShape.getHeight(), f6 / pShape.getDepth());
            } else if (this.shapeMode == 1) {
                this.translate(f, f2, f3);
                this.scale((f4 -= f) / pShape.getWidth(), (f5 -= f2) / pShape.getHeight(), (f6 -= f3) / pShape.getDepth());
            }
            pShape.draw(this);
            this.popMatrix();
        }
    }

    @Override
    public PShape loadShape(String string) {
        String string2 = PApplet.getExtension(string);
        if (PGraphics2D.isSupportedExtension(string2)) {
            return PGraphics2D.loadShapeImpl(this, string, string2);
        }
        if (PGraphics3D.isSupportedExtension(string2)) {
            return PGraphics3D.loadShapeImpl(this, string, string2);
        }
        PGraphics.showWarning(UNSUPPORTED_SHAPE_FORMAT_ERROR);
        return null;
    }

    @Override
    protected boolean textModeCheck(int n) {
        return n == 4;
    }

    @Override
    protected void textLineImpl(char[] cArray, int n, int n2, float f, float f2) {
        this.textTex = pgPrimary.getFontTexture(this.textFont);
        if (this.textTex == null) {
            this.textTex = new FontTexture(this.parent, this.textFont, maxTextureSize, maxTextureSize, this.is3D());
            pgPrimary.setFontTexture(this.textFont, this.textTex);
        } else if (this.textTex.contextIsOutdated()) {
            this.textTex = new FontTexture(this.parent, this.textFont, PApplet.min(512, maxTextureSize), PApplet.min(512, maxTextureSize), this.is3D());
            pgPrimary.setFontTexture(this.textFont, this.textTex);
        }
        this.textTex.begin();
        int n3 = this.textureMode;
        boolean bl = this.stroke;
        float f3 = this.normalX;
        float f4 = this.normalY;
        float f5 = this.normalZ;
        boolean bl2 = this.tint;
        int n4 = this.tintColor;
        int n5 = this.blendMode;
        this.textureMode = 1;
        this.stroke = false;
        this.normalX = 0.0f;
        this.normalY = 0.0f;
        this.normalZ = 1.0f;
        this.tint = true;
        this.tintColor = this.fillColor;
        this.blendMode(1);
        super.textLineImpl(cArray, n, n2, f, f2);
        this.textureMode = n3;
        this.stroke = bl;
        this.normalX = f3;
        this.normalY = f4;
        this.normalZ = f5;
        this.tint = bl2;
        this.tintColor = n4;
        this.blendMode(n5);
        this.textTex.end();
    }

    @Override
    protected void textCharImpl(char c, float f, float f2) {
        PFont.Glyph glyph = this.textFont.getGlyph(c);
        if (glyph != null) {
            FontTexture.TextureInfo textureInfo = this.textTex.getTexInfo(glyph);
            if (textureInfo == null) {
                textureInfo = this.textTex.addToTexture(glyph);
            }
            if (this.textMode == 4) {
                float f3 = (float)glyph.height / (float)this.textFont.getSize();
                float f4 = (float)glyph.width / (float)this.textFont.getSize();
                float f5 = (float)glyph.leftExtent / (float)this.textFont.getSize();
                float f6 = (float)glyph.topExtent / (float)this.textFont.getSize();
                float f7 = f + f5 * this.textSize;
                float f8 = f2 - f6 * this.textSize;
                float f9 = f7 + f4 * this.textSize;
                float f10 = f8 + f3 * this.textSize;
                this.textCharModelImpl(textureInfo, f7, f8, f9, f10);
            }
        }
    }

    protected void textCharModelImpl(FontTexture.TextureInfo textureInfo, float f, float f2, float f3, float f4) {
        if (this.textTex.currentTex != textureInfo.texIndex) {
            this.textTex.setTexture(textureInfo.texIndex);
        }
        PImage pImage = this.textTex.getCurrentTexture();
        this.beginShape(17);
        this.texture(pImage);
        this.vertex(f, f2, textureInfo.u0, textureInfo.v0);
        this.vertex(f3, f2, textureInfo.u1, textureInfo.v0);
        this.vertex(f3, f4, textureInfo.u1, textureInfo.v1);
        this.vertex(f, f4, textureInfo.u0, textureInfo.v1);
        this.endShape();
    }

    @Override
    public void pushMatrix() {
        if (this.modelviewStackDepth == 32) {
            throw new RuntimeException("Too many calls to pushMatrix().");
        }
        this.modelview.get(this.modelviewStack[this.modelviewStackDepth]);
        this.modelviewInv.get(this.modelviewInvStack[this.modelviewStackDepth]);
        this.camera.get(this.cameraStack[this.modelviewStackDepth]);
        this.cameraInv.get(this.cameraInvStack[this.modelviewStackDepth]);
        ++this.modelviewStackDepth;
    }

    @Override
    public void popMatrix() {
        if (this.modelviewStackDepth == 0) {
            throw new RuntimeException("Too many calls to popMatrix(), and not enough to pushMatrix().");
        }
        --this.modelviewStackDepth;
        this.modelview.set(this.modelviewStack[this.modelviewStackDepth]);
        this.modelviewInv.set(this.modelviewInvStack[this.modelviewStackDepth]);
        this.camera.set(this.cameraStack[this.modelviewStackDepth]);
        this.cameraInv.set(this.cameraInvStack[this.modelviewStackDepth]);
        this.updateProjmodelview();
    }

    @Override
    public void translate(float f, float f2) {
        this.translateImpl(f, f2, 0.0f);
    }

    @Override
    public void translate(float f, float f2, float f3) {
        this.translateImpl(f, f2, f3);
    }

    protected void translateImpl(float f, float f2, float f3) {
        this.modelview.translate(f, f2, f3);
        PGraphicsOpenGL.invTranslate(this.modelviewInv, f, f2, f3);
        this.projmodelview.translate(f, f2, f3);
    }

    protected static void invTranslate(PMatrix3D pMatrix3D, float f, float f2, float f3) {
        pMatrix3D.preApply(1.0f, 0.0f, 0.0f, -f, 0.0f, 1.0f, 0.0f, -f2, 0.0f, 0.0f, 1.0f, -f3, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void rotate(float f) {
        this.rotateImpl(f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void rotateX(float f) {
        this.rotateImpl(f, 1.0f, 0.0f, 0.0f);
    }

    @Override
    public void rotateY(float f) {
        this.rotateImpl(f, 0.0f, 1.0f, 0.0f);
    }

    @Override
    public void rotateZ(float f) {
        this.rotateImpl(f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void rotate(float f, float f2, float f3, float f4) {
        this.rotateImpl(f, f2, f3, f4);
    }

    protected void rotateImpl(float f, float f2, float f3, float f4) {
        float f5 = f2 * f2 + f3 * f3 + f4 * f4;
        if (PGraphicsOpenGL.zero(f5)) {
            return;
        }
        if (PGraphicsOpenGL.diff(f5, 1.0f)) {
            float f6 = PApplet.sqrt(f5);
            f2 /= f6;
            f3 /= f6;
            f4 /= f6;
        }
        this.modelview.rotate(f, f2, f3, f4);
        PGraphicsOpenGL.invRotate(this.modelviewInv, f, f2, f3, f4);
        this.updateProjmodelview();
    }

    private static void invRotate(PMatrix3D pMatrix3D, float f, float f2, float f3, float f4) {
        float f5 = PApplet.cos(-f);
        float f6 = PApplet.sin(-f);
        float f7 = 1.0f - f5;
        pMatrix3D.preApply(f7 * f2 * f2 + f5, f7 * f2 * f3 - f6 * f4, f7 * f2 * f4 + f6 * f3, 0.0f, f7 * f2 * f3 + f6 * f4, f7 * f3 * f3 + f5, f7 * f3 * f4 - f6 * f2, 0.0f, f7 * f2 * f4 - f6 * f3, f7 * f3 * f4 + f6 * f2, f7 * f4 * f4 + f5, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void scale(float f) {
        this.scaleImpl(f, f, f);
    }

    @Override
    public void scale(float f, float f2) {
        this.scaleImpl(f, f2, 1.0f);
    }

    @Override
    public void scale(float f, float f2, float f3) {
        this.scaleImpl(f, f2, f3);
    }

    protected void scaleImpl(float f, float f2, float f3) {
        this.modelview.scale(f, f2, f3);
        PGraphicsOpenGL.invScale(this.modelviewInv, f, f2, f3);
        this.projmodelview.scale(f, f2, f3);
    }

    protected static void invScale(PMatrix3D pMatrix3D, float f, float f2, float f3) {
        pMatrix3D.preApply(1.0f / f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / f2, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f / f3, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void shearX(float f) {
        float f2 = (float)Math.tan(f);
        this.applyMatrixImpl(1.0f, f2, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void shearY(float f) {
        float f2 = (float)Math.tan(f);
        this.applyMatrixImpl(1.0f, 0.0f, 0.0f, 0.0f, f2, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void resetMatrix() {
        this.modelview.reset();
        this.modelviewInv.reset();
        this.projmodelview.set(this.projection);
        this.camera.reset();
        this.cameraInv.reset();
    }

    @Override
    public void applyMatrix(PMatrix2D pMatrix2D) {
        this.applyMatrixImpl(pMatrix2D.m00, pMatrix2D.m01, 0.0f, pMatrix2D.m02, pMatrix2D.m10, pMatrix2D.m11, 0.0f, pMatrix2D.m12, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        this.applyMatrixImpl(f, f2, 0.0f, f3, f4, f5, 0.0f, f6, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void applyMatrix(PMatrix3D pMatrix3D) {
        this.applyMatrixImpl(pMatrix3D.m00, pMatrix3D.m01, pMatrix3D.m02, pMatrix3D.m03, pMatrix3D.m10, pMatrix3D.m11, pMatrix3D.m12, pMatrix3D.m13, pMatrix3D.m20, pMatrix3D.m21, pMatrix3D.m22, pMatrix3D.m23, pMatrix3D.m30, pMatrix3D.m31, pMatrix3D.m32, pMatrix3D.m33);
    }

    @Override
    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.applyMatrixImpl(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    protected void applyMatrixImpl(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.modelview.apply(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
        this.modelviewInv.set(this.modelview);
        this.modelviewInv.invert();
        this.projmodelview.apply(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    protected void begin2D() {
    }

    protected void end2D() {
    }

    @Override
    public PMatrix getMatrix() {
        return this.modelview.get();
    }

    @Override
    public PMatrix3D getMatrix(PMatrix3D pMatrix3D) {
        if (pMatrix3D == null) {
            pMatrix3D = new PMatrix3D();
        }
        pMatrix3D.set(this.modelview);
        return pMatrix3D;
    }

    @Override
    public void setMatrix(PMatrix2D pMatrix2D) {
        this.resetMatrix();
        this.applyMatrix(pMatrix2D);
    }

    @Override
    public void setMatrix(PMatrix3D pMatrix3D) {
        this.resetMatrix();
        this.applyMatrix(pMatrix3D);
    }

    @Override
    public void printMatrix() {
        this.modelview.print();
    }

    public void pushProjection() {
        if (this.projectionStackDepth == 32) {
            throw new RuntimeException("Too many calls to pushMatrix().");
        }
        this.projection.get(this.projectionStack[this.projectionStackDepth]);
        ++this.projectionStackDepth;
    }

    public void popProjection() {
        this.flush();
        if (this.projectionStackDepth == 0) {
            throw new RuntimeException("Too many calls to popMatrix(), and not enough to pushMatrix().");
        }
        --this.projectionStackDepth;
        this.projection.set(this.projectionStack[this.projectionStackDepth]);
        this.updateProjmodelview();
    }

    public void resetProjection() {
        this.flush();
        this.projection.reset();
        this.updateProjmodelview();
    }

    public void applyProjection(PMatrix3D pMatrix3D) {
        this.flush();
        this.projection.apply(pMatrix3D);
        this.updateProjmodelview();
    }

    public void applyProjection(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.flush();
        this.projection.apply(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
        this.updateProjmodelview();
    }

    public void setProjection(PMatrix3D pMatrix3D) {
        this.flush();
        this.projection.set(pMatrix3D);
        this.updateProjmodelview();
    }

    protected boolean orthoProjection() {
        return PGraphicsOpenGL.zero(this.projection.m01) && PGraphicsOpenGL.zero(this.projection.m02) && PGraphicsOpenGL.zero(this.projection.m10) && PGraphicsOpenGL.zero(this.projection.m12) && PGraphicsOpenGL.zero(this.projection.m20) && PGraphicsOpenGL.zero(this.projection.m21) && PGraphicsOpenGL.zero(this.projection.m30) && PGraphicsOpenGL.zero(this.projection.m31) && PGraphicsOpenGL.zero(this.projection.m32) && PGraphicsOpenGL.same(this.projection.m33, 1.0f);
    }

    protected boolean nonOrthoProjection() {
        return PGraphicsOpenGL.nonZero(this.projection.m01) || PGraphicsOpenGL.nonZero(this.projection.m02) || PGraphicsOpenGL.nonZero(this.projection.m10) || PGraphicsOpenGL.nonZero(this.projection.m12) || PGraphicsOpenGL.nonZero(this.projection.m20) || PGraphicsOpenGL.nonZero(this.projection.m21) || PGraphicsOpenGL.nonZero(this.projection.m30) || PGraphicsOpenGL.nonZero(this.projection.m31) || PGraphicsOpenGL.nonZero(this.projection.m32) || PGraphicsOpenGL.diff(this.projection.m33, 1.0f);
    }

    protected static boolean same(float f, float f2) {
        return Math.abs(f - f2) < PGL.FLOAT_EPS;
    }

    protected static boolean diff(float f, float f2) {
        return PGL.FLOAT_EPS <= Math.abs(f - f2);
    }

    protected static boolean zero(float f) {
        return Math.abs(f) < PGL.FLOAT_EPS;
    }

    protected static boolean nonZero(float f) {
        return PGL.FLOAT_EPS <= Math.abs(f);
    }

    @Override
    public void beginCamera() {
        if (this.manipulatingCamera) {
            throw new RuntimeException("beginCamera() cannot be called again before endCamera()");
        }
        this.manipulatingCamera = true;
    }

    @Override
    public void endCamera() {
        if (!this.manipulatingCamera) {
            throw new RuntimeException("Cannot call endCamera() without first calling beginCamera()");
        }
        this.camera.set(this.modelview);
        this.cameraInv.set(this.modelviewInv);
        this.manipulatingCamera = false;
    }

    @Override
    public void camera() {
        this.camera(this.cameraX, this.cameraY, this.cameraZ, this.cameraX, this.cameraY, 0.0f, 0.0f, 1.0f, 0.0f);
    }

    @Override
    public void camera(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        float f10 = f - f4;
        float f11 = f2 - f5;
        float f12 = f3 - f6;
        float f13 = PApplet.sqrt(f10 * f10 + f11 * f11 + f12 * f12);
        if (PGraphicsOpenGL.nonZero(f13)) {
            f10 /= f13;
            f11 /= f13;
            f12 /= f13;
        }
        this.cameraEyeX = f;
        this.cameraEyeY = f2;
        this.cameraEyeZ = f3;
        float f14 = f7;
        float f15 = f8;
        float f16 = f9;
        float f17 = f15 * f12 - f16 * f11;
        float f18 = -f14 * f12 + f16 * f10;
        float f19 = f14 * f11 - f15 * f10;
        f14 = f11 * f19 - f12 * f18;
        f15 = -f10 * f19 + f12 * f17;
        f16 = f10 * f18 - f11 * f17;
        f13 = PApplet.sqrt(f17 * f17 + f18 * f18 + f19 * f19);
        if (PGraphicsOpenGL.nonZero(f13)) {
            f17 /= f13;
            f18 /= f13;
            f19 /= f13;
        }
        if (PGraphicsOpenGL.nonZero(f13 = PApplet.sqrt(f14 * f14 + f15 * f15 + f16 * f16))) {
            f14 /= f13;
            f15 /= f13;
            f16 /= f13;
        }
        this.modelview.set(f17, f18, f19, 0.0f, f14, f15, f16, 0.0f, f10, f11, f12, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
        float f20 = -f;
        float f21 = -f2;
        float f22 = -f3;
        this.modelview.translate(f20, f21, f22);
        this.modelviewInv.set(this.modelview);
        this.modelviewInv.invert();
        this.camera.set(this.modelview);
        this.cameraInv.set(this.modelviewInv);
        this.updateProjmodelview();
    }

    public void camera(float f, float f2) {
        this.modelview.reset();
        this.modelview.translate(-f, -f2);
        this.modelviewInv.set(this.modelview);
        this.modelviewInv.invert();
        this.camera.set(this.modelview);
        this.cameraInv.set(this.modelviewInv);
        this.updateProjmodelview();
    }

    @Override
    public void printCamera() {
        this.camera.print();
    }

    protected void defaultCamera() {
        this.camera();
    }

    @Override
    public void ortho() {
        this.ortho(0.0f, this.width, 0.0f, this.height, this.cameraNear, this.cameraFar);
    }

    @Override
    public void ortho(float f, float f2, float f3, float f4) {
        this.ortho(f, f2, f3, f4, this.cameraNear, this.cameraFar);
    }

    @Override
    public void ortho(float f, float f2, float f3, float f4, float f5, float f6) {
        this.flush();
        float f7 = 2.0f / ((f2 -= (float)(this.width / 2)) - (f -= (float)(this.width / 2)));
        float f8 = 2.0f / ((f4 -= (float)(this.height / 2)) - (f3 -= (float)(this.height / 2)));
        float f9 = -2.0f / (f6 - f5);
        float f10 = -(f2 + f) / (f2 - f);
        float f11 = -(f4 + f3) / (f4 - f3);
        float f12 = -(f6 + f5) / (f6 - f5);
        this.projection.set(f7, 0.0f, 0.0f, f10, 0.0f, -f8, 0.0f, f11, 0.0f, 0.0f, f9, f12, 0.0f, 0.0f, 0.0f, 1.0f);
        this.updateProjmodelview();
    }

    @Override
    public void perspective() {
        this.perspective(this.cameraFOV, this.cameraAspect, this.cameraNear, this.cameraFar);
    }

    @Override
    public void perspective(float f, float f2, float f3, float f4) {
        float f5 = f3 * (float)Math.tan(f / 2.0f);
        float f6 = -f5;
        float f7 = f6 * f2;
        float f8 = f5 * f2;
        this.frustum(f7, f8, f6, f5, f3, f4);
    }

    @Override
    public void frustum(float f, float f2, float f3, float f4, float f5, float f6) {
        this.flush();
        float f7 = 2.0f * f5;
        float f8 = f2 - f;
        float f9 = f4 - f3;
        float f10 = f6 - f5;
        this.projection.set(f7 / f8, 0.0f, (f2 + f) / f8, 0.0f, 0.0f, -f7 / f9, (f4 + f3) / f9, 0.0f, 0.0f, 0.0f, -(f6 + f5) / f10, -(f7 * f6) / f10, 0.0f, 0.0f, -1.0f, 0.0f);
        this.updateProjmodelview();
    }

    @Override
    public void printProjection() {
        this.projection.print();
    }

    protected void defaultPerspective() {
        this.perspective();
    }

    @Override
    public float screenX(float f, float f2) {
        return this.screenXImpl(f, f2, 0.0f);
    }

    @Override
    public float screenY(float f, float f2) {
        return this.screenYImpl(f, f2, 0.0f);
    }

    @Override
    public float screenX(float f, float f2, float f3) {
        return this.screenXImpl(f, f2, f3);
    }

    @Override
    public float screenY(float f, float f2, float f3) {
        return this.screenYImpl(f, f2, f3);
    }

    @Override
    public float screenZ(float f, float f2, float f3) {
        return this.screenZImpl(f, f2, f3);
    }

    protected float screenXImpl(float f, float f2, float f3) {
        float f4 = this.modelview.m00 * f + this.modelview.m01 * f2 + this.modelview.m02 * f3 + this.modelview.m03;
        float f5 = this.modelview.m10 * f + this.modelview.m11 * f2 + this.modelview.m12 * f3 + this.modelview.m13;
        float f6 = this.modelview.m20 * f + this.modelview.m21 * f2 + this.modelview.m22 * f3 + this.modelview.m23;
        float f7 = this.modelview.m30 * f + this.modelview.m31 * f2 + this.modelview.m32 * f3 + this.modelview.m33;
        return this.screenXImpl(f4, f5, f6, f7);
    }

    protected float screenXImpl(float f, float f2, float f3, float f4) {
        float f5 = this.projection.m00 * f + this.projection.m01 * f2 + this.projection.m02 * f3 + this.projection.m03 * f4;
        float f6 = this.projection.m30 * f + this.projection.m31 * f2 + this.projection.m32 * f3 + this.projection.m33 * f4;
        if (PGraphicsOpenGL.nonZero(f6)) {
            f5 /= f6;
        }
        float f7 = (float)this.width * (1.0f + f5) / 2.0f;
        return f7;
    }

    protected float screenYImpl(float f, float f2, float f3) {
        float f4 = this.modelview.m00 * f + this.modelview.m01 * f2 + this.modelview.m02 * f3 + this.modelview.m03;
        float f5 = this.modelview.m10 * f + this.modelview.m11 * f2 + this.modelview.m12 * f3 + this.modelview.m13;
        float f6 = this.modelview.m20 * f + this.modelview.m21 * f2 + this.modelview.m22 * f3 + this.modelview.m23;
        float f7 = this.modelview.m30 * f + this.modelview.m31 * f2 + this.modelview.m32 * f3 + this.modelview.m33;
        return this.screenYImpl(f4, f5, f6, f7);
    }

    protected float screenYImpl(float f, float f2, float f3, float f4) {
        float f5 = this.projection.m10 * f + this.projection.m11 * f2 + this.projection.m12 * f3 + this.projection.m13 * f4;
        float f6 = this.projection.m30 * f + this.projection.m31 * f2 + this.projection.m32 * f3 + this.projection.m33 * f4;
        if (PGraphicsOpenGL.nonZero(f6)) {
            f5 /= f6;
        }
        float f7 = (float)this.height * (1.0f + f5) / 2.0f;
        f7 = (float)this.height - f7;
        return f7;
    }

    protected float screenZImpl(float f, float f2, float f3) {
        float f4 = this.modelview.m00 * f + this.modelview.m01 * f2 + this.modelview.m02 * f3 + this.modelview.m03;
        float f5 = this.modelview.m10 * f + this.modelview.m11 * f2 + this.modelview.m12 * f3 + this.modelview.m13;
        float f6 = this.modelview.m20 * f + this.modelview.m21 * f2 + this.modelview.m22 * f3 + this.modelview.m23;
        float f7 = this.modelview.m30 * f + this.modelview.m31 * f2 + this.modelview.m32 * f3 + this.modelview.m33;
        return this.screenZImpl(f4, f5, f6, f7);
    }

    protected float screenZImpl(float f, float f2, float f3, float f4) {
        float f5 = this.projection.m20 * f + this.projection.m21 * f2 + this.projection.m22 * f3 + this.projection.m23 * f4;
        float f6 = this.projection.m30 * f + this.projection.m31 * f2 + this.projection.m32 * f3 + this.projection.m33 * f4;
        if (PGraphicsOpenGL.nonZero(f6)) {
            f5 /= f6;
        }
        float f7 = (f5 + 1.0f) / 2.0f;
        return f7;
    }

    @Override
    public float modelX(float f, float f2, float f3) {
        float f4 = this.modelview.m00 * f + this.modelview.m01 * f2 + this.modelview.m02 * f3 + this.modelview.m03;
        float f5 = this.modelview.m10 * f + this.modelview.m11 * f2 + this.modelview.m12 * f3 + this.modelview.m13;
        float f6 = this.modelview.m20 * f + this.modelview.m21 * f2 + this.modelview.m22 * f3 + this.modelview.m23;
        float f7 = this.modelview.m30 * f + this.modelview.m31 * f2 + this.modelview.m32 * f3 + this.modelview.m33;
        float f8 = this.cameraInv.m00 * f4 + this.cameraInv.m01 * f5 + this.cameraInv.m02 * f6 + this.cameraInv.m03 * f7;
        float f9 = this.cameraInv.m30 * f4 + this.cameraInv.m31 * f5 + this.cameraInv.m32 * f6 + this.cameraInv.m33 * f7;
        return PGraphicsOpenGL.nonZero(f9) ? f8 / f9 : f8;
    }

    @Override
    public float modelY(float f, float f2, float f3) {
        float f4 = this.modelview.m00 * f + this.modelview.m01 * f2 + this.modelview.m02 * f3 + this.modelview.m03;
        float f5 = this.modelview.m10 * f + this.modelview.m11 * f2 + this.modelview.m12 * f3 + this.modelview.m13;
        float f6 = this.modelview.m20 * f + this.modelview.m21 * f2 + this.modelview.m22 * f3 + this.modelview.m23;
        float f7 = this.modelview.m30 * f + this.modelview.m31 * f2 + this.modelview.m32 * f3 + this.modelview.m33;
        float f8 = this.cameraInv.m10 * f4 + this.cameraInv.m11 * f5 + this.cameraInv.m12 * f6 + this.cameraInv.m13 * f7;
        float f9 = this.cameraInv.m30 * f4 + this.cameraInv.m31 * f5 + this.cameraInv.m32 * f6 + this.cameraInv.m33 * f7;
        return PGraphicsOpenGL.nonZero(f9) ? f8 / f9 : f8;
    }

    @Override
    public float modelZ(float f, float f2, float f3) {
        float f4 = this.modelview.m00 * f + this.modelview.m01 * f2 + this.modelview.m02 * f3 + this.modelview.m03;
        float f5 = this.modelview.m10 * f + this.modelview.m11 * f2 + this.modelview.m12 * f3 + this.modelview.m13;
        float f6 = this.modelview.m20 * f + this.modelview.m21 * f2 + this.modelview.m22 * f3 + this.modelview.m23;
        float f7 = this.modelview.m30 * f + this.modelview.m31 * f2 + this.modelview.m32 * f3 + this.modelview.m33;
        float f8 = this.cameraInv.m20 * f4 + this.cameraInv.m21 * f5 + this.cameraInv.m22 * f6 + this.cameraInv.m23 * f7;
        float f9 = this.cameraInv.m30 * f4 + this.cameraInv.m31 * f5 + this.cameraInv.m32 * f6 + this.cameraInv.m33 * f7;
        return PGraphicsOpenGL.nonZero(f9) ? f8 / f9 : f8;
    }

    @Override
    public void strokeWeight(float f) {
        this.strokeWeight = f;
    }

    @Override
    public void strokeJoin(int n) {
        this.strokeJoin = n;
    }

    @Override
    public void strokeCap(int n) {
        this.strokeCap = n;
    }

    @Override
    protected void fillFromCalc() {
        super.fillFromCalc();
        if (!this.setAmbient) {
            this.ambientFromCalc();
            this.setAmbient = false;
        }
    }

    @Override
    public void lights() {
        this.enableLighting();
        int n = this.colorMode;
        this.colorMode = 1;
        this.lightFalloff(1.0f, 0.0f, 0.0f);
        this.lightSpecular(0.0f, 0.0f, 0.0f);
        this.ambientLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f);
        this.directionalLight(this.colorModeX * 0.5f, this.colorModeY * 0.5f, this.colorModeZ * 0.5f, 0.0f, 0.0f, -1.0f);
        this.colorMode = n;
    }

    @Override
    public void noLights() {
        this.disableLighting();
        this.lightCount = 0;
    }

    @Override
    public void ambientLight(float f, float f2, float f3) {
        this.ambientLight(f, f2, f3, 0.0f, 0.0f, 0.0f);
    }

    @Override
    public void ambientLight(float f, float f2, float f3, float f4, float f5, float f6) {
        this.enableLighting();
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.lightType[this.lightCount] = 0;
        this.lightPosition(this.lightCount, f4, f5, f6, false);
        this.lightNormal(this.lightCount, 0.0f, 0.0f, 0.0f);
        this.lightAmbient(this.lightCount, f, f2, f3);
        this.noLightDiffuse(this.lightCount);
        this.noLightSpecular(this.lightCount);
        this.noLightSpot(this.lightCount);
        this.lightFalloff(this.lightCount, this.currentLightFalloffConstant, this.currentLightFalloffLinear, this.currentLightFalloffQuadratic);
        ++this.lightCount;
    }

    @Override
    public void directionalLight(float f, float f2, float f3, float f4, float f5, float f6) {
        this.enableLighting();
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.lightType[this.lightCount] = 1;
        this.lightPosition(this.lightCount, 0.0f, 0.0f, 0.0f, true);
        this.lightNormal(this.lightCount, f4, f5, f6);
        this.noLightAmbient(this.lightCount);
        this.lightDiffuse(this.lightCount, f, f2, f3);
        this.lightSpecular(this.lightCount, this.currentLightSpecular[0], this.currentLightSpecular[1], this.currentLightSpecular[2]);
        this.noLightSpot(this.lightCount);
        this.noLightFalloff(this.lightCount);
        ++this.lightCount;
    }

    @Override
    public void pointLight(float f, float f2, float f3, float f4, float f5, float f6) {
        this.enableLighting();
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.lightType[this.lightCount] = 2;
        this.lightPosition(this.lightCount, f4, f5, f6, false);
        this.lightNormal(this.lightCount, 0.0f, 0.0f, 0.0f);
        this.noLightAmbient(this.lightCount);
        this.lightDiffuse(this.lightCount, f, f2, f3);
        this.lightSpecular(this.lightCount, this.currentLightSpecular[0], this.currentLightSpecular[1], this.currentLightSpecular[2]);
        this.noLightSpot(this.lightCount);
        this.lightFalloff(this.lightCount, this.currentLightFalloffConstant, this.currentLightFalloffLinear, this.currentLightFalloffQuadratic);
        ++this.lightCount;
    }

    @Override
    public void spotLight(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        this.enableLighting();
        if (this.lightCount == 8) {
            throw new RuntimeException("can only create 8 lights");
        }
        this.lightType[this.lightCount] = 3;
        this.lightPosition(this.lightCount, f4, f5, f6, false);
        this.lightNormal(this.lightCount, f7, f8, f9);
        this.noLightAmbient(this.lightCount);
        this.lightDiffuse(this.lightCount, f, f2, f3);
        this.lightSpecular(this.lightCount, this.currentLightSpecular[0], this.currentLightSpecular[1], this.currentLightSpecular[2]);
        this.lightSpot(this.lightCount, f10, f11);
        this.lightFalloff(this.lightCount, this.currentLightFalloffConstant, this.currentLightFalloffLinear, this.currentLightFalloffQuadratic);
        ++this.lightCount;
    }

    @Override
    public void lightFalloff(float f, float f2, float f3) {
        this.currentLightFalloffConstant = f;
        this.currentLightFalloffLinear = f2;
        this.currentLightFalloffQuadratic = f3;
    }

    @Override
    public void lightSpecular(float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.currentLightSpecular[0] = this.calcR;
        this.currentLightSpecular[1] = this.calcG;
        this.currentLightSpecular[2] = this.calcB;
    }

    protected void enableLighting() {
        if (!this.lights) {
            this.flush();
            this.lights = true;
        }
    }

    protected void disableLighting() {
        if (this.lights) {
            this.flush();
            this.lights = false;
        }
    }

    protected void lightPosition(int n, float f, float f2, float f3, boolean bl) {
        this.lightPosition[4 * n + 0] = f * this.modelview.m00 + f2 * this.modelview.m01 + f3 * this.modelview.m02 + this.modelview.m03;
        this.lightPosition[4 * n + 1] = f * this.modelview.m10 + f2 * this.modelview.m11 + f3 * this.modelview.m12 + this.modelview.m13;
        this.lightPosition[4 * n + 2] = f * this.modelview.m20 + f2 * this.modelview.m21 + f3 * this.modelview.m22 + this.modelview.m23;
        this.lightPosition[4 * n + 3] = bl ? 1.0f : 0.0f;
    }

    protected void lightNormal(int n, float f, float f2, float f3) {
        float f4 = f * this.modelviewInv.m00 + f2 * this.modelviewInv.m10 + f3 * this.modelviewInv.m20;
        float f5 = f * this.modelviewInv.m01 + f2 * this.modelviewInv.m11 + f3 * this.modelviewInv.m21;
        float f6 = f * this.modelviewInv.m02 + f2 * this.modelviewInv.m12 + f3 * this.modelviewInv.m22;
        float f7 = 1.0f / PApplet.dist(0.0f, 0.0f, 0.0f, f4, f5, f6);
        this.lightNormal[3 * n + 0] = f7 * f4;
        this.lightNormal[3 * n + 1] = f7 * f5;
        this.lightNormal[3 * n + 2] = f7 * f6;
    }

    protected void lightAmbient(int n, float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.lightAmbient[3 * n + 0] = this.calcR;
        this.lightAmbient[3 * n + 1] = this.calcG;
        this.lightAmbient[3 * n + 2] = this.calcB;
    }

    protected void noLightAmbient(int n) {
        this.lightAmbient[3 * n + 0] = 0.0f;
        this.lightAmbient[3 * n + 1] = 0.0f;
        this.lightAmbient[3 * n + 2] = 0.0f;
    }

    protected void lightDiffuse(int n, float f, float f2, float f3) {
        this.colorCalc(f, f2, f3);
        this.lightDiffuse[3 * n + 0] = this.calcR;
        this.lightDiffuse[3 * n + 1] = this.calcG;
        this.lightDiffuse[3 * n + 2] = this.calcB;
    }

    protected void noLightDiffuse(int n) {
        this.lightDiffuse[3 * n + 0] = 0.0f;
        this.lightDiffuse[3 * n + 1] = 0.0f;
        this.lightDiffuse[3 * n + 2] = 0.0f;
    }

    protected void lightSpecular(int n, float f, float f2, float f3) {
        this.lightSpecular[3 * n + 0] = f;
        this.lightSpecular[3 * n + 1] = f2;
        this.lightSpecular[3 * n + 2] = f3;
    }

    protected void noLightSpecular(int n) {
        this.lightSpecular[3 * n + 0] = 0.0f;
        this.lightSpecular[3 * n + 1] = 0.0f;
        this.lightSpecular[3 * n + 2] = 0.0f;
    }

    protected void lightFalloff(int n, float f, float f2, float f3) {
        this.lightFalloffCoefficients[3 * n + 0] = f;
        this.lightFalloffCoefficients[3 * n + 1] = f2;
        this.lightFalloffCoefficients[3 * n + 2] = f3;
    }

    protected void noLightFalloff(int n) {
        this.lightFalloffCoefficients[3 * n + 0] = 1.0f;
        this.lightFalloffCoefficients[3 * n + 1] = 0.0f;
        this.lightFalloffCoefficients[3 * n + 2] = 0.0f;
    }

    protected void lightSpot(int n, float f, float f2) {
        this.lightSpotParameters[2 * n + 0] = Math.max(0.0f, PApplet.cos(f));
        this.lightSpotParameters[2 * n + 1] = f2;
    }

    protected void noLightSpot(int n) {
        this.lightSpotParameters[2 * n + 0] = 0.0f;
        this.lightSpotParameters[2 * n + 1] = 0.0f;
    }

    @Override
    protected void backgroundImpl(PImage pImage) {
        this.backgroundImpl();
        this.set(0, 0, pImage);
        if (0 < this.parent.frameCount) {
            this.clearColorBuffer = true;
        }
    }

    @Override
    protected void backgroundImpl() {
        this.flush();
        this.pgl.depthMask(true);
        this.pgl.clearDepth(1.0f);
        this.pgl.clear(256);
        if (this.hints[5]) {
            this.pgl.depthMask(false);
        } else {
            this.pgl.depthMask(true);
        }
        this.pgl.clearColor(this.backgroundR, this.backgroundG, this.backgroundB, this.backgroundA);
        this.pgl.clear(16384);
        if (0 < this.parent.frameCount) {
            this.clearColorBuffer = true;
        }
    }

    public void report(String string) {
        int n;
        if (!this.hints[4] && (n = this.pgl.getError()) != 0) {
            String string2 = this.pgl.errorString(n);
            String string3 = "OpenGL error " + n + " at " + string + ": " + string2;
            PGraphics.showWarning(string3);
        }
    }

    @Override
    public boolean isGL() {
        return true;
    }

    @Override
    public void loadPixels() {
        if (this.primarySurface && this.sized) {
            return;
        }
        boolean bl = false;
        if (!this.drawing) {
            this.beginDraw();
            bl = true;
        }
        if (!this.setgetPixels) {
            this.flush();
        }
        this.allocatePixels();
        if (!this.setgetPixels) {
            this.readPixels();
        }
        if (bl) {
            this.endDraw();
        }
    }

    protected void allocatePixels() {
        if (this.pixels == null || this.pixels.length != this.width * this.height) {
            this.pixels = new int[this.width * this.height];
            this.pixelBuffer = PGL.allocateIntBuffer(this.pixels);
        }
    }

    protected void saveSurfaceToPixels() {
        this.allocatePixels();
        this.readPixels();
    }

    protected void restoreSurfaceFromPixels() {
        this.drawPixels(0, 0, this.width, this.height);
    }

    protected void readPixels() {
        this.beginPixelsOp(1);
        try {
            this.pgl.readPixels(0, 0, this.width, this.height, 6408, 5121, this.pixelBuffer);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.endPixelsOp();
        try {
            PGL.getIntArray(this.pixelBuffer, this.pixels);
            PGL.nativeToJavaARGB(this.pixels, this.width, this.height);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    protected void drawPixels(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = n3 * n4;
        if (this.nativePixels == null || this.nativePixels.length < n6) {
            this.nativePixels = new int[n6];
            this.nativePixelBuffer = PGL.allocateIntBuffer(this.nativePixels);
        }
        try {
            if (0 < n || 0 < n2 || n3 < this.width || n4 < this.height) {
                n5 = n2 * this.width + n;
                int n7 = 0;
                for (int i = n2; i < n2 + n4; ++i) {
                    System.arraycopy(this.pixels, n5, this.nativePixels, n7, n3);
                    n5 += this.width;
                    n7 += n3;
                }
            } else {
                PApplet.arrayCopy(this.pixels, 0, this.nativePixels, 0, n6);
            }
            PGL.javaToNativeARGB(this.nativePixels, n3, n4);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        PGL.putIntArray(this.nativePixelBuffer, this.nativePixels);
        if (this.primarySurface && !this.pgl.isFBOBacked()) {
            this.loadTextureImpl(2, false);
        }
        int n8 = n5 = this.primarySurface && (!this.pgl.isFBOBacked() || this.pgl.isFBOBacked() && this.pgl.isMultisampled()) || this.offscreenMultisample ? 1 : 0;
        if (n5 != 0) {
            this.pgl.copyToTexture(this.texture.glTarget, this.texture.glFormat, this.texture.glName, n, n2, n3, n4, this.nativePixelBuffer);
            this.beginPixelsOp(2);
            this.drawTexture(n, n2, n3, n4);
            this.endPixelsOp();
        } else {
            this.pgl.copyToTexture(this.texture.glTarget, this.texture.glFormat, this.texture.glName, n, this.height - (n2 + n4), n3, n4, this.nativePixelBuffer);
        }
    }

    @Override
    public int get(int n, int n2) {
        this.loadPixels();
        this.setgetPixels = true;
        return super.get(n, n2);
    }

    @Override
    protected void getImpl(int n, int n2, int n3, int n4, PImage pImage, int n5, int n6) {
        this.loadPixels();
        this.setgetPixels = true;
        super.getImpl(n, n2, n3, n4, pImage, n5, n6);
    }

    @Override
    public void set(int n, int n2, int n3) {
        this.loadPixels();
        this.setgetPixels = true;
        super.set(n, n2, n3);
    }

    @Override
    protected void setImpl(PImage pImage, int n, int n2, int n3, int n4, int n5, int n6) {
        this.loadPixels();
        this.setgetPixels = true;
        super.setImpl(pImage, n, n2, n3, n4, n5, n6);
    }

    public void loadTexture() {
        boolean bl = false;
        if (!this.drawing) {
            this.beginDraw();
            bl = true;
        }
        this.flush();
        if (this.primarySurface) {
            if (this.pgl.isFBOBacked()) {
                this.pgl.syncBackTexture();
            } else {
                this.loadTextureImpl(2, false);
                if (this.nativePixels == null || this.nativePixels.length < this.width * this.height) {
                    this.nativePixels = new int[this.width * this.height];
                    this.nativePixelBuffer = PGL.allocateIntBuffer(this.nativePixels);
                }
                this.beginPixelsOp(1);
                try {
                    this.pgl.readPixels(0, 0, this.width, this.height, 6408, 5121, this.nativePixelBuffer);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                this.endPixelsOp();
                this.texture.setNative(this.nativePixelBuffer, 0, 0, this.width, this.height);
            }
        } else if (this.offscreenMultisample) {
            this.multisampleFramebuffer.copy(this.offscreenFramebuffer, currentFramebuffer);
        }
        if (bl) {
            this.endDraw();
        }
    }

    public void updateTexture() {
        this.texture.updateTexels();
    }

    public void updateTexture(int n, int n2, int n3, int n4) {
        this.texture.updateTexels(n, n2, n3, n4);
    }

    public void updateDisplay() {
        this.flush();
        this.beginPixelsOp(2);
        this.drawTexture();
        this.endPixelsOp();
    }

    public void drawTexture(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.beginPGL();
        this.pgl.drawTexture(n, n2, n3, n4, n5, n6, n7, n8);
        this.endPGL();
    }

    public void drawTexture(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        this.beginPGL();
        this.pgl.drawTexture(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12);
        this.endPGL();
    }

    protected void loadTextureImpl(int n, boolean bl) {
        if (this.width == 0 || this.height == 0) {
            return;
        }
        if (this.texture == null || this.texture.contextIsOutdated()) {
            Texture.Parameters parameters = new Texture.Parameters(2, n, bl);
            this.texture = new Texture(this.parent, this.width, this.height, parameters);
            this.texture.invertedY(true);
            this.texture.colorBufferOf(this);
            pgPrimary.setCache(this, this.texture);
            if (!this.primarySurface) {
                this.ptexture = new Texture(this.parent, this.width, this.height, parameters);
                this.ptexture.invertedY(true);
                this.ptexture.colorBufferOf(this);
            }
        }
    }

    protected void swapTextures() {
        int n = this.texture.glName;
        this.texture.glName = this.ptexture.glName;
        this.ptexture.glName = n;
        if (!this.primarySurface) {
            this.offscreenFramebuffer.setColorBuffer(this.texture);
        }
    }

    protected void drawTexture() {
        this.pgl.disable(3042);
        this.pgl.drawTexture(this.texture.glTarget, this.texture.glName, this.texture.glWidth, this.texture.glHeight, 0, 0, this.width, this.height);
        this.pgl.enable(3042);
    }

    protected void drawTexture(int n, int n2, int n3, int n4) {
        this.pgl.disable(3042);
        this.pgl.drawTexture(this.texture.glTarget, this.texture.glName, this.texture.glWidth, this.texture.glHeight, n, n2, n + n3, n2 + n4, n, this.height - (n2 + n4), n + n3, this.height - n2);
        this.pgl.enable(3042);
    }

    @Override
    public void mask(PImage pImage) {
        if (pImage.width != this.width || pImage.height != this.height) {
            throw new RuntimeException("The PImage used with mask() must be the same size as the applet.");
        }
        if (maskShader == null) {
            maskShader = new TexureShader(this.parent, defTextureShaderVertURL, maskShaderFragURL);
        }
        maskShader.set("mask", pImage);
        this.filter(maskShader);
    }

    @Override
    public void filter(int n) {
        PImage pImage = this.get();
        pImage.filter(n);
        this.set(0, 0, pImage);
    }

    @Override
    public void filter(int n, float f) {
        PImage pImage = this.get();
        pImage.filter(n, f);
        this.set(0, 0, pImage);
    }

    @Override
    public void filter(PShader pShader) {
        if (!(pShader instanceof TexureShader)) {
            PGraphics.showWarning(INVALID_FILTER_SHADER_ERROR);
            return;
        }
        this.pgl.needFBOLayer();
        this.loadTexture();
        if (this.filterTexture == null || this.filterTexture.contextIsOutdated()) {
            this.filterTexture = new Texture(this.parent, this.texture.width, this.texture.height, this.texture.getParameters());
            this.filterTexture.invertedY(true);
            this.filterImage = this.wrapTexture(this.filterTexture);
        }
        this.filterTexture.set(this.texture);
        this.pgl.depthMask(false);
        this.pgl.disable(2929);
        this.begin2D();
        boolean bl = this.lights;
        this.lights = false;
        int n = this.textureMode;
        this.textureMode = 1;
        boolean bl2 = this.stroke;
        this.stroke = false;
        TexureShader texureShader = this.textureShader;
        this.textureShader = (TexureShader)pShader;
        this.beginShape(17);
        this.texture(this.filterImage);
        this.vertex(0.0f, 0.0f, 0.0f, 0.0f);
        this.vertex(this.width, 0.0f, 1.0f, 0.0f);
        this.vertex(this.width, this.height, 1.0f, 1.0f);
        this.vertex(0.0f, this.height, 0.0f, 1.0f);
        this.endShape();
        this.end2D();
        this.textureShader = texureShader;
        this.stroke = bl2;
        this.lights = bl;
        this.textureMode = n;
        if (!this.hints[2]) {
            this.pgl.enable(2929);
        }
        if (!this.hints[5]) {
            this.pgl.depthMask(true);
        }
    }

    @Override
    public void blendMode(int n) {
        if (this.blendMode != n) {
            this.flush();
            this.setBlendMode(n);
        }
    }

    protected void setBlendMode(int n) {
        this.blendMode = n;
        this.pgl.enable(3042);
        if (n == 0) {
            if (blendEqSupported) {
                this.pgl.blendEquation(32774);
            }
            this.pgl.blendFunc(1, 0);
        } else if (n == 1) {
            if (blendEqSupported) {
                this.pgl.blendEquation(32774);
            }
            this.pgl.blendFunc(770, 771);
        } else if (n == 2) {
            if (blendEqSupported) {
                this.pgl.blendEquation(32774);
            }
            this.pgl.blendFunc(770, 1);
        } else if (n == 4) {
            if (blendEqSupported) {
                this.pgl.blendEquation(32774);
            }
            this.pgl.blendFunc(775, 0);
        } else if (n == 8) {
            if (blendEqSupported) {
                this.pgl.blendEquation(32776);
                this.pgl.blendFunc(770, 772);
            } else {
                PGraphics.showWarning(BLEND_DRIVER_ERROR, "LIGHTEST");
            }
        } else if (n == 16) {
            if (blendEqSupported) {
                this.pgl.blendEquation(32775);
                this.pgl.blendFunc(770, 772);
            } else {
                PGraphics.showWarning(BLEND_DRIVER_ERROR, "DARKEST");
            }
        } else if (n == 32) {
            if (blendEqSupported) {
                this.pgl.blendEquation(32779);
                this.pgl.blendFunc(1, 1);
            } else {
                PGraphics.showWarning(BLEND_DRIVER_ERROR, "DIFFERENCE");
            }
        } else if (n == 64) {
            if (blendEqSupported) {
                this.pgl.blendEquation(32774);
            }
            this.pgl.blendFunc(775, 769);
        } else if (n == 128) {
            if (blendEqSupported) {
                this.pgl.blendEquation(32774);
            }
            this.pgl.blendFunc(774, 768);
        } else if (n == 256) {
            if (blendEqSupported) {
                this.pgl.blendEquation(32774);
            }
            this.pgl.blendFunc(775, 1);
        } else if (n == 512) {
            PGraphics.showWarning(BLEND_RENDERER_ERROR, "OVERLAY");
        } else if (n == 1024) {
            PGraphics.showWarning(BLEND_RENDERER_ERROR, "HARD_LIGHT");
        } else if (n == 2048) {
            PGraphics.showWarning(BLEND_RENDERER_ERROR, "SOFT_LIGHT");
        } else if (n == 4096) {
            PGraphics.showWarning(BLEND_RENDERER_ERROR, "DODGE");
        } else if (n == 8192) {
            PGraphics.showWarning(BLEND_RENDERER_ERROR, "BURN");
        }
    }

    public Texture getTexture() {
        this.loadTexture();
        return this.texture;
    }

    public Texture getTexture(PImage pImage) {
        Texture texture = (Texture)this.initCache(pImage);
        if (texture == null) {
            return null;
        }
        if (pImage.isModified()) {
            if (pImage.width != texture.width || pImage.height != texture.height) {
                texture.init(pImage.width, pImage.height);
            }
            this.updateTexture(pImage, texture);
        }
        if (texture.hasBuffers()) {
            texture.bufferUpdate();
        }
        this.checkTexture(texture);
        return texture;
    }

    @Override
    public Object initCache(PImage pImage) {
        if (!this.checkGLThread()) {
            return null;
        }
        Texture texture = (Texture)pgPrimary.getCache(pImage);
        if ((texture == null || texture.contextIsOutdated()) && (texture = this.addTexture(pImage)) != null) {
            pImage.loadPixels();
            texture.set(pImage.pixels);
        }
        return texture;
    }

    protected void bindBackTexture() {
        if (this.primarySurface) {
            this.pgl.bindFrontTexture();
        } else {
            this.ptexture.bind();
        }
    }

    protected void unbindBackTexture() {
        if (this.primarySurface) {
            this.pgl.unbindFrontTexture();
        } else {
            this.ptexture.unbind();
        }
    }

    protected Texture addTexture(PImage pImage) {
        Texture.Parameters parameters = new Texture.Parameters(2, this.textureSampling, this.getHint(-8), this.textureWrap);
        return this.addTexture(pImage, parameters);
    }

    protected Texture addTexture(PImage pImage, Texture.Parameters parameters) {
        if (pImage.width == 0 || pImage.height == 0) {
            return null;
        }
        if (pImage.parent == null) {
            pImage.parent = this.parent;
        }
        Texture texture = new Texture(pImage.parent, pImage.width, pImage.height, parameters);
        pgPrimary.setCache(pImage, texture);
        return texture;
    }

    protected void checkTexture(Texture texture) {
        if (!texture.isColorBuffer() && texture.usingMipmaps == this.hints[8]) {
            if (this.hints[8]) {
                texture.usingMipmaps(false, this.textureSampling);
            } else {
                texture.usingMipmaps(true, this.textureSampling);
            }
        }
        if (texture.usingRepeat && this.textureWrap == 0 || !texture.usingRepeat && this.textureWrap == 1) {
            if (this.textureWrap == 0) {
                texture.usingRepeat(false);
            } else {
                texture.usingRepeat(true);
            }
        }
    }

    protected PImage wrapTexture(Texture texture) {
        PImage pImage = new PImage();
        pImage.parent = this.parent;
        pImage.width = texture.width;
        pImage.height = texture.height;
        pImage.format = 2;
        pgPrimary.setCache(pImage, texture);
        return pImage;
    }

    protected void updateTexture(PImage pImage, Texture texture) {
        if (texture != null) {
            int n = pImage.getModifiedX1();
            int n2 = pImage.getModifiedY1();
            int n3 = pImage.getModifiedX2() - n + 1;
            int n4 = pImage.getModifiedY2() - n2 + 1;
            texture.set(pImage.pixels, n, n2, n3, n4, pImage.format);
        }
        pImage.setModified(false);
    }

    protected boolean checkGLThread() {
        if (this.pgl.threadIsCurrent()) {
            return true;
        }
        PGraphics.showWarning(OPENGL_THREAD_ERROR);
        return false;
    }

    @Override
    public void resize(int n, int n2) {
        PGraphics.showMethodWarning("resize");
    }

    protected void initPrimary() {
        this.pgl.initSurface(this.quality);
        if (this.texture != null) {
            pgPrimary.removeCache(this);
            this.ptexture = null;
            this.texture = null;
        }
        pgPrimary = this;
        this.initialized = true;
    }

    protected void updatePrimary() {
        this.pgl.update();
    }

    protected void beginOnscreenDraw() {
        this.updatePrimary();
        this.pgl.beginDraw(this.clearColorBuffer);
        if (drawFramebuffer == null) {
            drawFramebuffer = new FrameBuffer(this.parent, this.width, this.height, true);
        }
        drawFramebuffer.setFBO(this.pgl.getDrawFramebuffer());
        if (readFramebuffer == null) {
            readFramebuffer = new FrameBuffer(this.parent, this.width, this.height, true);
        }
        readFramebuffer.setFBO(this.pgl.getReadFramebuffer());
        if (currentFramebuffer == null) {
            this.setFramebuffer(drawFramebuffer);
        }
        if (this.pgl.isFBOBacked()) {
            if (this.texture == null) {
                this.texture = this.pgl.wrapBackTexture();
            } else {
                this.texture.glName = this.pgl.getBackTextureName();
            }
            if (this.ptexture == null) {
                this.ptexture = this.pgl.wrapFrontTexture();
            } else {
                this.ptexture.glName = this.pgl.getFrontTextureName();
            }
        }
    }

    protected void endOnscreenDraw() {
        this.pgl.endDraw(this.clearColorBuffer0);
    }

    protected void initOffscreen() {
        boolean bl;
        this.loadTextureImpl(4, false);
        if (this.offscreenFramebuffer != null) {
            this.offscreenFramebuffer.release();
        }
        if (this.multisampleFramebuffer != null) {
            this.multisampleFramebuffer.release();
        }
        boolean bl2 = bl = depthBits == 24 && stencilBits == 8 && packedDepthStencilSupported;
        if (fboMultisampleSupported && 1 < this.quality) {
            this.multisampleFramebuffer = new FrameBuffer(this.parent, this.texture.glWidth, this.texture.glHeight, this.quality, 0, depthBits, stencilBits, bl, false);
            this.multisampleFramebuffer.clear();
            this.offscreenMultisample = true;
            this.offscreenFramebuffer = new FrameBuffer(this.parent, this.texture.glWidth, this.texture.glHeight, 1, 1, 0, 0, false, false);
        } else {
            this.quality = 0;
            this.offscreenFramebuffer = new FrameBuffer(this.parent, this.texture.glWidth, this.texture.glHeight, 1, 1, depthBits, stencilBits, bl, false);
            this.offscreenMultisample = false;
        }
        this.offscreenFramebuffer.setColorBuffer(this.texture);
        this.offscreenFramebuffer.clear();
        this.initialized = true;
    }

    protected void updateOffscreen() {
        if (!this.initialized) {
            this.initOffscreen();
        } else {
            boolean bl;
            boolean bl2 = this.offscreenFramebuffer != null && this.offscreenFramebuffer.contextIsOutdated();
            boolean bl3 = bl = this.multisampleFramebuffer != null && this.multisampleFramebuffer.contextIsOutdated();
            if (bl2 || bl) {
                this.restartPGL();
                this.initOffscreen();
            } else {
                this.swapTextures();
            }
        }
        this.pushFramebuffer();
        if (this.offscreenMultisample) {
            this.setFramebuffer(this.multisampleFramebuffer);
        } else {
            this.setFramebuffer(this.offscreenFramebuffer);
        }
    }

    protected void beginOffscreenDraw() {
        this.updateOffscreen();
        this.offscreenFramebuffer.setColorBuffer(this.texture);
        if (this.clip) {
            this.pgl.enable(3089);
            this.pgl.scissor(this.clipRect[0], this.clipRect[1], this.clipRect[2], this.clipRect[3]);
        } else {
            this.pgl.disable(3089);
        }
    }

    protected void endOffscreenDraw() {
        if (this.offscreenMultisample) {
            this.multisampleFramebuffer.copy(this.offscreenFramebuffer, currentFramebuffer);
        }
        if (!this.clearColorBuffer0) {
            if (this.offscreenMultisample) {
                this.pushFramebuffer();
                this.setFramebuffer(this.offscreenFramebuffer);
            }
            this.offscreenFramebuffer.setColorBuffer(this.ptexture);
            this.drawTexture();
            this.offscreenFramebuffer.setColorBuffer(this.texture);
            if (this.offscreenMultisample) {
                this.popFramebuffer();
            }
        }
        this.popFramebuffer();
        this.texture.updateTexels();
        pgPrimary.restoreGL();
    }

    protected void setDefaults() {
        this.inGeo.clear();
        this.tessGeo.clear();
        this.texCache.clear();
        super.noTexture();
        this.setBlendMode(1);
        if (this.hints[2]) {
            this.pgl.disable(2929);
        } else {
            this.pgl.enable(2929);
        }
        this.pgl.depthFunc(515);
        this.flushMode = this.hints[6] ? 0 : 1;
        if (this.primarySurface) {
            this.pgl.getIntegerv(32937, this.intBuffer);
            int n = this.intBuffer.get(0);
            if (this.quality != n && 1 < n && 1 < this.quality) {
                this.quality = n;
            }
        }
        if (this.quality < 2) {
            this.pgl.disable(-1);
        } else {
            this.pgl.enable(-1);
        }
        this.pgl.disable(-1);
        this.pgl.disable(-1);
        this.pgl.disable(-1);
        this.viewport.put(0, 0);
        this.viewport.put(1, 0);
        this.viewport.put(2, this.width);
        this.viewport.put(3, this.height);
        this.pgl.viewport(this.viewport.get(0), this.viewport.get(1), this.viewport.get(2), this.viewport.get(3));
        if (this.sized) {
            this.background(this.backgroundColor);
            this.defaultPerspective();
            this.defaultCamera();
            this.sized = false;
        } else {
            this.modelview.set(this.camera);
            this.modelviewInv.set(this.cameraInv);
            this.updateProjmodelview();
        }
        if (this.is3D()) {
            this.noLights();
            this.lightFalloff(1.0f, 0.0f, 0.0f);
            this.lightSpecular(0.0f, 0.0f, 0.0f);
        }
        this.pgl.frontFace(2304);
        this.pgl.disable(2884);
        this.pgl.activeTexture(33984);
        this.normalZ = 0.0f;
        this.normalY = 0.0f;
        this.normalX = 0.0f;
        this.pgl.depthMask(true);
        this.pgl.clearDepth(1.0f);
        this.pgl.clearStencil(0);
        this.pgl.clear(1280);
        if (!this.settingsInited) {
            this.defaultSettings();
        }
        if (this.restoreSurface) {
            this.restoreSurfaceFromPixels();
            this.restoreSurface = false;
        }
        if (this.hints[5]) {
            this.pgl.depthMask(false);
        } else {
            this.pgl.depthMask(true);
        }
        this.pixelsOp = 0;
        this.modified = false;
        this.setgetPixels = false;
        this.clearColorBuffer0 = this.clearColorBuffer;
        this.clearColorBuffer = false;
    }

    protected void getGLParameters() {
        OPENGL_VENDOR = this.pgl.getString(7936);
        OPENGL_RENDERER = this.pgl.getString(7937);
        OPENGL_VERSION = this.pgl.getString(7938);
        OPENGL_EXTENSIONS = this.pgl.getString(7939);
        GLSL_VERSION = this.pgl.getString(35724);
        int n = this.pgl.getGLVersion()[0];
        if (n < 2 && (OPENGL_EXTENSIONS.indexOf("_fragment_shader") == -1 || OPENGL_EXTENSIONS.indexOf("_vertex_shader") == -1 || OPENGL_EXTENSIONS.indexOf("_shader_objects") == -1 || OPENGL_EXTENSIONS.indexOf("_shading_language") == -1)) {
            throw new RuntimeException("Processing cannot run because GLSL shaders are not available.");
        }
        npotTexSupported = -1 < OPENGL_EXTENSIONS.indexOf("_texture_non_power_of_two");
        autoMipmapGenSupported = -1 < OPENGL_EXTENSIONS.indexOf("_generate_mipmap");
        fboMultisampleSupported = -1 < OPENGL_EXTENSIONS.indexOf("_framebuffer_multisample");
        packedDepthStencilSupported = -1 < OPENGL_EXTENSIONS.indexOf("_packed_depth_stencil");
        anisoSamplingSupported = -1 < OPENGL_EXTENSIONS.indexOf("_texture_filter_anisotropic");
        try {
            this.pgl.blendEquation(32774);
            blendEqSupported = true;
        }
        catch (Exception exception) {
            blendEqSupported = false;
        }
        depthBits = this.pgl.getDepthBits();
        stencilBits = this.pgl.getStencilBits();
        this.pgl.getIntegerv(3379, this.intBuffer);
        maxTextureSize = this.intBuffer.get(0);
        this.pgl.getIntegerv(-1, this.intBuffer);
        maxSamples = this.intBuffer.get(0);
        this.pgl.getIntegerv(33902, this.intBuffer);
        maxLineWidth = this.intBuffer.get(0);
        this.pgl.getIntegerv(33901, this.intBuffer);
        maxPointSize = this.intBuffer.get(0);
        if (anisoSamplingSupported) {
            this.pgl.getFloatv(34047, this.floatBuffer);
            maxAnisoAmount = this.floatBuffer.get(0);
        }
        glParamsRead = true;
    }

    @Override
    public PShader loadShader(String string) {
        int n = this.getShaderType(string);
        if (n == -1) {
            PGraphics.showWarning(INVALID_PROCESSING_SHADER_ERROR);
            return null;
        }
        BaseShader baseShader = null;
        if (n == 5) {
            baseShader = new PointShader(this.parent);
            baseShader.setVertexShader(defPointShaderVertURL);
        } else if (n == 4) {
            baseShader = new LineShader(this.parent);
            baseShader.setVertexShader(defLineShaderVertURL);
        } else if (n == 3) {
            baseShader = new TexlightShader(this.parent);
            baseShader.setVertexShader(defTexlightShaderVertURL);
        } else if (n == 1) {
            baseShader = new LightShader(this.parent);
            baseShader.setVertexShader(defLightShaderVertURL);
        } else if (n == 2) {
            baseShader = new TexureShader(this.parent);
            baseShader.setVertexShader(defTextureShaderVertURL);
        } else if (n == 0) {
            baseShader = new ColorShader(this.parent);
            baseShader.setVertexShader(defColorShaderVertURL);
        }
        baseShader.setFragmentShader(string);
        return baseShader;
    }

    @Override
    public PShader loadShader(String string, String string2) {
        int n = this.getShaderType(string2);
        if (n == -1) {
            n = this.getShaderType(string);
        }
        if (n == -1) {
            PGraphics.showWarning(INVALID_PROCESSING_SHADER_ERROR);
            return null;
        }
        BaseShader baseShader = null;
        if (string == null || string.equals("")) {
            if (n == 5) {
                baseShader = new PointShader(this.parent);
                baseShader.setFragmentShader(defPointShaderFragURL);
            } else if (n == 4) {
                baseShader = new LineShader(this.parent);
                baseShader.setFragmentShader(defLineShaderFragURL);
            } else if (n == 3) {
                baseShader = new TexlightShader(this.parent);
                baseShader.setFragmentShader(defTextureShaderFragURL);
            } else if (n == 1) {
                baseShader = new LightShader(this.parent);
                baseShader.setFragmentShader(defColorShaderFragURL);
            } else if (n == 2) {
                baseShader = new TexureShader(this.parent);
                baseShader.setFragmentShader(defTextureShaderFragURL);
            } else if (n == 0) {
                baseShader = new ColorShader(this.parent);
                baseShader.setFragmentShader(defColorShaderFragURL);
            }
            if (baseShader != null) {
                baseShader.setVertexShader(string2);
            }
        } else if (n == 5) {
            baseShader = new PointShader(this.parent, string2, string);
        } else if (n == 4) {
            baseShader = new LineShader(this.parent, string2, string);
        } else if (n == 3) {
            baseShader = new TexlightShader(this.parent, string2, string);
        } else if (n == 1) {
            baseShader = new LightShader(this.parent, string2, string);
        } else if (n == 2) {
            baseShader = new TexureShader(this.parent, string2, string);
        } else if (n == 0) {
            baseShader = new ColorShader(this.parent, string2, string);
        }
        return baseShader;
    }

    @Override
    public void shader(PShader pShader) {
        this.shader(pShader, 20);
    }

    @Override
    public void shader(PShader pShader, int n) {
        this.flush();
        if (n == 9 || n == 17 || n == 20) {
            if (pShader instanceof TexureShader) {
                this.textureShader = (TexureShader)pShader;
            } else if (pShader instanceof ColorShader) {
                this.colorShader = (ColorShader)pShader;
            } else if (pShader instanceof TexlightShader) {
                this.texlightShader = (TexlightShader)pShader;
            } else if (pShader instanceof LightShader) {
                this.lightShader = (LightShader)pShader;
            } else {
                PGraphics.showWarning(WRONG_SHADER_TYPE_ERROR);
            }
        } else if (n == 5) {
            if (pShader instanceof LineShader) {
                this.lineShader = (LineShader)pShader;
            } else {
                PGraphics.showWarning(WRONG_SHADER_TYPE_ERROR);
            }
        } else if (n == 3) {
            if (pShader instanceof PointShader) {
                this.pointShader = (PointShader)pShader;
            } else {
                PGraphics.showWarning(WRONG_SHADER_TYPE_ERROR);
            }
        } else {
            PGraphics.showWarning(UNKNOWN_SHADER_KIND_ERROR);
        }
    }

    @Override
    public void resetShader() {
        this.resetShader(20);
    }

    @Override
    public void resetShader(int n) {
        this.flush();
        if (n == 9 || n == 17 || n == 20) {
            this.textureShader = null;
            this.colorShader = null;
            this.texlightShader = null;
            this.lightShader = null;
        } else if (n == 5) {
            this.lineShader = null;
        } else if (n == 3) {
            this.pointShader = null;
        } else {
            PGraphics.showWarning(UNKNOWN_SHADER_KIND_ERROR);
        }
    }

    public void shaderWarnings(boolean bl) {
        this.shaderWarningsEnabled = bl;
    }

    protected int getShaderType(String string) {
        String[] stringArray = this.parent.loadStrings(string);
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("#define PROCESSING_POINT_SHADER")) {
                n = 5;
                continue;
            }
            if (stringArray[i].equals("#define PROCESSING_LINE_SHADER")) {
                n = 4;
                continue;
            }
            if (stringArray[i].equals("#define PROCESSING_COLOR_SHADER")) {
                n = 0;
                continue;
            }
            if (stringArray[i].equals("#define PROCESSING_LIGHT_SHADER")) {
                n = 1;
                continue;
            }
            if (stringArray[i].equals("#define PROCESSING_TEXTURE_SHADER")) {
                n = 2;
                continue;
            }
            if (!stringArray[i].equals("#define PROCESSING_TEXLIGHT_SHADER")) continue;
            n = 3;
        }
        return n;
    }

    protected void deleteDefaultShaders() {
        defColorShader = null;
        defTextureShader = null;
        defLightShader = null;
        defTexlightShader = null;
        defLineShader = null;
        defPointShader = null;
        maskShader = null;
    }

    protected BaseShader getPolyShader(boolean bl, boolean bl2) {
        BaseShader baseShader;
        if (bl) {
            if (bl2) {
                if (this.texlightShader == null) {
                    if (defTexlightShader == null) {
                        defTexlightShader = new TexlightShader(this.parent, defTexlightShaderVertURL, defTextureShaderFragURL);
                    }
                    baseShader = defTexlightShader;
                    this.texlightShaderCheck();
                } else {
                    baseShader = this.texlightShader;
                }
            } else if (this.lightShader == null) {
                if (defLightShader == null) {
                    defLightShader = new LightShader(this.parent, defLightShaderVertURL, defColorShaderFragURL);
                }
                baseShader = defLightShader;
                this.lightShaderCheck();
            } else {
                baseShader = this.lightShader;
            }
        } else if (bl2) {
            if (this.textureShader == null) {
                if (defTextureShader == null) {
                    defTextureShader = new TexureShader(this.parent, defTextureShaderVertURL, defTextureShaderFragURL);
                }
                baseShader = defTextureShader;
                this.textureShaderCheck();
            } else {
                baseShader = this.textureShader;
            }
        } else if (this.colorShader == null) {
            if (defColorShader == null) {
                defColorShader = new ColorShader(this.parent, defColorShaderVertURL, defColorShaderFragURL);
            }
            baseShader = defColorShader;
            this.colorShaderCheck();
        } else {
            baseShader = this.colorShader;
        }
        baseShader.setRenderer(this);
        baseShader.loadAttributes();
        baseShader.loadUniforms();
        return baseShader;
    }

    protected void texlightShaderCheck() {
        if (this.shaderWarningsEnabled && (this.lightShader != null || this.textureShader != null || this.colorShader != null)) {
            PGraphics.showWarning(NO_TEXLIGHT_SHADER_ERROR);
        }
    }

    protected void lightShaderCheck() {
        if (this.shaderWarningsEnabled && (this.texlightShader != null || this.textureShader != null || this.colorShader != null)) {
            PGraphics.showWarning(NO_LIGHT_SHADER_ERROR);
        }
    }

    protected void textureShaderCheck() {
        if (this.shaderWarningsEnabled && (this.texlightShader != null || this.lightShader != null || this.colorShader != null)) {
            PGraphics.showWarning(NO_TEXTURE_SHADER_ERROR);
        }
    }

    protected void colorShaderCheck() {
        if (this.shaderWarningsEnabled && (this.texlightShader != null || this.lightShader != null || this.textureShader != null)) {
            PGraphics.showWarning(NO_COLOR_SHADER_ERROR);
        }
    }

    protected LineShader getLineShader() {
        LineShader lineShader;
        if (this.lineShader == null) {
            if (defLineShader == null) {
                defLineShader = new LineShader(this.parent, defLineShaderVertURL, defLineShaderFragURL);
            }
            lineShader = defLineShader;
        } else {
            lineShader = this.lineShader;
        }
        lineShader.setRenderer(this);
        lineShader.loadAttributes();
        lineShader.loadUniforms();
        return lineShader;
    }

    protected PointShader getPointShader() {
        PointShader pointShader;
        if (this.pointShader == null) {
            if (defPointShader == null) {
                defPointShader = new PointShader(this.parent, defPointShaderVertURL, defPointShaderFragURL);
            }
            pointShader = defPointShader;
        } else {
            pointShader = this.pointShader;
        }
        pointShader.setRenderer(this);
        pointShader.loadAttributes();
        pointShader.loadUniforms();
        return pointShader;
    }

    protected static int expandArraySize(int n, int n2) {
        int n3;
        for (n3 = n; n3 < n2; n3 <<= 1) {
        }
        return n3;
    }

    protected InGeometry newInGeometry(int n) {
        return new InGeometry(n);
    }

    protected TessGeometry newTessGeometry(int n) {
        return new TessGeometry(n);
    }

    protected TexCache newTexCache() {
        return new TexCache();
    }

    static {
        glTextureObjects = new HashMap();
        glVertexBuffers = new HashMap();
        glFrameBuffers = new HashMap();
        glRenderBuffers = new HashMap();
        glslPrograms = new HashMap();
        glslVertexShaders = new HashMap();
        glslFragmentShaders = new HashMap();
        defColorShaderVertURL = PGraphicsOpenGL.class.getResource("ColorVert.glsl");
        defTextureShaderVertURL = PGraphicsOpenGL.class.getResource("TextureVert.glsl");
        defLightShaderVertURL = PGraphicsOpenGL.class.getResource("LightVert.glsl");
        defTexlightShaderVertURL = PGraphicsOpenGL.class.getResource("TexlightVert.glsl");
        defColorShaderFragURL = PGraphicsOpenGL.class.getResource("ColorFrag.glsl");
        defTextureShaderFragURL = PGraphicsOpenGL.class.getResource("TextureFrag.glsl");
        defLineShaderVertURL = PGraphicsOpenGL.class.getResource("LineVert.glsl");
        defLineShaderFragURL = PGraphicsOpenGL.class.getResource("LineFrag.glsl");
        defPointShaderVertURL = PGraphicsOpenGL.class.getResource("PointVert.glsl");
        defPointShaderFragURL = PGraphicsOpenGL.class.getResource("PointFrag.glsl");
        maskShaderFragURL = PGraphicsOpenGL.class.getResource("MaskFrag.glsl");
        identity = new PMatrix3D();
        fbStack = new FrameBuffer[16];
    }

    protected class Tessellator {
        InGeometry in;
        TessGeometry tess;
        TexCache texCache;
        PImage prevTexImage;
        PImage newTexImage;
        int firstTexIndex;
        int firstTexCache;
        PGL.Tessellator gluTess;
        TessellatorCallback callback = new TessellatorCallback();
        boolean fill;
        boolean stroke;
        int strokeColor;
        float strokeWeight;
        int strokeJoin;
        int strokeCap;
        boolean accurate2DStrokes;
        PMatrix transform;
        boolean is2D;
        boolean is3D;
        int[] rawIndices;
        int rawSize;
        int[] dupIndices;
        int dupCount;
        int firstPolyIndexCache;
        int lastPolyIndexCache;
        int firstLineIndexCache;
        int lastLineIndexCache;
        int firstPointIndexCache;
        int lastPointIndexCache;

        public Tessellator() {
            this.gluTess = PGraphicsOpenGL.this.pgl.createTessellator(this.callback);
            this.rawIndices = new int[512];
            this.accurate2DStrokes = true;
            this.transform = null;
            this.is2D = false;
            this.is3D = true;
        }

        void setInGeometry(InGeometry inGeometry) {
            this.in = inGeometry;
            this.firstPolyIndexCache = -1;
            this.lastPolyIndexCache = -1;
            this.firstLineIndexCache = -1;
            this.lastLineIndexCache = -1;
            this.firstPointIndexCache = -1;
            this.lastPointIndexCache = -1;
        }

        void setTessGeometry(TessGeometry tessGeometry) {
            this.tess = tessGeometry;
        }

        void setFill(boolean bl) {
            this.fill = bl;
        }

        void setStroke(boolean bl) {
            this.stroke = bl;
        }

        void setStrokeColor(int n) {
            this.strokeColor = PGL.javaToNativeARGB(n);
        }

        void setStrokeWeight(float f) {
            this.strokeWeight = f;
        }

        void setStrokeJoin(int n) {
            this.strokeJoin = n;
        }

        void setStrokeCap(int n) {
            this.strokeCap = n;
        }

        void setAccurate2DStrokes(boolean bl) {
            this.accurate2DStrokes = bl;
        }

        void setTexCache(TexCache texCache, PImage pImage, PImage pImage2) {
            this.texCache = texCache;
            this.prevTexImage = pImage;
            this.newTexImage = pImage2;
        }

        void set3D(boolean bl) {
            if (bl) {
                this.is2D = false;
                this.is3D = true;
            } else {
                this.is2D = true;
                this.is3D = false;
            }
        }

        void setTransform(PMatrix pMatrix) {
            this.transform = pMatrix;
        }

        void tessellatePoints() {
            if (this.strokeCap == 2) {
                this.tessellateRoundPoints();
            } else {
                this.tessellateSquarePoints();
            }
        }

        void tessellateRoundPoints() {
            int n = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.stroke && 1 <= n) {
                int n2 = PApplet.max(20, (int)((float)Math.PI * 2 * this.strokeWeight / 10.0f)) + 1;
                if (32768 <= n2) {
                    throw new RuntimeException("Error in point tessellation.");
                }
                this.updateTex();
                int n3 = n2 * n;
                int n4 = 3 * (n2 - 1) * n;
                if (this.is3D) {
                    this.tessellateRoundPoints3D(n3, n4, n2);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateRoundPoints2D(n3, n4, n2);
                    this.endNoTex();
                }
            }
        }

        void tessellateRoundPoints3D(int n, int n2, int n3) {
            int n4;
            int n5 = n3 - 1;
            this.tess.pointVertexCheck(n);
            this.tess.pointIndexCheck(n2);
            int n6 = this.tess.firstPointVertex;
            int n7 = this.tess.firstPointVertex;
            int n8 = this.tess.firstPointIndex;
            IndexCache indexCache = this.tess.pointIndexCache;
            this.firstPointIndexCache = n4 = this.in.renderMode == 1 ? indexCache.addNew() : indexCache.getLast();
            for (int i = this.in.firstVertex; i <= this.in.lastVertex; ++i) {
                int n9;
                int n10 = indexCache.vertexCount[n4];
                if (32768 <= n10 + n3) {
                    n4 = indexCache.addNew();
                    n10 = 0;
                }
                for (int j = 0; j < n3; ++j) {
                    this.tess.setPointVertex(n6, this.in, i);
                    ++n6;
                }
                this.tess.pointOffsets[2 * n7 + 0] = 0.0f;
                this.tess.pointOffsets[2 * n7 + 1] = 0.0f;
                ++n7;
                float f = 0.0f;
                float f2 = 720.0f / (float)n5;
                for (n9 = 0; n9 < n5; ++n9) {
                    this.tess.pointOffsets[2 * n7 + 0] = 0.5f * cosLUT[(int)f] * this.strokeWeight;
                    this.tess.pointOffsets[2 * n7 + 1] = 0.5f * sinLUT[(int)f] * this.strokeWeight;
                    f = (f + f2) % 720.0f;
                    ++n7;
                }
                for (n9 = 1; n9 < n3 - 1; ++n9) {
                    this.tess.pointIndices[n8++] = (short)(n10 + 0);
                    this.tess.pointIndices[n8++] = (short)(n10 + n9);
                    this.tess.pointIndices[n8++] = (short)(n10 + n9 + 1);
                }
                this.tess.pointIndices[n8++] = (short)(n10 + 0);
                this.tess.pointIndices[n8++] = (short)(n10 + 1);
                this.tess.pointIndices[n8++] = (short)(n10 + n3 - 1);
                indexCache.incCounts(n4, 3 * (n3 - 1), n3);
            }
            this.lastPointIndexCache = n4;
        }

        void tessellateRoundPoints2D(int n, int n2, int n3) {
            int n4;
            int n5 = n3 - 1;
            this.tess.polyVertexCheck(n);
            this.tess.polyIndexCheck(n2);
            int n6 = this.tess.firstPolyVertex;
            int n7 = this.tess.firstPolyIndex;
            IndexCache indexCache = this.tess.polyIndexCache;
            this.firstPointIndexCache = n4 = this.in.renderMode == 1 ? indexCache.addNew() : indexCache.getLast();
            for (int i = this.in.firstVertex; i <= this.in.lastVertex; ++i) {
                int n8;
                int n9 = indexCache.vertexCount[n4];
                if (32768 <= n9 + n3) {
                    n4 = indexCache.addNew();
                    n9 = 0;
                }
                float f = this.in.vertices[3 * i + 0];
                float f2 = this.in.vertices[3 * i + 1];
                int n10 = this.in.strokeColors[i];
                float f3 = 0.0f;
                float f4 = 720.0f / (float)n5;
                this.tess.setPolyVertex(n6, f, f2, 0.0f, n10);
                ++n6;
                for (n8 = 0; n8 < n5; ++n8) {
                    this.tess.setPolyVertex(n6, f + 0.5f * cosLUT[(int)f3] * this.strokeWeight, f2 + 0.5f * sinLUT[(int)f3] * this.strokeWeight, 0.0f, n10);
                    ++n6;
                    f3 = (f3 + f4) % 720.0f;
                }
                for (n8 = 1; n8 < n3 - 1; ++n8) {
                    this.tess.polyIndices[n7++] = (short)(n9 + 0);
                    this.tess.polyIndices[n7++] = (short)(n9 + n8);
                    this.tess.polyIndices[n7++] = (short)(n9 + n8 + 1);
                }
                this.tess.polyIndices[n7++] = (short)(n9 + 0);
                this.tess.polyIndices[n7++] = (short)(n9 + 1);
                this.tess.polyIndices[n7++] = (short)(n9 + n3 - 1);
                indexCache.incCounts(n4, 3 * (n3 - 1), n3);
            }
            this.lastPointIndexCache = this.lastPolyIndexCache = n4;
        }

        void tessellateSquarePoints() {
            int n = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.stroke && 1 <= n) {
                this.updateTex();
                int n2 = n;
                int n3 = 5 * n2;
                int n4 = 12 * n2;
                if (this.is3D) {
                    this.tessellateSquarePoints3D(n3, n4);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateSquarePoints2D(n3, n4);
                    this.endNoTex();
                }
            }
        }

        void tessellateSquarePoints3D(int n, int n2) {
            int n3;
            this.tess.pointVertexCheck(n);
            this.tess.pointIndexCheck(n2);
            int n4 = this.tess.firstPointVertex;
            int n5 = this.tess.firstPointVertex;
            int n6 = this.tess.firstPointIndex;
            IndexCache indexCache = this.tess.pointIndexCache;
            this.firstPointIndexCache = n3 = this.in.renderMode == 1 ? indexCache.addNew() : indexCache.getLast();
            for (int i = this.in.firstVertex; i <= this.in.lastVertex; ++i) {
                int n7;
                int n8 = indexCache.vertexCount[n3];
                int n9 = 5;
                if (32768 <= n8 + n9) {
                    n3 = indexCache.addNew();
                    n8 = 0;
                }
                for (n7 = 0; n7 < n9; ++n7) {
                    this.tess.setPointVertex(n4, this.in, i);
                    ++n4;
                }
                this.tess.pointOffsets[2 * n5 + 0] = 0.0f;
                this.tess.pointOffsets[2 * n5 + 1] = 0.0f;
                ++n5;
                for (n7 = 0; n7 < 4; ++n7) {
                    this.tess.pointOffsets[2 * n5 + 0] = 0.5f * PGraphicsOpenGL.this.QUAD_POINT_SIGNS[n7][0] * this.strokeWeight;
                    this.tess.pointOffsets[2 * n5 + 1] = 0.5f * PGraphicsOpenGL.this.QUAD_POINT_SIGNS[n7][1] * this.strokeWeight;
                    ++n5;
                }
                for (n7 = 1; n7 < n9 - 1; ++n7) {
                    this.tess.pointIndices[n6++] = (short)(n8 + 0);
                    this.tess.pointIndices[n6++] = (short)(n8 + n7);
                    this.tess.pointIndices[n6++] = (short)(n8 + n7 + 1);
                }
                this.tess.pointIndices[n6++] = (short)(n8 + 0);
                this.tess.pointIndices[n6++] = (short)(n8 + 1);
                this.tess.pointIndices[n6++] = (short)(n8 + n9 - 1);
                indexCache.incCounts(n3, 12, 5);
            }
            this.lastPointIndexCache = n3;
        }

        void tessellateSquarePoints2D(int n, int n2) {
            int n3;
            this.tess.polyVertexCheck(n);
            this.tess.polyIndexCheck(n2);
            int n4 = this.tess.firstPolyVertex;
            int n5 = this.tess.firstPolyIndex;
            IndexCache indexCache = this.tess.polyIndexCache;
            this.firstPointIndexCache = n3 = this.in.renderMode == 1 ? indexCache.addNew() : indexCache.getLast();
            for (int i = this.in.firstVertex; i <= this.in.lastVertex; ++i) {
                int n6;
                int n7 = indexCache.vertexCount[n3];
                int n8 = 5;
                if (32768 <= n7 + n8) {
                    n3 = indexCache.addNew();
                    n7 = 0;
                }
                float f = this.in.vertices[3 * i + 0];
                float f2 = this.in.vertices[3 * i + 1];
                int n9 = this.in.strokeColors[i];
                this.tess.setPolyVertex(n4, f, f2, 0.0f, n9);
                ++n4;
                for (n6 = 0; n6 < n8 - 1; ++n6) {
                    this.tess.setPolyVertex(n4, f + 0.5f * PGraphicsOpenGL.this.QUAD_POINT_SIGNS[n6][0] * this.strokeWeight, f2 + 0.5f * PGraphicsOpenGL.this.QUAD_POINT_SIGNS[n6][1] * this.strokeWeight, 0.0f, n9);
                    ++n4;
                }
                for (n6 = 1; n6 < n8 - 1; ++n6) {
                    this.tess.polyIndices[n5++] = (short)(n7 + 0);
                    this.tess.polyIndices[n5++] = (short)(n7 + n6);
                    this.tess.polyIndices[n5++] = (short)(n7 + n6 + 1);
                }
                this.tess.polyIndices[n5++] = (short)(n7 + 0);
                this.tess.polyIndices[n5++] = (short)(n7 + 1);
                this.tess.polyIndices[n5++] = (short)(n7 + n8 - 1);
                indexCache.incCounts(n3, 12, 5);
            }
            this.lastPointIndexCache = this.lastPolyIndexCache = n3;
        }

        void tessellateLines() {
            int n = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.stroke && 2 <= n) {
                this.updateTex();
                int n2 = n / 2;
                if (this.is3D) {
                    this.tessellateLines3D(n2);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateLines2D(n2);
                    this.endNoTex();
                }
            }
        }

        void tessellateLines3D(int n) {
            int n2;
            int n3 = n * 4;
            int n4 = n * 2 * 3;
            int n5 = this.in.firstVertex;
            this.tess.lineVertexCheck(n3);
            this.tess.lineIndexCheck(n4);
            this.firstLineIndexCache = n2 = this.in.renderMode == 1 ? this.tess.lineIndexCache.addNew() : this.tess.lineIndexCache.getLast();
            for (int i = 0; i < n; ++i) {
                int n6 = n5 + 2 * i + 0;
                int n7 = n5 + 2 * i + 1;
                n2 = this.addLine3D(n6, n7, n2, null, false);
            }
            this.lastLineIndexCache = n2;
        }

        void tessellateLines2D(int n) {
            int n2 = n * 4;
            int n3 = n * 2 * 3;
            int n4 = this.in.firstVertex;
            if (this.noCapsJoins(n2)) {
                int n5;
                this.tess.polyVertexCheck(n2);
                this.tess.polyIndexCheck(n3);
                this.firstLineIndexCache = n5 = this.in.renderMode == 1 ? this.tess.polyIndexCache.addNew() : this.tess.polyIndexCache.getLast();
                if (this.firstPolyIndexCache == -1) {
                    this.firstPolyIndexCache = n5;
                }
                for (int i = 0; i < n; ++i) {
                    int n6 = n4 + 2 * i + 0;
                    int n7 = n4 + 2 * i + 1;
                    n5 = this.addLine2D(n6, n7, n5, false);
                }
                this.lastLineIndexCache = this.lastPolyIndexCache = n5;
            } else {
                LinePath linePath = new LinePath(1);
                for (int i = 0; i < n; ++i) {
                    int n8 = n4 + 2 * i + 0;
                    int n9 = n4 + 2 * i + 1;
                    linePath.moveTo(this.in.vertices[3 * n8 + 0], this.in.vertices[3 * n8 + 1], this.in.strokeColors[n8]);
                    linePath.lineTo(this.in.vertices[3 * n9 + 0], this.in.vertices[3 * n9 + 1], this.in.strokeColors[n9]);
                }
                this.tessellateLinePath(linePath);
            }
        }

        void tessellateLineStrip() {
            int n = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.stroke && 2 <= n) {
                this.updateTex();
                int n2 = n - 1;
                if (this.is3D) {
                    this.tessellateLineStrip3D(n2);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateLineStrip2D(n2);
                    this.endNoTex();
                }
            }
        }

        void tessellateLineStrip3D(int n) {
            int n2;
            int n3 = this.noCapsJoins() ? 0 : n - 1;
            int n4 = n * 4 + n3;
            int n5 = n * 2 * 3 + n3 * 2 * 3;
            this.tess.lineVertexCheck(n4);
            this.tess.lineIndexCheck(n5);
            this.firstLineIndexCache = n2 = this.in.renderMode == 1 ? this.tess.lineIndexCache.addNew() : this.tess.lineIndexCache.getLast();
            int n6 = this.in.firstVertex;
            short[] sArray = new short[]{-1, -1};
            for (int i = 0; i < n; ++i) {
                int n7 = this.in.firstVertex + i + 1;
                n2 = 0 < n3 ? this.addLine3D(n6, n7, n2, sArray, false) : this.addLine3D(n6, n7, n2, null, false);
                n6 = n7;
            }
            this.lastLineIndexCache = n2;
        }

        void tessellateLineStrip2D(int n) {
            int n2 = n * 4;
            int n3 = n * 2 * 3;
            if (this.noCapsJoins(n2)) {
                int n4;
                this.tess.polyVertexCheck(n2);
                this.tess.polyIndexCheck(n3);
                this.firstLineIndexCache = n4 = this.in.renderMode == 1 ? this.tess.polyIndexCache.addNew() : this.tess.polyIndexCache.getLast();
                if (this.firstPolyIndexCache == -1) {
                    this.firstPolyIndexCache = n4;
                }
                int n5 = this.in.firstVertex;
                for (int i = 0; i < n; ++i) {
                    int n6 = this.in.firstVertex + i + 1;
                    n4 = this.addLine2D(n5, n6, n4, false);
                    n5 = n6;
                }
                this.lastLineIndexCache = this.lastPolyIndexCache = n4;
            } else {
                int n7 = this.in.firstVertex;
                LinePath linePath = new LinePath(1);
                linePath.moveTo(this.in.vertices[3 * n7 + 0], this.in.vertices[3 * n7 + 1], this.in.strokeColors[n7]);
                for (int i = 0; i < n; ++i) {
                    int n8 = n7 + i + 1;
                    linePath.lineTo(this.in.vertices[3 * n8 + 0], this.in.vertices[3 * n8 + 1], this.in.strokeColors[n8]);
                }
                this.tessellateLinePath(linePath);
            }
        }

        void tessellateLineLoop() {
            int n = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.stroke && 2 <= n) {
                this.updateTex();
                int n2 = n;
                if (this.is3D) {
                    this.tessellateLineLoop3D(n2);
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateLineLoop2D(n2);
                    this.endNoTex();
                }
            }
        }

        void tessellateLineLoop3D(int n) {
            int n2;
            int n3 = this.noCapsJoins() ? 0 : n - 1;
            int n4 = n * 4 + n3;
            int n5 = n * 2 * 3 + n3 * 2 * 3;
            this.tess.lineVertexCheck(n4);
            this.tess.lineIndexCheck(n5);
            this.firstLineIndexCache = n2 = this.in.renderMode == 1 ? this.tess.lineIndexCache.addNew() : this.tess.lineIndexCache.getLast();
            int n6 = this.in.firstVertex;
            short[] sArray = new short[]{-1, -1};
            for (int i = 0; i < n - 1; ++i) {
                int n7 = this.in.firstVertex + i + 1;
                n2 = 0 < n3 ? this.addLine3D(n6, n7, n2, sArray, false) : this.addLine3D(n6, n7, n2, null, false);
                n6 = n7;
            }
            this.lastLineIndexCache = n2 = this.addLine3D(this.in.lastVertex, this.in.firstVertex, n2, sArray, false);
        }

        void tessellateLineLoop2D(int n) {
            int n2 = n * 4;
            int n3 = n * 2 * 3;
            if (this.noCapsJoins(n2)) {
                int n4;
                this.tess.polyVertexCheck(n2);
                this.tess.polyIndexCheck(n3);
                this.firstLineIndexCache = n4 = this.in.renderMode == 1 ? this.tess.polyIndexCache.addNew() : this.tess.polyIndexCache.getLast();
                if (this.firstPolyIndexCache == -1) {
                    this.firstPolyIndexCache = n4;
                }
                int n5 = this.in.firstVertex;
                for (int i = 0; i < n - 1; ++i) {
                    int n6 = this.in.firstVertex + i + 1;
                    n4 = this.addLine2D(n5, n6, n4, false);
                    n5 = n6;
                }
                this.lastLineIndexCache = this.lastPolyIndexCache = (n4 = this.addLine2D(this.in.lastVertex, this.in.firstVertex, n4, false));
            } else {
                int n7 = this.in.firstVertex;
                LinePath linePath = new LinePath(1);
                linePath.moveTo(this.in.vertices[3 * n7 + 0], this.in.vertices[3 * n7 + 1], this.in.strokeColors[n7]);
                for (int i = 0; i < n - 1; ++i) {
                    int n8 = n7 + i + 1;
                    linePath.lineTo(this.in.vertices[3 * n8 + 0], this.in.vertices[3 * n8 + 1], this.in.strokeColors[n8]);
                }
                linePath.closePath();
                this.tessellateLinePath(linePath);
            }
        }

        void tessellateEdges() {
            if (this.stroke) {
                if (this.in.edgeCount == 0) {
                    return;
                }
                if (this.is3D) {
                    this.tessellateEdges3D();
                } else if (this.is2D) {
                    this.beginNoTex();
                    this.tessellateEdges2D();
                    this.endNoTex();
                }
            }
        }

        void tessellateEdges3D() {
            int n;
            boolean bl = !this.noCapsJoins();
            int n2 = this.in.getNumEdgeVertices(bl);
            int n3 = this.in.getNumEdgeIndices(bl);
            this.tess.lineVertexCheck(n2);
            this.tess.lineIndexCheck(n3);
            this.firstLineIndexCache = n = this.in.renderMode == 1 ? this.tess.lineIndexCache.addNew() : this.tess.lineIndexCache.getLast();
            short[] sArray = new short[]{-1, -1};
            for (int i = this.in.firstEdge; i <= this.in.lastEdge; ++i) {
                int[] nArray = this.in.edges[i];
                int n4 = nArray[0];
                int n5 = nArray[1];
                if (bl) {
                    n = this.addLine3D(n4, n5, n, sArray, false);
                    if (nArray[2] != 2 && nArray[2] != 3) continue;
                    sArray[1] = -1;
                    sArray[0] = -1;
                    continue;
                }
                n = this.addLine3D(n4, n5, n, null, false);
            }
            this.lastLineIndexCache = n;
        }

        void tessellateEdges2D() {
            int n = this.in.getNumEdgeVertices(false);
            if (this.noCapsJoins(n)) {
                int n2;
                int n3 = this.in.getNumEdgeIndices(false);
                this.tess.polyVertexCheck(n);
                this.tess.polyIndexCheck(n3);
                this.firstLineIndexCache = n2 = this.in.renderMode == 1 ? this.tess.polyIndexCache.addNew() : this.tess.polyIndexCache.getLast();
                if (this.firstPolyIndexCache == -1) {
                    this.firstPolyIndexCache = n2;
                }
                for (int i = this.in.firstEdge; i <= this.in.lastEdge; ++i) {
                    int[] nArray = this.in.edges[i];
                    int n4 = nArray[0];
                    int n5 = nArray[1];
                    n2 = this.addLine2D(n4, n5, n2, false);
                }
                this.lastLineIndexCache = this.lastPolyIndexCache = n2;
            } else {
                LinePath linePath = new LinePath(1);
                block7: for (int i = this.in.firstEdge; i <= this.in.lastEdge; ++i) {
                    int[] nArray = this.in.edges[i];
                    int n6 = nArray[0];
                    int n7 = nArray[1];
                    switch (nArray[2]) {
                        case 0: {
                            linePath.lineTo(this.in.vertices[3 * n7 + 0], this.in.vertices[3 * n7 + 1], this.in.strokeColors[n7]);
                            continue block7;
                        }
                        case 1: {
                            linePath.moveTo(this.in.vertices[3 * n6 + 0], this.in.vertices[3 * n6 + 1], this.in.strokeColors[n6]);
                            linePath.lineTo(this.in.vertices[3 * n7 + 0], this.in.vertices[3 * n7 + 1], this.in.strokeColors[n7]);
                            continue block7;
                        }
                        case 2: {
                            linePath.lineTo(this.in.vertices[3 * n7 + 0], this.in.vertices[3 * n7 + 1], this.in.strokeColors[n7]);
                            linePath.moveTo(this.in.vertices[3 * n7 + 0], this.in.vertices[3 * n7 + 1], this.in.strokeColors[n7]);
                            continue block7;
                        }
                        case 3: {
                            linePath.moveTo(this.in.vertices[3 * n6 + 0], this.in.vertices[3 * n6 + 1], this.in.strokeColors[n6]);
                            linePath.lineTo(this.in.vertices[3 * n7 + 0], this.in.vertices[3 * n7 + 1], this.in.strokeColors[n7]);
                            linePath.moveTo(this.in.vertices[3 * n7 + 0], this.in.vertices[3 * n7 + 1], this.in.strokeColors[n7]);
                        }
                    }
                }
                this.tessellateLinePath(linePath);
            }
        }

        int addLine3D(int n, int n2, int n3, short[] sArray, boolean bl) {
            IndexCache indexCache = this.tess.lineIndexCache;
            int n4 = indexCache.vertexCount[n3];
            boolean bl2 = sArray != null && -1 < sArray[0] && -1 < sArray[1];
            boolean bl3 = false;
            if (32768 <= n4 + 4 + (bl2 ? 1 : 0)) {
                n3 = indexCache.addNew();
                n4 = 0;
                bl3 = true;
            }
            int n5 = indexCache.indexOffset[n3] + indexCache.indexCount[n3];
            int n6 = indexCache.vertexOffset[n3] + indexCache.vertexCount[n3];
            int n7 = bl ? this.strokeColor : this.in.strokeColors[n];
            int n8 = n7;
            float f = bl ? this.strokeWeight : this.in.strokeWeights[n];
            this.tess.setLineVertex(n6++, this.in, n, n2, n7, f / 2.0f);
            this.tess.lineIndices[n5++] = (short)(n4 + 0);
            this.tess.setLineVertex(n6++, this.in, n, n2, n7, -f / 2.0f);
            this.tess.lineIndices[n5++] = (short)(n4 + 1);
            n7 = bl ? this.strokeColor : this.in.strokeColors[n2];
            f = bl ? this.strokeWeight : this.in.strokeWeights[n2];
            this.tess.setLineVertex(n6++, this.in, n2, n, n7, -f / 2.0f);
            this.tess.lineIndices[n5++] = (short)(n4 + 2);
            this.tess.lineIndices[n5++] = (short)(n4 + 2);
            this.tess.lineIndices[n5++] = (short)(n4 + 1);
            this.tess.setLineVertex(n6++, this.in, n2, n, n7, f / 2.0f);
            this.tess.lineIndices[n5++] = (short)(n4 + 3);
            indexCache.incCounts(n3, 6, 4);
            if (sArray != null) {
                if (-1 < sArray[0] && -1 < sArray[1]) {
                    this.tess.setLineVertex(n6, this.in, n, n8);
                    if (bl3) {
                        PGraphics.showWarning(PGraphicsOpenGL.TOO_LONG_STROKE_PATH_ERROR);
                        this.tess.lineIndices[n5++] = (short)(n4 + 4);
                        this.tess.lineIndices[n5++] = (short)(n4 + 0);
                        this.tess.lineIndices[n5++] = (short)(n4 + 0);
                        this.tess.lineIndices[n5++] = (short)(n4 + 4);
                        this.tess.lineIndices[n5++] = (short)(n4 + 1);
                        this.tess.lineIndices[n5] = (short)(n4 + 1);
                    } else {
                        this.tess.lineIndices[n5++] = (short)(n4 + 4);
                        this.tess.lineIndices[n5++] = sArray[0];
                        this.tess.lineIndices[n5++] = (short)(n4 + 0);
                        this.tess.lineIndices[n5++] = (short)(n4 + 4);
                        this.tess.lineIndices[n5++] = sArray[1];
                        this.tess.lineIndices[n5] = (short)(n4 + 1);
                    }
                    indexCache.incCounts(n3, 6, 1);
                }
                sArray[0] = (short)(n4 + 2);
                sArray[1] = (short)(n4 + 3);
            }
            return n3;
        }

        int addLine2D(int n, int n2, int n3, boolean bl) {
            IndexCache indexCache = this.tess.polyIndexCache;
            int n4 = indexCache.vertexCount[n3];
            if (32768 <= n4 + 4) {
                n3 = indexCache.addNew();
                n4 = 0;
            }
            int n5 = indexCache.indexOffset[n3] + indexCache.indexCount[n3];
            int n6 = indexCache.vertexOffset[n3] + indexCache.vertexCount[n3];
            int n7 = bl ? this.strokeColor : this.in.strokeColors[n];
            float f = bl ? this.strokeWeight : this.in.strokeWeights[n];
            float f2 = this.in.vertices[3 * n + 0];
            float f3 = this.in.vertices[3 * n + 1];
            float f4 = this.in.vertices[3 * n2 + 0];
            float f5 = this.in.vertices[3 * n2 + 1];
            float f6 = f4 - f2;
            float f7 = f5 - f3;
            float f8 = PApplet.sqrt(f6 * f6 + f7 * f7);
            float f9 = 0.0f;
            float f10 = 0.0f;
            if (PGraphicsOpenGL.nonZero(f8)) {
                f9 = -f7 / f8;
                f10 = f6 / f8;
            }
            this.tess.setPolyVertex(n6++, f2 + f9 * f / 2.0f, f3 + f10 * f / 2.0f, 0.0f, n7);
            this.tess.polyIndices[n5++] = (short)(n4 + 0);
            this.tess.setPolyVertex(n6++, f2 - f9 * f / 2.0f, f3 - f10 * f / 2.0f, 0.0f, n7);
            this.tess.polyIndices[n5++] = (short)(n4 + 1);
            if (!bl) {
                n7 = this.in.strokeColors[n2];
                f = this.in.strokeWeights[n2];
            }
            this.tess.setPolyVertex(n6++, f4 - f9 * f / 2.0f, f5 - f10 * f / 2.0f, 0.0f, n7);
            this.tess.polyIndices[n5++] = (short)(n4 + 2);
            this.tess.polyIndices[n5++] = (short)(n4 + 2);
            this.tess.polyIndices[n5++] = (short)(n4 + 0);
            this.tess.setPolyVertex(n6++, f4 + f9 * f / 2.0f, f5 + f10 * f / 2.0f, 0.0f, n7);
            this.tess.polyIndices[n5++] = (short)(n4 + 3);
            indexCache.incCounts(n3, 6, 4);
            return n3;
        }

        boolean noCapsJoins(int n) {
            if (!this.accurate2DStrokes) {
                return true;
            }
            if (1000 <= n) {
                return true;
            }
            return this.noCapsJoins();
        }

        boolean noCapsJoins() {
            float f = 1.0f;
            if (this.transform != null) {
                if (this.transform instanceof PMatrix2D) {
                    PMatrix2D pMatrix2D = (PMatrix2D)this.transform;
                    float f2 = Math.abs(pMatrix2D.m00 * pMatrix2D.m11 - pMatrix2D.m01 * pMatrix2D.m10);
                    f = (float)Math.sqrt(f2);
                } else if (this.transform instanceof PMatrix3D) {
                    PMatrix3D pMatrix3D = (PMatrix3D)this.transform;
                    float f3 = Math.abs(pMatrix3D.m00 * (pMatrix3D.m11 * pMatrix3D.m22 - pMatrix3D.m12 * pMatrix3D.m21) + pMatrix3D.m01 * (pMatrix3D.m12 * pMatrix3D.m20 - pMatrix3D.m10 * pMatrix3D.m22) + pMatrix3D.m02 * (pMatrix3D.m10 * pMatrix3D.m21 - pMatrix3D.m11 * pMatrix3D.m20));
                    f = (float)Math.pow(f3, 0.3333333432674408);
                }
            }
            return f * this.strokeWeight < 2.0f;
        }

        void tessellateTriangles() {
            this.beginTex();
            int n = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.fill && 3 <= n) {
                int n2 = n;
                this.setRawSize(n2);
                int n3 = 0;
                int n4 = this.in.firstVertex;
                while (n4 <= this.in.lastVertex) {
                    this.rawIndices[n3++] = n4++;
                }
                this.splitRawIndices();
            }
            this.endTex();
            this.tessellateEdges();
        }

        void tessellateTriangles(int[] nArray) {
            this.beginTex();
            int n = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.fill && 3 <= n) {
                int n2 = nArray.length;
                this.setRawSize(n2);
                PApplet.arrayCopy(nArray, this.rawIndices, n2);
                this.splitRawIndices();
            }
            this.endTex();
            this.tessellateEdges();
        }

        void tessellateTriangleFan() {
            this.beginTex();
            int n = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.fill && 3 <= n) {
                int n2 = 3 * (n - 2);
                this.setRawSize(n2);
                int n3 = 0;
                for (int i = this.in.firstVertex + 1; i < this.in.lastVertex; ++i) {
                    this.rawIndices[n3++] = this.in.firstVertex;
                    this.rawIndices[n3++] = i;
                    this.rawIndices[n3++] = i + 1;
                }
                this.splitRawIndices();
            }
            this.endTex();
            this.tessellateEdges();
        }

        void tessellateTriangleStrip() {
            this.beginTex();
            int n = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.fill && 3 <= n) {
                int n2 = 3 * (n - 2);
                this.setRawSize(n2);
                int n3 = 0;
                for (int i = this.in.firstVertex + 1; i < this.in.lastVertex; ++i) {
                    this.rawIndices[n3++] = i;
                    if (i % 2 == 0) {
                        this.rawIndices[n3++] = i - 1;
                        this.rawIndices[n3++] = i + 1;
                        continue;
                    }
                    this.rawIndices[n3++] = i + 1;
                    this.rawIndices[n3++] = i - 1;
                }
                this.splitRawIndices();
            }
            this.endTex();
            this.tessellateEdges();
        }

        void tessellateQuads() {
            this.beginTex();
            int n = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.fill && 4 <= n) {
                int n2 = n / 4;
                int n3 = 6 * n2;
                this.setRawSize(n3);
                int n4 = 0;
                for (int i = 0; i < n2; ++i) {
                    int n5 = this.in.firstVertex + 4 * i + 0;
                    int n6 = this.in.firstVertex + 4 * i + 1;
                    int n7 = this.in.firstVertex + 4 * i + 2;
                    int n8 = this.in.firstVertex + 4 * i + 3;
                    this.rawIndices[n4++] = n5;
                    this.rawIndices[n4++] = n6;
                    this.rawIndices[n4++] = n7;
                    this.rawIndices[n4++] = n7;
                    this.rawIndices[n4++] = n8;
                    this.rawIndices[n4++] = n5;
                }
                this.splitRawIndices();
            }
            this.endTex();
            this.tessellateEdges();
        }

        void tessellateQuadStrip() {
            this.beginTex();
            int n = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.fill && 4 <= n) {
                int n2 = n / 2 - 1;
                int n3 = 6 * n2;
                this.setRawSize(n3);
                int n4 = 0;
                for (int i = 1; i < n / 2; ++i) {
                    int n5 = this.in.firstVertex + 2 * (i - 1);
                    int n6 = this.in.firstVertex + 2 * (i - 1) + 1;
                    int n7 = this.in.firstVertex + 2 * i + 1;
                    int n8 = this.in.firstVertex + 2 * i;
                    this.rawIndices[n4++] = n5;
                    this.rawIndices[n4++] = n6;
                    this.rawIndices[n4++] = n8;
                    this.rawIndices[n4++] = n6;
                    this.rawIndices[n4++] = n7;
                    this.rawIndices[n4++] = n8;
                }
                this.splitRawIndices();
            }
            this.endTex();
            this.tessellateEdges();
        }

        void splitRawIndices() {
            int n;
            this.tess.polyIndexCheck(this.rawSize);
            int n2 = this.tess.firstPolyIndex;
            int n3 = 0;
            int n4 = 0;
            int n5 = this.in.firstVertex;
            int n6 = this.in.firstVertex;
            int n7 = n5;
            int n8 = -1;
            this.dupCount = 0;
            IndexCache indexCache = this.tess.polyIndexCache;
            this.firstPolyIndexCache = n = this.in.renderMode == 1 ? indexCache.addNew() : indexCache.getLast();
            int n9 = this.rawSize / 3;
            for (int i = 0; i < n9; ++i) {
                int n10;
                int n11;
                int n12;
                if (n == -1) {
                    n = indexCache.addNew();
                }
                int n13 = this.rawIndices[3 * i + 0];
                int n14 = this.rawIndices[3 * i + 1];
                int n15 = this.rawIndices[3 * i + 2];
                int n16 = n13 - n7;
                int n17 = n14 - n7;
                int n18 = n15 - n7;
                int n19 = indexCache.vertexCount[n];
                if (n16 < 0) {
                    this.addDupIndex(n16);
                    n12 = n16;
                } else {
                    n12 = n19 + n16;
                }
                if (n17 < 0) {
                    this.addDupIndex(n17);
                    n11 = n17;
                } else {
                    n11 = n19 + n17;
                }
                if (n18 < 0) {
                    this.addDupIndex(n18);
                    n10 = n18;
                } else {
                    n10 = n19 + n18;
                }
                this.tess.polyIndices[n2 + 3 * i + 0] = (short)n12;
                this.tess.polyIndices[n2 + 3 * i + 1] = (short)n11;
                this.tess.polyIndices[n2 + 3 * i + 2] = (short)n10;
                n4 = 3 * i + 2;
                n6 = PApplet.max(n6, PApplet.max(n13, n14, n15));
                n5 = PApplet.min(n5, PApplet.min(n13, n14, n15));
                n8 = PApplet.max(n8, PApplet.max(n12, n11, n10));
                if ((32765 > n8 + this.dupCount || n8 + this.dupCount >= 32768) && i != n9 - 1) continue;
                int n20 = 0;
                if (0 < this.dupCount) {
                    int n21;
                    for (n21 = n3; n21 <= n4; ++n21) {
                        short s = this.tess.polyIndices[n2 + n21];
                        if (s >= 0) continue;
                        this.tess.polyIndices[n2 + n21] = (short)(n8 + 1 + this.dupIndexPos(s));
                    }
                    if (n7 <= n6) {
                        this.tess.addPolyVertices(this.in, n7, n6);
                        n20 = n6 - n7 + 1;
                    }
                    for (n21 = 0; n21 < this.dupCount; ++n21) {
                        this.tess.addPolyVertex(this.in, this.dupIndices[n21] + n7);
                    }
                } else {
                    this.tess.addPolyVertices(this.in, n5, n6);
                    n20 = n6 - n5 + 1;
                }
                indexCache.incCounts(n, n4 - n3 + 1, n20 + this.dupCount);
                this.lastPolyIndexCache = n;
                n = -1;
                n8 = -1;
                n5 = n7 = n6 + 1;
                n3 = n4 + 1;
                if (this.dupIndices != null) {
                    Arrays.fill(this.dupIndices, 0, this.dupCount, 0);
                }
                this.dupCount = 0;
            }
        }

        void addDupIndex(int n) {
            int n2;
            if (this.dupIndices == null) {
                this.dupIndices = new int[16];
            }
            if (this.dupIndices.length == this.dupCount) {
                n2 = this.dupCount << 1;
                int[] nArray = new int[n2];
                PApplet.arrayCopy(this.dupIndices, 0, nArray, 0, this.dupCount);
                this.dupIndices = nArray;
            }
            if (n < this.dupIndices[0]) {
                for (n2 = this.dupCount; n2 > 0; --n2) {
                    this.dupIndices[n2] = this.dupIndices[n2 - 1];
                }
                this.dupIndices[0] = n;
                ++this.dupCount;
            } else if (this.dupIndices[this.dupCount - 1] < n) {
                this.dupIndices[this.dupCount] = n;
                ++this.dupCount;
            } else {
                for (n2 = 0; n2 < this.dupCount - 1 && this.dupIndices[n2] != n; ++n2) {
                    if (this.dupIndices[n2] >= n || n >= this.dupIndices[n2 + 1]) continue;
                    for (int i = this.dupCount; i > n2 + 1; --i) {
                        this.dupIndices[i] = this.dupIndices[i - 1];
                    }
                    this.dupIndices[n2 + 1] = n;
                    ++this.dupCount;
                    break;
                }
            }
        }

        int dupIndexPos(int n) {
            for (int i = 0; i < this.dupCount; ++i) {
                if (this.dupIndices[i] != n) continue;
                return i;
            }
            return 0;
        }

        void setRawSize(int n) {
            int n2 = this.rawIndices.length;
            if (n2 < n) {
                int n3 = PGraphicsOpenGL.expandArraySize(n2, n);
                this.expandRawIndices(n3);
            }
            this.rawSize = n;
        }

        void expandRawIndices(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.rawIndices, 0, nArray, 0, this.rawSize);
            this.rawIndices = nArray;
        }

        void beginTex() {
            this.setFirstTexIndex(this.tess.polyIndexCount, this.tess.polyIndexCache.size - 1);
        }

        void endTex() {
            this.setLastTexIndex(this.tess.lastPolyIndex, this.tess.polyIndexCache.size - 1);
        }

        void beginNoTex() {
            this.prevTexImage = this.newTexImage;
            this.newTexImage = null;
            this.setFirstTexIndex(this.tess.polyIndexCount, this.tess.polyIndexCache.size - 1);
        }

        void endNoTex() {
            this.setLastTexIndex(this.tess.lastPolyIndex, this.tess.polyIndexCache.size - 1);
        }

        void updateTex() {
            this.beginTex();
            this.endTex();
        }

        void setFirstTexIndex(int n, int n2) {
            if (this.texCache != null) {
                this.firstTexIndex = n;
                this.firstTexCache = PApplet.max(0, n2);
            }
        }

        void setLastTexIndex(int n, int n2) {
            if (this.texCache != null) {
                if (this.prevTexImage != this.newTexImage || this.texCache.size == 0) {
                    this.texCache.addTexture(this.newTexImage, this.firstTexIndex, this.firstTexCache, n, n2);
                } else {
                    this.texCache.setLastIndex(n, n2);
                }
            }
        }

        void tessellatePolygon(boolean bl, boolean bl2, boolean bl3) {
            this.beginTex();
            int n = this.in.lastVertex - this.in.firstVertex + 1;
            if (this.fill && 3 <= n) {
                this.firstPolyIndexCache = -1;
                this.callback.init(this.in.renderMode == 1, false, bl3);
                this.gluTess.beginPolygon();
                if (bl) {
                    this.gluTess.setWindingRule(100131);
                } else {
                    this.gluTess.setWindingRule(100130);
                }
                this.gluTess.beginContour();
                for (int i = this.in.firstVertex; i <= this.in.lastVertex; ++i) {
                    boolean bl4 = this.in.breaks[i];
                    if (bl4) {
                        this.gluTess.endContour();
                        this.gluTess.beginContour();
                    }
                    int n2 = this.in.colors[i] >> 24 & 0xFF;
                    int n3 = this.in.colors[i] >> 16 & 0xFF;
                    int n4 = this.in.colors[i] >> 8 & 0xFF;
                    int n5 = this.in.colors[i] >> 0 & 0xFF;
                    int n6 = this.in.ambient[i] >> 24 & 0xFF;
                    int n7 = this.in.ambient[i] >> 16 & 0xFF;
                    int n8 = this.in.ambient[i] >> 8 & 0xFF;
                    int n9 = this.in.ambient[i] >> 0 & 0xFF;
                    int n10 = this.in.specular[i] >> 24 & 0xFF;
                    int n11 = this.in.specular[i] >> 16 & 0xFF;
                    int n12 = this.in.specular[i] >> 8 & 0xFF;
                    int n13 = this.in.specular[i] >> 0 & 0xFF;
                    int n14 = this.in.emissive[i] >> 24 & 0xFF;
                    int n15 = this.in.emissive[i] >> 16 & 0xFF;
                    int n16 = this.in.emissive[i] >> 8 & 0xFF;
                    int n17 = this.in.emissive[i] >> 0 & 0xFF;
                    double[] dArray = new double[]{this.in.vertices[3 * i + 0], this.in.vertices[3 * i + 1], this.in.vertices[3 * i + 2], n2, n3, n4, n5, this.in.normals[3 * i + 0], this.in.normals[3 * i + 1], this.in.normals[3 * i + 2], this.in.texcoords[2 * i + 0], this.in.texcoords[2 * i + 1], n6, n7, n8, n9, n10, n11, n12, n13, n14, n15, n16, n17, this.in.shininess[i]};
                    this.gluTess.addVertex(dArray);
                }
                this.gluTess.endContour();
                this.gluTess.endPolygon();
            }
            this.endTex();
            this.tessellateEdges();
        }

        public void tessellateLinePath(LinePath linePath) {
            int n;
            this.callback.init(this.in.renderMode == 1, true, false);
            int n2 = this.strokeCap == 2 ? 1 : (n = this.strokeCap == 4 ? 2 : 0);
            int n3 = this.strokeJoin == 2 ? 1 : (this.strokeJoin == 32 ? 2 : 0);
            LinePath linePath2 = LinePath.createStrokedPath(linePath, this.strokeWeight, n, n3);
            this.gluTess.beginPolygon();
            float[] fArray = new float[6];
            LinePath.PathIterator pathIterator = linePath2.getPathIterator();
            int n4 = pathIterator.getWindingRule();
            switch (n4) {
                case 0: {
                    this.gluTess.setWindingRule(100130);
                    break;
                }
                case 1: {
                    this.gluTess.setWindingRule(100131);
                }
            }
            while (!pathIterator.isDone()) {
                switch (pathIterator.currentSegment(fArray)) {
                    case 0: {
                        this.gluTess.beginContour();
                    }
                    case 1: {
                        double[] dArray = new double[]{fArray[0], fArray[1], 0.0, fArray[2], fArray[3], fArray[4], fArray[5], 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
                        this.gluTess.addVertex(dArray);
                        break;
                    }
                    case 2: {
                        this.gluTess.endContour();
                    }
                }
                pathIterator.next();
            }
            this.gluTess.endPolygon();
        }

        protected class TessellatorCallback
        implements PGL.TessellatorCallback {
            boolean calcNormals;
            boolean strokeTess;
            IndexCache cache;
            int cacheIndex;
            int vertFirst;
            int vertCount;
            int primitive;

            protected TessellatorCallback() {
            }

            public void init(boolean bl, boolean bl2, boolean bl3) {
                this.strokeTess = bl2;
                this.calcNormals = bl3;
                this.cache = Tessellator.this.tess.polyIndexCache;
                if (bl) {
                    this.cache.addNew();
                }
            }

            @Override
            public void begin(int n) {
                this.cacheIndex = this.cache.getLast();
                if (Tessellator.this.firstPolyIndexCache == -1) {
                    Tessellator.this.firstPolyIndexCache = this.cacheIndex;
                }
                if (this.strokeTess && Tessellator.this.firstLineIndexCache == -1) {
                    Tessellator.this.firstLineIndexCache = this.cacheIndex;
                }
                this.vertFirst = this.cache.vertexCount[this.cacheIndex];
                this.vertCount = 0;
                switch (n) {
                    case 6: {
                        this.primitive = 11;
                        break;
                    }
                    case 5: {
                        this.primitive = 10;
                        break;
                    }
                    case 4: {
                        this.primitive = 9;
                    }
                }
            }

            @Override
            public void end() {
                if (32768 <= this.vertFirst + this.vertCount) {
                    this.cacheIndex = this.cache.addNew();
                    this.vertFirst = 0;
                }
                int n = 0;
                switch (this.primitive) {
                    case 11: {
                        n = 3 * (this.vertCount - 2);
                        for (int i = 1; i < this.vertCount - 1; ++i) {
                            this.addIndex(0);
                            this.addIndex(i);
                            this.addIndex(i + 1);
                            if (!this.calcNormals) continue;
                            this.calcTriNormal(0, i, i + 1);
                        }
                        break;
                    }
                    case 10: {
                        n = 3 * (this.vertCount - 2);
                        for (int i = 1; i < this.vertCount - 1; ++i) {
                            if (i % 2 == 0) {
                                this.addIndex(i + 1);
                                this.addIndex(i);
                                this.addIndex(i - 1);
                                if (!this.calcNormals) continue;
                                this.calcTriNormal(i + 1, i, i - 1);
                                continue;
                            }
                            this.addIndex(i - 1);
                            this.addIndex(i);
                            this.addIndex(i + 1);
                            if (!this.calcNormals) continue;
                            this.calcTriNormal(i - 1, i, i + 1);
                        }
                        break;
                    }
                    case 9: {
                        int n2;
                        n = this.vertCount;
                        for (n2 = 0; n2 < this.vertCount; ++n2) {
                            this.addIndex(n2);
                        }
                        if (!this.calcNormals) break;
                        for (n2 = 0; n2 < this.vertCount / 3; ++n2) {
                            int n3 = 3 * n2 + 0;
                            int n4 = 3 * n2 + 1;
                            int n5 = 3 * n2 + 2;
                            this.calcTriNormal(n3, n4, n5);
                        }
                        break;
                    }
                }
                this.cache.incCounts(this.cacheIndex, n, this.vertCount);
                Tessellator.this.lastPolyIndexCache = this.cacheIndex;
                if (this.strokeTess) {
                    Tessellator.this.lastLineIndexCache = this.cacheIndex;
                }
            }

            protected void addIndex(int n) {
                Tessellator.this.tess.polyIndexCheck();
                Tessellator.this.tess.polyIndices[Tessellator.this.tess.polyIndexCount - 1] = (short)(this.vertFirst + n);
            }

            protected void calcTriNormal(int n, int n2, int n3) {
                Tessellator.this.tess.calcPolyNormal(this.vertFirst + n, this.vertFirst + n2, this.vertFirst + n3);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void vertex(Object object) {
                if (!(object instanceof double[])) throw new RuntimeException("TessCallback vertex() data not understood");
                double[] dArray = (double[])object;
                int n = dArray.length;
                if (n < 25) {
                    throw new RuntimeException("TessCallback vertex() data is not of length 25");
                }
                if (this.vertCount >= 32768) throw new RuntimeException("The tessellator is generating too many vertices, reduce complexity of shape.");
                int n2 = (int)dArray[3] << 24 | (int)dArray[4] << 16 | (int)dArray[5] << 8 | (int)dArray[6];
                int n3 = (int)dArray[12] << 24 | (int)dArray[13] << 16 | (int)dArray[14] << 8 | (int)dArray[15];
                int n4 = (int)dArray[16] << 24 | (int)dArray[17] << 16 | (int)dArray[18] << 8 | (int)dArray[19];
                int n5 = (int)dArray[20] << 24 | (int)dArray[21] << 16 | (int)dArray[22] << 8 | (int)dArray[23];
                Tessellator.this.tess.addPolyVertex((float)dArray[0], (float)dArray[1], (float)dArray[2], n2, (float)dArray[7], (float)dArray[8], (float)dArray[9], (float)dArray[10], (float)dArray[11], n3, n4, n5, (float)dArray[24]);
                ++this.vertCount;
            }

            @Override
            public void error(int n) {
                String string = PGraphicsOpenGL.this.pgl.tessError(n);
                PGraphics.showWarning(PGraphicsOpenGL.TESSELLATION_ERROR, string);
            }

            @Override
            public void combine(double[] dArray, Object[] objectArray, float[] fArray, Object[] objectArray2) {
                double[] dArray2 = new double[33];
                dArray2[0] = dArray[0];
                dArray2[1] = dArray[1];
                dArray2[2] = dArray[2];
                for (int i = 3; i < 25; ++i) {
                    dArray2[i] = 0.0;
                    for (int j = 0; j < 4; ++j) {
                        double[] dArray3 = (double[])objectArray[j];
                        if (dArray3 == null) continue;
                        int n = i;
                        dArray2[n] = dArray2[n] + (double)fArray[j] * dArray3[i];
                    }
                }
                double d = dArray2[7] * dArray2[7] + dArray2[8] * dArray2[8] + dArray2[9] * dArray2[9];
                double d2 = Math.sqrt(d);
                dArray2[7] = dArray2[7] / d2;
                dArray2[8] = dArray2[8] / d2;
                dArray2[9] = dArray2[9] / d2;
                objectArray2[0] = dArray2;
            }
        }
    }

    protected class TessGeometry {
        int renderMode;
        int polyVertexCount;
        int firstPolyVertex;
        int lastPolyVertex;
        FloatBuffer polyVerticesBuffer;
        IntBuffer polyColorsBuffer;
        FloatBuffer polyNormalsBuffer;
        FloatBuffer polyTexCoordsBuffer;
        IntBuffer polyAmbientBuffer;
        IntBuffer polySpecularBuffer;
        IntBuffer polyEmissiveBuffer;
        FloatBuffer polyShininessBuffer;
        int polyIndexCount;
        int firstPolyIndex;
        int lastPolyIndex;
        ShortBuffer polyIndicesBuffer;
        IndexCache polyIndexCache;
        int lineVertexCount;
        int firstLineVertex;
        int lastLineVertex;
        FloatBuffer lineVerticesBuffer;
        IntBuffer lineColorsBuffer;
        FloatBuffer lineDirectionsBuffer;
        int lineIndexCount;
        int firstLineIndex;
        int lastLineIndex;
        ShortBuffer lineIndicesBuffer;
        IndexCache lineIndexCache;
        int pointVertexCount;
        int firstPointVertex;
        int lastPointVertex;
        FloatBuffer pointVerticesBuffer;
        IntBuffer pointColorsBuffer;
        FloatBuffer pointOffsetsBuffer;
        int pointIndexCount;
        int firstPointIndex;
        int lastPointIndex;
        ShortBuffer pointIndicesBuffer;
        IndexCache pointIndexCache;
        float[] polyVertices;
        int[] polyColors;
        float[] polyNormals;
        float[] polyTexCoords;
        int[] polyAmbient;
        int[] polySpecular;
        int[] polyEmissive;
        float[] polyShininess;
        short[] polyIndices;
        float[] lineVertices;
        int[] lineColors;
        float[] lineDirections;
        short[] lineIndices;
        float[] pointVertices;
        int[] pointColors;
        float[] pointOffsets;
        short[] pointIndices;

        TessGeometry(int n) {
            this.polyIndexCache = new IndexCache();
            this.lineIndexCache = new IndexCache();
            this.pointIndexCache = new IndexCache();
            this.renderMode = n;
            this.allocate();
        }

        void allocate() {
            this.polyVertices = new float[64];
            this.polyColors = new int[16];
            this.polyNormals = new float[48];
            this.polyTexCoords = new float[32];
            this.polyAmbient = new int[16];
            this.polySpecular = new int[16];
            this.polyEmissive = new int[16];
            this.polyShininess = new float[16];
            this.polyIndices = new short[16];
            this.lineVertices = new float[64];
            this.lineColors = new int[16];
            this.lineDirections = new float[64];
            this.lineIndices = new short[16];
            this.pointVertices = new float[64];
            this.pointColors = new int[16];
            this.pointOffsets = new float[32];
            this.pointIndices = new short[16];
            this.polyVerticesBuffer = PGL.allocateFloatBuffer(this.polyVertices);
            this.polyColorsBuffer = PGL.allocateIntBuffer(this.polyColors);
            this.polyNormalsBuffer = PGL.allocateFloatBuffer(this.polyNormals);
            this.polyTexCoordsBuffer = PGL.allocateFloatBuffer(this.polyTexCoords);
            this.polyAmbientBuffer = PGL.allocateIntBuffer(this.polyAmbient);
            this.polySpecularBuffer = PGL.allocateIntBuffer(this.polySpecular);
            this.polyEmissiveBuffer = PGL.allocateIntBuffer(this.polyEmissive);
            this.polyShininessBuffer = PGL.allocateFloatBuffer(this.polyShininess);
            this.polyIndicesBuffer = PGL.allocateShortBuffer(this.polyIndices);
            this.lineVerticesBuffer = PGL.allocateFloatBuffer(this.lineVertices);
            this.lineColorsBuffer = PGL.allocateIntBuffer(this.lineColors);
            this.lineDirectionsBuffer = PGL.allocateFloatBuffer(this.lineDirections);
            this.lineIndicesBuffer = PGL.allocateShortBuffer(this.lineIndices);
            this.pointVerticesBuffer = PGL.allocateFloatBuffer(this.pointVertices);
            this.pointColorsBuffer = PGL.allocateIntBuffer(this.pointColors);
            this.pointOffsetsBuffer = PGL.allocateFloatBuffer(this.pointOffsets);
            this.pointIndicesBuffer = PGL.allocateShortBuffer(this.pointIndices);
            this.clear();
        }

        void clear() {
            this.polyVertexCount = 0;
            this.lastPolyVertex = 0;
            this.firstPolyVertex = 0;
            this.polyIndexCount = 0;
            this.lastPolyIndex = 0;
            this.firstPolyIndex = 0;
            this.lineVertexCount = 0;
            this.lastLineVertex = 0;
            this.firstLineVertex = 0;
            this.lineIndexCount = 0;
            this.lastLineIndex = 0;
            this.firstLineIndex = 0;
            this.pointVertexCount = 0;
            this.lastPointVertex = 0;
            this.firstPointVertex = 0;
            this.pointIndexCount = 0;
            this.lastPointIndex = 0;
            this.firstPointIndex = 0;
            this.polyIndexCache.clear();
            this.lineIndexCache.clear();
            this.pointIndexCache.clear();
        }

        void polyVertexCheck() {
            if (this.polyVertexCount == this.polyVertices.length / 4) {
                int n = this.polyVertexCount << 1;
                this.expandPolyVertices(n);
                this.expandPolyColors(n);
                this.expandPolyNormals(n);
                this.expandPolyTexCoords(n);
                this.expandPolyAmbient(n);
                this.expandPolySpecular(n);
                this.expandPolyEmissive(n);
                this.expandPolyShininess(n);
            }
            this.firstPolyVertex = this.polyVertexCount++;
            this.lastPolyVertex = this.polyVertexCount - 1;
        }

        void polyVertexCheck(int n) {
            int n2 = this.polyVertices.length / 4;
            if (this.polyVertexCount + n > n2) {
                int n3 = PGraphicsOpenGL.expandArraySize(n2, this.polyVertexCount + n);
                this.expandPolyVertices(n3);
                this.expandPolyColors(n3);
                this.expandPolyNormals(n3);
                this.expandPolyTexCoords(n3);
                this.expandPolyAmbient(n3);
                this.expandPolySpecular(n3);
                this.expandPolyEmissive(n3);
                this.expandPolyShininess(n3);
            }
            this.firstPolyVertex = this.polyVertexCount;
            this.polyVertexCount += n;
            this.lastPolyVertex = this.polyVertexCount - 1;
        }

        void polyIndexCheck(int n) {
            int n2 = this.polyIndices.length;
            if (this.polyIndexCount + n > n2) {
                int n3 = PGraphicsOpenGL.expandArraySize(n2, this.polyIndexCount + n);
                this.expandPolyIndices(n3);
            }
            this.firstPolyIndex = this.polyIndexCount;
            this.polyIndexCount += n;
            this.lastPolyIndex = this.polyIndexCount - 1;
        }

        void polyIndexCheck() {
            if (this.polyIndexCount == this.polyIndices.length) {
                int n = this.polyIndexCount << 1;
                this.expandPolyIndices(n);
            }
            this.firstPolyIndex = this.polyIndexCount++;
            this.lastPolyIndex = this.polyIndexCount - 1;
        }

        void lineVertexCheck(int n) {
            int n2 = this.lineVertices.length / 4;
            if (this.lineVertexCount + n > n2) {
                int n3 = PGraphicsOpenGL.expandArraySize(n2, this.lineVertexCount + n);
                this.expandLineVertices(n3);
                this.expandLineColors(n3);
                this.expandLineDirections(n3);
            }
            this.firstLineVertex = this.lineVertexCount;
            this.lineVertexCount += n;
            this.lastLineVertex = this.lineVertexCount - 1;
        }

        void lineIndexCheck(int n) {
            int n2 = this.lineIndices.length;
            if (this.lineIndexCount + n > n2) {
                int n3 = PGraphicsOpenGL.expandArraySize(n2, this.lineIndexCount + n);
                this.expandLineIndices(n3);
            }
            this.firstLineIndex = this.lineIndexCount;
            this.lineIndexCount += n;
            this.lastLineIndex = this.lineIndexCount - 1;
        }

        void pointVertexCheck(int n) {
            int n2 = this.pointVertices.length / 4;
            if (this.pointVertexCount + n > n2) {
                int n3 = PGraphicsOpenGL.expandArraySize(n2, this.pointVertexCount + n);
                this.expandPointVertices(n3);
                this.expandPointColors(n3);
                this.expandPointOffsets(n3);
            }
            this.firstPointVertex = this.pointVertexCount;
            this.pointVertexCount += n;
            this.lastPointVertex = this.pointVertexCount - 1;
        }

        void pointIndexCheck(int n) {
            int n2 = this.pointIndices.length;
            if (this.pointIndexCount + n > n2) {
                int n3 = PGraphicsOpenGL.expandArraySize(n2, this.pointIndexCount + n);
                this.expandPointIndices(n3);
            }
            this.firstPointIndex = this.pointIndexCount;
            this.pointIndexCount += n;
            this.lastPointIndex = this.pointIndexCount - 1;
        }

        boolean isFull() {
            return 32768 <= this.polyVertexCount || 32768 <= this.lineVertexCount || 32768 <= this.pointVertexCount;
        }

        void getPolyVertexMin(PVector pVector, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                int n3 = 4 * i;
                pVector.x = PApplet.min(pVector.x, this.polyVertices[n3++]);
                pVector.y = PApplet.min(pVector.y, this.polyVertices[n3++]);
                pVector.z = PApplet.min(pVector.z, this.polyVertices[n3]);
            }
        }

        void getLineVertexMin(PVector pVector, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                int n3 = 4 * i;
                pVector.x = PApplet.min(pVector.x, this.lineVertices[n3++]);
                pVector.y = PApplet.min(pVector.y, this.lineVertices[n3++]);
                pVector.z = PApplet.min(pVector.z, this.lineVertices[n3]);
            }
        }

        void getPointVertexMin(PVector pVector, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                int n3 = 4 * i;
                pVector.x = PApplet.min(pVector.x, this.pointVertices[n3++]);
                pVector.y = PApplet.min(pVector.y, this.pointVertices[n3++]);
                pVector.z = PApplet.min(pVector.z, this.pointVertices[n3]);
            }
        }

        void getPolyVertexMax(PVector pVector, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                int n3 = 4 * i;
                pVector.x = PApplet.max(pVector.x, this.polyVertices[n3++]);
                pVector.y = PApplet.max(pVector.y, this.polyVertices[n3++]);
                pVector.z = PApplet.max(pVector.z, this.polyVertices[n3]);
            }
        }

        void getLineVertexMax(PVector pVector, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                int n3 = 4 * i;
                pVector.x = PApplet.max(pVector.x, this.lineVertices[n3++]);
                pVector.y = PApplet.max(pVector.y, this.lineVertices[n3++]);
                pVector.z = PApplet.max(pVector.z, this.lineVertices[n3]);
            }
        }

        void getPointVertexMax(PVector pVector, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                int n3 = 4 * i;
                pVector.x = PApplet.max(pVector.x, this.pointVertices[n3++]);
                pVector.y = PApplet.max(pVector.y, this.pointVertices[n3++]);
                pVector.z = PApplet.max(pVector.z, this.pointVertices[n3]);
            }
        }

        int getPolyVertexSum(PVector pVector, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                int n3 = 4 * i;
                pVector.x += this.polyVertices[n3++];
                pVector.y += this.polyVertices[n3++];
                pVector.z += this.polyVertices[n3];
            }
            return n2 - n + 1;
        }

        int getLineVertexSum(PVector pVector, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                int n3 = 4 * i;
                pVector.x += this.lineVertices[n3++];
                pVector.y += this.lineVertices[n3++];
                pVector.z += this.lineVertices[n3];
            }
            return n2 - n + 1;
        }

        int getPointVertexSum(PVector pVector, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                int n3 = 4 * i;
                pVector.x += this.pointVertices[n3++];
                pVector.y += this.pointVertices[n3++];
                pVector.z += this.pointVertices[n3];
            }
            return n2 - n + 1;
        }

        protected void updatePolyVerticesBuffer() {
            this.updatePolyVerticesBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyVerticesBuffer(int n, int n2) {
            PGL.updateFloatBuffer(this.polyVerticesBuffer, this.polyVertices, 4 * n, 4 * n2);
        }

        protected void updatePolyColorsBuffer() {
            this.updatePolyColorsBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyColorsBuffer(int n, int n2) {
            PGL.updateIntBuffer(this.polyColorsBuffer, this.polyColors, n, n2);
        }

        protected void updatePolyNormalsBuffer() {
            this.updatePolyNormalsBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyNormalsBuffer(int n, int n2) {
            PGL.updateFloatBuffer(this.polyNormalsBuffer, this.polyNormals, 3 * n, 3 * n2);
        }

        protected void updatePolyTexCoordsBuffer() {
            this.updatePolyTexCoordsBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyTexCoordsBuffer(int n, int n2) {
            PGL.updateFloatBuffer(this.polyTexCoordsBuffer, this.polyTexCoords, 2 * n, 2 * n2);
        }

        protected void updatePolyAmbientBuffer() {
            this.updatePolyAmbientBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyAmbientBuffer(int n, int n2) {
            PGL.updateIntBuffer(this.polyAmbientBuffer, this.polyAmbient, n, n2);
        }

        protected void updatePolySpecularBuffer() {
            this.updatePolySpecularBuffer(0, this.polyVertexCount);
        }

        protected void updatePolySpecularBuffer(int n, int n2) {
            PGL.updateIntBuffer(this.polySpecularBuffer, this.polySpecular, n, n2);
        }

        protected void updatePolyEmissiveBuffer() {
            this.updatePolyEmissiveBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyEmissiveBuffer(int n, int n2) {
            PGL.updateIntBuffer(this.polyEmissiveBuffer, this.polyEmissive, n, n2);
        }

        protected void updatePolyShininessBuffer() {
            this.updatePolyShininessBuffer(0, this.polyVertexCount);
        }

        protected void updatePolyShininessBuffer(int n, int n2) {
            PGL.updateFloatBuffer(this.polyShininessBuffer, this.polyShininess, n, n2);
        }

        protected void updatePolyIndicesBuffer() {
            this.updatePolyIndicesBuffer(0, this.polyIndexCount);
        }

        protected void updatePolyIndicesBuffer(int n, int n2) {
            PGL.updateShortBuffer(this.polyIndicesBuffer, this.polyIndices, n, n2);
        }

        protected void updateLineVerticesBuffer() {
            this.updateLineVerticesBuffer(0, this.lineVertexCount);
        }

        protected void updateLineVerticesBuffer(int n, int n2) {
            PGL.updateFloatBuffer(this.lineVerticesBuffer, this.lineVertices, 4 * n, 4 * n2);
        }

        protected void updateLineColorsBuffer() {
            this.updateLineColorsBuffer(0, this.lineVertexCount);
        }

        protected void updateLineColorsBuffer(int n, int n2) {
            PGL.updateIntBuffer(this.lineColorsBuffer, this.lineColors, n, n2);
        }

        protected void updateLineDirectionsBuffer() {
            this.updateLineDirectionsBuffer(0, this.lineVertexCount);
        }

        protected void updateLineDirectionsBuffer(int n, int n2) {
            PGL.updateFloatBuffer(this.lineDirectionsBuffer, this.lineDirections, 4 * n, 4 * n2);
        }

        protected void updateLineIndicesBuffer() {
            this.updateLineIndicesBuffer(0, this.lineIndexCount);
        }

        protected void updateLineIndicesBuffer(int n, int n2) {
            PGL.updateShortBuffer(this.lineIndicesBuffer, this.lineIndices, n, n2);
        }

        protected void updatePointVerticesBuffer() {
            this.updatePointVerticesBuffer(0, this.pointVertexCount);
        }

        protected void updatePointVerticesBuffer(int n, int n2) {
            PGL.updateFloatBuffer(this.pointVerticesBuffer, this.pointVertices, 4 * n, 4 * n2);
        }

        protected void updatePointColorsBuffer() {
            this.updatePointColorsBuffer(0, this.pointVertexCount);
        }

        protected void updatePointColorsBuffer(int n, int n2) {
            PGL.updateIntBuffer(this.pointColorsBuffer, this.pointColors, n, n2);
        }

        protected void updatePointOffsetsBuffer() {
            this.updatePointOffsetsBuffer(0, this.pointVertexCount);
        }

        protected void updatePointOffsetsBuffer(int n, int n2) {
            PGL.updateFloatBuffer(this.pointOffsetsBuffer, this.pointOffsets, 2 * n, 2 * n2);
        }

        protected void updatePointIndicesBuffer() {
            this.updatePointIndicesBuffer(0, this.pointIndexCount);
        }

        protected void updatePointIndicesBuffer(int n, int n2) {
            PGL.updateShortBuffer(this.pointIndicesBuffer, this.pointIndices, n, n2);
        }

        void expandPolyVertices(int n) {
            float[] fArray = new float[4 * n];
            PApplet.arrayCopy(this.polyVertices, 0, fArray, 0, 4 * this.polyVertexCount);
            this.polyVertices = fArray;
            this.polyVerticesBuffer = PGL.allocateFloatBuffer(this.polyVertices);
        }

        void expandPolyColors(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.polyColors, 0, nArray, 0, this.polyVertexCount);
            this.polyColors = nArray;
            this.polyColorsBuffer = PGL.allocateIntBuffer(this.polyColors);
        }

        void expandPolyNormals(int n) {
            float[] fArray = new float[3 * n];
            PApplet.arrayCopy(this.polyNormals, 0, fArray, 0, 3 * this.polyVertexCount);
            this.polyNormals = fArray;
            this.polyNormalsBuffer = PGL.allocateFloatBuffer(this.polyNormals);
        }

        void expandPolyTexCoords(int n) {
            float[] fArray = new float[2 * n];
            PApplet.arrayCopy(this.polyTexCoords, 0, fArray, 0, 2 * this.polyVertexCount);
            this.polyTexCoords = fArray;
            this.polyTexCoordsBuffer = PGL.allocateFloatBuffer(this.polyTexCoords);
        }

        void expandPolyAmbient(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.polyAmbient, 0, nArray, 0, this.polyVertexCount);
            this.polyAmbient = nArray;
            this.polyAmbientBuffer = PGL.allocateIntBuffer(this.polyAmbient);
        }

        void expandPolySpecular(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.polySpecular, 0, nArray, 0, this.polyVertexCount);
            this.polySpecular = nArray;
            this.polySpecularBuffer = PGL.allocateIntBuffer(this.polySpecular);
        }

        void expandPolyEmissive(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.polyEmissive, 0, nArray, 0, this.polyVertexCount);
            this.polyEmissive = nArray;
            this.polyEmissiveBuffer = PGL.allocateIntBuffer(this.polyEmissive);
        }

        void expandPolyShininess(int n) {
            float[] fArray = new float[n];
            PApplet.arrayCopy(this.polyShininess, 0, fArray, 0, this.polyVertexCount);
            this.polyShininess = fArray;
            this.polyShininessBuffer = PGL.allocateFloatBuffer(this.polyShininess);
        }

        void expandPolyIndices(int n) {
            short[] sArray = new short[n];
            PApplet.arrayCopy(this.polyIndices, 0, sArray, 0, this.polyIndexCount);
            this.polyIndices = sArray;
            this.polyIndicesBuffer = PGL.allocateShortBuffer(this.polyIndices);
        }

        void expandLineVertices(int n) {
            float[] fArray = new float[4 * n];
            PApplet.arrayCopy(this.lineVertices, 0, fArray, 0, 4 * this.lineVertexCount);
            this.lineVertices = fArray;
            this.lineVerticesBuffer = PGL.allocateFloatBuffer(this.lineVertices);
        }

        void expandLineColors(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.lineColors, 0, nArray, 0, this.lineVertexCount);
            this.lineColors = nArray;
            this.lineColorsBuffer = PGL.allocateIntBuffer(this.lineColors);
        }

        void expandLineDirections(int n) {
            float[] fArray = new float[4 * n];
            PApplet.arrayCopy(this.lineDirections, 0, fArray, 0, 4 * this.lineVertexCount);
            this.lineDirections = fArray;
            this.lineDirectionsBuffer = PGL.allocateFloatBuffer(this.lineDirections);
        }

        void expandLineIndices(int n) {
            short[] sArray = new short[n];
            PApplet.arrayCopy(this.lineIndices, 0, sArray, 0, this.lineIndexCount);
            this.lineIndices = sArray;
            this.lineIndicesBuffer = PGL.allocateShortBuffer(this.lineIndices);
        }

        void expandPointVertices(int n) {
            float[] fArray = new float[4 * n];
            PApplet.arrayCopy(this.pointVertices, 0, fArray, 0, 4 * this.pointVertexCount);
            this.pointVertices = fArray;
            this.pointVerticesBuffer = PGL.allocateFloatBuffer(this.pointVertices);
        }

        void expandPointColors(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.pointColors, 0, nArray, 0, this.pointVertexCount);
            this.pointColors = nArray;
            this.pointColorsBuffer = PGL.allocateIntBuffer(this.pointColors);
        }

        void expandPointOffsets(int n) {
            float[] fArray = new float[2 * n];
            PApplet.arrayCopy(this.pointOffsets, 0, fArray, 0, 2 * this.pointVertexCount);
            this.pointOffsets = fArray;
            this.pointOffsetsBuffer = PGL.allocateFloatBuffer(this.pointOffsets);
        }

        void expandPointIndices(int n) {
            short[] sArray = new short[n];
            PApplet.arrayCopy(this.pointIndices, 0, sArray, 0, this.pointIndexCount);
            this.pointIndices = sArray;
            this.pointIndicesBuffer = PGL.allocateShortBuffer(this.pointIndices);
        }

        void trim() {
            if (0 < this.polyVertexCount && this.polyVertexCount < this.polyVertices.length / 4) {
                this.trimPolyVertices();
                this.trimPolyColors();
                this.trimPolyNormals();
                this.trimPolyTexCoords();
                this.trimPolyAmbient();
                this.trimPolySpecular();
                this.trimPolyEmissive();
                this.trimPolyShininess();
            }
            if (0 < this.polyIndexCount && this.polyIndexCount < this.polyIndices.length) {
                this.trimPolyIndices();
            }
            if (0 < this.lineVertexCount && this.lineVertexCount < this.lineVertices.length / 4) {
                this.trimLineVertices();
                this.trimLineColors();
                this.trimLineDirections();
            }
            if (0 < this.lineIndexCount && this.lineIndexCount < this.lineIndices.length) {
                this.trimLineIndices();
            }
            if (0 < this.pointVertexCount && this.pointVertexCount < this.pointVertices.length / 4) {
                this.trimPointVertices();
                this.trimPointColors();
                this.trimPointOffsets();
            }
            if (0 < this.pointIndexCount && this.pointIndexCount < this.pointIndices.length) {
                this.trimPointIndices();
            }
        }

        void trimPolyVertices() {
            float[] fArray = new float[4 * this.polyVertexCount];
            PApplet.arrayCopy(this.polyVertices, 0, fArray, 0, 4 * this.polyVertexCount);
            this.polyVertices = fArray;
            this.polyVerticesBuffer = PGL.allocateFloatBuffer(this.polyVertices);
        }

        void trimPolyColors() {
            int[] nArray = new int[this.polyVertexCount];
            PApplet.arrayCopy(this.polyColors, 0, nArray, 0, this.polyVertexCount);
            this.polyColors = nArray;
            this.polyColorsBuffer = PGL.allocateIntBuffer(this.polyColors);
        }

        void trimPolyNormals() {
            float[] fArray = new float[3 * this.polyVertexCount];
            PApplet.arrayCopy(this.polyNormals, 0, fArray, 0, 3 * this.polyVertexCount);
            this.polyNormals = fArray;
            this.polyNormalsBuffer = PGL.allocateFloatBuffer(this.polyNormals);
        }

        void trimPolyTexCoords() {
            float[] fArray = new float[2 * this.polyVertexCount];
            PApplet.arrayCopy(this.polyTexCoords, 0, fArray, 0, 2 * this.polyVertexCount);
            this.polyTexCoords = fArray;
            this.polyTexCoordsBuffer = PGL.allocateFloatBuffer(this.polyTexCoords);
        }

        void trimPolyAmbient() {
            int[] nArray = new int[this.polyVertexCount];
            PApplet.arrayCopy(this.polyAmbient, 0, nArray, 0, this.polyVertexCount);
            this.polyAmbient = nArray;
            this.polyAmbientBuffer = PGL.allocateIntBuffer(this.polyAmbient);
        }

        void trimPolySpecular() {
            int[] nArray = new int[this.polyVertexCount];
            PApplet.arrayCopy(this.polySpecular, 0, nArray, 0, this.polyVertexCount);
            this.polySpecular = nArray;
            this.polySpecularBuffer = PGL.allocateIntBuffer(this.polySpecular);
        }

        void trimPolyEmissive() {
            int[] nArray = new int[this.polyVertexCount];
            PApplet.arrayCopy(this.polyEmissive, 0, nArray, 0, this.polyVertexCount);
            this.polyEmissive = nArray;
            this.polyEmissiveBuffer = PGL.allocateIntBuffer(this.polyEmissive);
        }

        void trimPolyShininess() {
            float[] fArray = new float[this.polyVertexCount];
            PApplet.arrayCopy(this.polyShininess, 0, fArray, 0, this.polyVertexCount);
            this.polyShininess = fArray;
            this.polyShininessBuffer = PGL.allocateFloatBuffer(this.polyShininess);
        }

        void trimPolyIndices() {
            short[] sArray = new short[this.polyIndexCount];
            PApplet.arrayCopy(this.polyIndices, 0, sArray, 0, this.polyIndexCount);
            this.polyIndices = sArray;
            this.polyIndicesBuffer = PGL.allocateShortBuffer(this.polyIndices);
        }

        void trimLineVertices() {
            float[] fArray = new float[4 * this.lineVertexCount];
            PApplet.arrayCopy(this.lineVertices, 0, fArray, 0, 4 * this.lineVertexCount);
            this.lineVertices = fArray;
            this.lineVerticesBuffer = PGL.allocateFloatBuffer(this.lineVertices);
        }

        void trimLineColors() {
            int[] nArray = new int[this.lineVertexCount];
            PApplet.arrayCopy(this.lineColors, 0, nArray, 0, this.lineVertexCount);
            this.lineColors = nArray;
            this.lineColorsBuffer = PGL.allocateIntBuffer(this.lineColors);
        }

        void trimLineDirections() {
            float[] fArray = new float[4 * this.lineVertexCount];
            PApplet.arrayCopy(this.lineDirections, 0, fArray, 0, 4 * this.lineVertexCount);
            this.lineDirections = fArray;
            this.lineDirectionsBuffer = PGL.allocateFloatBuffer(this.lineDirections);
        }

        void trimLineIndices() {
            short[] sArray = new short[this.lineIndexCount];
            PApplet.arrayCopy(this.lineIndices, 0, sArray, 0, this.lineIndexCount);
            this.lineIndices = sArray;
            this.lineIndicesBuffer = PGL.allocateShortBuffer(this.lineIndices);
        }

        void trimPointVertices() {
            float[] fArray = new float[4 * this.pointVertexCount];
            PApplet.arrayCopy(this.pointVertices, 0, fArray, 0, 4 * this.pointVertexCount);
            this.pointVertices = fArray;
            this.pointVerticesBuffer = PGL.allocateFloatBuffer(this.pointVertices);
        }

        void trimPointColors() {
            int[] nArray = new int[this.pointVertexCount];
            PApplet.arrayCopy(this.pointColors, 0, nArray, 0, this.pointVertexCount);
            this.pointColors = nArray;
            this.pointColorsBuffer = PGL.allocateIntBuffer(this.pointColors);
        }

        void trimPointOffsets() {
            float[] fArray = new float[2 * this.pointVertexCount];
            PApplet.arrayCopy(this.pointOffsets, 0, fArray, 0, 2 * this.pointVertexCount);
            this.pointOffsets = fArray;
            this.pointOffsetsBuffer = PGL.allocateFloatBuffer(this.pointOffsets);
        }

        void trimPointIndices() {
            short[] sArray = new short[this.pointIndexCount];
            PApplet.arrayCopy(this.pointIndices, 0, sArray, 0, this.pointIndexCount);
            this.pointIndices = sArray;
            this.pointIndicesBuffer = PGL.allocateShortBuffer(this.pointIndices);
        }

        void incPolyIndices(int n, int n2, int n3) {
            int n4 = n;
            while (n4 <= n2) {
                int n5 = n4++;
                this.polyIndices[n5] = (short)(this.polyIndices[n5] + n3);
            }
        }

        void incLineIndices(int n, int n2, int n3) {
            int n4 = n;
            while (n4 <= n2) {
                int n5 = n4++;
                this.lineIndices[n5] = (short)(this.lineIndices[n5] + n3);
            }
        }

        void incPointIndices(int n, int n2, int n3) {
            int n4 = n;
            while (n4 <= n2) {
                int n5 = n4++;
                this.pointIndices[n5] = (short)(this.pointIndices[n5] + n3);
            }
        }

        void calcPolyNormal(int n, int n2, int n3) {
            int n4 = 4 * n;
            float f = this.polyVertices[n4++];
            float f2 = this.polyVertices[n4++];
            float f3 = this.polyVertices[n4];
            n4 = 4 * n2;
            float f4 = this.polyVertices[n4++];
            float f5 = this.polyVertices[n4++];
            float f6 = this.polyVertices[n4];
            n4 = 4 * n3;
            float f7 = this.polyVertices[n4++];
            float f8 = this.polyVertices[n4++];
            float f9 = this.polyVertices[n4];
            float f10 = f7 - f4;
            float f11 = f8 - f5;
            float f12 = f9 - f6;
            float f13 = f - f4;
            float f14 = f2 - f5;
            float f15 = f3 - f6;
            float f16 = f11 * f15 - f14 * f12;
            float f17 = f12 * f13 - f15 * f10;
            float f18 = f10 * f14 - f13 * f11;
            float f19 = PApplet.sqrt(f16 * f16 + f17 * f17 + f18 * f18);
            n4 = 3 * n;
            this.polyNormals[n4++] = f16 /= f19;
            this.polyNormals[n4++] = f17 /= f19;
            this.polyNormals[n4] = f18 /= f19;
            n4 = 3 * n2;
            this.polyNormals[n4++] = f16;
            this.polyNormals[n4++] = f17;
            this.polyNormals[n4] = f18;
            n4 = 3 * n3;
            this.polyNormals[n4++] = f16;
            this.polyNormals[n4++] = f17;
            this.polyNormals[n4] = f18;
        }

        void setPointVertex(int n, InGeometry inGeometry, int n2) {
            int n3 = 3 * n2;
            float f = inGeometry.vertices[n3++];
            float f2 = inGeometry.vertices[n3++];
            float f3 = inGeometry.vertices[n3];
            if (this.renderMode == 0 && PGraphicsOpenGL.this.flushMode == 1) {
                PMatrix3D pMatrix3D = PGraphicsOpenGL.this.modelview;
                n3 = 4 * n;
                this.pointVertices[n3++] = f * pMatrix3D.m00 + f2 * pMatrix3D.m01 + f3 * pMatrix3D.m02 + pMatrix3D.m03;
                this.pointVertices[n3++] = f * pMatrix3D.m10 + f2 * pMatrix3D.m11 + f3 * pMatrix3D.m12 + pMatrix3D.m13;
                this.pointVertices[n3++] = f * pMatrix3D.m20 + f2 * pMatrix3D.m21 + f3 * pMatrix3D.m22 + pMatrix3D.m23;
                this.pointVertices[n3] = f * pMatrix3D.m30 + f2 * pMatrix3D.m31 + f3 * pMatrix3D.m32 + pMatrix3D.m33;
            } else {
                n3 = 4 * n;
                this.pointVertices[n3++] = f;
                this.pointVertices[n3++] = f2;
                this.pointVertices[n3++] = f3;
                this.pointVertices[n3] = 1.0f;
            }
            this.pointColors[n] = inGeometry.strokeColors[n2];
        }

        void setLineVertex(int n, InGeometry inGeometry, int n2, int n3) {
            int n4 = 3 * n2;
            float f = inGeometry.vertices[n4++];
            float f2 = inGeometry.vertices[n4++];
            float f3 = inGeometry.vertices[n4];
            if (this.renderMode == 0 && PGraphicsOpenGL.this.flushMode == 1) {
                PMatrix3D pMatrix3D = PGraphicsOpenGL.this.modelview;
                n4 = 4 * n;
                this.lineVertices[n4++] = f * pMatrix3D.m00 + f2 * pMatrix3D.m01 + f3 * pMatrix3D.m02 + pMatrix3D.m03;
                this.lineVertices[n4++] = f * pMatrix3D.m10 + f2 * pMatrix3D.m11 + f3 * pMatrix3D.m12 + pMatrix3D.m13;
                this.lineVertices[n4++] = f * pMatrix3D.m20 + f2 * pMatrix3D.m21 + f3 * pMatrix3D.m22 + pMatrix3D.m23;
                this.lineVertices[n4] = f * pMatrix3D.m30 + f2 * pMatrix3D.m31 + f3 * pMatrix3D.m32 + pMatrix3D.m33;
            } else {
                n4 = 4 * n;
                this.lineVertices[n4++] = f;
                this.lineVertices[n4++] = f2;
                this.lineVertices[n4++] = f3;
                this.lineVertices[n4] = 1.0f;
            }
            this.lineColors[n] = n3;
            n4 = 4 * n;
            this.lineDirections[n4++] = 0.0f;
            this.lineDirections[n4++] = 0.0f;
            this.lineDirections[n4++] = 0.0f;
            this.lineDirections[n4] = 0.0f;
        }

        void setLineVertex(int n, InGeometry inGeometry, int n2, int n3, int n4, float f) {
            int n5 = 3 * n2;
            float f2 = inGeometry.vertices[n5++];
            float f3 = inGeometry.vertices[n5++];
            float f4 = inGeometry.vertices[n5];
            n5 = 3 * n3;
            float f5 = inGeometry.vertices[n5++];
            float f6 = inGeometry.vertices[n5++];
            float f7 = inGeometry.vertices[n5];
            float f8 = f5 - f2;
            float f9 = f6 - f3;
            float f10 = f7 - f4;
            if (this.renderMode == 0 && PGraphicsOpenGL.this.flushMode == 1) {
                PMatrix3D pMatrix3D = PGraphicsOpenGL.this.modelview;
                n5 = 4 * n;
                this.lineVertices[n5++] = f2 * pMatrix3D.m00 + f3 * pMatrix3D.m01 + f4 * pMatrix3D.m02 + pMatrix3D.m03;
                this.lineVertices[n5++] = f2 * pMatrix3D.m10 + f3 * pMatrix3D.m11 + f4 * pMatrix3D.m12 + pMatrix3D.m13;
                this.lineVertices[n5++] = f2 * pMatrix3D.m20 + f3 * pMatrix3D.m21 + f4 * pMatrix3D.m22 + pMatrix3D.m23;
                this.lineVertices[n5] = f2 * pMatrix3D.m30 + f3 * pMatrix3D.m31 + f4 * pMatrix3D.m32 + pMatrix3D.m33;
                n5 = 4 * n;
                this.lineDirections[n5++] = f8 * pMatrix3D.m00 + f9 * pMatrix3D.m01 + f10 * pMatrix3D.m02;
                this.lineDirections[n5++] = f8 * pMatrix3D.m10 + f9 * pMatrix3D.m11 + f10 * pMatrix3D.m12;
                this.lineDirections[n5] = f8 * pMatrix3D.m20 + f9 * pMatrix3D.m21 + f10 * pMatrix3D.m22;
            } else {
                n5 = 4 * n;
                this.lineVertices[n5++] = f2;
                this.lineVertices[n5++] = f3;
                this.lineVertices[n5++] = f4;
                this.lineVertices[n5] = 1.0f;
                n5 = 4 * n;
                this.lineDirections[n5++] = f8;
                this.lineDirections[n5++] = f9;
                this.lineDirections[n5] = f10;
            }
            this.lineColors[n] = n4;
            this.lineDirections[4 * n + 3] = f;
        }

        void addPolyVertex(float f, float f2, float f3, int n, float f4, float f5, float f6, float f7, float f8, int n2, int n3, int n4, float f9) {
            this.polyVertexCheck();
            int n5 = this.polyVertexCount - 1;
            this.setPolyVertex(n5, f, f2, f3, n, f4, f5, f6, f7, f8, n2, n3, n4, f9);
        }

        void setPolyVertex(int n, float f, float f2, float f3, int n2) {
            this.setPolyVertex(n, f, f2, f3, n2, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0, 0, 0, 0.0f);
        }

        void setPolyVertex(int n, float f, float f2, float f3, int n2, float f4, float f5, float f6, float f7, float f8, int n3, int n4, int n5, float f9) {
            int n6;
            if (this.renderMode == 0 && PGraphicsOpenGL.this.flushMode == 1) {
                PMatrix3D pMatrix3D = PGraphicsOpenGL.this.modelview;
                PMatrix3D pMatrix3D2 = PGraphicsOpenGL.this.modelviewInv;
                n6 = 4 * n;
                this.polyVertices[n6++] = f * pMatrix3D.m00 + f2 * pMatrix3D.m01 + f3 * pMatrix3D.m02 + pMatrix3D.m03;
                this.polyVertices[n6++] = f * pMatrix3D.m10 + f2 * pMatrix3D.m11 + f3 * pMatrix3D.m12 + pMatrix3D.m13;
                this.polyVertices[n6++] = f * pMatrix3D.m20 + f2 * pMatrix3D.m21 + f3 * pMatrix3D.m22 + pMatrix3D.m23;
                this.polyVertices[n6] = f * pMatrix3D.m30 + f2 * pMatrix3D.m31 + f3 * pMatrix3D.m32 + pMatrix3D.m33;
                n6 = 3 * n;
                this.polyNormals[n6++] = f4 * pMatrix3D2.m00 + f5 * pMatrix3D2.m10 + f6 * pMatrix3D2.m20;
                this.polyNormals[n6++] = f4 * pMatrix3D2.m01 + f5 * pMatrix3D2.m11 + f6 * pMatrix3D2.m21;
                this.polyNormals[n6] = f4 * pMatrix3D2.m02 + f5 * pMatrix3D2.m12 + f6 * pMatrix3D2.m22;
            } else {
                n6 = 4 * n;
                this.polyVertices[n6++] = f;
                this.polyVertices[n6++] = f2;
                this.polyVertices[n6++] = f3;
                this.polyVertices[n6] = 1.0f;
                n6 = 3 * n;
                this.polyNormals[n6++] = f4;
                this.polyNormals[n6++] = f5;
                this.polyNormals[n6] = f6;
            }
            this.polyColors[n] = n2;
            n6 = 2 * n;
            this.polyTexCoords[n6++] = f7;
            this.polyTexCoords[n6] = f8;
            this.polyAmbient[n] = n3;
            this.polySpecular[n] = n4;
            this.polyEmissive[n] = n5;
            this.polyShininess[n] = f9;
        }

        void addPolyVertices(InGeometry inGeometry) {
            this.addPolyVertices(inGeometry, inGeometry.firstVertex, inGeometry.lastVertex);
        }

        void addPolyVertex(InGeometry inGeometry, int n) {
            this.addPolyVertices(inGeometry, n, n);
        }

        void addPolyVertices(InGeometry inGeometry, int n, int n2) {
            float f;
            float f2;
            float f3;
            float f4;
            int n3;
            int n4;
            int n5 = n2 - n + 1;
            this.polyVertexCheck(n5);
            if (this.renderMode == 0 && PGraphicsOpenGL.this.flushMode == 1) {
                PMatrix3D pMatrix3D = PGraphicsOpenGL.this.modelview;
                PMatrix3D pMatrix3D2 = PGraphicsOpenGL.this.modelviewInv;
                for (n4 = 0; n4 < n5; ++n4) {
                    int n6 = n + n4;
                    int n7 = this.firstPolyVertex + n4;
                    n3 = 3 * n6;
                    f4 = inGeometry.vertices[n3++];
                    f3 = inGeometry.vertices[n3++];
                    f2 = inGeometry.vertices[n3];
                    n3 = 3 * n6;
                    f = inGeometry.normals[n3++];
                    float f5 = inGeometry.normals[n3++];
                    float f6 = inGeometry.normals[n3];
                    n3 = 4 * n7;
                    this.polyVertices[n3++] = f4 * pMatrix3D.m00 + f3 * pMatrix3D.m01 + f2 * pMatrix3D.m02 + pMatrix3D.m03;
                    this.polyVertices[n3++] = f4 * pMatrix3D.m10 + f3 * pMatrix3D.m11 + f2 * pMatrix3D.m12 + pMatrix3D.m13;
                    this.polyVertices[n3++] = f4 * pMatrix3D.m20 + f3 * pMatrix3D.m21 + f2 * pMatrix3D.m22 + pMatrix3D.m23;
                    this.polyVertices[n3] = f4 * pMatrix3D.m30 + f3 * pMatrix3D.m31 + f2 * pMatrix3D.m32 + pMatrix3D.m33;
                    n3 = 3 * n7;
                    this.polyNormals[n3++] = f * pMatrix3D2.m00 + f5 * pMatrix3D2.m10 + f6 * pMatrix3D2.m20;
                    this.polyNormals[n3++] = f * pMatrix3D2.m01 + f5 * pMatrix3D2.m11 + f6 * pMatrix3D2.m21;
                    this.polyNormals[n3] = f * pMatrix3D2.m02 + f5 * pMatrix3D2.m12 + f6 * pMatrix3D2.m22;
                }
            } else if (n5 <= 2) {
                for (int i = 0; i < n5; ++i) {
                    int n8 = n + i;
                    n4 = this.firstPolyVertex + i;
                    n3 = 3 * n8;
                    float f7 = inGeometry.vertices[n3++];
                    float f8 = inGeometry.vertices[n3++];
                    f4 = inGeometry.vertices[n3];
                    n3 = 3 * n8;
                    f3 = inGeometry.normals[n3++];
                    f2 = inGeometry.normals[n3++];
                    f = inGeometry.normals[n3];
                    n3 = 4 * n4;
                    this.polyVertices[n3++] = f7;
                    this.polyVertices[n3++] = f8;
                    this.polyVertices[n3++] = f4;
                    this.polyVertices[n3] = 1.0f;
                    n3 = 3 * n4;
                    this.polyNormals[n3++] = f3;
                    this.polyNormals[n3++] = f2;
                    this.polyNormals[n3] = f;
                }
            } else {
                for (int i = 0; i < n5; ++i) {
                    int n9 = n + i;
                    n4 = this.firstPolyVertex + i;
                    PApplet.arrayCopy(inGeometry.vertices, 3 * n9, this.polyVertices, 4 * n4, 3);
                    this.polyVertices[4 * n4 + 3] = 1.0f;
                }
                PApplet.arrayCopy(inGeometry.normals, 3 * n, this.polyNormals, 3 * this.firstPolyVertex, 3 * n5);
            }
            if (n5 <= 2) {
                for (int i = 0; i < n5; ++i) {
                    int n10 = n + i;
                    n4 = this.firstPolyVertex + i;
                    n3 = 2 * n10;
                    float f9 = inGeometry.texcoords[n3++];
                    float f10 = inGeometry.texcoords[n3];
                    this.polyColors[n4] = inGeometry.colors[n10];
                    n3 = 2 * n4;
                    this.polyTexCoords[n3++] = f9;
                    this.polyTexCoords[n3] = f10;
                    this.polyAmbient[n4] = inGeometry.ambient[n10];
                    this.polySpecular[n4] = inGeometry.specular[n10];
                    this.polyEmissive[n4] = inGeometry.emissive[n10];
                    this.polyShininess[n4] = inGeometry.shininess[n10];
                }
            } else {
                PApplet.arrayCopy(inGeometry.colors, n, this.polyColors, this.firstPolyVertex, n5);
                PApplet.arrayCopy(inGeometry.texcoords, 2 * n, this.polyTexCoords, 2 * this.firstPolyVertex, 2 * n5);
                PApplet.arrayCopy(inGeometry.ambient, n, this.polyAmbient, this.firstPolyVertex, n5);
                PApplet.arrayCopy(inGeometry.specular, n, this.polySpecular, this.firstPolyVertex, n5);
                PApplet.arrayCopy(inGeometry.emissive, n, this.polyEmissive, this.firstPolyVertex, n5);
                PApplet.arrayCopy(inGeometry.shininess, n, this.polyShininess, this.firstPolyVertex, n5);
            }
        }

        void applyMatrixOnPolyGeometry(PMatrix pMatrix, int n, int n2) {
            if (pMatrix instanceof PMatrix2D) {
                this.applyMatrixOnPolyGeometry((PMatrix2D)pMatrix, n, n2);
            } else if (pMatrix instanceof PMatrix3D) {
                this.applyMatrixOnPolyGeometry((PMatrix3D)pMatrix, n, n2);
            }
        }

        void applyMatrixOnLineGeometry(PMatrix pMatrix, int n, int n2) {
            if (pMatrix instanceof PMatrix2D) {
                this.applyMatrixOnLineGeometry((PMatrix2D)pMatrix, n, n2);
            } else if (pMatrix instanceof PMatrix3D) {
                this.applyMatrixOnLineGeometry((PMatrix3D)pMatrix, n, n2);
            }
        }

        void applyMatrixOnPointGeometry(PMatrix pMatrix, int n, int n2) {
            if (pMatrix instanceof PMatrix2D) {
                this.applyMatrixOnPointGeometry((PMatrix2D)pMatrix, n, n2);
            } else if (pMatrix instanceof PMatrix3D) {
                this.applyMatrixOnPointGeometry((PMatrix3D)pMatrix, n, n2);
            }
        }

        void applyMatrixOnPolyGeometry(PMatrix2D pMatrix2D, int n, int n2) {
            if (n < n2) {
                for (int i = n; i <= n2; ++i) {
                    int n3 = 4 * i;
                    float f = this.polyVertices[n3++];
                    float f2 = this.polyVertices[n3];
                    n3 = 3 * i;
                    float f3 = this.polyNormals[n3++];
                    float f4 = this.polyNormals[n3];
                    n3 = 4 * i;
                    this.polyVertices[n3++] = f * pMatrix2D.m00 + f2 * pMatrix2D.m01 + pMatrix2D.m02;
                    this.polyVertices[n3] = f * pMatrix2D.m10 + f2 * pMatrix2D.m11 + pMatrix2D.m12;
                    n3 = 3 * i;
                    this.polyNormals[n3++] = f3 * pMatrix2D.m00 + f4 * pMatrix2D.m01;
                    this.polyNormals[n3] = f3 * pMatrix2D.m10 + f4 * pMatrix2D.m11;
                }
            }
        }

        void applyMatrixOnLineGeometry(PMatrix2D pMatrix2D, int n, int n2) {
            if (n < n2) {
                for (int i = n; i <= n2; ++i) {
                    int n3 = 4 * i;
                    float f = this.lineVertices[n3++];
                    float f2 = this.lineVertices[n3];
                    n3 = 4 * i;
                    float f3 = this.lineDirections[n3++];
                    float f4 = this.lineDirections[n3];
                    float f5 = f3 - f;
                    float f6 = f4 - f2;
                    n3 = 4 * i;
                    this.lineVertices[n3++] = f * pMatrix2D.m00 + f2 * pMatrix2D.m01 + pMatrix2D.m02;
                    this.lineVertices[n3] = f * pMatrix2D.m10 + f2 * pMatrix2D.m11 + pMatrix2D.m12;
                    n3 = 4 * i;
                    this.lineDirections[n3++] = f5 * pMatrix2D.m00 + f6 * pMatrix2D.m01;
                    this.lineDirections[n3] = f5 * pMatrix2D.m10 + f6 * pMatrix2D.m11;
                }
            }
        }

        void applyMatrixOnPointGeometry(PMatrix2D pMatrix2D, int n, int n2) {
            if (n < n2) {
                for (int i = n; i <= n2; ++i) {
                    int n3 = 4 * i;
                    float f = this.pointVertices[n3++];
                    float f2 = this.pointVertices[n3];
                    n3 = 4 * i;
                    this.pointVertices[n3++] = f * pMatrix2D.m00 + f2 * pMatrix2D.m01 + pMatrix2D.m02;
                    this.pointVertices[n3] = f * pMatrix2D.m10 + f2 * pMatrix2D.m11 + pMatrix2D.m12;
                }
            }
        }

        void applyMatrixOnPolyGeometry(PMatrix3D pMatrix3D, int n, int n2) {
            if (n < n2) {
                for (int i = n; i <= n2; ++i) {
                    int n3 = 4 * i;
                    float f = this.polyVertices[n3++];
                    float f2 = this.polyVertices[n3++];
                    float f3 = this.polyVertices[n3++];
                    float f4 = this.polyVertices[n3];
                    n3 = 3 * i;
                    float f5 = this.polyNormals[n3++];
                    float f6 = this.polyNormals[n3++];
                    float f7 = this.polyNormals[n3];
                    n3 = 4 * i;
                    this.polyVertices[n3++] = f * pMatrix3D.m00 + f2 * pMatrix3D.m01 + f3 * pMatrix3D.m02 + f4 * pMatrix3D.m03;
                    this.polyVertices[n3++] = f * pMatrix3D.m10 + f2 * pMatrix3D.m11 + f3 * pMatrix3D.m12 + f4 * pMatrix3D.m13;
                    this.polyVertices[n3++] = f * pMatrix3D.m20 + f2 * pMatrix3D.m21 + f3 * pMatrix3D.m22 + f4 * pMatrix3D.m23;
                    this.polyVertices[n3] = f * pMatrix3D.m30 + f2 * pMatrix3D.m31 + f3 * pMatrix3D.m32 + f4 * pMatrix3D.m33;
                    n3 = 3 * i;
                    this.polyNormals[n3++] = f5 * pMatrix3D.m00 + f6 * pMatrix3D.m01 + f7 * pMatrix3D.m02;
                    this.polyNormals[n3++] = f5 * pMatrix3D.m10 + f6 * pMatrix3D.m11 + f7 * pMatrix3D.m12;
                    this.polyNormals[n3] = f5 * pMatrix3D.m20 + f6 * pMatrix3D.m21 + f7 * pMatrix3D.m22;
                }
            }
        }

        void applyMatrixOnLineGeometry(PMatrix3D pMatrix3D, int n, int n2) {
            if (n < n2) {
                for (int i = n; i <= n2; ++i) {
                    int n3 = 4 * i;
                    float f = this.lineVertices[n3++];
                    float f2 = this.lineVertices[n3++];
                    float f3 = this.lineVertices[n3++];
                    float f4 = this.lineVertices[n3];
                    n3 = 4 * i;
                    float f5 = this.lineDirections[n3++];
                    float f6 = this.lineDirections[n3++];
                    float f7 = this.lineDirections[n3];
                    float f8 = f5 - f;
                    float f9 = f6 - f2;
                    float f10 = f7 - f3;
                    n3 = 4 * i;
                    this.lineVertices[n3++] = f * pMatrix3D.m00 + f2 * pMatrix3D.m01 + f3 * pMatrix3D.m02 + f4 * pMatrix3D.m03;
                    this.lineVertices[n3++] = f * pMatrix3D.m10 + f2 * pMatrix3D.m11 + f3 * pMatrix3D.m12 + f4 * pMatrix3D.m13;
                    this.lineVertices[n3++] = f * pMatrix3D.m20 + f2 * pMatrix3D.m21 + f3 * pMatrix3D.m22 + f4 * pMatrix3D.m23;
                    this.lineVertices[n3] = f * pMatrix3D.m30 + f2 * pMatrix3D.m31 + f3 * pMatrix3D.m32 + f4 * pMatrix3D.m33;
                    n3 = 4 * i;
                    this.lineDirections[n3++] = f8 * pMatrix3D.m00 + f9 * pMatrix3D.m01 + f10 * pMatrix3D.m02;
                    this.lineDirections[n3++] = f8 * pMatrix3D.m10 + f9 * pMatrix3D.m11 + f10 * pMatrix3D.m12;
                    this.lineDirections[n3] = f8 * pMatrix3D.m20 + f9 * pMatrix3D.m21 + f10 * pMatrix3D.m22;
                }
            }
        }

        void applyMatrixOnPointGeometry(PMatrix3D pMatrix3D, int n, int n2) {
            if (n < n2) {
                for (int i = n; i <= n2; ++i) {
                    int n3 = 4 * i;
                    float f = this.pointVertices[n3++];
                    float f2 = this.pointVertices[n3++];
                    float f3 = this.pointVertices[n3++];
                    float f4 = this.pointVertices[n3];
                    n3 = 4 * i;
                    this.pointVertices[n3++] = f * pMatrix3D.m00 + f2 * pMatrix3D.m01 + f3 * pMatrix3D.m02 + f4 * pMatrix3D.m03;
                    this.pointVertices[n3++] = f * pMatrix3D.m10 + f2 * pMatrix3D.m11 + f3 * pMatrix3D.m12 + f4 * pMatrix3D.m13;
                    this.pointVertices[n3++] = f * pMatrix3D.m20 + f2 * pMatrix3D.m21 + f3 * pMatrix3D.m22 + f4 * pMatrix3D.m23;
                    this.pointVertices[n3] = f * pMatrix3D.m30 + f2 * pMatrix3D.m31 + f3 * pMatrix3D.m32 + f4 * pMatrix3D.m33;
                }
            }
        }
    }

    protected class InGeometry {
        int renderMode;
        int vertexCount;
        int edgeCount;
        int firstVertex;
        int lastVertex;
        int firstEdge;
        int lastEdge;
        float[] vertices;
        int[] colors;
        float[] normals;
        float[] texcoords;
        int[] strokeColors;
        float[] strokeWeights;
        boolean[] breaks;
        int[][] edges;
        int[] ambient;
        int[] specular;
        int[] emissive;
        float[] shininess;
        int fillColor;
        int strokeColor;
        float strokeWeight;
        int ambientColor;
        int specularColor;
        int emissiveColor;
        float shininessFactor;
        float normalX;
        float normalY;
        float normalZ;

        InGeometry(int n) {
            this.renderMode = n;
            this.allocate();
        }

        void clear() {
            this.lastVertex = 0;
            this.firstVertex = 0;
            this.vertexCount = 0;
            this.lastEdge = 0;
            this.firstEdge = 0;
            this.edgeCount = 0;
        }

        void clearEdges() {
            this.lastEdge = 0;
            this.firstEdge = 0;
            this.edgeCount = 0;
        }

        void allocate() {
            this.vertices = new float[48];
            this.colors = new int[16];
            this.normals = new float[48];
            this.texcoords = new float[32];
            this.strokeColors = new int[16];
            this.strokeWeights = new float[16];
            this.ambient = new int[16];
            this.specular = new int[16];
            this.emissive = new int[16];
            this.shininess = new float[16];
            this.breaks = new boolean[16];
            this.edges = new int[32][3];
            this.clear();
        }

        void vertexCheck() {
            if (this.vertexCount == this.vertices.length / 3) {
                int n = this.vertexCount << 1;
                this.expandVertices(n);
                this.expandColors(n);
                this.expandNormals(n);
                this.expandTexCoords(n);
                this.expandStrokeColors(n);
                this.expandStrokeWeights(n);
                this.expandAmbient(n);
                this.expandSpecular(n);
                this.expandEmissive(n);
                this.expandShininess(n);
                this.expandBreaks(n);
            }
        }

        void edgeCheck() {
            if (this.edgeCount == this.edges.length) {
                int n = this.edgeCount << 1;
                this.expandEdges(n);
            }
        }

        float getVertexX(int n) {
            return this.vertices[3 * n + 0];
        }

        float getVertexY(int n) {
            return this.vertices[3 * n + 1];
        }

        float getVertexZ(int n) {
            return this.vertices[3 * n + 2];
        }

        float getLastVertexX() {
            return this.vertices[3 * (this.vertexCount - 1) + 0];
        }

        float getLastVertexY() {
            return this.vertices[3 * (this.vertexCount - 1) + 1];
        }

        float getLastVertexZ() {
            return this.vertices[3 * (this.vertexCount - 1) + 2];
        }

        int getNumEdgeVertices(boolean bl) {
            int n = 4 * (this.lastEdge - this.firstEdge + 1);
            int n2 = 0;
            if (bl) {
                for (int i = this.firstEdge; i <= this.lastEdge; ++i) {
                    int[] nArray = this.edges[i];
                    if (nArray[2] != 0 && nArray[2] != 1) continue;
                    ++n2;
                }
            }
            return n + n2;
        }

        int getNumEdgeIndices(boolean bl) {
            int n = 6 * (this.lastEdge - this.firstEdge + 1);
            int n2 = 0;
            if (bl) {
                for (int i = this.firstEdge; i <= this.lastEdge; ++i) {
                    int[] nArray = this.edges[i];
                    if (nArray[2] != 0 && nArray[2] != 1) continue;
                    n2 += 6;
                }
            }
            return n + n2;
        }

        void getVertexMin(PVector pVector) {
            for (int i = 0; i < this.vertexCount; ++i) {
                int n = 4 * i;
                pVector.x = PApplet.min(pVector.x, this.vertices[n++]);
                pVector.y = PApplet.min(pVector.y, this.vertices[n++]);
                pVector.z = PApplet.min(pVector.z, this.vertices[n]);
            }
        }

        void getVertexMax(PVector pVector) {
            for (int i = 0; i < this.vertexCount; ++i) {
                int n = 4 * i;
                pVector.x = PApplet.max(pVector.x, this.vertices[n++]);
                pVector.y = PApplet.max(pVector.y, this.vertices[n++]);
                pVector.z = PApplet.max(pVector.z, this.vertices[n]);
            }
        }

        int getVertexSum(PVector pVector) {
            for (int i = 0; i < this.vertexCount; ++i) {
                int n = 4 * i;
                pVector.x += this.vertices[n++];
                pVector.y += this.vertices[n++];
                pVector.z += this.vertices[n];
            }
            return this.vertexCount;
        }

        void expandVertices(int n) {
            float[] fArray = new float[3 * n];
            PApplet.arrayCopy(this.vertices, 0, fArray, 0, 3 * this.vertexCount);
            this.vertices = fArray;
        }

        void expandColors(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.colors, 0, nArray, 0, this.vertexCount);
            this.colors = nArray;
        }

        void expandNormals(int n) {
            float[] fArray = new float[3 * n];
            PApplet.arrayCopy(this.normals, 0, fArray, 0, 3 * this.vertexCount);
            this.normals = fArray;
        }

        void expandTexCoords(int n) {
            float[] fArray = new float[2 * n];
            PApplet.arrayCopy(this.texcoords, 0, fArray, 0, 2 * this.vertexCount);
            this.texcoords = fArray;
        }

        void expandStrokeColors(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.strokeColors, 0, nArray, 0, this.vertexCount);
            this.strokeColors = nArray;
        }

        void expandStrokeWeights(int n) {
            float[] fArray = new float[n];
            PApplet.arrayCopy(this.strokeWeights, 0, fArray, 0, this.vertexCount);
            this.strokeWeights = fArray;
        }

        void expandAmbient(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.ambient, 0, nArray, 0, this.vertexCount);
            this.ambient = nArray;
        }

        void expandSpecular(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.specular, 0, nArray, 0, this.vertexCount);
            this.specular = nArray;
        }

        void expandEmissive(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.emissive, 0, nArray, 0, this.vertexCount);
            this.emissive = nArray;
        }

        void expandShininess(int n) {
            float[] fArray = new float[n];
            PApplet.arrayCopy(this.shininess, 0, fArray, 0, this.vertexCount);
            this.shininess = fArray;
        }

        void expandBreaks(int n) {
            boolean[] blArray = new boolean[n];
            PApplet.arrayCopy(this.breaks, 0, blArray, 0, this.vertexCount);
            this.breaks = blArray;
        }

        void expandEdges(int n) {
            int[][] nArray = new int[n][3];
            PApplet.arrayCopy(this.edges, 0, nArray, 0, this.edgeCount);
            this.edges = nArray;
        }

        void trim() {
            if (0 < this.vertexCount && this.vertexCount < this.vertices.length / 3) {
                this.trimVertices();
                this.trimColors();
                this.trimNormals();
                this.trimTexCoords();
                this.trimStrokeColors();
                this.trimStrokeWeights();
                this.trimAmbient();
                this.trimSpecular();
                this.trimEmissive();
                this.trimShininess();
                this.trimBreaks();
            }
            if (0 < this.edgeCount && this.edgeCount < this.edges.length) {
                this.trimEdges();
            }
        }

        void trimVertices() {
            float[] fArray = new float[3 * this.vertexCount];
            PApplet.arrayCopy(this.vertices, 0, fArray, 0, 3 * this.vertexCount);
            this.vertices = fArray;
        }

        void trimColors() {
            int[] nArray = new int[this.vertexCount];
            PApplet.arrayCopy(this.colors, 0, nArray, 0, this.vertexCount);
            this.colors = nArray;
        }

        void trimNormals() {
            float[] fArray = new float[3 * this.vertexCount];
            PApplet.arrayCopy(this.normals, 0, fArray, 0, 3 * this.vertexCount);
            this.normals = fArray;
        }

        void trimTexCoords() {
            float[] fArray = new float[2 * this.vertexCount];
            PApplet.arrayCopy(this.texcoords, 0, fArray, 0, 2 * this.vertexCount);
            this.texcoords = fArray;
        }

        void trimStrokeColors() {
            int[] nArray = new int[this.vertexCount];
            PApplet.arrayCopy(this.strokeColors, 0, nArray, 0, this.vertexCount);
            this.strokeColors = nArray;
        }

        void trimStrokeWeights() {
            float[] fArray = new float[this.vertexCount];
            PApplet.arrayCopy(this.strokeWeights, 0, fArray, 0, this.vertexCount);
            this.strokeWeights = fArray;
        }

        void trimAmbient() {
            int[] nArray = new int[this.vertexCount];
            PApplet.arrayCopy(this.ambient, 0, nArray, 0, this.vertexCount);
            this.ambient = nArray;
        }

        void trimSpecular() {
            int[] nArray = new int[this.vertexCount];
            PApplet.arrayCopy(this.specular, 0, nArray, 0, this.vertexCount);
            this.specular = nArray;
        }

        void trimEmissive() {
            int[] nArray = new int[this.vertexCount];
            PApplet.arrayCopy(this.emissive, 0, nArray, 0, this.vertexCount);
            this.emissive = nArray;
        }

        void trimShininess() {
            float[] fArray = new float[this.vertexCount];
            PApplet.arrayCopy(this.shininess, 0, fArray, 0, this.vertexCount);
            this.shininess = fArray;
        }

        void trimBreaks() {
            boolean[] blArray = new boolean[this.vertexCount];
            PApplet.arrayCopy(this.breaks, 0, blArray, 0, this.vertexCount);
            this.breaks = blArray;
        }

        void trimEdges() {
            int[][] nArray = new int[this.edgeCount][3];
            PApplet.arrayCopy(this.edges, 0, nArray, 0, this.edgeCount);
            this.edges = nArray;
        }

        int addVertex(float f, float f2, int n) {
            return this.addVertex(f, f2, 0.0f, this.fillColor, this.normalX, this.normalY, this.normalZ, 0.0f, 0.0f, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, n);
        }

        int addVertex(float f, float f2, float f3, float f4, int n) {
            return this.addVertex(f, f2, 0.0f, this.fillColor, this.normalX, this.normalY, this.normalZ, f3, f4, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, n);
        }

        int addVertex(float f, float f2, float f3, int n) {
            return this.addVertex(f, f2, f3, this.fillColor, this.normalX, this.normalY, this.normalZ, 0.0f, 0.0f, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, n);
        }

        int addVertex(float f, float f2, float f3, float f4, float f5, int n) {
            return this.addVertex(f, f2, f3, this.fillColor, this.normalX, this.normalY, this.normalZ, f4, f5, this.strokeColor, this.strokeWeight, this.ambientColor, this.specularColor, this.emissiveColor, this.shininessFactor, n);
        }

        int addVertex(float f, float f2, float f3, int n, float f4, float f5, float f6, float f7, float f8, int n2, float f9, int n3, int n4, int n5, float f10, int n6) {
            this.vertexCheck();
            PGraphicsOpenGL.this.curveVertexCount = 0;
            int n7 = 3 * this.vertexCount;
            this.vertices[n7++] = f;
            this.vertices[n7++] = f2;
            this.vertices[n7] = f3;
            this.colors[this.vertexCount] = PGL.javaToNativeARGB(n);
            n7 = 3 * this.vertexCount;
            this.normals[n7++] = f4;
            this.normals[n7++] = f5;
            this.normals[n7] = f6;
            n7 = 2 * this.vertexCount;
            this.texcoords[n7++] = f7;
            this.texcoords[n7] = f8;
            this.strokeColors[this.vertexCount] = PGL.javaToNativeARGB(n2);
            this.strokeWeights[this.vertexCount] = f9;
            this.ambient[this.vertexCount] = PGL.javaToNativeARGB(n3);
            this.specular[this.vertexCount] = PGL.javaToNativeARGB(n4);
            this.emissive[this.vertexCount] = PGL.javaToNativeARGB(n5);
            this.shininess[this.vertexCount] = f10;
            this.breaks[this.vertexCount] = n6 == 4;
            this.lastVertex = this.vertexCount++;
            return this.lastVertex;
        }

        void addBezierVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, boolean bl, boolean bl2, int n, int n2) {
            this.addBezierVertex(f, f2, f3, f4, f5, f6, f7, f8, f9, bl, bl2, n, n2, 20);
        }

        void addBezierVertex(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, boolean bl, boolean bl2, int n, int n2, int n3) {
            PGraphicsOpenGL.this.bezierInitCheck();
            PGraphicsOpenGL.this.bezierVertexCheck(n3, this.vertexCount);
            PMatrix3D pMatrix3D = PGraphicsOpenGL.this.bezierDrawMatrix;
            float f10 = this.getLastVertexX();
            float f11 = this.getLastVertexY();
            float f12 = this.getLastVertexZ();
            float f13 = pMatrix3D.m10 * f10 + pMatrix3D.m11 * f + pMatrix3D.m12 * f4 + pMatrix3D.m13 * f7;
            float f14 = pMatrix3D.m20 * f10 + pMatrix3D.m21 * f + pMatrix3D.m22 * f4 + pMatrix3D.m23 * f7;
            float f15 = pMatrix3D.m30 * f10 + pMatrix3D.m31 * f + pMatrix3D.m32 * f4 + pMatrix3D.m33 * f7;
            float f16 = pMatrix3D.m10 * f11 + pMatrix3D.m11 * f2 + pMatrix3D.m12 * f5 + pMatrix3D.m13 * f8;
            float f17 = pMatrix3D.m20 * f11 + pMatrix3D.m21 * f2 + pMatrix3D.m22 * f5 + pMatrix3D.m23 * f8;
            float f18 = pMatrix3D.m30 * f11 + pMatrix3D.m31 * f2 + pMatrix3D.m32 * f5 + pMatrix3D.m33 * f8;
            float f19 = pMatrix3D.m10 * f12 + pMatrix3D.m11 * f3 + pMatrix3D.m12 * f6 + pMatrix3D.m13 * f9;
            float f20 = pMatrix3D.m20 * f12 + pMatrix3D.m21 * f3 + pMatrix3D.m22 * f6 + pMatrix3D.m23 * f9;
            float f21 = pMatrix3D.m30 * f12 + pMatrix3D.m31 * f3 + pMatrix3D.m32 * f6 + pMatrix3D.m33 * f9;
            for (int i = 0; i < n; ++i) {
                f10 += f13;
                f13 += f14;
                f14 += f15;
                f16 += f17;
                f17 += f18;
                f20 += f21;
                this.addVertex(f10, f11 += f16, f12 += (f19 += f20), i == 0 && n2 == 4 ? 4 : 0);
            }
        }

        public void addQuadraticVertex(float f, float f2, float f3, float f4, float f5, float f6, boolean bl, boolean bl2, int n, int n2) {
            this.addQuadraticVertex(f, f2, f3, f4, f5, f6, bl, bl2, n, n2, 20);
        }

        public void addQuadraticVertex(float f, float f2, float f3, float f4, float f5, float f6, boolean bl, boolean bl2, int n, int n2, int n3) {
            float f7 = this.getLastVertexX();
            float f8 = this.getLastVertexY();
            float f9 = this.getLastVertexZ();
            this.addBezierVertex(f7 + (f - f7) * 2.0f / 3.0f, f8 + (f2 - f8) * 2.0f / 3.0f, f9 + (f3 - f9) * 2.0f / 3.0f, f4 + (f - f4) * 2.0f / 3.0f, f5 + (f2 - f5) * 2.0f / 3.0f, f6 + (f3 - f6) * 2.0f / 3.0f, f4, f5, f6, bl, bl2, n, n2, n3);
        }

        void addCurveVertex(float f, float f2, float f3, boolean bl, boolean bl2, int n, int n2) {
            this.addCurveVertex(f, f2, f3, bl, bl2, n, n2, 20);
        }

        void addCurveVertex(float f, float f2, float f3, boolean bl, boolean bl2, int n, int n2, int n3) {
            PGraphicsOpenGL.this.curveVertexCheck(n3);
            float[] fArray = PGraphicsOpenGL.this.curveVertices[PGraphicsOpenGL.this.curveVertexCount];
            fArray[0] = f;
            fArray[1] = f2;
            fArray[2] = f3;
            PGraphicsOpenGL.this.curveVertexCount++;
            if (PGraphicsOpenGL.this.curveVertexCount > 3) {
                float[] fArray2 = PGraphicsOpenGL.this.curveVertices[PGraphicsOpenGL.this.curveVertexCount - 4];
                float[] fArray3 = PGraphicsOpenGL.this.curveVertices[PGraphicsOpenGL.this.curveVertexCount - 3];
                float[] fArray4 = PGraphicsOpenGL.this.curveVertices[PGraphicsOpenGL.this.curveVertexCount - 2];
                float[] fArray5 = PGraphicsOpenGL.this.curveVertices[PGraphicsOpenGL.this.curveVertexCount - 1];
                this.addCurveVertexSegment(fArray2[0], fArray2[1], fArray2[2], fArray3[0], fArray3[1], fArray3[2], fArray4[0], fArray4[1], fArray4[2], fArray5[0], fArray5[1], fArray5[2], n, n2);
            }
        }

        void addCurveVertexSegment(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, int n, int n2) {
            float f13 = f4;
            float f14 = f5;
            float f15 = f6;
            PMatrix3D pMatrix3D = PGraphicsOpenGL.this.curveDrawMatrix;
            float f16 = pMatrix3D.m10 * f + pMatrix3D.m11 * f4 + pMatrix3D.m12 * f7 + pMatrix3D.m13 * f10;
            float f17 = pMatrix3D.m20 * f + pMatrix3D.m21 * f4 + pMatrix3D.m22 * f7 + pMatrix3D.m23 * f10;
            float f18 = pMatrix3D.m30 * f + pMatrix3D.m31 * f4 + pMatrix3D.m32 * f7 + pMatrix3D.m33 * f10;
            float f19 = pMatrix3D.m10 * f2 + pMatrix3D.m11 * f5 + pMatrix3D.m12 * f8 + pMatrix3D.m13 * f11;
            float f20 = pMatrix3D.m20 * f2 + pMatrix3D.m21 * f5 + pMatrix3D.m22 * f8 + pMatrix3D.m23 * f11;
            float f21 = pMatrix3D.m30 * f2 + pMatrix3D.m31 * f5 + pMatrix3D.m32 * f8 + pMatrix3D.m33 * f11;
            float f22 = pMatrix3D.m10 * f3 + pMatrix3D.m11 * f6 + pMatrix3D.m12 * f9 + pMatrix3D.m13 * f12;
            float f23 = pMatrix3D.m20 * f3 + pMatrix3D.m21 * f6 + pMatrix3D.m22 * f9 + pMatrix3D.m23 * f12;
            float f24 = pMatrix3D.m30 * f3 + pMatrix3D.m31 * f6 + pMatrix3D.m32 * f9 + pMatrix3D.m33 * f12;
            int n3 = PGraphicsOpenGL.this.curveVertexCount;
            this.addVertex(f13, f14, f15, n2 == 4 ? 4 : 0);
            for (int i = 0; i < n; ++i) {
                f13 += f16;
                f16 += f17;
                f17 += f18;
                f20 += f21;
                this.addVertex(f13, f14 += (f19 += f20), f15 += (f22 += (f23 += f24)), 0);
            }
            PGraphicsOpenGL.this.curveVertexCount = n3;
        }

        float[][] getVertexData() {
            float[][] fArray = new float[this.vertexCount][37];
            for (int i = 0; i < this.vertexCount; ++i) {
                float[] fArray2 = fArray[i];
                fArray2[0] = this.vertices[3 * i + 0];
                fArray2[1] = this.vertices[3 * i + 1];
                fArray2[2] = this.vertices[3 * i + 2];
                fArray2[3] = (float)(this.colors[i] >> 16 & 0xFF) / 255.0f;
                fArray2[4] = (float)(this.colors[i] >> 8 & 0xFF) / 255.0f;
                fArray2[5] = (float)(this.colors[i] >> 0 & 0xFF) / 255.0f;
                fArray2[6] = (float)(this.colors[i] >> 24 & 0xFF) / 255.0f;
                fArray2[7] = this.texcoords[2 * i + 0];
                fArray2[8] = this.texcoords[2 * i + 1];
                fArray2[9] = this.normals[3 * i + 0];
                fArray2[10] = this.normals[3 * i + 1];
                fArray2[11] = this.normals[3 * i + 2];
                fArray2[13] = (float)(this.strokeColors[i] >> 16 & 0xFF) / 255.0f;
                fArray2[14] = (float)(this.strokeColors[i] >> 8 & 0xFF) / 255.0f;
                fArray2[15] = (float)(this.strokeColors[i] >> 0 & 0xFF) / 255.0f;
                fArray2[16] = (float)(this.strokeColors[i] >> 24 & 0xFF) / 255.0f;
                fArray2[17] = this.strokeWeights[i];
            }
            return fArray;
        }

        int addEdge(int n, int n2, boolean bl, boolean bl2) {
            this.edgeCheck();
            int[] nArray = this.edges[this.edgeCount];
            nArray[0] = n;
            nArray[1] = n2;
            nArray[2] = (bl ? 1 : 0) + 2 * (bl2 ? 1 : 0);
            this.lastEdge = this.edgeCount++;
            return this.lastEdge;
        }

        void addTrianglesEdges() {
            for (int i = 0; i < (this.lastVertex - this.firstVertex + 1) / 3; ++i) {
                int n = 3 * i + 0;
                int n2 = 3 * i + 1;
                int n3 = 3 * i + 2;
                this.addEdge(n, n2, true, false);
                this.addEdge(n2, n3, false, false);
                this.addEdge(n3, n, false, true);
            }
        }

        void addTriangleFanEdges() {
            for (int i = this.firstVertex + 1; i < this.lastVertex; ++i) {
                int n = this.firstVertex;
                int n2 = i;
                int n3 = i + 1;
                this.addEdge(n, n2, true, false);
                this.addEdge(n2, n3, false, false);
                this.addEdge(n3, n, false, true);
            }
        }

        void addTriangleStripEdges() {
            for (int i = this.firstVertex + 1; i < this.lastVertex; ++i) {
                int n;
                int n2;
                int n3 = i;
                if (i % 2 == 0) {
                    n2 = i - 1;
                    n = i + 1;
                } else {
                    n2 = i + 1;
                    n = i - 1;
                }
                this.addEdge(n3, n2, true, false);
                this.addEdge(n2, n, false, false);
                this.addEdge(n, n3, false, true);
            }
        }

        void addQuadsEdges() {
            for (int i = 0; i < (this.lastVertex - this.firstVertex + 1) / 4; ++i) {
                int n = 4 * i + 0;
                int n2 = 4 * i + 1;
                int n3 = 4 * i + 2;
                int n4 = 4 * i + 3;
                this.addEdge(n, n2, true, false);
                this.addEdge(n2, n3, false, false);
                this.addEdge(n3, n4, false, false);
                this.addEdge(n4, n, false, true);
            }
        }

        void addQuadStripEdges() {
            for (int i = 1; i < (this.lastVertex - this.firstVertex + 1) / 2; ++i) {
                int n = this.firstVertex + 2 * (i - 1);
                int n2 = this.firstVertex + 2 * (i - 1) + 1;
                int n3 = this.firstVertex + 2 * i + 1;
                int n4 = this.firstVertex + 2 * i;
                this.addEdge(n, n2, true, false);
                this.addEdge(n2, n3, false, false);
                this.addEdge(n3, n4, false, false);
                this.addEdge(n4, n, false, true);
            }
        }

        void addPolygonEdges(boolean bl) {
            int n = this.firstVertex;
            boolean bl2 = true;
            for (int i = this.firstVertex + 1; i <= this.lastVertex; ++i) {
                if (this.breaks[i]) {
                    if (bl) {
                        this.addEdge(i - 1, n, bl2, true);
                    }
                    n = i;
                    bl2 = true;
                    continue;
                }
                if (i == this.lastVertex) {
                    if (bl && n + 1 < i) {
                        this.addEdge(i - 1, i, bl2, false);
                        this.addEdge(i, n, false, true);
                    } else {
                        this.addEdge(i - 1, i, bl2, true);
                    }
                } else if (i < this.lastVertex && this.breaks[i + 1] && !bl) {
                    this.addEdge(i - 1, i, bl2, true);
                } else {
                    this.addEdge(i - 1, i, bl2, false);
                }
                bl2 = false;
            }
        }

        void calcTriangleNormal(int n, int n2, int n3) {
            int n4 = 3 * n;
            float f = this.vertices[n4++];
            float f2 = this.vertices[n4++];
            float f3 = this.vertices[n4];
            n4 = 3 * n2;
            float f4 = this.vertices[n4++];
            float f5 = this.vertices[n4++];
            float f6 = this.vertices[n4];
            n4 = 3 * n3;
            float f7 = this.vertices[n4++];
            float f8 = this.vertices[n4++];
            float f9 = this.vertices[n4];
            float f10 = f7 - f4;
            float f11 = f8 - f5;
            float f12 = f9 - f6;
            float f13 = f - f4;
            float f14 = f2 - f5;
            float f15 = f3 - f6;
            float f16 = f11 * f15 - f14 * f12;
            float f17 = f12 * f13 - f15 * f10;
            float f18 = f10 * f14 - f13 * f11;
            float f19 = PApplet.sqrt(f16 * f16 + f17 * f17 + f18 * f18);
            n4 = 3 * n;
            this.normals[n4++] = f16 /= f19;
            this.normals[n4++] = f17 /= f19;
            this.normals[n4] = f18 /= f19;
            n4 = 3 * n2;
            this.normals[n4++] = f16;
            this.normals[n4++] = f17;
            this.normals[n4] = f18;
            n4 = 3 * n3;
            this.normals[n4++] = f16;
            this.normals[n4++] = f17;
            this.normals[n4] = f18;
        }

        void calcTrianglesNormals() {
            for (int i = 0; i < (this.lastVertex - this.firstVertex + 1) / 3; ++i) {
                int n = 3 * i + 0;
                int n2 = 3 * i + 1;
                int n3 = 3 * i + 2;
                this.calcTriangleNormal(n, n2, n3);
            }
        }

        void calcTriangleFanNormals() {
            for (int i = this.firstVertex + 1; i < this.lastVertex; ++i) {
                int n = this.firstVertex;
                int n2 = i;
                int n3 = i + 1;
                this.calcTriangleNormal(n, n2, n3);
            }
        }

        void calcTriangleStripNormals() {
            for (int i = this.firstVertex + 1; i < this.lastVertex; ++i) {
                int n;
                int n2;
                int n3 = i;
                if (i % 2 == 0) {
                    n2 = i + 1;
                    n = i - 1;
                } else {
                    n2 = i - 1;
                    n = i + 1;
                }
                this.calcTriangleNormal(n2, n3, n);
            }
        }

        void calcQuadsNormals() {
            for (int i = 0; i < (this.lastVertex - this.firstVertex + 1) / 4; ++i) {
                int n = 4 * i + 0;
                int n2 = 4 * i + 1;
                int n3 = 4 * i + 2;
                int n4 = 4 * i + 3;
                this.calcTriangleNormal(n, n2, n3);
                this.calcTriangleNormal(n3, n4, n);
            }
        }

        void calcQuadStripNormals() {
            for (int i = 1; i < (this.lastVertex - this.firstVertex + 1) / 2; ++i) {
                int n = this.firstVertex + 2 * (i - 1);
                int n2 = this.firstVertex + 2 * (i - 1) + 1;
                int n3 = this.firstVertex + 2 * i;
                int n4 = this.firstVertex + 2 * i + 1;
                this.calcTriangleNormal(n, n4, n2);
                this.calcTriangleNormal(n, n3, n4);
            }
        }

        void setMaterial(int n, int n2, float f, int n3, int n4, int n5, float f2) {
            this.fillColor = n;
            this.strokeColor = n2;
            this.strokeWeight = f;
            this.ambientColor = n3;
            this.specularColor = n4;
            this.emissiveColor = n5;
            this.shininessFactor = f2;
        }

        void setNormal(float f, float f2, float f3) {
            this.normalX = f;
            this.normalY = f2;
            this.normalZ = f3;
        }

        void addPoint(float f, float f2, float f3, boolean bl, boolean bl2) {
            this.addVertex(f, f2, f3, 0);
        }

        void addLine(float f, float f2, float f3, float f4, float f5, float f6, boolean bl, boolean bl2) {
            int n = this.addVertex(f, f2, f3, 0);
            int n2 = this.addVertex(f4, f5, f6, 0);
            if (bl2) {
                this.addEdge(n, n2, true, true);
            }
        }

        void addTriangle(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, boolean bl, boolean bl2) {
            int n = this.addVertex(f, f2, f3, 0);
            int n2 = this.addVertex(f4, f5, f6, 0);
            int n3 = this.addVertex(f7, f8, f9, 0);
            if (bl2) {
                this.addEdge(n, n2, true, false);
                this.addEdge(n2, n3, false, false);
                this.addEdge(n3, n, false, true);
            }
        }

        void addQuad(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, boolean bl, boolean bl2) {
            int n = this.addVertex(f, f2, f3, 0.0f, 0.0f, 0);
            int n2 = this.addVertex(f4, f5, f6, 1.0f, 0.0f, 0);
            int n3 = this.addVertex(f7, f8, f9, 1.0f, 1.0f, 0);
            int n4 = this.addVertex(f10, f11, f12, 0.0f, 1.0f, 0);
            if (bl2) {
                this.addEdge(n, n2, true, false);
                this.addEdge(n2, n3, false, false);
                this.addEdge(n3, n4, false, false);
                this.addEdge(n4, n, false, true);
            }
        }

        void addRect(float f, float f2, float f3, float f4, boolean bl, boolean bl2, int n) {
            float f5;
            switch (n) {
                case 1: {
                    break;
                }
                case 0: {
                    f3 += f;
                    f4 += f2;
                    break;
                }
                case 2: {
                    float f6 = f3;
                    float f7 = f4;
                    f3 = f + f6;
                    f4 = f2 + f7;
                    f -= f6;
                    f2 -= f7;
                    break;
                }
                case 3: {
                    float f8 = f3 / 2.0f;
                    float f9 = f4 / 2.0f;
                    f3 = f + f8;
                    f4 = f2 + f9;
                    f -= f8;
                    f2 -= f9;
                }
            }
            if (f > f3) {
                f5 = f;
                f = f3;
                f3 = f5;
            }
            if (f2 > f4) {
                f5 = f2;
                f2 = f4;
                f4 = f5;
            }
            this.addQuad(f, f2, 0.0f, f3, f2, 0.0f, f3, f4, 0.0f, f, f4, 0.0f, bl, bl2);
        }

        void addRect(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, boolean bl, boolean bl2, int n, int n2) {
            float f9;
            switch (n2) {
                case 1: {
                    break;
                }
                case 0: {
                    f3 += f;
                    f4 += f2;
                    break;
                }
                case 2: {
                    float f10 = f3;
                    float f11 = f4;
                    f3 = f + f10;
                    f4 = f2 + f11;
                    f -= f10;
                    f2 -= f11;
                    break;
                }
                case 3: {
                    float f12 = f3 / 2.0f;
                    float f13 = f4 / 2.0f;
                    f3 = f + f12;
                    f4 = f2 + f13;
                    f -= f12;
                    f2 -= f13;
                }
            }
            if (f > f3) {
                f9 = f;
                f = f3;
                f3 = f9;
            }
            if (f2 > f4) {
                f9 = f2;
                f2 = f4;
                f4 = f9;
            }
            if (f5 > (f9 = PApplet.min((f3 - f) / 2.0f, (f4 - f2) / 2.0f))) {
                f5 = f9;
            }
            if (f6 > f9) {
                f6 = f9;
            }
            if (f7 > f9) {
                f7 = f9;
            }
            if (f8 > f9) {
                f8 = f9;
            }
            if (PGraphicsOpenGL.nonZero(f6)) {
                this.addVertex(f3 - f6, f2, 0);
                this.addQuadraticVertex(f3, f2, 0.0f, f3, f2 + f6, 0.0f, bl, bl2, n, 0);
            } else {
                this.addVertex(f3, f2, 0);
            }
            if (PGraphicsOpenGL.nonZero(f7)) {
                this.addVertex(f3, f4 - f7, 0);
                this.addQuadraticVertex(f3, f4, 0.0f, f3 - f7, f4, 0.0f, bl, bl2, n, 0);
            } else {
                this.addVertex(f3, f4, 0);
            }
            if (PGraphicsOpenGL.nonZero(f8)) {
                this.addVertex(f + f8, f4, 0);
                this.addQuadraticVertex(f, f4, 0.0f, f, f4 - f8, 0.0f, bl, bl2, n, 0);
            } else {
                this.addVertex(f, f4, 0);
            }
            if (PGraphicsOpenGL.nonZero(f5)) {
                this.addVertex(f, f2 + f5, 0);
                this.addQuadraticVertex(f, f2, 0.0f, f + f5, f2, 0.0f, bl, bl2, n, 0);
            } else {
                this.addVertex(f, f2, 0);
            }
            if (bl2) {
                this.addPolygonEdges(true);
            }
        }

        void addEllipse(float f, float f2, float f3, float f4, boolean bl, boolean bl2, int n) {
            float f5 = f;
            float f6 = f2;
            float f7 = f3;
            float f8 = f4;
            if (n == 1) {
                f7 = f3 - f;
                f8 = f4 - f2;
            } else if (n == 2) {
                f5 = f - f3;
                f6 = f2 - f4;
                f7 = f3 * 2.0f;
                f8 = f4 * 2.0f;
            } else if (n == 3) {
                f5 = f - f3 / 2.0f;
                f6 = f2 - f4 / 2.0f;
            }
            if (f7 < 0.0f) {
                f5 += f7;
                f7 = -f7;
            }
            if (f8 < 0.0f) {
                f6 += f8;
                f8 = -f8;
            }
            float f9 = f7 / 2.0f;
            float f10 = f8 / 2.0f;
            float f11 = f5 + f9;
            float f12 = f6 + f10;
            float f13 = pgCurrent.screenX(f5, f6);
            float f14 = pgCurrent.screenY(f5, f6);
            float f15 = pgCurrent.screenX(f5 + f7, f6 + f8);
            float f16 = pgCurrent.screenY(f5 + f7, f6 + f8);
            int n2 = PApplet.max(20, (int)((float)Math.PI * 2 * PApplet.dist(f13, f14, f15, f16) / 10.0f));
            float f17 = 720.0f / (float)n2;
            if (bl) {
                this.addVertex(f11, f12, 0);
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            float f18 = 0.0f;
            for (int i = 0; i < n2; ++i) {
                n3 = this.addVertex(f11 + cosLUT[(int)f18] * f9, f12 + sinLUT[(int)f18] * f10, 0);
                f18 = (f18 + f17) % 720.0f;
                if (0 < i) {
                    if (bl2) {
                        this.addEdge(n4, n3, i == 1, false);
                    }
                } else {
                    n5 = n3;
                }
                n4 = n3;
            }
            this.addVertex(f11 + cosLUT[0] * f9, f12 + sinLUT[0] * f10, 0);
            if (bl2) {
                this.addEdge(n3, n5, false, true);
            }
        }

        void addArc(float f, float f2, float f3, float f4, float f5, float f6, boolean bl, boolean bl2, int n) {
            int n2;
            int n3;
            float f7 = f3 / 2.0f;
            float f8 = f4 / 2.0f;
            float f9 = f + f7;
            float f10 = f2 + f8;
            int n4 = (int)(0.5f + f5 / ((float)Math.PI * 2) * 720.0f);
            int n5 = (int)(0.5f + f6 / ((float)Math.PI * 2) * 720.0f);
            if (bl) {
                this.addVertex(f9, f10, 0);
            }
            int n6 = 1;
            int n7 = 0;
            int n8 = 0;
            for (n3 = n4; n3 < n5; n3 += n6) {
                n2 = n3 % 720;
                if (n2 < 0) {
                    n2 += 720;
                }
                n7 = this.addVertex(f9 + cosLUT[n2] * f7, f10 + sinLUT[n2] * f8, 0);
                if (bl2) {
                    if (n == 3) {
                        this.addEdge(n8, n7, n3 == n4, false);
                    } else if (n4 < n3) {
                        this.addEdge(n8, n7, n3 == n4 + 1, n == 0 && n3 == n5 - 1);
                    }
                }
                n8 = n7;
            }
            n7 = this.addVertex(f9 + cosLUT[n5 % 720] * f7, f10 + sinLUT[n5 % 720] * f8, 0);
            if (bl2 && n == 3) {
                this.addEdge(n7, 0, false, true);
            }
            if (n == 2 || n == 1) {
                n8 = n7;
                n3 = n4;
                n2 = n3 % 720;
                if (n2 < 0) {
                    n2 += 720;
                }
                n7 = this.addVertex(f9 + cosLUT[n2] * f7, f10 + sinLUT[n2] * f8, 0);
                if (bl2 && n == 2) {
                    this.addEdge(n8, n7, false, true);
                }
            }
        }

        void addBox(float f, float f2, float f3, boolean bl, boolean bl2) {
            float f4 = -f / 2.0f;
            float f5 = f / 2.0f;
            float f6 = -f2 / 2.0f;
            float f7 = f2 / 2.0f;
            float f8 = -f3 / 2.0f;
            float f9 = f3 / 2.0f;
            if (bl || bl2) {
                this.setNormal(0.0f, 0.0f, 1.0f);
                this.addVertex(f4, f6, f8, 0.0f, 0.0f, 0);
                this.addVertex(f5, f6, f8, 1.0f, 0.0f, 0);
                this.addVertex(f5, f7, f8, 1.0f, 1.0f, 0);
                this.addVertex(f4, f7, f8, 0.0f, 1.0f, 0);
                this.setNormal(1.0f, 0.0f, 0.0f);
                this.addVertex(f5, f6, f8, 0.0f, 0.0f, 0);
                this.addVertex(f5, f6, f9, 1.0f, 0.0f, 0);
                this.addVertex(f5, f7, f9, 1.0f, 1.0f, 0);
                this.addVertex(f5, f7, f8, 0.0f, 1.0f, 0);
                this.setNormal(0.0f, 0.0f, -1.0f);
                this.addVertex(f5, f6, f9, 0.0f, 0.0f, 0);
                this.addVertex(f4, f6, f9, 1.0f, 0.0f, 0);
                this.addVertex(f4, f7, f9, 1.0f, 1.0f, 0);
                this.addVertex(f5, f7, f9, 0.0f, 1.0f, 0);
                this.setNormal(-1.0f, 0.0f, 0.0f);
                this.addVertex(f4, f6, f9, 0.0f, 0.0f, 0);
                this.addVertex(f4, f6, f8, 1.0f, 0.0f, 0);
                this.addVertex(f4, f7, f8, 1.0f, 1.0f, 0);
                this.addVertex(f4, f7, f9, 0.0f, 1.0f, 0);
                this.setNormal(0.0f, 1.0f, 0.0f);
                this.addVertex(f4, f6, f9, 0.0f, 0.0f, 0);
                this.addVertex(f5, f6, f9, 1.0f, 0.0f, 0);
                this.addVertex(f5, f6, f8, 1.0f, 1.0f, 0);
                this.addVertex(f4, f6, f8, 0.0f, 1.0f, 0);
                this.setNormal(0.0f, -1.0f, 0.0f);
                this.addVertex(f4, f7, f8, 0.0f, 0.0f, 0);
                this.addVertex(f5, f7, f8, 1.0f, 0.0f, 0);
                this.addVertex(f5, f7, f9, 1.0f, 1.0f, 0);
                this.addVertex(f4, f7, f9, 0.0f, 1.0f, 0);
            }
            if (bl2) {
                this.addEdge(0, 1, true, true);
                this.addEdge(1, 2, true, true);
                this.addEdge(2, 3, true, true);
                this.addEdge(3, 0, true, true);
                this.addEdge(0, 9, true, true);
                this.addEdge(1, 8, true, true);
                this.addEdge(2, 11, true, true);
                this.addEdge(3, 10, true, true);
                this.addEdge(8, 9, true, true);
                this.addEdge(9, 10, true, true);
                this.addEdge(10, 11, true, true);
                this.addEdge(11, 8, true, true);
            }
        }

        int[] addSphere(float f, int n, int n2, boolean bl, boolean bl2) {
            int n3;
            int n4;
            int n5;
            int n6;
            if (n < 3 || n2 < 2) {
                PGraphicsOpenGL.this.sphereDetail(30);
                n2 = 30;
                n = 30;
            } else {
                PGraphicsOpenGL.this.sphereDetail(n, n2);
            }
            int n7 = 3 * n + (6 * n + 3) * (n2 - 2) + 3 * n;
            int[] nArray = new int[n7];
            int n8 = 0;
            int n9 = 0;
            float f2 = 1.0f / (float)n;
            float f3 = 1.0f / (float)n2;
            float f4 = 1.0f;
            float f5 = 1.0f;
            for (n6 = 0; n6 < n; ++n6) {
                this.setNormal(0.0f, 1.0f, 0.0f);
                this.addVertex(0.0f, f, 0.0f, f4, f5, 0);
                f4 -= f2;
            }
            int n10 = n8 = n;
            f4 = 1.0f;
            f5 -= f3;
            for (n6 = 0; n6 < n; ++n6) {
                this.setNormal(PGraphicsOpenGL.this.sphereX[n6], PGraphicsOpenGL.this.sphereY[n6], PGraphicsOpenGL.this.sphereZ[n6]);
                this.addVertex(f * PGraphicsOpenGL.this.sphereX[n6], f * PGraphicsOpenGL.this.sphereY[n6], f * PGraphicsOpenGL.this.sphereZ[n6], f4, f5, 0);
                f4 -= f2;
            }
            n8 += n;
            int n11 = n8++;
            this.setNormal(PGraphicsOpenGL.this.sphereX[0], PGraphicsOpenGL.this.sphereY[0], PGraphicsOpenGL.this.sphereZ[0]);
            this.addVertex(f * PGraphicsOpenGL.this.sphereX[0], f * PGraphicsOpenGL.this.sphereY[0], f * PGraphicsOpenGL.this.sphereZ[0], f4, f5, 0);
            for (n6 = 0; n6 < n; ++n6) {
                n5 = n10 + n6;
                n4 = n10 + n6 - n;
                nArray[3 * n6 + 0] = n5;
                nArray[3 * n6 + 1] = n4;
                nArray[3 * n6 + 2] = n5 + 1;
                this.addEdge(n4, n5, true, true);
                this.addEdge(n5, n5 + 1, true, true);
            }
            n9 += 3 * n;
            n6 = 0;
            for (n5 = 2; n5 < n2; ++n5) {
                n6 += n;
                n10 = n8;
                f4 = 1.0f;
                f5 -= f3;
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n6 + n4;
                    this.setNormal(PGraphicsOpenGL.this.sphereX[n3], PGraphicsOpenGL.this.sphereY[n3], PGraphicsOpenGL.this.sphereZ[n3]);
                    this.addVertex(f * PGraphicsOpenGL.this.sphereX[n3], f * PGraphicsOpenGL.this.sphereY[n3], f * PGraphicsOpenGL.this.sphereZ[n3], f4, f5, 0);
                    f4 -= f2;
                }
                n8 += n;
                n11 = n8++;
                this.setNormal(PGraphicsOpenGL.this.sphereX[n6], PGraphicsOpenGL.this.sphereY[n6], PGraphicsOpenGL.this.sphereZ[n6]);
                this.addVertex(f * PGraphicsOpenGL.this.sphereX[n6], f * PGraphicsOpenGL.this.sphereY[n6], f * PGraphicsOpenGL.this.sphereZ[n6], f4, f5, 0);
                for (n4 = 0; n4 < n; ++n4) {
                    n3 = n10 + n4;
                    int n12 = n10 + n4 - n - 1;
                    nArray[n9 + 6 * n4 + 0] = n3;
                    nArray[n9 + 6 * n4 + 1] = n12;
                    nArray[n9 + 6 * n4 + 2] = n12 + 1;
                    nArray[n9 + 6 * n4 + 3] = n3;
                    nArray[n9 + 6 * n4 + 4] = n12 + 1;
                    nArray[n9 + 6 * n4 + 5] = n3 + 1;
                    this.addEdge(n12, n3, true, true);
                    this.addEdge(n3, n3 + 1, true, true);
                    this.addEdge(n12 + 1, n3, true, true);
                }
                nArray[(n9 += 6 * n) + 0] = n11;
                nArray[n9 + 1] = n11 - n;
                nArray[n9 + 2] = n11 - 1;
                n9 += 3;
                this.addEdge(n11 - n, n11 - 1, true, true);
                this.addEdge(n11 - 1, n11, true, true);
            }
            f4 = 1.0f;
            f5 = 0.0f;
            for (n5 = 0; n5 < n; ++n5) {
                this.setNormal(0.0f, -1.0f, 0.0f);
                this.addVertex(0.0f, -f, 0.0f, f4, f5, 0);
                f4 -= f2;
            }
            n8 += n;
            for (n5 = 0; n5 < n; ++n5) {
                n4 = n10 + n5;
                n3 = n10 + n5 + n + 1;
                nArray[n9 + 3 * n5 + 0] = n4;
                nArray[n9 + 3 * n5 + 1] = n3;
                nArray[n9 + 3 * n5 + 2] = n4 + 1;
                this.addEdge(n4, n4 + 1, true, true);
                this.addEdge(n4, n3, true, true);
            }
            n9 += 3 * n;
            return nArray;
        }
    }

    protected class IndexCache {
        int size;
        int[] indexCount;
        int[] indexOffset;
        int[] vertexCount;
        int[] vertexOffset;

        IndexCache() {
            this.allocate();
        }

        void allocate() {
            this.indexCount = new int[2];
            this.indexOffset = new int[2];
            this.vertexCount = new int[2];
            this.vertexOffset = new int[2];
            this.size = 0;
        }

        void clear() {
            this.size = 0;
        }

        int addNew() {
            this.arrayCheck();
            this.init(this.size);
            ++this.size;
            return this.size - 1;
        }

        int addNew(int n) {
            this.arrayCheck();
            this.indexCount[this.size] = this.indexCount[n];
            this.indexOffset[this.size] = this.indexOffset[n];
            this.vertexCount[this.size] = this.vertexCount[n];
            this.vertexOffset[this.size] = this.vertexOffset[n];
            ++this.size;
            return this.size - 1;
        }

        int getLast() {
            if (this.size == 0) {
                this.arrayCheck();
                this.init(0);
                this.size = 1;
            }
            return this.size - 1;
        }

        void incCounts(int n, int n2, int n3) {
            int n4 = n;
            this.indexCount[n4] = this.indexCount[n4] + n2;
            int n5 = n;
            this.vertexCount[n5] = this.vertexCount[n5] + n3;
        }

        void init(int n) {
            if (0 < n) {
                this.indexOffset[n] = this.indexOffset[n - 1] + this.indexCount[n - 1];
                this.vertexOffset[n] = this.vertexOffset[n - 1] + this.vertexCount[n - 1];
            } else {
                this.indexOffset[n] = 0;
                this.vertexOffset[n] = 0;
            }
            this.indexCount[n] = 0;
            this.vertexCount[n] = 0;
        }

        void arrayCheck() {
            if (this.size == this.indexCount.length) {
                int n = this.size << 1;
                this.expandIndexCount(n);
                this.expandIndexOffset(n);
                this.expandVertexCount(n);
                this.expandVertexOffset(n);
            }
        }

        void expandIndexCount(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.indexCount, 0, nArray, 0, this.size);
            this.indexCount = nArray;
        }

        void expandIndexOffset(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.indexOffset, 0, nArray, 0, this.size);
            this.indexOffset = nArray;
        }

        void expandVertexCount(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.vertexCount, 0, nArray, 0, this.size);
            this.vertexCount = nArray;
        }

        void expandVertexOffset(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.vertexOffset, 0, nArray, 0, this.size);
            this.vertexOffset = nArray;
        }
    }

    protected class TexCache {
        int size;
        PImage[] textures;
        int[] firstIndex;
        int[] lastIndex;
        int[] firstCache;
        int[] lastCache;
        boolean hasTexture;
        Texture tex0;

        TexCache() {
            this.allocate();
        }

        void allocate() {
            this.textures = new PImage[16];
            this.firstIndex = new int[16];
            this.lastIndex = new int[16];
            this.firstCache = new int[16];
            this.lastCache = new int[16];
            this.size = 0;
            this.hasTexture = false;
        }

        void clear() {
            Arrays.fill(this.textures, 0, this.size, null);
            this.size = 0;
            this.hasTexture = false;
        }

        void beginRender() {
            this.tex0 = null;
        }

        PImage getTextureImage(int n) {
            return this.textures[n];
        }

        Texture getTexture(int n) {
            PImage pImage = this.textures[n];
            Texture texture = null;
            if (pImage != null && (texture = pgPrimary.getTexture(pImage)) != null) {
                texture.bind();
                this.tex0 = texture;
            }
            if (texture == null && this.tex0 != null) {
                this.tex0.unbind();
                PGraphicsOpenGL.this.pgl.disableTexturing(this.tex0.glTarget);
            }
            return texture;
        }

        void endRender() {
            if (this.hasTexture) {
                for (int i = 0; i < this.size; ++i) {
                    Texture texture;
                    PImage pImage = this.textures[i];
                    if (pImage == null || (texture = pgPrimary.getTexture(pImage)) == null) continue;
                    texture.unbind();
                    PGraphicsOpenGL.this.pgl.disableTexturing(texture.glTarget);
                }
            }
        }

        void addTexture(PImage pImage, int n, int n2, int n3, int n4) {
            this.arrayCheck();
            this.textures[this.size] = pImage;
            this.firstIndex[this.size] = n;
            this.lastIndex[this.size] = n3;
            this.firstCache[this.size] = n2;
            this.lastCache[this.size] = n4;
            this.hasTexture |= pImage != null;
            ++this.size;
        }

        void setLastIndex(int n, int n2) {
            this.lastIndex[this.size - 1] = n;
            this.lastCache[this.size - 1] = n2;
        }

        void arrayCheck() {
            if (this.size == this.textures.length) {
                int n = this.size << 1;
                this.expandTextures(n);
                this.expandFirstIndex(n);
                this.expandLastIndex(n);
                this.expandFirstCache(n);
                this.expandLastCache(n);
            }
        }

        void expandTextures(int n) {
            PImage[] pImageArray = new PImage[n];
            PApplet.arrayCopy(this.textures, 0, pImageArray, 0, this.size);
            this.textures = pImageArray;
        }

        void expandFirstIndex(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.firstIndex, 0, nArray, 0, this.size);
            this.firstIndex = nArray;
        }

        void expandLastIndex(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.lastIndex, 0, nArray, 0, this.size);
            this.lastIndex = nArray;
        }

        void expandFirstCache(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.firstCache, 0, nArray, 0, this.size);
            this.firstCache = nArray;
        }

        void expandLastCache(int n) {
            int[] nArray = new int[n];
            PApplet.arrayCopy(this.lastCache, 0, nArray, 0, this.size);
            this.lastCache = nArray;
        }
    }

    protected class PointShader
    extends BaseShader {
        protected int perspectiveLoc;
        protected int vertexLoc;
        protected int colorLoc;
        protected int offsetLoc;

        public PointShader(PApplet pApplet) {
            super(pApplet);
        }

        public PointShader(PApplet pApplet, String string, String string2) {
            super(pApplet, string, string2);
        }

        public PointShader(PApplet pApplet, URL uRL, URL uRL2) {
            super(pApplet, uRL, uRL2);
        }

        @Override
        public void loadAttributes() {
            this.vertexLoc = this.getAttributeLoc("vertex");
            this.colorLoc = this.getAttributeLoc("color");
            this.offsetLoc = this.getAttributeLoc("offset");
        }

        @Override
        public void loadUniforms() {
            super.loadUniforms();
            this.perspectiveLoc = this.getUniformLoc("perspective");
        }

        @Override
        public void setVertexAttribute(int n, int n2, int n3, int n4, int n5) {
            this.setAttributeVBO(this.vertexLoc, n, n2, n3, false, n4, n5);
        }

        @Override
        public void setColorAttribute(int n, int n2, int n3, int n4, int n5) {
            this.setAttributeVBO(this.colorLoc, n, n2, n3, true, n4, n5);
        }

        public void setPointAttribute(int n, int n2, int n3, int n4, int n5) {
            this.setAttributeVBO(this.offsetLoc, n, n2, n3, false, n4, n5);
        }

        @Override
        public void bind() {
            super.bind();
            if (this.pgCurrent == null) {
                this.setRenderer(pgCurrent);
                this.loadAttributes();
                this.loadUniforms();
            }
            if (-1 < this.vertexLoc) {
                this.pgl.enableVertexAttribArray(this.vertexLoc);
            }
            if (-1 < this.colorLoc) {
                this.pgl.enableVertexAttribArray(this.colorLoc);
            }
            if (-1 < this.offsetLoc) {
                this.pgl.enableVertexAttribArray(this.offsetLoc);
            }
            if (this.pgCurrent.getHint(7) && this.pgCurrent.nonOrthoProjection()) {
                this.setUniformValue(this.perspectiveLoc, 1);
            } else {
                this.setUniformValue(this.perspectiveLoc, 0);
            }
            super.setCommonUniforms();
        }

        @Override
        public void unbind() {
            if (-1 < this.vertexLoc) {
                this.pgl.disableVertexAttribArray(this.vertexLoc);
            }
            if (-1 < this.colorLoc) {
                this.pgl.disableVertexAttribArray(this.colorLoc);
            }
            if (-1 < this.offsetLoc) {
                this.pgl.disableVertexAttribArray(this.offsetLoc);
            }
            super.unbind();
        }
    }

    protected class LineShader
    extends BaseShader {
        protected int perspectiveLoc;
        protected int scaleLoc;
        protected int vertexLoc;
        protected int colorLoc;
        protected int directionLoc;

        public LineShader(PApplet pApplet) {
            super(pApplet);
        }

        public LineShader(PApplet pApplet, String string, String string2) {
            super(pApplet, string, string2);
        }

        public LineShader(PApplet pApplet, URL uRL, URL uRL2) {
            super(pApplet, uRL, uRL2);
        }

        @Override
        public void loadAttributes() {
            this.vertexLoc = this.getAttributeLoc("vertex");
            this.colorLoc = this.getAttributeLoc("color");
            this.directionLoc = this.getAttributeLoc("direction");
        }

        @Override
        public void loadUniforms() {
            super.loadUniforms();
            this.viewportLoc = this.getUniformLoc("viewport");
            this.perspectiveLoc = this.getUniformLoc("perspective");
            this.scaleLoc = this.getUniformLoc("scale");
        }

        @Override
        public void setVertexAttribute(int n, int n2, int n3, int n4, int n5) {
            this.setAttributeVBO(this.vertexLoc, n, n2, n3, false, n4, n5);
        }

        @Override
        public void setColorAttribute(int n, int n2, int n3, int n4, int n5) {
            this.setAttributeVBO(this.colorLoc, n, n2, n3, true, n4, n5);
        }

        public void setLineAttribute(int n, int n2, int n3, int n4, int n5) {
            this.setAttributeVBO(this.directionLoc, n, n2, n3, false, n4, n5);
        }

        @Override
        public void bind() {
            super.bind();
            if (this.pgCurrent == null) {
                this.setRenderer(pgCurrent);
                this.loadAttributes();
                this.loadUniforms();
            }
            if (-1 < this.vertexLoc) {
                this.pgl.enableVertexAttribArray(this.vertexLoc);
            }
            if (-1 < this.colorLoc) {
                this.pgl.enableVertexAttribArray(this.colorLoc);
            }
            if (-1 < this.directionLoc) {
                this.pgl.enableVertexAttribArray(this.directionLoc);
            }
            if (this.pgCurrent.getHint(7) && this.pgCurrent.nonOrthoProjection()) {
                this.setUniformValue(this.perspectiveLoc, 1);
            } else {
                this.setUniformValue(this.perspectiveLoc, 0);
            }
            if (this.pgCurrent.getHint(6)) {
                this.setUniformValue(this.scaleLoc, 1.0f, 1.0f, 1.0f);
            } else if (PGraphicsOpenGL.this.orthoProjection()) {
                this.setUniformValue(this.scaleLoc, 1.0f, 1.0f, 0.99f);
            } else {
                this.setUniformValue(this.scaleLoc, 0.99f, 0.99f, 0.99f);
            }
            this.setCommonUniforms();
        }

        @Override
        public void unbind() {
            if (-1 < this.vertexLoc) {
                this.pgl.disableVertexAttribArray(this.vertexLoc);
            }
            if (-1 < this.colorLoc) {
                this.pgl.disableVertexAttribArray(this.colorLoc);
            }
            if (-1 < this.directionLoc) {
                this.pgl.disableVertexAttribArray(this.directionLoc);
            }
            super.unbind();
        }
    }

    protected class TexlightShader
    extends LightShader {
        protected int texCoordLoc;
        protected int textureLoc;
        protected int texMatrixLoc;
        protected int texOffsetLoc;
        protected float[] tcmat;

        public TexlightShader(PApplet pApplet) {
            super(pApplet);
        }

        public TexlightShader(PApplet pApplet, String string, String string2) {
            super(pApplet, string, string2);
        }

        public TexlightShader(PApplet pApplet, URL uRL, URL uRL2) {
            super(pApplet, uRL, uRL2);
        }

        @Override
        public void loadUniforms() {
            super.loadUniforms();
            this.textureLoc = this.getUniformLoc("texture");
            this.texMatrixLoc = this.getUniformLoc("texMatrix");
            this.texOffsetLoc = this.getUniformLoc("texOffset");
        }

        @Override
        public void loadAttributes() {
            super.loadAttributes();
            this.texCoordLoc = this.getAttributeLoc("texCoord");
        }

        @Override
        public void setTexcoordAttribute(int n, int n2, int n3, int n4, int n5) {
            this.setAttributeVBO(this.texCoordLoc, n, n2, n3, false, n4, n5);
        }

        @Override
        public void setTexture(Texture texture) {
            float f = 1.0f;
            float f2 = 1.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            if (texture.invertedX()) {
                f = -1.0f;
                f3 = 1.0f;
            }
            if (texture.invertedY()) {
                f2 = -1.0f;
                f4 = 1.0f;
            }
            f *= texture.maxTexcoordU;
            f3 *= texture.maxTexcoordU;
            f2 *= texture.maxTexcoordV;
            f4 *= texture.maxTexcoordV;
            if (-1 < this.texMatrixLoc) {
                if (this.tcmat == null) {
                    this.tcmat = new float[16];
                }
                this.tcmat[0] = f;
                this.tcmat[4] = 0.0f;
                this.tcmat[8] = 0.0f;
                this.tcmat[12] = f3;
                this.tcmat[1] = 0.0f;
                this.tcmat[5] = f2;
                this.tcmat[9] = 0.0f;
                this.tcmat[13] = f4;
                this.tcmat[2] = 0.0f;
                this.tcmat[6] = 0.0f;
                this.tcmat[10] = 0.0f;
                this.tcmat[14] = 0.0f;
                this.tcmat[3] = 0.0f;
                this.tcmat[7] = 0.0f;
                this.tcmat[11] = 0.0f;
                this.tcmat[15] = 0.0f;
                this.setUniformMatrix(this.texMatrixLoc, this.tcmat);
            }
            this.setUniformValue(this.texOffsetLoc, 1.0f / (float)texture.width, 1.0f / (float)texture.height);
            this.setUniformValue(this.textureLoc, 0);
        }

        @Override
        public void bind() {
            this.firstTexUnit = 1;
            super.bind();
            if (-1 < this.texCoordLoc) {
                this.pgl.enableVertexAttribArray(this.texCoordLoc);
            }
        }

        @Override
        public void unbind() {
            if (-1 < this.texCoordLoc) {
                this.pgl.disableVertexAttribArray(this.texCoordLoc);
            }
            super.unbind();
        }
    }

    protected class TexureShader
    extends ColorShader {
        protected int texCoordLoc;
        protected int textureLoc;
        protected int texMatrixLoc;
        protected int texOffsetLoc;
        protected float[] tcmat;

        public TexureShader(PApplet pApplet) {
            super(pApplet);
        }

        public TexureShader(PApplet pApplet, String string, String string2) {
            super(pApplet, string, string2);
        }

        public TexureShader(PApplet pApplet, URL uRL, URL uRL2) {
            super(pApplet, uRL, uRL2);
        }

        @Override
        public void loadUniforms() {
            super.loadUniforms();
            this.textureLoc = this.getUniformLoc("texture");
            this.texMatrixLoc = this.getUniformLoc("texMatrix");
            this.texOffsetLoc = this.getUniformLoc("texOffset");
        }

        @Override
        public void loadAttributes() {
            super.loadAttributes();
            this.texCoordLoc = this.getAttributeLoc("texCoord");
        }

        @Override
        public void setTexcoordAttribute(int n, int n2, int n3, int n4, int n5) {
            this.setAttributeVBO(this.texCoordLoc, n, n2, n3, false, n4, n5);
        }

        @Override
        public void setTexture(Texture texture) {
            float f = 1.0f;
            float f2 = 1.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            if (texture.invertedX()) {
                f = -1.0f;
                f3 = 1.0f;
            }
            if (texture.invertedY()) {
                f2 = -1.0f;
                f4 = 1.0f;
            }
            f *= texture.maxTexcoordU();
            f3 *= texture.maxTexcoordU();
            f2 *= texture.maxTexcoordV();
            f4 *= texture.maxTexcoordV();
            if (-1 < this.texMatrixLoc) {
                if (this.tcmat == null) {
                    this.tcmat = new float[16];
                }
                this.tcmat[0] = f;
                this.tcmat[4] = 0.0f;
                this.tcmat[8] = 0.0f;
                this.tcmat[12] = f3;
                this.tcmat[1] = 0.0f;
                this.tcmat[5] = f2;
                this.tcmat[9] = 0.0f;
                this.tcmat[13] = f4;
                this.tcmat[2] = 0.0f;
                this.tcmat[6] = 0.0f;
                this.tcmat[10] = 0.0f;
                this.tcmat[14] = 0.0f;
                this.tcmat[3] = 0.0f;
                this.tcmat[7] = 0.0f;
                this.tcmat[11] = 0.0f;
                this.tcmat[15] = 0.0f;
                this.setUniformMatrix(this.texMatrixLoc, this.tcmat);
            }
            this.setUniformValue(this.texOffsetLoc, 1.0f / (float)texture.width, 1.0f / (float)texture.height);
            this.setUniformValue(this.textureLoc, 0);
        }

        @Override
        public void bind() {
            this.firstTexUnit = 1;
            super.bind();
            if (-1 < this.texCoordLoc) {
                this.pgl.enableVertexAttribArray(this.texCoordLoc);
            }
        }

        @Override
        public void unbind() {
            if (-1 < this.texCoordLoc) {
                this.pgl.disableVertexAttribArray(this.texCoordLoc);
            }
            super.unbind();
        }
    }

    protected class LightShader
    extends BaseShader {
        protected int normalMatrixLoc;
        protected int lightCountLoc;
        protected int lightPositionLoc;
        protected int lightNormalLoc;
        protected int lightAmbientLoc;
        protected int lightDiffuseLoc;
        protected int lightSpecularLoc;
        protected int lightFalloffLoc;
        protected int lightSpotLoc;
        protected int vertexLoc;
        protected int colorLoc;
        protected int normalLoc;
        protected int ambientLoc;
        protected int specularLoc;
        protected int emissiveLoc;
        protected int shininessLoc;

        public LightShader(PApplet pApplet) {
            super(pApplet);
        }

        public LightShader(PApplet pApplet, String string, String string2) {
            super(pApplet, string, string2);
        }

        public LightShader(PApplet pApplet, URL uRL, URL uRL2) {
            super(pApplet, uRL, uRL2);
        }

        @Override
        public void loadAttributes() {
            this.vertexLoc = this.getAttributeLoc("vertex");
            this.colorLoc = this.getAttributeLoc("color");
            this.normalLoc = this.getAttributeLoc("normal");
            this.ambientLoc = this.getAttributeLoc("ambient");
            this.specularLoc = this.getAttributeLoc("specular");
            this.emissiveLoc = this.getAttributeLoc("emissive");
            this.shininessLoc = this.getAttributeLoc("shininess");
        }

        @Override
        public void loadUniforms() {
            super.loadUniforms();
            this.normalMatrixLoc = this.getUniformLoc("normalMatrix");
            this.lightCountLoc = this.getUniformLoc("lightCount");
            this.lightPositionLoc = this.getUniformLoc("lightPosition");
            this.lightNormalLoc = this.getUniformLoc("lightNormal");
            this.lightAmbientLoc = this.getUniformLoc("lightAmbient");
            this.lightDiffuseLoc = this.getUniformLoc("lightDiffuse");
            this.lightSpecularLoc = this.getUniformLoc("lightSpecular");
            this.lightFalloffLoc = this.getUniformLoc("lightFalloff");
            this.lightSpotLoc = this.getUniformLoc("lightSpot");
        }

        @Override
        public void setVertexAttribute(int n, int n2, int n3, int n4, int n5) {
            this.setAttributeVBO(this.vertexLoc, n, n2, n3, false, n4, n5);
        }

        @Override
        public void setColorAttribute(int n, int n2, int n3, int n4, int n5) {
            this.setAttributeVBO(this.colorLoc, n, n2, n3, true, n4, n5);
        }

        @Override
        public void setNormalAttribute(int n, int n2, int n3, int n4, int n5) {
            this.setAttributeVBO(this.normalLoc, n, n2, n3, false, n4, n5);
        }

        @Override
        public void setAmbientAttribute(int n, int n2, int n3, int n4, int n5) {
            this.setAttributeVBO(this.ambientLoc, n, n2, n3, true, n4, n5);
        }

        @Override
        public void setSpecularAttribute(int n, int n2, int n3, int n4, int n5) {
            this.setAttributeVBO(this.specularLoc, n, n2, n3, true, n4, n5);
        }

        @Override
        public void setEmissiveAttribute(int n, int n2, int n3, int n4, int n5) {
            this.setAttributeVBO(this.emissiveLoc, n, n2, n3, true, n4, n5);
        }

        @Override
        public void setShininessAttribute(int n, int n2, int n3, int n4, int n5) {
            this.setAttributeVBO(this.shininessLoc, n, n2, n3, false, n4, n5);
        }

        @Override
        public void bind() {
            super.bind();
            if (this.pgCurrent == null) {
                this.setRenderer(pgCurrent);
                this.loadAttributes();
                this.loadUniforms();
            }
            if (-1 < this.vertexLoc) {
                this.pgl.enableVertexAttribArray(this.vertexLoc);
            }
            if (-1 < this.colorLoc) {
                this.pgl.enableVertexAttribArray(this.colorLoc);
            }
            if (-1 < this.normalLoc) {
                this.pgl.enableVertexAttribArray(this.normalLoc);
            }
            if (-1 < this.ambientLoc) {
                this.pgl.enableVertexAttribArray(this.ambientLoc);
            }
            if (-1 < this.specularLoc) {
                this.pgl.enableVertexAttribArray(this.specularLoc);
            }
            if (-1 < this.emissiveLoc) {
                this.pgl.enableVertexAttribArray(this.emissiveLoc);
            }
            if (-1 < this.shininessLoc) {
                this.pgl.enableVertexAttribArray(this.shininessLoc);
            }
            if (-1 < this.normalMatrixLoc) {
                this.pgCurrent.updateGLNormal();
                this.setUniformMatrix(this.normalMatrixLoc, this.pgCurrent.glNormal);
            }
            int n = this.pgCurrent.lightCount;
            this.setUniformValue(this.lightCountLoc, n);
            this.setUniformVector(this.lightPositionLoc, this.pgCurrent.lightPosition, 4, n);
            this.setUniformVector(this.lightNormalLoc, this.pgCurrent.lightNormal, 3, n);
            this.setUniformVector(this.lightAmbientLoc, this.pgCurrent.lightAmbient, 3, n);
            this.setUniformVector(this.lightDiffuseLoc, this.pgCurrent.lightDiffuse, 3, n);
            this.setUniformVector(this.lightSpecularLoc, this.pgCurrent.lightSpecular, 3, n);
            this.setUniformVector(this.lightFalloffLoc, this.pgCurrent.lightFalloffCoefficients, 3, n);
            this.setUniformVector(this.lightSpotLoc, this.pgCurrent.lightSpotParameters, 2, n);
            this.setCommonUniforms();
        }

        @Override
        public void unbind() {
            if (-1 < this.vertexLoc) {
                this.pgl.disableVertexAttribArray(this.vertexLoc);
            }
            if (-1 < this.colorLoc) {
                this.pgl.disableVertexAttribArray(this.colorLoc);
            }
            if (-1 < this.normalLoc) {
                this.pgl.disableVertexAttribArray(this.normalLoc);
            }
            if (-1 < this.ambientLoc) {
                this.pgl.disableVertexAttribArray(this.ambientLoc);
            }
            if (-1 < this.specularLoc) {
                this.pgl.disableVertexAttribArray(this.specularLoc);
            }
            if (-1 < this.emissiveLoc) {
                this.pgl.disableVertexAttribArray(this.emissiveLoc);
            }
            if (-1 < this.shininessLoc) {
                this.pgl.disableVertexAttribArray(this.shininessLoc);
            }
            super.unbind();
        }
    }

    protected class ColorShader
    extends BaseShader {
        protected int vertexLoc;
        protected int colorLoc;

        public ColorShader(PApplet pApplet) {
            super(pApplet);
        }

        public ColorShader(PApplet pApplet, String string, String string2) {
            super(pApplet, string, string2);
        }

        public ColorShader(PApplet pApplet, URL uRL, URL uRL2) {
            super(pApplet, uRL, uRL2);
        }

        @Override
        public void loadAttributes() {
            this.vertexLoc = this.getAttributeLoc("vertex");
            this.colorLoc = this.getAttributeLoc("color");
        }

        @Override
        public void loadUniforms() {
            super.loadUniforms();
        }

        @Override
        public void setVertexAttribute(int n, int n2, int n3, int n4, int n5) {
            this.setAttributeVBO(this.vertexLoc, n, n2, n3, false, n4, n5);
        }

        @Override
        public void setColorAttribute(int n, int n2, int n3, int n4, int n5) {
            this.setAttributeVBO(this.colorLoc, n, n2, n3, true, n4, n5);
        }

        @Override
        public void bind() {
            super.bind();
            if (this.pgCurrent == null) {
                this.setRenderer(pgCurrent);
                this.loadAttributes();
                this.loadUniforms();
            }
            if (-1 < this.vertexLoc) {
                this.pgl.enableVertexAttribArray(this.vertexLoc);
            }
            if (-1 < this.colorLoc) {
                this.pgl.enableVertexAttribArray(this.colorLoc);
            }
            this.setCommonUniforms();
        }

        @Override
        public void unbind() {
            if (-1 < this.vertexLoc) {
                this.pgl.disableVertexAttribArray(this.vertexLoc);
            }
            if (-1 < this.colorLoc) {
                this.pgl.disableVertexAttribArray(this.colorLoc);
            }
            super.unbind();
        }
    }

    protected class BaseShader
    extends PShader {
        protected int transformLoc;
        protected int modelviewLoc;
        protected int projectionLoc;
        protected int bufferLoc;
        protected int viewportLoc;

        public BaseShader(PApplet pApplet) {
            super(pApplet);
        }

        public BaseShader(PApplet pApplet, String string, String string2) {
            super(pApplet, string, string2);
        }

        public BaseShader(PApplet pApplet, URL uRL, URL uRL2) {
            super(pApplet, uRL, uRL2);
        }

        @Override
        public void loadUniforms() {
            this.transformLoc = this.getUniformLoc("transform");
            this.modelviewLoc = this.getUniformLoc("modelview");
            this.projectionLoc = this.getUniformLoc("projection");
            this.viewportLoc = this.getUniformLoc("viewport");
            this.bufferLoc = this.getUniformLoc("buffer");
        }

        @Override
        public void unbind() {
            if (-1 < this.bufferLoc) {
                this.pgl.needFBOLayer();
                this.pgl.activeTexture(33984 + this.lastTexUnit);
                this.pgCurrent.unbindBackTexture();
                this.pgl.activeTexture(33984);
            }
            this.pgl.bindBuffer(34962, 0);
            super.unbind();
        }

        protected void setCommonUniforms() {
            if (-1 < this.transformLoc) {
                this.pgCurrent.updateGLProjmodelview();
                this.setUniformMatrix(this.transformLoc, this.pgCurrent.glProjmodelview);
            }
            if (-1 < this.modelviewLoc) {
                this.pgCurrent.updateGLModelview();
                this.setUniformMatrix(this.modelviewLoc, this.pgCurrent.glModelview);
            }
            if (-1 < this.projectionLoc) {
                this.pgCurrent.updateGLProjection();
                this.setUniformMatrix(this.projectionLoc, this.pgCurrent.glProjection);
            }
            if (-1 < this.viewportLoc) {
                float f = this.pgCurrent.viewport.get(0);
                float f2 = this.pgCurrent.viewport.get(1);
                float f3 = this.pgCurrent.viewport.get(2);
                float f4 = this.pgCurrent.viewport.get(3);
                this.setUniformValue(this.viewportLoc, f, f2, f3, f4);
            }
            if (-1 < this.bufferLoc) {
                this.setUniformValue(this.bufferLoc, this.lastTexUnit);
                this.pgl.activeTexture(33984 + this.lastTexUnit);
                this.pgCurrent.bindBackTexture();
            }
        }

        public void setVertexAttribute(int n, int n2, int n3, int n4, int n5) {
        }

        public void setColorAttribute(int n, int n2, int n3, int n4, int n5) {
        }

        public void setNormalAttribute(int n, int n2, int n3, int n4, int n5) {
        }

        public void setAmbientAttribute(int n, int n2, int n3, int n4, int n5) {
        }

        public void setSpecularAttribute(int n, int n2, int n3, int n4, int n5) {
        }

        public void setEmissiveAttribute(int n, int n2, int n3, int n4, int n5) {
        }

        public void setShininessAttribute(int n, int n2, int n3, int n4, int n5) {
        }

        public void setTexcoordAttribute(int n, int n2, int n3, int n4, int n5) {
        }

        public void setTexture(Texture texture) {
        }
    }

    protected class GLResource {
        int id;
        int context;

        GLResource(int n, int n2) {
            this.id = n;
            this.context = n2;
        }

        public boolean equals(Object object) {
            GLResource gLResource = (GLResource)object;
            return gLResource.id == this.id && gLResource.context == this.context;
        }

        public int hashCode() {
            int n = 17;
            n = 31 * n + this.id;
            n = 31 * n + this.context;
            return n;
        }
    }
}

