/*
 * Decompiled with CFR 0.152.
 */
package ketai.ui;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import java.lang.reflect.Method;
import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PVector;
import processing.event.TouchEvent;

public class KetaiGesture
implements GestureDetector.OnGestureListener,
GestureDetector.OnDoubleTapListener {
    PApplet parent;
    GestureDetector gestures;
    KetaiGesture me;
    Method onDoubleTapMethod;
    Method onScrollMethod;
    Method onFlickMethod;
    Method onTapMethod;
    Method onLongPressMethod;
    Method onPinchMethod;
    Method onRotateMethod;
    HashMap<Integer, PVector> cursors = new HashMap();
    HashMap<Integer, PVector> pcursors = new HashMap();

    public KetaiGesture(PApplet _parent) {
        this.parent = _parent;
        this.me = this;
        this.parent.runOnUiThread(new Runnable(){

            public void run() {
                KetaiGesture.this.gestures = new GestureDetector((Context)KetaiGesture.this.parent, (GestureDetector.OnGestureListener)KetaiGesture.this.me);
            }
        });
        this.parent.registerMethod("touchEvent", (Object)this);
        this.findParentIntentions();
    }

    public boolean onDown(MotionEvent arg0) {
        return true;
    }

    public boolean onFling(MotionEvent arg0, MotionEvent arg1, float arg2, float arg3) {
        if (this.onFlickMethod != null) {
            try {
                PVector v = new PVector(arg2, arg3);
                this.onFlickMethod.invoke((Object)this.parent, Float.valueOf(arg1.getX()), Float.valueOf(arg1.getY()), Float.valueOf(arg0.getX()), Float.valueOf(arg0.getY()), Float.valueOf(v.mag()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public void onLongPress(MotionEvent arg0) {
        if (this.onLongPressMethod != null) {
            try {
                this.onLongPressMethod.invoke((Object)this.parent, Float.valueOf(arg0.getX()), Float.valueOf(arg0.getY()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean onScroll(MotionEvent arg0, MotionEvent arg1, float arg2, float arg3) {
        return true;
    }

    public void onShowPress(MotionEvent arg0) {
    }

    public boolean onSingleTapUp(MotionEvent arg0) {
        if (this.onTapMethod != null) {
            try {
                this.onTapMethod.invoke((Object)this.parent, Float.valueOf(arg0.getX()), Float.valueOf(arg0.getY()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public void touchEvent(TouchEvent e) {
        PApplet.println((String)"motionEvent called inside kgesture");
        if (e.getNative() instanceof MotionEvent) {
            PApplet.println((String)"KGesture got a MotionEvent!");
            MotionEvent me = (MotionEvent)e.getNative();
            this.surfaceTouchEvent(me);
        }
    }

    public boolean surfaceTouchEvent(MotionEvent event) {
        int code = event.getAction() & 0xFF;
        int index = event.getAction() >> 8;
        float x = event.getX(index);
        float y = event.getY(index);
        int id = event.getPointerId(index);
        if (code == 0 || code == 5) {
            this.cursors.put(id, new PVector(x, y));
        } else if (code == 1 || code == 6) {
            if (this.cursors.containsKey(id)) {
                this.cursors.remove(id);
            }
            if (this.pcursors.containsKey(id)) {
                this.pcursors.remove(id);
            }
        } else if (code == 2) {
            int numPointers = event.getPointerCount();
            int i = 0;
            while (i < numPointers) {
                id = event.getPointerId(i);
                x = event.getX(i);
                y = event.getY(i);
                if (this.cursors.containsKey(id)) {
                    this.pcursors.put(id, this.cursors.get(id));
                } else {
                    this.pcursors.put(id, new PVector(x, y));
                }
                this.cursors.put(id, new PVector(x, y));
                ++i;
            }
        }
        this.analyse();
        this.parent.onTouchEvent(event);
        return this.gestures.onTouchEvent(event);
    }

    public boolean onSingleTapConfirmed(MotionEvent arg0) {
        return false;
    }

    public boolean onDoubleTap(MotionEvent arg0) {
        if (this.onDoubleTapMethod != null) {
            try {
                this.onDoubleTapMethod.invoke((Object)this.parent, Float.valueOf(arg0.getX()), Float.valueOf(arg0.getY()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private void findParentIntentions() {
        try {
            this.onTapMethod = this.parent.getClass().getMethod("onTap", Float.TYPE, Float.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.onDoubleTapMethod = this.parent.getClass().getMethod("onDoubleTap", Float.TYPE, Float.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.onFlickMethod = this.parent.getClass().getMethod("onFlick", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.onScrollMethod = this.parent.getClass().getMethod("onScroll", Integer.TYPE, Integer.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.onLongPressMethod = this.parent.getClass().getMethod("onLongPress", Float.TYPE, Float.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.onPinchMethod = this.parent.getClass().getMethod("onPinch", Float.TYPE, Float.TYPE, Float.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.onRotateMethod = this.parent.getClass().getMethod("onRotate", Float.TYPE, Float.TYPE, Float.TYPE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void analyse() {
        if (this.cursors.size() > 1 && this.pcursors.size() > 1) {
            PVector c1 = this.cursors.get(0);
            PVector p1 = this.pcursors.get(0);
            PVector c2 = this.cursors.get(1);
            PVector p2 = this.pcursors.get(1);
            if (c1 == null || c2 == null || p1 == null || p2 == null) {
                return;
            }
            float midx = (c1.x + c2.x) / 2.0f;
            float midy = (c1.y + c2.y) / 2.0f;
            float dp = PApplet.dist((float)p1.x, (float)p1.y, (float)p2.x, (float)p2.y);
            float dc = PApplet.dist((float)c1.x, (float)c1.y, (float)c2.x, (float)c2.y);
            float oldangle = PApplet.atan2((float)PVector.sub((PVector)p1, (PVector)p2).y, (float)PVector.sub((PVector)p1, (PVector)p2).x);
            float newangle = PApplet.atan2((float)PVector.sub((PVector)c1, (PVector)c2).y, (float)PVector.sub((PVector)c1, (PVector)c2).x);
            float delta = newangle - oldangle;
            if (this.onPinchMethod != null) {
                try {
                    this.onPinchMethod.invoke((Object)this.parent, Float.valueOf(midx), Float.valueOf(midy), Float.valueOf(dc - dp));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.onRotateMethod != null) {
                try {
                    this.onRotateMethod.invoke((Object)this.parent, Float.valueOf(midx), Float.valueOf(midy), Float.valueOf(delta));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public boolean onDoubleTapEvent(MotionEvent arg0) {
        return false;
    }
}

